#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 hledger-lib
version:              1.33.1
visibility:           public
id:                   hledger-lib-1.33.1-BRnSz40dxZGA6QImjTi5wW
key:                  hledger-lib-1.33.1-BRnSz40dxZGA6QImjTi5wW
license:              GPL-3.0-only
maintainer:           Simon Michael <simon@joyful.com>
author:               Simon Michael <simon@joyful.com>
stability:            stable
homepage:             http://hledger.org
synopsis:             A library providing the core functionality of hledger
description:
    This library contains hledger'\''s core functionality.
    It is used by most hledger* packages so that they support the same
    command line options, file formats, reports, etc.

    hledger is a robust, cross-platform set of tools for tracking money,
    time, or any other commodity, using double-entry accounting and a
    simple, editable file format, with command-line, terminal and web
    interfaces. It is a Haskell rewrite of Ledger, and one of the leading
    implementations of Plain Text Accounting.

    See also:

    - https://hledger.org - hledger'\''s home page

    - https://hledger.org/dev.html - starting point for hledger'\''s developer docs

    - https://hackage.haskell.org/package/hledger-lib/docs/Hledger.html - starting point for hledger'\''s haddock docs

category:             Finance
abi:                  38862ee020dfaa8986c9411c6d32db27
exposed:              True
exposed-modules:
    Hledger Hledger.Data Hledger.Data.Account Hledger.Data.AccountName
    Hledger.Data.Amount Hledger.Data.Balancing Hledger.Data.Dates
    Hledger.Data.Errors Hledger.Data.Journal Hledger.Data.JournalChecks
    Hledger.Data.JournalChecks.Ordereddates
    Hledger.Data.JournalChecks.Uniqueleafnames Hledger.Data.Json
    Hledger.Data.Ledger Hledger.Data.Period
    Hledger.Data.PeriodicTransaction Hledger.Data.Posting
    Hledger.Data.RawOptions Hledger.Data.StringFormat
    Hledger.Data.Timeclock Hledger.Data.Transaction
    Hledger.Data.TransactionModifier Hledger.Data.Types
    Hledger.Data.Valuation Hledger.Query Hledger.Read
    Hledger.Read.Common Hledger.Read.CsvReader Hledger.Read.CsvUtils
    Hledger.Read.InputOptions Hledger.Read.JournalReader
    Hledger.Read.RulesReader Hledger.Read.TimeclockReader
    Hledger.Read.TimedotReader Hledger.Reports
    Hledger.Reports.AccountTransactionsReport
    Hledger.Reports.BalanceReport Hledger.Reports.BudgetReport
    Hledger.Reports.EntriesReport Hledger.Reports.MultiBalanceReport
    Hledger.Reports.PostingsReport Hledger.Reports.ReportOptions
    Hledger.Reports.ReportTypes Hledger.Utils Hledger.Utils.Debug
    Hledger.Utils.IO Hledger.Utils.Parse Hledger.Utils.Regex
    Hledger.Utils.String Hledger.Utils.Test Hledger.Utils.Text
    Text.Tabular.AsciiWide

hidden-modules:
    Text.Megaparsec.Custom Text.WideString Paths_hledger_lib

import-dirs:          /usr/lib/ghc-9.4.8/site-local/hledger-lib-1.33.1
library-dirs:         /usr/lib/ghc-9.4.8/site-local/hledger-lib-1.33.1
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/hledger-lib-1.33.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-hledger-lib
hs-libraries:         HShledger-lib-1.33.1-BRnSz40dxZGA6QImjTi5wW
depends:
    Decimal-0.5.2-6swmwvqkmPSCVjz5gNR31f
    Glob-0.10.2-9zxjwb1hwii1DakiSTO7pb
    aeson-2.1.2.1-5gViDrHjeNhDfT19MwgeMT
    aeson-pretty-0.8.10-B9vRt54sIQsFdBteW4H6Dw
    ansi-terminal-1.0.2-7iJd05aKggE3LiIfKfS0OR array-0.5.4.0
    base-4.17.2.1 base-compat-0.12.3-H9qTMlLoDHsHlMi1O3x7Rp
    blaze-markup-0.8.3.0-4zzXpVLD4d23Y4oP0TA1oB bytestring-0.11.5.3
    call-stack-0.4.0-GRuL9lRThh8EyvG9NSK1NH
    cassava-0.5.4.0-JmNPudAGQyv6xlcO8HvPia
    cassava-megaparsec-2.1.1-KY65lODHIJYDLPtOEXQ1
    cmdargs-0.10.22-KMcxPO0UszDDPT8hI73uO5
    colour-2.3.6-FL2txQY6akFCZSFpCkIJtF containers-0.6.7
    data-default-0.7.1.2-86VyjkfSCk63mGj7Z05i2D deepseq-1.4.8.0
    directory-1.3.7.1 doclayout-0.4.0.1-9NVs29wr8IJGGdaANR9l5i
    extra-1.7.16-HVhKnqmiqAP7qbJKi6sYXI
    file-embed-0.0.16.0-FS79AECsQN660bIXAMLGHY filepath-1.4.2.2
    hashtables-1.4.0-ghIy9Y9IXB4oawfp4cZnv
    megaparsec-9.6.1-K842mSJotk3GLelhPtnPWL
    microlens-0.4.14.0-71jOCsiFFF8LaovsPy6HDt
    microlens-th-0.4.3.17-GRXwDxs8Aw09PQskuAg669 mtl-2.2.2
    pager-0.1.1.0-EUIcP3NtiyfCrJyWEoVKuM
    parser-combinators-1.3.0-11YwG5dPNej79xqbn9HKav
    pretty-simple-4.1.3.0-GMo4aOMlYWyBPy8Bajnc8o
    regex-tdfa-1.3.2.4-4bEsOyd8ZjUKkdBbrZow28
    safe-0.3.21-5rcOjzCJ9nx5zsTE32vvEc
    tabular-0.2.2.8-GPlaI3PukxDKI4c6j3m1vm
    tasty-1.4.3-7xhPoo3C67X1Ob3MpAycFz
    tasty-hunit-0.10.1-J8H2bfWtge03Zs5EtJgd2O template-haskell-2.19.0.0
    terminal-size-0.3.4-G9QKE0nIH70HWdqrMvHn0A text-2.0.2
    text-ansi-0.3.0.1-JAcQ116L5QB4PVpzybdJt time-1.12.2
    timeit-2.0-GSLifhpRLI5Gr54jWRx5t0 transformers-0.5.6.2
    uglymemo-0.1.0.1-8AX9zjlFnnmIrnTboBgOzO
    unordered-containers-0.2.20-BooESfmG3DbHMU6mBvbzIL
    utf8-string-1.0.2-EQXJBdOxi5qEemJFLwYYhw

haddock-interfaces:   /usr/share/doc/haskell-hledger-lib/html/hledger-lib.haddock
haddock-html:         /usr/share/doc/haskell-hledger-lib/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

