#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 hint
version:              0.9.0.8
visibility:           public
id:                   hint-0.9.0.8-2hQVww7rycpJK8ivQRqKdK
key:                  hint-0.9.0.8-2hQVww7rycpJK8ivQRqKdK
license:              BSD-3-Clause
maintainer:           "Samuel Gélineau" <gelisam@gmail.com>
author:               The Hint Authors
homepage:             https://github.com/haskell-hint/hint
synopsis:             A Haskell interpreter built on top of the GHC API
description:
    This library defines an Interpreter monad. It allows to load Haskell
    modules, browse them, type-check and evaluate strings with Haskell
    expressions and even coerce them into values. The library is thread-safe
    and type-safe (even the coercion of expressions to values).
    It is, essentially, a huge subset of the GHC API wrapped in a simpler
    API.

category:             Language, Compilers/Interpreters
abi:                  3164da6ebee18dc77d976a1a73d73237
exposed:              True
exposed-modules:
    Hint.Internal Language.Haskell.Interpreter
    Language.Haskell.Interpreter.Extension
    Language.Haskell.Interpreter.Unsafe

hidden-modules:
    Hint.GHC Hint.Base Hint.InterpreterT Hint.CompatPlatform
    Hint.Configuration Hint.Extension Hint.Context Hint.Conversions
    Hint.Eval Hint.Parsers Hint.Reflection Hint.Typecheck Hint.Util
    Hint.Annotations Control.Monad.Ghc

import-dirs:          /usr/lib/ghc-9.4.8/site-local/hint-0.9.0.8
library-dirs:         /usr/lib/ghc-9.4.8/site-local/hint-0.9.0.8
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/hint-0.9.0.8
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-hint
hs-libraries:         HShint-0.9.0.8-2hQVww7rycpJK8ivQRqKdK
depends:
    base-4.17.2.1 containers-0.6.7 directory-1.3.7.1 exceptions-0.10.5
    filepath-1.4.2.2 ghc-9.4.8 ghc-boot-9.4.8
    ghc-paths-0.1.0.12-8lmZj1VFo8V7iNy4rcXCyj
    random-1.2.1.3-1QsPqNiQGepFTMKcu0aMcs
    temporary-1.3-7OlUYGsOxiE5dNsZFuxKnV transformers-0.5.6.2
    unix-2.7.3

haddock-interfaces:   /usr/share/doc/haskell-hint/html/hint.haddock
haddock-html:         /usr/share/doc/haskell-hint/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

