#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 hasql
version:              1.5.0.5
visibility:           public
id:                   hasql-1.5.0.5-GrdI0YbqFRVGU6JMQk3dXE
key:                  hasql-1.5.0.5-GrdI0YbqFRVGU6JMQk3dXE
license:              MIT
copyright:            (c) 2014, Nikita Volkov
maintainer:           Nikita Volkov <nikita.y.volkov@mail.ru>
author:               Nikita Volkov <nikita.y.volkov@mail.ru>
homepage:             https://github.com/nikita-volkov/hasql
synopsis:             An efficient PostgreSQL driver with a flexible mapping API
description:
    Root of the \"hasql\" ecosystem.
    For details and tutorials see
    <https://github.com/nikita-volkov/hasql the readme>.

    The API comes free from all kinds of exceptions. All error-reporting is explicit and is presented using the '\''Either'\'' type.

category:             Hasql, Database, PostgreSQL
abi:                  d6bee9735b53d1f6c6bfd3504ad99ff1
exposed:              True
exposed-modules:
    Hasql.Connection Hasql.Decoders Hasql.Encoders Hasql.Session
    Hasql.Statement

hidden-modules:
    Hasql.Private.Prelude Hasql.Private.Errors Hasql.Private.PTI
    Hasql.Private.IO Hasql.Private.Session Hasql.Private.Connection
    Hasql.Private.PreparedStatementRegistry Hasql.Private.Settings
    Hasql.Private.Commands Hasql.Private.Decoders
    Hasql.Private.Decoders.Array Hasql.Private.Decoders.Composite
    Hasql.Private.Decoders.Value Hasql.Private.Decoders.Row
    Hasql.Private.Decoders.Result Hasql.Private.Decoders.Results
    Hasql.Private.Encoders Hasql.Private.Encoders.Array
    Hasql.Private.Encoders.Value Hasql.Private.Encoders.Params

import-dirs:          /usr/lib/ghc-9.4.8/site-local/hasql-1.5.0.5
library-dirs:         /usr/lib/ghc-9.4.8/site-local/hasql-1.5.0.5
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/hasql-1.5.0.5
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-hasql
hs-libraries:         HShasql-1.5.0.5-GrdI0YbqFRVGU6JMQk3dXE
depends:
    attoparsec-0.14.4-H6DCtC2rXm7CWC54FRqEZL base-4.17.2.1
    bytestring-0.11.5.3
    bytestring-strict-builder-0.4.5.8-BjcxqpAB6AGGeA8naMyA4A
    contravariant-1.5.5-p3peIMeiUA4Z37z2EtgYi
    dlist-1.0-E99MqJW5mmB4kr4PCgIESI
    hashable-1.4.6.0-Bdyeh8ev81I2bBqnptAVUL
    hashtables-1.4.2-L72KwBvOgrg4KDG4xPcDEv mtl-2.2.2
    postgresql-binary-0.12.5-97kelWY3OPdBm2tqABk1AB
    postgresql-libpq-0.9.5.0-ISIgXFjP19REFuF01eqmjw
    profunctors-5.6.3-B1puex7pinj8XdCtxpi2Qf text-2.0.2
    text-builder-0.6.7-CbjEqnCvRc65kE5cbIynFC transformers-0.5.6.2
    vector-0.13.2.0-JPy5pohpq8EDknIfFhMz6E

haddock-interfaces:   /usr/share/doc/haskell-hasql/html/hasql.haddock
haddock-html:         /usr/share/doc/haskell-hasql/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

