#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 hasql
version:              1.5.0.5
visibility:           public
id:                   hasql-1.5.0.5-EgmPHGumxp3LBAcSBJaDEe
key:                  hasql-1.5.0.5-EgmPHGumxp3LBAcSBJaDEe
license:              MIT
copyright:            (c) 2014, Nikita Volkov
maintainer:           Nikita Volkov <nikita.y.volkov@mail.ru>
author:               Nikita Volkov <nikita.y.volkov@mail.ru>
homepage:             https://github.com/nikita-volkov/hasql
synopsis:             An efficient PostgreSQL driver with a flexible mapping API
description:
    Root of the \"hasql\" ecosystem.
    For details and tutorials see
    <https://github.com/nikita-volkov/hasql the readme>.

    The API comes free from all kinds of exceptions. All error-reporting is explicit and is presented using the '\''Either'\'' type.

category:             Hasql, Database, PostgreSQL
abi:                  c9526f91777c9a9475e38d4aab3b2171
exposed:              True
exposed-modules:
    Hasql.Connection Hasql.Decoders Hasql.Encoders Hasql.Session
    Hasql.Statement

hidden-modules:
    Hasql.Private.Prelude Hasql.Private.Errors Hasql.Private.PTI
    Hasql.Private.IO Hasql.Private.Session Hasql.Private.Connection
    Hasql.Private.PreparedStatementRegistry Hasql.Private.Settings
    Hasql.Private.Commands Hasql.Private.Decoders
    Hasql.Private.Decoders.Array Hasql.Private.Decoders.Composite
    Hasql.Private.Decoders.Value Hasql.Private.Decoders.Row
    Hasql.Private.Decoders.Result Hasql.Private.Decoders.Results
    Hasql.Private.Encoders Hasql.Private.Encoders.Array
    Hasql.Private.Encoders.Value Hasql.Private.Encoders.Params

import-dirs:          /usr/lib/ghc-9.4.8/site-local/hasql-1.5.0.5
library-dirs:         /usr/lib/ghc-9.4.8/site-local/hasql-1.5.0.5
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/hasql-1.5.0.5
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-hasql
hs-libraries:         HShasql-1.5.0.5-EgmPHGumxp3LBAcSBJaDEe
depends:
    attoparsec-0.14.4-C65PLyhXhiCHiJkC3KuQ9j base-4.17.2.1
    bytestring-0.11.5.3
    bytestring-strict-builder-0.4.5.8-FUCQ5aCIe1v6TR1g4GaawW
    contravariant-1.5.5-p3peIMeiUA4Z37z2EtgYi
    dlist-1.0-E99MqJW5mmB4kr4PCgIESI
    hashable-1.4.5.0-EdCBZmCkEma7WCMhhvMdNf
    hashtables-1.4.1-6YepzaKPvKHCM0XdcqCgAH mtl-2.2.2
    postgresql-binary-0.12.5-9r2eGDon2uLC7LBmqWZO8R
    postgresql-libpq-0.9.5.0-ISIgXFjP19REFuF01eqmjw
    profunctors-5.6.3-JPsyxucHO7GE5uSKcotJO6 text-2.0.2
    text-builder-0.6.7-DstLpH74IPm7wzMMTtjtty transformers-0.5.6.2
    vector-0.13.2.0-BnQJYTBpbJKJ2sldbPuyJj

haddock-interfaces:   /usr/share/doc/haskell-hasql/html/hasql.haddock
haddock-html:         /usr/share/doc/haskell-hasql/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

