#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 hasql
version:              1.5.0.5
visibility:           public
id:                   hasql-1.5.0.5-8TMJkZA7wrLAYn1NiLqXJH
key:                  hasql-1.5.0.5-8TMJkZA7wrLAYn1NiLqXJH
license:              MIT
copyright:            (c) 2014, Nikita Volkov
maintainer:           Nikita Volkov <nikita.y.volkov@mail.ru>
author:               Nikita Volkov <nikita.y.volkov@mail.ru>
homepage:             https://github.com/nikita-volkov/hasql
synopsis:             An efficient PostgreSQL driver with a flexible mapping API
description:
    Root of the \"hasql\" ecosystem.
    For details and tutorials see
    <https://github.com/nikita-volkov/hasql the readme>.

    The API comes free from all kinds of exceptions. All error-reporting is explicit and is presented using the '\''Either'\'' type.

category:             Hasql, Database, PostgreSQL
abi:                  d6649e65ff31804786229abc647f3371
exposed:              True
exposed-modules:
    Hasql.Connection Hasql.Decoders Hasql.Encoders Hasql.Session
    Hasql.Statement

hidden-modules:
    Hasql.Private.Prelude Hasql.Private.Errors Hasql.Private.PTI
    Hasql.Private.IO Hasql.Private.Session Hasql.Private.Connection
    Hasql.Private.PreparedStatementRegistry Hasql.Private.Settings
    Hasql.Private.Commands Hasql.Private.Decoders
    Hasql.Private.Decoders.Array Hasql.Private.Decoders.Composite
    Hasql.Private.Decoders.Value Hasql.Private.Decoders.Row
    Hasql.Private.Decoders.Result Hasql.Private.Decoders.Results
    Hasql.Private.Encoders Hasql.Private.Encoders.Array
    Hasql.Private.Encoders.Value Hasql.Private.Encoders.Params

import-dirs:          /usr/lib/ghc-9.4.8/site-local/hasql-1.5.0.5
library-dirs:         /usr/lib/ghc-9.4.8/site-local/hasql-1.5.0.5
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/hasql-1.5.0.5
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-hasql
hs-libraries:         HShasql-1.5.0.5-8TMJkZA7wrLAYn1NiLqXJH
depends:
    attoparsec-0.14.4-EO1k9N7pvB2HEQuv23MWN base-4.17.2.1
    bytestring-0.11.5.3
    bytestring-strict-builder-0.4.5.8-5E2bAQlPSyC8qXkBCxHhnA
    contravariant-1.5.5-p3peIMeiUA4Z37z2EtgYi
    dlist-1.0-EcHgAYEoFWBKoiPlM8eS0R
    hashable-1.4.4.0-32D8TF68xTpFTCUtV1slOl
    hashtables-1.4.1-JuknuMVf8HS5v1aB0z1akM mtl-2.2.2
    postgresql-binary-0.12.5-8U90ls63aeF1DmPwVS6d07
    postgresql-libpq-0.9.5.0-ISIgXFjP19REFuF01eqmjw
    profunctors-5.6.3-KX2EIyoit6HH68OSd7rf0q text-2.0.2
    text-builder-0.6.7-BpgMDvBGBjo5HF0PecT66w transformers-0.5.6.2
    vector-0.13.2.0-PKWel9ZBueBULxf3GbwPA

haddock-interfaces:   /usr/share/doc/haskell-hasql/html/hasql.haddock
haddock-html:         /usr/share/doc/haskell-hasql/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

