#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 happstack-server
version:              7.9.3
visibility:           public
id:                   happstack-server-7.9.3-IVQ2jUtc8GrDw4NkQ3GDyQ
key:                  happstack-server-7.9.3-IVQ2jUtc8GrDw4NkQ3GDyQ
license:              BSD-3-Clause
maintainer:           Happstack team <happs@googlegroups.com>
author:               Happstack team, HAppS LLC
homepage:             http://happstack.com
synopsis:             Web related tools and services.
description:
    Happstack Server provides an HTTP server and a rich set of functions for routing requests, handling query parameters, generating responses, working with cookies, serving files, and more. For in-depth documentation see the Happstack Crash Course <http://happstack.com/docs/crashcourse/index.html>

category:             Web, Happstack
abi:                  5347ef5eeb0aaed3e836de32559b5c24
exposed:              True
exposed-modules:
    Happstack.Server Happstack.Server.Auth Happstack.Server.Compression
    Happstack.Server.Cookie Happstack.Server.Error
    Happstack.Server.FileServe
    Happstack.Server.FileServe.BuildingBlocks Happstack.Server.I18N
    Happstack.Server.Internal.Compression
    Happstack.Server.Internal.Cookie Happstack.Server.Internal.Handler
    Happstack.Server.Internal.Listen
    Happstack.Server.Internal.LogFormat
    Happstack.Server.Internal.LowLevel
    Happstack.Server.Internal.MessageWrap
    Happstack.Server.Internal.Monads
    Happstack.Server.Internal.Multipart
    Happstack.Server.Internal.RFC822Headers
    Happstack.Server.Internal.Socket
    Happstack.Server.Internal.TimeoutIO
    Happstack.Server.Internal.TimeoutManager
    Happstack.Server.Internal.TimeoutSocket
    Happstack.Server.Internal.Types Happstack.Server.Monads
    Happstack.Server.Response Happstack.Server.Routing
    Happstack.Server.RqData Happstack.Server.SURI
    Happstack.Server.SimpleHTTP Happstack.Server.Types
    Happstack.Server.Validation

hidden-modules:
    Happstack.Server.Internal.Clock Happstack.Server.Internal.LazyLiner
    Happstack.Server.SURI.ParseURI Paths_happstack_server

import-dirs:          /usr/lib/ghc-9.4.8/site-local/happstack-server-7.9.3
library-dirs:         /usr/lib/ghc-9.4.8/site-local/happstack-server-7.9.3
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/happstack-server-7.9.3
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-happstack-server
hs-libraries:         HShappstack-server-7.9.3-IVQ2jUtc8GrDw4NkQ3GDyQ
depends:
    base-4.17.2.1 base64-bytestring-1.2.1.0-E08AvuQpBHn2sZGuvrNhQw
    blaze-html-0.9.2.0-FdgXo84MQ5nJDnaCr5A0hJ bytestring-0.11.5.3
    containers-0.6.7 directory-1.3.7.1 exceptions-0.10.5
    extensible-exceptions-0.1.1.4-AGheGT2ZUDiCzp52FHEfjQ
    filepath-1.4.2.2 hslogger-1.3.2.0-61H0ZZSsiCwJhEeRcSHjWy
    html-1.0.1.2-J6DAJfvF1D3ECsZlmS8hoI
    monad-control-1.0.3.1-Ahk437vbyM3GQsp6r0AVlB mtl-2.2.2
    network-3.1.4.0-GdpHxCm9XS6F665gL00mHk
    network-uri-2.6.4.2-EJq2qAYdDkaFqs6P7Upy96 parsec-3.1.16.1
    process-1.6.18.0 sendfile-0.7.11.6-6LgioQB1hc1ExuVRrRZHoU
    syb-0.7.3-3SVfrNQz4RF9JrEUNzpzyO
    system-filepath-0.4.14.1-7lzYhhkv9VM8SfH054X5LU text-2.0.2
    threads-0.5.1.8-J4DLN8CklLqHHgVoEysJiR time-1.12.2
    transformers-0.5.6.2 transformers-base-0.4.6-AkrUPcRiqh28cnlQiVGnOV
    unix-2.7.3 utf8-string-1.0.2-D0oARDqSiCF3CIA0pPBIDm
    xhtml-3000.2.2.1 zlib-0.7.0.0-7Yfc1skJWQaC11O771G6OU

haddock-interfaces:
    /usr/share/doc/haskell-happstack-server/html/happstack-server.haddock

haddock-html:         /usr/share/doc/haskell-happstack-server/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

