#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 graphviz
version:              2999.20.2.1
visibility:           public
id:                   graphviz-2999.20.2.1-7RD8hEb3vNVLq2iSr6nKxm
key:                  graphviz-2999.20.2.1-7RD8hEb3vNVLq2iSr6nKxm
license:              BSD-3-Clause
copyright:            Matthew Sackman, Ivan Lazar Miljenovic
maintainer:           Daniel Casanueva (coding `at` danielcasanueva.eu)
author:               Matthew Sackman, Ivan Lazar Miljenovic
synopsis:             Bindings to Graphviz for graph visualisation.
description:
    This library provides bindings for the Dot language used by the
    Graphviz (<http://graphviz.org/>) suite of programs for visualising
    graphs, as well as functions to call those programs.

    Main features of the graphviz library include:

    * Almost complete coverage of all Graphviz attributes and syntax.

    * Support for specifying clusters.

    * The ability to use a custom node type.

    * Functions for running a Graphviz layout tool with all specified
    output types.

    * The ability to not only generate but also parse Dot code with two
    options: strict and liberal (in terms of ordering of statements).

    * Functions to convert FGL graphs and other graph-like data structures
    to Dot code - including support to group them into clusters - with a
    high degree of customisation by specifying which attributes to use
    and limited support for the inverse operation.

    * Round-trip support for passing an FGL graph through Graphviz to
    augment node and edge labels with positional information, etc.

category:             Graphs, Graphics
abi:                  3080c84138cbac3c7c4d5f9df4fef4bd
exposed:              True
exposed-modules:
    Data.GraphViz Data.GraphViz.Algorithms Data.GraphViz.Attributes
    Data.GraphViz.Attributes.Colors
    Data.GraphViz.Attributes.Colors.Brewer
    Data.GraphViz.Attributes.Colors.SVG
    Data.GraphViz.Attributes.Colors.X11
    Data.GraphViz.Attributes.Complete Data.GraphViz.Attributes.HTML
    Data.GraphViz.Attributes.Internal Data.GraphViz.Commands
    Data.GraphViz.Commands.IO Data.GraphViz.Exception
    Data.GraphViz.Internal.State Data.GraphViz.Internal.Util
    Data.GraphViz.Parsing Data.GraphViz.PreProcessing
    Data.GraphViz.Printing Data.GraphViz.Types
    Data.GraphViz.Types.Canonical Data.GraphViz.Types.Generalised
    Data.GraphViz.Types.Graph Data.GraphViz.Types.Internal.Common
    Data.GraphViz.Types.Monadic

hidden-modules:
    Data.GraphViz.Algorithms.Clustering Data.GraphViz.Attributes.Arrows
    Data.GraphViz.Attributes.ColorScheme Data.GraphViz.Attributes.Same
    Data.GraphViz.Attributes.Values Data.GraphViz.Commands.Available
    Data.GraphViz.Types.State

import-dirs:          /usr/lib/ghc-9.4.8/site-local/graphviz-2999.20.2.1
library-dirs:         /usr/lib/ghc-9.4.8/site-local/graphviz-2999.20.2.1
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/graphviz-2999.20.2.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-graphviz
hs-libraries:         HSgraphviz-2999.20.2.1-7RD8hEb3vNVLq2iSr6nKxm
depends:
    base-4.17.2.1 bytestring-0.11.5.3
    colour-2.3.6-G72z7SH6O4C2fokoLCMx4K containers-0.6.7
    directory-1.3.7.1 dlist-1.0-BKgPi70fx5AJreCYiKxIIN
    fgl-5.8.3.0-4JLUlWN9EXq8MGg2VZrqiW filepath-1.4.2.2 mtl-2.2.2
    polyparse-1.13-LdwKes91BNc9xm9kzNQ4gM process-1.6.18.0
    temporary-1.3-IbENfV52re6K6jELI02KCQ text-2.0.2
    wl-pprint-text-1.2.0.2-2DgtxhY3Z0q191IfktYYNf

haddock-interfaces:   /usr/share/doc/haskell-graphviz/html/graphviz.haddock
haddock-html:         /usr/share/doc/haskell-graphviz/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

