#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 ghc-typelits-extra
version:              0.4.6
visibility:           public
id:                   ghc-typelits-extra-0.4.6-8MYLDA2lzYBLxN8ECx1Glk
key:                  ghc-typelits-extra-0.4.6-8MYLDA2lzYBLxN8ECx1Glk
license:              BSD-2-Clause
copyright:
    Copyright © 2015-2016, University of Twente,
    2017-2018, QBayLogic B.V.

maintainer:           christiaan.baaij@gmail.com
author:               Christiaan Baaij
homepage:             http://www.clash-lang.org/
synopsis:             Additional type-level operations on GHC.TypeLits.Nat
description:
    Additional type-level operations on @GHC.TypeLits.Nat@:

    * @Max@: type-level <http://hackage.haskell.org/package/base-4.8.2.0/docs/Prelude.html#v:max max>

    * @Min@: type-level <http://hackage.haskell.org/package/base-4.8.2.0/docs/Prelude.html#v:min min>

    * @Div@: type-level <http://hackage.haskell.org/package/base-4.8.2.0/docs/Prelude.html#v:div div>

    * @Mod@: type-level <http://hackage.haskell.org/package/base-4.8.2.0/docs/Prelude.html#v:mod mod>

    * @FLog@: type-level equivalent of <https://hackage.haskell.org/package/base-4.17.0.0/docs/GHC-Integer-Logarithms.html#v:integerLogBase-35- integerLogBase#>
    i.e. the exact integer equivalent to @floor (logBase x y)@

    * @CLog@: type-level equivalent of /the ceiling of/ <https://hackage.haskell.org/package/base-4.17.0.0/docs/GHC-Integer-Logarithms.html#v:integerLogBase-35- integerLogBase#>
    i.e. the exact integer equivalent to @ceiling (logBase x y)@

    * @Log@: type-level equivalent of <https://hackage.haskell.org/package/base-4.17.0.0/docs/GHC-Integer-Logarithms.html#v:integerLogBase-35- integerLogBase#>
    where the operation only reduces when @floor (logBase b x) ~ ceiling (logBase b x)@

    * @GCD@: a type-level <http://hackage.haskell.org/package/base-4.8.2.0/docs/Prelude.html#v:gcd gcd>

    * @LCM@: a type-level <http://hackage.haskell.org/package/base-4.8.2.0/docs/Prelude.html#v:lcm lcm>

    And a custom solver for the above operations defined in
    @GHC.TypeLits.Extra.Solver@ as a GHC type-checker plugin. To use the plugin,
    add the

    @
    OPTIONS_GHC -fplugin GHC.TypeLits.Extra.Solver
    @

    pragma to the header of your file.

category:             Type System
abi:                  da5a059ed792c0618c73f704d1b8a13a
exposed:              True
exposed-modules:      GHC.TypeLits.Extra GHC.TypeLits.Extra.Solver
hidden-modules:
    GHC.TypeLits.Extra.Solver.Unify
    GHC.TypeLits.Extra.Solver.Operations

import-dirs:          /usr/lib/ghc-9.4.8/site-local/ghc-typelits-extra-0.4.6
library-dirs:         /usr/lib/ghc-9.4.8/site-local/ghc-typelits-extra-0.4.6
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/ghc-typelits-extra-0.4.6
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-ghc-typelits-extra
hs-libraries:         HSghc-typelits-extra-0.4.6-8MYLDA2lzYBLxN8ECx1Glk
depends:
    base-4.17.2.1 containers-0.6.7 ghc-9.4.8 ghc-bignum-1.3
    ghc-prim-0.9.1 ghc-tcplugins-extra-0.5-EDn2S7kYpSB4bldauH9edX
    ghc-typelits-knownnat-0.7.12-GfwIsdCTUXXKHW6a32bunm
    ghc-typelits-natnormalise-0.7.11-ByXu54VqEot9Ho4wUm1jP7
    transformers-0.5.6.2

haddock-interfaces:
    /usr/share/doc/haskell-ghc-typelits-extra/html/ghc-typelits-extra.haddock

haddock-html:         /usr/share/doc/haskell-ghc-typelits-extra/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

