#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 deriving-compat
version:              0.6.7
visibility:           public
id:                   deriving-compat-0.6.7-3YZT6YSUUxzEquTALnE5MQ
key:                  deriving-compat-0.6.7-3YZT6YSUUxzEquTALnE5MQ
license:              BSD-3-Clause
copyright:            (C) 2015-2017 Ryan Scott
maintainer:           Ryan Scott <ryan.gl.scott@gmail.com>
author:               Ryan Scott
stability:            Experimental
homepage:             https://github.com/haskell-compat/deriving-compat
synopsis:             Backports of GHC deriving extensions
description:
    @deriving-compat@ provides Template Haskell functions that
    mimic @deriving@ extensions that were introduced or modified
    in recent versions of GHC. Currently, the following
    typeclasses/extensions are covered:

    * Deriving @Bounded@

    * Deriving @Enum@

    * Deriving @Ix@

    * Deriving @Eq@

    * Deriving @Ord@

    * Deriving @Read@

    * Deriving @Show@

    * @DeriveFoldable@

    * @DeriveFunctor@

    * @DeriveTraversable@

    * @GeneralizedNewtypeDeriving@ (with GHC 8.2 or later)

    * @DerivingVia@ (with GHC 8.2 or later)

    See the "Data.Deriving" module for a full list of backported changes.

    In addition, @deriving-compat@ also provides some additional
    @deriving@ functionality that has not yet been merged into
    upstream GHC. Aside from the GHC @deriving@ extensions
    mentioned above, @deriving-compat@ also permits deriving
    instances of classes in the @Data.Functor.Classes@ module,
    covering the @Eq1@, @Eq2@, @Ord1@, @Ord2@, @Read1@,
    @Read2@, @Show1@, and @Show2@ classes. This extra
    functionality is outside of the main scope of
    @deriving-compat@, as it does not backport extensions that
    exist in today'\''s GHC. Nevertheless, the underlying Template
    Haskell machinery needed to derive @Eq@ and friends
    extends very naturally to @Eq1@ and friends, so this extra
    functionality is included in @deriving-compat@ as a
    convenience.

    Note that some recent GHC typeclasses/extensions are not covered by this package:

    * @DeriveDataTypeable@

    * @DeriveGeneric@, which was introducted in GHC 7.2 for deriving
    @Generic@ instances, and modified in GHC 7.6 to allow derivation
    of @Generic1@ instances. Use @Generics.Deriving.TH@ from
    @<http://hackage.haskell.org/package/generic-deriving generic-deriving>@
    to derive @Generic(1)@ using Template Haskell.

    * @DeriveLift@, which was introduced in GHC 8.0 for deriving
    @Lift@ instances. Use @Language.Haskell.TH.Lift@ from
    @<http://hackage.haskell.org/package/th-lift th-lift>@
    to derive @Lift@ using Template Haskell.

    * The @Bifunctor@ typeclass, which was introduced in GHC 7.10,
    as well as the @Bifoldable@ and @Bitraversable@ typeclasses, which
    were introduced in GHC 8.2. Use @Data.Bifunctor.TH@ from
    @<http://hackage.haskell.org/package/bifunctors bifunctors>@
    to derive these typeclasses using Template Haskell.

category:             Compatibility
abi:                  b61d3009efc9a26253eaf88f20e8b888
exposed:              True
exposed-modules:
    Data.Bounded.Deriving Data.Bounded.Deriving.Internal Data.Deriving
    Data.Deriving.Internal Data.Deriving.Via Data.Deriving.Via.Internal
    Data.Enum.Deriving Data.Enum.Deriving.Internal Data.Eq.Deriving
    Data.Eq.Deriving.Internal Data.Foldable.Deriving
    Data.Functor.Deriving Data.Functor.Deriving.Internal
    Data.Ix.Deriving Data.Ix.Deriving.Internal Data.Ord.Deriving
    Data.Ord.Deriving.Internal Data.Traversable.Deriving
    Text.Read.Deriving Text.Read.Deriving.Internal Text.Show.Deriving
    Text.Show.Deriving.Internal

import-dirs:          /usr/lib/ghc-9.4.8/site-local/deriving-compat-0.6.7
library-dirs:         /usr/lib/ghc-9.4.8/site-local/deriving-compat-0.6.7
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/deriving-compat-0.6.7
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-deriving-compat
hs-libraries:         HSderiving-compat-0.6.7-3YZT6YSUUxzEquTALnE5MQ
depends:
    base-4.17.2.1 containers-0.6.7 ghc-boot-th-9.4.8 ghc-prim-0.9.1
    template-haskell-2.19.0.0
    th-abstraction-0.5.0.0-BROQwjXmGCt8uLmQUfLqOy transformers-0.5.6.2
    transformers-compat-0.7.2-F1TSDgHxVH372cWL2D3XnQ

haddock-interfaces:
    /usr/share/doc/haskell-deriving-compat/html/deriving-compat.haddock

haddock-html:         /usr/share/doc/haskell-deriving-compat/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

