#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 dbus
version:              1.3.3
visibility:           public
id:                   dbus-1.3.3-9oZX57MILji9wPzPmV4ul
key:                  dbus-1.3.3-9oZX57MILji9wPzPmV4ul
license:              Apache-2.0
maintainer:           Andrey Sverdlichenko <blaze@rusty.zone>
author:               John Millikin <john@john-millikin.com>
stability:            experimental
homepage:             https://github.com/rblaze/haskell-dbus#readme
synopsis:             A client library for the D-Bus IPC system.
description:
    D-Bus is a simple, message-based protocol for inter-process
    communication, which allows applications to interact with other parts of
    the machine and the user'\''s session using remote procedure calls.

    D-Bus is a essential part of the modern Linux desktop, where it replaces
    earlier protocols such as CORBA and DCOP.

    This library is an implementation of the D-Bus protocol in Haskell. It
    can be used to add D-Bus support to Haskell applications, without the
    awkward interfaces common to foreign bindings.

    Example: connect to the session bus, and get a list of active names.

    @
    &#x7b;-\# LANGUAGE OverloadedStrings \#-&#x7d;

    import Data.List (sort)
    import DBus
    import DBus.Client

    main = do
    &#x20;   client <- connectSession
    &#x20;
    &#x20;   -- Request a list of connected clients from the bus
    &#x20;   reply <- call_ client (methodCall \"\/org\/freedesktop\/DBus\" \"org.freedesktop.DBus\" \"ListNames\")
    &#x20;       &#x7b; methodCallDestination = Just \"org.freedesktop.DBus\"
    &#x20;       &#x7d;
    &#x20;
    &#x20;   -- org.freedesktop.DBus.ListNames() returns a single value, which is
    &#x20;   -- a list of names (here represented as [String])
    &#x20;   let Just names = fromVariant (methodReturnBody reply !! 0)
    &#x20;
    &#x20;   -- Print each name on a line, sorted so reserved names are below
    &#x20;   -- temporary names.
    &#x20;   mapM_ putStrLn (sort names)
    @

    >$ ghc --make list-names.hs
    >$ ./list-names
    >:1.0
    >:1.1
    >:1.10
    >:1.106
    >:1.109
    >:1.110
    >ca.desrt.dconf
    >org.freedesktop.DBus
    >org.freedesktop.Notifications
    >org.freedesktop.secrets
    >org.gnome.ScreenSaver

category:             Network, Desktop
abi:                  1e0a5d4049c0dd3ebc609849252418b6
exposed:              True
exposed-modules:
    DBus DBus.Client DBus.Generation DBus.Internal.Address
    DBus.Internal.Message DBus.Internal.Types DBus.Internal.Wire
    DBus.Introspection DBus.Introspection.Parse
    DBus.Introspection.Render DBus.Introspection.Types DBus.Socket
    DBus.TH DBus.Transport

import-dirs:          /usr/lib/ghc-9.4.8/site-local/dbus-1.3.3
library-dirs:         /usr/lib/ghc-9.4.8/site-local/dbus-1.3.3
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/dbus-1.3.3
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-dbus
hs-libraries:         HSdbus-1.3.3-9oZX57MILji9wPzPmV4ul
depends:
    base-4.17.2.1 bytestring-0.11.5.3
    cereal-0.5.8.3-H9MXf6i1TMkEAfnsx4oYbT
    conduit-1.3.6.1-H4k4i0iLyOvIn1EDVVZRrE containers-0.6.7
    deepseq-1.4.8.0 exceptions-0.10.5 filepath-1.4.2.2
    lens-5.3.1-Hr3CNVd7aJGEq0oCRlwS0q
    network-3.1.4.0-7upd0S3IeIT8lWw9Gu9EjE parsec-3.1.16.1
    random-1.2.1.3-2ZgWYD0ujk9C5rWAN16PoW
    split-0.2.5-42FGdeEiiUOLLQR1FNYPlK template-haskell-2.19.0.0
    text-2.0.2 th-lift-0.8.6-HRVeiGNnDxNElRy2LmdExl
    transformers-0.5.6.2 unix-2.7.3
    vector-0.13.2.0-PKWel9ZBueBULxf3GbwPA
    xml-conduit-1.9.1.4-IBXeirh4oDHATjrBR6UxZe
    xml-types-0.3.8-IpGyuvvNOu2AH1SOobl25

haddock-interfaces:   /usr/share/doc/haskell-dbus/html/dbus.haddock
haddock-html:         /usr/share/doc/haskell-dbus/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

