#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 cryptonite-conduit
version:              0.2.2
visibility:           public
id:                   cryptonite-conduit-0.2.2-C65c6tE7Av4GJ0pXifsvxu
key:                  cryptonite-conduit-0.2.2-C65c6tE7Av4GJ0pXifsvxu
license:              BSD-3-Clause
copyright:            Vincent Hanquez <vincent@snarc.org>
maintainer:           vincent@snarc.org
author:               Vincent Hanquez <vincent@snarc.org>
stability:            experimental
homepage:             https://github.com/haskell-crypto/cryptonite-conduit
synopsis:             cryptonite conduit
description:
    Conduit bridge for cryptonite

    For now only provide a conduit version for hash and hmac, but
    with contribution, this could provide cipher conduits too,
    and probably other things.

category:             Cryptography, Conduit
abi:                  5c9b1906e740cd18b106e8777221e503
exposed:              True
exposed-modules:
    Crypto.Cipher.ChaChaPoly1305.Conduit Crypto.Hash.Conduit
    Crypto.MAC.HMAC.Conduit Crypto.PubKey.ECIES.Conduit

import-dirs:          /usr/lib/ghc-9.4.8/site-local/cryptonite-conduit-0.2.2
library-dirs:         /usr/lib/ghc-9.4.8/site-local/cryptonite-conduit-0.2.2
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/cryptonite-conduit-0.2.2
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-cryptonite-conduit
hs-libraries:         HScryptonite-conduit-0.2.2-C65c6tE7Av4GJ0pXifsvxu
depends:
    base-4.17.2.1 bytestring-0.11.5.3
    conduit-1.3.6.1-IWWL48tOiUMKLUHQSWumck
    conduit-extra-1.3.8-BYn4ndKCbWC3YxWBUq3JmF
    cryptonite-0.30-jhEEAx8wR9CswYrYmSF54 exceptions-0.10.5
    memory-0.18.0-1oHOZXUPjWrG0kImkORGvt
    resourcet-1.2.6-3PSKFpTI3ZgIKasExv0vYD transformers-0.5.6.2

haddock-interfaces:
    /usr/share/doc/haskell-cryptonite-conduit/html/cryptonite-conduit.haddock

haddock-html:         /usr/share/doc/haskell-cryptonite-conduit/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

