#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 crypto-enigma
version:              0.1.1.6
visibility:           public
id:                   crypto-enigma-0.1.1.6-FBx8maa0GwU7SGqtiISJn5
key:                  crypto-enigma-0.1.1.6-FBx8maa0GwU7SGqtiISJn5
license:              BSD-3-Clause
copyright:            (c) 2014-2019 Roy Levien
maintainer:           royl@aldaron.com
author:               Roy Levien
homepage:             https://github.com/orome/crypto-enigma-hs
synopsis:             An Enigma machine simulator with display. 
description:
    The crypto-enigma package is an Enigma machine simulator
    with rich display and machine state details.

    Currently support is only provided for the machine models in most widespread general use
    during the war years: the I, M3, and M4.

    For basic functionality, including some introspection of machine state
    and the mappings performed, simply

    > > import Crypto.Enigma

    For richer display functionality additionally

    > > import Crypto.Enigma.Display

    (Note that this package assumes support for combining Unicode, without which some output may
    appear garbled.)

category:             Cryptography, Education
abi:                  9f7a1ff4ca5363c411aafc476e0b7f27
exposed:              True
exposed-modules:      Crypto.Enigma Crypto.Enigma.Display
hidden-modules:       Crypto.Enigma.Utils
import-dirs:          /usr/lib/ghc-9.4.8/site-local/crypto-enigma-0.1.1.6
library-dirs:         /usr/lib/ghc-9.4.8/site-local/crypto-enigma-0.1.1.6
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/crypto-enigma-0.1.1.6
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-crypto-enigma
hs-libraries:         HScrypto-enigma-0.1.1.6-FBx8maa0GwU7SGqtiISJn5
depends:
    base-4.17.2.1 containers-0.6.7 split-0.2.5-7gsjo3yHZtCABdHL1urbMk
    text-2.0.2

haddock-interfaces:
    /usr/share/doc/haskell-crypto-enigma/html/crypto-enigma.haddock

haddock-html:         /usr/share/doc/haskell-crypto-enigma/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

