#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 co-log-core
version:              0.3.2.5
visibility:           public
id:                   co-log-core-0.3.2.5-IkxfmnXlHsm8uU10UCtPvd
key:                  co-log-core-0.3.2.5-IkxfmnXlHsm8uU10UCtPvd
license:              MPL-2.0
copyright:            2018-2020 Kowainik, 2021-2025 Co-Log
maintainer:           Co-Log <xrom.xkov@gmail.com>
author:               Dmitrii Kovanikov
stability:            stable
homepage:             https://github.com/co-log/co-log-core
synopsis:             Composable Contravariant Comonadic Logging Library
description:
    This package provides core types and functions to work with the @LogAction@ data type which is both simple and powerful.

    @
    __newtype__ LogAction m msg = LogAction
    \    { unLogAction :: msg -> m ()
    \    }
    @

    The ideas behind this package are described in the following blog post:

    * [co-log: Composable Contravariant Combinatorial Comonadic Configurable Convenient Logging](https://kowainik.github.io/posts/2018-09-25-co-log)

    See the following packages for different implementations based on @co-log-core@:

    * [co-log](http://hackage.haskell.org/package/co-log): taggless final implementations.
    * [co-log-polysemy](http://hackage.haskell.org/package/co-log-polysemy): extensible
    effects implementation based on @polysemy@.

category:             Logging, Contravariant, Comonad
abi:                  ce0050c9a0fe5cb5c5f54ff62d8e9a91
exposed:              True
exposed-modules:
    Colog.Core Colog.Core.Action Colog.Core.Class Colog.Core.IO
    Colog.Core.Severity

import-dirs:          /usr/lib/ghc-9.4.8/site-local/co-log-core-0.3.2.5
library-dirs:         /usr/lib/ghc-9.4.8/site-local/co-log-core-0.3.2.5
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/co-log-core-0.3.2.5
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-co-log-core
hs-libraries:         HSco-log-core-0.3.2.5-IkxfmnXlHsm8uU10UCtPvd
depends:              base-4.17.2.1
haddock-interfaces:   /usr/share/doc/haskell-co-log-core/html/co-log-core.haddock
haddock-html:         /usr/share/doc/haskell-co-log-core/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

