#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 clay
version:              0.16.0
visibility:           public
id:                   clay-0.16.0-F8gbjsxlm7IHxLXbaZIGWo
key:                  clay-0.16.0-F8gbjsxlm7IHxLXbaZIGWo
license:              BSD-3-Clause
maintainer:           Sebastiaan Visser <code@fvisser.nl>
author:               Sebastiaan Visser
homepage:             http://fvisser.nl/clay
synopsis:             CSS preprocessor as embedded Haskell.
description:
    Clay is a CSS preprocessor like LESS and Sass, but implemented as an embedded
    domain specific language (EDSL) in Haskell. This means that all CSS selectors
    and style rules are first class Haskell functions, which makes reuse and
    composability easy.

    The project is described on <http://fvisser.nl/clay>.

    The API documentation can be found in the top level module "Clay".

category:             Web, Graphics
abi:                  6c96e429f0190458311eaffa48463e8e
exposed:              True
exposed-modules:
    Clay Clay.Animation Clay.Attributes Clay.Background Clay.Border
    Clay.Box Clay.Color Clay.Comments Clay.Common Clay.Display
    Clay.Dynamic Clay.Elements Clay.Filter Clay.Flexbox Clay.Font
    Clay.FontFace Clay.Geometry Clay.Gradient Clay.Grid Clay.List
    Clay.Mask Clay.Media Clay.Property Clay.Pseudo Clay.Render
    Clay.Selector Clay.Size Clay.Stylesheet Clay.Text Clay.Time
    Clay.Transform Clay.Transition

import-dirs:          /usr/lib/ghc-9.4.8/site-local/clay-0.16.0
library-dirs:         /usr/lib/ghc-9.4.8/site-local/clay-0.16.0
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/clay-0.16.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-clay
hs-libraries:         HSclay-0.16.0-F8gbjsxlm7IHxLXbaZIGWo
depends:              base-4.17.2.1 mtl-2.2.2 text-2.0.2
haddock-interfaces:   /usr/share/doc/haskell-clay/html/clay.haddock
haddock-html:         /usr/share/doc/haskell-clay/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

