#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 z-haskell-ci-z-haskell-ci-internal
version:              0.16.2
package-name:         haskell-ci
lib-name:             haskell-ci-internal
id:
    haskell-ci-0.16.2-JrKac3rV9dA4L6IL7Ze3vk-haskell-ci-internal

key:
    haskell-ci-0.16.2-JrKac3rV9dA4L6IL7Ze3vk-haskell-ci-internal

license:              GPL-3.0-or-later
maintainer:           hvr@gnu.org
author:               Herbert Valerio Riedel, Oleg Grenrus
homepage:             https://haskell-ci.rtfd.org/
synopsis:             Cabal package script generator for Travis-CI
description:
    Script generator (@haskell-ci@) for
    [GitHub Actions](https://docs.github.com/en/actions) and
    [Travis-CI](https://travis-ci.org/)
    for continuous-integration testing of Haskell Cabal packages.

    Included features (not limited to):

    * Multiple GHC support
    * Dependency caching
    * cabal.project support (see [Nix-style local builds documentation](https://cabal.readthedocs.io/en/latest/nix-local-build-overview.html))
    * Runs tests and builds benchmarks
    * Generates Haddocks
    * GHCJS support
    * building with specific constraints

    === Quick Start Guide

    Add a @tested-with@ line to your @.cabal@ file (e.g. @tested-with: GHC == 8.0.2 || == 8.2.2@) and then run @haskell-ci yourpackage.cabal -o .travis.yml@ to generate the Travis-CI job script.

    See @haskell-ci --help@ for more information.

category:             Development
abi:                  2c0ee52dbc316b0bb9b458dec52204d5
exposed-modules:
    HaskellCI HaskellCI.Auxiliary HaskellCI.Bash
    HaskellCI.Bash.Template HaskellCI.Cabal HaskellCI.Cli
    HaskellCI.Compiler HaskellCI.Config HaskellCI.Config.Components
    HaskellCI.Config.ConstraintSet HaskellCI.Config.CopyFields
    HaskellCI.Config.Docspec HaskellCI.Config.Doctest
    HaskellCI.Config.Dump HaskellCI.Config.Empty HaskellCI.Config.Folds
    HaskellCI.Config.HLint HaskellCI.Config.Installed
    HaskellCI.Config.Jobs HaskellCI.Config.PackageScope
    HaskellCI.Config.Ubuntu HaskellCI.Config.Validity
    HaskellCI.Diagnostics HaskellCI.Error HaskellCI.Ghcup
    HaskellCI.GitConfig HaskellCI.GitHub HaskellCI.GitHub.Yaml
    HaskellCI.HeadHackage HaskellCI.Jobs HaskellCI.List
    HaskellCI.MonadErr HaskellCI.Newtypes HaskellCI.OptionsGrammar
    HaskellCI.OptparseGrammar HaskellCI.Package HaskellCI.ParsecUtils
    HaskellCI.Prelude HaskellCI.Sh HaskellCI.ShVersionRange
    HaskellCI.TestedWith HaskellCI.Tools HaskellCI.Travis
    HaskellCI.Travis.Yaml HaskellCI.VersionInfo HaskellCI.YamlSyntax

import-dirs:          /usr/lib/ghc-9.4.8/site-local/haskell-ci-0.16.2
library-dirs:         /usr/lib/ghc-9.4.8/site-local/haskell-ci-0.16.2
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/haskell-ci-0.16.2
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-ci
hs-libraries:
    HShaskell-ci-0.16.2-JrKac3rV9dA4L6IL7Ze3vk-haskell-ci-internal

depends:
    Cabal-syntax-3.8.1.0 HsYAML-0.2.1.3-Gs6wJysf21a4Ld39Ym5DUQ
    ShellCheck-0.10.0-3n6XAsD17vBYQ4G6hBP2O
    aeson-2.1.2.1-EZ4q40CmD1e6rYIqwxbubT
    attoparsec-0.14.4-K6A3Lnx18lt9B7Ad03ungd base-4.17.2.1
    base-compat-0.12.3-H9qTMlLoDHsHlMi1O3x7Rp
    base16-bytestring-1.0.2.0-KBep11INWPS4gh3hA0irR7 binary-0.8.9.1
    bytestring-0.11.5.3
    cabal-install-parsers-0.6-AgCibBJsaS7Ahlr5zLasKf containers-0.6.7
    cryptohash-sha256-0.11.102.1-16wRg0gM8EaDoVyZpUOCza deepseq-1.4.8.0
    directory-1.3.7.1 exceptions-0.10.5 filepath-1.4.2.2
    generic-lens-lite-0.1.1-fdAG00wdys4njg4MryBwd
    indexed-traversable-0.1.4-9Yra3WDK9eE6oqTuJLwCGF
    indexed-traversable-instances-0.1.2-DQ47HfxwK3q38tNJSi0jXS
    ini-0.4.2-Hvzd15WgyKQ8xB8ZFphF1t
    lattices-2.2.1-Aq4sJQt01xZ7cbATw9gkvc mtl-2.2.2
    network-uri-2.6.4.2-F1pCk9rgbkv7rdfQWWKihk
    optparse-applicative-0.17.1.0-CKO7Hv5HIMoIThZFruc57S
    parsec-3.1.16.1 pretty-1.1.3.6 process-1.6.18.0
    temporary-1.3-KrnV93DB6hBAYgorLtz1qq text-2.0.2
    transformers-0.5.6.2
    unordered-containers-0.2.20-Kq2dPHqifzB9n0MYGmTosg
    zinza-0.2-AT8kkmwNKPDJqEDHKubLRK

haddock-interfaces:   /usr/share/doc/haskell-ci/html/haskell-ci.haddock
haddock-html:         /usr/share/doc/haskell-ci/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

