#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 chimera
version:              0.4.1.0
visibility:           public
id:                   chimera-0.4.1.0-T06QVVcc8uKiqsut5miJM
key:                  chimera-0.4.1.0-T06QVVcc8uKiqsut5miJM
license:              BSD-3-Clause
copyright:            2017-2019 Bodigrim
maintainer:           andrew.lelechenko@gmail.com
author:               Bodigrim
homepage:             https://github.com/Bodigrim/chimera#readme
synopsis:
    Lazy infinite streams with O(1) indexing and applications for memoization

description:
    There are plenty of memoizing libraries on Hackage, but they
    usually fall into two categories:

    * Store cache as a flat array, enabling us
    to obtain cached values in O(1) time, which is nice.
    The drawback is that one must specify the size
    of the array beforehand,
    limiting an interval of inputs,
    and actually allocate it at once.
    * Store cache as a lazy binary tree.
    Thanks to laziness, one can freely use the full range of inputs.
    The drawback is that obtaining values from a tree
    takes logarithmic time and is unfriendly to CPU cache,
    which kinda defeats the purpose.

    This package intends to tackle both issues,
    providing a data type '\''Chimera'\'' for
    lazy infinite compact streams with cache-friendly O(1) indexing.

    Additional features include:

    * memoization of recursive functions and recurrent sequences,
    * memoization of functions of several, possibly signed arguments,
    * efficient memoization of boolean predicates.

category:             Data
abi:                  62644d66d7214a5ca1c27c91b892c65f
exposed:              True
exposed-modules:
    Data.Chimera Data.Chimera.ContinuousMapping
    Data.Chimera.WheelMapping

hidden-modules:
    Data.Chimera.Compat Data.Chimera.FromIntegral Data.Chimera.Internal
    Data.Chimera.Memoize

import-dirs:          /usr/lib/ghc-9.4.8/site-local/chimera-0.4.1.0
library-dirs:         /usr/lib/ghc-9.4.8/site-local/chimera-0.4.1.0
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/chimera-0.4.1.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-chimera
hs-libraries:         HSchimera-0.4.1.0-T06QVVcc8uKiqsut5miJM
depends:
    adjunctions-4.4.3-ClqJsSb2iTor4w6nevqr6 base-4.17.2.1
    distributive-0.6.2.1-CzKu81AHmYTC67d7tpP57v
    infinite-list-0.1.2-dpUih1uibDHyjzyaFThGR mtl-2.2.2
    primitive-0.8.0.0-23sMuMAVhGHKTmE2Kuy9Fz transformers-0.5.6.2
    vector-0.13.2.0-7SxE3dSPVCM2VxyJW4x4GJ

haddock-interfaces:   /usr/share/doc/haskell-chimera/html/chimera.haddock
haddock-html:         /usr/share/doc/haskell-chimera/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

