#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 cborg
version:              0.2.10.0
visibility:           public
id:                   cborg-0.2.10.0-616VPqstnwoLQCUNvfaUe9
key:                  cborg-0.2.10.0-616VPqstnwoLQCUNvfaUe9
license:              BSD-3-Clause
copyright:
    2015-2019 Duncan Coutts,
    2015-2019 Well-Typed LLP,
    2015 IRIS Connect Ltd

maintainer:           duncan@community.haskell.org, ben@smart-cactus.org
author:               Duncan Coutts
synopsis:             Concise Binary Object Representation (CBOR)
description:
    This package provides an efficient implementation of the Concise
    Binary Object Representation (CBOR), as specified by
    [RFC 7049](https://tools.ietf.org/html/rfc7049).

    If you are looking for a library for serialisation of Haskell values,
    have a look at the [serialise](/package/serialise) package, which is
    built upon this library.

    An implementation of the standard bijection between CBOR and JSON is
    provided by the [cborg-json](/package/cborg-json) package. Also see
    [cbor-tool](/package/cbor-tool) for a convenient command-line utility
    for working with CBOR data.

    This package was formerly known as @binary-serialise-cbor@.

category:             Codec
abi:                  f26e577ab6b4deb93109ae52183c95aa
exposed:              True
exposed-modules:
    Codec.CBOR Codec.CBOR.ByteArray Codec.CBOR.ByteArray.Sliced
    Codec.CBOR.Decoding Codec.CBOR.Encoding Codec.CBOR.FlatTerm
    Codec.CBOR.Magic Codec.CBOR.Pretty Codec.CBOR.Read Codec.CBOR.Term
    Codec.CBOR.Write

hidden-modules:       Codec.CBOR.ByteArray.Internal
import-dirs:          /usr/lib/ghc-9.4.8/site-local/cborg-0.2.10.0
library-dirs:         /usr/lib/ghc-9.4.8/site-local/cborg-0.2.10.0
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/cborg-0.2.10.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-cborg
hs-libraries:         HScborg-0.2.10.0-616VPqstnwoLQCUNvfaUe9
depends:
    array-0.5.4.0 base-4.17.2.1 bytestring-0.11.5.3 containers-0.6.7
    deepseq-1.4.8.0 ghc-bignum-1.3 ghc-prim-0.9.1
    half-0.3.3-HIMgn2FeOp2FBhhejn29Jr
    primitive-0.9.1.0-3qHntBOAe4Y4he61Fs3OAc text-2.0.2

haddock-interfaces:   /usr/share/doc/haskell-cborg/html/cborg.haddock
haddock-html:         /usr/share/doc/haskell-cborg/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

