#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 brick
version:              2.2
visibility:           public
id:                   brick-2.2-IOI0OQSlAUeKLljeb5V1YK
key:                  brick-2.2-IOI0OQSlAUeKLljeb5V1YK
license:              BSD-3-Clause
copyright:            (c) Jonathan Daugherty 2015-2023
maintainer:           Jonathan Daugherty <cygnus@foobox.com>
author:               Jonathan Daugherty <cygnus@foobox.com>
homepage:             https://github.com/jtdaugherty/brick/
synopsis:             A declarative terminal user interface library
description:
    Write terminal user interfaces (TUIs) painlessly with '\''brick'\''! You
    write an event handler and a drawing function and the library does the
    rest.


    > module Main where
    >
    > import Brick
    >
    > ui :: Widget ()
    > ui = str "Hello, world!"
    >
    > main :: IO ()
    > main = simpleMain ui


    To get started, see:

    * <https://github.com/jtdaugherty/brick/blob/master/README.md The README>

    * The <https://github.com/jtdaugherty/brick/blob/master/docs/guide.rst Brick user guide>

    * The demonstration programs in the '\''programs'\'' directory


    This package deprecates <http://hackage.haskell.org/package/vty-ui vty-ui>.

category:             Graphics
abi:                  1ff6eb8c3ad8655d71d5cbbd454b07d4
exposed:              True
exposed-modules:
    Brick Brick.AttrMap Brick.BChan Brick.BorderMap Brick.Focus
    Brick.Forms Brick.Keybindings Brick.Keybindings.KeyConfig
    Brick.Keybindings.KeyDispatcher Brick.Keybindings.KeyEvents
    Brick.Keybindings.Parse Brick.Keybindings.Pretty Brick.Main
    Brick.Themes Brick.Types Brick.Util Brick.Widgets.Border
    Brick.Widgets.Border.Style Brick.Widgets.Center Brick.Widgets.Core
    Brick.Widgets.Dialog Brick.Widgets.Edit Brick.Widgets.FileBrowser
    Brick.Widgets.List Brick.Widgets.ProgressBar Brick.Widgets.Table
    Data.IMap

hidden-modules:
    Brick.Types.Common Brick.Types.TH Brick.Types.EventM
    Brick.Types.Internal Brick.Widgets.Internal

import-dirs:          /usr/lib/ghc-9.4.8/site-local/brick-2.2
library-dirs:         /usr/lib/ghc-9.4.8/site-local/brick-2.2
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/brick-2.2
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-brick
hs-libraries:         HSbrick-2.2-IOI0OQSlAUeKLljeb5V1YK
depends:
    base-4.17.2.1 bimap-0.5.0-ECbLcCDzbB4JglTIGzySL8
    bytestring-0.11.5.3 config-ini-0.2.7.0-Fh52coN1FX43DZPvBXnG33
    containers-0.6.7 data-clist-0.2-8tS5IduO2S9Btwa2N8BGTn
    deepseq-1.4.8.0 directory-1.3.7.1 exceptions-0.10.5
    filepath-1.4.2.2 microlens-0.4.14.0-71jOCsiFFF8LaovsPy6HDt
    microlens-mtl-0.2.1.0-LWyutRK1cqlCk2SYzoFhAy
    microlens-th-0.4.3.17-GRXwDxs8Aw09PQskuAg669 mtl-2.2.2 stm-2.5.1.0
    template-haskell-2.19.0.0 text-2.0.2
    text-zipper-0.13-9eVSCZiE1eDEot23E7tUSZ
    unix-compat-0.7.4-L2kjPBf5fIp84KOh8GLDxJ
    vector-0.13.2.0-GTax7SJDHXyLP8P6Lzhygl
    vty-6.2-CIlPg9RkqI82mPtYTRomKU
    vty-crossplatform-0.4.0.0-CNKhcFy58Hq5e8mKWKrDez
    word-wrap-0.5-9afQzJURY0o8zTSRVMUtFq

haddock-interfaces:   /usr/share/doc/haskell-brick/html/brick.haddock
haddock-html:         /usr/share/doc/haskell-brick/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

