#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 binary-tagged
version:              0.3.1
visibility:           public
id:                   binary-tagged-0.3.1-6MlpoWQEVTuHzUplcNL52k
key:                  binary-tagged-0.3.1-6MlpoWQEVTuHzUplcNL52k
license:              BSD-3-Clause
maintainer:           Oleg Grenrus <oleg.grenrus@iki.fi>
author:               Oleg Grenrus <oleg.grenrus@iki.fi>
synopsis:             Tagged binary serialisation.
description:
    Structurally tag binary serialisation stream.

    Say you have:

    Say you have a data type

    @
    data Record = Record
    \  { _recordFields  :: HM.HashMap Text (Integer, ByteString)
    \  , _recordEnabled :: Bool
    \  }
    \  deriving (Eq, Show, Generic)

    instance @Binary@ Record
    instance '\''Structured'\'' Record
    @

    then you can serialise and deserialise @Record@ values with a structure tag by simply

    @
    '\''structuredEncode'\'' record :: LBS.ByteString
    '\''structuredDecode'\'' lbs    :: IO Record
    @

    If structure of @Record@ changes in between, deserialisation will fail early.

    The overhead is next to non-observable.

    @
    benchmarking encode/Binary
    time                 352.8 μs   (349.5 μs .. 355.9 μs)

    benchmarking encode/Tagged
    time                 350.8 μs   (349.0 μs .. 353.1 μs)

    benchmarking decode/Binary
    time                 346.8 μs   (344.7 μs .. 349.9 μs)

    benchmarking decode/Tagged
    time                 353.8 μs   (352.0 μs .. 355.8 μs)
    @

category:             Data
abi:                  559fa90160297307d95c5eae8638d9e1
exposed:              True
exposed-modules:      Data.Binary.Tagged
import-dirs:          /usr/lib/ghc-9.4.8/site-local/binary-tagged-0.3.1
library-dirs:         /usr/lib/ghc-9.4.8/site-local/binary-tagged-0.3.1
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/binary-tagged-0.3.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-binary-tagged
hs-libraries:         HSbinary-tagged-0.3.1-6MlpoWQEVTuHzUplcNL52k
depends:
    array-0.5.4.0 base-4.17.2.1
    base16-bytestring-1.0.2.0-3kwon8iNzO25udiTa31L4P binary-0.8.9.1
    bytestring-0.11.5.3 containers-0.6.7
    structured-0.1.1-EvlbNI9fUvs4woMIfGC4Sn
    tagged-0.8.9-KMS3sfDasKWItFZcxfaN6C

haddock-interfaces:
    /usr/share/doc/haskell-binary-tagged/html/binary-tagged.haddock

haddock-html:         /usr/share/doc/haskell-binary-tagged/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

