#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 bin
version:              0.1.4
visibility:           public
id:                   bin-0.1.4-ly345C3GaqHFuP4DMcq6i
key:                  bin-0.1.4-ly345C3GaqHFuP4DMcq6i
license:              GPL-2.0-or-later
copyright:            (c) 2019-2021 Oleg Grenrus
maintainer:           Oleg.Grenrus <oleg.grenrus@iki.fi>
author:               Oleg Grenrus <oleg.grenrus@iki.fi>
homepage:             https://github.com/phadej/vec
synopsis:             Bin: binary natural numbers.
description:
    This package provides /binary natural numbers/ ("Data.Bin");
    also utilities to work on the type level with @DataKinds@ ("Data.Type.Bin").

    @
    data Bin
    \    = BZ       -- ^ zero
    \    | BP BinP  -- ^ non-zero

    data BinP
    \    = BE       -- ^ one
    \    | B0 BinP  -- ^ double
    \    | B1 BinP  -- ^ double plus 1
    @

    There are /ordinals/ in "Data.Bin.Pos" module, as well as
    fixed width integers in "Data.Wrd".

    Another implementation is at <https://hackage.haskell.org/package/nat>,
    this differs in naming, and provides promoted variant.

category:             Data, Dependent Types, Singletons, Math
abi:                  8705ffdd23dee5bbe772029c21e76979
exposed:              True
exposed-modules:
    Data.Bin Data.Bin.Pos Data.BinP Data.BinP.PosP Data.Type.Bin
    Data.Type.BinP Data.Wrd

hidden-modules:       TrustworthyCompat
import-dirs:          /usr/lib/ghc-9.4.8/site-local/bin-0.1.4
library-dirs:         /usr/lib/ghc-9.4.8/site-local/bin-0.1.4
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/bin-0.1.4
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-bin
hs-libraries:         HSbin-0.1.4-ly345C3GaqHFuP4DMcq6i
depends:
    QuickCheck-2.15.0.1-59GGzHy0g7bISHsBJt3oMz base-4.17.2.1
    boring-0.2.2-HI9VvaC9JR142cnMpyID0P
    dec-0.0.6-C66T8uIzry9Gen6Yxn0qxQ deepseq-1.4.8.0
    fin-0.3.2-AsBd091cOpmI48fwwn5CjT
    hashable-1.4.5.0-EMf4Iv4OllUGRj72K4SCf0
    some-1.0.6-6idsGxAX2M4GvQ9LMNT3hK

haddock-interfaces:   /usr/share/doc/haskell-bin/html/bin.haddock
haddock-html:         /usr/share/doc/haskell-bin/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

