#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 bin
version:              0.1.3
visibility:           public
id:                   bin-0.1.3-LD8dsdxY6VU8vnVQzShO4y
key:                  bin-0.1.3-LD8dsdxY6VU8vnVQzShO4y
license:              GPL-2.0-or-later
copyright:            (c) 2019-2021 Oleg Grenrus
maintainer:           Oleg.Grenrus <oleg.grenrus@iki.fi>
author:               Oleg Grenrus <oleg.grenrus@iki.fi>
homepage:             https://github.com/phadej/vec
synopsis:             Bin: binary natural numbers.
description:
    This package provides /binary natural numbers/ ("Data.Bin");
    also utilities to work on the type level with @DataKinds@ ("Data.Type.Bin").

    @
    data Bin
    \    = BZ       -- ^ zero
    \    | BP BinP  -- ^ non-zero

    data BinP
    \    = BE       -- ^ one
    \    | B0 BinP  -- ^ double
    \    | B1 BinP  -- ^ double plus 1
    @

    There are /ordinals/ in "Data.Bin.Pos" module, as well as
    fixed width integers in "Data.Wrd".

    Another implementation is at <https://hackage.haskell.org/package/nat>,
    this differs in naming, and provides promoted variant.

category:             Data, Dependent Types, Singletons, Math
abi:                  ccfa65205a35f206c0b6743ae3caaf9c
exposed:              True
exposed-modules:
    Data.Bin Data.Bin.Pos Data.BinP Data.BinP.PosP Data.Type.Bin
    Data.Type.BinP Data.Wrd

hidden-modules:       TrustworthyCompat
import-dirs:          /usr/lib/ghc-9.4.8/site-local/bin-0.1.3
library-dirs:         /usr/lib/ghc-9.4.8/site-local/bin-0.1.3
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/bin-0.1.3
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-bin
hs-libraries:         HSbin-0.1.3-LD8dsdxY6VU8vnVQzShO4y
depends:
    QuickCheck-2.14.3-HkhxQP3LI4xGXphdZ0VS0H base-4.17.2.1
    boring-0.2.2-HI9VvaC9JR142cnMpyID0P
    dec-0.0.6-C66T8uIzry9Gen6Yxn0qxQ deepseq-1.4.8.0
    fin-0.3.1-Cw3MyM1wScQ7BFbuInM0YT
    hashable-1.4.4.0-qRezrAQI2A9YjlaZCGaTD
    some-1.0.6-3FlP9zxgrEXJ2BlgOQwb18

haddock-interfaces:   /usr/share/doc/haskell-bin/html/bin.haddock
haddock-html:         /usr/share/doc/haskell-bin/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

