#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 base64-bytestring
version:              1.2.1.0
visibility:           public
id:                   base64-bytestring-1.2.1.0-9TOa4ZiPzZCEZmYgmgxjAh
key:                  base64-bytestring-1.2.1.0-9TOa4ZiPzZCEZmYgmgxjAh
license:              BSD-3-Clause
copyright:            2010-2020 Bryan O'\''Sullivan et al.
maintainer:
    Herbert Valerio Riedel <hvr@gnu.org>,
    Mikhail Glushenkov <mikhail.glushenkov@gmail.com>,
    Emily Pillmore <emilypi@cohomolo.gy>

author:               Bryan O'\''Sullivan <bos@serpentine.com>
homepage:             https://github.com/haskell/base64-bytestring
synopsis:             Fast base64 encoding and decoding for ByteStrings
description:
    This package provides support for encoding and decoding binary data according to @base64@ (see also <https://tools.ietf.org/html/rfc4648 RFC 4648>) for strict and lazy ByteStrings

    For a fuller-featured and better-performing Base64 library, see the <https://hackage.haskell.org/package/base64 base64> package.

category:             Data
abi:                  0bcc3e159f00e5d828e2b745bf732252
exposed:              True
exposed-modules:
    Data.ByteString.Base64 Data.ByteString.Base64.Lazy
    Data.ByteString.Base64.URL Data.ByteString.Base64.URL.Lazy

hidden-modules:       Data.ByteString.Base64.Internal
import-dirs:          /usr/lib/ghc-9.4.8/site-local/base64-bytestring-1.2.1.0
library-dirs:         /usr/lib/ghc-9.4.8/site-local/base64-bytestring-1.2.1.0
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/base64-bytestring-1.2.1.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-base64-bytestring
hs-libraries:         HSbase64-bytestring-1.2.1.0-9TOa4ZiPzZCEZmYgmgxjAh
depends:              base-4.17.2.1 bytestring-0.11.5.3
haddock-interfaces:
    /usr/share/doc/haskell-base64-bytestring/html/base64-bytestring.haddock

haddock-html:         /usr/share/doc/haskell-base64-bytestring/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

