#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 base16-bytestring
version:              1.0.2.0
visibility:           public
id:                   base16-bytestring-1.0.2.0-LR2y57Bi8RU55o0THQ9plt
key:                  base16-bytestring-1.0.2.0-LR2y57Bi8RU55o0THQ9plt
license:              BSD-3-Clause
copyright:
    Copyright 2011 MailRank, Inc.;
    Copyright 2010-2020 Bryan O'\''Sullivan et al.

maintainer:
    Herbert Valerio Riedel <hvr@gnu.org>,
    Mikhail Glushenkov <mikhail.glushenkov@gmail.com>,
    Emily Pillmore <emilypi@cohomolo.gy>

author:               Bryan O'\''Sullivan <bos@serpentine.com>
homepage:             http://github.com/haskell/base16-bytestring
synopsis:             RFC 4648-compliant Base16 encodings for ByteStrings
description:
    This package provides support for encoding and decoding binary data according
    to @base16@ (see also <https://tools.ietf.org/html/rfc4648 RFC 4648>) for
    strict (see "Data.ByteString.Base16") and lazy @ByteString@s (see "Data.ByteString.Base16.Lazy").

    See the <https://hackage.haskell.org/package/base16 base16> package which provides superior encoding and decoding performance as well as support for lazy, short, and strict variants of '\''Text'\'' and '\''ByteString'\'' values. Additionally, see the <https://hackage.haskell.org/package/base-encoding base-encoding> package which
    provides an uniform API providing conversion paths between more binary and textual types.

category:             Data
abi:                  af555392ed4e5bc6c066c653583825e7
exposed:              True
exposed-modules:      Data.ByteString.Base16 Data.ByteString.Base16.Lazy
hidden-modules:       Data.ByteString.Base16.Internal
import-dirs:          /usr/lib/ghc-9.4.8/site-local/base16-bytestring-1.0.2.0
library-dirs:         /usr/lib/ghc-9.4.8/site-local/base16-bytestring-1.0.2.0
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/base16-bytestring-1.0.2.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-base16-bytestring
hs-libraries:         HSbase16-bytestring-1.0.2.0-LR2y57Bi8RU55o0THQ9plt
depends:              base-4.17.2.1 bytestring-0.11.5.3
haddock-interfaces:
    /usr/share/doc/haskell-base16-bytestring/html/base16-bytestring.haddock

haddock-html:         /usr/share/doc/haskell-base16-bytestring/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

