#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 async
version:              2.2.5
visibility:           public
id:                   async-2.2.5-75FFlJsh5XPALDlYx1XYqh
key:                  async-2.2.5-75FFlJsh5XPALDlYx1XYqh
license:              BSD-3-Clause
copyright:            (c) Simon Marlow 2012
maintainer:           Simon Marlow <marlowsd@gmail.com>
author:               Simon Marlow
homepage:             https://github.com/simonmar/async
synopsis:             Run IO operations asynchronously and wait for their results
description:
    This package provides a higher-level interface over
    threads, in which an @Async a@ is a concurrent
    thread that will eventually deliver a value of
    type @a@.  The package provides ways to create
    @Async@ computations, wait for their results, and
    cancel them.

    Using @Async@ is safer than using threads in two
    ways:

    * When waiting for a thread to return a result,
    if the thread dies with an exception then the
    caller must either re-throw the exception
    ('\''wait'\'') or handle it ('\''waitCatch'\''); the
    exception cannot be ignored.

    * The API makes it possible to build a tree of
    threads that are automatically killed when
    their parent dies (see '\''withAsync'\'').

category:             Concurrency
abi:                  6a8086050bd265bc6b3edab4212a57e9
exposed:              True
exposed-modules:
    Control.Concurrent.Async Control.Concurrent.Async.Internal

import-dirs:          /usr/lib/ghc-9.4.8/site-local/async-2.2.5
library-dirs:         /usr/lib/ghc-9.4.8/site-local/async-2.2.5
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/async-2.2.5
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-async
hs-libraries:         HSasync-2.2.5-75FFlJsh5XPALDlYx1XYqh
depends:
    base-4.17.2.1 hashable-1.4.4.0-D3m6G7BPJON5VQ2FLdROoK stm-2.5.1.0

haddock-interfaces:   /usr/share/doc/haskell-async/html/async.haddock
haddock-html:         /usr/share/doc/haskell-async/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

