#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 arithmoi
version:              0.13.1.0
visibility:           public
id:                   arithmoi-0.13.1.0-9bpatKREQ6qHM56jfIGjcX
key:                  arithmoi-0.13.1.0-9bpatKREQ6qHM56jfIGjcX
license:              MIT
copyright:
    (c) 2016-2021 Andrew Lelechenko, 2016-2019 Carter Schonwald, 2011 Daniel Fischer

maintainer:           Andrew Lelechenko <andrew.lelechenko@gmail.com>
author:               Andrew Lelechenko, Daniel Fischer
homepage:             https://github.com/Bodigrim/arithmoi
synopsis:             Efficient basic number-theoretic functions.
description:
    A library of basic functionality needed for
    number-theoretic calculations. The aim of this library
    is to provide efficient implementations of the functions.
    Primes and related things (totients, factorisation),
    powers (integer roots and tests, modular exponentiation).

category:             Math, Algorithms, Number Theory
abi:                  1377c1190d76ef71927b8809685dd21b
exposed:              True
exposed-modules:
    Math.NumberTheory.ArithmeticFunctions
    Math.NumberTheory.ArithmeticFunctions.Inverse
    Math.NumberTheory.ArithmeticFunctions.Mertens
    Math.NumberTheory.ArithmeticFunctions.Moebius
    Math.NumberTheory.ArithmeticFunctions.NFreedom
    Math.NumberTheory.ArithmeticFunctions.SieveBlock
    Math.NumberTheory.Curves.Montgomery Math.NumberTheory.Diophantine
    Math.NumberTheory.DirichletCharacters
    Math.NumberTheory.Euclidean.Coprimes Math.NumberTheory.Moduli
    Math.NumberTheory.Moduli.Cbrt Math.NumberTheory.Moduli.Chinese
    Math.NumberTheory.Moduli.Class Math.NumberTheory.Moduli.Equations
    Math.NumberTheory.Moduli.Multiplicative
    Math.NumberTheory.Moduli.Singleton Math.NumberTheory.Moduli.Sqrt
    Math.NumberTheory.MoebiusInversion Math.NumberTheory.Prefactored
    Math.NumberTheory.Primes Math.NumberTheory.Primes.Counting
    Math.NumberTheory.Primes.IntSet Math.NumberTheory.Primes.Testing
    Math.NumberTheory.Quadratic.EisensteinIntegers
    Math.NumberTheory.Quadratic.GaussianIntegers
    Math.NumberTheory.Recurrences
    Math.NumberTheory.Recurrences.Bilinear
    Math.NumberTheory.Recurrences.Linear
    Math.NumberTheory.SmoothNumbers Math.NumberTheory.Zeta

hidden-modules:
    Math.NumberTheory.ArithmeticFunctions.Class
    Math.NumberTheory.ArithmeticFunctions.Standard
    Math.NumberTheory.Moduli.Internal
    Math.NumberTheory.Moduli.JacobiSymbol
    Math.NumberTheory.Moduli.SomeMod
    Math.NumberTheory.Primes.Counting.Approximate
    Math.NumberTheory.Primes.Counting.Impl
    Math.NumberTheory.Primes.Factorisation.Montgomery
    Math.NumberTheory.Primes.Factorisation.TrialDivision
    Math.NumberTheory.Primes.Sieve.Eratosthenes
    Math.NumberTheory.Primes.Sieve.Indexing
    Math.NumberTheory.Primes.Small
    Math.NumberTheory.Primes.Testing.Certified
    Math.NumberTheory.Primes.Testing.Probabilistic
    Math.NumberTheory.Primes.Types
    Math.NumberTheory.Recurrences.Pentagonal
    Math.NumberTheory.RootsOfUnity Math.NumberTheory.Utils
    Math.NumberTheory.Utils.DirichletSeries
    Math.NumberTheory.Utils.FromIntegral
    Math.NumberTheory.Utils.Hyperbola Math.NumberTheory.Zeta.Dirichlet
    Math.NumberTheory.Zeta.Hurwitz Math.NumberTheory.Zeta.Riemann
    Math.NumberTheory.Zeta.Utils

import-dirs:          /usr/lib/ghc-9.4.8/site-local/arithmoi-0.13.1.0
library-dirs:         /usr/lib/ghc-9.4.8/site-local/arithmoi-0.13.1.0
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/arithmoi-0.13.1.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-arithmoi
hs-libraries:         HSarithmoi-0.13.1.0-9bpatKREQ6qHM56jfIGjcX
depends:
    array-0.5.4.0 base-4.17.2.1 chimera-0.4.1.0-IVezhndnFDfLRaUlEITcX9
    constraints-0.14-ptcKLPcBahCGjnsHD0Bcv containers-0.6.7
    deepseq-1.4.8.0 exact-pi-0.5.0.2-7A7jACRbOm19a4W6VqlDlt
    ghc-bignum-1.3 infinite-list-0.1.2-56oPa8oIGxlBBOkbBEJRDX
    integer-logarithms-1.0.4-Ht1z2ZKBsXTBf3pgeNmcv2
    integer-roots-1.0.3.0-KC5UaDnVVNY5oWiGaEu6l1
    mod-0.2.0.1-JspqdKlGw7s1SAyZ9kPonr
    random-1.2.1.3-G8HhURP50mfDOIe4gICdYG
    semirings-0.7-IOESXRz0ruvE106fTnkisV transformers-0.5.6.2
    vector-0.13.2.0-GjxrA8HCtQq4MGRlxeWifh

haddock-interfaces:   /usr/share/doc/haskell-arithmoi/html/arithmoi.haddock
haddock-html:         /usr/share/doc/haskell-arithmoi/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

