#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 aeson
version:              2.1.2.1
visibility:           public
id:                   aeson-2.1.2.1-JflO2jKMgLf4qHLretO6v3
key:                  aeson-2.1.2.1-JflO2jKMgLf4qHLretO6v3
license:              BSD-3-Clause
copyright:
    (c) 2011-2016 Bryan O'\''Sullivan
    (c) 2011 MailRank, Inc.

maintainer:           Adam Bergmark <adam@bergmark.nl>
author:               Bryan O'\''Sullivan <bos@serpentine.com>
stability:            experimental
homepage:             https://github.com/haskell/aeson
synopsis:             Fast JSON parsing and encoding
description:
    A JSON parsing and encoding library optimized for ease of use
    and high performance.

    To get started, see the documentation for the @Data.Aeson@ module
    below.

    (A note on naming: in Greek mythology, Aeson was the father of Jason.)

category:             Text, Web, JSON
abi:                  f62d9faed45c5ef07ccb926e6e66d106
exposed:              True
exposed-modules:
    Data.Aeson Data.Aeson.Decoding Data.Aeson.Decoding.ByteString
    Data.Aeson.Decoding.ByteString.Lazy Data.Aeson.Decoding.Tokens
    Data.Aeson.Encoding Data.Aeson.Encoding.Internal
    Data.Aeson.Internal Data.Aeson.Internal.Time Data.Aeson.Key
    Data.Aeson.KeyMap Data.Aeson.Parser Data.Aeson.Parser.Internal
    Data.Aeson.QQ.Simple Data.Aeson.TH Data.Aeson.Text Data.Aeson.Types

hidden-modules:
    Data.Aeson.Decoding.Internal Data.Aeson.Encoding.Builder
    Data.Aeson.Internal.ByteString Data.Aeson.Internal.Functions
    Data.Aeson.Internal.Integer Data.Aeson.Internal.Text
    Data.Aeson.Internal.TH Data.Aeson.Internal.Word8
    Data.Aeson.Parser.Time Data.Aeson.Parser.Unescape
    Data.Aeson.Types.Class Data.Aeson.Types.FromJSON
    Data.Aeson.Types.Generic Data.Aeson.Types.Internal
    Data.Aeson.Types.ToJSON Data.Attoparsec.Time
    Data.Attoparsec.Time.Internal Data.Aeson.Parser.UnescapePure

import-dirs:          /usr/lib/ghc-9.4.8/site-local/aeson-2.1.2.1
library-dirs:         /usr/lib/ghc-9.4.8/site-local/aeson-2.1.2.1
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/aeson-2.1.2.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-aeson
hs-libraries:         HSaeson-2.1.2.1-JflO2jKMgLf4qHLretO6v3
depends:
    OneTuple-0.4.2-5DyQFzq8WA51jg2V77K4Uo
    QuickCheck-2.15.0.1-93Z9357UkgtKg8lpP8YyKm
    attoparsec-0.14.4-2LtDsLmLe3yKhxR8c5Iii0 base-4.17.2.1
    base-compat-batteries-0.13.1-KtHlcazEW5gGLxwfn9yrTm
    bytestring-0.11.5.3 containers-0.6.7
    data-fix-0.3.4-HCeTjtMQtNEDmkpJMPqJaI deepseq-1.4.8.0
    dlist-1.0-E99MqJW5mmB4kr4PCgIESI exceptions-0.10.5
    generically-0.1.1-8l2I4yoTrC3HmOIKLnf6DY ghc-prim-0.9.1
    hashable-1.4.4.0-6tleuNdu8X41J3b2E1oOOY
    indexed-traversable-0.1.4-FjrZ8c6UpDNGZqVYWjmd91
    primitive-0.9.1.0-LKIwDdhUWCeBBmo7dhK3va
    scientific-0.3.8.0-8fLTd8S79uT7C3Z3GpM5Vd
    semialign-1.3.1-F8ngwiV1IycCKnwiSVnZBG
    strict-0.5-KCJjzcRdVAH3SLIidke6gS
    tagged-0.8.9-KMS3sfDasKWItFZcxfaN6C template-haskell-2.19.0.0
    text-2.0.2 text-short-0.1.6-87eR6cDNww9GOZXiGn0zTP
    th-abstraction-0.5.0.0-BROQwjXmGCt8uLmQUfLqOy
    these-1.2.1-9Zb46YzLSd02L7Dpd6HAhg time-1.12.2
    time-compat-1.9.7-L3e4UdKa32OIGxcD4RiTDd
    unordered-containers-0.2.20-Eo1ocpXri5ABLOF81VToPu
    uuid-types-1.0.6-7nr0HSCzKm12IQ0RH4Fdnz
    vector-0.13.2.0-ByKMfTK8tTR39fPNQcIOcc
    witherable-0.4.2-BrhfoGA0LlEh6emYSuYLV

haddock-interfaces:   /usr/share/doc/haskell-aeson/html/aeson.haddock
haddock-html:         /usr/share/doc/haskell-aeson/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

