#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 aeson
version:              2.1.2.1
visibility:           public
id:                   aeson-2.1.2.1-4XssoWP8s0tKPHSv4bO4jS
key:                  aeson-2.1.2.1-4XssoWP8s0tKPHSv4bO4jS
license:              BSD-3-Clause
copyright:
    (c) 2011-2016 Bryan O'\''Sullivan
    (c) 2011 MailRank, Inc.

maintainer:           Adam Bergmark <adam@bergmark.nl>
author:               Bryan O'\''Sullivan <bos@serpentine.com>
stability:            experimental
homepage:             https://github.com/haskell/aeson
synopsis:             Fast JSON parsing and encoding
description:
    A JSON parsing and encoding library optimized for ease of use
    and high performance.

    To get started, see the documentation for the @Data.Aeson@ module
    below.

    (A note on naming: in Greek mythology, Aeson was the father of Jason.)

category:             Text, Web, JSON
abi:                  b3058eda5e6f768f8561aab9afd7b646
exposed:              True
exposed-modules:
    Data.Aeson Data.Aeson.Decoding Data.Aeson.Decoding.ByteString
    Data.Aeson.Decoding.ByteString.Lazy Data.Aeson.Decoding.Tokens
    Data.Aeson.Encoding Data.Aeson.Encoding.Internal
    Data.Aeson.Internal Data.Aeson.Internal.Time Data.Aeson.Key
    Data.Aeson.KeyMap Data.Aeson.Parser Data.Aeson.Parser.Internal
    Data.Aeson.QQ.Simple Data.Aeson.TH Data.Aeson.Text Data.Aeson.Types

hidden-modules:
    Data.Aeson.Decoding.Internal Data.Aeson.Encoding.Builder
    Data.Aeson.Internal.ByteString Data.Aeson.Internal.Functions
    Data.Aeson.Internal.Integer Data.Aeson.Internal.Text
    Data.Aeson.Internal.TH Data.Aeson.Internal.Word8
    Data.Aeson.Parser.Time Data.Aeson.Parser.Unescape
    Data.Aeson.Types.Class Data.Aeson.Types.FromJSON
    Data.Aeson.Types.Generic Data.Aeson.Types.Internal
    Data.Aeson.Types.ToJSON Data.Attoparsec.Time
    Data.Attoparsec.Time.Internal Data.Aeson.Parser.UnescapePure

import-dirs:          /usr/lib/ghc-9.4.8/site-local/aeson-2.1.2.1
library-dirs:         /usr/lib/ghc-9.4.8/site-local/aeson-2.1.2.1
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/aeson-2.1.2.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-aeson
hs-libraries:         HSaeson-2.1.2.1-4XssoWP8s0tKPHSv4bO4jS
depends:
    OneTuple-0.4.2-H2hq3WX7vAYH5Mde32s1b7
    QuickCheck-2.14.3-1CLrY0JmQk09KGHT2BGJSb
    attoparsec-0.14.4-BOYjI7Xnyxi2UxSSzbjWOG base-4.17.2.1
    base-compat-batteries-0.12.3-FcRMjNkOutnDUS5mOzCzuW
    bytestring-0.11.5.3 containers-0.6.7
    data-fix-0.3.4-3WH1Nyn4CDY9ptBqgWwtYB deepseq-1.4.8.0
    dlist-1.0-BKgPi70fx5AJreCYiKxIIN exceptions-0.10.5
    generically-0.1.1-Aa3SK6SvqhB4TwtMsjw7wA ghc-prim-0.9.1
    hashable-1.4.4.0-D3m6G7BPJON5VQ2FLdROoK
    indexed-traversable-0.1.4-HSZPVrJnBqe50DNrlM74QR
    primitive-0.9.1.0-CJdTcKbxsQE2upc4cw9myr
    scientific-0.3.8.0-7k94WWHeF91KCJJx1troIA
    semialign-1.3.1-GjC8tsuCOpC9T2vukz9ThV
    strict-0.5-KdAFYmHkX5h7xO3NbvffYQ
    tagged-0.8.9-KMS3sfDasKWItFZcxfaN6C template-haskell-2.19.0.0
    text-2.0.2 text-short-0.1.6-1ZjKhXyMGveJXBVMe8ZtNB
    th-abstraction-0.5.0.0-BROQwjXmGCt8uLmQUfLqOy
    these-1.2.1-1niDck1a12Y2C8gwBjaVV8 time-1.12.2
    time-compat-1.9.6.1-5VTLlrOMVpoDbF7NFxNKia
    unordered-containers-0.2.20-3371VA61Be1CojVrkG24uM
    uuid-types-1.0.6-BTbypSrmBZfD9LP85sqeBq
    vector-0.13.2.0-EWs7nDhBFQF5RfgCWU6KmC
    witherable-0.4.2-HmxQXGSVxLH4e7tzcdvhTa

haddock-interfaces:   /usr/share/doc/haskell-aeson/html/aeson.haddock
haddock-html:         /usr/share/doc/haskell-aeson/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

