#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 aeson
version:              2.1.2.1
visibility:           public
id:                   aeson-2.1.2.1-6LfdTurWC20A9IWYLs821k
key:                  aeson-2.1.2.1-6LfdTurWC20A9IWYLs821k
license:              BSD-3-Clause
copyright:
    (c) 2011-2016 Bryan O'\''Sullivan
    (c) 2011 MailRank, Inc.

maintainer:           Adam Bergmark <adam@bergmark.nl>
author:               Bryan O'\''Sullivan <bos@serpentine.com>
stability:            experimental
homepage:             https://github.com/haskell/aeson
synopsis:             Fast JSON parsing and encoding
description:
    A JSON parsing and encoding library optimized for ease of use
    and high performance.

    To get started, see the documentation for the @Data.Aeson@ module
    below.

    (A note on naming: in Greek mythology, Aeson was the father of Jason.)

category:             Text, Web, JSON
abi:                  f0f69c5980fc3653d073cc1b1bd7e175
exposed:              True
exposed-modules:
    Data.Aeson Data.Aeson.Decoding Data.Aeson.Decoding.ByteString
    Data.Aeson.Decoding.ByteString.Lazy Data.Aeson.Decoding.Tokens
    Data.Aeson.Encoding Data.Aeson.Encoding.Internal
    Data.Aeson.Internal Data.Aeson.Internal.Time Data.Aeson.Key
    Data.Aeson.KeyMap Data.Aeson.Parser Data.Aeson.Parser.Internal
    Data.Aeson.QQ.Simple Data.Aeson.TH Data.Aeson.Text Data.Aeson.Types

hidden-modules:
    Data.Aeson.Decoding.Internal Data.Aeson.Encoding.Builder
    Data.Aeson.Internal.ByteString Data.Aeson.Internal.Functions
    Data.Aeson.Internal.Integer Data.Aeson.Internal.Text
    Data.Aeson.Internal.TH Data.Aeson.Internal.Word8
    Data.Aeson.Parser.Time Data.Aeson.Parser.Unescape
    Data.Aeson.Types.Class Data.Aeson.Types.FromJSON
    Data.Aeson.Types.Generic Data.Aeson.Types.Internal
    Data.Aeson.Types.ToJSON Data.Attoparsec.Time
    Data.Attoparsec.Time.Internal Data.Aeson.Parser.UnescapePure

import-dirs:          /usr/lib/ghc-9.4.8/site-local/aeson-2.1.2.1
library-dirs:         /usr/lib/ghc-9.4.8/site-local/aeson-2.1.2.1
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/aeson-2.1.2.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-aeson
hs-libraries:         HSaeson-2.1.2.1-6LfdTurWC20A9IWYLs821k
depends:
    OneTuple-0.4.2-LloQNzbvlBAAJXWpE1PsO9
    QuickCheck-2.14.3-6LKdi6bmSSC7fWzYy22Dkb
    attoparsec-0.14.4-K4GZo37SQ24KyCrR1RSIsH base-4.17.2.1
    base-compat-batteries-0.12.3-537cASY64IoAeENHONbCpw
    bytestring-0.11.5.3 containers-0.6.7
    data-fix-0.3.4-4gmf3Gb5k9Q33Mbau7zDoG deepseq-1.4.8.0
    dlist-1.0-IJrTDexief3J1GR3vYsW3H exceptions-0.10.5
    generically-0.1.1-4Eeor3tDk8aAPBd5GL9q1J ghc-prim-0.9.1
    hashable-1.4.4.0-9uPnQxUdwOnCZlD9EiHqMs
    indexed-traversable-0.1.4-GRWI01OF8Y0Lwm8Qck38KL
    primitive-0.9.1.0-DCQZIOwgrIsJjCTNFajhDh
    scientific-0.3.8.0-4T67wgFVOmHCrVwu3HwSpM
    semialign-1.3.1-AHDWVzGtmmKah87P3NtcN
    strict-0.5-1Mhl5EAkW91lKnOVnLYmO
    tagged-0.8.9-KMS3sfDasKWItFZcxfaN6C template-haskell-2.19.0.0
    text-2.0.2 text-short-0.1.6-DtEm1uyDHCFKxrESeItn2B
    th-abstraction-0.5.0.0-BROQwjXmGCt8uLmQUfLqOy
    these-1.2.1-FPukFJM03Y3m1oxvoJW4N time-1.12.2
    time-compat-1.9.6.1-5MK3r3NBCMd242g4GYXBwR
    unordered-containers-0.2.20-3iRUctzIz2JCUYhLp7SKku
    uuid-types-1.0.6-9qLtwBCTGuhEZmoNW1PHBJ
    vector-0.13.2.0-GniUvXn58d91eC1W7jmZ0
    witherable-0.4.2-57WIUcDFQOtK6kY8HeY1U8

haddock-interfaces:   /usr/share/doc/haskell-aeson/html/aeson.haddock
haddock-html:         /usr/share/doc/haskell-aeson/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

