#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 aeson
version:              2.1.2.1
visibility:           public
id:                   aeson-2.1.2.1-F9MXb1A8ug6GkYytoGh4jA
key:                  aeson-2.1.2.1-F9MXb1A8ug6GkYytoGh4jA
license:              BSD-3-Clause
copyright:
    (c) 2011-2016 Bryan O'\''Sullivan
    (c) 2011 MailRank, Inc.

maintainer:           Adam Bergmark <adam@bergmark.nl>
author:               Bryan O'\''Sullivan <bos@serpentine.com>
stability:            experimental
homepage:             https://github.com/haskell/aeson
synopsis:             Fast JSON parsing and encoding
description:
    A JSON parsing and encoding library optimized for ease of use
    and high performance.

    To get started, see the documentation for the @Data.Aeson@ module
    below.

    (A note on naming: in Greek mythology, Aeson was the father of Jason.)

category:             Text, Web, JSON
abi:                  4b3bbec455a357831b3f813d56b569aa
exposed:              True
exposed-modules:
    Data.Aeson Data.Aeson.Decoding Data.Aeson.Decoding.ByteString
    Data.Aeson.Decoding.ByteString.Lazy Data.Aeson.Decoding.Tokens
    Data.Aeson.Encoding Data.Aeson.Encoding.Internal
    Data.Aeson.Internal Data.Aeson.Internal.Time Data.Aeson.Key
    Data.Aeson.KeyMap Data.Aeson.Parser Data.Aeson.Parser.Internal
    Data.Aeson.QQ.Simple Data.Aeson.TH Data.Aeson.Text Data.Aeson.Types

hidden-modules:
    Data.Aeson.Decoding.Internal Data.Aeson.Encoding.Builder
    Data.Aeson.Internal.ByteString Data.Aeson.Internal.Functions
    Data.Aeson.Internal.Integer Data.Aeson.Internal.Text
    Data.Aeson.Internal.TH Data.Aeson.Internal.Word8
    Data.Aeson.Parser.Time Data.Aeson.Parser.Unescape
    Data.Aeson.Types.Class Data.Aeson.Types.FromJSON
    Data.Aeson.Types.Generic Data.Aeson.Types.Internal
    Data.Aeson.Types.ToJSON Data.Attoparsec.Time
    Data.Attoparsec.Time.Internal Data.Aeson.Parser.UnescapePure

import-dirs:          /usr/lib/ghc-9.4.8/site-local/aeson-2.1.2.1
library-dirs:         /usr/lib/ghc-9.4.8/site-local/aeson-2.1.2.1
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/aeson-2.1.2.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-aeson
hs-libraries:         HSaeson-2.1.2.1-F9MXb1A8ug6GkYytoGh4jA
depends:
    OneTuple-0.4.2-AlTTwFsWbTb1mMM5SNX6jI
    QuickCheck-2.14.3-EZ7TdgRzq7jKBweVl9M0jh
    attoparsec-0.14.4-Ie40PJLLZWYz4b9BsvrTL base-4.17.2.1
    base-compat-batteries-0.12.3-EvEDhZ4uceV7DYoaaLT9vC
    bytestring-0.11.5.3 containers-0.6.7
    data-fix-0.3.4-Gwr5CMj1VygI6U0r5nAxwF deepseq-1.4.8.0
    dlist-1.0-3IsW2ghxYJNLBlqCManDLX exceptions-0.10.5
    generically-0.1.1-6hJG4Gk5H6c4S81vVDP8CG ghc-prim-0.9.1
    hashable-1.4.4.0-FG1b1gw3lrmKPDYe5KupbE
    indexed-traversable-0.1.4-sHndVhfz3Y5KGJ22wKiRW
    primitive-0.9.1.0-3L6fSIJx0fWJUtVHVLpgAb
    scientific-0.3.7.0-IuEDgnpy5lN4JI5naZeXd4
    semialign-1.3-BUDu2umda4tDhozTpvFdei
    strict-0.5-5h6wkhKraVw8H65c2jvZW8
    tagged-0.8.9-KMS3sfDasKWItFZcxfaN6C template-haskell-2.19.0.0
    text-2.0.2 text-short-0.1.6-71LcX2fy78wGcAWdL5PVyD
    th-abstraction-0.5.0.0-BROQwjXmGCt8uLmQUfLqOy
    these-1.2.1-C7gR1tvmN5rAFU2MBVu3ms time-1.12.2
    time-compat-1.9.6.1-HyjHsVIEQkBBXptjUo6bw0
    unordered-containers-0.2.20-Kb1zmdIZFsX5Z4trT8w0xB
    uuid-types-1.0.6-4937MPpTkBicPu3FlXJr9
    vector-0.13.2.0-3KdUWUHYfVjDmpelwHDbn6
    witherable-0.4.2-DceuH80hBiAApQk3Lyu76h

haddock-interfaces:   /usr/share/doc/haskell-aeson/html/aeson.haddock
haddock-html:         /usr/share/doc/haskell-aeson/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

