#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 aeson
version:              2.1.2.1
visibility:           public
id:                   aeson-2.1.2.1-2ooOAwlErgbHj6Tyvuh2I5
key:                  aeson-2.1.2.1-2ooOAwlErgbHj6Tyvuh2I5
license:              BSD-3-Clause
copyright:
    (c) 2011-2016 Bryan O'\''Sullivan
    (c) 2011 MailRank, Inc.

maintainer:           Adam Bergmark <adam@bergmark.nl>
author:               Bryan O'\''Sullivan <bos@serpentine.com>
stability:            experimental
homepage:             https://github.com/haskell/aeson
synopsis:             Fast JSON parsing and encoding
description:
    A JSON parsing and encoding library optimized for ease of use
    and high performance.

    To get started, see the documentation for the @Data.Aeson@ module
    below.

    (A note on naming: in Greek mythology, Aeson was the father of Jason.)

category:             Text, Web, JSON
abi:                  6518eaae6fa711d45e5f2910b4419234
exposed:              True
exposed-modules:
    Data.Aeson Data.Aeson.Decoding Data.Aeson.Decoding.ByteString
    Data.Aeson.Decoding.ByteString.Lazy Data.Aeson.Decoding.Tokens
    Data.Aeson.Encoding Data.Aeson.Encoding.Internal
    Data.Aeson.Internal Data.Aeson.Internal.Time Data.Aeson.Key
    Data.Aeson.KeyMap Data.Aeson.Parser Data.Aeson.Parser.Internal
    Data.Aeson.QQ.Simple Data.Aeson.TH Data.Aeson.Text Data.Aeson.Types

hidden-modules:
    Data.Aeson.Decoding.Internal Data.Aeson.Encoding.Builder
    Data.Aeson.Internal.ByteString Data.Aeson.Internal.Functions
    Data.Aeson.Internal.Integer Data.Aeson.Internal.Text
    Data.Aeson.Internal.TH Data.Aeson.Internal.Word8
    Data.Aeson.Parser.Time Data.Aeson.Parser.Unescape
    Data.Aeson.Types.Class Data.Aeson.Types.FromJSON
    Data.Aeson.Types.Generic Data.Aeson.Types.Internal
    Data.Aeson.Types.ToJSON Data.Attoparsec.Time
    Data.Attoparsec.Time.Internal Data.Aeson.Parser.UnescapePure

import-dirs:          /usr/lib/ghc-9.4.8/site-local/aeson-2.1.2.1
library-dirs:         /usr/lib/ghc-9.4.8/site-local/aeson-2.1.2.1
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/aeson-2.1.2.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-aeson
hs-libraries:         HSaeson-2.1.2.1-2ooOAwlErgbHj6Tyvuh2I5
depends:
    OneTuple-0.4.2-DwBf62X1oqOJ5vdkL5wCev
    QuickCheck-2.14.3-2QKb6Hom0yuuAm9FvZ6nN
    attoparsec-0.14.4-FDtC6GeLACtJHW3icA3qMM base-4.17.2.1
    base-compat-batteries-0.12.3-4tRj1vBO42KJm7Gkiwotoz
    bytestring-0.11.5.3 containers-0.6.7
    data-fix-0.3.4-MvZ5QYUMH23A2Zjpfkrs9 deepseq-1.4.8.0
    dlist-1.0-3IsW2ghxYJNLBlqCManDLX exceptions-0.10.5
    generically-0.1.1-J9qHdHKciJA6XPTkJZ92Ku ghc-prim-0.9.1
    hashable-1.4.4.0-CTf4tWLvOCwE4B8hp3PoEK
    indexed-traversable-0.1.4-9eY2jWX2flnImgSA45MGyH
    primitive-0.9.1.0-3L6fSIJx0fWJUtVHVLpgAb
    scientific-0.3.7.0-Kb5Gqy0LO2R6GqxRC9SGn9
    semialign-1.3-L5Qe2yM1P2R74BCvx8dF6b
    strict-0.5-GIVbxC0qnBM4FlQvEZkT0w
    tagged-0.8.9-KMS3sfDasKWItFZcxfaN6C template-haskell-2.19.0.0
    text-2.0.2 text-short-0.1.6-JuParaFlytB3yHsA4QF9zw
    th-abstraction-0.5.0.0-BROQwjXmGCt8uLmQUfLqOy
    these-1.2.1-KkupqsXLtAWAbRN3ifpX2j time-1.12.2
    time-compat-1.9.6.1-B8XCiHfsOqHBayPnaUwlQc
    unordered-containers-0.2.20-5aRSzj1YCHv4h2N6lFa6Hx
    uuid-types-1.0.6-7TS0mgNSpe6DCHBsUvRL2z
    vector-0.13.2.0-BWMo7dqC00725tIPRLs4rJ
    witherable-0.4.2-E31cGa1QCjVHmhrKK8LnId

haddock-interfaces:   /usr/share/doc/haskell-aeson/html/aeson.haddock
haddock-html:         /usr/share/doc/haskell-aeson/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

