#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 aeson
version:              2.1.2.1
visibility:           public
id:                   aeson-2.1.2.1-6jLf9XnWqJCFwZgyNgcXK5
key:                  aeson-2.1.2.1-6jLf9XnWqJCFwZgyNgcXK5
license:              BSD-3-Clause
copyright:
    (c) 2011-2016 Bryan O'\''Sullivan
    (c) 2011 MailRank, Inc.

maintainer:           Adam Bergmark <adam@bergmark.nl>
author:               Bryan O'\''Sullivan <bos@serpentine.com>
stability:            experimental
homepage:             https://github.com/haskell/aeson
synopsis:             Fast JSON parsing and encoding
description:
    A JSON parsing and encoding library optimized for ease of use
    and high performance.

    To get started, see the documentation for the @Data.Aeson@ module
    below.

    (A note on naming: in Greek mythology, Aeson was the father of Jason.)

category:             Text, Web, JSON
abi:                  d3747fdbdf43977c92c18c7f5b52ddae
exposed:              True
exposed-modules:
    Data.Aeson Data.Aeson.Decoding Data.Aeson.Decoding.ByteString
    Data.Aeson.Decoding.ByteString.Lazy Data.Aeson.Decoding.Tokens
    Data.Aeson.Encoding Data.Aeson.Encoding.Internal
    Data.Aeson.Internal Data.Aeson.Internal.Time Data.Aeson.Key
    Data.Aeson.KeyMap Data.Aeson.Parser Data.Aeson.Parser.Internal
    Data.Aeson.QQ.Simple Data.Aeson.TH Data.Aeson.Text Data.Aeson.Types

hidden-modules:
    Data.Aeson.Decoding.Internal Data.Aeson.Encoding.Builder
    Data.Aeson.Internal.ByteString Data.Aeson.Internal.Functions
    Data.Aeson.Internal.Integer Data.Aeson.Internal.Text
    Data.Aeson.Internal.TH Data.Aeson.Internal.Word8
    Data.Aeson.Parser.Time Data.Aeson.Parser.Unescape
    Data.Aeson.Types.Class Data.Aeson.Types.FromJSON
    Data.Aeson.Types.Generic Data.Aeson.Types.Internal
    Data.Aeson.Types.ToJSON Data.Attoparsec.Time
    Data.Attoparsec.Time.Internal Data.Aeson.Parser.UnescapePure

import-dirs:          /usr/lib/ghc-9.4.8/site-local/aeson-2.1.2.1
library-dirs:         /usr/lib/ghc-9.4.8/site-local/aeson-2.1.2.1
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/aeson-2.1.2.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-aeson
hs-libraries:         HSaeson-2.1.2.1-6jLf9XnWqJCFwZgyNgcXK5
depends:
    OneTuple-0.4.2-89w5w6pkNHVF6fP6q4V28o
    QuickCheck-2.14.3-3dx0gffu76dAd1sNzKx1gf
    attoparsec-0.14.4-2y9eL1gxaFn1uCSGoZSkZz base-4.17.2.1
    base-compat-batteries-0.12.3-D9mito3gnF7GZLNEKYhs0a
    bytestring-0.11.5.3 containers-0.6.7
    data-fix-0.3.4-DZhirzyW6Q1ND1doZdJKs deepseq-1.4.8.0
    dlist-1.0-3IsW2ghxYJNLBlqCManDLX exceptions-0.10.5
    generically-0.1.1-KbtOdL3XjpuCKdKVAfDdnu ghc-prim-0.9.1
    hashable-1.4.4.0-8IAMfvJ5RiNBptVjfaEAIZ
    indexed-traversable-0.1.4-9YXKO6oMx1B7bSWe0dnRh7
    primitive-0.9.0.0-2SWzXeJZNqNGCC3BQBwQzS
    scientific-0.3.7.0-HO6fZYKmOY5KBpmsmPggyV
    semialign-1.3-AWnenQMAdfUG62X53qxLid
    strict-0.5-9G8ZtoGWOYoHYtZfyJgn9p
    tagged-0.8.9-KMS3sfDasKWItFZcxfaN6C template-haskell-2.19.0.0
    text-2.0.2 text-short-0.1.6-Ft8ifG1PMNdE1wx0FtvU3P
    th-abstraction-0.5.0.0-BROQwjXmGCt8uLmQUfLqOy
    these-1.2.1-KjOi0MoaLzb3eYqHCkList time-1.12.2
    time-compat-1.9.6.1-3yhDQGznr602IphKua0FS5
    unordered-containers-0.2.20-C8J7H3CMcSh2WWoYFsvixL
    uuid-types-1.0.6-J2SBeeLQV9U42M48QfVW5z
    vector-0.13.2.0-DHb3zbtAYMJG5fP738ULIp
    witherable-0.4.2-2EIIHALEBw8EgPoCtm7VQe

haddock-interfaces:   /usr/share/doc/haskell-aeson/html/aeson.haddock
haddock-html:         /usr/share/doc/haskell-aeson/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

