/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component.model;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gradle.api.attributes.Attribute;
import org.gradle.api.internal.attributes.AttributeContainerInternal;
import org.gradle.api.internal.attributes.AttributeDescriber;

public class AttributeDescriberSelector {
    public static AttributeDescriber selectDescriber(AttributeContainerInternal consumerAttributes, List<AttributeDescriber> attributeDescribers) {
        Set consumerAttributeSet = consumerAttributes.keySet();
        AttributeDescriber current = null;
        int maxSize = 0;
        for (AttributeDescriber describer : attributeDescribers) {
            int size = Sets.intersection((Set)describer.getDescribableAttributes(), (Set)consumerAttributeSet).size();
            if (size <= maxSize) continue;
            current = describer;
            maxSize = size;
        }
        if (current != null) {
            return new FallbackDescriber(current);
        }
        return DefaultDescriber.INSTANCE;
    }

    private static class FallbackDescriber
    implements AttributeDescriber {
        private final AttributeDescriber delegate;

        private FallbackDescriber(AttributeDescriber delegate) {
            this.delegate = delegate;
        }

        public ImmutableSet<Attribute<?>> getDescribableAttributes() {
            return this.delegate.getDescribableAttributes();
        }

        public String describeAttributeSet(Map<Attribute<?>, ?> attributes) {
            String description = this.delegate.describeAttributeSet(attributes);
            return description == null ? DefaultDescriber.INSTANCE.describeAttributeSet(attributes) : description;
        }

        public String describeMissingAttribute(Attribute<?> attribute, Object producerValue) {
            String description = this.delegate.describeMissingAttribute(attribute, producerValue);
            return description == null ? DefaultDescriber.INSTANCE.describeMissingAttribute(attribute, producerValue) : description;
        }

        public String describeExtraAttribute(Attribute<?> attribute, Object producerValue) {
            String description = this.delegate.describeExtraAttribute(attribute, producerValue);
            return description == null ? DefaultDescriber.INSTANCE.describeExtraAttribute(attribute, producerValue) : description;
        }
    }

    private static class DefaultDescriber
    implements AttributeDescriber {
        private static final DefaultDescriber INSTANCE = new DefaultDescriber();

        private DefaultDescriber() {
        }

        public ImmutableSet<Attribute<?>> getDescribableAttributes() {
            return ImmutableSet.of();
        }

        public String describeAttributeSet(Map<Attribute<?>, ?> attributes) {
            StringBuilder sb = new StringBuilder();
            attributes.entrySet().stream().sorted(Comparator.comparing(e -> ((Attribute)e.getKey()).getName())).forEach(entry -> {
                Attribute attribute = (Attribute)entry.getKey();
                if (sb.length() > 0) {
                    sb.append(", ");
                }
                sb.append("attribute '").append(attribute.getName()).append("' with value '").append(entry.getValue()).append("'");
            });
            return sb.toString();
        }

        public String describeMissingAttribute(Attribute<?> attribute, Object consumerValue) {
            return attribute.getName() + " (required '" + consumerValue + "')";
        }

        public String describeExtraAttribute(Attribute<?> attribute, Object producerValue) {
            return attribute.getName() + " '" + producerValue + "'";
        }
    }
}

