/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.gui;

import java.awt.Dimension;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import tim.prune.I18nManager;
import tim.prune.gui.WholeNumberField;
import tim.prune.threedee.TerrainDefinition;

public class TerrainDefinitionPanel
extends JPanel {
    private final JCheckBox _useCheckbox;
    private final WholeNumberField _gridSizeField;

    public TerrainDefinitionPanel(int n) {
        this.setLayout(new BoxLayout(this, 0));
        this._useCheckbox = new JCheckBox(I18nManager.getText("dialog.3d.useterrain"));
        this._useCheckbox.addActionListener(actionEvent -> this.activateGridField());
        this.add(this._useCheckbox);
        this.add(Box.createHorizontalGlue());
        JLabel jLabel = new JLabel(String.valueOf(I18nManager.getText("dialog.3d.terraingridsize")) + ": ");
        this.add(jLabel);
        this._gridSizeField = new WholeNumberField(4);
        this._gridSizeField.setValue(n);
        this._gridSizeField.setMaximumSize(new Dimension(100, 50));
        this._gridSizeField.setEnabled(false);
        this.add(this._gridSizeField);
    }

    public void initTerrainParameters(TerrainDefinition terrainDefinition) {
        this._useCheckbox.setSelected(terrainDefinition != null && terrainDefinition.getUseTerrain());
        if (terrainDefinition != null && terrainDefinition.getGridSize() > 0) {
            this._gridSizeField.setValue(terrainDefinition.getGridSize());
        }
        this.activateGridField();
    }

    public boolean getUseTerrain() {
        return this._useCheckbox.isSelected() && this.getGridSize() > 2;
    }

    public int getGridSize() {
        return this._gridSizeField.getValue();
    }

    private void activateGridField() {
        this._gridSizeField.setEnabled(this._useCheckbox.isSelected());
    }
}

