#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 glirc
version:              2.40.1
visibility:           public
id:                   glirc-2.40.1-LUUBTO1Evbl8ZsWV0s4x6R
key:                  glirc-2.40.1-LUUBTO1Evbl8ZsWV0s4x6R
license:              ISC
copyright:            2016-2019 Eric Mertens
maintainer:           emertens@gmail.com
author:               Eric Mertens
homepage:             https://github.com/glguy/irc-core
synopsis:             Console IRC client
description:
    Console IRC client

    glirc is a console IRC client with an emphasis on providing
    dynamic views into the model of your IRC connections.

    <https://github.com/glguy/irc-core/wiki Documentation Wiki>

category:             Network
abi:                  69a299609df9494492ac98ef30a23ca3
exposed:              True
exposed-modules:
    Client.Authentication.Ecdh Client.Authentication.Ecdsa
    Client.Authentication.Scram Client.CApi Client.CApi.Exports
    Client.CApi.Types Client.Commands Client.Commands.Arguments.Parser
    Client.Commands.Arguments.Renderer Client.Commands.Arguments.Spec
    Client.Commands.Certificate Client.Commands.Channel
    Client.Commands.Chat Client.Commands.Connection
    Client.Commands.Docs Client.Commands.Exec
    Client.Commands.Interpolation Client.Commands.Operator
    Client.Commands.Queries Client.Commands.Recognizer
    Client.Commands.TabCompletion Client.Commands.Toggles
    Client.Commands.Types Client.Commands.Window
    Client.Commands.WordCompletion Client.Commands.ZNC
    Client.Configuration Client.Configuration.Colors
    Client.Configuration.Macros Client.Configuration.Notifications
    Client.Configuration.ServerSettings Client.Configuration.Sts
    Client.Docs Client.EventLoop Client.EventLoop.Actions
    Client.EventLoop.Errors Client.EventLoop.Network Client.Hook
    Client.Hook.DroneBLRelay Client.Hook.Matterbridge
    Client.Hook.Snotice Client.Hook.Znc.Buffextras Client.Hooks
    Client.Image Client.Image.Layout Client.Image.LineWrap
    Client.Image.Message Client.Image.MircFormatting
    Client.Image.PackedImage Client.Image.Palette
    Client.Image.StatusLine Client.Image.Textbox Client.Log Client.Mask
    Client.Message Client.Network.Async Client.Network.Connect
    Client.Options Client.State Client.State.Channel
    Client.State.EditBox Client.State.EditBox.Content
    Client.State.Extensions Client.State.Focus Client.State.Network
    Client.State.Url Client.State.Window Client.UserHost Client.View
    Client.View.Cert Client.View.ChannelInfo Client.View.ChannelList
    Client.View.Digraphs Client.View.Help Client.View.IgnoreList
    Client.View.KeyMap Client.View.MaskList Client.View.Mentions
    Client.View.Messages Client.View.Palette Client.View.RtsStats
    Client.View.UrlSelection Client.View.UserList Client.View.Who
    Client.View.Windows Client.WhoReply

hidden-modules:
    ContextFilter DigraphQuote Digraphs LensUtils RtsStats StrQuote
    StrictUnit Paths_glirc Build_glirc

import-dirs:          /usr/lib/ghc-9.4.8/site-local/glirc-2.40.1
library-dirs:         /usr/lib/ghc-9.4.8/site-local/glirc-2.40.1
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/glirc-2.40.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/glirc
hs-libraries:         HSglirc-2.40.1-LUUBTO1Evbl8ZsWV0s4x6R
include-dirs:         /usr/lib/ghc-9.4.8/site-local/glirc-2.40.1/include
includes:             include/glirc-api.h
depends:
    HsOpenSSL-0.11.7.9-ABz2mAiFhzZJZi7dc04UNa
    async-2.2.5-5XB7N1FG9ne5YT8tptoJA4
    attoparsec-0.14.4-FxkaWaI1cCNBlT495krgLy base-4.17.2.1
    base64-bytestring-1.2.1.0-E08AvuQpBHn2sZGuvrNhQw
    bytestring-0.11.5.3 config-schema-1.3.0.0-2tPC6vpFOXn3fB87ZJjp4B
    config-value-0.8.3-AwfdtSmE9Y1aqPSXDWTLH containers-0.6.7
    curve25519-0.2.8.1-LaqX9CSi5uIHT7p2Tg5f1Y directory-1.3.7.1
    filepath-1.4.2.2 free-5.2-4BhqVm0YwcdLhUwvBUyNs8
    githash-0.1.6.3-1hoZ1N54R1YEUQg1FoJP5
    hashable-1.4.6.0-YmGjGgSp1PCYD264OAOUA
    hookup-0.8-L6RL612rWR3DTFA1u1rdVB
    irc-core-2.12-DPdr9uCtNnhJl6Qfk9yQwK
    kan-extensions-5.2.7-UXalNPRItmKetzBMOZDmR
    lens-5.3.2-3x6i1OAeQ2c8gg8RvgTRSW
    network-3.1.4.0-GdpHxCm9XS6F665gL00mHk
    psqueues-0.2.8.2-5irOogwUlRy7VHaK72XUE9
    random-1.2.1.3-AELLTL3R5f5HMsp0oxLypG
    regex-tdfa-1.3.2.4-AhpOdFU5juh7boEnS9Ka1y
    semigroupoids-6.0.1-JI2B6BEq5LTBs96WkqcLuZ
    split-0.2.5-Dujwwofvw7aEFmjRmWhj9Q stm-2.5.1.0
    template-haskell-2.19.0.0 text-2.0.2 time-1.12.2
    transformers-0.5.6.2 typed-process-0.2.13.0-ALaUZKVUP30KwQLF0sGO2h
    unix-2.7.3 unordered-containers-0.2.20-7E9U8fDCyyE7V5F5vC663n
    vector-0.13.2.0-62lZRWkkFegAYWIszJUA7I
    vty-6.2-ByNfCThvtWXDpDjPFASHXa

haddock-interfaces:   /usr/share/doc/glirc/html/glirc.haddock
haddock-html:         /usr/share/doc/glirc/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

