#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 glirc
version:              2.40.1
visibility:           public
id:                   glirc-2.40.1-DdZ854gAVjiDsZptaVvQhS
key:                  glirc-2.40.1-DdZ854gAVjiDsZptaVvQhS
license:              ISC
copyright:            2016-2019 Eric Mertens
maintainer:           emertens@gmail.com
author:               Eric Mertens
homepage:             https://github.com/glguy/irc-core
synopsis:             Console IRC client
description:
    Console IRC client

    glirc is a console IRC client with an emphasis on providing
    dynamic views into the model of your IRC connections.

    <https://github.com/glguy/irc-core/wiki Documentation Wiki>

category:             Network
abi:                  2b41c0356ab63c1a11fa8027706812bf
exposed:              True
exposed-modules:
    Client.Authentication.Ecdh Client.Authentication.Ecdsa
    Client.Authentication.Scram Client.CApi Client.CApi.Exports
    Client.CApi.Types Client.Commands Client.Commands.Arguments.Parser
    Client.Commands.Arguments.Renderer Client.Commands.Arguments.Spec
    Client.Commands.Certificate Client.Commands.Channel
    Client.Commands.Chat Client.Commands.Connection
    Client.Commands.Docs Client.Commands.Exec
    Client.Commands.Interpolation Client.Commands.Operator
    Client.Commands.Queries Client.Commands.Recognizer
    Client.Commands.TabCompletion Client.Commands.Toggles
    Client.Commands.Types Client.Commands.Window
    Client.Commands.WordCompletion Client.Commands.ZNC
    Client.Configuration Client.Configuration.Colors
    Client.Configuration.Macros Client.Configuration.Notifications
    Client.Configuration.ServerSettings Client.Configuration.Sts
    Client.Docs Client.EventLoop Client.EventLoop.Actions
    Client.EventLoop.Errors Client.EventLoop.Network Client.Hook
    Client.Hook.DroneBLRelay Client.Hook.Matterbridge
    Client.Hook.Snotice Client.Hook.Znc.Buffextras Client.Hooks
    Client.Image Client.Image.Layout Client.Image.LineWrap
    Client.Image.Message Client.Image.MircFormatting
    Client.Image.PackedImage Client.Image.Palette
    Client.Image.StatusLine Client.Image.Textbox Client.Log Client.Mask
    Client.Message Client.Network.Async Client.Network.Connect
    Client.Options Client.State Client.State.Channel
    Client.State.EditBox Client.State.EditBox.Content
    Client.State.Extensions Client.State.Focus Client.State.Network
    Client.State.Url Client.State.Window Client.UserHost Client.View
    Client.View.Cert Client.View.ChannelInfo Client.View.ChannelList
    Client.View.Digraphs Client.View.Help Client.View.IgnoreList
    Client.View.KeyMap Client.View.MaskList Client.View.Mentions
    Client.View.Messages Client.View.Palette Client.View.RtsStats
    Client.View.UrlSelection Client.View.UserList Client.View.Who
    Client.View.Windows Client.WhoReply

hidden-modules:
    ContextFilter DigraphQuote Digraphs LensUtils RtsStats StrQuote
    StrictUnit Paths_glirc Build_glirc

import-dirs:          /usr/lib/ghc-9.4.8/site-local/glirc-2.40.1
library-dirs:         /usr/lib/ghc-9.4.8/site-local/glirc-2.40.1
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/glirc-2.40.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/glirc
hs-libraries:         HSglirc-2.40.1-DdZ854gAVjiDsZptaVvQhS
include-dirs:         /usr/lib/ghc-9.4.8/site-local/glirc-2.40.1/include
includes:             include/glirc-api.h
depends:
    HsOpenSSL-0.11.7.9-4EtY31C2W0ZVQ6xRTjnnF
    async-2.2.5-5zadbbqeCp9HahDgxNyESl
    attoparsec-0.14.4-CZt0qAnGZHQHCYZEsndAye base-4.17.2.1
    base64-bytestring-1.2.1.0-1ZLaOmG6271EszdgVZtDyi
    bytestring-0.11.5.3 config-schema-1.3.0.0-63rxg4GSxJ1Lf5bphQe1YB
    config-value-0.8.3-AwfdtSmE9Y1aqPSXDWTLH containers-0.6.7
    curve25519-0.2.8.1-13BdaYJagOg6oPY1xIVlHP directory-1.3.7.1
    filepath-1.4.2.2 free-5.2-AeOLr0OnSlT3UWLxHzF03u
    githash-0.1.6.3-BM4yoEyl18pFBGlp7RlGTS
    hashable-1.4.4.0-GXwYNb6ixbL0AOxKKxOK7
    hookup-0.8-AZO4HRYyebyH7UbHnGM0J4
    irc-core-2.12-9Fh2yBS2I0zADV1flmZsEI
    kan-extensions-5.2.7-BMFmTdTMDzq22FXgnKRHUc
    lens-5.3.1-Jk0s21IZQ9F7Om7ixQU7VU
    network-3.1.4.0-GjkG889aAvvIfieaCEFwUy
    psqueues-0.2.8.2-9dBWlvbowgV9rizuQwd9B2
    random-1.2.1.3-DyhQJBMZMiBKToaxsRw6jM
    regex-tdfa-1.3.2.4-7R3Q4g0HpHyGnQN3kqm2tU
    semigroupoids-6.0.1-6WhHJo1U8WlHQ4cwxv98KH
    split-0.2.5-Dujwwofvw7aEFmjRmWhj9Q stm-2.5.1.0
    template-haskell-2.19.0.0 text-2.0.2 time-1.12.2
    transformers-0.5.6.2 typed-process-0.2.13.0-1vNgAEM6R5l10pbii51D2p
    unix-2.7.3 unordered-containers-0.2.20-psp1ib8v1R5J9F619BTWH
    vector-0.13.2.0-BxFNQQxQb2S1T9ycXEZ0Cs
    vty-6.2-BXvCtScza0FKyZJivjmPu

haddock-interfaces:   /usr/share/doc/glirc/html/glirc.haddock
haddock-html:         /usr/share/doc/glirc/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

