#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 glirc
version:              2.40
visibility:           public
id:                   glirc-2.40-Dx2GkghE0qg4h7HOmm2eME
key:                  glirc-2.40-Dx2GkghE0qg4h7HOmm2eME
license:              ISC
copyright:            2016-2019 Eric Mertens
maintainer:           emertens@gmail.com
author:               Eric Mertens
homepage:             https://github.com/glguy/irc-core
synopsis:             Console IRC client
description:
    Console IRC client

    glirc is a console IRC client with an emphasis on providing
    dynamic views into the model of your IRC connections.

    <https://github.com/glguy/irc-core/wiki Documentation Wiki>

category:             Network
abi:                  fc8f31abe30225917c58876d95789959
exposed:              True
exposed-modules:
    Client.Authentication.Ecdh Client.Authentication.Ecdsa
    Client.Authentication.Scram Client.CApi Client.CApi.Exports
    Client.CApi.Types Client.Commands Client.Commands.Arguments.Parser
    Client.Commands.Arguments.Renderer Client.Commands.Arguments.Spec
    Client.Commands.Certificate Client.Commands.Channel
    Client.Commands.Chat Client.Commands.Connection
    Client.Commands.Exec Client.Commands.Interpolation
    Client.Commands.Operator Client.Commands.Queries
    Client.Commands.Recognizer Client.Commands.TabCompletion
    Client.Commands.Toggles Client.Commands.Types
    Client.Commands.Window Client.Commands.WordCompletion
    Client.Commands.ZNC Client.Configuration
    Client.Configuration.Colors Client.Configuration.Macros
    Client.Configuration.Notifications
    Client.Configuration.ServerSettings Client.Configuration.Sts
    Client.EventLoop Client.EventLoop.Actions Client.EventLoop.Errors
    Client.EventLoop.Network Client.Hook Client.Hook.DroneBLRelay
    Client.Hook.Matterbridge Client.Hook.Snotice
    Client.Hook.Znc.Buffextras Client.Hooks Client.Image
    Client.Image.Layout Client.Image.LineWrap Client.Image.Message
    Client.Image.MircFormatting Client.Image.PackedImage
    Client.Image.Palette Client.Image.StatusLine Client.Image.Textbox
    Client.Log Client.Mask Client.Message Client.Network.Async
    Client.Network.Connect Client.Options Client.State
    Client.State.Channel Client.State.EditBox
    Client.State.EditBox.Content Client.State.Extensions
    Client.State.Focus Client.State.Network Client.State.Url
    Client.State.Window Client.UserHost Client.View Client.View.Cert
    Client.View.ChannelInfo Client.View.ChannelList
    Client.View.Digraphs Client.View.Help Client.View.IgnoreList
    Client.View.KeyMap Client.View.MaskList Client.View.Mentions
    Client.View.Messages Client.View.Palette Client.View.RtsStats
    Client.View.UrlSelection Client.View.UserList Client.View.Who
    Client.View.Windows Client.WhoReply

hidden-modules:
    ContextFilter DigraphQuote Digraphs LensUtils RtsStats StrQuote
    StrictUnit Paths_glirc Build_glirc

import-dirs:          /usr/lib/ghc-9.4.8/site-local/glirc-2.40
library-dirs:         /usr/lib/ghc-9.4.8/site-local/glirc-2.40
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/glirc-2.40
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/glirc
hs-libraries:         HSglirc-2.40-Dx2GkghE0qg4h7HOmm2eME
include-dirs:         /usr/lib/ghc-9.4.8/site-local/glirc-2.40/include
includes:             include/glirc-api.h
depends:
    HsOpenSSL-0.11.7.9-DHY3Ypgo0XRIv6cpgxqbNM
    async-2.2.5-71qvS8UVmexLJ5VLFM0sV7
    attoparsec-0.14.4-2y9eL1gxaFn1uCSGoZSkZz base-4.17.2.1
    base64-bytestring-1.2.1.0-3bi2EtKyNEA1xONdADOQ95
    bytestring-0.11.5.3 config-schema-1.3.0.0-LZ6WKDazkLC40ViQmIC8IE
    config-value-0.8.3-AwfdtSmE9Y1aqPSXDWTLH containers-0.6.7
    curve25519-0.2.8.1-HpbVIitvOvvD4irwK6zTix directory-1.3.7.1
    filepath-1.4.2.2 free-5.2-TrLvtrA0gM2voGgcmOMXy
    githash-0.1.6.3-ErP6XjlqL9k377LptX5hhT
    hashable-1.4.4.0-8IAMfvJ5RiNBptVjfaEAIZ
    hookup-0.8-KAjQxoEXRIoBK7zxp3iv33
    irc-core-2.12-B89CPnPZvzRL3oAAPz6L0c
    kan-extensions-5.2.7-9hI24S4GWcV4533eqKyI58
    lens-5.3-FqQ28IkTmSZ8BNGxtZdro6
    network-3.1.4.0-4jRwWQxmWDJ7j79sTkSj9R
    psqueues-0.2.8.1-ETiMwnMMVGbFlxOlXEDjHQ
    random-1.2.1.3-EDeqrsptr1q9TLFlKboGu1
    regex-tdfa-1.3.2.4-EAD4660LgJC3mTIvpjlw14
    semigroupoids-6.0.1-5rcUCGiBvJxLY6IagigTIE
    split-0.2.5-JeJxVdKJRKMda8iubaxqh stm-2.5.1.0
    template-haskell-2.19.0.0 text-2.0.2 time-1.12.2
    transformers-0.5.6.2 typed-process-0.2.13.0-50sPiK9NEvI3jFXJriiVVy
    unix-2.7.3 unordered-containers-0.2.20-C8J7H3CMcSh2WWoYFsvixL
    vector-0.13.2.0-DHb3zbtAYMJG5fP738ULIp
    vty-6.2-GSriEyxSvI48NiGg1M2bCi

haddock-interfaces:   /usr/share/doc/glirc/html/glirc.haddock
haddock-html:         /usr/share/doc/glirc/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

