#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 gitit
version:              0.15.1.2
visibility:           public
id:                   gitit-0.15.1.2-GjSidbPSgDxDrlYUeIxr0
key:                  gitit-0.15.1.2-GjSidbPSgDxDrlYUeIxr0
license:              LicenseRef-GPL
maintainer:           jgm@berkeley.edu
author:               John MacFarlane
stability:            experimental
synopsis:             Wiki using happstack, git or darcs, and pandoc.
description:
    Gitit is a wiki backed by a git, darcs, or mercurial
    filestore.  Pages and uploaded files can be modified either
    directly via the VCS'\''s command-line tools or through
    the wiki'\''s web interface. Pandoc is used for markup
    processing, so pages may be written in
    (extended) markdown, reStructuredText, LaTeX, HTML,
    or literate Haskell.

    Notable features include

    * plugins: dynamically loaded page
    transformations written in Haskell (see
    "Network.Gitit.Interface")

    * conversion of TeX math to MathML for display in
    web browsers

    * syntax highlighting of source code
    files and code snippets

    * Atom feeds (site-wide and per-page)

    * a library, "Network.Gitit", that makes it simple
    to include a gitit wiki in any happstack application

    For usage information:  @gitit --help@

category:             Network
abi:                  fe85c7b6f8bd2a911025e12ae3201cf0
exposed:              True
exposed-modules:
    Network.Gitit Network.Gitit.Authentication
    Network.Gitit.Authentication.Github Network.Gitit.Cache
    Network.Gitit.Compat.Except Network.Gitit.Config
    Network.Gitit.ContentTransformer Network.Gitit.Feed
    Network.Gitit.Framework Network.Gitit.Handlers
    Network.Gitit.Initialize Network.Gitit.Interface
    Network.Gitit.Layout Network.Gitit.Page Network.Gitit.Plugins
    Network.Gitit.Rpxnow Network.Gitit.Server Network.Gitit.State
    Network.Gitit.Types Network.Gitit.Util Paths_gitit

import-dirs:          /usr/lib/ghc-9.4.8/site-local/gitit-0.15.1.2
library-dirs:         /usr/lib/ghc-9.4.8/site-local/gitit-0.15.1.2
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/gitit-0.15.1.2
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/gitit
hs-libraries:         HSgitit-0.15.1.2-GjSidbPSgDxDrlYUeIxr0
depends:
    HStringTemplate-0.8.8-F5MuPJA1Qqk1fCnuYlqbsm
    HTTP-4000.4.1-GRo9vicF7H85D4W05vEDv7
    SHA-1.6.4.4-8ksu987L0xnDMFbhBLiacl
    aeson-2.1.2.1-LEWFZomfRabp1ORmI1Rne base-4.17.2.1
    base64-bytestring-1.2.1.0-629Bo7Gc9ZF7jdkMFmzdCw
    blaze-html-0.9.2.0-6FdDEpkzFvJ8vV2dWWNvLM bytestring-0.11.5.3
    containers-0.6.7 directory-1.3.7.1
    doctemplates-0.11.0.1-6Hl5KTwVGvy4vL3v5LtVSd
    feed-1.3.2.1-JbnTDMQLl41IkPGr0ZWBNk filepath-1.4.2.2
    filestore-0.6.5.1-2ZqpYDXL1qjIFtlN5yuvQF ghc-9.4.8
    ghc-paths-0.1.0.12-8lmZj1VFo8V7iNy4rcXCyj
    happstack-server-7.9.3-FAOTpcNS3HxLMuGfalD8a6
    hoauth2-2.13.1-BB5RRi5xhXP2PXKr4mM7Iv
    hslogger-1.3.2.0-AjTk1C0pxzs9yKeH9MMN3O
    http-client-tls-0.3.6.4-Fi8IRjkKHwaC5vXzfxQwF1
    http-conduit-2.3.9.1-1ZtBudtkVKQHTNrIHwzYXd
    json-0.10-AsXpHFzrS6DLBI8yHPvGgj mtl-2.2.2
    network-3.1.4.0-IC0hdE8eZqJ6PeeNglfLy3
    network-bsd-2.8.1.0-Dwchj9QAXSX7UKHrUfNcqy
    network-uri-2.6.4.2-KsTvmsDtlUpEkltGNZvqUJ
    old-locale-1.0.0.7-KCPcWVOQKME2P4y4gxzvhh
    old-time-1.1.0.4-7kNg8VzooGoExH4yeT9sv9
    pandoc-3.4-69OuZwdcBcjGqVprIcO1MN
    pandoc-types-1.23.1-3GPCRlYgi7A9JkeDiKYcZT parsec-3.1.16.1
    pretty-1.1.3.6 process-1.6.18.0
    random-1.2.1.3-Lrb8TDGfTan4fST0eiDAa7
    recaptcha-0.1.0.4-46XyvFJuj0kbeKA2xd3J2
    safe-0.3.21-Bbk2Vieba7fJdNA7Fx2QS4
    skylighting-0.14.3-2iGfIG6jngs5kAfaAsMe1q
    split-0.2.5-Dujwwofvw7aEFmjRmWhj9Q syb-0.7.3-CwqNo0h5dXa2Bf4xbRg7w6
    tagsoup-0.14.8-ENqcSVH2wyMLHeJQbujslZ
    temporary-1.3-Jo3GPHqXt7U7op7E9Rmxl4 text-2.0.2 time-1.12.2
    uri-bytestring-0.3.3.1-I1W7CkEbsbyDj8wnpz3yHg
    url-2.1.3-HH0TccKaktc7b8I8qoi3h7
    utf8-string-1.0.2-D0oARDqSiCF3CIA0pPBIDm
    uuid-1.3.16-HfbLE3sXZOyDJAY1vuAieO xhtml-3000.2.2.1
    xml-1.3.14-Lx2FeToC7XoDX0aDGC9dRG
    xml-conduit-1.9.1.4-5LdHi4f2JDjCjovuaqhtHD
    xml-types-0.3.8-IpGyuvvNOu2AH1SOobl25
    xss-sanitize-0.3.7.2-Hc6Y7HfL57v7liNbJrgM6V
    zlib-0.7.0.0-KDAxufZYhOOHDYF4DkDFsG

haddock-interfaces:   /usr/share/doc/gitit/html/gitit.haddock
haddock-html:         /usr/share/doc/gitit/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

