#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 gitit
version:              0.15.1.2
visibility:           public
id:                   gitit-0.15.1.2-1Fh00rlYD3sGo97td5Aeuh
key:                  gitit-0.15.1.2-1Fh00rlYD3sGo97td5Aeuh
license:              LicenseRef-GPL
maintainer:           jgm@berkeley.edu
author:               John MacFarlane
stability:            experimental
synopsis:             Wiki using happstack, git or darcs, and pandoc.
description:
    Gitit is a wiki backed by a git, darcs, or mercurial
    filestore.  Pages and uploaded files can be modified either
    directly via the VCS'\''s command-line tools or through
    the wiki'\''s web interface. Pandoc is used for markup
    processing, so pages may be written in
    (extended) markdown, reStructuredText, LaTeX, HTML,
    or literate Haskell.

    Notable features include

    * plugins: dynamically loaded page
    transformations written in Haskell (see
    "Network.Gitit.Interface")

    * conversion of TeX math to MathML for display in
    web browsers

    * syntax highlighting of source code
    files and code snippets

    * Atom feeds (site-wide and per-page)

    * a library, "Network.Gitit", that makes it simple
    to include a gitit wiki in any happstack application

    For usage information:  @gitit --help@

category:             Network
abi:                  cfe904d0634b6d717c6b87f40082599b
exposed:              True
exposed-modules:
    Network.Gitit Network.Gitit.Authentication
    Network.Gitit.Authentication.Github Network.Gitit.Cache
    Network.Gitit.Compat.Except Network.Gitit.Config
    Network.Gitit.ContentTransformer Network.Gitit.Feed
    Network.Gitit.Framework Network.Gitit.Handlers
    Network.Gitit.Initialize Network.Gitit.Interface
    Network.Gitit.Layout Network.Gitit.Page Network.Gitit.Plugins
    Network.Gitit.Rpxnow Network.Gitit.Server Network.Gitit.State
    Network.Gitit.Types Network.Gitit.Util Paths_gitit

import-dirs:          /usr/lib/ghc-9.4.8/site-local/gitit-0.15.1.2
library-dirs:         /usr/lib/ghc-9.4.8/site-local/gitit-0.15.1.2
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/gitit-0.15.1.2
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/gitit
hs-libraries:         HSgitit-0.15.1.2-1Fh00rlYD3sGo97td5Aeuh
depends:
    HStringTemplate-0.8.8-HAWJ9KTxO3QFHWUV4XjFAc
    HTTP-4000.4.1-KnVy0Z4vKymGLqCAUlrW4k
    SHA-1.6.4.4-8ksu987L0xnDMFbhBLiacl
    aeson-2.1.2.1-IZ8jLcnEISD7S5Vyf2Tehm base-4.17.2.1
    base64-bytestring-1.2.1.0-7CU13IWnWdcDMU9nDc25iT
    blaze-html-0.9.2.0-LTAcRvwA4RX5X1Di6KFyT1 bytestring-0.11.5.3
    containers-0.6.7 directory-1.3.7.1
    doctemplates-0.11.0.1-9pa2jofdveQBYF9Ob47w2Q
    feed-1.3.2.1-JYJASf4TmIb1ujxG0Gb93Y filepath-1.4.2.2
    filestore-0.6.5.1-1WUlJBeonxa4rRXFFJ4KUH ghc-9.4.8
    ghc-paths-0.1.0.12-8lmZj1VFo8V7iNy4rcXCyj
    happstack-server-7.9.2.2-3k9BNaUabQdFIjlSjCWKjA
    hoauth2-2.12.0-5GaUPVU0oGZKlF5hsqf4Fe
    hslogger-1.3.2.0-2VvIfXniGBBG1Z464pLxt3
    http-client-tls-0.3.6.4-Egz0XoSYeB1LT6UCJVMaX8
    http-conduit-2.3.9.1-3unIqyPQbILE7LHBwWMmkF
    json-0.10-GrgDp0AKt8A29OeuATu8B7 mtl-2.2.2
    network-3.1.4.0-KAEk2uZxmO9GA8hoXz0jL7
    network-bsd-2.8.1.0-BJUSKEuJTGy8j4ZDnoY4NB
    network-uri-2.6.4.2-BPG1Yj05GAIIauIotQ4jTb
    old-locale-1.0.0.7-KCPcWVOQKME2P4y4gxzvhh
    old-time-1.1.0.4-7kNg8VzooGoExH4yeT9sv9
    pandoc-3.2-Hi4b8z0wE5W2h94zAvZVex
    pandoc-types-1.23.1-DkJitg32dGYAvPxFYUNIVd parsec-3.1.16.1
    pretty-1.1.3.6 process-1.6.18.0
    random-1.2.1.3-LY8g0he9kPzH0WCF9vQLty
    recaptcha-0.1.0.4-AJeheJDv0v2El3sOXVac36
    safe-0.3.21-KEfOvx15i1f7ewOxq0ZYoN
    skylighting-0.14.2-JRq7P0eepftHzIlMbEQVMQ
    split-0.2.5-Dujwwofvw7aEFmjRmWhj9Q syb-0.7.3-82kecYkSnotJhXSs3T6xq0
    tagsoup-0.14.8-LBUfvWN5ZFu8SHYhreNfBS
    temporary-1.3-Hp6jkQ9rtgX3Zx1BXXhTu3 text-2.0.2 time-1.12.2
    uri-bytestring-0.3.3.1-ING8b3qfISQ5B92rBJHj8q
    url-2.1.3-4JedCcWLwjDJHh8GXXluzI
    utf8-string-1.0.2-EpYvbnx7dwVHTduFVbgaKq
    uuid-1.3.16-8DXJEeeES9kGcCaO3OL4N3 xhtml-3000.2.2.1
    xml-1.3.14-Lx2FeToC7XoDX0aDGC9dRG
    xml-conduit-1.9.1.4-5kSTlpOWg4V6G2RRq5lEzi
    xml-types-0.3.8-IpGyuvvNOu2AH1SOobl25
    xss-sanitize-0.3.7.2-D77ZOZXrMMhLkjHM9FaJVu
    zlib-0.7.0.0-LNS4V16oWBo1UVlHx1MhtU

haddock-interfaces:   /usr/share/doc/gitit/html/gitit.haddock
haddock-html:         /usr/share/doc/gitit/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

