#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 gitit
version:              0.15.1.2
visibility:           public
id:                   gitit-0.15.1.2-1ThovFbGZBdCCW5TDI16tH
key:                  gitit-0.15.1.2-1ThovFbGZBdCCW5TDI16tH
license:              LicenseRef-GPL
maintainer:           jgm@berkeley.edu
author:               John MacFarlane
stability:            experimental
synopsis:             Wiki using happstack, git or darcs, and pandoc.
description:
    Gitit is a wiki backed by a git, darcs, or mercurial
    filestore.  Pages and uploaded files can be modified either
    directly via the VCS'\''s command-line tools or through
    the wiki'\''s web interface. Pandoc is used for markup
    processing, so pages may be written in
    (extended) markdown, reStructuredText, LaTeX, HTML,
    or literate Haskell.

    Notable features include

    * plugins: dynamically loaded page
    transformations written in Haskell (see
    "Network.Gitit.Interface")

    * conversion of TeX math to MathML for display in
    web browsers

    * syntax highlighting of source code
    files and code snippets

    * Atom feeds (site-wide and per-page)

    * a library, "Network.Gitit", that makes it simple
    to include a gitit wiki in any happstack application

    For usage information:  @gitit --help@

category:             Network
abi:                  a10017d80d5144d023b8f2841b07f737
exposed:              True
exposed-modules:
    Network.Gitit Network.Gitit.Authentication
    Network.Gitit.Authentication.Github Network.Gitit.Cache
    Network.Gitit.Compat.Except Network.Gitit.Config
    Network.Gitit.ContentTransformer Network.Gitit.Feed
    Network.Gitit.Framework Network.Gitit.Handlers
    Network.Gitit.Initialize Network.Gitit.Interface
    Network.Gitit.Layout Network.Gitit.Page Network.Gitit.Plugins
    Network.Gitit.Rpxnow Network.Gitit.Server Network.Gitit.State
    Network.Gitit.Types Network.Gitit.Util Paths_gitit

import-dirs:          /usr/lib/ghc-9.4.8/site-local/gitit-0.15.1.2
library-dirs:         /usr/lib/ghc-9.4.8/site-local/gitit-0.15.1.2
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/gitit-0.15.1.2
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/gitit
hs-libraries:         HSgitit-0.15.1.2-1ThovFbGZBdCCW5TDI16tH
depends:
    HStringTemplate-0.8.8-3otgg7CEukHIWRK1JBMHnq
    HTTP-4000.4.1-cxESqnQ5INHUQLfhPMkmP
    SHA-1.6.4.4-8ksu987L0xnDMFbhBLiacl
    aeson-2.1.2.1-8kv8xeVfmZaCzdZG9aqfKb base-4.17.2.1
    base64-bytestring-1.2.1.0-3cCVQioh572KzPLHpOFxfQ
    blaze-html-0.9.2.0-IQy0cbBKAdFK1dhx28dN3E bytestring-0.11.5.3
    containers-0.6.7 directory-1.3.7.1
    doctemplates-0.11.0.1-6RiPMXQynqj8dmYUTdhQA8
    feed-1.3.2.1-Io4OwdzYZhn8Xp7jCukoU8 filepath-1.4.2.2
    filestore-0.6.5.1-EX8fcThTQyT8w0ANrBPsuv ghc-9.4.8
    ghc-paths-0.1.0.12-8lmZj1VFo8V7iNy4rcXCyj
    happstack-server-7.9.2.1-Haunw6pqgyd9KJMKgVAIzM
    hoauth2-2.10.0-60YJkjDlrjC5oDfofbhieu
    hslogger-1.3.1.2-DouaEh2Olyj7S79Lig3W67
    http-client-tls-0.3.6.4-8XU3sE2WrKcAyR7Z9nyH2W
    http-conduit-2.3.9.1-Htpo5ybm1VnLc22xTZEyI8
    json-0.10-HQ53o9xwf9lL3bC3dID88c mtl-2.2.2
    network-3.1.4.0-HNOpCulLIRrH0UV3cvGeTA
    network-bsd-2.8.1.0-2j2ZbQwL2ho7OZpxXWFm02
    network-uri-2.6.4.2-4Or7NcWT1BFGL9jaSnxRbG
    old-locale-1.0.0.7-KCPcWVOQKME2P4y4gxzvhh
    old-time-1.1.0.4-7kNg8VzooGoExH4yeT9sv9
    pandoc-3.1.13-9wMZiZQV5cfE1CElysz5Dm
    pandoc-types-1.23.1-6ll0VgcGUsdEd5Y7k1UObG parsec-3.1.16.1
    pretty-1.1.3.6 process-1.6.18.0
    random-1.2.1.3-1ICINoe1N4e7cLBAPqefIx
    recaptcha-0.1.0.4-7BLWS4DDYIXGgp1nABomH4
    safe-0.3.21-EJlQ7Hm9gwUGpRoyGimKjN
    skylighting-0.14.1.1-IK3BFcwb6FR23m6DMbx0Fc
    split-0.2.5-HF22Q1cIKmoK4fHDRbSUwV
    syb-0.7.2.4-LBhYOmNvCTD9nmTNYbjxYb
    tagsoup-0.14.8-2QG0oOUui39AL9VmXW7mLb
    temporary-1.3-3mtZbkJPoBb5nlmfkfYt6T text-2.0.2 time-1.12.2
    uri-bytestring-0.3.3.1-5hEQH5JYpk7CdyBQmXzfig
    url-2.1.3-HH0TccKaktc7b8I8qoi3h7
    utf8-string-1.0.2-D0oARDqSiCF3CIA0pPBIDm
    uuid-1.3.16-E94tJlD3hEQJwX865gS6xP xhtml-3000.2.2.1
    xml-1.3.14-Lx2FeToC7XoDX0aDGC9dRG
    xml-conduit-1.9.1.4-CdWSJqdLhP31lFJKXpJQwT
    xml-types-0.3.8-IpGyuvvNOu2AH1SOobl25
    xss-sanitize-0.3.7.2-E8nlIPBZ5HyI27n8sn5U9a
    zlib-0.7.0.0-A3AttubSge48DOXx0obOud

haddock-interfaces:   /usr/share/doc/gitit/html/gitit.haddock
haddock-html:         /usr/share/doc/gitit/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

