#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 gitit
version:              0.15.1.2
visibility:           public
id:                   gitit-0.15.1.2-1msUM4qmzemHWGL2WAXedm
key:                  gitit-0.15.1.2-1msUM4qmzemHWGL2WAXedm
license:              LicenseRef-GPL
maintainer:           jgm@berkeley.edu
author:               John MacFarlane
stability:            experimental
synopsis:             Wiki using happstack, git or darcs, and pandoc.
description:
    Gitit is a wiki backed by a git, darcs, or mercurial
    filestore.  Pages and uploaded files can be modified either
    directly via the VCS'\''s command-line tools or through
    the wiki'\''s web interface. Pandoc is used for markup
    processing, so pages may be written in
    (extended) markdown, reStructuredText, LaTeX, HTML,
    or literate Haskell.

    Notable features include

    * plugins: dynamically loaded page
    transformations written in Haskell (see
    "Network.Gitit.Interface")

    * conversion of TeX math to MathML for display in
    web browsers

    * syntax highlighting of source code
    files and code snippets

    * Atom feeds (site-wide and per-page)

    * a library, "Network.Gitit", that makes it simple
    to include a gitit wiki in any happstack application

    For usage information:  @gitit --help@

category:             Network
abi:                  663f232fd18f77699293f9d227f3e64f
exposed:              True
exposed-modules:
    Network.Gitit Network.Gitit.Authentication
    Network.Gitit.Authentication.Github Network.Gitit.Cache
    Network.Gitit.Compat.Except Network.Gitit.Config
    Network.Gitit.ContentTransformer Network.Gitit.Feed
    Network.Gitit.Framework Network.Gitit.Handlers
    Network.Gitit.Initialize Network.Gitit.Interface
    Network.Gitit.Layout Network.Gitit.Page Network.Gitit.Plugins
    Network.Gitit.Rpxnow Network.Gitit.Server Network.Gitit.State
    Network.Gitit.Types Network.Gitit.Util Paths_gitit

import-dirs:          /usr/lib/ghc-9.4.8/site-local/gitit-0.15.1.2
library-dirs:         /usr/lib/ghc-9.4.8/site-local/gitit-0.15.1.2
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/gitit-0.15.1.2
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/gitit
hs-libraries:         HSgitit-0.15.1.2-1msUM4qmzemHWGL2WAXedm
depends:
    HStringTemplate-0.8.8-TGcgZ78l23Hq7NjVuVDhh
    HTTP-4000.4.1-CPnqWPj2z0ADf70EBq9MPS
    SHA-1.6.4.4-8ksu987L0xnDMFbhBLiacl
    aeson-2.1.2.1-6ANjbGmrSDg8K6hz3VmYXP base-4.17.2.1
    base64-bytestring-1.2.1.0-9TOa4ZiPzZCEZmYgmgxjAh
    blaze-html-0.9.2.0-Ji537hcwMq4HoKqYAGHtNW bytestring-0.11.5.3
    containers-0.6.7 directory-1.3.7.1
    doctemplates-0.11.0.1-99xKuF3cXHk4X02lQM7R56
    feed-1.3.2.1-J9TCNIfX8oC5b5l6w68HnC filepath-1.4.2.2
    filestore-0.6.5.1-9nM2vuhzY1y7FVw6d0N7UH ghc-9.4.8
    ghc-paths-0.1.0.12-8lmZj1VFo8V7iNy4rcXCyj
    happstack-server-7.9.2.1-8rN80DcjhJ3J5qwuyWnhnZ
    hoauth2-2.11.0-B2TRjbTD2wzFKO6UHd1I52
    hslogger-1.3.2.0-JPl4iTHiy5sKtYlE8mEZMX
    http-client-tls-0.3.6.4-4b1LqwZqELbD3PiYpWlMw1
    http-conduit-2.3.9.1-IrgIKKd9NOlKX1Xpi2KNUa
    json-0.10-GtmTPpjuynnC3spyvpHoyU mtl-2.2.2
    network-3.1.4.0-480JOeNLV9o5fbqpzcHJCB
    network-bsd-2.8.1.0-FVYMexhdgoihg44V3yAwr
    network-uri-2.6.4.2-DCTjueINivX2RvibFUmCb5
    old-locale-1.0.0.7-KCPcWVOQKME2P4y4gxzvhh
    old-time-1.1.0.4-7kNg8VzooGoExH4yeT9sv9
    pandoc-3.2-9nPBsXUnEBBFnrWtEL8Z10
    pandoc-types-1.23.1-K06ZkCBa4PnEZfDQl4Mn1O parsec-3.1.16.1
    pretty-1.1.3.6 process-1.6.18.0
    random-1.2.1.3-2jtdg0FBSKzAasSf5KWDPe
    recaptcha-0.1.0.4-2euADbaCGtwJ7gs65MpYHp
    safe-0.3.21-95M34uAYizmIkn1zPFtQ36
    skylighting-0.14.2-Kim8KOoVFJBFI2cvNA1M40
    split-0.2.5-Dujwwofvw7aEFmjRmWhj9Q syb-0.7.3-Lap6GPARkRXCVbqA2faY6P
    tagsoup-0.14.8-2whXo20s5seDdYInOXET8Y
    temporary-1.3-Bz9UHoeAgBV21I7419KVlH text-2.0.2 time-1.12.2
    uri-bytestring-0.3.3.1-HLD9xgSHQmP79s7EoLgJs2
    url-2.1.3-HH0TccKaktc7b8I8qoi3h7
    utf8-string-1.0.2-D0oARDqSiCF3CIA0pPBIDm
    uuid-1.3.16-H6wTQZCEbfUDs3BNV1jl4c xhtml-3000.2.2.1
    xml-1.3.14-Lx2FeToC7XoDX0aDGC9dRG
    xml-conduit-1.9.1.4-7lMJqvbIlhi6eIKtmmElnZ
    xml-types-0.3.8-IpGyuvvNOu2AH1SOobl25
    xss-sanitize-0.3.7.2-Jic7Ex2eGaS9Rfh0EILhRv
    zlib-0.7.0.0-JzSh6x0Wz1B4h2omw65Rcm

haddock-interfaces:   /usr/share/doc/gitit/html/gitit.haddock
haddock-html:         /usr/share/doc/gitit/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

