#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 gitit
version:              0.15.1.2
visibility:           public
id:                   gitit-0.15.1.2-CIUcDHva3ZFGkhmad1C1au
key:                  gitit-0.15.1.2-CIUcDHva3ZFGkhmad1C1au
license:              LicenseRef-GPL
maintainer:           jgm@berkeley.edu
author:               John MacFarlane
stability:            experimental
synopsis:             Wiki using happstack, git or darcs, and pandoc.
description:
    Gitit is a wiki backed by a git, darcs, or mercurial
    filestore.  Pages and uploaded files can be modified either
    directly via the VCS'\''s command-line tools or through
    the wiki'\''s web interface. Pandoc is used for markup
    processing, so pages may be written in
    (extended) markdown, reStructuredText, LaTeX, HTML,
    or literate Haskell.

    Notable features include

    * plugins: dynamically loaded page
    transformations written in Haskell (see
    "Network.Gitit.Interface")

    * conversion of TeX math to MathML for display in
    web browsers

    * syntax highlighting of source code
    files and code snippets

    * Atom feeds (site-wide and per-page)

    * a library, "Network.Gitit", that makes it simple
    to include a gitit wiki in any happstack application

    For usage information:  @gitit --help@

category:             Network
abi:                  faa539237383b928f8af1f1c0cbfddf4
exposed:              True
exposed-modules:
    Network.Gitit Network.Gitit.Authentication
    Network.Gitit.Authentication.Github Network.Gitit.Cache
    Network.Gitit.Compat.Except Network.Gitit.Config
    Network.Gitit.ContentTransformer Network.Gitit.Feed
    Network.Gitit.Framework Network.Gitit.Handlers
    Network.Gitit.Initialize Network.Gitit.Interface
    Network.Gitit.Layout Network.Gitit.Page Network.Gitit.Plugins
    Network.Gitit.Rpxnow Network.Gitit.Server Network.Gitit.State
    Network.Gitit.Types Network.Gitit.Util Paths_gitit

import-dirs:          /usr/lib/ghc-9.4.8/site-local/gitit-0.15.1.2
library-dirs:         /usr/lib/ghc-9.4.8/site-local/gitit-0.15.1.2
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/gitit-0.15.1.2
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/gitit
hs-libraries:         HSgitit-0.15.1.2-CIUcDHva3ZFGkhmad1C1au
depends:
    HStringTemplate-0.8.8-J8yXJ9QNzO17HsjGWYwyUt
    HTTP-4000.4.1-14B7e92uULi3NEdUxVKXYv
    SHA-1.6.4.4-8ksu987L0xnDMFbhBLiacl
    aeson-2.1.2.1-AuEsVg6Hhe2CPhaLp40FYe base-4.17.2.1
    base64-bytestring-1.2.1.0-AbhqXNvtZOJLR3Ub6lZ1hd
    blaze-html-0.9.2.0-2tQrpPPktTE9kc7YupDhad bytestring-0.11.5.3
    containers-0.6.7 directory-1.3.7.1
    doctemplates-0.11.0.1-Chj9hOMnWt7C65NZxTv8al
    feed-1.3.2.1-Iw4kqSMfBNJ9FnJe7BrzQT filepath-1.4.2.2
    filestore-0.6.5.1-FjukShBDW7A6nzs1kUw3TY ghc-9.4.8
    ghc-paths-0.1.0.12-8lmZj1VFo8V7iNy4rcXCyj
    happstack-server-7.9.2.1-1kdSl6dkdE18WXSMVZSlkG
    hoauth2-2.11.0-Hh0HayUJSpuEPjOk52nP1O
    hslogger-1.3.2.0-AzvyJp6KC686sMbxwPnIts
    http-client-tls-0.3.6.4-BtAmNja0oKIEdL14Ub64ie
    http-conduit-2.3.9.1-8bxAH0k07PX13M7HRtwP2b
    json-0.10-J5wdOcq7hdHLtIKCHRdnhL mtl-2.2.2
    network-3.1.4.0-HbZCj3UHcZsFvn6ftFrD4m
    network-bsd-2.8.1.0-BSLTa1UZa046rrHqmBIOQa
    network-uri-2.6.4.2-BuPsn3YVnowHuszetfOccY
    old-locale-1.0.0.7-KCPcWVOQKME2P4y4gxzvhh
    old-time-1.1.0.4-7kNg8VzooGoExH4yeT9sv9
    pandoc-3.2-EoPKBUIR4TVL3hBaNjenu3
    pandoc-types-1.23.1-7qhMcAsOl2E7hqDAjcd2Na parsec-3.1.16.1
    pretty-1.1.3.6 process-1.6.18.0
    random-1.2.1.3-6i9JKgFPfeq3EPTeuIde26
    recaptcha-0.1.0.4-6WO97jD0f0w6OZqMsMpFpe
    safe-0.3.21-8kVaTUiukdbF02Sa2bWRZd
    skylighting-0.14.2-BWy6OXuc7vULPdmO7NY2A7
    split-0.2.5-Dujwwofvw7aEFmjRmWhj9Q syb-0.7.3-GzxvBIT7N6LHXGQxqlBVFk
    tagsoup-0.14.8-B17Cc7zYY7sAlqoHY1CE9I
    temporary-1.3-AfE2cndENM7EhkpFowzNgZ text-2.0.2 time-1.12.2
    uri-bytestring-0.3.3.1-3M3REwWc3S6IMkax8pV9R
    url-2.1.3-HH0TccKaktc7b8I8qoi3h7
    utf8-string-1.0.2-D0oARDqSiCF3CIA0pPBIDm
    uuid-1.3.16-C3saOK348ZADBDzhjAv3Kl xhtml-3000.2.2.1
    xml-1.3.14-Lx2FeToC7XoDX0aDGC9dRG
    xml-conduit-1.9.1.4-HX7sewl5DOYJ1lWepRkYDC
    xml-types-0.3.8-IpGyuvvNOu2AH1SOobl25
    xss-sanitize-0.3.7.2-3t64uzYR9WuE4oLopbd8Vj
    zlib-0.7.0.0-8AcmAPhxxYB499JDo6q05j

haddock-interfaces:   /usr/share/doc/gitit/html/gitit.haddock
haddock-html:         /usr/share/doc/gitit/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

