#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 gitit
version:              0.15.1.2
visibility:           public
id:                   gitit-0.15.1.2-IGyFLoHuDGNAylwwcl4AuY
key:                  gitit-0.15.1.2-IGyFLoHuDGNAylwwcl4AuY
license:              LicenseRef-GPL
maintainer:           jgm@berkeley.edu
author:               John MacFarlane
stability:            experimental
synopsis:             Wiki using happstack, git or darcs, and pandoc.
description:
    Gitit is a wiki backed by a git, darcs, or mercurial
    filestore.  Pages and uploaded files can be modified either
    directly via the VCS'\''s command-line tools or through
    the wiki'\''s web interface. Pandoc is used for markup
    processing, so pages may be written in
    (extended) markdown, reStructuredText, LaTeX, HTML,
    or literate Haskell.

    Notable features include

    * plugins: dynamically loaded page
    transformations written in Haskell (see
    "Network.Gitit.Interface")

    * conversion of TeX math to MathML for display in
    web browsers

    * syntax highlighting of source code
    files and code snippets

    * Atom feeds (site-wide and per-page)

    * a library, "Network.Gitit", that makes it simple
    to include a gitit wiki in any happstack application

    For usage information:  @gitit --help@

category:             Network
abi:                  b522b0afa82b1513fe3bc55000931845
exposed:              True
exposed-modules:
    Network.Gitit Network.Gitit.Authentication
    Network.Gitit.Authentication.Github Network.Gitit.Cache
    Network.Gitit.Compat.Except Network.Gitit.Config
    Network.Gitit.ContentTransformer Network.Gitit.Feed
    Network.Gitit.Framework Network.Gitit.Handlers
    Network.Gitit.Initialize Network.Gitit.Interface
    Network.Gitit.Layout Network.Gitit.Page Network.Gitit.Plugins
    Network.Gitit.Rpxnow Network.Gitit.Server Network.Gitit.State
    Network.Gitit.Types Network.Gitit.Util Paths_gitit

import-dirs:          /usr/lib/ghc-9.4.8/site-local/gitit-0.15.1.2
library-dirs:         /usr/lib/ghc-9.4.8/site-local/gitit-0.15.1.2
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/gitit-0.15.1.2
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/gitit
hs-libraries:         HSgitit-0.15.1.2-IGyFLoHuDGNAylwwcl4AuY
depends:
    HStringTemplate-0.8.8-B1o795Xqoo57umDG9ElPdx
    HTTP-4000.4.1-E8Ywa0lXD8D4pNfBY9Gj51
    SHA-1.6.4.4-8ksu987L0xnDMFbhBLiacl
    aeson-2.1.2.1-J19dEw13kUOF5hLEOQVj2r base-4.17.2.1
    base64-bytestring-1.2.1.0-36j4xjYGwYUKFZDPcQTnk0
    blaze-html-0.9.2.0-KGNUVzd5sBrDaiavnWufWj bytestring-0.11.5.3
    containers-0.6.7 directory-1.3.7.1
    doctemplates-0.11.0.1-6tYrE7Rv76WIwRLzVWa86e
    feed-1.3.2.1-A9sfCD8TeYBLpFbaPpmLax filepath-1.4.2.2
    filestore-0.6.5.1-4Gzz8pyJey67WOjDAA9k46 ghc-9.4.8
    ghc-paths-0.1.0.12-8lmZj1VFo8V7iNy4rcXCyj
    happstack-server-7.9.2.1-328oxufJCv6BCSnw6fgMPF
    hoauth2-2.11.0-C6CBxCU79CNHnfHsQBnJbZ
    hslogger-1.3.2.0-Cd5feFOq11h13FKEO5920a
    http-client-tls-0.3.6.4-BH2xF2TCL7BBkvzFmR7sFV
    http-conduit-2.3.9.1-3n4v82wlSFa3QDa9P93DJ7
    json-0.10-AxsOIJ7nLHIBntzVdD7JUR mtl-2.2.2
    network-3.1.4.0-Aot7Hsnd3no7HIoU7vrrpP
    network-bsd-2.8.1.0-1NNN1bMlF4J8GlBB74g1Xf
    network-uri-2.6.4.2-14hVMYCnjzx6Mshy3n2kRE
    old-locale-1.0.0.7-KCPcWVOQKME2P4y4gxzvhh
    old-time-1.1.0.4-7kNg8VzooGoExH4yeT9sv9
    pandoc-3.2-C47bq49UTvq8UlY4UmvOaS
    pandoc-types-1.23.1-8PxAysaiPrI2y7nkSd3yJH parsec-3.1.16.1
    pretty-1.1.3.6 process-1.6.18.0
    random-1.2.1.3-8yAn85BRVsALc4v1F70S7L
    recaptcha-0.1.0.4-1XilVcV64UPAsE2CGHY0rQ
    safe-0.3.21-BTgY19Ix98PEQ0IXGyRX6s
    skylighting-0.14.2-7V5AIbRsUBXBNaAb7gLlfR
    split-0.2.5-HF22Q1cIKmoK4fHDRbSUwV syb-0.7.3-6VXQKmiHaWYG9qlQr6p3GQ
    tagsoup-0.14.8-KDFXPJFJpbQF6FtgQ05wFZ
    temporary-1.3-H3SteNwKbkKBCt6CIyC5cW text-2.0.2 time-1.12.2
    uri-bytestring-0.3.3.1-D5QJv3bWS7oLnxFS7lj2jY
    url-2.1.3-HH0TccKaktc7b8I8qoi3h7
    utf8-string-1.0.2-D0oARDqSiCF3CIA0pPBIDm
    uuid-1.3.16-5cxlukUHp1iIaHLZ7jl7cq xhtml-3000.2.2.1
    xml-1.3.14-Lx2FeToC7XoDX0aDGC9dRG
    xml-conduit-1.9.1.4-JbW1CHHxxgY6y4Z5H36YfY
    xml-types-0.3.8-IpGyuvvNOu2AH1SOobl25
    xss-sanitize-0.3.7.2-2E4iA9ccHRMLVWbZmpFYYJ
    zlib-0.7.0.0-ATHPnZDfTdk2n8nRbXD692

haddock-interfaces:   /usr/share/doc/gitit/html/gitit.haddock
haddock-html:         /usr/share/doc/gitit/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

