#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 gitit
version:              0.15.1.2
visibility:           public
id:                   gitit-0.15.1.2-9jPbTTu7X8JAoOeGvhhzko
key:                  gitit-0.15.1.2-9jPbTTu7X8JAoOeGvhhzko
license:              LicenseRef-GPL
maintainer:           jgm@berkeley.edu
author:               John MacFarlane
stability:            experimental
synopsis:             Wiki using happstack, git or darcs, and pandoc.
description:
    Gitit is a wiki backed by a git, darcs, or mercurial
    filestore.  Pages and uploaded files can be modified either
    directly via the VCS'\''s command-line tools or through
    the wiki'\''s web interface. Pandoc is used for markup
    processing, so pages may be written in
    (extended) markdown, reStructuredText, LaTeX, HTML,
    or literate Haskell.

    Notable features include

    * plugins: dynamically loaded page
    transformations written in Haskell (see
    "Network.Gitit.Interface")

    * conversion of TeX math to MathML for display in
    web browsers

    * syntax highlighting of source code
    files and code snippets

    * Atom feeds (site-wide and per-page)

    * a library, "Network.Gitit", that makes it simple
    to include a gitit wiki in any happstack application

    For usage information:  @gitit --help@

category:             Network
abi:                  2309486947241c29e740681585aa0087
exposed:              True
exposed-modules:
    Network.Gitit Network.Gitit.Authentication
    Network.Gitit.Authentication.Github Network.Gitit.Cache
    Network.Gitit.Compat.Except Network.Gitit.Config
    Network.Gitit.ContentTransformer Network.Gitit.Feed
    Network.Gitit.Framework Network.Gitit.Handlers
    Network.Gitit.Initialize Network.Gitit.Interface
    Network.Gitit.Layout Network.Gitit.Page Network.Gitit.Plugins
    Network.Gitit.Rpxnow Network.Gitit.Server Network.Gitit.State
    Network.Gitit.Types Network.Gitit.Util Paths_gitit

import-dirs:          /usr/lib/ghc-9.4.8/site-local/gitit-0.15.1.2
library-dirs:         /usr/lib/ghc-9.4.8/site-local/gitit-0.15.1.2
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/gitit-0.15.1.2
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/gitit
hs-libraries:         HSgitit-0.15.1.2-9jPbTTu7X8JAoOeGvhhzko
depends:
    HStringTemplate-0.8.8-IlWFYp7ufu5ImPCCZj24Y1
    HTTP-4000.4.1-Ix1w0BNbLlK51NY5iY9BjB
    SHA-1.6.4.4-8ksu987L0xnDMFbhBLiacl
    aeson-2.1.2.1-4XssoWP8s0tKPHSv4bO4jS base-4.17.2.1
    base64-bytestring-1.2.1.0-9K52dGT2jL1Hyh8Ww36box
    blaze-html-0.9.2.0-6qRmvU75P7Y4rwuconQelG bytestring-0.11.5.3
    containers-0.6.7 directory-1.3.7.1
    doctemplates-0.11.0.1-KRY5iRzklYrG7ObBFUXk0c
    feed-1.3.2.1-EkMXcFx55ukGjYT0bXtmqL filepath-1.4.2.2
    filestore-0.6.5.1-9HQiXtKDXCsC2p07tQIcMH ghc-9.4.8
    ghc-paths-0.1.0.12-8lmZj1VFo8V7iNy4rcXCyj
    happstack-server-7.9.2.1-8Jg77y84PHIKu8OD9Z4pyX
    hoauth2-2.10.0-2CRHwDE5vvC55ZBr2cXz8S
    hslogger-1.3.1.2-3Gja8tueiGUmN1XADeLFV
    http-client-tls-0.3.6.4-EsZUowlT5rT685ImtnlbYx
    http-conduit-2.3.9.1-EsbQViE5oYG6OdIa009kue
    json-0.10-FDPGsXzpLW1HTCsmwVxFpW mtl-2.2.2
    network-3.1.4.0-5uK3u4RW2BBBzIyfRS5Jps
    network-bsd-2.8.1.0-DJTjlUoYJxrJ5HhtYIPAf0
    network-uri-2.6.4.2-2wmE2uZDcqIIgHOfFlXQyo
    old-locale-1.0.0.7-KCPcWVOQKME2P4y4gxzvhh
    old-time-1.1.0.4-7kNg8VzooGoExH4yeT9sv9
    pandoc-3.1.13-7KCZhbGvPkeLdAKBNWfYrA
    pandoc-types-1.23.1-jAANCg3bEVITKUApc2yXD parsec-3.1.16.1
    pretty-1.1.3.6 process-1.6.18.0
    random-1.2.1.3-Hc2Rnu5BTd49WL1xp2j5Li
    recaptcha-0.1.0.4-BErOrpvZKSsFj7SOsrwHmP
    safe-0.3.21-Fk6FaHWaShq6V6AQNbWYhR
    skylighting-0.14.1.1-CSamCKkKHukAGx148NioRX
    split-0.2.5-HF22Q1cIKmoK4fHDRbSUwV
    syb-0.7.2.4-3MUyG3p3euQLeyQ65NE0AP
    tagsoup-0.14.8-9Fyby9nljQv3chZcvN0gHw
    temporary-1.3-IbENfV52re6K6jELI02KCQ text-2.0.2 time-1.12.2
    uri-bytestring-0.3.3.1-H69JDYmhmmT7hIVMBbsV8R
    url-2.1.3-5jqeZ5XJ7ppHdpwVy0F3TG
    utf8-string-1.0.2-FAQSGuIUGqDKZx6mH04y15
    uuid-1.3.16-dS6vFBhNeiE6DOQNmMx8D xhtml-3000.2.2.1
    xml-1.3.14-Lx2FeToC7XoDX0aDGC9dRG
    xml-conduit-1.9.1.4-2J0zZfr9vqgEeegk8Odyfb
    xml-types-0.3.8-IpGyuvvNOu2AH1SOobl25
    xss-sanitize-0.3.7.2-EaB6Zk7cdTxDkBuWNXp1Rb
    zlib-0.7.0.0-JfaybF41sT11aveAlOmghA

haddock-interfaces:   /usr/share/doc/gitit/html/gitit.haddock
haddock-html:         /usr/share/doc/gitit/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

