/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.dom;

import io.sf.carte.doc.dom.AbstractDOMNode;
import io.sf.carte.doc.dom.DOMAttr;
import io.sf.carte.doc.dom.DOMElement;
import io.sf.carte.doc.dom.DOMNode;
import io.sf.carte.doc.dom.NodeFilter;
import io.sf.carte.doc.dom.NodeIterator;
import java.util.NoSuchElementException;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;

class NodeIteratorImpl
implements NodeIterator,
org.w3c.dom.traversal.NodeIterator {
    private final AbstractDOMNode rootNode;
    private AbstractDOMNode currentNode;
    private AbstractDOMNode last = null;
    private int currentIndex = 0;
    private final int whatToShow;
    private final NodeFilter nodeFilter;

    NodeIteratorImpl(AbstractDOMNode abstractDOMNode, int n, NodeFilter nodeFilter) {
        this.rootNode = abstractDOMNode;
        this.nodeFilter = nodeFilter;
        this.whatToShow = n;
        this.currentNode = null;
    }

    @Override
    public AbstractDOMNode getRoot() {
        return this.rootNode;
    }

    @Override
    public int getWhatToShow() {
        return this.whatToShow;
    }

    @Override
    public NodeFilter getNodeFilter() {
        return this.nodeFilter;
    }

    @Override
    public boolean hasNext() {
        AbstractDOMNode abstractDOMNode = this.findNext();
        return abstractDOMNode != this.rootNode || this.currentNode == null && (this.isAccepted(abstractDOMNode) || this.findNext(abstractDOMNode) != this.rootNode);
    }

    private AbstractDOMNode findNext() {
        if (this.currentNode == null) {
            return this.rootNode;
        }
        return this.findNext(this.currentNode);
    }

    private AbstractDOMNode findNext(AbstractDOMNode abstractDOMNode) {
        short s;
        AbstractDOMNode abstractDOMNode2 = this.nextNode(abstractDOMNode);
        while (abstractDOMNode2 != this.rootNode && (s = this.filter(abstractDOMNode2)) != 1) {
            if (s != 3) {
                abstractDOMNode2 = this.nextSiblingOrParent(abstractDOMNode2);
                continue;
            }
            abstractDOMNode2 = this.nextNode(abstractDOMNode2);
        }
        return abstractDOMNode2;
    }

    private AbstractDOMNode nextNode(AbstractDOMNode abstractDOMNode) {
        AbstractDOMNode abstractDOMNode2 = abstractDOMNode.getNodeList().getFirst();
        if (abstractDOMNode2 == null) {
            abstractDOMNode2 = abstractDOMNode != this.rootNode || this.rootNode.getNodeType() == 2 ? this.nextSiblingOrParent(abstractDOMNode) : abstractDOMNode;
        }
        return abstractDOMNode2;
    }

    private AbstractDOMNode nextSiblingOrParent(AbstractDOMNode abstractDOMNode) {
        AbstractDOMNode abstractDOMNode2 = abstractDOMNode.nextSibling;
        if (abstractDOMNode2 == null) {
            AbstractDOMNode abstractDOMNode3 = abstractDOMNode.parentNode();
            if (abstractDOMNode3 != this.rootNode && abstractDOMNode3 != null) {
                return this.nextSiblingOrParent(abstractDOMNode3);
            }
            abstractDOMNode2 = this.rootNode;
        }
        return abstractDOMNode2;
    }

    private boolean isToShow(Node node) {
        int n = NodeFilter.maskTable[node.getNodeType() - 1];
        return (this.whatToShow & n) == n;
    }

    private short filter(Node node) {
        if (!this.isToShow(node)) {
            return 3;
        }
        return this.nodeFilter == null ? (short)1 : this.nodeFilter.acceptNode(node);
    }

    @Override
    public DOMNode next() {
        AbstractDOMNode abstractDOMNode = this.findNext();
        if (abstractDOMNode != this.rootNode || this.currentNode == null && (this.isAccepted(abstractDOMNode) || (abstractDOMNode = this.findNext(abstractDOMNode)) != this.rootNode)) {
            ++this.currentIndex;
            this.last = abstractDOMNode;
            this.currentNode = abstractDOMNode;
            return abstractDOMNode;
        }
        throw new NoSuchElementException();
    }

    private boolean isAccepted(AbstractDOMNode abstractDOMNode) {
        return this.filter(abstractDOMNode) == 1;
    }

    @Override
    public DOMNode nextNode() {
        try {
            return this.next();
        }
        catch (NoSuchElementException noSuchElementException) {
            return null;
        }
    }

    @Override
    public boolean hasPrevious() {
        return this.currentNode != null;
    }

    private AbstractDOMNode findPrevious() {
        AbstractDOMNode abstractDOMNode;
        if (this.currentNode != this.rootNode) {
            short s;
            abstractDOMNode = this.previousNode(this.currentNode);
            while (abstractDOMNode != this.rootNode && (s = this.filter(abstractDOMNode)) != 1) {
                abstractDOMNode = this.previousNode(abstractDOMNode);
            }
        } else {
            abstractDOMNode = null;
        }
        return abstractDOMNode;
    }

    private AbstractDOMNode previousNode(AbstractDOMNode abstractDOMNode) {
        AbstractDOMNode abstractDOMNode2 = abstractDOMNode.previousSibling;
        if (abstractDOMNode2 == null) {
            abstractDOMNode2 = abstractDOMNode.parentNode();
        } else {
            while (true) {
                AbstractDOMNode abstractDOMNode3;
                short s;
                if ((s = this.filter(abstractDOMNode2)) != 2) {
                    abstractDOMNode3 = abstractDOMNode2.getNodeList().getLast();
                    if (abstractDOMNode3 == null) break;
                    abstractDOMNode2 = abstractDOMNode3;
                    continue;
                }
                abstractDOMNode3 = abstractDOMNode2.previousSibling;
                if (abstractDOMNode3 == null) break;
                abstractDOMNode2 = abstractDOMNode3;
            }
        }
        return abstractDOMNode2;
    }

    @Override
    public DOMNode previous() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        --this.currentIndex;
        this.last = this.currentNode;
        AbstractDOMNode abstractDOMNode = this.findPrevious();
        this.currentNode = abstractDOMNode != this.rootNode || this.isAccepted(abstractDOMNode) ? abstractDOMNode : null;
        return this.last;
    }

    @Override
    public DOMNode previousNode() {
        try {
            return this.previous();
        }
        catch (NoSuchElementException noSuchElementException) {
            return null;
        }
    }

    @Override
    public int nextIndex() {
        return this.currentIndex;
    }

    @Override
    public int previousIndex() {
        return this.currentIndex - 1;
    }

    @Override
    public void remove() {
        if (this.last != null && this.last != this.rootNode) {
            AbstractDOMNode abstractDOMNode = this.last.parentNode();
            if (abstractDOMNode == null) {
                throw new IllegalStateException("Node to remove has no parent.");
            }
            if (this.currentNode != this.rootNode) {
                if (this.currentNode != this.last) {
                    if (this.last != this.findNext()) {
                        throw new IllegalStateException();
                    }
                } else {
                    this.currentNode = this.previousNode(this.last);
                    --this.currentIndex;
                }
            } else if (this.last != this.findNext()) {
                throw new IllegalStateException();
            }
            if (this.last.getNodeType() != 2) {
                abstractDOMNode.removeChild(this.last);
            } else {
                abstractDOMNode.getAttributes().removeNamedItemNS(this.last.getNamespaceURI(), this.last.getLocalName());
            }
        } else {
            throw new IllegalStateException();
        }
        this.last = null;
    }

    @Override
    public void set(Node node) {
        AbstractDOMNode abstractDOMNode;
        if (this.last != null && this.last != this.rootNode && (abstractDOMNode = this.last.parentNode()) != null) {
            AbstractDOMNode abstractDOMNode2 = (AbstractDOMNode)node;
            if (this.last.getNodeType() != 2) {
                abstractDOMNode.replaceChild(node, this.last);
                if (!this.isAccepted(abstractDOMNode2)) {
                    abstractDOMNode.replaceChild(this.last, abstractDOMNode2);
                    throw new IllegalArgumentException("Not part of the logical tree.");
                }
            } else {
                if (node.getNodeType() != 2) {
                    throw new DOMException(3, "Not an attribute.");
                }
                DOMElement.MyNamedNodeMap myNamedNodeMap = ((DOMElement)abstractDOMNode).nodeMap;
                myNamedNodeMap.replaceItem((DOMAttr)node, (DOMAttr)this.last);
                if (!this.isAccepted(abstractDOMNode2)) {
                    myNamedNodeMap.replaceItem((DOMAttr)this.last, (DOMAttr)node);
                    throw new IllegalArgumentException("Not part of the logical tree.");
                }
            }
            if (this.currentNode == this.last) {
                this.currentNode = abstractDOMNode2;
            }
        } else {
            throw new IllegalStateException();
        }
        this.last = null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void add(Node node) {
        AbstractDOMNode abstractDOMNode = (AbstractDOMNode)node;
        if (this.currentNode == null) {
            throw new IllegalStateException();
        }
        short s = this.currentNode.getNodeType();
        if (s != 1 && s != 9) {
            AbstractDOMNode abstractDOMNode2 = this.currentNode.parentNode();
            if (abstractDOMNode2 == null) throw new IllegalStateException("Collection was modified outside of this iterator.");
            if (this.currentNode.getNodeType() != 2) {
                abstractDOMNode2.insertAfter(abstractDOMNode, this.currentNode);
            } else {
                if (node.getNodeType() != 2) {
                    throw new DOMException(3, "Not an attribute.");
                }
                ((DOMElement)abstractDOMNode2).nodeMap.insertAfter((DOMAttr)abstractDOMNode, this.currentNode);
            }
        } else {
            this.currentNode.insertBefore(abstractDOMNode, this.currentNode.getNodeList().getFirst());
        }
        this.currentNode = abstractDOMNode;
        if (!this.isAccepted(abstractDOMNode)) {
            this.currentNode = this.findPrevious();
        } else {
            ++this.currentIndex;
        }
        this.last = null;
    }

    @Override
    public org.w3c.dom.traversal.NodeFilter getFilter() {
        if (this.nodeFilter instanceof org.w3c.dom.traversal.NodeFilter) {
            return (org.w3c.dom.traversal.NodeFilter)((Object)this.nodeFilter);
        }
        return null;
    }

    @Override
    public boolean getExpandEntityReferences() {
        return false;
    }

    @Override
    public void detach() {
    }
}

