gap> START_TEST( "Irreps of degree k test" );
gap> TestPrint := function(rho); Print(rho.name, " : ", rho.degree, " ", rho.level, " ", Trace(rho.S), " ", Trace(rho.T), "\n"); end;;
gap> test := SL2IrrepsOfDegree(1);; for rho in test do TestPrint(rho); od;
Xi_0 : 1 1 1 1
Xi_6 : 1 2 -1 -1
Xi_4 : 1 3 1 E(3)
Xi_8 : 1 3 1 E(3)^2
Xi_3 : 1 4 -E(4) E(4)
Xi_9 : 1 4 E(4) -E(4)
Xi_2 : 1 6 -1 -E(3)^2
Xi_10 : 1 6 -1 -E(3)
Xi_1 : 1 12 E(4) -E(12)^7
Xi_5 : 1 12 E(4) -E(12)^11
Xi_7 : 1 12 -E(4) E(12)^7
Xi_11 : 1 12 -E(4) E(12)^11
gap> test := SL2IrrepsOfDegree(6);; for rho in test do TestPrint(rho); od;
D_1([0,1]) : 6 5 0 1
N_1(nu) tensor N_1(nu) : 6 6 0 0
N_1([0,2]) : 6 7 2 -1
N_1([0,3]) : 6 7 0 -1
N_1([0,1]) : 6 7 0 -1
D_3([1,0])+ : 6 8 0 E(8)-E(8)^3
D_3([1,0])- : 6 8 0 -E(8)+E(8)^3
D_3([1,1])+ : 6 8 0 E(8)+E(8)^3
D_3([1,1])- : 6 8 0 -E(8)-E(8)^3
R_3^0(1,3,nu)_1 : 6 8 0 0
Xi_9 tensor R_3^0(1,3,nu)_1 : 6 8 0 0
N_2([1,0]) : 6 9 2 0
N_2([1,2]) : 6 9 -2 0
N_2([1,1]) : 6 9 0 0
N_2([2,1]) : 6 9 0 0
D_1([0,1]) tensor Xi_6 : 6 10 0 -1
R_1(1)+ tensor N_1(nu) : 6 10 0 0
R_1(2)+ tensor N_1(nu) : 6 10 0 0
R_1(1)+ : 6 11 0 -E(11)^2-E(11)^6-E(11)^7-E(11)^8-E(11)^10
R_1(2)+ : 6 11 0 -E(11)-E(11)^3-E(11)^4-E(11)^5-E(11)^9
N_1(nu) tensor N_2([0,1]) : 6 12 0 0
Xi_6 tensor R_2^0(1,3)_1 tensor R_1(1)+ : 6 12 0 E(3)^2
D_2([1,0])+ tensor N_1([0,1]) : 6 12 0 -E(4)
D_2([1,0])+ tensor R_1(1)+ : 6 12 0 -E(12)^11
Xi_6 tensor R_2^0(1,3)_1 tensor N_1([0,1]) : 6 12 0 1
D_2([1,0])- tensor N_1([0,1]) : 6 12 0 E(4)
D_2([1,0])- tensor R_1(1)+ : 6 12 0 E(12)^11
D_2([1,0])- tensor R_1(2)+ : 6 12 0 E(12)^7
R_2^0(1,3)_1 tensor N_1([0,1]) : 6 12 0 -1
R_2^0(1,3)_1 tensor R_1(1)+ : 6 12 0 -E(3)^2
D_2([1,0])+ tensor R_1(2)+ : 6 12 0 -E(12)^7
R_2^0(1,3)_1 tensor R_1(2)+ : 6 12 0 -E(3)
Xi_6 tensor R_2^0(1,3)_1 tensor R_1(2)+ : 6 12 0 E(3)
R_1(2)- : 6 13 0 E(13)^2+E(13)^5+E(13)^6+E(13)^7+E(13)^8+E(13)^11
R_1(1)- : 6 13 0 E(13)+E(13)^3+E(13)^4+E(13)^9+E(13)^10+E(13)^12
N_1([0,3]) tensor Xi_6 : 6 14 0 1
R_1(3)- tensor N_1(nu) : 6 14 0 0
R_1(1)- tensor N_1(nu) : 6 14 0 0
N_1([0,2]) tensor Xi_6 : 6 14 -2 1
N_1([0,1]) tensor Xi_6 : 6 14 0 1
R_1(2)+ tensor R_1(1)+ : 6 15 0 E(15)^7+E(15)^13
R_1(2)+ tensor N_1([0,1]) : 6 15 0 E(5)+E(5)^4
R_1(2)+ tensor R_1(2)+ : 6 15 0 E(15)^2+E(15)^8
N_1(nu) tensor R_1(1)- : 6 15 0 0
D_1([0,1]) tensor Xi_8 : 6 15 0 E(3)^2
R_1(1)+ tensor N_1([0,1]) : 6 15 0 E(5)^2+E(5)^3
D_1([0,1]) tensor Xi_4 : 6 15 0 E(3)
R_1(1)+ tensor R_1(2)+ : 6 15 0 E(15)^11+E(15)^14
N_1(nu) tensor R_1(2)- : 6 15 0 0
R_1(1)+ tensor R_1(1)+ : 6 15 0 E(15)+E(15)^4
R_4^0(1,3,[1,0])- : 6 16 0 0
R_4^0(3,5,[1,0]) : 6 16 0 0
R_4^0(1,3,[1,1])+ : 6 16 0 0
R_4^0(1,7,[1,1])+ : 6 16 0 0
Xi_6 tensor R_4^2(3,3,[0,1]) : 6 16 0 -1+E(4)
R_4^0(1,5,[1,0]) : 6 16 0 0
R_4^2(3,3,[0,1]) : 6 16 0 1-E(4)
R_4^2(1,3,nu)_1 : 6 16 0 1-E(4)
R_4^0(1,7,[1,1])- : 6 16 0 0
R_4^0(1,7,[1,0])+ : 6 16 0 0
R_4^2(3,1,[0,1]) : 6 16 0 -1-E(4)
R_4^0(1,3,[1,1])- : 6 16 0 0
R_4^0(3,1,[1,1]) : 6 16 0 0
R_4^0(1,1,[1,1]) : 6 16 0 0
R_4^0(1,3,[1,0])+ : 6 16 0 0
Xi_6 tensor R_4^2(1,3,[0,1]) : 6 16 0 -1-E(4)
R_4^2(3,3,nu)_1 : 6 16 0 1+E(4)
R_4^2(1,3,[0,1]) : 6 16 0 1+E(4)
R_4^2(1,1,[0,1]) : 6 16 0 -1+E(4)
R_4^0(1,7,[1,0])- : 6 16 0 0
N_2([1,2]) tensor Xi_6 : 6 18 2 0
N_2([1,0]) tensor Xi_6 : 6 18 -2 0
N_2([1,1]) tensor Xi_6 : 6 18 0 0
N_2([2,1]) tensor Xi_6 : 6 18 0 0
D_1([0,1]) tensor Xi_3 : 6 20 0 E(4)
R_2^0(1,3)_1 tensor R_1(2)- : 6 20 0 E(5)^2+E(5)^3
R_2^0(1,3)_1 tensor R_1(1)- : 6 20 0 E(5)+E(5)^4
D_1([0,1]) tensor Xi_9 : 6 20 0 -E(4)
R_1(1)+ tensor N_2([0,1]) : 6 20 0 0
D_2([1,0])- tensor R_1(2)- : 6 20 0 -E(20)^13-E(20)^17
D_2([1,0])+ tensor R_1(1)- : 6 20 0 E(20)+E(20)^9
D_2([1,0])- tensor R_1(1)- : 6 20 0 -E(20)-E(20)^9
Xi_6 tensor R_2^0(1,3)_1 tensor R_1(1)- : 6 20 0 -E(5)-E(5)^4
D_2([1,0])+ tensor R_1(2)- : 6 20 0 E(20)^13+E(20)^17
Xi_6 tensor R_2^0(1,3)_1 tensor R_1(2)- : 6 20 0 -E(5)^2-E(5)^3
R_1(2)+ tensor N_2([0,1]) : 6 20 0 0
R_1(3)- tensor R_1(1)+ : 6 21 0 -E(21)^2-E(21)^8-E(21)^11
R_1(3)- tensor R_1(2)+ : 6 21 0 -E(21)-E(21)^4-E(21)^16
N_1([0,3]) tensor Xi_4 : 6 21 0 -E(3)
N_1([0,3]) tensor Xi_8 : 6 21 0 -E(3)^2
N_1([0,1]) tensor Xi_8 : 6 21 0 -E(3)^2
N_1([0,1]) tensor Xi_4 : 6 21 0 -E(3)
R_1(1)- tensor N_1([0,1]) : 6 21 0 -E(7)-E(7)^2-E(7)^4
R_1(1)- tensor R_1(1)+ : 6 21 0 -E(21)^5-E(21)^17-E(21)^20
R_1(1)- tensor R_1(2)+ : 6 21 0 -E(21)^10-E(21)^13-E(21)^19
N_1([0,2]) tensor Xi_4 : 6 21 2 -E(3)
N_1([0,2]) tensor Xi_8 : 6 21 2 -E(3)^2
R_1(3)- tensor N_1([0,1]) : 6 21 0 -E(7)^3-E(7)^5-E(7)^6
R_1(2)+ tensor Xi_6 : 6 22 0 E(11)+E(11)^3+E(11)^4+E(11)^5+E(11)^9
R_1(1)+ tensor Xi_6 : 6 22 0 E(11)^2+E(11)^6+E(11)^7+E(11)^8+E(11)^10
N_1(nu) tensor N_3([1,3])- : 6 24 0 0
R_3^0(1,5,[0,1]) tensor N_1([0,1]) : 6 24 0 E(4)
N_1(nu) tensor N_3([1,0])+ : 6 24 0 0
R_3^0(1,1,[0,1]) tensor R_1(1)+ : 6 24 0 -E(12)^11
R_3^0(1,7,[0,1])- tensor R_1(2)+ : 6 24 0 -E(3)
N_1(nu) tensor N_3([1,0])- : 6 24 0 0
R_3^0(1,7,[0,1])- tensor N_1([0,1]) : 6 24 0 -1
N_1(nu) tensor N_3([1,3])+ : 6 24 0 0
R_3^0(1,7,[0,1])+ tensor R_1(2)+ : 6 24 0 -E(3)
R_3^0(1,1,[0,1]) tensor R_1(2)+ : 6 24 0 -E(12)^7
R_3^0(1,5,[0,1]) tensor R_1(1)+ : 6 24 0 E(12)^11
R_3^0(1,5,[0,1]) tensor R_1(2)+ : 6 24 0 E(12)^7
R_3^0(1,7,[0,1])+ tensor R_1(1)+ : 6 24 0 -E(3)^2
R_3^0(3,1,[0,1]) tensor N_1([0,1]) : 6 24 0 E(4)
D_3([1,0])+ tensor Xi_4 : 6 24 0 E(24)^11-E(24)^17
R_3^0(3,5,[0,1]) tensor N_1([0,1]) : 6 24 0 -E(4)
D_3([1,0])- tensor Xi_4 : 6 24 0 -E(24)^11+E(24)^17
D_3([1,0])- tensor Xi_8 : 6 24 0 E(24)-E(24)^19
R_3^0(1,3,[0,1])+ tensor R_1(2)+ : 6 24 0 E(3)
R_3^0(1,7,[0,1])+ tensor N_1([0,1]) : 6 24 0 -1
R_3^0(1,7,[0,1])- tensor R_1(1)+ : 6 24 0 -E(3)^2
Xi_9 tensor R_3^0(1,3,nu)_1 tensor Xi_4 : 6 24 0 0
R_3^0(1,3,[0,1])- tensor N_1([0,1]) : 6 24 0 1
R_3^0(1,3,[0,1])- tensor R_1(1)+ : 6 24 0 E(3)^2
R_3^0(3,1,[0,1]) tensor R_1(1)+ : 6 24 0 E(12)^11
R_3^0(3,1,[0,1]) tensor R_1(2)+ : 6 24 0 E(12)^7
D_3([1,1])+ tensor Xi_4 : 6 24 0 E(24)^11+E(24)^17
D_3([1,1])+ tensor Xi_8 : 6 24 0 E(24)+E(24)^19
Xi_9 tensor R_3^0(1,3,nu)_1 tensor Xi_8 : 6 24 0 0
R_3^0(1,3,[0,1])+ tensor R_1(1)+ : 6 24 0 E(3)^2
D_3([1,1])- tensor Xi_4 : 6 24 0 -E(24)^11-E(24)^17
D_3([1,1])- tensor Xi_8 : 6 24 0 -E(24)-E(24)^19
R_3^0(1,3,[0,1])- tensor R_1(2)+ : 6 24 0 E(3)
R_3^0(1,3,[0,1])+ tensor N_1([0,1]) : 6 24 0 1
R_3^0(3,5,[0,1]) tensor R_1(1)+ : 6 24 0 -E(12)^11
R_3^0(1,3,nu)_1 tensor Xi_8 : 6 24 0 0
R_3^0(3,5,[0,1]) tensor R_1(2)+ : 6 24 0 -E(12)^7
R_3^0(1,1,[0,1]) tensor N_1([0,1]) : 6 24 0 -E(4)
R_3^0(1,3,nu)_1 tensor Xi_4 : 6 24 0 0
D_3([1,0])+ tensor Xi_8 : 6 24 0 -E(24)+E(24)^19
R_1(2)- tensor Xi_6 : 6 26 0 -E(13)^2-E(13)^5-E(13)^6-E(13)^7-E(13)^8-E(13)^11
R_1(1)- tensor Xi_6 : 6 26 0 -E(13)-E(13)^3-E(13)^4-E(13)^9-E(13)^10-E(13)^12
N_1([0,3]) tensor Xi_3 : 6 28 0 -E(4)
N_1([0,3]) tensor Xi_9 : 6 28 0 E(4)
R_1(3)- tensor N_2([0,1]) : 6 28 0 0
N_1([0,1]) tensor Xi_3 : 6 28 0 -E(4)
N_1([0,2]) tensor Xi_3 : 6 28 -2*E(4) -E(4)
N_1([0,1]) tensor Xi_9 : 6 28 0 E(4)
N_1([0,2]) tensor Xi_9 : 6 28 2*E(4) E(4)
R_1(1)- tensor N_2([0,1]) : 6 28 0 0
R_1(2)+ tensor N_1(nu) tensor Xi_4 : 6 30 0 0
D_1([0,1]) tensor Xi_2 : 6 30 0 -E(3)^2
R_1(2)+ tensor R_1(2)+ tensor Xi_6 : 6 30 0 -E(15)^2-E(15)^8
R_1(2)+ tensor R_1(1)+ tensor Xi_6 : 6 30 0 -E(15)^7-E(15)^13
R_1(2)+ tensor N_1([0,1]) tensor Xi_6 : 6 30 0 -E(5)-E(5)^4
R_1(2)+ tensor N_1(nu) tensor Xi_8 : 6 30 0 0
R_1(1)+ tensor N_1(nu) tensor Xi_4 : 6 30 0 0
R_1(1)+ tensor R_1(2)+ tensor Xi_6 : 6 30 0 -E(15)^11-E(15)^14
R_1(1)+ tensor R_1(1)+ tensor Xi_6 : 6 30 0 -E(15)-E(15)^4
R_1(1)+ tensor N_1([0,1]) tensor Xi_6 : 6 30 0 -E(5)^2-E(5)^3
N_1(nu) tensor R_1(2)- tensor Xi_6 : 6 30 0 0
N_1(nu) tensor R_1(1)- tensor Xi_6 : 6 30 0 0
D_1([0,1]) tensor Xi_10 : 6 30 0 -E(3)
R_1(1)+ tensor N_1(nu) tensor Xi_8 : 6 30 0 0
R_5^2(3,5,[1,1])+ : 6 32 0 E(8)^2+E(8)^3
R_5^2(1,5,[1,1])+ : 6 32 0 E(8)-E(8)^2
R_5^2(3,7,[1,1])+ : 6 32 0 1+E(8)
R_5^2(3,7,[1,0])+ : 6 32 0 1-E(8)
R_5^2(3,1,[1,0])+ : 6 32 0 -E(8)^2+E(8)^3
R_5^2(1,5,[1,0])- : 6 32 0 E(8)-E(8)^2
R_5^2(3,5,[1,1])- : 6 32 0 E(8)^2-E(8)^3
R_5^2(1,5,[1,1])- : 6 32 0 -E(8)-E(8)^2
R_5^2(3,5,[1,0])- : 6 32 0 E(8)^2+E(8)^3
R_5^2(1,5,[1,0])+ : 6 32 0 -E(8)-E(8)^2
R_5^2(1,3,[1,1])- : 6 32 0 -1+E(8)^3
R_5^2(3,5,[1,0])+ : 6 32 0 E(8)^2-E(8)^3
R_5^2(1,7,[1,0])+ : 6 32 0 1-E(8)^3
R_5^2(3,3,[1,1])+ : 6 32 0 -1-E(8)
R_5^2(3,7,[1,0])- : 6 32 0 1+E(8)
R_5^2(1,3,[1,1])+ : 6 32 0 -1-E(8)^3
R_5^2(1,7,[1,0])- : 6 32 0 1+E(8)^3
R_5^2(3,3,[1,0])+ : 6 32 0 -1+E(8)
R_5^2(1,3,[1,0])- : 6 32 0 -1-E(8)^3
R_5^2(1,7,[1,1])+ : 6 32 0 1+E(8)^3
R_5^2(3,1,[1,1])- : 6 32 0 -E(8)^2+E(8)^3
R_5^2(1,3,[1,0])+ : 6 32 0 -1+E(8)^3
R_5^2(1,1,[1,0])- : 6 32 0 -E(8)+E(8)^2
R_5^2(3,1,[1,0])- : 6 32 0 -E(8)^2-E(8)^3
R_5^2(1,7,[1,1])- : 6 32 0 1-E(8)^3
R_5^2(1,1,[1,1])- : 6 32 0 E(8)+E(8)^2
R_5^2(1,1,[1,0])+ : 6 32 0 E(8)+E(8)^2
R_5^2(1,1,[1,1])+ : 6 32 0 -E(8)+E(8)^2
R_5^2(3,3,[1,1])- : 6 32 0 -1+E(8)
R_5^2(3,1,[1,1])+ : 6 32 0 -E(8)^2-E(8)^3
R_5^2(3,3,[1,0])- : 6 32 0 -1-E(8)
R_5^2(3,7,[1,1])- : 6 32 0 1-E(8)
R_1(1)+ tensor Xi_4 : 6 33 0 -E(33)^2-E(33)^8-E(33)^17-E(33)^29-E(33)^32
R_1(2)+ tensor Xi_4 : 6 33 0 -E(33)^5-E(33)^14-E(33)^20-E(33)^23-E(33)^26
R_1(2)+ tensor Xi_8 : 6 33 0 -E(33)-E(33)^4-E(33)^16-E(33)^25-E(33)^31
R_1(1)+ tensor Xi_8 : 6 33 0 -E(33)^7-E(33)^10-E(33)^13-E(33)^19-E(33)^28
R_1(1)- tensor R_1(1)- : 6 35 0 E(35)^3+E(35)^12+E(35)^13+E(35)^17+E(35)^27
 +E(35)^33
R_1(3)- tensor R_1(2)- : 6 35 0 E(35)+E(35)^4+E(35)^9+E(35)^11+E(35)^16
 +E(35)^29
R_1(3)- tensor R_1(1)- : 6 35 0 E(35)^2+E(35)^8+E(35)^18+E(35)^22+E(35)^23
 +E(35)^32
R_1(1)- tensor R_1(2)- : 6 35 0 E(35)^6+E(35)^19+E(35)^24+E(35)^26+E(35)^31
 +E(35)^34
N_2([1,1]) tensor Xi_3 : 6 36 0 0
N_2([1,1]) tensor Xi_9 : 6 36 0 0
N_2([1,2]) tensor Xi_3 : 6 36 2*E(4) 0
N_2([1,0]) tensor Xi_9 : 6 36 2*E(4) 0
N_2([2,1]) tensor Xi_9 : 6 36 0 0
N_2([1,0]) tensor Xi_3 : 6 36 -2*E(4) 0
N_2([2,1]) tensor Xi_3 : 6 36 0 0
N_2([1,2]) tensor Xi_9 : 6 36 -2*E(4) 0
R_1(2)- tensor Xi_8 : 6 39 0 E(39)^2+E(39)^5+E(39)^8+E(39)^11+E(39)^20
 +E(39)^32
R_1(2)- tensor Xi_4 : 6 39 0 E(39)^7+E(39)^19+E(39)^28+E(39)^31+E(39)^34
 +E(39)^37
R_1(1)- tensor Xi_8 : 6 39 0 E(39)^14+E(39)^17+E(39)^23+E(39)^29+E(39)^35
 +E(39)^38
R_1(1)- tensor Xi_4 : 6 39 0 E(39)+E(39)^4+E(39)^10+E(39)^16+E(39)^22+E(39)^25
R_3^0(1,5,[0,1]) tensor R_1(1)- : 6 40 0 -E(20)-E(20)^9
R_1(2)+ tensor N_3([1,3])+ : 6 40 0 E(40)^7-E(40)^13+E(40)^23-E(40)^37
R_3^0(1,7,[0,1])- tensor R_1(2)- : 6 40 0 E(5)^2+E(5)^3
R_1(1)+ tensor N_3([1,0])+ : 6 40 0 -E(40)^21-E(40)^29-E(40)^31-E(40)^39
R_3^0(1,1,[0,1]) tensor R_1(1)- : 6 40 0 E(20)+E(20)^9
R_3^0(1,7,[0,1])+ tensor R_1(2)- : 6 40 0 E(5)^2+E(5)^3
R_3^0(1,7,[0,1])+ tensor R_1(1)- : 6 40 0 E(5)+E(5)^4
R_3^0(1,3,[0,1])- tensor R_1(2)- : 6 40 0 -E(5)^2-E(5)^3
R_3^0(1,1,[0,1]) tensor R_1(2)- : 6 40 0 E(20)^13+E(20)^17
R_1(2)+ tensor N_3([1,0])- : 6 40 0 E(40)^7+E(40)^13+E(40)^23+E(40)^37
R_3^0(1,3,[0,1])- tensor R_1(1)- : 6 40 0 -E(5)-E(5)^4
R_3^0(3,5,[0,1]) tensor R_1(2)- : 6 40 0 E(20)^13+E(20)^17
R_3^0(3,1,[0,1]) tensor R_1(1)- : 6 40 0 -E(20)-E(20)^9
R_3^0(1,3,[0,1])+ tensor R_1(2)- : 6 40 0 -E(5)^2-E(5)^3
R_3^0(3,1,[0,1]) tensor R_1(2)- : 6 40 0 -E(20)^13-E(20)^17
R_1(1)+ tensor N_3([1,3])- : 6 40 0 E(40)^21+E(40)^29-E(40)^31-E(40)^39
R_3^0(1,5,[0,1]) tensor R_1(2)- : 6 40 0 -E(20)^13-E(20)^17
R_1(1)+ tensor N_3([1,3])+ : 6 40 0 -E(40)^21-E(40)^29+E(40)^31+E(40)^39
R_1(1)+ tensor N_3([1,0])- : 6 40 0 E(40)^21+E(40)^29+E(40)^31+E(40)^39
R_1(2)+ tensor N_3([1,3])- : 6 40 0 -E(40)^7+E(40)^13-E(40)^23+E(40)^37
R_3^0(3,5,[0,1]) tensor R_1(1)- : 6 40 0 E(20)+E(20)^9
R_1(2)+ tensor N_3([1,0])+ : 6 40 0 -E(40)^7-E(40)^13-E(40)^23-E(40)^37
R_3^0(1,7,[0,1])- tensor R_1(1)- : 6 40 0 E(5)+E(5)^4
R_3^0(1,3,[0,1])+ tensor R_1(1)- : 6 40 0 -E(5)-E(5)^4
R_1(3)- tensor N_1(nu) tensor Xi_4 : 6 42 0 0
N_1([0,3]) tensor Xi_10 : 6 42 0 E(3)
R_1(1)- tensor N_1([0,1]) tensor Xi_6 : 6 42 0 E(7)+E(7)^2+E(7)^4
N_1([0,2]) tensor Xi_10 : 6 42 -2 E(3)
R_1(1)- tensor R_1(1)+ tensor Xi_6 : 6 42 0 E(21)^5+E(21)^17+E(21)^20
R_1(3)- tensor N_1(nu) tensor Xi_8 : 6 42 0 0
R_1(1)- tensor R_1(2)+ tensor Xi_6 : 6 42 0 E(21)^10+E(21)^13+E(21)^19
N_1([0,3]) tensor Xi_2 : 6 42 0 E(3)^2
N_1([0,2]) tensor Xi_2 : 6 42 -2 E(3)^2
R_1(1)- tensor N_1(nu) tensor Xi_4 : 6 42 0 0
R_1(1)- tensor N_1(nu) tensor Xi_8 : 6 42 0 0
N_1([0,1]) tensor Xi_2 : 6 42 0 E(3)^2
R_1(3)- tensor N_1([0,1]) tensor Xi_6 : 6 42 0 E(7)^3+E(7)^5+E(7)^6
R_1(3)- tensor R_1(1)+ tensor Xi_6 : 6 42 0 E(21)^2+E(21)^8+E(21)^11
R_1(3)- tensor R_1(2)+ tensor Xi_6 : 6 42 0 E(21)+E(21)^4+E(21)^16
N_1([0,1]) tensor Xi_10 : 6 42 0 E(3)
R_1(1)+ tensor Xi_3 : 6 44 0 -E(44)^7-E(44)^19-E(44)^35-E(44)^39-E(44)^43
R_1(2)+ tensor Xi_3 : 6 44 0 -E(44)^3-E(44)^15-E(44)^23-E(44)^27-E(44)^31
R_1(2)+ tensor Xi_9 : 6 44 0 E(44)^3+E(44)^15+E(44)^23+E(44)^27+E(44)^31
R_1(1)+ tensor Xi_9 : 6 44 0 E(44)^7+E(44)^19+E(44)^35+E(44)^39+E(44)^43
R_4^0(1,7,[1,0])- tensor Xi_4 : 6 48 0 0
R_4^0(3,1,[1,0])- tensor R_1(2)+ : 6 48 0 E(24)^17
R_4^0(3,1,[1,2])+ tensor N_1([0,1]) : 6 48 0 E(8)^3
R_4^0(1,3,[1,0])- tensor Xi_4 : 6 48 0 0
R_4^0(3,1,[1,2])+ tensor R_1(1)+ : 6 48 0 E(24)
R_4^0(1,3,[1,0])- tensor Xi_8 : 6 48 0 0
R_4^0(3,1,[1,0])- tensor R_1(1)+ : 6 48 0 E(24)
R_4^0(3,1,[1,2])- tensor N_1([0,1]) : 6 48 0 -E(8)^3
R_4^0(1,3,[1,1])+ tensor Xi_8 : 6 48 0 0
R_4^0(3,1,[1,2])- tensor R_1(1)+ : 6 48 0 -E(24)
R_4^0(3,1,[1,2])- tensor R_1(2)+ : 6 48 0 -E(24)^17
R_4^0(1,3,[1,1])- tensor Xi_4 : 6 48 0 0
R_4^0(1,3,[1,1])- tensor Xi_8 : 6 48 0 0
R_4^0(3,1,[1,0])- tensor N_1([0,1]) : 6 48 0 E(8)^3
R_4^0(3,5,[0,1])- tensor R_1(1)+ : 6 48 0 E(24)^19
R_4^0(3,5,[0,1])- tensor R_1(2)+ : 6 48 0 E(24)^11
R_4^0(1,3,[1,0])+ tensor Xi_4 : 6 48 0 0
R_4^0(1,7,[1,0])+ tensor Xi_4 : 6 48 0 0
R_4^0(1,7,[1,0])+ tensor Xi_8 : 6 48 0 0
R_4^0(3,5,[1,0]) tensor Xi_8 : 6 48 0 0
R_4^0(1,3,[1,0])+ tensor Xi_8 : 6 48 0 0
R_4^0(1,7,[1,0])- tensor Xi_8 : 6 48 0 0
R_4^0(1,5,[0,1])+ tensor N_1([0,1]) : 6 48 0 -E(8)^3
R_4^0(3,5,[2,1])+ tensor N_1([0,1]) : 6 48 0 E(8)
R_4^0(1,5,[0,1])+ tensor R_1(1)+ : 6 48 0 -E(24)
R_4^0(1,5,[0,1])+ tensor R_1(2)+ : 6 48 0 -E(24)^17
R_4^0(3,5,[2,1])+ tensor R_1(1)+ : 6 48 0 E(24)^19
R_4^0(1,7,[1,1])+ tensor Xi_4 : 6 48 0 0
R_4^0(1,5,[0,1])- tensor N_1([0,1]) : 6 48 0 E(8)^3
R_4^0(3,5,[1,0]) tensor Xi_4 : 6 48 0 0
R_4^0(1,7,[1,1])+ tensor Xi_8 : 6 48 0 0
R_4^0(1,7,[1,1])- tensor Xi_4 : 6 48 0 0
R_4^0(1,5,[0,1])- tensor R_1(2)+ : 6 48 0 E(24)^17
R_4^0(1,7,[1,1])- tensor Xi_8 : 6 48 0 0
R_4^0(1,5,[1,0]) tensor Xi_8 : 6 48 0 0
R_4^0(3,5,[2,1])+ tensor R_1(2)+ : 6 48 0 E(24)^11
R_4^0(3,5,[2,1])- tensor N_1([0,1]) : 6 48 0 -E(8)
R_4^2(1,1,[0,1]) tensor Xi_4 : 6 48 0 -E(12)^4+E(12)^7
R_4^0(1,5,[1,0]) tensor Xi_4 : 6 48 0 0
R_4^0(3,1,[1,0])+ tensor R_1(2)+ : 6 48 0 -E(24)^17
R_4^2(1,1,[0,1]) tensor Xi_8 : 6 48 0 -E(12)^8+E(12)^11
R_4^2(1,3,[0,1]) tensor Xi_4 : 6 48 0 E(12)^4+E(12)^7
R_4^0(3,1,[1,0])+ tensor R_1(1)+ : 6 48 0 -E(24)
R_4^0(3,1,[1,1]) tensor Xi_8 : 6 48 0 0
R_4^0(3,1,[1,0])+ tensor N_1([0,1]) : 6 48 0 -E(8)^3
R_4^0(3,5,[2,1])- tensor R_1(1)+ : 6 48 0 -E(24)^19
R_4^0(3,5,[2,1])- tensor R_1(2)+ : 6 48 0 -E(24)^11
R_4^0(1,5,[2,1])+ tensor N_1([0,1]) : 6 48 0 E(8)^3
R_4^2(1,3,[0,1]) tensor Xi_8 : 6 48 0 E(12)^8+E(12)^11
R_4^0(1,1,[1,0])+ tensor N_1([0,1]) : 6 48 0 -E(8)
R_4^0(1,5,[2,1])+ tensor R_1(1)+ : 6 48 0 E(24)
R_4^0(1,5,[2,1])+ tensor R_1(2)+ : 6 48 0 E(24)^17
R_4^2(3,3,[0,1]) tensor Xi_8 : 6 48 0 E(12)^8-E(12)^11
R_4^0(1,1,[1,0])+ tensor R_1(1)+ : 6 48 0 -E(24)^19
R_4^0(1,1,[1,0])+ tensor R_1(2)+ : 6 48 0 -E(24)^11
R_4^2(1,3,nu)_1 tensor Xi_8 : 6 48 0 E(12)^8-E(12)^11
R_4^2(3,3,nu)_1 tensor Xi_4 : 6 48 0 E(12)^4+E(12)^7
R_4^0(1,1,[1,2])- tensor R_1(2)+ : 6 48 0 -E(24)^11
R_4^0(1,1,[1,2])+ tensor R_1(1)+ : 6 48 0 E(24)^19
R_4^0(1,3,[1,1])+ tensor Xi_4 : 6 48 0 0
R_4^2(3,3,nu)_1 tensor Xi_8 : 6 48 0 E(12)^8+E(12)^11
R_4^2(3,1,[0,1]) tensor Xi_4 : 6 48 0 -E(12)^4-E(12)^7
R_4^0(3,5,[0,1])+ tensor N_1([0,1]) : 6 48 0 -E(8)
R_4^0(3,5,[0,1])+ tensor R_1(1)+ : 6 48 0 -E(24)^19
R_4^2(3,1,[0,1]) tensor Xi_8 : 6 48 0 -E(12)^8-E(12)^11
R_4^0(3,5,[0,1])+ tensor R_1(2)+ : 6 48 0 -E(24)^11
R_4^2(3,3,[0,1]) tensor Xi_4 : 6 48 0 E(12)^4-E(12)^7
Xi_6 tensor R_4^2(3,3,[0,1]) tensor Xi_4 : 6 48 0 -E(12)^4+E(12)^7
R_4^0(1,1,[1,2])- tensor R_1(1)+ : 6 48 0 -E(24)^19
R_4^0(1,1,[1,1]) tensor Xi_4 : 6 48 0 0
Xi_6 tensor R_4^2(3,3,[0,1]) tensor Xi_8 : 6 48 0 -E(12)^8+E(12)^11
R_4^2(1,3,nu)_1 tensor Xi_4 : 6 48 0 E(12)^4-E(12)^7
R_4^0(1,1,[1,1]) tensor Xi_8 : 6 48 0 0
R_4^0(3,1,[1,2])+ tensor R_1(2)+ : 6 48 0 E(24)^17
R_4^0(1,1,[1,2])- tensor N_1([0,1]) : 6 48 0 -E(8)
R_4^0(1,1,[1,2])+ tensor R_1(2)+ : 6 48 0 E(24)^11
R_4^0(3,1,[1,1]) tensor Xi_4 : 6 48 0 0
R_4^0(1,1,[1,0])- tensor N_1([0,1]) : 6 48 0 E(8)
R_4^0(1,1,[1,0])- tensor R_1(1)+ : 6 48 0 E(24)^19
R_4^0(1,1,[1,2])+ tensor N_1([0,1]) : 6 48 0 E(8)
R_4^0(1,5,[0,1])- tensor R_1(1)+ : 6 48 0 E(24)
R_4^0(1,5,[2,1])- tensor N_1([0,1]) : 6 48 0 -E(8)^3
R_4^0(1,1,[1,0])- tensor R_1(2)+ : 6 48 0 E(24)^11
Xi_6 tensor R_4^2(1,3,[0,1]) tensor Xi_4 : 6 48 0 -E(12)^4-E(12)^7
Xi_6 tensor R_4^2(1,3,[0,1]) tensor Xi_8 : 6 48 0 -E(12)^8-E(12)^11
R_4^0(1,5,[2,1])- tensor R_1(1)+ : 6 48 0 -E(24)
R_4^0(1,5,[2,1])- tensor R_1(2)+ : 6 48 0 -E(24)^17
R_4^0(3,5,[0,1])- tensor N_1([0,1]) : 6 48 0 E(8)
R_1(1)- tensor Xi_9 : 6 52 0 -E(52)-E(52)^9-E(52)^17-E(52)^25-E(52)^29
 -E(52)^49
R_1(2)- tensor Xi_9 : 6 52 0 -E(52)^5-E(52)^21-E(52)^33-E(52)^37-E(52)^41
 -E(52)^45
R_1(2)- tensor Xi_3 : 6 52 0 E(52)^5+E(52)^21+E(52)^33+E(52)^37+E(52)^41
 +E(52)^45
R_1(1)- tensor Xi_3 : 6 52 0 E(52)+E(52)^9+E(52)^17+E(52)^25+E(52)^29+E(52)^49
R_1(3)- tensor N_3([1,0])+ : 6 56 0 E(56)^5+E(56)^13+E(56)^31+E(56)^45
 +E(56)^47+E(56)^55
R_1(3)- tensor N_3([1,3])+ : 6 56 0 -E(56)^5-E(56)^13+E(56)^31-E(56)^45
 +E(56)^47+E(56)^55
R_1(1)- tensor N_3([1,0])+ : 6 56 0 E(56)^15+E(56)^23+E(56)^29+E(56)^37
 +E(56)^39+E(56)^53
R_1(1)- tensor N_3([1,0])- : 6 56 0 -E(56)^15-E(56)^23-E(56)^29-E(56)^37
 -E(56)^39-E(56)^53
R_1(1)- tensor N_3([1,3])+ : 6 56 0 E(56)^15+E(56)^23-E(56)^29-E(56)^37
 +E(56)^39-E(56)^53
R_1(1)- tensor N_3([1,3])- : 6 56 0 -E(56)^15-E(56)^23+E(56)^29+E(56)^37
 -E(56)^39+E(56)^53
R_1(3)- tensor N_3([1,3])- : 6 56 0 E(56)^5+E(56)^13-E(56)^31+E(56)^45
 -E(56)^47-E(56)^55
R_1(3)- tensor N_3([1,0])- : 6 56 0 -E(56)^5-E(56)^13-E(56)^31-E(56)^45
 -E(56)^47-E(56)^55
D_2([1,0])- tensor R_1(2)- tensor Xi_4 : 6 60 0 -E(60)^11-E(60)^59
R_1(2)+ tensor R_1(1)+ tensor Xi_3 : 6 60 0 E(60)^7+E(60)^43
D_1([0,1]) tensor Xi_7 : 6 60 0 E(12)^7
D_1([0,1]) tensor Xi_5 : 6 60 0 -E(12)^11
R_1(2)+ tensor N_1([0,1]) tensor Xi_9 : 6 60 0 -E(20)-E(20)^9
R_1(2)+ tensor N_1([0,1]) tensor Xi_3 : 6 60 0 E(20)+E(20)^9
D_2([1,0])- tensor R_1(1)- tensor Xi_4 : 6 60 0 -E(60)^23-E(60)^47
D_2([1,0])- tensor R_1(1)- tensor Xi_8 : 6 60 0 -E(60)^7-E(60)^43
D_2([1,0])+ tensor R_1(2)- tensor Xi_4 : 6 60 0 E(60)^11+E(60)^59
D_2([1,0])+ tensor R_1(1)- tensor Xi_8 : 6 60 0 E(60)^7+E(60)^43
D_2([1,0])+ tensor R_1(1)- tensor Xi_4 : 6 60 0 E(60)^23+E(60)^47
R_1(2)+ tensor N_2([0,1]) tensor Xi_8 : 6 60 0 0
D_2([1,0])- tensor R_1(2)- tensor Xi_8 : 6 60 0 -E(60)^19-E(60)^31
R_2^0(1,3)_1 tensor R_1(1)- tensor Xi_4 : 6 60 0 E(15)^2+E(15)^8
R_2^0(1,3)_1 tensor R_1(1)- tensor Xi_8 : 6 60 0 E(15)^7+E(15)^13
R_2^0(1,3)_1 tensor R_1(2)- tensor Xi_4 : 6 60 0 E(15)^11+E(15)^14
D_1([0,1]) tensor Xi_11 : 6 60 0 E(12)^11
R_1(2)+ tensor R_1(2)+ tensor Xi_9 : 6 60 0 -E(60)^23-E(60)^47
R_1(2)+ tensor R_1(1)+ tensor Xi_9 : 6 60 0 -E(60)^7-E(60)^43
R_2^0(1,3)_1 tensor R_1(2)- tensor Xi_8 : 6 60 0 E(15)+E(15)^4
R_1(2)+ tensor N_2([0,1]) tensor Xi_4 : 6 60 0 0
N_1(nu) tensor R_1(1)- tensor Xi_3 : 6 60 0 0
D_2([1,0])+ tensor R_1(2)- tensor Xi_8 : 6 60 0 E(60)^19+E(60)^31
D_1([0,1]) tensor Xi_1 : 6 60 0 -E(12)^7
R_1(1)+ tensor R_1(1)+ tensor Xi_3 : 6 60 0 E(60)^19+E(60)^31
R_1(1)+ tensor R_1(1)+ tensor Xi_9 : 6 60 0 -E(60)^19-E(60)^31
R_1(1)+ tensor N_1([0,1]) tensor Xi_3 : 6 60 0 E(20)^13+E(20)^17
Xi_6 tensor R_2^0(1,3)_1 tensor R_1(2)- tensor Xi_4 : 6 60 0 
-E(15)^11-E(15)^14
R_1(1)+ tensor N_2([0,1]) tensor Xi_4 : 6 60 0 0
R_1(2)+ tensor R_1(2)+ tensor Xi_3 : 6 60 0 E(60)^23+E(60)^47
Xi_6 tensor R_2^0(1,3)_1 tensor R_1(1)- tensor Xi_4 : 6 60 0 -E(15)^2-E(15)^8
R_1(1)+ tensor R_1(2)+ tensor Xi_9 : 6 60 0 -E(60)^11-E(60)^59
R_1(1)+ tensor R_1(2)+ tensor Xi_3 : 6 60 0 E(60)^11+E(60)^59
R_1(1)+ tensor N_1([0,1]) tensor Xi_9 : 6 60 0 -E(20)^13-E(20)^17
Xi_6 tensor R_2^0(1,3)_1 tensor R_1(1)- tensor Xi_8 : 6 60 0 -E(15)^7-E(15)^13
N_1(nu) tensor R_1(1)- tensor Xi_9 : 6 60 0 0
R_1(1)+ tensor N_2([0,1]) tensor Xi_8 : 6 60 0 0
N_1(nu) tensor R_1(2)- tensor Xi_3 : 6 60 0 0
Xi_6 tensor R_2^0(1,3)_1 tensor R_1(2)- tensor Xi_8 : 6 60 0 -E(15)-E(15)^4
N_1(nu) tensor R_1(2)- tensor Xi_9 : 6 60 0 0
R_1(2)+ tensor Xi_10 : 6 66 0 E(33)^5+E(33)^14+E(33)^20+E(33)^23+E(33)^26
R_1(1)+ tensor Xi_2 : 6 66 0 E(33)^7+E(33)^10+E(33)^13+E(33)^19+E(33)^28
R_1(1)+ tensor Xi_10 : 6 66 0 E(33)^2+E(33)^8+E(33)^17+E(33)^29+E(33)^32
R_1(2)+ tensor Xi_2 : 6 66 0 E(33)+E(33)^4+E(33)^16+E(33)^25+E(33)^31
R_1(3)- tensor R_1(1)- tensor Xi_6 : 6 70 0 -E(35)^2-E(35)^8-E(35)^18-E(35)^22
 -E(35)^23-E(35)^32
R_1(1)- tensor R_1(2)- tensor Xi_6 : 6 70 0 -E(35)^6-E(35)^19-E(35)^24
 -E(35)^26-E(35)^31-E(35)^34
R_1(1)- tensor R_1(1)- tensor Xi_6 : 6 70 0 -E(35)^3-E(35)^12-E(35)^13
 -E(35)^17-E(35)^27-E(35)^33
R_1(3)- tensor R_1(2)- tensor Xi_6 : 6 70 0 -E(35)-E(35)^4-E(35)^9-E(35)^11
 -E(35)^16-E(35)^29
R_1(2)- tensor Xi_10 : 6 78 0 -E(39)^7-E(39)^19-E(39)^28-E(39)^31-E(39)^34
 -E(39)^37
R_1(2)- tensor Xi_2 : 6 78 0 -E(39)^2-E(39)^5-E(39)^8-E(39)^11-E(39)^20
 -E(39)^32
R_1(1)- tensor Xi_2 : 6 78 0 -E(39)^14-E(39)^17-E(39)^23-E(39)^29-E(39)^35
 -E(39)^38
R_1(1)- tensor Xi_10 : 6 78 0 -E(39)-E(39)^4-E(39)^10-E(39)^16-E(39)^22
 -E(39)^25
R_4^0(1,5,[0,1])+ tensor R_1(1)- : 6 80 0 E(40)^7+E(40)^23
R_4^0(3,5,[0,1])- tensor R_1(1)- : 6 80 0 -E(40)^13-E(40)^37
R_4^0(3,5,[0,1])- tensor R_1(2)- : 6 80 0 -E(40)^21-E(40)^29
R_4^0(1,5,[2,1])- tensor R_1(2)- : 6 80 0 E(40)^31+E(40)^39
R_4^0(3,5,[2,1])+ tensor R_1(1)- : 6 80 0 -E(40)^13-E(40)^37
R_4^0(3,5,[2,1])+ tensor R_1(2)- : 6 80 0 -E(40)^21-E(40)^29
R_4^0(3,5,[0,1])+ tensor R_1(1)- : 6 80 0 E(40)^13+E(40)^37
R_4^0(3,1,[1,0])- tensor R_1(1)- : 6 80 0 -E(40)^7-E(40)^23
R_4^0(1,5,[0,1])- tensor R_1(1)- : 6 80 0 -E(40)^7-E(40)^23
R_4^0(3,5,[2,1])- tensor R_1(1)- : 6 80 0 E(40)^13+E(40)^37
R_4^0(1,5,[2,1])+ tensor R_1(2)- : 6 80 0 -E(40)^31-E(40)^39
R_4^0(1,5,[0,1])+ tensor R_1(2)- : 6 80 0 E(40)^31+E(40)^39
R_4^0(1,5,[2,1])- tensor R_1(1)- : 6 80 0 E(40)^7+E(40)^23
R_4^0(1,1,[1,0])+ tensor R_1(1)- : 6 80 0 E(40)^13+E(40)^37
R_4^0(1,1,[1,2])+ tensor R_1(2)- : 6 80 0 -E(40)^21-E(40)^29
R_4^0(1,5,[2,1])+ tensor R_1(1)- : 6 80 0 -E(40)^7-E(40)^23
R_4^0(3,1,[1,0])- tensor R_1(2)- : 6 80 0 -E(40)^31-E(40)^39
R_4^0(3,1,[1,0])+ tensor R_1(1)- : 6 80 0 E(40)^7+E(40)^23
R_4^0(3,1,[1,2])+ tensor R_1(1)- : 6 80 0 -E(40)^7-E(40)^23
R_4^0(3,1,[1,0])+ tensor R_1(2)- : 6 80 0 E(40)^31+E(40)^39
R_4^0(1,1,[1,2])- tensor R_1(1)- : 6 80 0 E(40)^13+E(40)^37
R_4^0(1,1,[1,2])- tensor R_1(2)- : 6 80 0 E(40)^21+E(40)^29
R_4^0(1,1,[1,2])+ tensor R_1(1)- : 6 80 0 -E(40)^13-E(40)^37
R_4^0(3,1,[1,2])+ tensor R_1(2)- : 6 80 0 -E(40)^31-E(40)^39
R_4^0(1,1,[1,0])- tensor R_1(1)- : 6 80 0 -E(40)^13-E(40)^37
R_4^0(3,5,[0,1])+ tensor R_1(2)- : 6 80 0 E(40)^21+E(40)^29
R_4^0(3,5,[2,1])- tensor R_1(2)- : 6 80 0 E(40)^21+E(40)^29
R_4^0(1,1,[1,0])+ tensor R_1(2)- : 6 80 0 E(40)^21+E(40)^29
R_4^0(3,1,[1,2])- tensor R_1(2)- : 6 80 0 E(40)^31+E(40)^39
R_4^0(3,1,[1,2])- tensor R_1(1)- : 6 80 0 E(40)^7+E(40)^23
R_4^0(1,5,[0,1])- tensor R_1(2)- : 6 80 0 -E(40)^31-E(40)^39
R_4^0(1,1,[1,0])- tensor R_1(2)- : 6 80 0 -E(40)^21-E(40)^29
R_1(1)- tensor R_1(2)+ tensor Xi_3 : 6 84 0 -E(84)^13-E(84)^61-E(84)^73
N_1([0,1]) tensor Xi_1 : 6 84 0 E(12)^7
N_1([0,1]) tensor Xi_5 : 6 84 0 E(12)^11
N_1([0,1]) tensor Xi_7 : 6 84 0 -E(12)^7
N_1([0,1]) tensor Xi_11 : 6 84 0 -E(12)^11
R_1(1)- tensor R_1(2)+ tensor Xi_9 : 6 84 0 E(84)^13+E(84)^61+E(84)^73
N_1([0,2]) tensor Xi_7 : 6 84 -2*E(4) -E(12)^7
R_1(1)- tensor R_1(1)+ tensor Xi_9 : 6 84 0 E(84)^5+E(84)^17+E(84)^41
R_1(3)- tensor N_2([0,1]) tensor Xi_4 : 6 84 0 0
R_1(1)- tensor N_1([0,1]) tensor Xi_9 : 6 84 0 E(28)^11+E(28)^15+E(28)^23
R_1(1)- tensor N_1([0,1]) tensor Xi_3 : 6 84 0 -E(28)^11-E(28)^15-E(28)^23
R_1(3)- tensor N_2([0,1]) tensor Xi_8 : 6 84 0 0
N_1([0,2]) tensor Xi_11 : 6 84 -2*E(4) -E(12)^11
N_1([0,3]) tensor Xi_11 : 6 84 0 -E(12)^11
N_1([0,3]) tensor Xi_7 : 6 84 0 -E(12)^7
N_1([0,3]) tensor Xi_5 : 6 84 0 E(12)^11
R_1(1)- tensor N_2([0,1]) tensor Xi_4 : 6 84 0 0
R_1(1)- tensor N_2([0,1]) tensor Xi_8 : 6 84 0 0
R_1(1)- tensor R_1(1)+ tensor Xi_3 : 6 84 0 -E(84)^5-E(84)^17-E(84)^41
R_1(3)- tensor N_1([0,1]) tensor Xi_3 : 6 84 0 -E(28)^3-E(28)^19-E(28)^27
R_1(3)- tensor R_1(2)+ tensor Xi_3 : 6 84 0 -E(84)-E(84)^25-E(84)^37
N_1([0,2]) tensor Xi_1 : 6 84 2*E(4) E(12)^7
N_1([0,2]) tensor Xi_5 : 6 84 2*E(4) E(12)^11
R_1(3)- tensor R_1(1)+ tensor Xi_3 : 6 84 0 -E(84)^29-E(84)^53-E(84)^65
R_1(3)- tensor R_1(1)+ tensor Xi_9 : 6 84 0 E(84)^29+E(84)^53+E(84)^65
N_1([0,3]) tensor Xi_1 : 6 84 0 E(12)^7
R_1(3)- tensor N_1([0,1]) tensor Xi_9 : 6 84 0 E(28)^3+E(28)^19+E(28)^27
R_1(3)- tensor R_1(2)+ tensor Xi_9 : 6 84 0 E(84)+E(84)^25+E(84)^37
R_5^2(1,7,[1,0])- tensor Xi_8 : 6 96 0 E(24)+E(24)^16
R_5^2(3,5,[1,1])- tensor Xi_4 : 6 96 0 E(24)^14-E(24)^17
R_5^2(1,7,[1,1])- tensor Xi_8 : 6 96 0 -E(24)+E(24)^16
R_5^2(3,5,[1,1])- tensor Xi_8 : 6 96 0 -E(24)+E(24)^22
R_5^2(3,7,[1,0])+ tensor Xi_4 : 6 96 0 E(24)^8-E(24)^11
R_5^2(3,1,[1,0])- tensor Xi_4 : 6 96 0 -E(24)^14-E(24)^17
R_5^2(3,1,[1,0])- tensor Xi_8 : 6 96 0 -E(24)-E(24)^22
R_5^2(3,7,[1,0])+ tensor Xi_8 : 6 96 0 E(24)^16-E(24)^19
R_5^2(1,7,[1,1])- tensor Xi_4 : 6 96 0 E(24)^8-E(24)^17
R_5^2(3,7,[1,0])- tensor Xi_4 : 6 96 0 E(24)^8+E(24)^11
R_5^2(3,5,[1,1])+ tensor Xi_8 : 6 96 0 E(24)+E(24)^22
R_5^2(1,7,[1,1])+ tensor Xi_8 : 6 96 0 E(24)+E(24)^16
R_5^2(3,5,[1,1])+ tensor Xi_4 : 6 96 0 E(24)^14+E(24)^17
R_5^2(3,7,[1,0])- tensor Xi_8 : 6 96 0 E(24)^16+E(24)^19
R_5^2(1,7,[1,1])+ tensor Xi_4 : 6 96 0 E(24)^8+E(24)^17
R_5^2(3,1,[1,0])+ tensor Xi_4 : 6 96 0 -E(24)^14+E(24)^17
R_5^2(3,5,[1,0])- tensor Xi_8 : 6 96 0 E(24)+E(24)^22
R_5^2(3,3,[1,1])- tensor Xi_8 : 6 96 0 -E(24)^16+E(24)^19
R_5^2(3,7,[1,1])+ tensor Xi_4 : 6 96 0 E(24)^8+E(24)^11
R_5^2(3,7,[1,1])+ tensor Xi_8 : 6 96 0 E(24)^16+E(24)^19
R_5^2(1,7,[1,0])+ tensor Xi_4 : 6 96 0 E(24)^8-E(24)^17
R_5^2(3,7,[1,1])- tensor Xi_4 : 6 96 0 E(24)^8-E(24)^11
R_5^2(3,7,[1,1])- tensor Xi_8 : 6 96 0 E(24)^16-E(24)^19
R_5^2(1,5,[1,1])- tensor Xi_8 : 6 96 0 -E(24)^19-E(24)^22
R_5^2(1,5,[1,1])- tensor Xi_4 : 6 96 0 -E(24)^11-E(24)^14
R_5^2(1,5,[1,1])+ tensor Xi_8 : 6 96 0 E(24)^19-E(24)^22
R_5^2(1,5,[1,1])+ tensor Xi_4 : 6 96 0 E(24)^11-E(24)^14
R_5^2(3,1,[1,1])+ tensor Xi_8 : 6 96 0 -E(24)-E(24)^22
R_5^2(3,1,[1,1])- tensor Xi_4 : 6 96 0 -E(24)^14+E(24)^17
R_5^2(1,5,[1,0])- tensor Xi_8 : 6 96 0 E(24)^19-E(24)^22
R_5^2(3,5,[1,0])- tensor Xi_4 : 6 96 0 E(24)^14+E(24)^17
R_5^2(3,1,[1,1])- tensor Xi_8 : 6 96 0 E(24)-E(24)^22
R_5^2(1,5,[1,0])- tensor Xi_4 : 6 96 0 E(24)^11-E(24)^14
R_5^2(1,5,[1,0])+ tensor Xi_8 : 6 96 0 -E(24)^19-E(24)^22
R_5^2(1,5,[1,0])+ tensor Xi_4 : 6 96 0 -E(24)^11-E(24)^14
R_5^2(1,3,[1,1])- tensor Xi_8 : 6 96 0 E(24)-E(24)^16
R_5^2(3,5,[1,0])+ tensor Xi_8 : 6 96 0 -E(24)+E(24)^22
R_5^2(3,3,[1,0])+ tensor Xi_4 : 6 96 0 -E(24)^8+E(24)^11
R_5^2(1,3,[1,1])- tensor Xi_4 : 6 96 0 -E(24)^8+E(24)^17
R_5^2(3,3,[1,0])+ tensor Xi_8 : 6 96 0 -E(24)^16+E(24)^19
R_5^2(1,1,[1,0])+ tensor Xi_4 : 6 96 0 E(24)^11+E(24)^14
R_5^2(1,3,[1,1])+ tensor Xi_8 : 6 96 0 -E(24)-E(24)^16
R_5^2(1,3,[1,1])+ tensor Xi_4 : 6 96 0 -E(24)^8-E(24)^17
R_5^2(1,3,[1,0])- tensor Xi_8 : 6 96 0 -E(24)-E(24)^16
R_5^2(1,3,[1,0])- tensor Xi_4 : 6 96 0 -E(24)^8-E(24)^17
R_5^2(3,1,[1,0])+ tensor Xi_8 : 6 96 0 E(24)-E(24)^22
R_5^2(1,1,[1,0])+ tensor Xi_8 : 6 96 0 E(24)^19+E(24)^22
R_5^2(1,3,[1,0])+ tensor Xi_8 : 6 96 0 E(24)-E(24)^16
R_5^2(3,3,[1,0])- tensor Xi_8 : 6 96 0 -E(24)^16-E(24)^19
R_5^2(3,3,[1,1])+ tensor Xi_4 : 6 96 0 -E(24)^8-E(24)^11
R_5^2(1,3,[1,0])+ tensor Xi_4 : 6 96 0 -E(24)^8+E(24)^17
R_5^2(1,1,[1,1])- tensor Xi_8 : 6 96 0 E(24)^19+E(24)^22
R_5^2(1,1,[1,1])- tensor Xi_4 : 6 96 0 E(24)^11+E(24)^14
R_5^2(1,1,[1,1])+ tensor Xi_8 : 6 96 0 -E(24)^19+E(24)^22
R_5^2(3,3,[1,1])+ tensor Xi_8 : 6 96 0 -E(24)^16-E(24)^19
R_5^2(3,3,[1,1])- tensor Xi_4 : 6 96 0 -E(24)^8+E(24)^11
R_5^2(1,1,[1,1])+ tensor Xi_4 : 6 96 0 -E(24)^11+E(24)^14
R_5^2(3,5,[1,0])+ tensor Xi_4 : 6 96 0 E(24)^14-E(24)^17
R_5^2(3,1,[1,1])+ tensor Xi_4 : 6 96 0 -E(24)^14-E(24)^17
R_5^2(1,1,[1,0])- tensor Xi_8 : 6 96 0 -E(24)^19+E(24)^22
R_5^2(1,1,[1,0])- tensor Xi_4 : 6 96 0 -E(24)^11+E(24)^14
R_5^2(3,3,[1,0])- tensor Xi_4 : 6 96 0 -E(24)^8-E(24)^11
R_5^2(1,7,[1,0])- tensor Xi_4 : 6 96 0 E(24)^8+E(24)^17
R_5^2(1,7,[1,0])+ tensor Xi_8 : 6 96 0 -E(24)+E(24)^16
R_1(1)- tensor R_1(1)- tensor Xi_8 : 6 105 0 E(105)+E(105)^4+E(105)^16
 +E(105)^46+E(105)^64+E(105)^79
R_1(1)- tensor R_1(2)- tensor Xi_8 : 6 105 0 E(105)^22+E(105)^37+E(105)^43
 +E(105)^58+E(105)^67+E(105)^88
R_1(1)- tensor R_1(2)- tensor Xi_4 : 6 105 0 E(105)^2+E(105)^8+E(105)^23
 +E(105)^32+E(105)^53+E(105)^92
R_1(3)- tensor R_1(2)- tensor Xi_8 : 6 105 0 E(105)^13+E(105)^52+E(105)^73
 +E(105)^82+E(105)^97+E(105)^103
R_1(3)- tensor R_1(2)- tensor Xi_4 : 6 105 0 E(105)^17+E(105)^38+E(105)^47
 +E(105)^62+E(105)^68+E(105)^83
R_1(3)- tensor R_1(1)- tensor Xi_4 : 6 105 0 E(105)^26+E(105)^41+E(105)^59
 +E(105)^89+E(105)^101+E(105)^104
R_1(3)- tensor R_1(1)- tensor Xi_8 : 6 105 0 E(105)^19+E(105)^31+E(105)^34
 +E(105)^61+E(105)^76+E(105)^94
R_1(1)- tensor R_1(1)- tensor Xi_4 : 6 105 0 E(105)^11+E(105)^29+E(105)^44
 +E(105)^71+E(105)^74+E(105)^86
R_3^0(1,3,[0,1])- tensor R_1(1)- tensor Xi_4 : 6 120 0 -E(15)^2-E(15)^8
R_3^0(3,1,[0,1]) tensor R_1(1)- tensor Xi_4 : 6 120 0 -E(60)^23-E(60)^47
R_3^0(1,3,[0,1])+ tensor R_1(1)- tensor Xi_4 : 6 120 0 -E(15)^2-E(15)^8
R_3^0(1,3,[0,1])+ tensor R_1(1)- tensor Xi_8 : 6 120 0 -E(15)^7-E(15)^13
R_3^0(1,3,[0,1])+ tensor R_1(2)- tensor Xi_8 : 6 120 0 -E(15)-E(15)^4
R_3^0(1,3,[0,1])+ tensor R_1(2)- tensor Xi_4 : 6 120 0 -E(15)^11-E(15)^14
R_3^0(3,5,[0,1]) tensor R_1(1)- tensor Xi_8 : 6 120 0 E(60)^7+E(60)^43
R_1(1)+ tensor N_3([1,0])- tensor Xi_4 : 6 120 0 E(120)^7+E(120)^13+E(120)^37
 +E(120)^103
R_1(1)+ tensor N_3([1,0])- tensor Xi_8 : 6 120 0 E(120)^23+E(120)^47+E(120)^53
 +E(120)^77
R_1(1)+ tensor N_3([1,3])+ tensor Xi_4 : 6 120 0 -E(120)^7+E(120)^13+E(120)^37
 -E(120)^103
R_3^0(3,1,[0,1]) tensor R_1(1)- tensor Xi_8 : 6 120 0 -E(60)^7-E(60)^43
R_3^0(3,1,[0,1]) tensor R_1(2)- tensor Xi_4 : 6 120 0 -E(60)^11-E(60)^59
R_3^0(1,3,[0,1])- tensor R_1(1)- tensor Xi_8 : 6 120 0 -E(15)^7-E(15)^13
R_3^0(1,3,[0,1])- tensor R_1(2)- tensor Xi_4 : 6 120 0 -E(15)^11-E(15)^14
R_3^0(1,3,[0,1])- tensor R_1(2)- tensor Xi_8 : 6 120 0 -E(15)-E(15)^4
R_1(1)+ tensor N_3([1,3])+ tensor Xi_8 : 6 120 0 -E(120)^23-E(120)^47
 +E(120)^53+E(120)^77
R_3^0(3,1,[0,1]) tensor R_1(2)- tensor Xi_8 : 6 120 0 -E(60)^19-E(60)^31
R_3^0(1,5,[0,1]) tensor R_1(2)- tensor Xi_4 : 6 120 0 -E(60)^11-E(60)^59
R_3^0(1,7,[0,1])+ tensor R_1(1)- tensor Xi_4 : 6 120 0 E(15)^2+E(15)^8
R_3^0(1,7,[0,1])+ tensor R_1(1)- tensor Xi_8 : 6 120 0 E(15)^7+E(15)^13
R_1(1)+ tensor N_3([1,3])- tensor Xi_4 : 6 120 0 E(120)^7-E(120)^13-E(120)^37
 +E(120)^103
R_3^0(1,7,[0,1])+ tensor R_1(2)- tensor Xi_4 : 6 120 0 E(15)^11+E(15)^14
R_3^0(1,7,[0,1])+ tensor R_1(2)- tensor Xi_8 : 6 120 0 E(15)+E(15)^4
R_1(1)+ tensor N_3([1,3])- tensor Xi_8 : 6 120 0 E(120)^23+E(120)^47-E(120)^53
 -E(120)^77
R_3^0(1,5,[0,1]) tensor R_1(1)- tensor Xi_8 : 6 120 0 -E(60)^7-E(60)^43
R_3^0(1,1,[0,1]) tensor R_1(2)- tensor Xi_8 : 6 120 0 E(60)^19+E(60)^31
R_3^0(1,1,[0,1]) tensor R_1(2)- tensor Xi_4 : 6 120 0 E(60)^11+E(60)^59
R_3^0(1,7,[0,1])- tensor R_1(1)- tensor Xi_4 : 6 120 0 E(15)^2+E(15)^8
R_3^0(1,7,[0,1])- tensor R_1(1)- tensor Xi_8 : 6 120 0 E(15)^7+E(15)^13
R_3^0(1,1,[0,1]) tensor R_1(1)- tensor Xi_8 : 6 120 0 E(60)^7+E(60)^43
R_3^0(3,5,[0,1]) tensor R_1(2)- tensor Xi_8 : 6 120 0 E(60)^19+E(60)^31
R_1(1)+ tensor N_3([1,0])+ tensor Xi_4 : 6 120 0 -E(120)^7-E(120)^13-E(120)^37
 -E(120)^103
R_3^0(3,5,[0,1]) tensor R_1(2)- tensor Xi_4 : 6 120 0 E(60)^11+E(60)^59
R_3^0(3,5,[0,1]) tensor R_1(1)- tensor Xi_4 : 6 120 0 E(60)^23+E(60)^47
R_1(2)+ tensor N_3([1,3])+ tensor Xi_8 : 6 120 0 E(120)^29-E(120)^71
 +E(120)^101-E(120)^119
R_1(2)+ tensor N_3([1,3])+ tensor Xi_4 : 6 120 0 -E(120)^31+E(120)^61
 -E(120)^79+E(120)^109
R_3^0(1,1,[0,1]) tensor R_1(1)- tensor Xi_4 : 6 120 0 E(60)^23+E(60)^47
R_1(2)+ tensor N_3([1,0])- tensor Xi_8 : 6 120 0 E(120)^29+E(120)^71
 +E(120)^101+E(120)^119
R_1(2)+ tensor N_3([1,0])- tensor Xi_4 : 6 120 0 E(120)^31+E(120)^61+E(120)^79
 +E(120)^109
R_1(2)+ tensor N_3([1,0])+ tensor Xi_8 : 6 120 0 -E(120)^29-E(120)^71
 -E(120)^101-E(120)^119
R_1(1)+ tensor N_3([1,0])+ tensor Xi_8 : 6 120 0 -E(120)^23-E(120)^47
 -E(120)^53-E(120)^77
R_1(2)+ tensor N_3([1,0])+ tensor Xi_4 : 6 120 0 -E(120)^31-E(120)^61
 -E(120)^79-E(120)^109
R_3^0(1,5,[0,1]) tensor R_1(2)- tensor Xi_8 : 6 120 0 -E(60)^19-E(60)^31
R_3^0(1,7,[0,1])- tensor R_1(2)- tensor Xi_4 : 6 120 0 E(15)^11+E(15)^14
R_3^0(1,7,[0,1])- tensor R_1(2)- tensor Xi_8 : 6 120 0 E(15)+E(15)^4
R_1(2)+ tensor N_3([1,3])- tensor Xi_8 : 6 120 0 -E(120)^29+E(120)^71
 -E(120)^101+E(120)^119
R_1(2)+ tensor N_3([1,3])- tensor Xi_4 : 6 120 0 E(120)^31-E(120)^61+E(120)^79
 -E(120)^109
R_3^0(1,5,[0,1]) tensor R_1(1)- tensor Xi_4 : 6 120 0 -E(60)^23-E(60)^47
R_1(1)+ tensor Xi_5 : 6 132 0 E(132)^13+E(132)^61+E(132)^73+E(132)^85
 +E(132)^109
R_1(1)+ tensor Xi_7 : 6 132 0 -E(132)^17-E(132)^29-E(132)^41-E(132)^65
 -E(132)^101
R_1(1)+ tensor Xi_11 : 6 132 0 -E(132)^13-E(132)^61-E(132)^73-E(132)^85
 -E(132)^109
R_1(2)+ tensor Xi_1 : 6 132 0 E(132)^5+E(132)^53+E(132)^89+E(132)^113
 +E(132)^125
R_1(1)+ tensor Xi_1 : 6 132 0 E(132)^17+E(132)^29+E(132)^41+E(132)^65
 +E(132)^101
R_1(2)+ tensor Xi_11 : 6 132 0 -E(132)-E(132)^25-E(132)^37-E(132)^49-E(132)^97
R_1(2)+ tensor Xi_7 : 6 132 0 -E(132)^5-E(132)^53-E(132)^89-E(132)^113
 -E(132)^125
R_1(2)+ tensor Xi_5 : 6 132 0 E(132)+E(132)^25+E(132)^37+E(132)^49+E(132)^97
R_1(3)- tensor R_1(1)- tensor Xi_3 : 6 140 0 E(140)^23+E(140)^43+E(140)^67
 +E(140)^107+E(140)^123+E(140)^127
R_1(3)- tensor R_1(2)- tensor Xi_9 : 6 140 0 -E(140)^11-E(140)^39-E(140)^51
 -E(140)^71-E(140)^79-E(140)^99
R_1(3)- tensor R_1(1)- tensor Xi_9 : 6 140 0 -E(140)^23-E(140)^43-E(140)^67
 -E(140)^107-E(140)^123-E(140)^127
R_1(1)- tensor R_1(1)- tensor Xi_3 : 6 140 0 E(140)^3+E(140)^27+E(140)^47
 +E(140)^83+E(140)^87+E(140)^103
R_1(1)- tensor R_1(1)- tensor Xi_9 : 6 140 0 -E(140)^3-E(140)^27-E(140)^47
 -E(140)^83-E(140)^87-E(140)^103
R_1(3)- tensor R_1(2)- tensor Xi_3 : 6 140 0 E(140)^11+E(140)^39+E(140)^51
 +E(140)^71+E(140)^79+E(140)^99
R_1(1)- tensor R_1(2)- tensor Xi_3 : 6 140 0 E(140)^19+E(140)^31+E(140)^59
 +E(140)^111+E(140)^131+E(140)^139
R_1(1)- tensor R_1(2)- tensor Xi_9 : 6 140 0 -E(140)^19-E(140)^31-E(140)^59
 -E(140)^111-E(140)^131-E(140)^139
R_1(1)- tensor Xi_5 : 6 156 0 -E(156)^23-E(156)^35-E(156)^95-E(156)^107
 -E(156)^131-E(156)^155
R_1(1)- tensor Xi_1 : 6 156 0 -E(156)^43-E(156)^55-E(156)^79-E(156)^103
 -E(156)^127-E(156)^139
R_1(2)- tensor Xi_11 : 6 156 0 E(156)^11+E(156)^47+E(156)^59+E(156)^71
 +E(156)^83+E(156)^119
R_1(2)- tensor Xi_7 : 6 156 0 E(156)^7+E(156)^19+E(156)^31+E(156)^67
 +E(156)^115+E(156)^151
R_1(2)- tensor Xi_5 : 6 156 0 -E(156)^11-E(156)^47-E(156)^59-E(156)^71
 -E(156)^83-E(156)^119
R_1(2)- tensor Xi_1 : 6 156 0 -E(156)^7-E(156)^19-E(156)^31-E(156)^67
 -E(156)^115-E(156)^151
R_1(1)- tensor Xi_11 : 6 156 0 E(156)^23+E(156)^35+E(156)^95+E(156)^107
 +E(156)^131+E(156)^155
R_1(1)- tensor Xi_7 : 6 156 0 E(156)^43+E(156)^55+E(156)^79+E(156)^103
 +E(156)^127+E(156)^139
R_1(3)- tensor N_3([1,3])+ tensor Xi_4 : 6 168 0 -E(168)^23+E(168)^29
 +E(168)^53-E(168)^71-E(168)^95+E(168)^149
R_1(3)- tensor N_3([1,3])+ tensor Xi_8 : 6 168 0 E(168)^37-E(168)^79+E(168)^85
 +E(168)^109-E(168)^127-E(168)^151
R_1(3)- tensor N_3([1,3])- tensor Xi_4 : 6 168 0 E(168)^23-E(168)^29-E(168)^53
 +E(168)^71+E(168)^95-E(168)^149
R_1(3)- tensor N_3([1,0])- tensor Xi_8 : 6 168 0 -E(168)^37-E(168)^79
 -E(168)^85-E(168)^109-E(168)^127-E(168)^151
R_1(3)- tensor N_3([1,0])- tensor Xi_4 : 6 168 0 -E(168)^23-E(168)^29
 -E(168)^53-E(168)^71-E(168)^95-E(168)^149
R_1(3)- tensor N_3([1,0])+ tensor Xi_8 : 6 168 0 E(168)^37+E(168)^79+E(168)^85
 +E(168)^109+E(168)^127+E(168)^151
R_1(3)- tensor N_3([1,0])+ tensor Xi_4 : 6 168 0 E(168)^23+E(168)^29+E(168)^53
 +E(168)^71+E(168)^95+E(168)^149
R_1(1)- tensor N_3([1,0])+ tensor Xi_8 : 6 168 0 E(168)^13+E(168)^31+E(168)^55
 +E(168)^61+E(168)^103+E(168)^157
R_1(1)- tensor N_3([1,0])- tensor Xi_4 : 6 168 0 -E(168)^5-E(168)^47
 -E(168)^101-E(168)^125-E(168)^143-E(168)^167
R_1(1)- tensor N_3([1,0])- tensor Xi_8 : 6 168 0 -E(168)^13-E(168)^31
 -E(168)^55-E(168)^61-E(168)^103-E(168)^157
R_1(1)- tensor N_3([1,3])+ tensor Xi_4 : 6 168 0 E(168)^5-E(168)^47+E(168)^101
 +E(168)^125-E(168)^143-E(168)^167
R_1(1)- tensor N_3([1,3])+ tensor Xi_8 : 6 168 0 E(168)^13-E(168)^31-E(168)^55
 +E(168)^61-E(168)^103+E(168)^157
R_1(1)- tensor N_3([1,3])- tensor Xi_4 : 6 168 0 -E(168)^5+E(168)^47
 -E(168)^101-E(168)^125+E(168)^143+E(168)^167
R_1(1)- tensor N_3([1,3])- tensor Xi_8 : 6 168 0 -E(168)^13+E(168)^31
 +E(168)^55-E(168)^61+E(168)^103-E(168)^157
R_1(3)- tensor N_3([1,3])- tensor Xi_8 : 6 168 0 -E(168)^37+E(168)^79
 -E(168)^85-E(168)^109+E(168)^127+E(168)^151
R_1(1)- tensor N_3([1,0])+ tensor Xi_4 : 6 168 0 E(168)^5+E(168)^47+E(168)^101
 +E(168)^125+E(168)^143+E(168)^167
R_1(3)- tensor R_1(1)- tensor Xi_10 : 6 210 0 -E(105)^26-E(105)^41-E(105)^59
 -E(105)^89-E(105)^101-E(105)^104
R_1(3)- tensor R_1(2)- tensor Xi_10 : 6 210 0 -E(105)^17-E(105)^38-E(105)^47
 -E(105)^62-E(105)^68-E(105)^83
R_1(3)- tensor R_1(1)- tensor Xi_2 : 6 210 0 -E(105)^19-E(105)^31-E(105)^34
 -E(105)^61-E(105)^76-E(105)^94
R_1(1)- tensor R_1(2)- tensor Xi_2 : 6 210 0 -E(105)^22-E(105)^37-E(105)^43
 -E(105)^58-E(105)^67-E(105)^88
R_1(3)- tensor R_1(2)- tensor Xi_2 : 6 210 0 -E(105)^13-E(105)^52-E(105)^73
 -E(105)^82-E(105)^97-E(105)^103
R_1(1)- tensor R_1(2)- tensor Xi_10 : 6 210 0 -E(105)^2-E(105)^8-E(105)^23
 -E(105)^32-E(105)^53-E(105)^92
R_1(1)- tensor R_1(1)- tensor Xi_2 : 6 210 0 -E(105)-E(105)^4-E(105)^16
 -E(105)^46-E(105)^64-E(105)^79
R_1(1)- tensor R_1(1)- tensor Xi_10 : 6 210 0 -E(105)^11-E(105)^29-E(105)^44
 -E(105)^71-E(105)^74-E(105)^86
R_4^0(3,1,[1,0])- tensor R_1(1)- tensor Xi_8 : 6 240 0 -E(120)^29-E(120)^101
R_4^0(3,1,[1,2])+ tensor R_1(2)- tensor Xi_8 : 6 240 0 -E(120)^53-E(120)^77
R_4^0(1,1,[1,0])- tensor R_1(2)- tensor Xi_4 : 6 240 0 -E(120)^7-E(120)^103
R_4^0(3,1,[1,0])- tensor R_1(1)- tensor Xi_4 : 6 240 0 -E(120)^61-E(120)^109
R_4^0(3,1,[1,2])- tensor R_1(2)- tensor Xi_4 : 6 240 0 E(120)^13+E(120)^37
R_4^0(3,1,[1,2])+ tensor R_1(1)- tensor Xi_8 : 6 240 0 -E(120)^29-E(120)^101
R_4^0(3,5,[2,1])- tensor R_1(1)- tensor Xi_8 : 6 240 0 E(120)^71+E(120)^119
R_4^0(3,1,[1,2])- tensor R_1(1)- tensor Xi_4 : 6 240 0 E(120)^61+E(120)^109
R_4^0(3,1,[1,2])- tensor R_1(2)- tensor Xi_8 : 6 240 0 E(120)^53+E(120)^77
R_4^0(3,1,[1,0])- tensor R_1(2)- tensor Xi_8 : 6 240 0 -E(120)^53-E(120)^77
R_4^0(3,1,[1,2])- tensor R_1(1)- tensor Xi_8 : 6 240 0 E(120)^29+E(120)^101
R_4^0(3,1,[1,0])+ tensor R_1(2)- tensor Xi_4 : 6 240 0 E(120)^13+E(120)^37
R_4^0(1,5,[0,1])+ tensor R_1(1)- tensor Xi_4 : 6 240 0 E(120)^61+E(120)^109
R_4^0(1,5,[0,1])+ tensor R_1(1)- tensor Xi_8 : 6 240 0 E(120)^29+E(120)^101
R_4^0(3,1,[1,0])+ tensor R_1(2)- tensor Xi_8 : 6 240 0 E(120)^53+E(120)^77
R_4^0(3,1,[1,0])- tensor R_1(2)- tensor Xi_4 : 6 240 0 -E(120)^13-E(120)^37
R_4^0(3,1,[1,2])+ tensor R_1(1)- tensor Xi_4 : 6 240 0 -E(120)^61-E(120)^109
R_4^0(3,1,[1,0])+ tensor R_1(1)- tensor Xi_8 : 6 240 0 E(120)^29+E(120)^101
R_4^0(3,5,[2,1])- tensor R_1(2)- tensor Xi_4 : 6 240 0 E(120)^7+E(120)^103
R_4^0(3,1,[1,2])+ tensor R_1(2)- tensor Xi_4 : 6 240 0 -E(120)^13-E(120)^37
R_4^0(3,5,[2,1])+ tensor R_1(2)- tensor Xi_8 : 6 240 0 -E(120)^23-E(120)^47
R_4^0(1,5,[0,1])- tensor R_1(1)- tensor Xi_4 : 6 240 0 -E(120)^61-E(120)^109
R_4^0(1,5,[0,1])- tensor R_1(1)- tensor Xi_8 : 6 240 0 -E(120)^29-E(120)^101
R_4^0(3,5,[2,1])+ tensor R_1(2)- tensor Xi_4 : 6 240 0 -E(120)^7-E(120)^103
R_4^0(1,5,[0,1])- tensor R_1(2)- tensor Xi_4 : 6 240 0 -E(120)^13-E(120)^37
R_4^0(1,5,[0,1])- tensor R_1(2)- tensor Xi_8 : 6 240 0 -E(120)^53-E(120)^77
R_4^0(1,1,[1,2])- tensor R_1(2)- tensor Xi_4 : 6 240 0 E(120)^7+E(120)^103
R_4^0(3,5,[2,1])+ tensor R_1(1)- tensor Xi_8 : 6 240 0 -E(120)^71-E(120)^119
R_4^0(1,5,[0,1])+ tensor R_1(2)- tensor Xi_4 : 6 240 0 E(120)^13+E(120)^37
R_4^0(1,5,[0,1])+ tensor R_1(2)- tensor Xi_8 : 6 240 0 E(120)^53+E(120)^77
R_4^0(1,5,[2,1])+ tensor R_1(1)- tensor Xi_4 : 6 240 0 -E(120)^61-E(120)^109
R_4^0(3,1,[1,0])+ tensor R_1(1)- tensor Xi_4 : 6 240 0 E(120)^61+E(120)^109
R_4^0(1,1,[1,2])- tensor R_1(2)- tensor Xi_8 : 6 240 0 E(120)^23+E(120)^47
R_4^0(1,1,[1,2])+ tensor R_1(1)- tensor Xi_8 : 6 240 0 -E(120)^71-E(120)^119
R_4^0(3,5,[0,1])+ tensor R_1(1)- tensor Xi_4 : 6 240 0 E(120)^31+E(120)^79
R_4^0(3,5,[0,1])+ tensor R_1(1)- tensor Xi_8 : 6 240 0 E(120)^71+E(120)^119
R_4^0(1,1,[1,0])+ tensor R_1(2)- tensor Xi_4 : 6 240 0 E(120)^7+E(120)^103
R_4^0(3,5,[0,1])+ tensor R_1(2)- tensor Xi_8 : 6 240 0 E(120)^23+E(120)^47
R_4^0(1,1,[1,0])+ tensor R_1(2)- tensor Xi_8 : 6 240 0 E(120)^23+E(120)^47
R_4^0(1,1,[1,0])- tensor R_1(1)- tensor Xi_4 : 6 240 0 -E(120)^31-E(120)^79
R_4^0(1,1,[1,0])- tensor R_1(2)- tensor Xi_8 : 6 240 0 -E(120)^23-E(120)^47
R_4^0(3,5,[0,1])- tensor R_1(1)- tensor Xi_4 : 6 240 0 -E(120)^31-E(120)^79
R_4^0(3,5,[0,1])- tensor R_1(1)- tensor Xi_8 : 6 240 0 -E(120)^71-E(120)^119
R_4^0(1,5,[2,1])- tensor R_1(2)- tensor Xi_8 : 6 240 0 E(120)^53+E(120)^77
R_4^0(1,1,[1,2])- tensor R_1(1)- tensor Xi_8 : 6 240 0 E(120)^71+E(120)^119
R_4^0(1,1,[1,2])- tensor R_1(1)- tensor Xi_4 : 6 240 0 E(120)^31+E(120)^79
R_4^0(1,1,[1,2])+ tensor R_1(1)- tensor Xi_4 : 6 240 0 -E(120)^31-E(120)^79
R_4^0(3,5,[0,1])- tensor R_1(2)- tensor Xi_4 : 6 240 0 -E(120)^7-E(120)^103
R_4^0(3,5,[0,1])- tensor R_1(2)- tensor Xi_8 : 6 240 0 -E(120)^23-E(120)^47
R_4^0(1,1,[1,0])+ tensor R_1(1)- tensor Xi_4 : 6 240 0 E(120)^31+E(120)^79
R_4^0(3,5,[0,1])+ tensor R_1(2)- tensor Xi_4 : 6 240 0 E(120)^7+E(120)^103
R_4^0(3,5,[2,1])+ tensor R_1(1)- tensor Xi_4 : 6 240 0 -E(120)^31-E(120)^79
R_4^0(1,1,[1,2])+ tensor R_1(2)- tensor Xi_8 : 6 240 0 -E(120)^23-E(120)^47
R_4^0(1,1,[1,2])+ tensor R_1(2)- tensor Xi_4 : 6 240 0 -E(120)^7-E(120)^103
R_4^0(1,1,[1,0])- tensor R_1(1)- tensor Xi_8 : 6 240 0 -E(120)^71-E(120)^119
R_4^0(1,5,[2,1])- tensor R_1(1)- tensor Xi_4 : 6 240 0 E(120)^61+E(120)^109
R_4^0(1,5,[2,1])- tensor R_1(1)- tensor Xi_8 : 6 240 0 E(120)^29+E(120)^101
R_4^0(1,1,[1,0])+ tensor R_1(1)- tensor Xi_8 : 6 240 0 E(120)^71+E(120)^119
R_4^0(3,5,[2,1])- tensor R_1(1)- tensor Xi_4 : 6 240 0 E(120)^31+E(120)^79
R_4^0(1,5,[2,1])- tensor R_1(2)- tensor Xi_4 : 6 240 0 E(120)^13+E(120)^37
R_4^0(1,5,[2,1])+ tensor R_1(2)- tensor Xi_4 : 6 240 0 -E(120)^13-E(120)^37
R_4^0(1,5,[2,1])+ tensor R_1(2)- tensor Xi_8 : 6 240 0 -E(120)^53-E(120)^77
R_4^0(1,5,[2,1])+ tensor R_1(1)- tensor Xi_8 : 6 240 0 -E(120)^29-E(120)^101
R_4^0(3,5,[2,1])- tensor R_1(2)- tensor Xi_8 : 6 240 0 E(120)^23+E(120)^47
R_1(1)- tensor R_1(1)- tensor Xi_1 : 6 420 0 -E(420)^29-E(420)^149-E(420)^221
 -E(420)^281-E(420)^389-E(420)^401
R_1(1)- tensor R_1(1)- tensor Xi_5 : 6 420 0 -E(420)-E(420)^109-E(420)^121
 -E(420)^169-E(420)^289-E(420)^361
R_1(1)- tensor R_1(1)- tensor Xi_7 : 6 420 0 E(420)^29+E(420)^149+E(420)^221
 +E(420)^281+E(420)^389+E(420)^401
R_1(1)- tensor R_1(1)- tensor Xi_11 : 6 420 0 E(420)+E(420)^109+E(420)^121
 +E(420)^169+E(420)^289+E(420)^361
R_1(1)- tensor R_1(2)- tensor Xi_1 : 6 420 0 -E(420)^53-E(420)^113-E(420)^137
 -E(420)^197-E(420)^233-E(420)^317
R_1(1)- tensor R_1(2)- tensor Xi_5 : 6 420 0 -E(420)^37-E(420)^193-E(420)^253
 -E(420)^277-E(420)^337-E(420)^373
R_1(1)- tensor R_1(2)- tensor Xi_7 : 6 420 0 E(420)^53+E(420)^113+E(420)^137
 +E(420)^197+E(420)^233+E(420)^317
R_1(1)- tensor R_1(2)- tensor Xi_11 : 6 420 0 E(420)^37+E(420)^193+E(420)^253
 +E(420)^277+E(420)^337+E(420)^373
R_1(3)- tensor R_1(1)- tensor Xi_1 : 6 420 0 -E(420)^41-E(420)^89-E(420)^101
 -E(420)^209-E(420)^269-E(420)^341
R_1(3)- tensor R_1(1)- tensor Xi_5 : 6 420 0 -E(420)^61-E(420)^181-E(420)^229
 -E(420)^241-E(420)^349-E(420)^409
R_1(3)- tensor R_1(1)- tensor Xi_7 : 6 420 0 E(420)^41+E(420)^89+E(420)^101
 +E(420)^209+E(420)^269+E(420)^341
R_1(3)- tensor R_1(1)- tensor Xi_11 : 6 420 0 E(420)^61+E(420)^181+E(420)^229
 +E(420)^241+E(420)^349+E(420)^409
R_1(3)- tensor R_1(2)- tensor Xi_1 : 6 420 0 -E(420)^17-E(420)^173-E(420)^257
 -E(420)^293-E(420)^353-E(420)^377
R_1(3)- tensor R_1(2)- tensor Xi_5 : 6 420 0 -E(420)^13-E(420)^73-E(420)^97
 -E(420)^157-E(420)^313-E(420)^397
R_1(3)- tensor R_1(2)- tensor Xi_7 : 6 420 0 E(420)^17+E(420)^173+E(420)^257
 +E(420)^293+E(420)^353+E(420)^377
R_1(3)- tensor R_1(2)- tensor Xi_11 : 6 420 0 E(420)^13+E(420)^73+E(420)^97
 +E(420)^157+E(420)^313+E(420)^397
gap> test := SL2IrrepsOfDegree(12);; for rho in test do TestPrint(rho); od;
D_2([1,0]) : 12 9 0 0
D_2([1,1]) : 12 9 0 0
D_1([0,1]) tensor N_1(nu) : 12 10 0 0
D_1([0,1]) : 12 11 0 1
D_1([0,2]) : 12 11 0 1
D_1([0,4]) : 12 11 0 1
D_1([0,3]) : 12 11 0 1
N_1([0,6]) : 12 13 0 -1
N_1([0,5]) : 12 13 0 -1
N_1([0,4]) : 12 13 0 -1
N_1([0,3]) : 12 13 0 -1
N_1([0,2]) : 12 13 0 -1
N_1([0,1]) : 12 13 0 -1
N_1([0,1]) tensor N_1(nu) : 12 14 0 0
N_1([0,2]) tensor N_1(nu) : 12 14 0 0
N_1([0,3]) tensor N_1(nu) : 12 14 0 0
N_1([0,2]) tensor N_1(nu) : 12 15 0 0
D_1([0,1]) tensor N_1([0,1]) : 12 15 0 -1
D_1([0,1]) tensor R_1(1)+ : 12 15 0 -E(3)^2
D_1([0,1]) tensor R_1(2)+ : 12 15 0 -E(3)
N_1([0,1]) tensor N_1(nu) : 12 15 0 0
N_3([1,0])+ tensor R_4^0(1,7,[1,1])+ : 12 16 0 0
N_3([1,3])+ tensor R_4^0(1,7,[1,1])+ : 12 16 0 0
N_2([2,1]) tensor N_1(nu) : 12 18 0 0
N_2([1,1]) tensor N_1(nu) : 12 18 0 0
N_2([1,0]) tensor N_1(nu) : 12 18 0 0
D_2([1,1]) tensor Xi_6 : 12 18 0 0
N_2([1,2]) tensor N_1(nu) : 12 18 0 0
D_2([1,0]) tensor Xi_6 : 12 18 0 0
N_1([0,2]) tensor R_2^0(1,3)_1 : 12 20 0 -1
N_1([0,2]) tensor D_2([1,0])- : 12 20 0 E(4)
N_1([0,2]) tensor D_2([1,0])+ : 12 20 0 -E(4)
N_1([0,1]) tensor Xi_6 tensor R_2^0(1,3)_1 : 12 20 0 1
N_1([0,1]) tensor R_2^0(1,3)_1 : 12 20 0 -1
D_1([0,1]) tensor N_2([0,1]) : 12 20 0 0
N_1([0,1]) tensor D_2([1,0])- : 12 20 0 E(4)
N_1([0,1]) tensor D_2([1,0])+ : 12 20 0 -E(4)
N_1([0,2]) tensor Xi_6 tensor R_2^0(1,3)_1 : 12 20 0 1
N_1([0,3]) tensor N_1([0,1]) : 12 21 0 1
R_1(1)+ tensor N_1(nu) : 12 21 0 0
N_1([0,2]) tensor R_1(2)+ : 12 21 0 E(3)
N_1([0,2]) tensor R_1(1)+ : 12 21 0 E(3)^2
N_1([0,2]) tensor N_1([0,1]) : 12 21 0 1
R_1(3)+ tensor N_1(nu) : 12 21 0 0
N_1([0,3]) tensor R_1(1)+ : 12 21 0 E(3)^2
N_1([0,3]) tensor R_1(2)+ : 12 21 0 E(3)
N_1([0,1]) tensor R_1(2)+ : 12 21 0 E(3)
N_1([0,1]) tensor R_1(1)+ : 12 21 0 E(3)^2
N_1([0,1]) tensor N_1([0,1]) : 12 21 0 1
D_1([0,4]) tensor Xi_6 : 12 22 0 -1
D_1([0,3]) tensor Xi_6 : 12 22 0 -1
R_1(2)+ tensor N_1(nu) : 12 22 0 0
D_1([0,2]) tensor Xi_6 : 12 22 0 -1
D_1([0,1]) tensor Xi_6 : 12 22 0 -1
R_1(1)+ tensor N_1(nu) : 12 22 0 0
R_1(5)+ : 12 23 0 -E(23)-E(23)^2-E(23)^3-E(23)^4-E(23)^6-E(23)^8-E(23)^9
 -E(23)^12-E(23)^13-E(23)^16-E(23)^18
R_1(1)+ : 12 23 0 -E(23)^5-E(23)^7-E(23)^10-E(23)^11-E(23)^14-E(23)^15
 -E(23)^17-E(23)^19-E(23)^20-E(23)^21-E(23)^22
N_3([1,2]) tensor N_1(nu) : 12 24 0 0
D_3([1,1])- tensor R_1(1)+ : 12 24 0 E(24)+E(24)^19
D_3([1,1])+ tensor N_1([0,1]) : 12 24 0 -E(8)-E(8)^3
D_3([1,0])- tensor R_1(1)+ : 12 24 0 -E(24)+E(24)^19
N_3([1,1]) tensor N_1(nu) : 12 24 0 0
D_3([1,0])- tensor N_1([0,1]) : 12 24 0 E(8)-E(8)^3
Xi_9 tensor R_3^0(1,3,nu)_1 tensor R_1(2)+ : 12 24 0 0
D_3([1,0])+ tensor R_1(2)+ : 12 24 0 -E(24)^11+E(24)^17
Xi_9 tensor R_3^0(1,3,nu)_1 tensor R_1(1)+ : 12 24 0 0
D_3([1,1])+ tensor R_1(1)+ : 12 24 0 -E(24)-E(24)^19
Xi_9 tensor R_3^0(1,3,nu)_1 tensor N_1([0,1]) : 12 24 0 0
D_3([1,1])- tensor N_1([0,1]) : 12 24 0 E(8)+E(8)^3
D_3([1,0])+ tensor R_1(1)+ : 12 24 0 E(24)-E(24)^19
R_3^0(1,3,nu)_1 tensor N_1([0,1]) : 12 24 0 0
D_3([1,1])- tensor R_1(2)+ : 12 24 0 E(24)^11+E(24)^17
D_3([1,0])+ tensor N_1([0,1]) : 12 24 0 -E(8)+E(8)^3
D_3([1,1])+ tensor R_1(2)+ : 12 24 0 -E(24)^11-E(24)^17
R_3^0(1,3,nu)_1 tensor R_1(2)+ : 12 24 0 0
R_3^0(1,3,nu)_1 tensor R_1(1)+ : 12 24 0 0
D_3([1,0])- tensor R_1(2)+ : 12 24 0 E(24)^11-E(24)^17
R_2^1(2,2,[1,0]) : 12 25 0 E(5)+E(5)^4
R_2^1(1,1,[1,1]) : 12 25 0 E(5)+E(5)^4
(R_2(2)+)_1 : 12 25 0 2
(R_2(1)-)_1 : 12 25 0 2
R_2^1(1,1,[2,0]) : 12 25 0 E(5)+E(5)^4
(R_2(1)+)_1 : 12 25 0 2
R_2^1(1,1,[2,1]) : 12 25 0 E(5)+E(5)^4
R_2^1(2,2,[2,1]) : 12 25 0 E(5)+E(5)^4
R_2^1(2,2,[2,0]) : 12 25 0 E(5)+E(5)^4
R_2^1(2,2,[1,1]) : 12 25 0 E(5)+E(5)^4
(R_2(2)-)_1 : 12 25 0 2
R_2^1(2,1,[2,1]) : 12 25 0 E(5)^2+E(5)^3
R_2^1(2,1,[2,0]) : 12 25 0 E(5)^2+E(5)^3
R_2^1(2,1,[1,1]) : 12 25 0 E(5)^2+E(5)^3
R_2^1(2,1,[1,0]) : 12 25 0 E(5)^2+E(5)^3
R_2^1(1,2,[1,0]) : 12 25 0 E(5)^2+E(5)^3
R_2^1(1,2,[2,1]) : 12 25 0 E(5)^2+E(5)^3
R_2^1(1,2,[2,0]) : 12 25 0 E(5)^2+E(5)^3
R_2^1(1,2,[1,1]) : 12 25 0 E(5)^2+E(5)^3
R_2^1(1,1,[1,0]) : 12 25 0 E(5)+E(5)^4
N_1([0,3]) tensor Xi_6 : 12 26 0 1
N_1([0,5]) tensor Xi_6 : 12 26 0 1
N_1([0,4]) tensor Xi_6 : 12 26 0 1
N_1([0,2]) tensor Xi_6 : 12 26 0 1
N_1([0,6]) tensor Xi_6 : 12 26 0 1
R_1(2)- tensor N_1(nu) : 12 26 0 0
N_1([0,1]) tensor Xi_6 : 12 26 0 1
R_1(1)- tensor N_1(nu) : 12 26 0 0
R_3^1(1,1,[2,1]) : 12 27 0 0
R_3^1(2,1,[1,1]) : 12 27 0 0
R_3^1(1,1,[2,2]) : 12 27 0 0
(R_3(2)-)_1 : 12 27 0 -E(3)+E(3)^2
(R_3(2)+)_1 : 12 27 0 -E(3)+E(3)^2
R_3^1(1,2,[1,1]) : 12 27 0 0
R_3^1(2,1,[1,0]) : 12 27 0 0
R_3^1(2,2,[2,0]) : 12 27 0 0
R_3^1(1,2,[1,0]) : 12 27 0 0
(R_3(1)-)_1 : 12 27 0 E(3)-E(3)^2
(R_3(1)+)_1 : 12 27 0 E(3)-E(3)^2
R_3^2(2,2,[1,1]) : 12 27 0 -E(3)-2*E(3)^2
R_3^1(1,1,[1,2]) : 12 27 0 0
R_3^2(2,2,[1,0]) : 12 27 0 -E(3)-2*E(3)^2
R_3^2(2,1,[1,1]) : 12 27 0 2*E(3)+E(3)^2
R_3^1(2,2,[1,0]) : 12 27 0 0
R_3^2(2,1,[1,0]) : 12 27 0 2*E(3)+E(3)^2
R_3^1(1,1,[1,1]) : 12 27 0 0
R_3^1(1,2,[2,1]) : 12 27 0 0
R_3^2(1,2,[1,1]) : 12 27 0 -2*E(3)-E(3)^2
R_3^1(1,1,[1,3]) : 12 27 0 0
R_3^2(1,2,[1,0]) : 12 27 0 -2*E(3)-E(3)^2
R_3^1(2,2,[2,1]) : 12 27 0 0
R_3^1(1,1,[1,0]) : 12 27 0 0
R_3^2(1,1,[1,1]) : 12 27 0 E(3)+2*E(3)^2
R_3^1(1,2,[2,0]) : 12 27 0 0
R_3^1(1,2,[4,1]) : 12 27 0 0
R_3^1(2,1,[2,2]) : 12 27 0 0
R_3^1(2,1,[2,1]) : 12 27 0 0
R_3^1(2,2,[4,1]) : 12 27 0 0
R_3^1(2,2,[4,0]) : 12 27 0 0
R_3^1(2,1,[1,3]) : 12 27 0 0
R_3^1(2,1,[1,2]) : 12 27 0 0
R_3^1(1,2,[4,0]) : 12 27 0 0
R_3^1(2,2,[1,1]) : 12 27 0 0
R_3^2(1,1,[1,0]) : 12 27 0 E(3)+2*E(3)^2
N_1([0,1]) tensor N_2([0,1]) : 12 28 0 0
R_1(3)+ tensor R_2^0(1,3)_1 : 12 28 0 -E(7)-E(7)^2-E(7)^4
N_1([0,2]) tensor N_2([0,1]) : 12 28 0 0
R_1(1)+ tensor D_2([1,0])+ : 12 28 0 -E(28)^3-E(28)^19-E(28)^27
N_1([0,3]) tensor N_2([0,1]) : 12 28 0 0
R_1(3)+ tensor Xi_6 tensor R_2^0(1,3)_1 : 12 28 0 E(7)+E(7)^2+E(7)^4
R_1(1)+ tensor R_2^0(1,3)_1 : 12 28 0 -E(7)^3-E(7)^5-E(7)^6
R_1(1)+ tensor Xi_6 tensor R_2^0(1,3)_1 : 12 28 0 E(7)^3+E(7)^5+E(7)^6
R_1(3)+ tensor D_2([1,0])+ : 12 28 0 -E(28)^11-E(28)^15-E(28)^23
R_1(3)+ tensor D_2([1,0])- : 12 28 0 E(28)^11+E(28)^15+E(28)^23
R_1(1)+ tensor D_2([1,0])- : 12 28 0 E(28)^3+E(28)^19+E(28)^27
N_1([0,1]) tensor N_1(nu) tensor Xi_6 : 12 30 0 0
D_1([0,1]) tensor N_1(nu) tensor Xi_8 : 12 30 0 0
R_1(1)+ tensor N_1([0,1]) tensor N_1(nu) : 12 30 0 0
R_1(2)+ tensor N_1([0,1]) tensor N_1(nu) : 12 30 0 0
D_1([0,1]) tensor N_1(nu) tensor Xi_4 : 12 30 0 0
D_1([0,1]) tensor R_1(2)+ tensor Xi_6 : 12 30 0 E(3)
D_1([0,1]) tensor R_1(1)+ tensor Xi_6 : 12 30 0 E(3)^2
R_1(2)+ tensor R_1(1)+ tensor N_1(nu) : 12 30 0 0
D_1([0,1]) tensor N_1([0,1]) tensor Xi_6 : 12 30 0 1
R_1(2)+ tensor R_1(2)+ tensor N_1(nu) : 12 30 0 0
N_1([0,2]) tensor N_1(nu) tensor Xi_6 : 12 30 0 0
N_1(nu) tensor R_1(2)- tensor N_1(nu) : 12 30 0 0
R_1(1)+ tensor R_1(1)+ tensor N_1(nu) : 12 30 0 0
N_1(nu) tensor R_1(1)- tensor N_1(nu) : 12 30 0 0
R_1(1)+ tensor R_1(2)+ tensor N_1(nu) : 12 30 0 0
R_5^1(1,7,[1,1]) : 12 32 0 0
R_5^1(1,5,[1,1]) : 12 32 0 0
R_5^1(5,1,[1,0]) : 12 32 0 0
R_5^1(5,1,[1,1]) : 12 32 0 0
R_5^1(5,5,[1,0]) : 12 32 0 0
R_5^1(5,5,[1,1]) : 12 32 0 0
R_5^1(1,1,[1,1]) : 12 32 0 0
R_5^1(1,3,[1,1]) : 12 32 0 0
R_5^1(1,7,[1,0]) : 12 32 0 0
R_5^1(1,5,[1,0]) : 12 32 0 0
R_5^1(3,3,[1,1]) : 12 32 0 0
R_5^1(3,7,[1,0]) : 12 32 0 0
R_5^1(3,7,[1,1]) : 12 32 0 0
R_5^2(1,1,[0,0])_1 : 12 32 0 0
Xi_9 tensor R_5^2(1,1,[0,0])_1 : 12 32 0 0
R_5^2(1,1,[0,1])_1 : 12 32 0 0
Xi_9 tensor R_5^2(1,1,[0,1])_1 : 12 32 0 0
R_5^2(3,1,[0,0])_1 : 12 32 0 0
Xi_9 tensor R_5^2(3,1,[0,0])_1 : 12 32 0 0
R_5^2(3,1,[0,1])_1 : 12 32 0 0
Xi_9 tensor R_5^2(3,1,[0,1])_1 : 12 32 0 0
R_5^1(1,1,[1,0]) : 12 32 0 0
R_5^0(3,5,[3,1]) : 12 32 0 0
R_5^0(3,5,[3,0]) : 12 32 0 0
R_5^0(3,5,[1,1]) : 12 32 0 0
R_5^0(3,5,[1,0]) : 12 32 0 0
R_5^0(1,5,[3,1]) : 12 32 0 0
R_5^0(1,5,[3,0]) : 12 32 0 0
R_5^0(1,5,[1,1]) : 12 32 0 0
R_5^0(3,1,[3,1]) : 12 32 2 0
R_5^0(3,1,[1,1]) : 12 32 -2 0
R_5^0(3,1,[1,2]) : 12 32 2*E(4) 0
R_5^0(3,1,[1,0]) : 12 32 -2*E(4) 0
R_5^0(1,1,[3,1]) : 12 32 2 0
R_5^0(1,1,[1,1]) : 12 32 -2 0
R_5^0(1,1,[1,2]) : 12 32 -2*E(4) 0
R_5^0(1,1,[1,0]) : 12 32 2*E(4) 0
R_5^0(1,5,[1,0]) : 12 32 0 0
R_5^1(1,3,[1,0]) : 12 32 0 0
R_5^1(3,3,[1,0]) : 12 32 0 0
R_1(1)+ tensor R_1(2)+ : 12 33 0 E(33)^2+E(33)^8+E(33)^17+E(33)^29+E(33)^32
D_1([0,1]) tensor Xi_4 : 12 33 0 E(3)
D_1([0,2]) tensor Xi_8 : 12 33 0 E(3)^2
D_1([0,1]) tensor Xi_8 : 12 33 0 E(3)^2
D_1([0,3]) tensor Xi_8 : 12 33 0 E(3)^2
D_1([0,2]) tensor Xi_4 : 12 33 0 E(3)
R_1(2)+ tensor R_1(2)+ : 12 33 0 E(33)^5+E(33)^14+E(33)^20+E(33)^23+E(33)^26
R_1(2)+ tensor R_1(1)+ : 12 33 0 E(33)+E(33)^4+E(33)^16+E(33)^25+E(33)^31
D_1([0,4]) tensor Xi_4 : 12 33 0 E(3)
R_1(1)+ tensor R_1(1)+ : 12 33 0 E(33)^7+E(33)^10+E(33)^13+E(33)^19+E(33)^28
D_1([0,3]) tensor Xi_4 : 12 33 0 E(3)
R_1(2)+ tensor N_1([0,1]) : 12 33 0 E(11)+E(11)^3+E(11)^4+E(11)^5+E(11)^9
D_1([0,4]) tensor Xi_8 : 12 33 0 E(3)^2
R_1(1)+ tensor N_1([0,1]) : 12 33 0 E(11)^2+E(11)^6+E(11)^7+E(11)^8+E(11)^10
N_1([0,2]) tensor R_1(1)- : 12 35 0 -E(5)-E(5)^4
R_1(1)+ tensor R_1(1)+ : 12 35 0 E(35)+E(35)^4+E(35)^9+E(35)^11+E(35)^16
 +E(35)^29
N_1([0,3]) tensor R_1(1)- : 12 35 0 -E(5)-E(5)^4
R_1(3)+ tensor R_1(1)+ : 12 35 0 E(35)^6+E(35)^19+E(35)^24+E(35)^26+E(35)^31
 +E(35)^34
R_1(3)+ tensor R_1(2)+ : 12 35 0 E(35)^3+E(35)^12+E(35)^13+E(35)^17+E(35)^27
 +E(35)^33
N_1([0,1]) tensor R_1(3)- : 12 35 0 -E(7)^3-E(7)^5-E(7)^6
N_1([0,1]) tensor R_1(1)- : 12 35 0 -E(5)-E(5)^4
R_1(1)+ tensor R_1(2)+ : 12 35 0 E(35)^2+E(35)^8+E(35)^18+E(35)^22+E(35)^23
 +E(35)^32
N_1([0,3]) tensor R_1(2)- : 12 35 0 -E(5)^2-E(5)^3
N_1([0,2]) tensor R_1(3)- : 12 35 0 -E(7)^3-E(7)^5-E(7)^6
N_1([0,2]) tensor R_1(1)- : 12 35 0 -E(7)-E(7)^2-E(7)^4
N_1([0,1]) tensor R_1(2)- : 12 35 0 -E(5)^2-E(5)^3
N_1([0,2]) tensor R_1(2)- : 12 35 0 -E(5)^2-E(5)^3
N_1([0,1]) tensor R_1(1)- : 12 35 0 -E(7)-E(7)^2-E(7)^4
(R_2(2)-)_1 tensor R_2^0(1,3)_1 : 12 36 0 1
(R_2(2)+)_1 tensor Xi_6 tensor R_2^0(1,3)_1 : 12 36 0 -1
(R_2(2)-)_1 tensor Xi_6 tensor R_2^0(1,3)_1 : 12 36 0 -1
(R_2(2)+)_1 tensor D_2([1,0])- : 12 36 0 -E(4)
(R_2(2)+)_1 tensor D_2([1,0])+ : 12 36 0 E(4)
R_2^1(2,2,[1,0]) tensor Xi_6 tensor R_2^0(1,3)_1 : 12 36 0 -E(3)
R_2^1(1,1,[1,0]) tensor R_2^0(1,3)_1 : 12 36 0 E(3)
R_2^1(2,2,[1,0]) tensor R_2^0(1,3)_1 : 12 36 0 E(3)
R_2^1(2,2,[1,0]) tensor D_2([1,0])- : 12 36 0 -E(12)^7
R_2^1(1,1,[1,0]) tensor Xi_6 tensor R_2^0(1,3)_1 : 12 36 0 -E(3)
R_2^1(2,2,[1,0]) tensor D_2([1,0])+ : 12 36 0 E(12)^7
D_2([1,0]) tensor Xi_3 : 12 36 0 0
N_2([1,1]) tensor N_2([0,1]) : 12 36 0 0
(R_2(2)+)_1 tensor R_2^0(1,3)_1 : 12 36 0 1
R_2^1(2,2,[1,1]) tensor D_2([1,0])- : 12 36 0 -E(12)^7
N_2([1,2]) tensor N_2([0,1]) : 12 36 0 0
R_2^1(1,2,[1,1]) tensor D_2([1,0])- : 12 36 0 -E(12)^11
D_2([1,0]) tensor Xi_9 : 12 36 0 0
R_2^1(2,2,[1,1]) tensor R_2^0(1,3)_1 : 12 36 0 E(3)
R_2^1(2,2,[1,1]) tensor Xi_6 tensor R_2^0(1,3)_1 : 12 36 0 -E(3)
R_2^1(1,1,[1,1]) tensor D_2([1,0])+ : 12 36 0 E(12)^7
R_2^1(1,1,[1,0]) tensor D_2([1,0])- : 12 36 0 -E(12)^7
R_2^1(1,1,[1,1]) tensor D_2([1,0])- : 12 36 0 -E(12)^7
R_2^1(1,1,[1,1]) tensor R_2^0(1,3)_1 : 12 36 0 E(3)
R_2^1(1,1,[1,0]) tensor D_2([1,0])+ : 12 36 0 E(12)^7
R_2^1(1,2,[1,1]) tensor R_2^0(1,3)_1 : 12 36 0 E(3)^2
R_2^1(1,2,[1,1]) tensor Xi_6 tensor R_2^0(1,3)_1 : 12 36 0 -E(3)^2
(R_2(2)-)_1 tensor D_2([1,0])- : 12 36 0 -E(4)
N_2([1,0]) tensor N_2([0,1]) : 12 36 0 0
R_2^1(1,1,[1,1]) tensor Xi_6 tensor R_2^0(1,3)_1 : 12 36 0 -E(3)
D_2([1,1]) tensor Xi_3 : 12 36 0 0
R_2^1(1,2,[1,0]) tensor Xi_6 tensor R_2^0(1,3)_1 : 12 36 0 -E(3)^2
N_2([2,1]) tensor N_2([0,1]) : 12 36 0 0
R_2^1(2,1,[1,1]) tensor Xi_6 tensor R_2^0(1,3)_1 : 12 36 0 -E(3)^2
(R_2(2)-)_1 tensor D_2([1,0])+ : 12 36 0 E(4)
(R_2(1)-)_1 tensor Xi_6 tensor R_2^0(1,3)_1 : 12 36 0 -1
(R_2(1)-)_1 tensor R_2^0(1,3)_1 : 12 36 0 1
R_2^1(2,1,[1,1]) tensor R_2^0(1,3)_1 : 12 36 0 E(3)^2
R_2^1(1,2,[1,0]) tensor R_2^0(1,3)_1 : 12 36 0 E(3)^2
(R_2(1)-)_1 tensor D_2([1,0])- : 12 36 0 -E(4)
R_2^1(1,2,[1,1]) tensor D_2([1,0])+ : 12 36 0 E(12)^11
R_2^1(2,1,[1,0]) tensor Xi_6 tensor R_2^0(1,3)_1 : 12 36 0 -E(3)^2
(R_2(1)+)_1 tensor D_2([1,0])- : 12 36 0 -E(4)
R_2^1(2,1,[1,1]) tensor D_2([1,0])- : 12 36 0 -E(12)^11
(R_2(1)+)_1 tensor R_2^0(1,3)_1 : 12 36 0 1
R_2^1(2,1,[1,1]) tensor D_2([1,0])+ : 12 36 0 E(12)^11
R_2^1(2,1,[1,0]) tensor D_2([1,0])+ : 12 36 0 E(12)^11
R_2^1(2,1,[1,0]) tensor D_2([1,0])- : 12 36 0 -E(12)^11
(R_2(1)+)_1 tensor Xi_6 tensor R_2^0(1,3)_1 : 12 36 0 -1
R_2^1(2,1,[1,0]) tensor R_2^0(1,3)_1 : 12 36 0 E(3)^2
R_2^1(1,2,[1,0]) tensor D_2([1,0])- : 12 36 0 -E(12)^11
R_2^1(1,2,[1,0]) tensor D_2([1,0])+ : 12 36 0 E(12)^11
D_2([1,1]) tensor Xi_9 : 12 36 0 0
(R_2(1)-)_1 tensor D_2([1,0])+ : 12 36 0 E(4)
(R_2(1)+)_1 tensor D_2([1,0])+ : 12 36 0 E(4)
R_2^1(2,2,[1,1]) tensor D_2([1,0])+ : 12 36 0 E(12)^7
N_1([0,4]) tensor Xi_8 : 12 39 0 -E(3)^2
N_1([0,4]) tensor Xi_4 : 12 39 0 -E(3)
R_1(1)- tensor R_1(2)+ : 12 39 0 -E(39)-E(39)^4-E(39)^10-E(39)^16-E(39)^22
 -E(39)^25
N_1([0,1]) tensor Xi_4 : 12 39 0 -E(3)
R_1(2)- tensor N_1([0,1]) : 12 39 0 -E(13)^2-E(13)^5-E(13)^6-E(13)^7-E(13)^8
 -E(13)^11
N_1([0,2]) tensor Xi_8 : 12 39 0 -E(3)^2
N_1([0,2]) tensor Xi_4 : 12 39 0 -E(3)
R_1(2)- tensor R_1(2)+ : 12 39 0 -E(39)^7-E(39)^19-E(39)^28-E(39)^31-E(39)^34
 -E(39)^37
R_1(1)- tensor R_1(1)+ : 12 39 0 -E(39)^14-E(39)^17-E(39)^23-E(39)^29-E(39)^35
 -E(39)^38
R_1(1)- tensor N_1([0,1]) : 12 39 0 -E(13)-E(13)^3-E(13)^4-E(13)^9-E(13)^10
 -E(13)^12
N_1([0,3]) tensor Xi_8 : 12 39 0 -E(3)^2
N_1([0,6]) tensor Xi_8 : 12 39 0 -E(3)^2
N_1([0,5]) tensor Xi_8 : 12 39 0 -E(3)^2
N_1([0,6]) tensor Xi_4 : 12 39 0 -E(3)
N_1([0,5]) tensor Xi_4 : 12 39 0 -E(3)
N_1([0,1]) tensor Xi_8 : 12 39 0 -E(3)^2
N_1([0,3]) tensor Xi_4 : 12 39 0 -E(3)
R_1(2)- tensor R_1(1)+ : 12 39 0 -E(39)^2-E(39)^5-E(39)^8-E(39)^11-E(39)^20
 -E(39)^32
D_1([0,1]) tensor N_3([1,0])- : 12 40 0 -E(8)-E(8)^3
Xi_9 tensor R_3^0(1,3,nu)_1 tensor R_1(1)- : 12 40 0 0
N_3([1,2]) tensor R_1(2)+ : 12 40 0 0
N_3([1,2]) tensor R_1(1)+ : 12 40 0 0
N_1([0,1]) tensor R_3^0(1,7,[0,1])- : 12 40 0 -1
D_3([1,1])+ tensor R_1(1)- : 12 40 0 E(40)^7+E(40)^13+E(40)^23+E(40)^37
N_1([0,1]) tensor R_3^0(1,7,[0,1])+ : 12 40 0 -1
N_1([0,1]) tensor R_3^0(1,3,[0,1])- : 12 40 0 1
N_1([0,1]) tensor R_3^0(3,1,[0,1]) : 12 40 0 E(4)
D_3([1,0])- tensor R_1(2)- : 12 40 0 -E(40)^21-E(40)^29+E(40)^31+E(40)^39
D_3([1,1])- tensor R_1(1)- : 12 40 0 -E(40)^7-E(40)^13-E(40)^23-E(40)^37
N_1([0,1]) tensor R_3^0(1,3,[0,1])+ : 12 40 0 1
D_3([1,1])- tensor R_1(2)- : 12 40 0 -E(40)^21-E(40)^29-E(40)^31-E(40)^39
N_1([0,1]) tensor R_3^0(1,5,[0,1]) : 12 40 0 E(4)
D_1([0,1]) tensor N_3([1,0])+ : 12 40 0 E(8)+E(8)^3
D_3([1,0])+ tensor R_1(1)- : 12 40 0 -E(40)^7+E(40)^13-E(40)^23+E(40)^37
Xi_9 tensor R_3^0(1,3,nu)_1 tensor R_1(2)- : 12 40 0 0
D_1([0,1]) tensor N_3([1,3])+ : 12 40 0 E(8)-E(8)^3
R_3^0(1,3,nu)_1 tensor R_1(2)- : 12 40 0 0
N_1([0,2]) tensor R_3^0(1,7,[0,1])- : 12 40 0 -1
D_1([0,1]) tensor N_3([1,3])- : 12 40 0 -E(8)+E(8)^3
N_1([0,2]) tensor R_3^0(1,3,[0,1])- : 12 40 0 1
N_1([0,2]) tensor R_3^0(1,3,[0,1])+ : 12 40 0 1
N_1([0,2]) tensor R_3^0(3,5,[0,1]) : 12 40 0 -E(4)
D_3([1,0])+ tensor R_1(2)- : 12 40 0 E(40)^21+E(40)^29-E(40)^31-E(40)^39
N_1([0,2]) tensor R_3^0(1,1,[0,1]) : 12 40 0 -E(4)
N_3([1,1]) tensor R_1(2)+ : 12 40 0 0
N_1([0,2]) tensor R_3^0(3,1,[0,1]) : 12 40 0 E(4)
N_1([0,2]) tensor R_3^0(1,5,[0,1]) : 12 40 0 E(4)
R_3^0(1,3,nu)_1 tensor R_1(1)- : 12 40 0 0
N_3([1,1]) tensor R_1(1)+ : 12 40 0 0
N_1([0,1]) tensor R_3^0(3,5,[0,1]) : 12 40 0 -E(4)
D_3([1,1])+ tensor R_1(2)- : 12 40 0 E(40)^21+E(40)^29+E(40)^31+E(40)^39
N_1([0,2]) tensor R_3^0(1,7,[0,1])+ : 12 40 0 -1
N_1([0,1]) tensor R_3^0(1,1,[0,1]) : 12 40 0 -E(4)
D_3([1,0])- tensor R_1(1)- : 12 40 0 E(40)^7-E(40)^13+E(40)^23-E(40)^37
R_1(1)- tensor R_1(1)+ tensor N_1(nu) : 12 42 0 0
N_1([0,1]) tensor R_1(2)+ tensor Xi_6 : 12 42 0 -E(3)
R_1(1)- tensor R_1(2)+ tensor N_1(nu) : 12 42 0 0
R_1(1)- tensor N_1([0,1]) tensor N_1(nu) : 12 42 0 0
N_1([0,2]) tensor N_1([0,1]) tensor Xi_6 : 12 42 0 -1
N_1([0,3]) tensor N_1(nu) tensor Xi_8 : 12 42 0 0
N_1([0,2]) tensor R_1(1)+ tensor Xi_6 : 12 42 0 -E(3)^2
N_1([0,1]) tensor R_1(1)+ tensor Xi_6 : 12 42 0 -E(3)^2
N_1([0,2]) tensor R_1(2)+ tensor Xi_6 : 12 42 0 -E(3)
N_1([0,2]) tensor N_1(nu) tensor Xi_4 : 12 42 0 0
N_1([0,2]) tensor N_1(nu) tensor Xi_8 : 12 42 0 0
R_1(1)+ tensor N_1(nu) tensor Xi_6 : 12 42 0 0
R_1(3)- tensor N_1([0,1]) tensor N_1(nu) : 12 42 0 0
N_1([0,3]) tensor N_1([0,1]) tensor Xi_6 : 12 42 0 -1
R_1(3)- tensor R_1(1)+ tensor N_1(nu) : 12 42 0 0
N_1([0,1]) tensor N_1(nu) tensor Xi_8 : 12 42 0 0
N_1([0,1]) tensor N_1(nu) tensor Xi_4 : 12 42 0 0
N_1([0,3]) tensor R_1(1)+ tensor Xi_6 : 12 42 0 -E(3)^2
N_1([0,3]) tensor R_1(2)+ tensor Xi_6 : 12 42 0 -E(3)
R_1(3)+ tensor N_1(nu) tensor Xi_6 : 12 42 0 0
R_1(3)- tensor R_1(2)+ tensor N_1(nu) : 12 42 0 0
N_1([0,3]) tensor N_1(nu) tensor Xi_4 : 12 42 0 0
N_1([0,1]) tensor N_1([0,1]) tensor Xi_6 : 12 42 0 -1
R_1(2)+ tensor N_2([0,1]) : 12 44 0 0
D_1([0,1]) tensor Xi_9 : 12 44 0 -E(4)
D_1([0,2]) tensor Xi_3 : 12 44 0 E(4)
D_1([0,3]) tensor Xi_9 : 12 44 0 -E(4)
R_1(1)+ tensor N_2([0,1]) : 12 44 0 0
D_1([0,2]) tensor Xi_9 : 12 44 0 -E(4)
D_1([0,3]) tensor Xi_3 : 12 44 0 E(4)
D_1([0,4]) tensor Xi_3 : 12 44 0 E(4)
D_1([0,4]) tensor Xi_9 : 12 44 0 -E(4)
D_1([0,1]) tensor Xi_3 : 12 44 0 E(4)
R_2^1(1,1,[1,1]) tensor R_1(2)+ : 12 45 0 -E(15)^2-E(15)^8
N_2([1,0]) tensor R_1(2)- : 12 45 0 0
R_2^1(2,2,[1,1]) tensor R_1(2)+ : 12 45 0 -E(15)^2-E(15)^8
(R_2(2)+)_1 tensor R_1(2)+ : 12 45 0 -E(5)-E(5)^4
R_2^1(1,1,[1,1]) tensor R_1(1)+ : 12 45 0 -E(15)^11-E(15)^14
R_2^1(1,2,[1,1]) tensor R_1(1)+ : 12 45 0 -E(15)-E(15)^4
(R_2(2)+)_1 tensor R_1(1)+ : 12 45 0 -E(5)^2-E(5)^3
R_2^1(2,2,[1,1]) tensor R_1(1)+ : 12 45 0 -E(15)^11-E(15)^14
R_2^1(1,2,[1,1]) tensor R_1(2)+ : 12 45 0 -E(15)^7-E(15)^13
R_2^1(2,2,[1,0]) tensor R_1(2)+ : 12 45 0 -E(15)^2-E(15)^8
R_2^1(2,2,[1,0]) tensor R_1(1)+ : 12 45 0 -E(15)^11-E(15)^14
(R_2(1)+)_1 tensor R_1(1)+ : 12 45 0 -E(5)^2-E(5)^3
(R_2(1)+)_1 tensor R_1(2)+ : 12 45 0 -E(5)-E(5)^4
R_2^1(1,1,[1,0]) tensor R_1(2)+ : 12 45 0 -E(15)^2-E(15)^8
N_2([2,1]) tensor R_1(2)- : 12 45 0 0
R_2^1(1,1,[1,0]) tensor R_1(1)+ : 12 45 0 -E(15)^11-E(15)^14
N_2([2,1]) tensor R_1(1)- : 12 45 0 0
N_2([1,2]) tensor R_1(1)- : 12 45 0 0
N_2([1,1]) tensor R_1(2)- : 12 45 0 0
N_2([1,2]) tensor R_1(2)- : 12 45 0 0
N_2([1,0]) tensor R_1(1)- : 12 45 0 0
R_2^1(2,1,[1,1]) tensor R_1(1)+ : 12 45 0 -E(15)-E(15)^4
R_2^1(2,1,[1,0]) tensor R_1(2)+ : 12 45 0 -E(15)^7-E(15)^13
N_2([1,1]) tensor R_1(1)- : 12 45 0 0
R_2^1(1,2,[1,0]) tensor R_1(1)+ : 12 45 0 -E(15)-E(15)^4
(R_2(1)-)_1 tensor R_1(1)+ : 12 45 0 -E(5)^2-E(5)^3
(R_2(2)-)_1 tensor R_1(2)+ : 12 45 0 -E(5)-E(5)^4
(R_2(1)-)_1 tensor R_1(2)+ : 12 45 0 -E(5)-E(5)^4
R_2^1(2,1,[1,0]) tensor R_1(1)+ : 12 45 0 -E(15)-E(15)^4
R_2^1(2,1,[1,1]) tensor R_1(2)+ : 12 45 0 -E(15)^7-E(15)^13
(R_2(2)-)_1 tensor R_1(1)+ : 12 45 0 -E(5)^2-E(5)^3
R_2^1(1,2,[1,0]) tensor R_1(2)+ : 12 45 0 -E(15)^7-E(15)^13
R_1(5)+ tensor Xi_6 : 12 46 0 E(23)+E(23)^2+E(23)^3+E(23)^4+E(23)^6+E(23)^8
 +E(23)^9+E(23)^12+E(23)^13+E(23)^16+E(23)^18
R_1(1)+ tensor Xi_6 : 12 46 0 E(23)^5+E(23)^7+E(23)^10+E(23)^11+E(23)^14
 +E(23)^15+E(23)^17+E(23)^19+E(23)^20+E(23)^21+E(23)^22
R_4^0(1,3,[1,0])- tensor R_1(2)+ : 12 48 0 0
R_4^0(1,5,[1,0]) tensor R_1(1)+ : 12 48 0 0
R_4^0(1,5,[1,0]) tensor R_1(2)+ : 12 48 0 0
R_4^0(3,5,[1,0]) tensor N_1([0,1]) : 12 48 0 0
R_4^0(3,1,[1,1]) tensor N_1([0,1]) : 12 48 0 0
R_4^0(1,1,[1,1]) tensor R_1(2)+ : 12 48 0 0
R_4^0(1,1,[1,1]) tensor R_1(1)+ : 12 48 0 0
R_4^0(1,1,[1,1]) tensor N_1([0,1]) : 12 48 0 0
R_4^0(3,5,[1,0]) tensor R_1(1)+ : 12 48 0 0
R_4^0(3,5,[1,0]) tensor R_1(2)+ : 12 48 0 0
R_4^0(1,3,[1,0])+ tensor N_1([0,1]) : 12 48 0 0
R_4^0(1,3,[1,0])+ tensor R_1(1)+ : 12 48 0 0
R_4^0(1,3,[1,0])+ tensor R_1(2)+ : 12 48 0 0
R_4^0(1,3,[1,0])- tensor N_1([0,1]) : 12 48 0 0
R_4^0(1,3,[1,0])- tensor R_1(1)+ : 12 48 0 0
N_3([1,3])+ tensor R_4^0(1,7,[1,1])+ tensor Xi_8 : 12 48 0 0
R_4^0(1,5,[1,0]) tensor N_1([0,1]) : 12 48 0 0
N_3([1,3])+ tensor R_4^0(1,7,[1,1])+ tensor Xi_4 : 12 48 0 0
N_3([1,0])+ tensor R_4^0(1,7,[1,1])+ tensor Xi_8 : 12 48 0 0
N_3([1,0])+ tensor R_4^0(1,7,[1,1])+ tensor Xi_4 : 12 48 0 0
R_4^0(1,3,[1,1])+ tensor N_1([0,1]) : 12 48 0 0
R_4^0(1,3,[1,1])+ tensor R_1(1)+ : 12 48 0 0
R_4^0(1,3,[1,1])+ tensor R_1(2)+ : 12 48 0 0
R_4^0(3,1,[1,1]) tensor R_1(1)+ : 12 48 0 0
R_4^0(1,3,[1,1])- tensor N_1([0,1]) : 12 48 0 0
R_4^0(1,3,[1,1])- tensor R_1(1)+ : 12 48 0 0
R_4^0(1,3,[1,1])- tensor R_1(2)+ : 12 48 0 0
R_4^0(1,7,[1,0])+ tensor N_1([0,1]) : 12 48 0 0
R_4^0(1,7,[1,0])+ tensor R_1(1)+ : 12 48 0 0
R_4^0(1,7,[1,0])+ tensor R_1(2)+ : 12 48 0 0
R_4^0(3,1,[1,1]) tensor R_1(2)+ : 12 48 0 0
R_4^0(1,7,[1,0])- tensor R_1(1)+ : 12 48 0 0
R_4^0(1,7,[1,0])- tensor R_1(2)+ : 12 48 0 0
R_4^0(1,7,[1,1])+ tensor N_1([0,1]) : 12 48 0 0
R_4^0(1,7,[1,1])+ tensor R_1(1)+ : 12 48 0 0
R_4^0(1,7,[1,1])+ tensor R_1(2)+ : 12 48 0 0
R_4^0(1,7,[1,1])- tensor N_1([0,1]) : 12 48 0 0
R_4^0(1,7,[1,1])- tensor R_1(1)+ : 12 48 0 0
R_4^0(1,7,[1,1])- tensor R_1(2)+ : 12 48 0 0
R_4^2(1,1,[0,1]) tensor N_1([0,1]) : 12 48 0 1-E(4)
R_4^2(1,1,[0,1]) tensor R_1(1)+ : 12 48 0 E(12)^8-E(12)^11
R_4^2(1,1,[0,1]) tensor R_1(2)+ : 12 48 0 E(12)^4-E(12)^7
R_4^2(1,3,[0,1]) tensor N_1([0,1]) : 12 48 0 -1-E(4)
R_4^2(1,3,[0,1]) tensor R_1(1)+ : 12 48 0 -E(12)^8-E(12)^11
R_4^2(1,3,[0,1]) tensor R_1(2)+ : 12 48 0 -E(12)^4-E(12)^7
Xi_6 tensor R_4^2(1,3,[0,1]) tensor N_1([0,1]) : 12 48 0 1+E(4)
Xi_6 tensor R_4^2(1,3,[0,1]) tensor R_1(1)+ : 12 48 0 E(12)^8+E(12)^11
R_4^2(3,3,nu)_1 tensor R_1(2)+ : 12 48 0 -E(12)^4-E(12)^7
R_4^2(3,1,[0,1]) tensor N_1([0,1]) : 12 48 0 1+E(4)
R_4^2(3,1,[0,1]) tensor R_1(1)+ : 12 48 0 E(12)^8+E(12)^11
R_4^2(3,1,[0,1]) tensor R_1(2)+ : 12 48 0 E(12)^4+E(12)^7
R_4^2(3,3,[0,1]) tensor N_1([0,1]) : 12 48 0 -1+E(4)
R_4^2(3,3,[0,1]) tensor R_1(1)+ : 12 48 0 -E(12)^8+E(12)^11
R_4^2(3,3,[0,1]) tensor R_1(2)+ : 12 48 0 -E(12)^4+E(12)^7
Xi_6 tensor R_4^2(3,3,[0,1]) tensor N_1([0,1]) : 12 48 0 1-E(4)
Xi_6 tensor R_4^2(3,3,[0,1]) tensor R_1(1)+ : 12 48 0 E(12)^8-E(12)^11
Xi_6 tensor R_4^2(3,3,[0,1]) tensor R_1(2)+ : 12 48 0 E(12)^4-E(12)^7
R_4^2(1,3,nu)_1 tensor N_1([0,1]) : 12 48 0 -1+E(4)
R_4^2(1,3,nu)_1 tensor R_1(1)+ : 12 48 0 -E(12)^8+E(12)^11
R_4^2(1,3,nu)_1 tensor R_1(2)+ : 12 48 0 -E(12)^4+E(12)^7
R_4^2(3,3,nu)_1 tensor N_1([0,1]) : 12 48 0 -1-E(4)
R_4^2(3,3,nu)_1 tensor R_1(1)+ : 12 48 0 -E(12)^8-E(12)^11
R_4^0(1,7,[1,0])- tensor N_1([0,1]) : 12 48 0 0
Xi_6 tensor R_4^2(1,3,[0,1]) tensor R_1(2)+ : 12 48 0 E(12)^4+E(12)^7
R_2^1(2,2,[2,1]) tensor Xi_6 : 12 50 0 -E(5)-E(5)^4
R_2^1(1,1,[2,0]) tensor Xi_6 : 12 50 0 -E(5)-E(5)^4
R_2^1(2,1,[2,1]) tensor Xi_6 : 12 50 0 -E(5)^2-E(5)^3
R_2^1(2,1,[1,1]) tensor Xi_6 : 12 50 0 -E(5)^2-E(5)^3
R_2^1(2,1,[1,0]) tensor Xi_6 : 12 50 0 -E(5)^2-E(5)^3
R_2^1(1,1,[1,0]) tensor Xi_6 : 12 50 0 -E(5)-E(5)^4
R_2^1(1,2,[2,1]) tensor Xi_6 : 12 50 0 -E(5)^2-E(5)^3
R_2^1(2,1,[2,0]) tensor Xi_6 : 12 50 0 -E(5)^2-E(5)^3
R_2^1(2,2,[1,0]) tensor Xi_6 : 12 50 0 -E(5)-E(5)^4
R_2^1(1,2,[2,0]) tensor Xi_6 : 12 50 0 -E(5)^2-E(5)^3
R_2^1(1,2,[1,1]) tensor Xi_6 : 12 50 0 -E(5)^2-E(5)^3
(R_2(2)+)_1 tensor Xi_6 : 12 50 0 -2
R_2^1(2,2,[1,1]) tensor Xi_6 : 12 50 0 -E(5)-E(5)^4
(R_2(1)+)_1 tensor Xi_6 : 12 50 0 -2
R_2^1(2,2,[2,0]) tensor Xi_6 : 12 50 0 -E(5)-E(5)^4
(R_2(2)-)_1 tensor Xi_6 : 12 50 0 -2
(R_2(1)-)_1 tensor Xi_6 : 12 50 0 -2
R_2^1(1,2,[1,0]) tensor Xi_6 : 12 50 0 -E(5)^2-E(5)^3
R_2^1(1,1,[2,1]) tensor Xi_6 : 12 50 0 -E(5)-E(5)^4
R_2^1(1,1,[1,1]) tensor Xi_6 : 12 50 0 -E(5)-E(5)^4
N_1([0,5]) tensor Xi_9 : 12 52 0 E(4)
N_1([0,3]) tensor Xi_9 : 12 52 0 E(4)
R_1(2)- tensor N_2([0,1]) : 12 52 0 0
R_1(1)- tensor N_2([0,1]) : 12 52 0 0
N_1([0,1]) tensor Xi_9 : 12 52 0 E(4)
N_1([0,4]) tensor Xi_3 : 12 52 0 -E(4)
N_1([0,1]) tensor Xi_3 : 12 52 0 -E(4)
N_1([0,5]) tensor Xi_3 : 12 52 0 -E(4)
N_1([0,3]) tensor Xi_3 : 12 52 0 -E(4)
N_1([0,4]) tensor Xi_9 : 12 52 0 E(4)
N_1([0,2]) tensor Xi_9 : 12 52 0 E(4)
N_1([0,6]) tensor Xi_3 : 12 52 0 -E(4)
N_1([0,6]) tensor Xi_9 : 12 52 0 E(4)
N_1([0,2]) tensor Xi_3 : 12 52 0 -E(4)
R_3^1(2,1,[2,2]) tensor Xi_6 : 12 54 0 0
R_3^1(1,1,[1,0]) tensor Xi_6 : 12 54 0 0
R_3^1(2,1,[1,2]) tensor Xi_6 : 12 54 0 0
R_3^1(2,1,[1,3]) tensor Xi_6 : 12 54 0 0
R_3^1(1,1,[2,2]) tensor Xi_6 : 12 54 0 0
R_3^2(1,1,[1,1]) tensor Xi_6 : 12 54 0 -E(3)-2*E(3)^2
R_3^2(2,1,[1,0]) tensor Xi_6 : 12 54 0 -2*E(3)-E(3)^2
R_3^1(1,1,[1,3]) tensor Xi_6 : 12 54 0 0
(R_3(1)-)_1 tensor Xi_6 : 12 54 0 -E(3)+E(3)^2
R_3^2(1,1,[1,0]) tensor Xi_6 : 12 54 0 -E(3)-2*E(3)^2
R_3^1(2,1,[1,1]) tensor Xi_6 : 12 54 0 0
R_3^2(2,1,[1,1]) tensor Xi_6 : 12 54 0 -2*E(3)-E(3)^2
(R_3(2)+)_1 tensor Xi_6 : 12 54 0 E(3)-E(3)^2
R_3^1(1,2,[4,0]) tensor Xi_6 : 12 54 0 0
R_3^1(1,2,[2,0]) tensor Xi_6 : 12 54 0 0
(R_3(1)+)_1 tensor Xi_6 : 12 54 0 -E(3)+E(3)^2
R_3^1(2,2,[2,0]) tensor Xi_6 : 12 54 0 0
(R_3(2)-)_1 tensor Xi_6 : 12 54 0 E(3)-E(3)^2
R_3^1(2,2,[2,1]) tensor Xi_6 : 12 54 0 0
R_3^1(1,1,[2,1]) tensor Xi_6 : 12 54 0 0
R_3^2(1,2,[1,1]) tensor Xi_6 : 12 54 0 2*E(3)+E(3)^2
R_3^1(2,1,[1,0]) tensor Xi_6 : 12 54 0 0
R_3^1(2,2,[1,0]) tensor Xi_6 : 12 54 0 0
R_3^1(2,2,[1,1]) tensor Xi_6 : 12 54 0 0
R_3^1(2,1,[2,1]) tensor Xi_6 : 12 54 0 0
R_3^2(2,2,[1,0]) tensor Xi_6 : 12 54 0 E(3)+2*E(3)^2
R_3^1(2,2,[4,0]) tensor Xi_6 : 12 54 0 0
R_3^2(2,2,[1,1]) tensor Xi_6 : 12 54 0 E(3)+2*E(3)^2
R_3^1(1,1,[1,1]) tensor Xi_6 : 12 54 0 0
R_3^1(2,2,[4,1]) tensor Xi_6 : 12 54 0 0
R_3^1(1,2,[1,1]) tensor Xi_6 : 12 54 0 0
R_3^1(1,2,[2,1]) tensor Xi_6 : 12 54 0 0
R_3^1(1,2,[4,1]) tensor Xi_6 : 12 54 0 0
R_3^1(1,1,[1,2]) tensor Xi_6 : 12 54 0 0
R_3^2(1,2,[1,0]) tensor Xi_6 : 12 54 0 2*E(3)+E(3)^2
R_3^1(1,2,[1,0]) tensor Xi_6 : 12 54 0 0
R_1(1)+ tensor R_1(1)- : 12 55 0 -E(55)^6-E(55)^19-E(55)^21-E(55)^24-E(55)^29
 -E(55)^39-E(55)^41-E(55)^46-E(55)^51-E(55)^54
R_1(2)+ tensor R_1(2)- : 12 55 0 -E(55)^3-E(55)^12-E(55)^23-E(55)^27-E(55)^37
 -E(55)^38-E(55)^42-E(55)^47-E(55)^48-E(55)^53
R_1(1)+ tensor R_1(2)- : 12 55 0 -E(55)^2-E(55)^7-E(55)^8-E(55)^13-E(55)^17
 -E(55)^18-E(55)^28-E(55)^32-E(55)^43-E(55)^52
R_1(2)+ tensor R_1(1)- : 12 55 0 -E(55)-E(55)^4-E(55)^9-E(55)^14-E(55)^16
 -E(55)^26-E(55)^31-E(55)^34-E(55)^36-E(55)^49
R_1(3)+ tensor R_3^0(1,3,[0,1])- : 12 56 0 E(7)+E(7)^2+E(7)^4
R_1(1)+ tensor R_3^0(1,7,[0,1])- : 12 56 0 -E(7)^3-E(7)^5-E(7)^6
R_1(1)+ tensor R_3^0(1,3,[0,1])+ : 12 56 0 E(7)^3+E(7)^5+E(7)^6
R_1(1)+ tensor R_3^0(1,7,[0,1])+ : 12 56 0 -E(7)^3-E(7)^5-E(7)^6
R_1(1)+ tensor R_3^0(1,5,[0,1]) : 12 56 0 E(28)^3+E(28)^19+E(28)^27
R_1(1)+ tensor R_3^0(1,1,[0,1]) : 12 56 0 -E(28)^3-E(28)^19-E(28)^27
R_1(3)+ tensor R_3^0(1,3,[0,1])+ : 12 56 0 E(7)+E(7)^2+E(7)^4
N_3([1,1]) tensor R_1(3)- : 12 56 0 0
R_1(1)+ tensor R_3^0(3,5,[0,1]) : 12 56 0 -E(28)^3-E(28)^19-E(28)^27
R_1(3)+ tensor R_3^0(1,7,[0,1])+ : 12 56 0 -E(7)-E(7)^2-E(7)^4
R_1(3)+ tensor R_3^0(3,1,[0,1]) : 12 56 0 E(28)^11+E(28)^15+E(28)^23
R_1(3)+ tensor R_3^0(1,7,[0,1])- : 12 56 0 -E(7)-E(7)^2-E(7)^4
R_1(1)+ tensor R_3^0(3,1,[0,1]) : 12 56 0 E(28)^3+E(28)^19+E(28)^27
R_1(1)+ tensor R_3^0(1,3,[0,1])- : 12 56 0 E(7)^3+E(7)^5+E(7)^6
N_1([0,2]) tensor N_3([1,3])- : 12 56 0 E(8)-E(8)^3
R_1(3)+ tensor R_3^0(3,5,[0,1]) : 12 56 0 -E(28)^11-E(28)^15-E(28)^23
N_1([0,1]) tensor N_3([1,3])+ : 12 56 0 -E(8)+E(8)^3
N_1([0,3]) tensor N_3([1,3])+ : 12 56 0 -E(8)+E(8)^3
R_1(3)+ tensor R_3^0(1,5,[0,1]) : 12 56 0 E(28)^11+E(28)^15+E(28)^23
N_1([0,3]) tensor N_3([1,3])- : 12 56 0 E(8)-E(8)^3
N_1([0,3]) tensor N_3([1,0])- : 12 56 0 E(8)+E(8)^3
N_3([1,1]) tensor R_1(1)- : 12 56 0 0
N_1([0,1]) tensor N_3([1,0])+ : 12 56 0 -E(8)-E(8)^3
N_1([0,1]) tensor N_3([1,0])- : 12 56 0 E(8)+E(8)^3
N_1([0,2]) tensor N_3([1,3])+ : 12 56 0 -E(8)+E(8)^3
N_3([1,2]) tensor R_1(1)- : 12 56 0 0
N_1([0,2]) tensor N_3([1,0])- : 12 56 0 E(8)+E(8)^3
N_1([0,2]) tensor N_3([1,0])+ : 12 56 0 -E(8)-E(8)^3
N_1([0,1]) tensor N_3([1,3])- : 12 56 0 E(8)-E(8)^3
N_3([1,2]) tensor R_1(3)- : 12 56 0 0
R_1(3)+ tensor R_3^0(1,1,[0,1]) : 12 56 0 -E(28)^11-E(28)^15-E(28)^23
N_1([0,3]) tensor N_3([1,0])+ : 12 56 0 -E(8)-E(8)^3
D_1([0,1]) tensor N_1([0,1]) tensor Xi_3 : 12 60 0 -E(4)
N_1([0,2]) tensor D_2([1,0])- tensor Xi_4 : 12 60 0 E(12)^7
N_1([0,1]) tensor Xi_6 tensor R_2^0(1,3)_1 tensor Xi_4 : 12 60 0 E(3)
D_2([1,0])+ tensor R_1(1)+ tensor R_1(2)- : 12 60 0 -E(60)^19-E(60)^31
N_1([0,2]) tensor R_2^0(1,3)_1 tensor Xi_4 : 12 60 0 -E(3)
N_1([0,2]) tensor R_2^0(1,3)_1 tensor Xi_8 : 12 60 0 -E(3)^2
R_1(1)+ tensor N_1([0,1]) tensor N_2([0,1]) : 12 60 0 0
N_1([0,2]) tensor Xi_6 tensor R_2^0(1,3)_1 tensor Xi_4 : 12 60 0 E(3)
N_1([0,2]) tensor Xi_6 tensor R_2^0(1,3)_1 tensor Xi_8 : 12 60 0 E(3)^2
N_1([0,2]) tensor D_2([1,0])+ tensor Xi_8 : 12 60 0 -E(12)^11
N_1([0,2]) tensor D_2([1,0])+ tensor Xi_4 : 12 60 0 -E(12)^7
N_1([0,1]) tensor R_2^0(1,3)_1 tensor Xi_8 : 12 60 0 -E(3)^2
N_1([0,1]) tensor Xi_6 tensor R_2^0(1,3)_1 tensor Xi_8 : 12 60 0 E(3)^2
N_1([0,1]) tensor R_2^0(1,3)_1 tensor Xi_4 : 12 60 0 -E(3)
N_1(nu) tensor R_1(2)- tensor N_2([0,1]) : 12 60 0 0
D_2([1,0])+ tensor N_1([0,1]) tensor R_1(1)- : 12 60 0 -E(20)-E(20)^9
N_1([0,2]) tensor N_1(nu) tensor Xi_9 : 12 60 0 0
D_1([0,1]) tensor N_1([0,1]) tensor Xi_9 : 12 60 0 E(4)
D_1([0,1]) tensor R_1(1)+ tensor Xi_3 : 12 60 0 -E(12)^11
D_1([0,1]) tensor R_1(1)+ tensor Xi_9 : 12 60 0 E(12)^11
D_2([1,0])+ tensor R_1(2)+ tensor R_1(1)- : 12 60 0 -E(60)^23-E(60)^47
D_1([0,1]) tensor R_1(2)+ tensor Xi_3 : 12 60 0 -E(12)^7
D_1([0,1]) tensor R_1(2)+ tensor Xi_9 : 12 60 0 E(12)^7
R_2^0(1,3)_1 tensor R_1(2)+ tensor R_1(1)- : 12 60 0 -E(15)^2-E(15)^8
N_1([0,2]) tensor N_1(nu) tensor Xi_3 : 12 60 0 0
R_2^0(1,3)_1 tensor R_1(2)+ tensor R_1(2)- : 12 60 0 -E(15)^11-E(15)^14
D_2([1,0])+ tensor N_1([0,1]) tensor R_1(2)- : 12 60 0 -E(20)^13-E(20)^17
D_2([1,0])+ tensor R_1(1)+ tensor R_1(1)- : 12 60 0 -E(60)^7-E(60)^43
D_2([1,0])- tensor R_1(2)+ tensor R_1(2)- : 12 60 0 E(60)^11+E(60)^59
N_1([0,2]) tensor D_2([1,0])- tensor Xi_8 : 12 60 0 E(12)^11
R_1(2)+ tensor R_1(2)+ tensor N_2([0,1]) : 12 60 0 0
D_2([1,0])+ tensor R_1(2)+ tensor R_1(2)- : 12 60 0 -E(60)^11-E(60)^59
R_1(2)+ tensor R_1(1)+ tensor N_2([0,1]) : 12 60 0 0
R_1(1)+ tensor R_1(1)+ tensor N_2([0,1]) : 12 60 0 0
D_2([1,0])- tensor N_1([0,1]) tensor R_1(1)- : 12 60 0 E(20)+E(20)^9
D_2([1,0])- tensor N_1([0,1]) tensor R_1(2)- : 12 60 0 E(20)^13+E(20)^17
D_1([0,1]) tensor N_2([0,1]) tensor Xi_4 : 12 60 0 0
R_1(2)+ tensor N_1([0,1]) tensor N_2([0,1]) : 12 60 0 0
R_2^0(1,3)_1 tensor N_1([0,1]) tensor R_1(1)- : 12 60 0 -E(5)-E(5)^4
Xi_6 tensor R_2^0(1,3)_1 tensor R_1(1)+ tensor R_1(1)- : 12 60 0 
E(15)^7+E(15)^13
R_2^0(1,3)_1 tensor N_1([0,1]) tensor R_1(2)- : 12 60 0 -E(5)^2-E(5)^3
D_1([0,1]) tensor N_2([0,1]) tensor Xi_8 : 12 60 0 0
Xi_6 tensor R_2^0(1,3)_1 tensor N_1([0,1]) tensor R_1(2)- : 12 60 0 
E(5)^2+E(5)^3
Xi_6 tensor R_2^0(1,3)_1 tensor R_1(2)+ tensor R_1(1)- : 12 60 0 
E(15)^2+E(15)^8
Xi_6 tensor R_2^0(1,3)_1 tensor R_1(1)+ tensor R_1(2)- : 12 60 0 E(15)+E(15)^4
D_2([1,0])- tensor R_1(1)+ tensor R_1(2)- : 12 60 0 E(60)^19+E(60)^31
D_2([1,0])- tensor R_1(1)+ tensor R_1(1)- : 12 60 0 E(60)^7+E(60)^43
N_1([0,1]) tensor D_2([1,0])- tensor Xi_8 : 12 60 0 E(12)^11
N_1([0,1]) tensor N_1(nu) tensor Xi_3 : 12 60 0 0
R_1(1)+ tensor R_1(2)+ tensor N_2([0,1]) : 12 60 0 0
N_1([0,1]) tensor D_2([1,0])- tensor Xi_4 : 12 60 0 E(12)^7
N_1(nu) tensor R_1(1)- tensor N_2([0,1]) : 12 60 0 0
N_1([0,1]) tensor D_2([1,0])+ tensor Xi_8 : 12 60 0 -E(12)^11
N_1([0,1]) tensor D_2([1,0])+ tensor Xi_4 : 12 60 0 -E(12)^7
N_1([0,1]) tensor N_1(nu) tensor Xi_9 : 12 60 0 0
Xi_6 tensor R_2^0(1,3)_1 tensor R_1(2)+ tensor R_1(2)- : 12 60 0 
E(15)^11+E(15)^14
R_2^0(1,3)_1 tensor R_1(1)+ tensor R_1(2)- : 12 60 0 -E(15)-E(15)^4
R_2^0(1,3)_1 tensor R_1(1)+ tensor R_1(1)- : 12 60 0 -E(15)^7-E(15)^13
D_2([1,0])- tensor R_1(2)+ tensor R_1(1)- : 12 60 0 E(60)^23+E(60)^47
Xi_6 tensor R_2^0(1,3)_1 tensor N_1([0,1]) tensor R_1(1)- : 12 60 0 
E(5)+E(5)^4
(R_2(1)+)_1 tensor R_1(3)- : 12 63 0 E(7)^3+E(7)^5+E(7)^6
(R_2(1)+)_1 tensor R_1(1)- : 12 63 0 E(7)+E(7)^2+E(7)^4
(R_2(1)-)_1 tensor R_1(1)- : 12 63 0 E(7)+E(7)^2+E(7)^4
(R_2(1)-)_1 tensor R_1(3)- : 12 63 0 E(7)^3+E(7)^5+E(7)^6
R_2^1(2,2,[1,1]) tensor R_1(3)- : 12 63 0 E(21)+E(21)^4+E(21)^16
R_2^1(2,2,[1,1]) tensor R_1(1)- : 12 63 0 E(21)^10+E(21)^13+E(21)^19
(R_2(2)-)_1 tensor R_1(1)- : 12 63 0 E(7)+E(7)^2+E(7)^4
R_2^1(2,2,[1,0]) tensor R_1(3)- : 12 63 0 E(21)+E(21)^4+E(21)^16
R_2^1(2,2,[1,0]) tensor R_1(1)- : 12 63 0 E(21)^10+E(21)^13+E(21)^19
R_2^1(2,1,[1,1]) tensor R_1(3)- : 12 63 0 E(21)^2+E(21)^8+E(21)^11
R_2^1(2,1,[1,1]) tensor R_1(1)- : 12 63 0 E(21)^5+E(21)^17+E(21)^20
(R_2(2)+)_1 tensor R_1(1)- : 12 63 0 E(7)+E(7)^2+E(7)^4
(R_2(2)+)_1 tensor R_1(3)- : 12 63 0 E(7)^3+E(7)^5+E(7)^6
R_2^1(2,1,[1,0]) tensor R_1(3)- : 12 63 0 E(21)^2+E(21)^8+E(21)^11
R_2^1(2,1,[1,0]) tensor R_1(1)- : 12 63 0 E(21)^5+E(21)^17+E(21)^20
R_2^1(1,1,[1,0]) tensor R_1(1)- : 12 63 0 E(21)^10+E(21)^13+E(21)^19
R_2^1(1,1,[1,0]) tensor R_1(3)- : 12 63 0 E(21)+E(21)^4+E(21)^16
R_2^1(1,2,[1,1]) tensor R_1(3)- : 12 63 0 E(21)^2+E(21)^8+E(21)^11
R_2^1(1,2,[1,1]) tensor R_1(1)- : 12 63 0 E(21)^5+E(21)^17+E(21)^20
R_2^1(1,1,[1,1]) tensor R_1(1)- : 12 63 0 E(21)^10+E(21)^13+E(21)^19
R_2^1(1,1,[1,1]) tensor R_1(3)- : 12 63 0 E(21)+E(21)^4+E(21)^16
R_2^1(1,2,[1,0]) tensor R_1(3)- : 12 63 0 E(21)^2+E(21)^8+E(21)^11
(R_2(2)-)_1 tensor R_1(3)- : 12 63 0 E(7)^3+E(7)^5+E(7)^6
R_2^1(1,2,[1,0]) tensor R_1(1)- : 12 63 0 E(21)^5+E(21)^17+E(21)^20
R_6^4(3,3,nu)_1 : 12 64 0 1-E(4)
R_6^3(1,1,[1,0]) : 12 64 0 E(8)+E(8)^3
R_6^3(1,3,[1,0]) : 12 64 0 -E(8)+E(8)^3
Xi_6 tensor R_6^4(7,3,nu)_1 : 12 64 0 -1+E(4)
R_6^4(7,3,nu)_1 : 12 64 0 1-E(4)
R_6^3(1,3,[1,1]) : 12 64 0 -E(8)+E(8)^3
Xi_6 tensor R_6^4(7,1,nu)_1 : 12 64 0 -1+E(4)
R_6^4(7,1,nu)_1 : 12 64 0 1-E(4)
R_6^3(1,5,[1,0]) : 12 64 0 -E(8)-E(8)^3
Xi_6 tensor R_6^4(5,3,nu)_1 : 12 64 0 -1-E(4)
R_6^4(5,3,nu)_1 : 12 64 0 1+E(4)
R_6^3(1,5,[1,1]) : 12 64 0 -E(8)-E(8)^3
Xi_6 tensor R_6^4(5,1,nu)_1 : 12 64 0 -1-E(4)
R_6^4(5,1,nu)_1 : 12 64 0 1+E(4)
Xi_6 tensor R_6^4(3,3,nu)_1 : 12 64 0 -1+E(4)
R_6^3(1,1,[1,1]) : 12 64 0 E(8)+E(8)^3
Xi_6 tensor R_6^4(3,1,nu)_1 : 12 64 0 -1+E(4)
R_6^3(1,7,[1,1]) : 12 64 0 E(8)-E(8)^3
R_6^4(3,1,nu)_1 : 12 64 0 1-E(4)
Xi_6 tensor R_6^4(1,3,nu)_1 : 12 64 0 -1-E(4)
R_6^3(3,1,[1,0]) : 12 64 0 E(8)+E(8)^3
R_6^4(1,3,nu)_1 : 12 64 0 1+E(4)
Xi_6 tensor R_6^4(1,1,nu)_1 : 12 64 0 -1-E(4)
R_6^3(3,1,[1,1]) : 12 64 0 E(8)+E(8)^3
R_6^4(1,1,nu)_1 : 12 64 0 1+E(4)
R_6^4(7,3,[1,1]) : 12 64 0 1+E(4)
R_6^3(3,3,[1,0]) : 12 64 0 E(8)-E(8)^3
R_6^4(7,3,[1,0]) : 12 64 0 1+E(4)
R_6^4(7,1,[1,1]) : 12 64 0 -1-E(4)
R_6^3(3,3,[1,1]) : 12 64 0 E(8)-E(8)^3
R_6^4(7,1,[1,0]) : 12 64 0 -1-E(4)
R_6^4(5,3,[1,1]) : 12 64 0 1-E(4)
R_6^3(3,5,[1,0]) : 12 64 0 -E(8)-E(8)^3
R_6^4(5,3,[1,0]) : 12 64 0 1-E(4)
R_6^4(5,1,[1,1]) : 12 64 0 -1+E(4)
R_6^3(3,5,[1,1]) : 12 64 0 -E(8)-E(8)^3
R_6^4(5,1,[1,0]) : 12 64 0 -1+E(4)
R_6^4(3,3,[1,1]) : 12 64 0 1+E(4)
R_6^3(3,7,[1,0]) : 12 64 0 -E(8)+E(8)^3
R_6^4(3,3,[1,0]) : 12 64 0 1+E(4)
R_6^3(1,7,[1,0]) : 12 64 0 E(8)-E(8)^3
R_6^3(3,7,[1,1]) : 12 64 0 -E(8)+E(8)^3
R_6^4(3,1,[1,1]) : 12 64 0 -1-E(4)
R_6^4(3,1,[1,0]) : 12 64 0 -1-E(4)
R_6^3(5,1,[1,0]) : 12 64 0 -E(8)-E(8)^3
R_6^4(1,3,[1,1]) : 12 64 0 1-E(4)
R_6^4(1,3,[1,0]) : 12 64 0 1-E(4)
R_6^3(5,7,[1,0]) : 12 64 0 -E(8)+E(8)^3
R_6^4(1,1,[1,1]) : 12 64 0 -1+E(4)
R_6^4(1,1,[1,0]) : 12 64 0 -1+E(4)
R_6^3(5,3,[1,0]) : 12 64 0 E(8)-E(8)^3
R_6^3(7,7,[1,1]) : 12 64 0 E(8)-E(8)^3
R_6^3(7,7,[1,0]) : 12 64 0 E(8)-E(8)^3
R_6^3(5,3,[1,1]) : 12 64 0 E(8)-E(8)^3
R_6^3(7,5,[1,1]) : 12 64 0 E(8)+E(8)^3
R_6^3(7,5,[1,0]) : 12 64 0 E(8)+E(8)^3
R_6^3(5,5,[1,0]) : 12 64 0 E(8)+E(8)^3
R_6^3(7,3,[1,1]) : 12 64 0 -E(8)+E(8)^3
R_6^3(7,3,[1,0]) : 12 64 0 -E(8)+E(8)^3
R_6^3(5,5,[1,1]) : 12 64 0 E(8)+E(8)^3
R_6^3(7,1,[1,1]) : 12 64 0 -E(8)-E(8)^3
R_6^3(7,1,[1,0]) : 12 64 0 -E(8)-E(8)^3
R_6^3(5,1,[1,1]) : 12 64 0 -E(8)-E(8)^3
R_6^3(5,7,[1,1]) : 12 64 0 -E(8)+E(8)^3
R_1(1)- tensor R_1(1)- : 12 65 0 E(65)^2+E(65)^7+E(65)^8+E(65)^18+E(65)^28
 +E(65)^32+E(65)^33+E(65)^37+E(65)^47+E(65)^57+E(65)^58+E(65)^63
R_1(2)- tensor R_1(2)- : 12 65 0 E(65)+E(65)^4+E(65)^9+E(65)^14+E(65)^16
 +E(65)^29+E(65)^36+E(65)^49+E(65)^51+E(65)^56+E(65)^61+E(65)^64
R_1(2)- tensor R_1(1)- : 12 65 0 E(65)^3+E(65)^12+E(65)^17+E(65)^22+E(65)^23
 +E(65)^27+E(65)^38+E(65)^42+E(65)^43+E(65)^48+E(65)^53+E(65)^62
R_1(1)- tensor R_1(2)- : 12 65 0 E(65)^6+E(65)^11+E(65)^19+E(65)^21+E(65)^24
 +E(65)^31+E(65)^34+E(65)^41+E(65)^44+E(65)^46+E(65)^54+E(65)^59
D_1([0,1]) tensor Xi_10 : 12 66 0 -E(3)
D_1([0,2]) tensor Xi_10 : 12 66 0 -E(3)
R_1(2)+ tensor R_1(1)+ tensor Xi_6 : 12 66 0 -E(33)-E(33)^4-E(33)^16-E(33)^25
 -E(33)^31
R_1(1)+ tensor N_1([0,1]) tensor Xi_6 : 12 66 0 -E(11)^2-E(11)^6-E(11)^7
 -E(11)^8-E(11)^10
D_1([0,2]) tensor Xi_2 : 12 66 0 -E(3)^2
R_1(1)+ tensor R_1(1)+ tensor Xi_6 : 12 66 0 -E(33)^7-E(33)^10-E(33)^13
 -E(33)^19-E(33)^28
D_1([0,1]) tensor Xi_2 : 12 66 0 -E(3)^2
R_1(1)+ tensor R_1(2)+ tensor Xi_6 : 12 66 0 -E(33)^2-E(33)^8-E(33)^17
 -E(33)^29-E(33)^32
R_1(2)+ tensor N_1(nu) tensor Xi_8 : 12 66 0 0
R_1(2)+ tensor N_1(nu) tensor Xi_4 : 12 66 0 0
D_1([0,4]) tensor Xi_10 : 12 66 0 -E(3)
D_1([0,3]) tensor Xi_2 : 12 66 0 -E(3)^2
D_1([0,4]) tensor Xi_2 : 12 66 0 -E(3)^2
R_1(2)+ tensor R_1(2)+ tensor Xi_6 : 12 66 0 -E(33)^5-E(33)^14-E(33)^20
 -E(33)^23-E(33)^26
D_1([0,3]) tensor Xi_10 : 12 66 0 -E(3)
R_1(1)+ tensor N_1(nu) tensor Xi_4 : 12 66 0 0
R_1(1)+ tensor N_1(nu) tensor Xi_8 : 12 66 0 0
R_1(2)+ tensor N_1([0,1]) tensor Xi_6 : 12 66 0 -E(11)-E(11)^3-E(11)^4-E(11)^5
 -E(11)^9
R_1(5)+ tensor Xi_4 : 12 69 0 -E(69)^2-E(69)^8-E(69)^26-E(69)^29-E(69)^32
 -E(69)^35-E(69)^41-E(69)^47-E(69)^50-E(69)^59-E(69)^62
R_1(1)+ tensor Xi_8 : 12 69 0 -E(69)^7-E(69)^10-E(69)^19-E(69)^22-E(69)^28
 -E(69)^34-E(69)^37-E(69)^40-E(69)^43-E(69)^61-E(69)^67
R_1(5)+ tensor Xi_8 : 12 69 0 -E(69)-E(69)^4-E(69)^13-E(69)^16-E(69)^25
 -E(69)^31-E(69)^49-E(69)^52-E(69)^55-E(69)^58-E(69)^64
R_1(1)+ tensor Xi_4 : 12 69 0 -E(69)^5-E(69)^11-E(69)^14-E(69)^17-E(69)^20
 -E(69)^38-E(69)^44-E(69)^53-E(69)^56-E(69)^65-E(69)^68
N_1([0,2]) tensor R_1(2)- tensor Xi_6 : 12 70 0 E(5)^2+E(5)^3
N_1([0,2]) tensor R_1(1)- tensor Xi_6 : 12 70 0 E(5)+E(5)^4
R_1(3)+ tensor R_1(2)+ tensor Xi_6 : 12 70 0 -E(35)^3-E(35)^12-E(35)^13
 -E(35)^17-E(35)^27-E(35)^33
R_1(3)- tensor R_1(1)- tensor N_1(nu) : 12 70 0 0
N_1([0,1]) tensor R_1(2)- tensor Xi_6 : 12 70 0 E(5)^2+E(5)^3
N_1([0,2]) tensor R_1(1)- tensor Xi_6 : 12 70 0 E(7)+E(7)^2+E(7)^4
R_1(3)- tensor R_1(2)- tensor N_1(nu) : 12 70 0 0
R_1(3)+ tensor R_1(1)+ tensor Xi_6 : 12 70 0 -E(35)^6-E(35)^19-E(35)^24
 -E(35)^26-E(35)^31-E(35)^34
R_1(1)- tensor R_1(2)- tensor N_1(nu) : 12 70 0 0
N_1([0,2]) tensor R_1(3)- tensor Xi_6 : 12 70 0 E(7)^3+E(7)^5+E(7)^6
N_1([0,1]) tensor R_1(1)- tensor Xi_6 : 12 70 0 E(7)+E(7)^2+E(7)^4
N_1([0,1]) tensor R_1(1)- tensor Xi_6 : 12 70 0 E(5)+E(5)^4
R_1(1)- tensor R_1(1)- tensor N_1(nu) : 12 70 0 0
N_1([0,3]) tensor R_1(2)- tensor Xi_6 : 12 70 0 E(5)^2+E(5)^3
N_1([0,1]) tensor R_1(3)- tensor Xi_6 : 12 70 0 E(7)^3+E(7)^5+E(7)^6
R_1(1)+ tensor R_1(1)+ tensor Xi_6 : 12 70 0 -E(35)-E(35)^4-E(35)^9-E(35)^11
 -E(35)^16-E(35)^29
N_1([0,3]) tensor R_1(1)- tensor Xi_6 : 12 70 0 E(5)+E(5)^4
R_1(1)+ tensor R_1(2)+ tensor Xi_6 : 12 70 0 -E(35)^2-E(35)^8-E(35)^18
 -E(35)^22-E(35)^23-E(35)^32
(R_2(1)-)_1 tensor R_3^0(1,3,[0,1])+ : 12 72 0 -1
R_2^1(2,2,[1,1]) tensor R_3^0(1,3,[0,1])+ : 12 72 0 -E(3)
R_2^1(2,2,[1,1]) tensor R_3^0(1,3,[0,1])- : 12 72 0 -E(3)
R_2^1(2,1,[1,1]) tensor R_3^0(1,7,[0,1])- : 12 72 0 E(3)^2
N_2([1,2]) tensor N_3([1,0])+ : 12 72 0 0
N_2([1,0]) tensor N_3([1,0])+ : 12 72 0 0
R_2^1(2,1,[1,1]) tensor R_3^0(1,7,[0,1])+ : 12 72 0 E(3)^2
R_2^1(2,1,[1,1]) tensor R_3^0(1,3,[0,1])- : 12 72 0 -E(3)^2
R_2^1(2,2,[1,1]) tensor R_3^0(1,7,[0,1])+ : 12 72 0 E(3)
R_2^1(2,1,[1,1]) tensor R_3^0(1,3,[0,1])+ : 12 72 0 -E(3)^2
R_2^1(2,1,[1,1]) tensor R_3^0(3,5,[0,1]) : 12 72 0 E(12)^11
N_2([1,1]) tensor N_3([1,3])+ : 12 72 0 0
R_2^1(2,1,[1,1]) tensor R_3^0(3,1,[0,1]) : 12 72 0 -E(12)^11
N_2([2,1]) tensor N_3([1,0])+ : 12 72 0 0
R_2^1(2,2,[1,1]) tensor R_3^0(1,7,[0,1])- : 12 72 0 E(3)
R_2^1(2,1,[1,1]) tensor R_3^0(1,5,[0,1]) : 12 72 0 -E(12)^11
(R_2(1)-)_1 tensor R_3^0(1,7,[0,1])- : 12 72 0 1
(R_2(2)-)_1 tensor R_3^0(1,7,[0,1])- : 12 72 0 1
(R_2(2)-)_1 tensor R_3^0(1,5,[0,1]) : 12 72 0 -E(4)
R_2^1(2,1,[1,1]) tensor R_3^0(1,1,[0,1]) : 12 72 0 E(12)^11
(R_2(1)-)_1 tensor R_3^0(1,7,[0,1])+ : 12 72 0 1
R_2^1(2,2,[1,1]) tensor R_3^0(3,5,[0,1]) : 12 72 0 E(12)^7
N_2([2,1]) tensor N_3([1,0])- : 12 72 0 0
N_2([1,0]) tensor N_3([1,0])- : 12 72 0 0
R_2^1(2,2,[1,1]) tensor R_3^0(3,1,[0,1]) : 12 72 0 -E(12)^7
R_2^1(2,2,[1,1]) tensor R_3^0(1,5,[0,1]) : 12 72 0 -E(12)^7
(R_2(1)-)_1 tensor R_3^0(1,3,[0,1])- : 12 72 0 -1
(R_2(2)-)_1 tensor R_3^0(3,1,[0,1]) : 12 72 0 -E(4)
N_2([2,1]) tensor N_3([1,3])+ : 12 72 0 0
N_2([1,0]) tensor N_3([1,3])+ : 12 72 0 0
N_2([2,1]) tensor N_3([1,3])- : 12 72 0 0
R_2^1(2,2,[1,0]) tensor R_3^0(1,1,[0,1]) : 12 72 0 E(12)^7
R_2^1(2,2,[1,0]) tensor R_3^0(1,5,[0,1]) : 12 72 0 -E(12)^7
R_2^1(2,2,[1,0]) tensor R_3^0(1,7,[0,1])+ : 12 72 0 E(3)
R_2^1(2,1,[1,0]) tensor R_3^0(1,7,[0,1])- : 12 72 0 E(3)^2
N_2([1,0]) tensor N_3([1,3])- : 12 72 0 0
R_2^1(2,1,[1,0]) tensor R_3^0(1,7,[0,1])+ : 12 72 0 E(3)^2
R_2^1(2,1,[1,0]) tensor R_3^0(1,3,[0,1])- : 12 72 0 -E(3)^2
R_2^1(2,2,[1,1]) tensor R_3^0(1,1,[0,1]) : 12 72 0 E(12)^7
R_2^1(2,1,[1,0]) tensor R_3^0(1,3,[0,1])+ : 12 72 0 -E(3)^2
(R_2(1)-)_1 tensor R_3^0(3,5,[0,1]) : 12 72 0 E(4)
(R_2(2)-)_1 tensor R_3^0(1,7,[0,1])+ : 12 72 0 1
(R_2(2)-)_1 tensor R_3^0(1,1,[0,1]) : 12 72 0 E(4)
R_2^1(2,1,[1,0]) tensor R_3^0(3,5,[0,1]) : 12 72 0 E(12)^11
(R_2(1)+)_1 tensor R_3^0(1,7,[0,1])- : 12 72 0 1
N_2([1,2]) tensor N_3([1,3])- : 12 72 0 0
R_2^1(2,1,[1,0]) tensor R_3^0(3,1,[0,1]) : 12 72 0 -E(12)^11
(R_2(1)+)_1 tensor R_3^0(1,7,[0,1])+ : 12 72 0 1
R_2^1(2,1,[1,0]) tensor R_3^0(1,5,[0,1]) : 12 72 0 -E(12)^11
R_2^1(2,1,[1,0]) tensor R_3^0(1,1,[0,1]) : 12 72 0 E(12)^11
(R_2(1)-)_1 tensor R_3^0(3,1,[0,1]) : 12 72 0 -E(4)
(R_2(2)-)_1 tensor R_3^0(1,3,[0,1])+ : 12 72 0 -1
R_2^1(2,2,[1,0]) tensor R_3^0(3,1,[0,1]) : 12 72 0 -E(12)^7
(R_2(1)+)_1 tensor R_3^0(1,1,[0,1]) : 12 72 0 E(4)
R_2^1(1,2,[1,1]) tensor R_3^0(1,7,[0,1])- : 12 72 0 E(3)^2
R_2^1(2,2,[1,0]) tensor R_3^0(3,5,[0,1]) : 12 72 0 E(12)^7
(R_2(1)+)_1 tensor R_3^0(1,5,[0,1]) : 12 72 0 -E(4)
(R_2(1)-)_1 tensor R_3^0(1,5,[0,1]) : 12 72 0 -E(4)
R_2^1(1,2,[1,1]) tensor R_3^0(1,7,[0,1])+ : 12 72 0 E(3)^2
(R_2(1)+)_1 tensor R_3^0(3,1,[0,1]) : 12 72 0 -E(4)
(R_2(2)+)_1 tensor R_3^0(1,1,[0,1]) : 12 72 0 E(4)
(R_2(2)+)_1 tensor R_3^0(1,5,[0,1]) : 12 72 0 -E(4)
(R_2(1)+)_1 tensor R_3^0(3,5,[0,1]) : 12 72 0 E(4)
R_2^1(1,2,[1,1]) tensor R_3^0(1,3,[0,1])- : 12 72 0 -E(3)^2
(R_2(2)+)_1 tensor R_3^0(3,1,[0,1]) : 12 72 0 -E(4)
(R_2(1)-)_1 tensor R_3^0(1,1,[0,1]) : 12 72 0 E(4)
(R_2(2)+)_1 tensor R_3^0(3,5,[0,1]) : 12 72 0 E(4)
R_2^1(1,2,[1,1]) tensor R_3^0(1,3,[0,1])+ : 12 72 0 -E(3)^2
(R_2(1)+)_1 tensor R_3^0(1,3,[0,1])+ : 12 72 0 -1
R_2^1(1,2,[1,1]) tensor R_3^0(3,5,[0,1]) : 12 72 0 E(12)^11
(R_2(2)+)_1 tensor R_3^0(1,3,[0,1])+ : 12 72 0 -1
R_2^1(2,2,[1,0]) tensor R_3^0(1,3,[0,1])+ : 12 72 0 -E(3)
N_2([1,1]) tensor N_3([1,0])+ : 12 72 0 0
R_2^1(1,2,[1,1]) tensor R_3^0(1,5,[0,1]) : 12 72 0 -E(12)^11
(R_2(1)+)_1 tensor R_3^0(1,3,[0,1])- : 12 72 0 -1
R_2^1(1,2,[1,1]) tensor R_3^0(1,1,[0,1]) : 12 72 0 E(12)^11
R_2^1(1,1,[1,0]) tensor R_3^0(1,1,[0,1]) : 12 72 0 E(12)^7
(R_2(2)-)_1 tensor R_3^0(1,3,[0,1])- : 12 72 0 -1
R_2^1(1,1,[1,0]) tensor R_3^0(1,5,[0,1]) : 12 72 0 -E(12)^7
(R_2(2)+)_1 tensor R_3^0(1,3,[0,1])- : 12 72 0 -1
R_2^1(1,1,[1,0]) tensor R_3^0(3,1,[0,1]) : 12 72 0 -E(12)^7
R_2^1(1,1,[1,0]) tensor R_3^0(3,5,[0,1]) : 12 72 0 E(12)^7
(R_2(2)-)_1 tensor R_3^0(3,5,[0,1]) : 12 72 0 E(4)
R_2^1(1,1,[1,0]) tensor R_3^0(1,3,[0,1])+ : 12 72 0 -E(3)
R_2^1(1,1,[1,0]) tensor R_3^0(1,3,[0,1])- : 12 72 0 -E(3)
(R_2(2)+)_1 tensor R_3^0(1,7,[0,1])+ : 12 72 0 1
R_2^1(1,1,[1,0]) tensor R_3^0(1,7,[0,1])+ : 12 72 0 E(3)
R_2^1(1,1,[1,0]) tensor R_3^0(1,7,[0,1])- : 12 72 0 E(3)
(R_2(2)+)_1 tensor R_3^0(1,7,[0,1])- : 12 72 0 1
R_2^1(1,2,[1,0]) tensor R_3^0(1,7,[0,1])- : 12 72 0 E(3)^2
R_2^1(1,2,[1,0]) tensor R_3^0(1,7,[0,1])+ : 12 72 0 E(3)^2
R_2^1(1,2,[1,0]) tensor R_3^0(1,3,[0,1])- : 12 72 0 -E(3)^2
R_2^1(1,2,[1,0]) tensor R_3^0(1,3,[0,1])+ : 12 72 0 -E(3)^2
R_2^1(1,2,[1,0]) tensor R_3^0(3,5,[0,1]) : 12 72 0 E(12)^11
R_2^1(1,2,[1,0]) tensor R_3^0(3,1,[0,1]) : 12 72 0 -E(12)^11
R_2^1(1,2,[1,0]) tensor R_3^0(1,5,[0,1]) : 12 72 0 -E(12)^11
R_2^1(1,2,[1,0]) tensor R_3^0(1,1,[0,1]) : 12 72 0 E(12)^11
R_2^1(1,1,[1,1]) tensor R_3^0(1,1,[0,1]) : 12 72 0 E(12)^7
N_2([1,2]) tensor N_3([1,0])- : 12 72 0 0
R_2^1(1,1,[1,1]) tensor R_3^0(1,5,[0,1]) : 12 72 0 -E(12)^7
R_2^1(2,2,[1,0]) tensor R_3^0(1,3,[0,1])- : 12 72 0 -E(3)
R_2^1(1,1,[1,1]) tensor R_3^0(3,1,[0,1]) : 12 72 0 -E(12)^7
R_2^1(1,1,[1,1]) tensor R_3^0(3,5,[0,1]) : 12 72 0 E(12)^7
R_2^1(1,1,[1,1]) tensor R_3^0(1,3,[0,1])+ : 12 72 0 -E(3)
N_2([1,2]) tensor N_3([1,3])+ : 12 72 0 0
R_2^1(1,1,[1,1]) tensor R_3^0(1,3,[0,1])- : 12 72 0 -E(3)
R_2^1(1,1,[1,1]) tensor R_3^0(1,7,[0,1])+ : 12 72 0 E(3)
R_2^1(1,1,[1,1]) tensor R_3^0(1,7,[0,1])- : 12 72 0 E(3)
R_2^1(2,2,[1,0]) tensor R_3^0(1,7,[0,1])- : 12 72 0 E(3)
N_2([1,1]) tensor N_3([1,0])- : 12 72 0 0
R_2^1(1,2,[1,1]) tensor R_3^0(3,1,[0,1]) : 12 72 0 -E(12)^11
N_2([1,1]) tensor N_3([1,3])- : 12 72 0 0
R_2^1(1,1,[2,0]) tensor Xi_4 : 12 75 0 E(15)^2+E(15)^8
R_2^1(1,1,[1,0]) tensor Xi_4 : 12 75 0 E(15)^2+E(15)^8
(R_2(1)+)_1 tensor Xi_4 : 12 75 0 2*E(3)
R_2^1(2,2,[2,1]) tensor Xi_4 : 12 75 0 E(15)^2+E(15)^8
R_2^1(1,1,[1,0]) tensor Xi_8 : 12 75 0 E(15)^7+E(15)^13
R_2^1(1,1,[1,1]) tensor Xi_4 : 12 75 0 E(15)^2+E(15)^8
R_2^1(2,2,[2,0]) tensor Xi_8 : 12 75 0 E(15)^7+E(15)^13
(R_2(1)-)_1 tensor Xi_4 : 12 75 0 2*E(3)
R_2^1(1,1,[1,1]) tensor Xi_8 : 12 75 0 E(15)^7+E(15)^13
(R_2(1)+)_1 tensor Xi_8 : 12 75 0 2*E(3)^2
R_2^1(2,2,[2,0]) tensor Xi_4 : 12 75 0 E(15)^2+E(15)^8
R_2^1(2,2,[1,1]) tensor Xi_8 : 12 75 0 E(15)^7+E(15)^13
(R_2(1)-)_1 tensor Xi_8 : 12 75 0 2*E(3)^2
(R_2(2)+)_1 tensor Xi_4 : 12 75 0 2*E(3)
R_2^1(2,2,[1,1]) tensor Xi_4 : 12 75 0 E(15)^2+E(15)^8
R_2^1(2,2,[1,0]) tensor Xi_8 : 12 75 0 E(15)^7+E(15)^13
(R_2(2)+)_1 tensor Xi_8 : 12 75 0 2*E(3)^2
R_2^1(2,2,[1,0]) tensor Xi_4 : 12 75 0 E(15)^2+E(15)^8
R_2^1(1,1,[2,0]) tensor Xi_8 : 12 75 0 E(15)^7+E(15)^13
R_2^1(1,1,[2,1]) tensor Xi_4 : 12 75 0 E(15)^2+E(15)^8
R_2^1(1,1,[2,1]) tensor Xi_8 : 12 75 0 E(15)^7+E(15)^13
R_2^1(1,2,[1,0]) tensor Xi_4 : 12 75 0 E(15)^11+E(15)^14
R_2^1(2,1,[2,1]) tensor Xi_8 : 12 75 0 E(15)+E(15)^4
(R_2(2)-)_1 tensor Xi_4 : 12 75 0 2*E(3)
R_2^1(1,2,[1,0]) tensor Xi_8 : 12 75 0 E(15)+E(15)^4
R_2^1(1,2,[1,1]) tensor Xi_4 : 12 75 0 E(15)^11+E(15)^14
R_2^1(1,2,[1,1]) tensor Xi_8 : 12 75 0 E(15)+E(15)^4
R_2^1(1,2,[2,0]) tensor Xi_4 : 12 75 0 E(15)^11+E(15)^14
(R_2(2)-)_1 tensor Xi_8 : 12 75 0 2*E(3)^2
R_2^1(1,2,[2,1]) tensor Xi_4 : 12 75 0 E(15)^11+E(15)^14
R_2^1(1,2,[2,1]) tensor Xi_8 : 12 75 0 E(15)+E(15)^4
R_2^1(2,1,[1,0]) tensor Xi_4 : 12 75 0 E(15)^11+E(15)^14
R_2^1(2,1,[1,0]) tensor Xi_8 : 12 75 0 E(15)+E(15)^4
R_2^1(2,1,[1,1]) tensor Xi_4 : 12 75 0 E(15)^11+E(15)^14
R_2^1(2,1,[2,1]) tensor Xi_4 : 12 75 0 E(15)^11+E(15)^14
R_2^1(2,1,[2,0]) tensor Xi_8 : 12 75 0 E(15)+E(15)^4
R_2^1(2,1,[2,0]) tensor Xi_4 : 12 75 0 E(15)^11+E(15)^14
R_2^1(1,2,[2,0]) tensor Xi_8 : 12 75 0 E(15)+E(15)^4
R_2^1(2,1,[1,1]) tensor Xi_8 : 12 75 0 E(15)+E(15)^4
R_2^1(2,2,[2,1]) tensor Xi_8 : 12 75 0 E(15)^7+E(15)^13
R_1(2)- tensor N_1(nu) tensor Xi_8 : 12 78 0 0
R_1(2)- tensor R_1(1)+ tensor Xi_6 : 12 78 0 E(39)^2+E(39)^5+E(39)^8+E(39)^11
 +E(39)^20+E(39)^32
R_1(2)- tensor N_1(nu) tensor Xi_4 : 12 78 0 0
R_1(2)- tensor N_1([0,1]) tensor Xi_6 : 12 78 0 E(13)^2+E(13)^5+E(13)^6
 +E(13)^7+E(13)^8+E(13)^11
R_1(2)- tensor R_1(2)+ tensor Xi_6 : 12 78 0 E(39)^7+E(39)^19+E(39)^28
 +E(39)^31+E(39)^34+E(39)^37
R_1(1)- tensor N_1(nu) tensor Xi_8 : 12 78 0 0
R_1(1)- tensor N_1(nu) tensor Xi_4 : 12 78 0 0
N_1([0,3]) tensor Xi_2 : 12 78 0 E(3)^2
R_1(1)- tensor R_1(2)+ tensor Xi_6 : 12 78 0 E(39)+E(39)^4+E(39)^10+E(39)^16
 +E(39)^22+E(39)^25
R_1(1)- tensor R_1(1)+ tensor Xi_6 : 12 78 0 E(39)^14+E(39)^17+E(39)^23
 +E(39)^29+E(39)^35+E(39)^38
R_1(1)- tensor N_1([0,1]) tensor Xi_6 : 12 78 0 E(13)+E(13)^3+E(13)^4+E(13)^9
 +E(13)^10+E(13)^12
N_1([0,6]) tensor Xi_10 : 12 78 0 E(3)
N_1([0,3]) tensor Xi_10 : 12 78 0 E(3)
N_1([0,6]) tensor Xi_2 : 12 78 0 E(3)^2
N_1([0,5]) tensor Xi_10 : 12 78 0 E(3)
N_1([0,5]) tensor Xi_2 : 12 78 0 E(3)^2
N_1([0,4]) tensor Xi_10 : 12 78 0 E(3)
N_1([0,2]) tensor Xi_10 : 12 78 0 E(3)
N_1([0,4]) tensor Xi_2 : 12 78 0 E(3)^2
N_1([0,2]) tensor Xi_2 : 12 78 0 E(3)^2
N_1([0,1]) tensor Xi_10 : 12 78 0 E(3)
N_1([0,1]) tensor Xi_2 : 12 78 0 E(3)^2
R_4^0(1,1,[1,1]) tensor R_1(2)- : 12 80 0 0
N_1([0,2]) tensor R_4^0(3,1,[1,2])+ : 12 80 0 E(8)^3
N_1([0,2]) tensor R_4^0(1,5,[0,1])+ : 12 80 0 -E(8)^3
N_1([0,2]) tensor R_4^0(1,5,[0,1])- : 12 80 0 E(8)^3
N_1([0,2]) tensor R_4^0(3,1,[1,0])- : 12 80 0 E(8)^3
N_1([0,2]) tensor R_4^0(3,1,[1,0])+ : 12 80 0 -E(8)^3
N_1([0,2]) tensor R_4^0(1,1,[1,2])- : 12 80 0 -E(8)
N_1([0,2]) tensor R_4^0(1,1,[1,2])+ : 12 80 0 E(8)
N_1([0,2]) tensor R_4^0(1,1,[1,0])- : 12 80 0 E(8)
N_1([0,2]) tensor R_4^0(1,1,[1,0])+ : 12 80 0 -E(8)
N_1([0,1]) tensor R_4^0(3,5,[2,1])- : 12 80 0 -E(8)
N_1([0,1]) tensor R_4^0(3,5,[2,1])+ : 12 80 0 E(8)
N_1([0,1]) tensor R_4^0(3,5,[0,1])- : 12 80 0 E(8)
N_1([0,1]) tensor R_4^0(3,5,[0,1])+ : 12 80 0 -E(8)
N_1([0,2]) tensor R_4^0(1,5,[2,1])+ : 12 80 0 E(8)^3
N_1([0,2]) tensor R_4^0(1,5,[2,1])- : 12 80 0 -E(8)^3
R_4^0(1,1,[1,1]) tensor R_1(1)- : 12 80 0 0
N_1([0,2]) tensor R_4^0(3,1,[1,2])- : 12 80 0 -E(8)^3
R_4^0(3,1,[1,1]) tensor R_1(1)- : 12 80 0 0
R_4^0(3,1,[1,1]) tensor R_1(2)- : 12 80 0 0
R_4^0(1,5,[1,0]) tensor R_1(1)- : 12 80 0 0
N_1([0,1]) tensor R_4^0(1,5,[2,1])- : 12 80 0 -E(8)^3
N_1([0,1]) tensor R_4^0(1,5,[2,1])+ : 12 80 0 E(8)^3
R_4^0(1,5,[1,0]) tensor R_1(2)- : 12 80 0 0
R_4^0(3,5,[1,0]) tensor R_1(1)- : 12 80 0 0
R_4^0(3,5,[1,0]) tensor R_1(2)- : 12 80 0 0
N_1([0,2]) tensor R_4^0(3,5,[0,1])- : 12 80 0 E(8)
N_1([0,2]) tensor R_4^0(3,5,[2,1])+ : 12 80 0 E(8)
N_1([0,2]) tensor R_4^0(3,5,[2,1])- : 12 80 0 -E(8)
R_4^0(1,3,[1,0])+ tensor R_1(1)- : 12 80 0 0
R_4^0(1,3,[1,0])+ tensor R_1(2)- : 12 80 0 0
R_4^0(1,3,[1,0])- tensor R_1(1)- : 12 80 0 0
R_4^0(1,3,[1,0])- tensor R_1(2)- : 12 80 0 0
R_4^0(1,3,[1,1])+ tensor R_1(1)- : 12 80 0 0
R_4^0(1,3,[1,1])+ tensor R_1(2)- : 12 80 0 0
N_1([0,1]) tensor R_4^0(1,5,[0,1])- : 12 80 0 E(8)^3
N_1([0,1]) tensor R_4^0(1,5,[0,1])+ : 12 80 0 -E(8)^3
R_4^0(1,3,[1,1])- tensor R_1(1)- : 12 80 0 0
R_4^0(1,3,[1,1])- tensor R_1(2)- : 12 80 0 0
N_1([0,1]) tensor R_4^0(3,1,[1,2])- : 12 80 0 -E(8)^3
N_1([0,1]) tensor R_4^0(3,1,[1,2])+ : 12 80 0 E(8)^3
R_4^0(1,7,[1,0])+ tensor R_1(1)- : 12 80 0 0
R_4^0(1,7,[1,0])+ tensor R_1(2)- : 12 80 0 0
N_1([0,1]) tensor R_4^0(3,1,[1,0])- : 12 80 0 E(8)^3
N_1([0,1]) tensor R_4^0(3,1,[1,0])+ : 12 80 0 -E(8)^3
R_4^0(1,7,[1,0])- tensor R_1(1)- : 12 80 0 0
R_4^0(1,7,[1,0])- tensor R_1(2)- : 12 80 0 0
N_1([0,1]) tensor R_4^0(1,1,[1,2])- : 12 80 0 -E(8)
R_4^0(1,7,[1,1])+ tensor R_1(1)- : 12 80 0 0
R_4^0(1,7,[1,1])+ tensor R_1(2)- : 12 80 0 0
R_4^0(1,7,[1,1])- tensor R_1(1)- : 12 80 0 0
R_4^0(1,7,[1,1])- tensor R_1(2)- : 12 80 0 0
R_4^2(1,1,[0,1]) tensor R_1(1)- : 12 80 0 E(20)-E(20)^4+E(20)^9-E(20)^16
N_1([0,1]) tensor R_4^0(1,1,[1,0])+ : 12 80 0 -E(8)
R_4^2(1,3,[0,1]) tensor R_1(1)- : 12 80 0 E(20)+E(20)^4+E(20)^9+E(20)^16
R_4^2(1,3,[0,1]) tensor R_1(2)- : 12 80 0 E(20)^8+E(20)^12+E(20)^13+E(20)^17
Xi_6 tensor R_4^2(1,3,[0,1]) tensor R_1(1)- : 12 80 0 -E(20)-E(20)^4-E(20)^9
 -E(20)^16
Xi_6 tensor R_4^2(1,3,[0,1]) tensor R_1(2)- : 12 80 0 -E(20)^8-E(20)^12
 -E(20)^13-E(20)^17
N_1([0,1]) tensor R_4^0(1,1,[1,2])+ : 12 80 0 E(8)
N_1([0,1]) tensor R_4^0(1,1,[1,0])- : 12 80 0 E(8)
R_4^2(3,1,[0,1]) tensor R_1(1)- : 12 80 0 -E(20)-E(20)^4-E(20)^9-E(20)^16
R_4^2(3,1,[0,1]) tensor R_1(2)- : 12 80 0 -E(20)^8-E(20)^12-E(20)^13-E(20)^17
R_4^2(3,3,[0,1]) tensor R_1(1)- : 12 80 0 -E(20)+E(20)^4-E(20)^9+E(20)^16
R_4^2(3,3,[0,1]) tensor R_1(2)- : 12 80 0 E(20)^8+E(20)^12-E(20)^13-E(20)^17
N_1([0,2]) tensor R_4^0(3,5,[0,1])+ : 12 80 0 -E(8)
Xi_6 tensor R_4^2(3,3,[0,1]) tensor R_1(2)- : 12 80 0 -E(20)^8-E(20)^12
 +E(20)^13+E(20)^17
R_4^2(1,3,nu)_1 tensor R_1(1)- : 12 80 0 -E(20)+E(20)^4-E(20)^9+E(20)^16
R_4^2(1,3,nu)_1 tensor R_1(2)- : 12 80 0 E(20)^8+E(20)^12-E(20)^13-E(20)^17
R_4^2(3,3,nu)_1 tensor R_1(1)- : 12 80 0 E(20)+E(20)^4+E(20)^9+E(20)^16
R_4^2(3,3,nu)_1 tensor R_1(2)- : 12 80 0 E(20)^8+E(20)^12+E(20)^13+E(20)^17
R_4^2(1,1,[0,1]) tensor R_1(2)- : 12 80 0 -E(20)^8-E(20)^12+E(20)^13+E(20)^17
Xi_6 tensor R_4^2(3,3,[0,1]) tensor R_1(1)- : 12 80 0 E(20)-E(20)^4+E(20)^9
 -E(20)^16
N_1([0,3]) tensor N_2([0,1]) tensor Xi_4 : 12 84 0 0
R_1(3)+ tensor D_2([1,0])+ tensor Xi_4 : 12 84 0 -E(84)^13-E(84)^61-E(84)^73
R_1(1)+ tensor Xi_6 tensor R_2^0(1,3)_1 tensor Xi_8 : 12 84 0 
E(21)^2+E(21)^8+E(21)^11
N_1([0,3]) tensor R_1(2)+ tensor Xi_9 : 12 84 0 -E(12)^7
N_1([0,3]) tensor R_1(2)+ tensor Xi_3 : 12 84 0 E(12)^7
R_1(1)- tensor R_1(2)+ tensor N_2([0,1]) : 12 84 0 0
R_1(1)+ tensor Xi_6 tensor R_2^0(1,3)_1 tensor Xi_4 : 12 84 0 
E(21)+E(21)^4+E(21)^16
R_1(1)+ tensor R_2^0(1,3)_1 tensor Xi_8 : 12 84 0 -E(21)^2-E(21)^8-E(21)^11
N_1([0,3]) tensor R_1(1)+ tensor Xi_9 : 12 84 0 -E(12)^11
R_1(3)+ tensor D_2([1,0])+ tensor Xi_8 : 12 84 0 -E(84)^5-E(84)^17-E(84)^41
R_1(3)+ tensor D_2([1,0])- tensor Xi_4 : 12 84 0 E(84)^13+E(84)^61+E(84)^73
R_1(3)+ tensor D_2([1,0])- tensor Xi_8 : 12 84 0 E(84)^5+E(84)^17+E(84)^41
R_1(1)- tensor R_1(1)+ tensor N_2([0,1]) : 12 84 0 0
N_1([0,3]) tensor N_2([0,1]) tensor Xi_8 : 12 84 0 0
R_1(3)+ tensor R_2^0(1,3)_1 tensor Xi_4 : 12 84 0 -E(21)^10-E(21)^13-E(21)^19
N_1([0,1]) tensor N_1([0,1]) tensor Xi_9 : 12 84 0 -E(4)
N_1([0,1]) tensor R_1(1)+ tensor Xi_3 : 12 84 0 E(12)^11
R_1(3)+ tensor R_2^0(1,3)_1 tensor Xi_8 : 12 84 0 -E(21)^5-E(21)^17-E(21)^20
N_1([0,3]) tensor R_1(1)+ tensor Xi_3 : 12 84 0 E(12)^11
R_1(1)+ tensor R_2^0(1,3)_1 tensor Xi_4 : 12 84 0 -E(21)-E(21)^4-E(21)^16
R_1(3)+ tensor Xi_6 tensor R_2^0(1,3)_1 tensor Xi_4 : 12 84 0 
E(21)^10+E(21)^13+E(21)^19
N_1([0,1]) tensor R_1(1)+ tensor Xi_9 : 12 84 0 -E(12)^11
N_1([0,1]) tensor R_1(2)+ tensor Xi_3 : 12 84 0 E(12)^7
R_1(3)+ tensor Xi_6 tensor R_2^0(1,3)_1 tensor Xi_8 : 12 84 0 E(21)^5+E(21)^17
 +E(21)^20
R_1(1)+ tensor D_2([1,0])- tensor Xi_8 : 12 84 0 E(84)^29+E(84)^53+E(84)^65
N_1([0,3]) tensor N_1([0,1]) tensor Xi_9 : 12 84 0 -E(4)
N_1([0,1]) tensor R_1(2)+ tensor Xi_9 : 12 84 0 -E(12)^7
N_1([0,3]) tensor N_1([0,1]) tensor Xi_3 : 12 84 0 E(4)
R_1(1)+ tensor D_2([1,0])- tensor Xi_4 : 12 84 0 E(84)+E(84)^25+E(84)^37
N_1([0,1]) tensor N_1([0,1]) tensor Xi_3 : 12 84 0 E(4)
R_1(1)+ tensor D_2([1,0])+ tensor Xi_8 : 12 84 0 -E(84)^29-E(84)^53-E(84)^65
R_1(1)+ tensor D_2([1,0])+ tensor Xi_4 : 12 84 0 -E(84)-E(84)^25-E(84)^37
R_1(3)- tensor N_1([0,1]) tensor N_2([0,1]) : 12 84 0 0
R_1(1)- tensor N_1([0,1]) tensor N_2([0,1]) : 12 84 0 0
R_1(1)+ tensor N_1(nu) tensor Xi_9 : 12 84 0 0
N_1([0,2]) tensor R_1(1)+ tensor Xi_9 : 12 84 0 -E(12)^11
N_1([0,2]) tensor N_2([0,1]) tensor Xi_4 : 12 84 0 0
N_1([0,1]) tensor N_2([0,1]) tensor Xi_4 : 12 84 0 0
N_1([0,1]) tensor N_2([0,1]) tensor Xi_8 : 12 84 0 0
R_1(1)+ tensor N_1(nu) tensor Xi_3 : 12 84 0 0
R_1(3)- tensor R_1(1)+ tensor N_2([0,1]) : 12 84 0 0
R_1(3)+ tensor N_1(nu) tensor Xi_3 : 12 84 0 0
R_1(3)+ tensor N_1(nu) tensor Xi_9 : 12 84 0 0
N_1([0,2]) tensor N_1([0,1]) tensor Xi_3 : 12 84 0 E(4)
N_1([0,2]) tensor N_1([0,1]) tensor Xi_9 : 12 84 0 -E(4)
N_1([0,2]) tensor R_1(1)+ tensor Xi_3 : 12 84 0 E(12)^11
N_1([0,2]) tensor R_1(2)+ tensor Xi_9 : 12 84 0 -E(12)^7
N_1([0,2]) tensor N_2([0,1]) tensor Xi_8 : 12 84 0 0
N_1([0,2]) tensor R_1(2)+ tensor Xi_3 : 12 84 0 E(12)^7
R_1(3)- tensor R_1(2)+ tensor N_2([0,1]) : 12 84 0 0
R_1(1)+ tensor N_3([1,3])- : 12 88 0 -E(88)+E(88)^3-E(88)^9-E(88)^25+E(88)^27
 -E(88)^49+E(88)^59+E(88)^67+E(88)^75-E(88)^81
R_1(2)+ tensor N_3([1,0])+ : 12 88 0 -E(88)^17-E(88)^19-E(88)^35-E(88)^41
 -E(88)^43-E(88)^51-E(88)^57-E(88)^65-E(88)^73-E(88)^83
R_1(1)+ tensor N_3([1,3])+ : 12 88 0 E(88)-E(88)^3+E(88)^9+E(88)^25-E(88)^27
 +E(88)^49-E(88)^59-E(88)^67-E(88)^75+E(88)^81
R_1(2)+ tensor N_3([1,0])- : 12 88 0 E(88)^17+E(88)^19+E(88)^35+E(88)^41
 +E(88)^43+E(88)^51+E(88)^57+E(88)^65+E(88)^73+E(88)^83
R_1(1)+ tensor N_3([1,0])- : 12 88 0 E(88)+E(88)^3+E(88)^9+E(88)^25+E(88)^27
 +E(88)^49+E(88)^59+E(88)^67+E(88)^75+E(88)^81
R_1(2)+ tensor N_3([1,3])+ : 12 88 0 E(88)^17-E(88)^19-E(88)^35+E(88)^41
 -E(88)^43-E(88)^51+E(88)^57+E(88)^65+E(88)^73-E(88)^83
R_1(2)+ tensor N_3([1,3])- : 12 88 0 -E(88)^17+E(88)^19+E(88)^35-E(88)^41
 +E(88)^43+E(88)^51-E(88)^57-E(88)^65-E(88)^73+E(88)^83
R_1(1)+ tensor N_3([1,0])+ : 12 88 0 -E(88)-E(88)^3-E(88)^9-E(88)^25-E(88)^27
 -E(88)^49-E(88)^59-E(88)^67-E(88)^75-E(88)^81
R_2^1(1,1,[1,1]) tensor R_1(1)+ tensor Xi_6 : 12 90 0 E(15)^11+E(15)^14
R_2^1(2,1,[1,1]) tensor R_1(1)+ tensor Xi_6 : 12 90 0 E(15)+E(15)^4
R_2^1(2,1,[1,1]) tensor R_1(2)+ tensor Xi_6 : 12 90 0 E(15)^7+E(15)^13
R_2^1(2,2,[1,0]) tensor R_1(1)+ tensor Xi_6 : 12 90 0 E(15)^11+E(15)^14
N_2([2,1]) tensor R_1(2)- tensor Xi_6 : 12 90 0 0
N_2([2,1]) tensor R_1(1)- tensor Xi_6 : 12 90 0 0
R_2^1(2,2,[1,0]) tensor R_1(2)+ tensor Xi_6 : 12 90 0 E(15)^2+E(15)^8
R_2^1(2,1,[1,0]) tensor R_1(2)+ tensor Xi_6 : 12 90 0 E(15)^7+E(15)^13
N_2([1,0]) tensor R_1(1)- tensor Xi_6 : 12 90 0 0
R_2^1(2,2,[1,1]) tensor R_1(1)+ tensor Xi_6 : 12 90 0 E(15)^11+E(15)^14
R_2^1(1,1,[1,0]) tensor R_1(1)+ tensor Xi_6 : 12 90 0 E(15)^11+E(15)^14
R_2^1(2,1,[1,0]) tensor R_1(1)+ tensor Xi_6 : 12 90 0 E(15)+E(15)^4
R_2^1(1,1,[1,0]) tensor R_1(2)+ tensor Xi_6 : 12 90 0 E(15)^2+E(15)^8
(R_2(2)-)_1 tensor R_1(2)+ tensor Xi_6 : 12 90 0 E(5)+E(5)^4
R_2^1(1,2,[1,1]) tensor R_1(2)+ tensor Xi_6 : 12 90 0 E(15)^7+E(15)^13
N_2([1,0]) tensor R_1(2)- tensor Xi_6 : 12 90 0 0
R_2^1(1,2,[1,1]) tensor R_1(1)+ tensor Xi_6 : 12 90 0 E(15)+E(15)^4
R_2^1(2,2,[1,1]) tensor R_1(2)+ tensor Xi_6 : 12 90 0 E(15)^2+E(15)^8
R_2^1(1,1,[1,1]) tensor R_1(2)+ tensor Xi_6 : 12 90 0 E(15)^2+E(15)^8
R_2^1(1,2,[1,0]) tensor R_1(2)+ tensor Xi_6 : 12 90 0 E(15)^7+E(15)^13
(R_2(1)+)_1 tensor R_1(1)+ tensor Xi_6 : 12 90 0 E(5)^2+E(5)^3
(R_2(1)+)_1 tensor R_1(2)+ tensor Xi_6 : 12 90 0 E(5)+E(5)^4
N_2([1,2]) tensor R_1(1)- tensor Xi_6 : 12 90 0 0
(R_2(2)-)_1 tensor R_1(1)+ tensor Xi_6 : 12 90 0 E(5)^2+E(5)^3
N_2([1,2]) tensor R_1(2)- tensor Xi_6 : 12 90 0 0
N_2([1,1]) tensor R_1(1)- tensor Xi_6 : 12 90 0 0
(R_2(1)-)_1 tensor R_1(1)+ tensor Xi_6 : 12 90 0 E(5)^2+E(5)^3
(R_2(1)-)_1 tensor R_1(2)+ tensor Xi_6 : 12 90 0 E(5)+E(5)^4
(R_2(2)+)_1 tensor R_1(1)+ tensor Xi_6 : 12 90 0 E(5)^2+E(5)^3
(R_2(2)+)_1 tensor R_1(2)+ tensor Xi_6 : 12 90 0 E(5)+E(5)^4
N_2([1,1]) tensor R_1(2)- tensor Xi_6 : 12 90 0 0
R_2^1(1,2,[1,0]) tensor R_1(1)+ tensor Xi_6 : 12 90 0 E(15)+E(15)^4
R_1(1)+ tensor Xi_3 : 12 92 0 -E(92)^7-E(92)^11-E(92)^15-E(92)^19-E(92)^43
 -E(92)^51-E(92)^63-E(92)^67-E(92)^79-E(92)^83-E(92)^91
R_1(5)+ tensor Xi_3 : 12 92 0 -E(92)^3-E(92)^27-E(92)^31-E(92)^35-E(92)^39
 -E(92)^47-E(92)^55-E(92)^59-E(92)^71-E(92)^75-E(92)^87
R_1(1)+ tensor Xi_9 : 12 92 0 E(92)^7+E(92)^11+E(92)^15+E(92)^19+E(92)^43
 +E(92)^51+E(92)^63+E(92)^67+E(92)^79+E(92)^83+E(92)^91
R_1(5)+ tensor Xi_9 : 12 92 0 E(92)^3+E(92)^27+E(92)^31+E(92)^35+E(92)^39
 +E(92)^47+E(92)^55+E(92)^59+E(92)^71+E(92)^75+E(92)^87
R_5^2(1,7,[1,1])- tensor N_1([0,1]) : 12 96 0 -1+E(8)^3
R_5^1(1,7,[1,0]) tensor Xi_4 : 12 96 0 0
R_5^2(1,1,[0,0])_1 tensor Xi_8 : 12 96 0 0
R_5^1(1,3,[1,1]) tensor Xi_4 : 12 96 0 0
R_5^1(1,3,[1,0]) tensor Xi_8 : 12 96 0 0
R_5^2(1,1,[0,0])_1 tensor Xi_4 : 12 96 0 0
R_5^1(1,3,[1,1]) tensor Xi_8 : 12 96 0 0
R_5^1(1,3,[1,0]) tensor Xi_4 : 12 96 0 0
R_5^1(3,3,[1,0]) tensor Xi_4 : 12 96 0 0
R_5^1(1,1,[1,0]) tensor Xi_8 : 12 96 0 0
R_5^2(1,7,[1,1])+ tensor R_1(2)+ : 12 96 0 -E(24)^8-E(24)^17
R_5^2(1,7,[1,1])+ tensor R_1(1)+ : 12 96 0 -E(24)-E(24)^16
R_5^1(5,5,[1,1]) tensor Xi_4 : 12 96 0 0
R_5^1(5,5,[1,0]) tensor Xi_8 : 12 96 0 0
R_5^1(3,3,[1,0]) tensor Xi_8 : 12 96 0 0
R_5^1(5,1,[1,1]) tensor Xi_8 : 12 96 0 0
R_5^2(1,7,[1,1])+ tensor N_1([0,1]) : 12 96 0 -1-E(8)^3
R_5^1(3,3,[1,1]) tensor Xi_4 : 12 96 0 0
R_5^1(1,7,[1,1]) tensor Xi_8 : 12 96 0 0
R_5^1(5,1,[1,0]) tensor Xi_8 : 12 96 0 0
R_5^1(5,1,[1,0]) tensor Xi_4 : 12 96 0 0
R_5^1(3,3,[1,1]) tensor Xi_8 : 12 96 0 0
R_5^1(5,5,[1,1]) tensor Xi_8 : 12 96 0 0
R_5^1(3,7,[1,0]) tensor Xi_4 : 12 96 0 0
R_5^1(1,5,[1,1]) tensor Xi_8 : 12 96 0 0
R_5^1(1,5,[1,1]) tensor Xi_4 : 12 96 0 0
R_5^1(1,5,[1,0]) tensor Xi_8 : 12 96 0 0
R_5^1(1,7,[1,1]) tensor Xi_4 : 12 96 0 0
R_5^1(3,7,[1,0]) tensor Xi_8 : 12 96 0 0
R_5^1(1,1,[1,1]) tensor Xi_8 : 12 96 0 0
R_5^1(1,1,[1,1]) tensor Xi_4 : 12 96 0 0
R_5^1(3,7,[1,1]) tensor Xi_4 : 12 96 0 0
R_5^2(1,7,[1,0])- tensor R_1(2)+ : 12 96 0 -E(24)^8-E(24)^17
R_5^2(1,7,[1,0])- tensor R_1(1)+ : 12 96 0 -E(24)-E(24)^16
R_5^1(3,7,[1,1]) tensor Xi_8 : 12 96 0 0
R_5^2(1,7,[1,1])- tensor R_1(1)+ : 12 96 0 E(24)-E(24)^16
R_5^2(1,7,[1,0])+ tensor R_1(2)+ : 12 96 0 -E(24)^8+E(24)^17
R_5^1(1,1,[1,0]) tensor Xi_4 : 12 96 0 0
R_5^2(1,7,[1,1])- tensor R_1(2)+ : 12 96 0 -E(24)^8+E(24)^17
Xi_9 tensor R_5^2(1,1,[0,0])_1 tensor Xi_4 : 12 96 0 0
R_5^2(1,5,[1,1])- tensor N_1([0,1]) : 12 96 0 E(8)+E(8)^2
R_5^1(1,7,[1,0]) tensor Xi_8 : 12 96 0 0
R_5^2(3,1,[1,0])+ tensor N_1([0,1]) : 12 96 0 E(8)^2-E(8)^3
R_5^0(3,5,[3,1]) tensor Xi_4 : 12 96 0 0
R_5^0(3,5,[3,0]) tensor Xi_8 : 12 96 0 0
R_5^0(3,5,[3,0]) tensor Xi_4 : 12 96 0 0
R_5^2(3,1,[1,0])+ tensor R_1(1)+ : 12 96 0 -E(24)+E(24)^22
Xi_9 tensor R_5^2(1,1,[0,0])_1 tensor Xi_8 : 12 96 0 0
R_5^2(3,1,[1,0])+ tensor R_1(2)+ : 12 96 0 E(24)^14-E(24)^17
R_5^2(1,1,[0,1])_1 tensor Xi_4 : 12 96 0 0
R_5^2(3,1,[1,0])- tensor N_1([0,1]) : 12 96 0 E(8)^2+E(8)^3
R_5^0(3,5,[1,1]) tensor Xi_8 : 12 96 0 0
R_5^0(3,5,[1,1]) tensor Xi_4 : 12 96 0 0
R_5^0(3,5,[1,0]) tensor Xi_8 : 12 96 0 0
R_5^1(5,5,[1,0]) tensor Xi_4 : 12 96 0 0
R_5^2(3,1,[1,0])- tensor R_1(1)+ : 12 96 0 E(24)+E(24)^22
R_5^2(3,1,[1,0])- tensor R_1(2)+ : 12 96 0 E(24)^14+E(24)^17
R_5^0(1,5,[3,1]) tensor Xi_8 : 12 96 0 0
R_5^1(5,1,[1,1]) tensor Xi_4 : 12 96 0 0
R_5^0(1,5,[3,0]) tensor Xi_8 : 12 96 0 0
R_5^2(1,1,[0,1])_1 tensor Xi_8 : 12 96 0 0
Xi_9 tensor R_5^2(1,1,[0,1])_1 tensor Xi_4 : 12 96 0 0
R_5^0(1,5,[3,0]) tensor Xi_4 : 12 96 0 0
R_5^0(1,5,[1,1]) tensor Xi_8 : 12 96 0 0
R_5^0(1,5,[1,1]) tensor Xi_4 : 12 96 0 0
Xi_9 tensor R_5^2(1,1,[0,1])_1 tensor Xi_8 : 12 96 0 0
R_5^2(1,7,[1,0])+ tensor R_1(1)+ : 12 96 0 E(24)-E(24)^16
R_5^1(1,5,[1,0]) tensor Xi_4 : 12 96 0 0
R_5^0(1,5,[1,0]) tensor Xi_8 : 12 96 0 0
R_5^0(1,5,[1,0]) tensor Xi_4 : 12 96 0 0
R_5^2(3,1,[1,1])+ tensor N_1([0,1]) : 12 96 0 E(8)^2+E(8)^3
R_5^2(3,1,[1,1])+ tensor R_1(1)+ : 12 96 0 E(24)+E(24)^22
R_5^0(3,1,[3,1]) tensor Xi_8 : 12 96 2 0
R_5^0(3,1,[3,1]) tensor Xi_4 : 12 96 2 0
R_5^0(3,1,[1,1]) tensor Xi_8 : 12 96 -2 0
R_5^2(3,1,[1,1])+ tensor R_1(2)+ : 12 96 0 E(24)^14+E(24)^17
R_5^0(3,1,[1,1]) tensor Xi_4 : 12 96 -2 0
R_5^2(3,1,[1,1])- tensor N_1([0,1]) : 12 96 0 E(8)^2-E(8)^3
R_5^2(3,1,[1,1])- tensor R_1(1)+ : 12 96 0 -E(24)+E(24)^22
R_5^0(3,1,[1,2]) tensor Xi_8 : 12 96 2*E(4) 0
R_5^2(3,1,[1,1])- tensor R_1(2)+ : 12 96 0 E(24)^14-E(24)^17
R_5^0(3,1,[1,2]) tensor Xi_4 : 12 96 2*E(4) 0
R_5^0(3,1,[1,0]) tensor Xi_8 : 12 96 -2*E(4) 0
R_5^0(3,1,[1,0]) tensor Xi_4 : 12 96 -2*E(4) 0
R_5^2(3,3,[1,0])+ tensor N_1([0,1]) : 12 96 0 1-E(8)
R_5^2(3,3,[1,0])+ tensor R_1(1)+ : 12 96 0 E(24)^16-E(24)^19
R_5^0(1,1,[3,1]) tensor Xi_8 : 12 96 2 0
R_5^0(1,1,[3,1]) tensor Xi_4 : 12 96 2 0
R_5^0(1,1,[1,1]) tensor Xi_8 : 12 96 -2 0
R_5^2(3,3,[1,0])+ tensor R_1(2)+ : 12 96 0 E(24)^8-E(24)^11
R_5^2(3,3,[1,0])- tensor N_1([0,1]) : 12 96 0 1+E(8)
R_5^0(1,1,[1,1]) tensor Xi_4 : 12 96 -2 0
R_5^0(1,1,[1,2]) tensor Xi_8 : 12 96 -2*E(4) 0
R_5^0(1,1,[1,2]) tensor Xi_4 : 12 96 -2*E(4) 0
R_5^0(3,5,[1,0]) tensor Xi_4 : 12 96 0 0
R_5^2(3,3,[1,0])- tensor R_1(1)+ : 12 96 0 E(24)^16+E(24)^19
R_5^0(1,1,[1,0]) tensor Xi_8 : 12 96 2*E(4) 0
R_5^0(1,1,[1,0]) tensor Xi_4 : 12 96 2*E(4) 0
R_5^0(1,5,[3,1]) tensor Xi_4 : 12 96 0 0
R_5^2(3,3,[1,0])- tensor R_1(2)+ : 12 96 0 E(24)^8+E(24)^11
R_5^2(1,7,[1,0])+ tensor N_1([0,1]) : 12 96 0 -1+E(8)^3
R_5^2(3,1,[0,0])_1 tensor Xi_4 : 12 96 0 0
R_5^2(3,3,[1,1])+ tensor N_1([0,1]) : 12 96 0 1+E(8)
R_5^2(3,3,[1,1])+ tensor R_1(1)+ : 12 96 0 E(24)^16+E(24)^19
R_5^2(3,3,[1,1])+ tensor R_1(2)+ : 12 96 0 E(24)^8+E(24)^11
R_5^2(3,3,[1,1])- tensor N_1([0,1]) : 12 96 0 1-E(8)
R_5^2(3,3,[1,1])- tensor R_1(1)+ : 12 96 0 E(24)^16-E(24)^19
R_5^2(3,1,[0,0])_1 tensor Xi_8 : 12 96 0 0
R_5^2(1,1,[1,0])+ tensor N_1([0,1]) : 12 96 0 -E(8)-E(8)^2
R_5^2(3,3,[1,1])- tensor R_1(2)+ : 12 96 0 E(24)^8-E(24)^11
R_5^2(3,5,[1,0])+ tensor N_1([0,1]) : 12 96 0 -E(8)^2+E(8)^3
R_5^2(3,5,[1,0])+ tensor R_1(1)+ : 12 96 0 E(24)-E(24)^22
R_5^2(1,5,[1,1])- tensor R_1(2)+ : 12 96 0 E(24)^11+E(24)^14
R_5^2(1,1,[1,0])+ tensor R_1(1)+ : 12 96 0 -E(24)^19-E(24)^22
R_5^2(1,1,[1,0])+ tensor R_1(2)+ : 12 96 0 -E(24)^11-E(24)^14
R_5^2(1,1,[1,0])- tensor N_1([0,1]) : 12 96 0 E(8)-E(8)^2
R_5^2(3,7,[1,1])- tensor R_1(1)+ : 12 96 0 -E(24)^16+E(24)^19
R_5^2(3,7,[1,1])- tensor R_1(2)+ : 12 96 0 -E(24)^8+E(24)^11
Xi_9 tensor R_5^2(3,1,[0,1])_1 tensor Xi_8 : 12 96 0 0
R_5^2(1,3,[1,1])+ tensor R_1(1)+ : 12 96 0 E(24)+E(24)^16
R_5^2(1,3,[1,1])+ tensor R_1(2)+ : 12 96 0 E(24)^8+E(24)^17
R_5^2(1,3,[1,1])- tensor N_1([0,1]) : 12 96 0 1-E(8)^3
R_5^2(1,3,[1,1])- tensor R_1(2)+ : 12 96 0 E(24)^8-E(24)^17
R_5^2(1,5,[1,0])+ tensor N_1([0,1]) : 12 96 0 E(8)+E(8)^2
R_5^2(1,5,[1,0])+ tensor R_1(1)+ : 12 96 0 E(24)^19+E(24)^22
R_5^2(1,5,[1,0])- tensor N_1([0,1]) : 12 96 0 -E(8)+E(8)^2
R_5^2(1,5,[1,0])- tensor R_1(1)+ : 12 96 0 -E(24)^19+E(24)^22
R_5^2(1,5,[1,0])- tensor R_1(2)+ : 12 96 0 -E(24)^11+E(24)^14
R_5^2(1,5,[1,1])+ tensor R_1(1)+ : 12 96 0 -E(24)^19+E(24)^22
R_5^2(1,5,[1,1])+ tensor R_1(2)+ : 12 96 0 -E(24)^11+E(24)^14
R_5^2(3,5,[1,1])+ tensor R_1(2)+ : 12 96 0 -E(24)^14-E(24)^17
R_5^2(3,5,[1,1])- tensor N_1([0,1]) : 12 96 0 -E(8)^2+E(8)^3
Xi_9 tensor R_5^2(3,1,[0,0])_1 tensor Xi_4 : 12 96 0 0
R_5^2(1,3,[1,0])+ tensor N_1([0,1]) : 12 96 0 1-E(8)^3
R_5^2(3,5,[1,1])- tensor R_1(1)+ : 12 96 0 E(24)-E(24)^22
R_5^2(1,3,[1,0])+ tensor R_1(1)+ : 12 96 0 -E(24)+E(24)^16
Xi_9 tensor R_5^2(3,1,[0,0])_1 tensor Xi_8 : 12 96 0 0
R_5^2(3,5,[1,1])- tensor R_1(2)+ : 12 96 0 -E(24)^14+E(24)^17
R_5^2(3,7,[1,0])+ tensor N_1([0,1]) : 12 96 0 -1+E(8)
R_5^2(3,7,[1,0])+ tensor R_1(1)+ : 12 96 0 -E(24)^16+E(24)^19
R_5^2(3,7,[1,0])+ tensor R_1(2)+ : 12 96 0 -E(24)^8+E(24)^11
R_5^2(1,5,[1,1])- tensor R_1(1)+ : 12 96 0 E(24)^19+E(24)^22
R_5^2(1,3,[1,0])+ tensor R_1(2)+ : 12 96 0 E(24)^8-E(24)^17
R_5^2(3,7,[1,0])- tensor N_1([0,1]) : 12 96 0 -1-E(8)
R_5^2(1,3,[1,0])- tensor N_1([0,1]) : 12 96 0 1+E(8)^3
R_5^2(3,7,[1,0])- tensor R_1(1)+ : 12 96 0 -E(24)^16-E(24)^19
R_5^2(3,1,[0,1])_1 tensor Xi_4 : 12 96 0 0
R_5^2(3,7,[1,0])- tensor R_1(2)+ : 12 96 0 -E(24)^8-E(24)^11
R_5^2(3,7,[1,1])+ tensor N_1([0,1]) : 12 96 0 -1-E(8)
R_5^2(3,1,[0,1])_1 tensor Xi_8 : 12 96 0 0
R_5^2(3,7,[1,1])+ tensor R_1(1)+ : 12 96 0 -E(24)^16-E(24)^19
R_5^2(3,7,[1,1])+ tensor R_1(2)+ : 12 96 0 -E(24)^8-E(24)^11
R_5^2(1,3,[1,0])- tensor R_1(1)+ : 12 96 0 E(24)+E(24)^16
R_5^2(1,3,[1,0])- tensor R_1(2)+ : 12 96 0 E(24)^8+E(24)^17
Xi_9 tensor R_5^2(3,1,[0,1])_1 tensor Xi_4 : 12 96 0 0
R_5^2(3,7,[1,1])- tensor N_1([0,1]) : 12 96 0 -1+E(8)
R_5^2(1,1,[1,0])- tensor R_1(1)+ : 12 96 0 E(24)^19-E(24)^22
R_5^2(1,1,[1,0])- tensor R_1(2)+ : 12 96 0 E(24)^11-E(24)^14
R_5^2(1,3,[1,1])+ tensor N_1([0,1]) : 12 96 0 1+E(8)^3
R_5^2(1,1,[1,1])+ tensor N_1([0,1]) : 12 96 0 E(8)-E(8)^2
R_5^2(1,1,[1,1])+ tensor R_1(1)+ : 12 96 0 E(24)^19-E(24)^22
R_5^2(3,5,[1,0])+ tensor R_1(2)+ : 12 96 0 -E(24)^14+E(24)^17
R_5^2(1,3,[1,1])- tensor R_1(1)+ : 12 96 0 -E(24)+E(24)^16
R_5^2(1,1,[1,1])+ tensor R_1(2)+ : 12 96 0 E(24)^11-E(24)^14
R_5^2(1,1,[1,1])- tensor N_1([0,1]) : 12 96 0 -E(8)-E(8)^2
R_5^2(3,5,[1,0])- tensor N_1([0,1]) : 12 96 0 -E(8)^2-E(8)^3
R_5^2(1,5,[1,0])+ tensor R_1(2)+ : 12 96 0 E(24)^11+E(24)^14
R_5^2(3,5,[1,0])- tensor R_1(1)+ : 12 96 0 -E(24)-E(24)^22
R_5^2(3,5,[1,0])- tensor R_1(2)+ : 12 96 0 -E(24)^14-E(24)^17
R_5^2(3,5,[1,1])+ tensor N_1([0,1]) : 12 96 0 -E(8)^2-E(8)^3
R_5^2(1,5,[1,1])+ tensor N_1([0,1]) : 12 96 0 -E(8)+E(8)^2
R_5^2(1,1,[1,1])- tensor R_1(1)+ : 12 96 0 -E(24)^19-E(24)^22
R_5^2(1,1,[1,1])- tensor R_1(2)+ : 12 96 0 -E(24)^11-E(24)^14
R_5^2(3,5,[1,1])+ tensor R_1(1)+ : 12 96 0 -E(24)-E(24)^22
R_5^2(1,7,[1,0])- tensor N_1([0,1]) : 12 96 0 -1-E(8)^3
R_5^0(3,5,[3,1]) tensor Xi_8 : 12 96 0 0
R_2^1(2,2,[1,0]) tensor Xi_3 : 12 100 0 E(20)+E(20)^9
R_2^1(1,2,[1,1]) tensor Xi_3 : 12 100 0 E(20)^13+E(20)^17
(R_2(1)-)_1 tensor Xi_9 : 12 100 0 -2*E(4)
R_2^1(2,1,[2,1]) tensor Xi_9 : 12 100 0 -E(20)^13-E(20)^17
R_2^1(1,2,[1,0]) tensor Xi_9 : 12 100 0 -E(20)^13-E(20)^17
R_2^1(1,2,[1,0]) tensor Xi_3 : 12 100 0 E(20)^13+E(20)^17
(R_2(1)+)_1 tensor Xi_9 : 12 100 0 -2*E(4)
(R_2(1)+)_1 tensor Xi_3 : 12 100 0 2*E(4)
R_2^1(2,2,[2,0]) tensor Xi_9 : 12 100 0 -E(20)-E(20)^9
R_2^1(1,1,[2,0]) tensor Xi_9 : 12 100 0 -E(20)-E(20)^9
R_2^1(2,2,[1,0]) tensor Xi_9 : 12 100 0 -E(20)-E(20)^9
(R_2(1)-)_1 tensor Xi_3 : 12 100 0 2*E(4)
R_2^1(2,2,[1,1]) tensor Xi_9 : 12 100 0 -E(20)-E(20)^9
R_2^1(1,1,[1,0]) tensor Xi_9 : 12 100 0 -E(20)-E(20)^9
R_2^1(1,1,[2,1]) tensor Xi_9 : 12 100 0 -E(20)-E(20)^9
R_2^1(1,1,[1,0]) tensor Xi_3 : 12 100 0 E(20)+E(20)^9
R_2^1(1,2,[2,1]) tensor Xi_3 : 12 100 0 E(20)^13+E(20)^17
R_2^1(1,1,[2,1]) tensor Xi_3 : 12 100 0 E(20)+E(20)^9
R_2^1(2,1,[1,0]) tensor Xi_3 : 12 100 0 E(20)^13+E(20)^17
R_2^1(2,1,[1,0]) tensor Xi_9 : 12 100 0 -E(20)^13-E(20)^17
R_2^1(2,2,[1,1]) tensor Xi_3 : 12 100 0 E(20)+E(20)^9
R_2^1(1,2,[2,1]) tensor Xi_9 : 12 100 0 -E(20)^13-E(20)^17
R_2^1(1,1,[2,0]) tensor Xi_3 : 12 100 0 E(20)+E(20)^9
R_2^1(2,2,[2,0]) tensor Xi_3 : 12 100 0 E(20)+E(20)^9
(R_2(2)+)_1 tensor Xi_3 : 12 100 0 2*E(4)
(R_2(2)+)_1 tensor Xi_9 : 12 100 0 -2*E(4)
R_2^1(1,2,[1,1]) tensor Xi_9 : 12 100 0 -E(20)^13-E(20)^17
(R_2(2)-)_1 tensor Xi_3 : 12 100 0 2*E(4)
(R_2(2)-)_1 tensor Xi_9 : 12 100 0 -2*E(4)
R_2^1(1,1,[1,1]) tensor Xi_9 : 12 100 0 -E(20)-E(20)^9
R_2^1(1,1,[1,1]) tensor Xi_3 : 12 100 0 E(20)+E(20)^9
R_2^1(2,1,[1,1]) tensor Xi_9 : 12 100 0 -E(20)^13-E(20)^17
R_2^1(2,2,[2,1]) tensor Xi_9 : 12 100 0 -E(20)-E(20)^9
R_2^1(2,2,[2,1]) tensor Xi_3 : 12 100 0 E(20)+E(20)^9
R_2^1(2,1,[2,0]) tensor Xi_3 : 12 100 0 E(20)^13+E(20)^17
R_2^1(2,1,[2,0]) tensor Xi_9 : 12 100 0 -E(20)^13-E(20)^17
R_2^1(1,2,[2,0]) tensor Xi_3 : 12 100 0 E(20)^13+E(20)^17
R_2^1(1,2,[2,0]) tensor Xi_9 : 12 100 0 -E(20)^13-E(20)^17
R_2^1(2,1,[1,1]) tensor Xi_3 : 12 100 0 E(20)^13+E(20)^17
R_2^1(2,1,[2,1]) tensor Xi_3 : 12 100 0 E(20)^13+E(20)^17
R_1(1)- tensor N_3([1,0])+ : 12 104 0 E(104)^5+E(104)^7+E(104)^15+E(104)^21
 +E(104)^31+E(104)^37+E(104)^45+E(104)^47+E(104)^63+E(104)^71+E(104)^85
 +E(104)^93
R_1(1)- tensor N_3([1,0])- : 12 104 0 -E(104)^5-E(104)^7-E(104)^15-E(104)^21
 -E(104)^31-E(104)^37-E(104)^45-E(104)^47-E(104)^63-E(104)^71-E(104)^85
 -E(104)^93
R_1(2)- tensor N_3([1,0])+ : 12 104 0 E(104)^23+E(104)^29+E(104)^53+E(104)^55
 +E(104)^61+E(104)^69+E(104)^77+E(104)^79+E(104)^87+E(104)^95+E(104)^101
 +E(104)^103
R_1(2)- tensor N_3([1,3])- : 12 104 0 E(104)^23-E(104)^29-E(104)^53+E(104)^55
 -E(104)^61-E(104)^69-E(104)^77+E(104)^79+E(104)^87+E(104)^95-E(104)^101
 +E(104)^103
R_1(1)- tensor N_3([1,3])+ : 12 104 0 E(104)^5-E(104)^7-E(104)^15+E(104)^21
 -E(104)^31+E(104)^37+E(104)^45-E(104)^47-E(104)^63-E(104)^71+E(104)^85
 +E(104)^93
R_1(1)- tensor N_3([1,3])- : 12 104 0 -E(104)^5+E(104)^7+E(104)^15-E(104)^21
 +E(104)^31-E(104)^37-E(104)^45+E(104)^47+E(104)^63+E(104)^71-E(104)^85
 -E(104)^93
R_1(2)- tensor N_3([1,3])+ : 12 104 0 -E(104)^23+E(104)^29+E(104)^53-E(104)^55
 +E(104)^61+E(104)^69+E(104)^77-E(104)^79-E(104)^87-E(104)^95+E(104)^101
 -E(104)^103
R_1(2)- tensor N_3([1,0])- : 12 104 0 -E(104)^23-E(104)^29-E(104)^53-E(104)^55
 -E(104)^61-E(104)^69-E(104)^77-E(104)^79-E(104)^87-E(104)^95-E(104)^101
 -E(104)^103
R_1(1)+ tensor R_1(2)+ tensor Xi_4 : 12 105 0 E(105)^26+E(105)^41+E(105)^59
 +E(105)^89+E(105)^101+E(105)^104
R_1(3)- tensor N_1([0,1]) tensor R_1(2)- : 12 105 0 -E(35)-E(35)^4-E(35)^9
 -E(35)^11-E(35)^16-E(35)^29
R_1(3)+ tensor R_1(2)+ tensor Xi_8 : 12 105 0 E(105)+E(105)^4+E(105)^16
 +E(105)^46+E(105)^64+E(105)^79
N_1([0,3]) tensor R_1(1)- tensor Xi_4 : 12 105 0 -E(15)^2-E(15)^8
R_1(1)- tensor R_1(2)+ tensor R_1(2)- : 12 105 0 -E(105)^2-E(105)^8-E(105)^23
 -E(105)^32-E(105)^53-E(105)^92
N_1([0,1]) tensor R_1(2)- tensor Xi_8 : 12 105 0 -E(15)-E(15)^4
N_1([0,1]) tensor R_1(2)- tensor Xi_4 : 12 105 0 -E(15)^11-E(15)^14
N_1([0,3]) tensor R_1(2)- tensor Xi_8 : 12 105 0 -E(15)-E(15)^4
N_1([0,2]) tensor R_1(3)- tensor Xi_4 : 12 105 0 -E(21)-E(21)^4-E(21)^16
R_1(1)+ tensor R_1(2)+ tensor Xi_8 : 12 105 0 E(105)^19+E(105)^31+E(105)^34
 +E(105)^61+E(105)^76+E(105)^94
N_1([0,2]) tensor R_1(1)- tensor Xi_4 : 12 105 0 -E(15)^2-E(15)^8
R_1(3)+ tensor R_1(2)+ tensor Xi_4 : 12 105 0 E(105)^11+E(105)^29+E(105)^44
 +E(105)^71+E(105)^74+E(105)^86
N_1([0,1]) tensor R_1(1)- tensor Xi_4 : 12 105 0 -E(15)^2-E(15)^8
R_1(1)- tensor R_1(1)+ tensor R_1(1)- : 12 105 0 -E(105)-E(105)^4-E(105)^16
 -E(105)^46-E(105)^64-E(105)^79
N_1([0,1]) tensor R_1(1)- tensor Xi_4 : 12 105 0 -E(21)^10-E(21)^13-E(21)^19
N_1([0,1]) tensor R_1(1)- tensor Xi_8 : 12 105 0 -E(15)^7-E(15)^13
R_1(1)- tensor R_1(2)+ tensor R_1(1)- : 12 105 0 -E(105)^11-E(105)^29
 -E(105)^44-E(105)^71-E(105)^74-E(105)^86
N_1([0,2]) tensor R_1(3)- tensor Xi_8 : 12 105 0 -E(21)^2-E(21)^8-E(21)^11
R_1(1)- tensor N_1([0,1]) tensor R_1(1)- : 12 105 0 -E(35)^3-E(35)^12-E(35)^13
 -E(35)^17-E(35)^27-E(35)^33
N_1([0,1]) tensor R_1(1)- tensor Xi_8 : 12 105 0 -E(21)^5-E(21)^17-E(21)^20
N_1([0,3]) tensor R_1(2)- tensor Xi_4 : 12 105 0 -E(15)^11-E(15)^14
R_1(1)- tensor N_1([0,1]) tensor R_1(2)- : 12 105 0 -E(35)^6-E(35)^19-E(35)^24
 -E(35)^26-E(35)^31-E(35)^34
R_1(3)- tensor R_1(2)+ tensor R_1(2)- : 12 105 0 -E(105)^17-E(105)^38
 -E(105)^47-E(105)^62-E(105)^68-E(105)^83
R_1(1)- tensor R_1(1)+ tensor R_1(2)- : 12 105 0 -E(105)^22-E(105)^37
 -E(105)^43-E(105)^58-E(105)^67-E(105)^88
R_1(3)- tensor R_1(1)+ tensor R_1(1)- : 12 105 0 -E(105)^19-E(105)^31
 -E(105)^34-E(105)^61-E(105)^76-E(105)^94
N_1([0,2]) tensor R_1(1)- tensor Xi_8 : 12 105 0 -E(15)^7-E(15)^13
R_1(3)- tensor R_1(1)+ tensor R_1(2)- : 12 105 0 -E(105)^13-E(105)^52
 -E(105)^73-E(105)^82-E(105)^97-E(105)^103
N_1([0,2]) tensor R_1(1)- tensor Xi_8 : 12 105 0 -E(21)^5-E(21)^17-E(21)^20
N_1([0,3]) tensor R_1(1)- tensor Xi_8 : 12 105 0 -E(15)^7-E(15)^13
N_1([0,1]) tensor R_1(3)- tensor Xi_4 : 12 105 0 -E(21)-E(21)^4-E(21)^16
R_1(3)+ tensor R_1(1)+ tensor Xi_8 : 12 105 0 E(105)^22+E(105)^37+E(105)^43
 +E(105)^58+E(105)^67+E(105)^88
R_1(1)+ tensor R_1(1)+ tensor Xi_8 : 12 105 0 E(105)^13+E(105)^52+E(105)^73
 +E(105)^82+E(105)^97+E(105)^103
R_1(1)+ tensor R_1(1)+ tensor Xi_4 : 12 105 0 E(105)^17+E(105)^38+E(105)^47
 +E(105)^62+E(105)^68+E(105)^83
N_1([0,1]) tensor R_1(3)- tensor Xi_8 : 12 105 0 -E(21)^2-E(21)^8-E(21)^11
R_1(3)- tensor R_1(2)+ tensor R_1(1)- : 12 105 0 -E(105)^26-E(105)^41
 -E(105)^59-E(105)^89-E(105)^101-E(105)^104
R_1(3)+ tensor R_1(1)+ tensor Xi_4 : 12 105 0 E(105)^2+E(105)^8+E(105)^23
 +E(105)^32+E(105)^53+E(105)^92
R_1(3)- tensor N_1([0,1]) tensor R_1(1)- : 12 105 0 -E(35)^2-E(35)^8-E(35)^18
 -E(35)^22-E(35)^23-E(35)^32
N_1([0,2]) tensor R_1(1)- tensor Xi_4 : 12 105 0 -E(21)^10-E(21)^13-E(21)^19
N_1([0,2]) tensor R_1(2)- tensor Xi_4 : 12 105 0 -E(15)^11-E(15)^14
N_1([0,2]) tensor R_1(2)- tensor Xi_8 : 12 105 0 -E(15)-E(15)^4
(R_3(2)-)_1 tensor Xi_9 : 12 108 0 E(12)^7-E(12)^11
R_3^1(2,1,[1,0]) tensor Xi_9 : 12 108 0 0
R_3^1(1,2,[2,0]) tensor Xi_9 : 12 108 0 0
R_3^1(2,1,[1,2]) tensor Xi_3 : 12 108 0 0
R_3^1(2,2,[1,1]) tensor Xi_3 : 12 108 0 0
R_3^1(2,1,[1,2]) tensor Xi_9 : 12 108 0 0
(R_3(2)+)_1 tensor Xi_3 : 12 108 0 -E(12)^7+E(12)^11
R_3^1(1,2,[4,0]) tensor Xi_3 : 12 108 0 0
R_3^1(2,2,[2,0]) tensor Xi_9 : 12 108 0 0
(R_3(2)-)_1 tensor Xi_3 : 12 108 0 -E(12)^7+E(12)^11
R_3^1(2,2,[4,0]) tensor Xi_9 : 12 108 0 0
R_3^1(2,1,[1,1]) tensor Xi_9 : 12 108 0 0
R_3^2(1,2,[1,0]) tensor Xi_9 : 12 108 0 2*E(12)^7+E(12)^11
R_3^1(2,1,[1,1]) tensor Xi_3 : 12 108 0 0
R_3^1(2,1,[1,3]) tensor Xi_9 : 12 108 0 0
R_3^1(2,1,[1,3]) tensor Xi_3 : 12 108 0 0
R_3^2(2,2,[1,1]) tensor Xi_9 : 12 108 0 E(12)^7+2*E(12)^11
R_3^1(1,1,[1,3]) tensor Xi_3 : 12 108 0 0
R_3^2(2,2,[1,1]) tensor Xi_3 : 12 108 0 -E(12)^7-2*E(12)^11
R_3^1(1,1,[2,2]) tensor Xi_3 : 12 108 0 0
R_3^1(1,1,[2,1]) tensor Xi_9 : 12 108 0 0
R_3^1(2,2,[4,0]) tensor Xi_3 : 12 108 0 0
R_3^1(2,1,[2,1]) tensor Xi_3 : 12 108 0 0
R_3^1(1,2,[2,0]) tensor Xi_3 : 12 108 0 0
R_3^1(2,2,[2,1]) tensor Xi_3 : 12 108 0 0
R_3^2(2,1,[1,0]) tensor Xi_3 : 12 108 0 2*E(12)^7+E(12)^11
R_3^2(1,2,[1,1]) tensor Xi_9 : 12 108 0 2*E(12)^7+E(12)^11
R_3^2(1,2,[1,1]) tensor Xi_3 : 12 108 0 -2*E(12)^7-E(12)^11
R_3^2(1,1,[1,0]) tensor Xi_9 : 12 108 0 -E(12)^7-2*E(12)^11
R_3^1(2,1,[1,0]) tensor Xi_3 : 12 108 0 0
R_3^1(2,2,[1,1]) tensor Xi_9 : 12 108 0 0
R_3^1(1,1,[1,1]) tensor Xi_9 : 12 108 0 0
R_3^1(1,1,[1,1]) tensor Xi_3 : 12 108 0 0
R_3^2(1,2,[1,0]) tensor Xi_3 : 12 108 0 -2*E(12)^7-E(12)^11
(R_3(2)+)_1 tensor Xi_9 : 12 108 0 E(12)^7-E(12)^11
(R_3(1)-)_1 tensor Xi_9 : 12 108 0 -E(12)^7+E(12)^11
R_3^1(1,1,[1,0]) tensor Xi_9 : 12 108 0 0
(R_3(1)-)_1 tensor Xi_3 : 12 108 0 E(12)^7-E(12)^11
R_3^1(1,2,[1,1]) tensor Xi_3 : 12 108 0 0
R_3^2(1,1,[1,0]) tensor Xi_3 : 12 108 0 E(12)^7+2*E(12)^11
R_3^2(2,2,[1,0]) tensor Xi_9 : 12 108 0 E(12)^7+2*E(12)^11
R_3^1(2,2,[4,1]) tensor Xi_9 : 12 108 0 0
R_3^1(1,2,[4,1]) tensor Xi_9 : 12 108 0 0
R_3^2(1,1,[1,1]) tensor Xi_3 : 12 108 0 E(12)^7+2*E(12)^11
R_3^2(1,1,[1,1]) tensor Xi_9 : 12 108 0 -E(12)^7-2*E(12)^11
R_3^1(2,2,[2,0]) tensor Xi_3 : 12 108 0 0
R_3^1(2,2,[1,0]) tensor Xi_9 : 12 108 0 0
R_3^1(1,2,[4,1]) tensor Xi_3 : 12 108 0 0
R_3^1(2,2,[1,0]) tensor Xi_3 : 12 108 0 0
R_3^1(1,2,[2,1]) tensor Xi_9 : 12 108 0 0
R_3^1(1,1,[1,2]) tensor Xi_3 : 12 108 0 0
(R_3(1)+)_1 tensor Xi_3 : 12 108 0 E(12)^7-E(12)^11
R_3^1(1,1,[2,2]) tensor Xi_9 : 12 108 0 0
R_3^1(2,1,[2,2]) tensor Xi_9 : 12 108 0 0
R_3^1(1,2,[2,1]) tensor Xi_3 : 12 108 0 0
R_3^2(2,1,[1,0]) tensor Xi_9 : 12 108 0 -2*E(12)^7-E(12)^11
R_3^1(2,2,[2,1]) tensor Xi_9 : 12 108 0 0
R_3^1(1,2,[4,0]) tensor Xi_9 : 12 108 0 0
R_3^1(2,1,[2,2]) tensor Xi_3 : 12 108 0 0
R_3^1(1,1,[2,1]) tensor Xi_3 : 12 108 0 0
R_3^1(1,1,[1,2]) tensor Xi_9 : 12 108 0 0
R_3^1(1,2,[1,1]) tensor Xi_9 : 12 108 0 0
R_3^2(2,1,[1,1]) tensor Xi_3 : 12 108 0 2*E(12)^7+E(12)^11
R_3^1(1,1,[1,3]) tensor Xi_9 : 12 108 0 0
R_3^1(2,1,[2,1]) tensor Xi_9 : 12 108 0 0
(R_3(1)+)_1 tensor Xi_9 : 12 108 0 -E(12)^7+E(12)^11
R_3^1(1,2,[1,0]) tensor Xi_3 : 12 108 0 0
R_3^1(1,1,[1,0]) tensor Xi_3 : 12 108 0 0
R_3^2(2,2,[1,0]) tensor Xi_3 : 12 108 0 -E(12)^7-2*E(12)^11
R_3^1(1,2,[1,0]) tensor Xi_9 : 12 108 0 0
R_3^1(2,2,[4,1]) tensor Xi_3 : 12 108 0 0
R_3^2(2,1,[1,1]) tensor Xi_9 : 12 108 0 -2*E(12)^7-E(12)^11
R_1(2)+ tensor R_1(1)- tensor Xi_6 : 12 110 0 E(55)+E(55)^4+E(55)^9+E(55)^14
 +E(55)^16+E(55)^26+E(55)^31+E(55)^34+E(55)^36+E(55)^49
R_1(2)+ tensor R_1(2)- tensor Xi_6 : 12 110 0 E(55)^3+E(55)^12+E(55)^23
 +E(55)^27+E(55)^37+E(55)^38+E(55)^42+E(55)^47+E(55)^48+E(55)^53
R_1(1)+ tensor R_1(1)- tensor Xi_6 : 12 110 0 E(55)^6+E(55)^19+E(55)^21
 +E(55)^24+E(55)^29+E(55)^39+E(55)^41+E(55)^46+E(55)^51+E(55)^54
R_1(1)+ tensor R_1(2)- tensor Xi_6 : 12 110 0 E(55)^2+E(55)^7+E(55)^8+E(55)^13
 +E(55)^17+E(55)^18+E(55)^28+E(55)^32+E(55)^43+E(55)^52
R_1(3)+ tensor R_4^0(1,5,[2,1])+ : 12 112 0 E(56)^29+E(56)^37+E(56)^53
R_1(1)+ tensor R_4^0(3,5,[2,1])- : 12 112 0 -E(56)^31-E(56)^47-E(56)^55
R_1(3)+ tensor R_4^0(3,1,[1,0])- : 12 112 0 E(56)^29+E(56)^37+E(56)^53
R_1(1)+ tensor R_4^0(3,5,[0,1])- : 12 112 0 E(56)^31+E(56)^47+E(56)^55
R_1(1)+ tensor R_4^0(1,5,[0,1])+ : 12 112 0 -E(56)^5-E(56)^13-E(56)^45
R_1(1)+ tensor R_4^0(1,5,[0,1])- : 12 112 0 E(56)^5+E(56)^13+E(56)^45
R_1(3)+ tensor R_4^0(3,5,[2,1])- : 12 112 0 -E(56)^15-E(56)^23-E(56)^39
R_1(3)+ tensor R_4^0(3,5,[0,1])+ : 12 112 0 -E(56)^15-E(56)^23-E(56)^39
R_1(1)+ tensor R_4^0(3,1,[1,2])- : 12 112 0 -E(56)^5-E(56)^13-E(56)^45
R_1(3)+ tensor R_4^0(3,1,[1,0])+ : 12 112 0 -E(56)^29-E(56)^37-E(56)^53
R_1(1)+ tensor R_4^0(3,1,[1,0])- : 12 112 0 E(56)^5+E(56)^13+E(56)^45
R_1(1)+ tensor R_4^0(3,5,[0,1])+ : 12 112 0 -E(56)^31-E(56)^47-E(56)^55
R_1(1)+ tensor R_4^0(1,5,[2,1])- : 12 112 0 -E(56)^5-E(56)^13-E(56)^45
R_1(1)+ tensor R_4^0(3,5,[2,1])+ : 12 112 0 E(56)^31+E(56)^47+E(56)^55
R_1(3)+ tensor R_4^0(3,1,[1,2])+ : 12 112 0 E(56)^29+E(56)^37+E(56)^53
R_1(3)+ tensor R_4^0(1,1,[1,0])- : 12 112 0 E(56)^15+E(56)^23+E(56)^39
R_1(3)+ tensor R_4^0(1,1,[1,2])- : 12 112 0 -E(56)^15-E(56)^23-E(56)^39
R_1(3)+ tensor R_4^0(3,5,[0,1])- : 12 112 0 E(56)^15+E(56)^23+E(56)^39
R_1(3)+ tensor R_4^0(1,5,[0,1])- : 12 112 0 E(56)^29+E(56)^37+E(56)^53
R_1(1)+ tensor R_4^0(1,5,[2,1])+ : 12 112 0 E(56)^5+E(56)^13+E(56)^45
R_1(1)+ tensor R_4^0(3,1,[1,2])+ : 12 112 0 E(56)^5+E(56)^13+E(56)^45
R_1(3)+ tensor R_4^0(1,5,[2,1])- : 12 112 0 -E(56)^29-E(56)^37-E(56)^53
R_1(1)+ tensor R_4^0(1,1,[1,2])- : 12 112 0 -E(56)^31-E(56)^47-E(56)^55
R_1(3)+ tensor R_4^0(3,5,[2,1])+ : 12 112 0 E(56)^15+E(56)^23+E(56)^39
R_1(1)+ tensor R_4^0(1,1,[1,2])+ : 12 112 0 E(56)^31+E(56)^47+E(56)^55
R_1(3)+ tensor R_4^0(1,1,[1,2])+ : 12 112 0 E(56)^15+E(56)^23+E(56)^39
R_1(1)+ tensor R_4^0(1,1,[1,0])- : 12 112 0 E(56)^31+E(56)^47+E(56)^55
R_1(1)+ tensor R_4^0(1,1,[1,0])+ : 12 112 0 -E(56)^31-E(56)^47-E(56)^55
R_1(3)+ tensor R_4^0(3,1,[1,2])- : 12 112 0 -E(56)^29-E(56)^37-E(56)^53
R_1(3)+ tensor R_4^0(1,1,[1,0])+ : 12 112 0 -E(56)^15-E(56)^23-E(56)^39
R_1(3)+ tensor R_4^0(1,5,[0,1])+ : 12 112 0 -E(56)^29-E(56)^37-E(56)^53
R_1(1)+ tensor R_4^0(3,1,[1,0])+ : 12 112 0 -E(56)^5-E(56)^13-E(56)^45
D_1([0,1]) tensor N_3([1,3])+ tensor Xi_8 : 12 120 0 -E(24)+E(24)^19
N_1([0,2]) tensor R_3^0(1,7,[0,1])+ tensor Xi_8 : 12 120 0 -E(3)^2
R_3^0(1,5,[0,1]) tensor R_1(1)+ tensor R_1(2)- : 12 120 0 E(60)^19+E(60)^31
N_1([0,2]) tensor R_3^0(1,7,[0,1])- tensor Xi_4 : 12 120 0 -E(3)
N_1([0,2]) tensor R_3^0(1,3,[0,1])- tensor Xi_8 : 12 120 0 E(3)^2
N_1([0,2]) tensor R_3^0(1,3,[0,1])- tensor Xi_4 : 12 120 0 E(3)
N_1([0,2]) tensor R_3^0(1,3,[0,1])+ tensor Xi_8 : 12 120 0 E(3)^2
N_1([0,2]) tensor R_3^0(1,3,[0,1])+ tensor Xi_4 : 12 120 0 E(3)
N_1([0,2]) tensor R_3^0(3,5,[0,1]) tensor Xi_8 : 12 120 0 -E(12)^11
N_1([0,2]) tensor R_3^0(3,5,[0,1]) tensor Xi_4 : 12 120 0 -E(12)^7
N_1([0,2]) tensor R_3^0(1,7,[0,1])- tensor Xi_8 : 12 120 0 -E(3)^2
N_1([0,2]) tensor R_3^0(3,1,[0,1]) tensor Xi_8 : 12 120 0 E(12)^11
N_1([0,2]) tensor R_3^0(3,1,[0,1]) tensor Xi_4 : 12 120 0 E(12)^7
N_1([0,2]) tensor R_3^0(1,5,[0,1]) tensor Xi_8 : 12 120 0 E(12)^11
N_3([1,2]) tensor R_1(2)+ tensor Xi_8 : 12 120 0 0
R_1(2)+ tensor R_1(1)+ tensor N_3([1,3])- : 12 120 0 E(120)^29-E(120)^71
 +E(120)^101-E(120)^119
R_3^0(1,5,[0,1]) tensor R_1(1)+ tensor R_1(1)- : 12 120 0 E(60)^7+E(60)^43
R_3^0(1,5,[0,1]) tensor N_1([0,1]) tensor R_1(2)- : 12 120 0 E(20)^13+E(20)^17
R_3^0(1,1,[0,1]) tensor N_1([0,1]) tensor R_1(1)- : 12 120 0 -E(20)-E(20)^9
N_3([1,2]) tensor R_1(2)+ tensor Xi_4 : 12 120 0 0
R_3^0(1,5,[0,1]) tensor R_1(2)+ tensor R_1(1)- : 12 120 0 E(60)^23+E(60)^47
N_1([0,2]) tensor R_3^0(1,1,[0,1]) tensor Xi_8 : 12 120 0 -E(12)^11
N_3([1,2]) tensor R_1(1)+ tensor Xi_8 : 12 120 0 0
N_3([1,2]) tensor R_1(1)+ tensor Xi_4 : 12 120 0 0
N_1([0,2]) tensor R_3^0(1,1,[0,1]) tensor Xi_4 : 12 120 0 -E(12)^7
R_1(2)+ tensor N_1([0,1]) tensor N_3([1,0])- : 12 120 0 -E(40)^7-E(40)^13
 -E(40)^23-E(40)^37
R_1(2)+ tensor N_1([0,1]) tensor N_3([1,3])+ : 12 120 0 -E(40)^7+E(40)^13
 -E(40)^23+E(40)^37
R_1(2)+ tensor N_1([0,1]) tensor N_3([1,3])- : 12 120 0 E(40)^7-E(40)^13
 +E(40)^23-E(40)^37
R_1(2)+ tensor R_1(2)+ tensor N_3([1,3])- : 12 120 0 -E(120)^31+E(120)^61
 -E(120)^79+E(120)^109
D_1([0,1]) tensor N_3([1,3])- tensor Xi_8 : 12 120 0 E(24)-E(24)^19
D_1([0,1]) tensor N_3([1,3])- tensor Xi_4 : 12 120 0 -E(24)^11+E(24)^17
R_1(2)+ tensor R_1(1)+ tensor N_3([1,0])+ : 12 120 0 E(120)^29+E(120)^71
 +E(120)^101+E(120)^119
N_1(nu) tensor R_1(1)- tensor N_3([1,0])+ : 12 120 0 0
R_1(2)+ tensor R_1(2)+ tensor N_3([1,3])+ : 12 120 0 E(120)^31-E(120)^61
 +E(120)^79-E(120)^109
R_1(2)+ tensor R_1(2)+ tensor N_3([1,0])- : 12 120 0 -E(120)^31-E(120)^61
 -E(120)^79-E(120)^109
R_1(2)+ tensor R_1(2)+ tensor N_3([1,0])+ : 12 120 0 E(120)^31+E(120)^61
 +E(120)^79+E(120)^109
N_1(nu) tensor R_1(1)- tensor N_3([1,0])- : 12 120 0 0
N_1([0,2]) tensor R_3^0(1,7,[0,1])+ tensor Xi_4 : 12 120 0 -E(3)
D_1([0,1]) tensor N_3([1,3])+ tensor Xi_4 : 12 120 0 E(24)^11-E(24)^17
D_1([0,1]) tensor N_3([1,0])- tensor Xi_8 : 12 120 0 -E(24)-E(24)^19
R_1(1)+ tensor R_1(1)+ tensor N_3([1,0])+ : 12 120 0 E(120)^23+E(120)^47
 +E(120)^53+E(120)^77
D_1([0,1]) tensor N_3([1,0])+ tensor Xi_8 : 12 120 0 E(24)+E(24)^19
D_1([0,1]) tensor N_3([1,0])+ tensor Xi_4 : 12 120 0 E(24)^11+E(24)^17
R_3^0(1,5,[0,1]) tensor N_1([0,1]) tensor R_1(1)- : 12 120 0 E(20)+E(20)^9
R_3^0(1,1,[0,1]) tensor R_1(2)+ tensor R_1(2)- : 12 120 0 -E(60)^11-E(60)^59
Xi_9 tensor R_3^0(1,3,nu)_1 tensor R_1(2)- tensor Xi_8 : 12 120 0 0
Xi_9 tensor R_3^0(1,3,nu)_1 tensor R_1(2)- tensor Xi_4 : 12 120 0 0
Xi_9 tensor R_3^0(1,3,nu)_1 tensor R_1(1)- tensor Xi_8 : 12 120 0 0
Xi_9 tensor R_3^0(1,3,nu)_1 tensor R_1(1)- tensor Xi_4 : 12 120 0 0
N_1([0,1]) tensor R_3^0(1,1,[0,1]) tensor Xi_4 : 12 120 0 -E(12)^7
R_1(2)+ tensor R_1(1)+ tensor N_3([1,0])- : 12 120 0 -E(120)^29-E(120)^71
 -E(120)^101-E(120)^119
N_1([0,1]) tensor R_3^0(1,1,[0,1]) tensor Xi_8 : 12 120 0 -E(12)^11
N_1([0,1]) tensor R_3^0(1,5,[0,1]) tensor Xi_4 : 12 120 0 E(12)^7
R_1(2)+ tensor R_1(1)+ tensor N_3([1,3])+ : 12 120 0 -E(120)^29+E(120)^71
 -E(120)^101+E(120)^119
R_3^0(1,5,[0,1]) tensor R_1(2)+ tensor R_1(2)- : 12 120 0 E(60)^11+E(60)^59
N_1([0,1]) tensor R_3^0(1,5,[0,1]) tensor Xi_8 : 12 120 0 E(12)^11
R_3^0(1,3,nu)_1 tensor R_1(2)- tensor Xi_8 : 12 120 0 0
R_3^0(3,1,[0,1]) tensor N_1([0,1]) tensor R_1(1)- : 12 120 0 E(20)+E(20)^9
R_3^0(1,3,nu)_1 tensor R_1(2)- tensor Xi_4 : 12 120 0 0
R_3^0(1,3,nu)_1 tensor R_1(1)- tensor Xi_8 : 12 120 0 0
N_1(nu) tensor R_1(1)- tensor N_3([1,3])+ : 12 120 0 0
R_3^0(1,3,nu)_1 tensor R_1(1)- tensor Xi_4 : 12 120 0 0
N_1([0,1]) tensor R_3^0(3,1,[0,1]) tensor Xi_4 : 12 120 0 E(12)^7
R_3^0(3,1,[0,1]) tensor R_1(1)+ tensor R_1(2)- : 12 120 0 E(60)^19+E(60)^31
N_1([0,1]) tensor R_3^0(3,1,[0,1]) tensor Xi_8 : 12 120 0 E(12)^11
R_3^0(1,1,[0,1]) tensor R_1(2)+ tensor R_1(1)- : 12 120 0 -E(60)^23-E(60)^47
D_3([1,1])- tensor R_1(2)- tensor Xi_8 : 12 120 0 -E(120)^23-E(120)^47
 -E(120)^53-E(120)^77
D_3([1,1])- tensor R_1(2)- tensor Xi_4 : 12 120 0 -E(120)^7-E(120)^13
 -E(120)^37-E(120)^103
N_1([0,1]) tensor R_3^0(3,5,[0,1]) tensor Xi_4 : 12 120 0 -E(12)^7
N_1(nu) tensor R_1(1)- tensor N_3([1,3])- : 12 120 0 0
D_3([1,1])- tensor R_1(1)- tensor Xi_8 : 12 120 0 -E(120)^29-E(120)^71
 -E(120)^101-E(120)^119
R_1(2)+ tensor N_1([0,1]) tensor N_3([1,0])+ : 12 120 0 E(40)^7+E(40)^13
 +E(40)^23+E(40)^37
D_3([1,1])- tensor R_1(1)- tensor Xi_4 : 12 120 0 -E(120)^31-E(120)^61
 -E(120)^79-E(120)^109
R_1(1)+ tensor R_1(2)+ tensor N_3([1,3])- : 12 120 0 -E(120)^7+E(120)^13
 +E(120)^37-E(120)^103
R_1(1)+ tensor R_1(2)+ tensor N_3([1,3])+ : 12 120 0 E(120)^7-E(120)^13
 -E(120)^37+E(120)^103
R_1(1)+ tensor R_1(2)+ tensor N_3([1,0])- : 12 120 0 -E(120)^7-E(120)^13
 -E(120)^37-E(120)^103
N_1([0,1]) tensor R_3^0(3,5,[0,1]) tensor Xi_8 : 12 120 0 -E(12)^11
N_1([0,1]) tensor R_3^0(1,3,[0,1])+ tensor Xi_4 : 12 120 0 E(3)
N_1([0,1]) tensor R_3^0(1,3,[0,1])+ tensor Xi_8 : 12 120 0 E(3)^2
D_3([1,1])+ tensor R_1(2)- tensor Xi_8 : 12 120 0 E(120)^23+E(120)^47
 +E(120)^53+E(120)^77
D_3([1,1])+ tensor R_1(2)- tensor Xi_4 : 12 120 0 E(120)^7+E(120)^13+E(120)^37
 +E(120)^103
D_3([1,1])+ tensor R_1(1)- tensor Xi_8 : 12 120 0 E(120)^29+E(120)^71
 +E(120)^101+E(120)^119
R_3^0(3,1,[0,1]) tensor N_1([0,1]) tensor R_1(2)- : 12 120 0 E(20)^13+E(20)^17
D_3([1,1])+ tensor R_1(1)- tensor Xi_4 : 12 120 0 E(120)^31+E(120)^61
 +E(120)^79+E(120)^109
R_3^0(1,7,[0,1])- tensor R_1(2)+ tensor R_1(2)- : 12 120 0 -E(15)^11-E(15)^14
N_1(nu) tensor R_1(2)- tensor N_3([1,0])+ : 12 120 0 0
N_1([0,1]) tensor R_3^0(1,3,[0,1])- tensor Xi_4 : 12 120 0 E(3)
N_1(nu) tensor R_1(2)- tensor N_3([1,0])- : 12 120 0 0
R_3^0(1,7,[0,1])- tensor R_1(2)+ tensor R_1(1)- : 12 120 0 -E(15)^2-E(15)^8
R_3^0(1,7,[0,1])- tensor R_1(1)+ tensor R_1(2)- : 12 120 0 -E(15)-E(15)^4
N_1(nu) tensor R_1(2)- tensor N_3([1,3])+ : 12 120 0 0
R_3^0(1,7,[0,1])- tensor R_1(1)+ tensor R_1(1)- : 12 120 0 -E(15)^7-E(15)^13
R_3^0(1,7,[0,1])- tensor N_1([0,1]) tensor R_1(2)- : 12 120 0 -E(5)^2-E(5)^3
N_1([0,1]) tensor R_3^0(1,3,[0,1])- tensor Xi_8 : 12 120 0 E(3)^2
N_1(nu) tensor R_1(2)- tensor N_3([1,3])- : 12 120 0 0
D_3([1,0])- tensor R_1(2)- tensor Xi_8 : 12 120 0 -E(120)^23-E(120)^47
 +E(120)^53+E(120)^77
R_1(1)+ tensor N_1([0,1]) tensor N_3([1,0])+ : 12 120 0 E(40)^21+E(40)^29
 +E(40)^31+E(40)^39
R_3^0(1,7,[0,1])- tensor N_1([0,1]) tensor R_1(1)- : 12 120 0 -E(5)-E(5)^4
R_3^0(1,7,[0,1])+ tensor R_1(2)+ tensor R_1(2)- : 12 120 0 -E(15)^11-E(15)^14
D_3([1,0])- tensor R_1(2)- tensor Xi_4 : 12 120 0 -E(120)^7+E(120)^13
 +E(120)^37-E(120)^103
R_3^0(1,7,[0,1])+ tensor R_1(2)+ tensor R_1(1)- : 12 120 0 -E(15)^2-E(15)^8
R_3^0(1,7,[0,1])+ tensor R_1(1)+ tensor R_1(2)- : 12 120 0 -E(15)-E(15)^4
N_1([0,1]) tensor R_3^0(1,7,[0,1])+ tensor Xi_4 : 12 120 0 -E(3)
D_3([1,0])- tensor R_1(1)- tensor Xi_8 : 12 120 0 E(120)^29-E(120)^71
 +E(120)^101-E(120)^119
D_3([1,0])- tensor R_1(1)- tensor Xi_4 : 12 120 0 -E(120)^31+E(120)^61
 -E(120)^79+E(120)^109
R_1(1)+ tensor N_1([0,1]) tensor N_3([1,0])- : 12 120 0 -E(40)^21-E(40)^29
 -E(40)^31-E(40)^39
R_3^0(1,7,[0,1])+ tensor R_1(1)+ tensor R_1(1)- : 12 120 0 -E(15)^7-E(15)^13
R_3^0(1,7,[0,1])+ tensor N_1([0,1]) tensor R_1(2)- : 12 120 0 -E(5)^2-E(5)^3
R_1(1)+ tensor N_1([0,1]) tensor N_3([1,3])+ : 12 120 0 E(40)^21+E(40)^29
 -E(40)^31-E(40)^39
R_3^0(1,7,[0,1])+ tensor N_1([0,1]) tensor R_1(1)- : 12 120 0 -E(5)-E(5)^4
R_3^0(1,3,[0,1])- tensor R_1(2)+ tensor R_1(2)- : 12 120 0 E(15)^11+E(15)^14
R_3^0(3,1,[0,1]) tensor R_1(2)+ tensor R_1(1)- : 12 120 0 E(60)^23+E(60)^47
R_1(1)+ tensor R_1(2)+ tensor N_3([1,0])+ : 12 120 0 E(120)^7+E(120)^13
 +E(120)^37+E(120)^103
D_3([1,0])+ tensor R_1(2)- tensor Xi_8 : 12 120 0 E(120)^23+E(120)^47
 -E(120)^53-E(120)^77
D_3([1,0])+ tensor R_1(2)- tensor Xi_4 : 12 120 0 E(120)^7-E(120)^13-E(120)^37
 +E(120)^103
R_3^0(1,3,[0,1])- tensor R_1(2)+ tensor R_1(1)- : 12 120 0 E(15)^2+E(15)^8
R_3^0(1,3,[0,1])- tensor R_1(1)+ tensor R_1(2)- : 12 120 0 E(15)+E(15)^4
R_1(1)+ tensor N_1([0,1]) tensor N_3([1,3])- : 12 120 0 -E(40)^21-E(40)^29
 +E(40)^31+E(40)^39
R_3^0(1,3,[0,1])- tensor R_1(1)+ tensor R_1(1)- : 12 120 0 E(15)^7+E(15)^13
R_3^0(1,3,[0,1])- tensor N_1([0,1]) tensor R_1(2)- : 12 120 0 E(5)^2+E(5)^3
R_3^0(3,1,[0,1]) tensor R_1(1)+ tensor R_1(1)- : 12 120 0 E(60)^7+E(60)^43
N_1([0,1]) tensor R_3^0(1,7,[0,1])+ tensor Xi_8 : 12 120 0 -E(3)^2
R_1(1)+ tensor R_1(1)+ tensor N_3([1,0])- : 12 120 0 -E(120)^23-E(120)^47
 -E(120)^53-E(120)^77
R_1(1)+ tensor R_1(1)+ tensor N_3([1,3])+ : 12 120 0 E(120)^23+E(120)^47
 -E(120)^53-E(120)^77
R_3^0(1,3,[0,1])- tensor N_1([0,1]) tensor R_1(1)- : 12 120 0 E(5)+E(5)^4
R_3^0(1,3,[0,1])+ tensor R_1(2)+ tensor R_1(2)- : 12 120 0 E(15)^11+E(15)^14
D_3([1,0])+ tensor R_1(1)- tensor Xi_8 : 12 120 0 -E(120)^29+E(120)^71
 -E(120)^101+E(120)^119
R_3^0(1,3,[0,1])+ tensor R_1(2)+ tensor R_1(1)- : 12 120 0 E(15)^2+E(15)^8
R_3^0(1,3,[0,1])+ tensor R_1(1)+ tensor R_1(2)- : 12 120 0 E(15)+E(15)^4
D_3([1,0])+ tensor R_1(1)- tensor Xi_4 : 12 120 0 E(120)^31-E(120)^61
 +E(120)^79-E(120)^109
N_1([0,1]) tensor R_3^0(1,7,[0,1])- tensor Xi_4 : 12 120 0 -E(3)
R_1(1)+ tensor R_1(1)+ tensor N_3([1,3])- : 12 120 0 -E(120)^23-E(120)^47
 +E(120)^53+E(120)^77
N_1([0,1]) tensor R_3^0(1,7,[0,1])- tensor Xi_8 : 12 120 0 -E(3)^2
R_3^0(1,3,[0,1])+ tensor R_1(1)+ tensor R_1(1)- : 12 120 0 E(15)^7+E(15)^13
R_3^0(1,3,[0,1])+ tensor N_1([0,1]) tensor R_1(2)- : 12 120 0 E(5)^2+E(5)^3
R_3^0(1,1,[0,1]) tensor R_1(1)+ tensor R_1(1)- : 12 120 0 -E(60)^7-E(60)^43
R_3^0(1,3,[0,1])+ tensor N_1([0,1]) tensor R_1(1)- : 12 120 0 E(5)+E(5)^4
R_3^0(3,5,[0,1]) tensor R_1(2)+ tensor R_1(2)- : 12 120 0 -E(60)^11-E(60)^59
N_3([1,1]) tensor R_1(2)+ tensor Xi_8 : 12 120 0 0
N_3([1,1]) tensor R_1(2)+ tensor Xi_4 : 12 120 0 0
R_3^0(3,5,[0,1]) tensor R_1(2)+ tensor R_1(1)- : 12 120 0 -E(60)^23-E(60)^47
N_3([1,1]) tensor R_1(1)+ tensor Xi_4 : 12 120 0 0
R_3^0(3,5,[0,1]) tensor R_1(1)+ tensor R_1(2)- : 12 120 0 -E(60)^19-E(60)^31
R_3^0(3,5,[0,1]) tensor R_1(1)+ tensor R_1(1)- : 12 120 0 -E(60)^7-E(60)^43
N_3([1,1]) tensor R_1(1)+ tensor Xi_8 : 12 120 0 0
R_3^0(3,5,[0,1]) tensor N_1([0,1]) tensor R_1(2)- : 12 120 0 
-E(20)^13-E(20)^17
R_3^0(3,5,[0,1]) tensor N_1([0,1]) tensor R_1(1)- : 12 120 0 -E(20)-E(20)^9
R_3^0(3,1,[0,1]) tensor R_1(2)+ tensor R_1(2)- : 12 120 0 E(60)^11+E(60)^59
R_3^0(1,1,[0,1]) tensor R_1(1)+ tensor R_1(2)- : 12 120 0 -E(60)^19-E(60)^31
D_1([0,1]) tensor N_3([1,0])- tensor Xi_4 : 12 120 0 -E(24)^11-E(24)^17
N_1([0,2]) tensor R_3^0(1,5,[0,1]) tensor Xi_4 : 12 120 0 E(12)^7
R_3^0(1,1,[0,1]) tensor N_1([0,1]) tensor R_1(2)- : 12 120 0 
-E(20)^13-E(20)^17
R_2^1(1,1,[1,0]) tensor R_1(3)- tensor Xi_6 : 12 126 0 -E(21)-E(21)^4-E(21)^16
R_2^1(2,1,[1,0]) tensor R_1(1)- tensor Xi_6 : 12 126 0 -E(21)^5-E(21)^17
 -E(21)^20
R_2^1(2,1,[1,0]) tensor R_1(3)- tensor Xi_6 : 12 126 0 -E(21)^2-E(21)^8
 -E(21)^11
(R_2(2)-)_1 tensor R_1(3)- tensor Xi_6 : 12 126 0 -E(7)^3-E(7)^5-E(7)^6
R_2^1(1,1,[1,0]) tensor R_1(1)- tensor Xi_6 : 12 126 0 -E(21)^10-E(21)^13
 -E(21)^19
(R_2(2)-)_1 tensor R_1(1)- tensor Xi_6 : 12 126 0 -E(7)-E(7)^2-E(7)^4
R_2^1(2,1,[1,1]) tensor R_1(1)- tensor Xi_6 : 12 126 0 -E(21)^5-E(21)^17
 -E(21)^20
R_2^1(1,2,[1,0]) tensor R_1(1)- tensor Xi_6 : 12 126 0 -E(21)^5-E(21)^17
 -E(21)^20
R_2^1(2,1,[1,1]) tensor R_1(3)- tensor Xi_6 : 12 126 0 -E(21)^2-E(21)^8
 -E(21)^11
R_2^1(1,1,[1,1]) tensor R_1(1)- tensor Xi_6 : 12 126 0 -E(21)^10-E(21)^13
 -E(21)^19
R_2^1(1,1,[1,1]) tensor R_1(3)- tensor Xi_6 : 12 126 0 -E(21)-E(21)^4-E(21)^16
(R_2(1)-)_1 tensor R_1(3)- tensor Xi_6 : 12 126 0 -E(7)^3-E(7)^5-E(7)^6
(R_2(1)-)_1 tensor R_1(1)- tensor Xi_6 : 12 126 0 -E(7)-E(7)^2-E(7)^4
R_2^1(2,2,[1,0]) tensor R_1(3)- tensor Xi_6 : 12 126 0 -E(21)-E(21)^4-E(21)^16
R_2^1(1,2,[1,0]) tensor R_1(3)- tensor Xi_6 : 12 126 0 -E(21)^2-E(21)^8
 -E(21)^11
R_2^1(2,2,[1,1]) tensor R_1(1)- tensor Xi_6 : 12 126 0 -E(21)^10-E(21)^13
 -E(21)^19
(R_2(1)+)_1 tensor R_1(3)- tensor Xi_6 : 12 126 0 -E(7)^3-E(7)^5-E(7)^6
R_2^1(1,2,[1,1]) tensor R_1(3)- tensor Xi_6 : 12 126 0 -E(21)^2-E(21)^8
 -E(21)^11
(R_2(2)+)_1 tensor R_1(1)- tensor Xi_6 : 12 126 0 -E(7)-E(7)^2-E(7)^4
R_2^1(1,2,[1,1]) tensor R_1(1)- tensor Xi_6 : 12 126 0 -E(21)^5-E(21)^17
 -E(21)^20
(R_2(2)+)_1 tensor R_1(3)- tensor Xi_6 : 12 126 0 -E(7)^3-E(7)^5-E(7)^6
(R_2(1)+)_1 tensor R_1(1)- tensor Xi_6 : 12 126 0 -E(7)-E(7)^2-E(7)^4
R_2^1(2,2,[1,1]) tensor R_1(3)- tensor Xi_6 : 12 126 0 -E(21)-E(21)^4-E(21)^16
R_2^1(2,2,[1,0]) tensor R_1(1)- tensor Xi_6 : 12 126 0 -E(21)^10-E(21)^13
 -E(21)^19
R_1(2)- tensor R_1(1)- tensor Xi_6 : 12 130 0 -E(65)^3-E(65)^12-E(65)^17
 -E(65)^22-E(65)^23-E(65)^27-E(65)^38-E(65)^42-E(65)^43-E(65)^48-E(65)^53
 -E(65)^62
R_1(2)- tensor R_1(2)- tensor Xi_6 : 12 130 0 -E(65)-E(65)^4-E(65)^9-E(65)^14
 -E(65)^16-E(65)^29-E(65)^36-E(65)^49-E(65)^51-E(65)^56-E(65)^61-E(65)^64
R_1(1)- tensor R_1(2)- tensor Xi_6 : 12 130 0 -E(65)^6-E(65)^11-E(65)^19
 -E(65)^21-E(65)^24-E(65)^31-E(65)^34-E(65)^41-E(65)^44-E(65)^46-E(65)^54
 -E(65)^59
R_1(1)- tensor R_1(1)- tensor Xi_6 : 12 130 0 -E(65)^2-E(65)^7-E(65)^8
 -E(65)^18-E(65)^28-E(65)^32-E(65)^33-E(65)^37-E(65)^47-E(65)^57-E(65)^58
 -E(65)^63
D_1([0,1]) tensor Xi_5 : 12 132 0 -E(12)^11
D_1([0,1]) tensor Xi_7 : 12 132 0 E(12)^7
D_1([0,1]) tensor Xi_11 : 12 132 0 E(12)^11
R_1(1)+ tensor N_2([0,1]) tensor Xi_4 : 12 132 0 0
R_1(1)+ tensor N_2([0,1]) tensor Xi_8 : 12 132 0 0
R_1(2)+ tensor N_1([0,1]) tensor Xi_9 : 12 132 0 -E(44)^3-E(44)^15-E(44)^23
 -E(44)^27-E(44)^31
D_1([0,2]) tensor Xi_1 : 12 132 0 -E(12)^7
D_1([0,2]) tensor Xi_5 : 12 132 0 -E(12)^11
D_1([0,2]) tensor Xi_7 : 12 132 0 E(12)^7
R_1(2)+ tensor R_1(1)+ tensor Xi_3 : 12 132 0 E(132)+E(132)^25+E(132)^37
 +E(132)^49+E(132)^97
R_1(2)+ tensor N_1([0,1]) tensor Xi_3 : 12 132 0 E(44)^3+E(44)^15+E(44)^23
 +E(44)^27+E(44)^31
D_1([0,3]) tensor Xi_1 : 12 132 0 -E(12)^7
R_1(2)+ tensor R_1(1)+ tensor Xi_9 : 12 132 0 -E(132)-E(132)^25-E(132)^37
 -E(132)^49-E(132)^97
R_1(2)+ tensor R_1(2)+ tensor Xi_3 : 12 132 0 E(132)^5+E(132)^53+E(132)^89
 +E(132)^113+E(132)^125
R_1(2)+ tensor R_1(2)+ tensor Xi_9 : 12 132 0 -E(132)^5-E(132)^53-E(132)^89
 -E(132)^113-E(132)^125
R_1(2)+ tensor N_2([0,1]) tensor Xi_4 : 12 132 0 0
D_1([0,3]) tensor Xi_5 : 12 132 0 -E(12)^11
D_1([0,3]) tensor Xi_7 : 12 132 0 E(12)^7
R_1(2)+ tensor N_2([0,1]) tensor Xi_8 : 12 132 0 0
D_1([0,4]) tensor Xi_5 : 12 132 0 -E(12)^11
D_1([0,1]) tensor Xi_1 : 12 132 0 -E(12)^7
D_1([0,4]) tensor Xi_11 : 12 132 0 E(12)^11
R_1(1)+ tensor R_1(2)+ tensor Xi_3 : 12 132 0 E(132)^17+E(132)^29+E(132)^41
 +E(132)^65+E(132)^101
R_1(1)+ tensor R_1(1)+ tensor Xi_3 : 12 132 0 E(132)^13+E(132)^61+E(132)^73
 +E(132)^85+E(132)^109
R_1(1)+ tensor R_1(1)+ tensor Xi_9 : 12 132 0 -E(132)^13-E(132)^61-E(132)^73
 -E(132)^85-E(132)^109
D_1([0,4]) tensor Xi_7 : 12 132 0 E(12)^7
D_1([0,2]) tensor Xi_11 : 12 132 0 E(12)^11
D_1([0,3]) tensor Xi_11 : 12 132 0 E(12)^11
D_1([0,4]) tensor Xi_1 : 12 132 0 -E(12)^7
R_1(1)+ tensor N_1([0,1]) tensor Xi_3 : 12 132 0 E(44)^7+E(44)^19+E(44)^35
 +E(44)^39+E(44)^43
R_1(1)+ tensor N_1([0,1]) tensor Xi_9 : 12 132 0 -E(44)^7-E(44)^19-E(44)^35
 -E(44)^39-E(44)^43
R_1(1)+ tensor R_1(2)+ tensor Xi_9 : 12 132 0 -E(132)^17-E(132)^29-E(132)^41
 -E(132)^65-E(132)^101
R_1(5)+ tensor Xi_2 : 12 138 0 E(69)+E(69)^4+E(69)^13+E(69)^16+E(69)^25
 +E(69)^31+E(69)^49+E(69)^52+E(69)^55+E(69)^58+E(69)^64
R_1(1)+ tensor Xi_2 : 12 138 0 E(69)^7+E(69)^10+E(69)^19+E(69)^22+E(69)^28
 +E(69)^34+E(69)^37+E(69)^40+E(69)^43+E(69)^61+E(69)^67
R_1(5)+ tensor Xi_10 : 12 138 0 E(69)^2+E(69)^8+E(69)^26+E(69)^29+E(69)^32
 +E(69)^35+E(69)^41+E(69)^47+E(69)^50+E(69)^59+E(69)^62
R_1(1)+ tensor Xi_10 : 12 138 0 E(69)^5+E(69)^11+E(69)^14+E(69)^17+E(69)^20
 +E(69)^38+E(69)^44+E(69)^53+E(69)^56+E(69)^65+E(69)^68
N_1([0,2]) tensor R_1(1)- tensor Xi_9 : 12 140 0 E(28)^11+E(28)^15+E(28)^23
N_1([0,2]) tensor R_1(1)- tensor Xi_3 : 12 140 0 -E(28)^11-E(28)^15-E(28)^23
N_1([0,1]) tensor R_1(3)- tensor Xi_9 : 12 140 0 E(28)^3+E(28)^19+E(28)^27
N_1([0,1]) tensor R_1(1)- tensor Xi_9 : 12 140 0 E(28)^11+E(28)^15+E(28)^23
N_1([0,2]) tensor R_1(3)- tensor Xi_9 : 12 140 0 E(28)^3+E(28)^19+E(28)^27
R_1(1)+ tensor R_1(1)+ tensor Xi_9 : 12 140 0 -E(140)^11-E(140)^39-E(140)^51
 -E(140)^71-E(140)^79-E(140)^99
N_1([0,1]) tensor R_1(3)- tensor Xi_3 : 12 140 0 -E(28)^3-E(28)^19-E(28)^27
R_1(3)+ tensor R_1(1)+ tensor Xi_3 : 12 140 0 E(140)^19+E(140)^31+E(140)^59
 +E(140)^111+E(140)^131+E(140)^139
R_1(1)+ tensor R_1(1)+ tensor Xi_3 : 12 140 0 E(140)^11+E(140)^39+E(140)^51
 +E(140)^71+E(140)^79+E(140)^99
N_1([0,1]) tensor R_1(1)- tensor Xi_3 : 12 140 0 -E(28)^11-E(28)^15-E(28)^23
R_1(1)+ tensor R_1(2)+ tensor Xi_3 : 12 140 0 E(140)^23+E(140)^43+E(140)^67
 +E(140)^107+E(140)^123+E(140)^127
N_1([0,1]) tensor R_1(1)- tensor Xi_3 : 12 140 0 -E(20)-E(20)^9
N_1([0,1]) tensor R_1(1)- tensor Xi_9 : 12 140 0 E(20)+E(20)^9
R_1(1)+ tensor R_1(2)+ tensor Xi_9 : 12 140 0 -E(140)^23-E(140)^43-E(140)^67
 -E(140)^107-E(140)^123-E(140)^127
N_1([0,2]) tensor R_1(1)- tensor Xi_3 : 12 140 0 -E(20)-E(20)^9
N_1([0,3]) tensor R_1(2)- tensor Xi_9 : 12 140 0 E(20)^13+E(20)^17
N_1([0,3]) tensor R_1(2)- tensor Xi_3 : 12 140 0 -E(20)^13-E(20)^17
N_1([0,2]) tensor R_1(2)- tensor Xi_9 : 12 140 0 E(20)^13+E(20)^17
R_1(3)+ tensor R_1(2)+ tensor Xi_9 : 12 140 0 -E(140)^3-E(140)^27-E(140)^47
 -E(140)^83-E(140)^87-E(140)^103
R_1(3)- tensor R_1(2)- tensor N_2([0,1]) : 12 140 0 0
N_1([0,1]) tensor R_1(2)- tensor Xi_3 : 12 140 0 -E(20)^13-E(20)^17
N_1([0,1]) tensor R_1(2)- tensor Xi_9 : 12 140 0 E(20)^13+E(20)^17
R_1(3)+ tensor R_1(2)+ tensor Xi_3 : 12 140 0 E(140)^3+E(140)^27+E(140)^47
 +E(140)^83+E(140)^87+E(140)^103
R_1(3)- tensor R_1(1)- tensor N_2([0,1]) : 12 140 0 0
R_1(1)- tensor R_1(1)- tensor N_2([0,1]) : 12 140 0 0
R_1(1)- tensor R_1(2)- tensor N_2([0,1]) : 12 140 0 0
N_1([0,2]) tensor R_1(1)- tensor Xi_9 : 12 140 0 E(20)+E(20)^9
R_1(3)+ tensor R_1(1)+ tensor Xi_9 : 12 140 0 -E(140)^19-E(140)^31-E(140)^59
 -E(140)^111-E(140)^131-E(140)^139
N_1([0,3]) tensor R_1(1)- tensor Xi_3 : 12 140 0 -E(20)-E(20)^9
N_1([0,3]) tensor R_1(1)- tensor Xi_9 : 12 140 0 E(20)+E(20)^9
N_1([0,2]) tensor R_1(3)- tensor Xi_3 : 12 140 0 -E(28)^3-E(28)^19-E(28)^27
N_1([0,2]) tensor R_1(2)- tensor Xi_3 : 12 140 0 -E(20)^13-E(20)^17
R_2^1(1,1,[1,1]) tensor R_4^0(3,5,[0,1])- : 12 144 0 -E(24)^11
R_2^1(1,1,[1,1]) tensor R_4^0(1,1,[1,2])+ : 12 144 0 -E(24)^11
R_2^1(2,1,[1,0]) tensor R_4^0(1,5,[2,1])+ : 12 144 0 -E(24)
R_2^1(1,2,[1,1]) tensor R_4^0(1,5,[2,1])- : 12 144 0 E(24)
R_2^1(1,1,[1,1]) tensor R_4^0(1,1,[1,2])- : 12 144 0 E(24)^11
R_2^1(2,1,[1,0]) tensor R_4^0(1,5,[2,1])- : 12 144 0 E(24)
R_2^1(1,2,[1,1]) tensor R_4^0(1,5,[2,1])+ : 12 144 0 -E(24)
R_2^1(2,1,[1,0]) tensor R_4^0(3,5,[0,1])+ : 12 144 0 E(24)^19
R_2^1(2,1,[1,0]) tensor R_4^0(1,5,[0,1])+ : 12 144 0 E(24)
R_2^1(2,1,[1,0]) tensor R_4^0(3,5,[0,1])- : 12 144 0 -E(24)^19
R_2^1(2,1,[1,0]) tensor R_4^0(3,5,[2,1])+ : 12 144 0 -E(24)^19
(R_2(2)+)_1 tensor R_4^0(3,5,[2,1])- : 12 144 0 E(8)
(R_2(2)+)_1 tensor R_4^0(3,5,[2,1])+ : 12 144 0 -E(8)
R_2^1(1,1,[1,0]) tensor R_4^0(1,1,[1,0])+ : 12 144 0 E(24)^11
R_2^1(1,1,[1,0]) tensor R_4^0(1,1,[1,0])- : 12 144 0 -E(24)^11
R_2^1(1,1,[1,0]) tensor R_4^0(1,1,[1,2])+ : 12 144 0 -E(24)^11
R_2^1(1,1,[1,0]) tensor R_4^0(1,1,[1,2])- : 12 144 0 E(24)^11
R_2^1(1,2,[1,1]) tensor R_4^0(1,5,[0,1])- : 12 144 0 -E(24)
R_2^1(1,2,[1,1]) tensor R_4^0(1,5,[0,1])+ : 12 144 0 E(24)
R_2^1(1,1,[1,0]) tensor R_4^0(3,1,[1,0])+ : 12 144 0 E(24)^17
R_2^1(2,1,[1,0]) tensor R_4^0(3,5,[2,1])- : 12 144 0 E(24)^19
R_2^1(1,2,[1,1]) tensor R_4^0(3,1,[1,2])- : 12 144 0 E(24)
R_2^1(1,1,[1,1]) tensor R_4^0(3,5,[2,1])- : 12 144 0 E(24)^11
R_2^1(1,1,[1,1]) tensor R_4^0(3,5,[2,1])+ : 12 144 0 -E(24)^11
R_2^1(1,1,[1,0]) tensor R_4^0(3,1,[1,2])+ : 12 144 0 -E(24)^17
(R_2(1)-)_1 tensor R_4^0(1,1,[1,0])- : 12 144 0 -E(8)
R_2^1(2,1,[1,0]) tensor R_4^0(3,1,[1,2])- : 12 144 0 E(24)
R_2^1(2,1,[1,0]) tensor R_4^0(3,1,[1,2])+ : 12 144 0 -E(24)
R_2^1(1,1,[1,0]) tensor R_4^0(3,1,[1,2])- : 12 144 0 E(24)^17
R_2^1(1,1,[1,0]) tensor R_4^0(1,5,[0,1])+ : 12 144 0 E(24)^17
R_2^1(1,1,[1,0]) tensor R_4^0(1,5,[0,1])- : 12 144 0 -E(24)^17
R_2^1(1,1,[1,0]) tensor R_4^0(1,5,[2,1])+ : 12 144 0 -E(24)^17
R_2^1(1,1,[1,0]) tensor R_4^0(1,5,[2,1])- : 12 144 0 E(24)^17
R_2^1(1,1,[1,0]) tensor R_4^0(3,5,[0,1])+ : 12 144 0 E(24)^11
(R_2(1)-)_1 tensor R_4^0(1,1,[1,0])+ : 12 144 0 E(8)
R_2^1(2,1,[1,0]) tensor R_4^0(3,1,[1,0])+ : 12 144 0 E(24)
R_2^1(1,1,[1,0]) tensor R_4^0(3,5,[0,1])- : 12 144 0 -E(24)^11
R_2^1(1,1,[1,0]) tensor R_4^0(3,5,[2,1])+ : 12 144 0 -E(24)^11
R_2^1(1,1,[1,0]) tensor R_4^0(3,5,[2,1])- : 12 144 0 E(24)^11
R_2^1(1,2,[1,1]) tensor R_4^0(3,1,[1,0])- : 12 144 0 -E(24)
R_2^1(1,2,[1,1]) tensor R_4^0(3,5,[0,1])+ : 12 144 0 E(24)^19
R_2^1(1,2,[1,1]) tensor R_4^0(3,5,[0,1])- : 12 144 0 -E(24)^19
R_2^1(1,2,[1,1]) tensor R_4^0(3,1,[1,0])+ : 12 144 0 E(24)
R_2^1(2,1,[1,0]) tensor R_4^0(1,1,[1,2])- : 12 144 0 E(24)^19
R_2^1(2,1,[1,0]) tensor R_4^0(1,1,[1,2])+ : 12 144 0 -E(24)^19
R_2^1(1,2,[1,1]) tensor R_4^0(3,5,[2,1])+ : 12 144 0 -E(24)^19
(R_2(2)+)_1 tensor R_4^0(3,5,[0,1])- : 12 144 0 -E(8)
R_2^1(2,1,[1,0]) tensor R_4^0(1,5,[0,1])- : 12 144 0 -E(24)
R_2^1(2,1,[1,0]) tensor R_4^0(1,1,[1,0])- : 12 144 0 -E(24)^19
R_2^1(1,1,[1,1]) tensor R_4^0(3,5,[0,1])+ : 12 144 0 E(24)^11
R_2^1(1,2,[1,1]) tensor R_4^0(1,1,[1,2])- : 12 144 0 E(24)^19
R_2^1(1,2,[1,1]) tensor R_4^0(1,1,[1,2])+ : 12 144 0 -E(24)^19
R_2^1(1,1,[1,1]) tensor R_4^0(1,5,[2,1])- : 12 144 0 E(24)^17
R_2^1(1,1,[1,1]) tensor R_4^0(1,5,[2,1])+ : 12 144 0 -E(24)^17
R_2^1(2,1,[1,1]) tensor R_4^0(1,1,[1,0])+ : 12 144 0 E(24)^19
R_2^1(2,1,[1,1]) tensor R_4^0(1,1,[1,0])- : 12 144 0 -E(24)^19
(R_2(2)+)_1 tensor R_4^0(3,5,[0,1])+ : 12 144 0 E(8)
R_2^1(1,2,[1,1]) tensor R_4^0(3,5,[2,1])- : 12 144 0 E(24)^19
R_2^1(2,1,[1,1]) tensor R_4^0(1,1,[1,2])+ : 12 144 0 -E(24)^19
R_2^1(1,2,[1,1]) tensor R_4^0(1,1,[1,0])- : 12 144 0 -E(24)^19
R_2^1(1,2,[1,1]) tensor R_4^0(1,1,[1,0])+ : 12 144 0 E(24)^19
R_2^1(2,1,[1,1]) tensor R_4^0(1,1,[1,2])- : 12 144 0 E(24)^19
(R_2(2)+)_1 tensor R_4^0(1,5,[2,1])- : 12 144 0 E(8)^3
R_2^1(2,1,[1,1]) tensor R_4^0(3,1,[1,0])+ : 12 144 0 E(24)
R_2^1(2,1,[1,1]) tensor R_4^0(3,1,[1,0])- : 12 144 0 -E(24)
(R_2(2)+)_1 tensor R_4^0(1,5,[2,1])+ : 12 144 0 -E(8)^3
R_2^1(2,1,[1,1]) tensor R_4^0(3,1,[1,2])+ : 12 144 0 -E(24)
R_2^1(2,1,[1,1]) tensor R_4^0(3,1,[1,2])- : 12 144 0 E(24)
R_2^1(2,1,[1,1]) tensor R_4^0(1,5,[0,1])+ : 12 144 0 E(24)
R_2^1(2,1,[1,1]) tensor R_4^0(1,5,[0,1])- : 12 144 0 -E(24)
R_2^1(2,1,[1,1]) tensor R_4^0(1,5,[2,1])+ : 12 144 0 -E(24)
R_2^1(2,1,[1,1]) tensor R_4^0(1,5,[2,1])- : 12 144 0 E(24)
R_2^1(2,1,[1,1]) tensor R_4^0(3,5,[0,1])+ : 12 144 0 E(24)^19
(R_2(2)+)_1 tensor R_4^0(1,5,[0,1])- : 12 144 0 -E(8)^3
R_2^1(2,1,[1,1]) tensor R_4^0(3,5,[0,1])- : 12 144 0 -E(24)^19
R_2^1(2,1,[1,1]) tensor R_4^0(3,5,[2,1])+ : 12 144 0 -E(24)^19
R_2^1(2,1,[1,1]) tensor R_4^0(3,5,[2,1])- : 12 144 0 E(24)^19
(R_2(2)+)_1 tensor R_4^0(1,1,[1,0])+ : 12 144 0 E(8)
(R_2(2)+)_1 tensor R_4^0(1,1,[1,0])- : 12 144 0 -E(8)
R_2^1(1,1,[1,1]) tensor R_4^0(1,5,[0,1])- : 12 144 0 -E(24)^17
(R_2(1)-)_1 tensor R_4^0(3,5,[2,1])- : 12 144 0 E(8)
(R_2(1)-)_1 tensor R_4^0(3,5,[2,1])+ : 12 144 0 -E(8)
(R_2(2)+)_1 tensor R_4^0(1,5,[0,1])+ : 12 144 0 E(8)^3
R_2^1(1,1,[1,1]) tensor R_4^0(1,5,[0,1])+ : 12 144 0 E(24)^17
R_2^1(1,1,[1,1]) tensor R_4^0(3,1,[1,2])- : 12 144 0 E(24)^17
(R_2(2)+)_1 tensor R_4^0(3,1,[1,2])- : 12 144 0 E(8)^3
(R_2(2)+)_1 tensor R_4^0(3,1,[1,2])+ : 12 144 0 -E(8)^3
(R_2(2)-)_1 tensor R_4^0(3,1,[1,2])+ : 12 144 0 -E(8)^3
R_2^1(2,1,[1,0]) tensor R_4^0(1,1,[1,0])+ : 12 144 0 E(24)^19
R_2^1(1,1,[1,1]) tensor R_4^0(3,1,[1,2])+ : 12 144 0 -E(24)^17
R_2^1(2,2,[1,0]) tensor R_4^0(1,1,[1,0])+ : 12 144 0 E(24)^11
R_2^1(2,2,[1,0]) tensor R_4^0(1,1,[1,0])- : 12 144 0 -E(24)^11
R_2^1(2,2,[1,0]) tensor R_4^0(1,1,[1,2])+ : 12 144 0 -E(24)^11
R_2^1(2,2,[1,0]) tensor R_4^0(1,1,[1,2])- : 12 144 0 E(24)^11
R_2^1(2,2,[1,0]) tensor R_4^0(3,1,[1,0])+ : 12 144 0 E(24)^17
R_2^1(2,2,[1,0]) tensor R_4^0(3,1,[1,0])- : 12 144 0 -E(24)^17
R_2^1(2,2,[1,0]) tensor R_4^0(3,1,[1,2])+ : 12 144 0 -E(24)^17
(R_2(2)+)_1 tensor R_4^0(3,1,[1,0])- : 12 144 0 -E(8)^3
(R_2(2)+)_1 tensor R_4^0(3,1,[1,0])+ : 12 144 0 E(8)^3
(R_2(2)+)_1 tensor R_4^0(1,1,[1,2])- : 12 144 0 E(8)
(R_2(2)+)_1 tensor R_4^0(1,1,[1,2])+ : 12 144 0 -E(8)
R_2^1(2,2,[1,0]) tensor R_4^0(3,1,[1,2])- : 12 144 0 E(24)^17
R_2^1(2,2,[1,0]) tensor R_4^0(1,5,[0,1])+ : 12 144 0 E(24)^17
R_2^1(1,1,[1,1]) tensor R_4^0(1,1,[1,0])+ : 12 144 0 E(24)^11
R_2^1(2,2,[1,0]) tensor R_4^0(1,5,[0,1])- : 12 144 0 -E(24)^17
R_2^1(2,2,[1,0]) tensor R_4^0(1,5,[2,1])+ : 12 144 0 -E(24)^17
R_2^1(2,2,[1,0]) tensor R_4^0(1,5,[2,1])- : 12 144 0 E(24)^17
R_2^1(2,2,[1,0]) tensor R_4^0(3,5,[0,1])+ : 12 144 0 E(24)^11
(R_2(1)-)_1 tensor R_4^0(1,1,[1,2])+ : 12 144 0 -E(8)
(R_2(1)-)_1 tensor R_4^0(1,1,[1,2])- : 12 144 0 E(8)
R_2^1(2,2,[1,0]) tensor R_4^0(3,5,[0,1])- : 12 144 0 -E(24)^11
R_2^1(2,2,[1,0]) tensor R_4^0(3,5,[2,1])+ : 12 144 0 -E(24)^11
R_2^1(2,2,[1,0]) tensor R_4^0(3,5,[2,1])- : 12 144 0 E(24)^11
(R_2(1)-)_1 tensor R_4^0(3,1,[1,0])+ : 12 144 0 E(8)^3
(R_2(1)-)_1 tensor R_4^0(3,1,[1,0])- : 12 144 0 -E(8)^3
(R_2(1)-)_1 tensor R_4^0(3,1,[1,2])+ : 12 144 0 -E(8)^3
(R_2(2)-)_1 tensor R_4^0(3,1,[1,2])- : 12 144 0 E(8)^3
(R_2(1)+)_1 tensor R_4^0(3,5,[2,1])- : 12 144 0 E(8)
(R_2(1)+)_1 tensor R_4^0(3,5,[2,1])+ : 12 144 0 -E(8)
(R_2(2)-)_1 tensor R_4^0(1,5,[0,1])+ : 12 144 0 E(8)^3
(R_2(2)-)_1 tensor R_4^0(1,5,[0,1])- : 12 144 0 -E(8)^3
(R_2(1)+)_1 tensor R_4^0(3,5,[0,1])- : 12 144 0 -E(8)
(R_2(1)+)_1 tensor R_4^0(3,5,[0,1])+ : 12 144 0 E(8)
(R_2(2)-)_1 tensor R_4^0(3,5,[2,1])+ : 12 144 0 -E(8)
(R_2(2)-)_1 tensor R_4^0(3,5,[2,1])- : 12 144 0 E(8)
(R_2(1)+)_1 tensor R_4^0(1,5,[0,1])- : 12 144 0 -E(8)^3
(R_2(1)-)_1 tensor R_4^0(3,1,[1,2])- : 12 144 0 E(8)^3
(R_2(1)-)_1 tensor R_4^0(1,5,[0,1])+ : 12 144 0 E(8)^3
(R_2(1)+)_1 tensor R_4^0(1,5,[0,1])+ : 12 144 0 E(8)^3
R_2^1(1,1,[1,1]) tensor R_4^0(1,1,[1,0])- : 12 144 0 -E(24)^11
(R_2(1)+)_1 tensor R_4^0(3,1,[1,2])- : 12 144 0 E(8)^3
(R_2(1)+)_1 tensor R_4^0(3,1,[1,2])+ : 12 144 0 -E(8)^3
(R_2(1)-)_1 tensor R_4^0(1,5,[0,1])- : 12 144 0 -E(8)^3
(R_2(1)-)_1 tensor R_4^0(1,5,[2,1])+ : 12 144 0 -E(8)^3
(R_2(1)-)_1 tensor R_4^0(1,5,[2,1])- : 12 144 0 E(8)^3
(R_2(1)+)_1 tensor R_4^0(3,1,[1,0])- : 12 144 0 -E(8)^3
(R_2(1)+)_1 tensor R_4^0(3,1,[1,0])+ : 12 144 0 E(8)^3
R_2^1(2,2,[1,1]) tensor R_4^0(1,1,[1,0])+ : 12 144 0 E(24)^11
R_2^1(2,2,[1,1]) tensor R_4^0(1,1,[1,0])- : 12 144 0 -E(24)^11
R_2^1(2,2,[1,1]) tensor R_4^0(1,1,[1,2])+ : 12 144 0 -E(24)^11
R_2^1(2,1,[1,0]) tensor R_4^0(3,1,[1,0])- : 12 144 0 -E(24)
R_2^1(2,2,[1,1]) tensor R_4^0(3,1,[1,0])+ : 12 144 0 E(24)^17
R_2^1(2,2,[1,1]) tensor R_4^0(3,1,[1,0])- : 12 144 0 -E(24)^17
R_2^1(2,2,[1,1]) tensor R_4^0(3,1,[1,2])+ : 12 144 0 -E(24)^17
R_2^1(2,2,[1,1]) tensor R_4^0(3,1,[1,2])- : 12 144 0 E(24)^17
R_2^1(2,2,[1,1]) tensor R_4^0(1,5,[0,1])+ : 12 144 0 E(24)^17
(R_2(1)-)_1 tensor R_4^0(3,5,[0,1])+ : 12 144 0 E(8)
(R_2(1)-)_1 tensor R_4^0(3,5,[0,1])- : 12 144 0 -E(8)
(R_2(2)-)_1 tensor R_4^0(3,1,[1,0])- : 12 144 0 -E(8)^3
(R_2(2)-)_1 tensor R_4^0(3,1,[1,0])+ : 12 144 0 E(8)^3
(R_2(2)-)_1 tensor R_4^0(1,5,[2,1])+ : 12 144 0 -E(8)^3
(R_2(2)-)_1 tensor R_4^0(1,5,[2,1])- : 12 144 0 E(8)^3
(R_2(2)-)_1 tensor R_4^0(1,1,[1,2])- : 12 144 0 E(8)
R_2^1(2,2,[1,1]) tensor R_4^0(1,5,[0,1])- : 12 144 0 -E(24)^17
R_2^1(2,2,[1,1]) tensor R_4^0(1,5,[2,1])+ : 12 144 0 -E(24)^17
R_2^1(2,2,[1,1]) tensor R_4^0(1,5,[2,1])- : 12 144 0 E(24)^17
R_2^1(2,2,[1,1]) tensor R_4^0(3,5,[0,1])+ : 12 144 0 E(24)^11
R_2^1(2,2,[1,1]) tensor R_4^0(3,5,[0,1])- : 12 144 0 -E(24)^11
R_2^1(2,2,[1,1]) tensor R_4^0(3,5,[2,1])+ : 12 144 0 -E(24)^11
R_2^1(2,2,[1,1]) tensor R_4^0(3,5,[2,1])- : 12 144 0 E(24)^11
(R_2(1)+)_1 tensor R_4^0(1,1,[1,2])- : 12 144 0 E(8)
(R_2(1)+)_1 tensor R_4^0(1,1,[1,2])+ : 12 144 0 -E(8)
(R_2(2)-)_1 tensor R_4^0(1,1,[1,2])+ : 12 144 0 -E(8)
(R_2(2)-)_1 tensor R_4^0(3,5,[0,1])+ : 12 144 0 E(8)
R_2^1(1,1,[1,1]) tensor R_4^0(3,1,[1,0])- : 12 144 0 -E(24)^17
R_2^1(1,1,[1,1]) tensor R_4^0(3,1,[1,0])+ : 12 144 0 E(24)^17
(R_2(1)+)_1 tensor R_4^0(1,1,[1,0])- : 12 144 0 -E(8)
(R_2(1)+)_1 tensor R_4^0(1,1,[1,0])+ : 12 144 0 E(8)
R_2^1(1,2,[1,1]) tensor R_4^0(3,1,[1,2])+ : 12 144 0 -E(24)
(R_2(2)-)_1 tensor R_4^0(1,1,[1,0])+ : 12 144 0 E(8)
R_2^1(1,2,[1,0]) tensor R_4^0(3,5,[2,1])- : 12 144 0 E(24)^19
R_2^1(1,2,[1,0]) tensor R_4^0(3,5,[2,1])+ : 12 144 0 -E(24)^19
R_2^1(1,2,[1,0]) tensor R_4^0(3,5,[0,1])- : 12 144 0 -E(24)^19
R_2^1(1,2,[1,0]) tensor R_4^0(3,5,[0,1])+ : 12 144 0 E(24)^19
R_2^1(1,2,[1,0]) tensor R_4^0(1,5,[2,1])- : 12 144 0 E(24)
R_2^1(1,2,[1,0]) tensor R_4^0(1,5,[2,1])+ : 12 144 0 -E(24)
R_2^1(1,2,[1,0]) tensor R_4^0(1,5,[0,1])- : 12 144 0 -E(24)
R_2^1(1,2,[1,0]) tensor R_4^0(1,5,[0,1])+ : 12 144 0 E(24)
R_2^1(1,2,[1,0]) tensor R_4^0(3,1,[1,2])- : 12 144 0 E(24)
R_2^1(1,2,[1,0]) tensor R_4^0(3,1,[1,2])+ : 12 144 0 -E(24)
R_2^1(1,2,[1,0]) tensor R_4^0(3,1,[1,0])- : 12 144 0 -E(24)
R_2^1(1,2,[1,0]) tensor R_4^0(3,1,[1,0])+ : 12 144 0 E(24)
R_2^1(1,2,[1,0]) tensor R_4^0(1,1,[1,2])- : 12 144 0 E(24)^19
R_2^1(1,2,[1,0]) tensor R_4^0(1,1,[1,2])+ : 12 144 0 -E(24)^19
R_2^1(1,2,[1,0]) tensor R_4^0(1,1,[1,0])- : 12 144 0 -E(24)^19
R_2^1(1,2,[1,0]) tensor R_4^0(1,1,[1,0])+ : 12 144 0 E(24)^19
(R_2(2)-)_1 tensor R_4^0(3,5,[0,1])- : 12 144 0 -E(8)
R_2^1(2,2,[1,1]) tensor R_4^0(1,1,[1,2])- : 12 144 0 E(24)^11
(R_2(1)+)_1 tensor R_4^0(1,5,[2,1])- : 12 144 0 E(8)^3
(R_2(1)+)_1 tensor R_4^0(1,5,[2,1])+ : 12 144 0 -E(8)^3
R_2^1(1,1,[1,0]) tensor R_4^0(3,1,[1,0])- : 12 144 0 -E(24)^17
(R_2(2)-)_1 tensor R_4^0(1,1,[1,0])- : 12 144 0 -E(8)
R_2^1(2,1,[2,1]) tensor Xi_10 : 12 150 0 -E(15)^11-E(15)^14
R_2^1(2,2,[1,1]) tensor Xi_2 : 12 150 0 -E(15)^7-E(15)^13
R_2^1(2,2,[1,0]) tensor Xi_10 : 12 150 0 -E(15)^2-E(15)^8
R_2^1(2,2,[1,0]) tensor Xi_2 : 12 150 0 -E(15)^7-E(15)^13
R_2^1(2,2,[2,1]) tensor Xi_2 : 12 150 0 -E(15)^7-E(15)^13
R_2^1(2,2,[2,0]) tensor Xi_2 : 12 150 0 -E(15)^7-E(15)^13
R_2^1(2,2,[2,0]) tensor Xi_10 : 12 150 0 -E(15)^2-E(15)^8
R_2^1(2,2,[2,1]) tensor Xi_10 : 12 150 0 -E(15)^2-E(15)^8
(R_2(1)+)_1 tensor Xi_2 : 12 150 0 -2*E(3)^2
R_2^1(2,1,[2,1]) tensor Xi_2 : 12 150 0 -E(15)-E(15)^4
(R_2(1)+)_1 tensor Xi_10 : 12 150 0 -2*E(3)
(R_2(1)-)_1 tensor Xi_2 : 12 150 0 -2*E(3)^2
(R_2(1)-)_1 tensor Xi_10 : 12 150 0 -2*E(3)
R_2^1(1,1,[1,0]) tensor Xi_2 : 12 150 0 -E(15)^7-E(15)^13
(R_2(2)+)_1 tensor Xi_2 : 12 150 0 -2*E(3)^2
(R_2(2)+)_1 tensor Xi_10 : 12 150 0 -2*E(3)
(R_2(2)-)_1 tensor Xi_2 : 12 150 0 -2*E(3)^2
(R_2(2)-)_1 tensor Xi_10 : 12 150 0 -2*E(3)
R_2^1(2,1,[2,0]) tensor Xi_10 : 12 150 0 -E(15)^11-E(15)^14
R_2^1(2,2,[1,1]) tensor Xi_10 : 12 150 0 -E(15)^2-E(15)^8
R_2^1(2,1,[1,1]) tensor Xi_10 : 12 150 0 -E(15)^11-E(15)^14
R_2^1(2,1,[1,1]) tensor Xi_2 : 12 150 0 -E(15)-E(15)^4
R_2^1(2,1,[1,0]) tensor Xi_10 : 12 150 0 -E(15)^11-E(15)^14
R_2^1(2,1,[1,0]) tensor Xi_2 : 12 150 0 -E(15)-E(15)^4
R_2^1(1,2,[2,1]) tensor Xi_10 : 12 150 0 -E(15)^11-E(15)^14
R_2^1(1,2,[2,1]) tensor Xi_2 : 12 150 0 -E(15)-E(15)^4
R_2^1(1,2,[2,0]) tensor Xi_10 : 12 150 0 -E(15)^11-E(15)^14
R_2^1(1,2,[2,0]) tensor Xi_2 : 12 150 0 -E(15)-E(15)^4
R_2^1(1,1,[1,1]) tensor Xi_2 : 12 150 0 -E(15)^7-E(15)^13
R_2^1(1,2,[1,1]) tensor Xi_2 : 12 150 0 -E(15)-E(15)^4
R_2^1(1,2,[1,0]) tensor Xi_10 : 12 150 0 -E(15)^11-E(15)^14
R_2^1(1,2,[1,0]) tensor Xi_2 : 12 150 0 -E(15)-E(15)^4
R_2^1(1,1,[2,1]) tensor Xi_10 : 12 150 0 -E(15)^2-E(15)^8
R_2^1(1,1,[2,1]) tensor Xi_2 : 12 150 0 -E(15)^7-E(15)^13
R_2^1(1,1,[2,0]) tensor Xi_10 : 12 150 0 -E(15)^2-E(15)^8
R_2^1(1,1,[2,0]) tensor Xi_2 : 12 150 0 -E(15)^7-E(15)^13
R_2^1(1,1,[1,1]) tensor Xi_10 : 12 150 0 -E(15)^2-E(15)^8
R_2^1(1,1,[1,0]) tensor Xi_10 : 12 150 0 -E(15)^2-E(15)^8
R_2^1(1,2,[1,1]) tensor Xi_10 : 12 150 0 -E(15)^11-E(15)^14
R_2^1(2,1,[2,0]) tensor Xi_2 : 12 150 0 -E(15)-E(15)^4
R_1(2)- tensor N_1([0,1]) tensor Xi_9 : 12 156 0 E(52)^5+E(52)^21+E(52)^33
 +E(52)^37+E(52)^41+E(52)^45
R_1(1)- tensor N_1([0,1]) tensor Xi_9 : 12 156 0 E(52)+E(52)^9+E(52)^17
 +E(52)^25+E(52)^29+E(52)^49
R_1(1)- tensor R_1(1)+ tensor Xi_3 : 12 156 0 -E(156)^23-E(156)^35-E(156)^95
 -E(156)^107-E(156)^131-E(156)^155
R_1(1)- tensor R_1(1)+ tensor Xi_9 : 12 156 0 E(156)^23+E(156)^35+E(156)^95
 +E(156)^107+E(156)^131+E(156)^155
R_1(1)- tensor R_1(2)+ tensor Xi_3 : 12 156 0 -E(156)^43-E(156)^55-E(156)^79
 -E(156)^103-E(156)^127-E(156)^139
R_1(1)- tensor R_1(2)+ tensor Xi_9 : 12 156 0 E(156)^43+E(156)^55+E(156)^79
 +E(156)^103+E(156)^127+E(156)^139
R_1(1)- tensor N_2([0,1]) tensor Xi_4 : 12 156 0 0
R_1(1)- tensor N_2([0,1]) tensor Xi_8 : 12 156 0 0
R_1(2)- tensor N_1([0,1]) tensor Xi_3 : 12 156 0 -E(52)^5-E(52)^21-E(52)^33
 -E(52)^37-E(52)^41-E(52)^45
R_1(2)- tensor R_1(2)+ tensor Xi_3 : 12 156 0 -E(156)^7-E(156)^19-E(156)^31
 -E(156)^67-E(156)^115-E(156)^151
R_1(2)- tensor R_1(1)+ tensor Xi_3 : 12 156 0 -E(156)^11-E(156)^47-E(156)^59
 -E(156)^71-E(156)^83-E(156)^119
N_1([0,1]) tensor Xi_1 : 12 156 0 E(12)^7
N_1([0,1]) tensor Xi_5 : 12 156 0 E(12)^11
N_1([0,6]) tensor Xi_11 : 12 156 0 -E(12)^11
N_1([0,1]) tensor Xi_7 : 12 156 0 -E(12)^7
N_1([0,6]) tensor Xi_7 : 12 156 0 -E(12)^7
N_1([0,1]) tensor Xi_11 : 12 156 0 -E(12)^11
N_1([0,2]) tensor Xi_1 : 12 156 0 E(12)^7
N_1([0,2]) tensor Xi_5 : 12 156 0 E(12)^11
N_1([0,2]) tensor Xi_7 : 12 156 0 -E(12)^7
N_1([0,2]) tensor Xi_11 : 12 156 0 -E(12)^11
R_1(2)- tensor R_1(1)+ tensor Xi_9 : 12 156 0 E(156)^11+E(156)^47+E(156)^59
 +E(156)^71+E(156)^83+E(156)^119
R_1(1)- tensor N_1([0,1]) tensor Xi_3 : 12 156 0 -E(52)-E(52)^9-E(52)^17
 -E(52)^25-E(52)^29-E(52)^49
N_1([0,6]) tensor Xi_5 : 12 156 0 E(12)^11
N_1([0,6]) tensor Xi_1 : 12 156 0 E(12)^7
N_1([0,3]) tensor Xi_1 : 12 156 0 E(12)^7
N_1([0,3]) tensor Xi_5 : 12 156 0 E(12)^11
R_1(2)- tensor R_1(2)+ tensor Xi_9 : 12 156 0 E(156)^7+E(156)^19+E(156)^31
 +E(156)^67+E(156)^115+E(156)^151
R_1(2)- tensor N_2([0,1]) tensor Xi_4 : 12 156 0 0
N_1([0,5]) tensor Xi_1 : 12 156 0 E(12)^7
N_1([0,3]) tensor Xi_7 : 12 156 0 -E(12)^7
N_1([0,3]) tensor Xi_11 : 12 156 0 -E(12)^11
N_1([0,4]) tensor Xi_1 : 12 156 0 E(12)^7
N_1([0,5]) tensor Xi_11 : 12 156 0 -E(12)^11
N_1([0,5]) tensor Xi_7 : 12 156 0 -E(12)^7
N_1([0,4]) tensor Xi_5 : 12 156 0 E(12)^11
N_1([0,4]) tensor Xi_7 : 12 156 0 -E(12)^7
N_1([0,4]) tensor Xi_11 : 12 156 0 -E(12)^11
R_1(2)- tensor N_2([0,1]) tensor Xi_8 : 12 156 0 0
N_1([0,5]) tensor Xi_5 : 12 156 0 E(12)^11
R_5^2(1,3,[1,0])+ tensor R_1(2)- : 12 160 0 -E(40)^16-E(40)^24+E(40)^31
 +E(40)^39
R_5^2(3,5,[1,1])- tensor R_1(1)- : 12 160 0 E(40)^2-E(40)^7+E(40)^18-E(40)^23
R_5^2(1,1,[1,0])+ tensor R_1(1)- : 12 160 0 E(40)^2+E(40)^13+E(40)^18+E(40)^37
R_5^2(3,5,[1,1])+ tensor R_1(2)- : 12 160 0 E(40)^26+E(40)^31+E(40)^34
 +E(40)^39
R_5^2(1,1,[1,0])+ tensor R_1(2)- : 12 160 0 E(40)^21+E(40)^26+E(40)^29
 +E(40)^34
R_5^2(3,5,[1,1])+ tensor R_1(1)- : 12 160 0 E(40)^2+E(40)^7+E(40)^18+E(40)^23
R_5^2(1,1,[1,0])- tensor R_1(1)- : 12 160 0 E(40)^2-E(40)^13+E(40)^18-E(40)^37
R_5^2(1,1,[1,0])- tensor R_1(2)- : 12 160 0 -E(40)^21+E(40)^26-E(40)^29
 +E(40)^34
R_5^2(1,1,[1,1])+ tensor R_1(1)- : 12 160 0 E(40)^2-E(40)^13+E(40)^18-E(40)^37
R_5^2(3,5,[1,0])- tensor R_1(2)- : 12 160 0 E(40)^26+E(40)^31+E(40)^34
 +E(40)^39
R_5^2(3,5,[1,0])- tensor R_1(1)- : 12 160 0 E(40)^2+E(40)^7+E(40)^18+E(40)^23
R_5^2(1,1,[1,1])+ tensor R_1(2)- : 12 160 0 -E(40)^21+E(40)^26-E(40)^29
 +E(40)^34
R_5^2(1,1,[1,1])- tensor R_1(1)- : 12 160 0 E(40)^2+E(40)^13+E(40)^18+E(40)^37
R_5^2(1,1,[1,1])- tensor R_1(2)- : 12 160 0 E(40)^21+E(40)^26+E(40)^29
 +E(40)^34
R_5^2(1,3,[1,0])+ tensor R_1(1)- : 12 160 0 E(40)^7-E(40)^8+E(40)^23-E(40)^32
R_5^2(1,7,[1,1])- tensor R_1(2)- : 12 160 0 E(40)^16+E(40)^24-E(40)^31
 -E(40)^39
R_5^2(1,3,[1,0])- tensor R_1(1)- : 12 160 0 -E(40)^7-E(40)^8-E(40)^23-E(40)^32
R_5^2(1,3,[1,0])- tensor R_1(2)- : 12 160 0 -E(40)^16-E(40)^24-E(40)^31
 -E(40)^39
R_5^2(3,5,[1,0])+ tensor R_1(2)- : 12 160 0 E(40)^26-E(40)^31+E(40)^34
 -E(40)^39
R_5^2(1,3,[1,1])+ tensor R_1(1)- : 12 160 0 -E(40)^7-E(40)^8-E(40)^23-E(40)^32
R_5^2(3,5,[1,0])+ tensor R_1(1)- : 12 160 0 E(40)^2-E(40)^7+E(40)^18-E(40)^23
R_5^2(1,3,[1,1])+ tensor R_1(2)- : 12 160 0 -E(40)^16-E(40)^24-E(40)^31
 -E(40)^39
R_5^2(3,5,[1,1])- tensor R_1(2)- : 12 160 0 E(40)^26-E(40)^31+E(40)^34
 -E(40)^39
R_5^2(1,3,[1,1])- tensor R_1(1)- : 12 160 0 E(40)^7-E(40)^8+E(40)^23-E(40)^32
R_5^2(3,3,[1,1])- tensor R_1(2)- : 12 160 0 -E(40)^16+E(40)^21-E(40)^24
 +E(40)^29
R_5^2(1,3,[1,1])- tensor R_1(2)- : 12 160 0 -E(40)^16-E(40)^24+E(40)^31
 +E(40)^39
R_5^2(1,5,[1,0])+ tensor R_1(1)- : 12 160 0 -E(40)^2-E(40)^13-E(40)^18
 -E(40)^37
R_5^2(3,3,[1,1])- tensor R_1(1)- : 12 160 0 -E(40)^8+E(40)^13-E(40)^32
 +E(40)^37
R_5^2(1,5,[1,0])+ tensor R_1(2)- : 12 160 0 -E(40)^21-E(40)^26-E(40)^29
 -E(40)^34
R_5^2(3,3,[1,1])+ tensor R_1(2)- : 12 160 0 -E(40)^16-E(40)^21-E(40)^24
 -E(40)^29
R_5^2(3,3,[1,1])+ tensor R_1(1)- : 12 160 0 -E(40)^8-E(40)^13-E(40)^32
 -E(40)^37
R_5^2(1,5,[1,0])- tensor R_1(1)- : 12 160 0 -E(40)^2+E(40)^13-E(40)^18
 +E(40)^37
R_5^2(3,7,[1,0])+ tensor R_1(1)- : 12 160 0 E(40)^8-E(40)^13+E(40)^32-E(40)^37
R_5^2(1,5,[1,0])- tensor R_1(2)- : 12 160 0 E(40)^21-E(40)^26+E(40)^29
 -E(40)^34
R_5^2(3,3,[1,0])- tensor R_1(2)- : 12 160 0 -E(40)^16-E(40)^21-E(40)^24
 -E(40)^29
R_5^2(1,5,[1,1])+ tensor R_1(1)- : 12 160 0 -E(40)^2+E(40)^13-E(40)^18
 +E(40)^37
R_5^2(1,5,[1,1])+ tensor R_1(2)- : 12 160 0 E(40)^21-E(40)^26+E(40)^29
 -E(40)^34
R_5^2(3,3,[1,0])- tensor R_1(1)- : 12 160 0 -E(40)^8-E(40)^13-E(40)^32
 -E(40)^37
R_5^2(1,5,[1,1])- tensor R_1(1)- : 12 160 0 -E(40)^2-E(40)^13-E(40)^18
 -E(40)^37
R_5^2(3,3,[1,0])+ tensor R_1(2)- : 12 160 0 -E(40)^16+E(40)^21-E(40)^24
 +E(40)^29
R_5^2(3,7,[1,0])+ tensor R_1(2)- : 12 160 0 E(40)^16-E(40)^21+E(40)^24
 -E(40)^29
R_5^2(3,3,[1,0])+ tensor R_1(1)- : 12 160 0 -E(40)^8+E(40)^13-E(40)^32
 +E(40)^37
R_5^2(1,7,[1,0])+ tensor R_1(1)- : 12 160 0 -E(40)^7+E(40)^8-E(40)^23+E(40)^32
R_5^2(3,7,[1,0])- tensor R_1(1)- : 12 160 0 E(40)^8+E(40)^13+E(40)^32+E(40)^37
R_5^2(1,7,[1,0])+ tensor R_1(2)- : 12 160 0 E(40)^16+E(40)^24-E(40)^31
 -E(40)^39
R_5^2(1,7,[1,0])- tensor R_1(1)- : 12 160 0 E(40)^7+E(40)^8+E(40)^23+E(40)^32
R_5^2(3,1,[1,1])- tensor R_1(2)- : 12 160 0 -E(40)^26+E(40)^31-E(40)^34
 +E(40)^39
R_5^2(3,1,[1,0])- tensor R_1(2)- : 12 160 0 -E(40)^26-E(40)^31-E(40)^34
 -E(40)^39
R_5^2(1,7,[1,1])+ tensor R_1(1)- : 12 160 0 E(40)^7+E(40)^8+E(40)^23+E(40)^32
R_5^2(1,7,[1,1])+ tensor R_1(2)- : 12 160 0 E(40)^16+E(40)^24+E(40)^31
 +E(40)^39
R_5^2(1,7,[1,1])- tensor R_1(1)- : 12 160 0 -E(40)^7+E(40)^8-E(40)^23+E(40)^32
R_5^2(3,1,[1,1])- tensor R_1(1)- : 12 160 0 -E(40)^2+E(40)^7-E(40)^18+E(40)^23
R_5^2(1,5,[1,1])- tensor R_1(2)- : 12 160 0 -E(40)^21-E(40)^26-E(40)^29
 -E(40)^34
R_5^2(3,7,[1,0])- tensor R_1(2)- : 12 160 0 E(40)^16+E(40)^21+E(40)^24
 +E(40)^29
R_5^2(3,1,[1,1])+ tensor R_1(2)- : 12 160 0 -E(40)^26-E(40)^31-E(40)^34
 -E(40)^39
R_5^2(3,1,[1,0])+ tensor R_1(1)- : 12 160 0 -E(40)^2+E(40)^7-E(40)^18+E(40)^23
R_5^2(3,7,[1,1])- tensor R_1(2)- : 12 160 0 E(40)^16-E(40)^21+E(40)^24
 -E(40)^29
R_5^2(3,1,[1,1])+ tensor R_1(1)- : 12 160 0 -E(40)^2-E(40)^7-E(40)^18-E(40)^23
R_5^2(3,1,[1,0])+ tensor R_1(2)- : 12 160 0 -E(40)^26+E(40)^31-E(40)^34
 +E(40)^39
R_5^2(3,7,[1,1])+ tensor R_1(1)- : 12 160 0 E(40)^8+E(40)^13+E(40)^32+E(40)^37
R_5^2(3,7,[1,1])+ tensor R_1(2)- : 12 160 0 E(40)^16+E(40)^21+E(40)^24
 +E(40)^29
R_5^2(3,7,[1,1])- tensor R_1(1)- : 12 160 0 E(40)^8-E(40)^13+E(40)^32-E(40)^37
R_5^2(1,7,[1,0])- tensor R_1(2)- : 12 160 0 E(40)^16+E(40)^24+E(40)^31
 +E(40)^39
R_5^2(3,1,[1,0])- tensor R_1(1)- : 12 160 0 -E(40)^2-E(40)^7-E(40)^18-E(40)^23
R_1(2)+ tensor R_1(1)- tensor Xi_8 : 12 165 0 -E(165)^23-E(165)^38-E(165)^47
 -E(165)^53-E(165)^92-E(165)^113-E(165)^122-E(165)^137-E(165)^152-E(165)^158
R_1(2)+ tensor R_1(2)- tensor Xi_4 : 12 165 0 -E(165)-E(165)^4-E(165)^16
 -E(165)^31-E(165)^34-E(165)^49-E(165)^64-E(165)^91-E(165)^124-E(165)^136
R_1(2)+ tensor R_1(2)- tensor Xi_8 : 12 165 0 -E(165)^14-E(165)^26-E(165)^56
 -E(165)^59-E(165)^71-E(165)^86-E(165)^89-E(165)^104-E(165)^119-E(165)^146
R_1(1)+ tensor R_1(1)- tensor Xi_4 : 12 165 0 -E(165)^7-E(165)^13-E(165)^28
 -E(165)^43-E(165)^52-E(165)^73-E(165)^112-E(165)^118-E(165)^127-E(165)^142
R_1(1)+ tensor R_1(2)- tensor Xi_4 : 12 165 0 -E(165)^19-E(165)^46-E(165)^61
 -E(165)^76-E(165)^79-E(165)^94-E(165)^106-E(165)^109-E(165)^139-E(165)^151
R_1(1)+ tensor R_1(2)- tensor Xi_8 : 12 165 0 -E(165)^29-E(165)^41-E(165)^74
 -E(165)^101-E(165)^116-E(165)^131-E(165)^134-E(165)^149-E(165)^161-E(165)^164
R_1(2)+ tensor R_1(1)- tensor Xi_4 : 12 165 0 -E(165)^37-E(165)^58-E(165)^67
 -E(165)^82-E(165)^97-E(165)^103-E(165)^133-E(165)^148-E(165)^157-E(165)^163
R_1(1)+ tensor R_1(1)- tensor Xi_8 : 12 165 0 -E(165)^2-E(165)^8-E(165)^17
 -E(165)^32-E(165)^62-E(165)^68-E(165)^83-E(165)^98-E(165)^107-E(165)^128
N_1([0,2]) tensor N_3([1,3])- tensor Xi_4 : 12 168 0 E(24)^11-E(24)^17
N_1([0,2]) tensor N_3([1,0])+ tensor Xi_4 : 12 168 0 -E(24)^11-E(24)^17
N_1([0,2]) tensor N_3([1,0])+ tensor Xi_8 : 12 168 0 -E(24)-E(24)^19
R_1(1)- tensor N_1([0,1]) tensor N_3([1,0])+ : 12 168 0 -E(56)^15-E(56)^23
 -E(56)^29-E(56)^37-E(56)^39-E(56)^53
R_1(1)- tensor R_1(1)+ tensor N_3([1,0])+ : 12 168 0 -E(168)^13-E(168)^31
 -E(168)^55-E(168)^61-E(168)^103-E(168)^157
R_1(1)- tensor N_1([0,1]) tensor N_3([1,3])+ : 12 168 0 -E(56)^15-E(56)^23
 +E(56)^29+E(56)^37-E(56)^39+E(56)^53
N_1([0,2]) tensor N_3([1,3])- tensor Xi_8 : 12 168 0 -E(24)+E(24)^19
N_3([1,1]) tensor R_1(3)- tensor Xi_4 : 12 168 0 0
R_1(1)- tensor R_1(1)+ tensor N_3([1,0])- : 12 168 0 E(168)^13+E(168)^31
 +E(168)^55+E(168)^61+E(168)^103+E(168)^157
R_1(1)- tensor N_1([0,1]) tensor N_3([1,3])- : 12 168 0 E(56)^15+E(56)^23
 -E(56)^29-E(56)^37+E(56)^39-E(56)^53
N_1([0,2]) tensor N_3([1,3])+ tensor Xi_8 : 12 168 0 E(24)-E(24)^19
R_1(3)+ tensor R_3^0(1,1,[0,1]) tensor Xi_4 : 12 168 0 -E(84)^13-E(84)^61
 -E(84)^73
R_1(3)- tensor R_1(2)+ tensor N_3([1,3])+ : 12 168 0 E(168)^23-E(168)^29
 -E(168)^53+E(168)^71+E(168)^95-E(168)^149
R_1(3)- tensor R_1(2)+ tensor N_3([1,0])+ : 12 168 0 -E(168)^23-E(168)^29
 -E(168)^53-E(168)^71-E(168)^95-E(168)^149
N_3([1,1]) tensor R_1(1)- tensor Xi_8 : 12 168 0 0
R_1(3)+ tensor R_3^0(1,1,[0,1]) tensor Xi_8 : 12 168 0 -E(84)^5-E(84)^17
 -E(84)^41
R_1(3)+ tensor R_3^0(1,5,[0,1]) tensor Xi_4 : 12 168 0 E(84)^13+E(84)^61
 +E(84)^73
N_1([0,2]) tensor N_3([1,0])- tensor Xi_4 : 12 168 0 E(24)^11+E(24)^17
R_1(3)- tensor R_1(2)+ tensor N_3([1,3])- : 12 168 0 -E(168)^23+E(168)^29
 +E(168)^53-E(168)^71-E(168)^95+E(168)^149
R_1(3)+ tensor R_3^0(1,7,[0,1])+ tensor Xi_4 : 12 168 0 -E(21)^10-E(21)^13
 -E(21)^19
R_1(3)- tensor R_1(1)+ tensor N_3([1,3])- : 12 168 0 E(168)^37-E(168)^79
 +E(168)^85+E(168)^109-E(168)^127-E(168)^151
N_1([0,2]) tensor N_3([1,0])- tensor Xi_8 : 12 168 0 E(24)+E(24)^19
N_1([0,2]) tensor N_3([1,3])+ tensor Xi_4 : 12 168 0 -E(24)^11+E(24)^17
R_1(3)- tensor R_1(1)+ tensor N_3([1,0])+ : 12 168 0 -E(168)^37-E(168)^79
 -E(168)^85-E(168)^109-E(168)^127-E(168)^151
R_1(1)- tensor R_1(2)+ tensor N_3([1,0])+ : 12 168 0 -E(168)^5-E(168)^47
 -E(168)^101-E(168)^125-E(168)^143-E(168)^167
R_1(3)- tensor N_1([0,1]) tensor N_3([1,3])- : 12 168 0 -E(56)^5-E(56)^13
 +E(56)^31-E(56)^45+E(56)^47+E(56)^55
R_1(3)- tensor R_1(2)+ tensor N_3([1,0])- : 12 168 0 E(168)^23+E(168)^29
 +E(168)^53+E(168)^71+E(168)^95+E(168)^149
R_1(1)+ tensor R_3^0(1,1,[0,1]) tensor Xi_4 : 12 168 0 
-E(84)-E(84)^25-E(84)^37
R_1(1)+ tensor R_3^0(1,1,[0,1]) tensor Xi_8 : 12 168 0 -E(84)^29-E(84)^53
 -E(84)^65
N_1([0,3]) tensor N_3([1,0])+ tensor Xi_4 : 12 168 0 -E(24)^11-E(24)^17
R_1(1)- tensor R_1(1)+ tensor N_3([1,3])+ : 12 168 0 -E(168)^13+E(168)^31
 +E(168)^55-E(168)^61+E(168)^103-E(168)^157
N_3([1,1]) tensor R_1(3)- tensor Xi_8 : 12 168 0 0
R_1(3)+ tensor R_3^0(1,3,[0,1])+ tensor Xi_4 : 12 168 0 E(21)^10+E(21)^13
 +E(21)^19
R_1(1)+ tensor R_3^0(3,1,[0,1]) tensor Xi_4 : 12 168 0 E(84)+E(84)^25+E(84)^37
R_1(3)- tensor R_1(1)+ tensor N_3([1,3])+ : 12 168 0 -E(168)^37+E(168)^79
 -E(168)^85-E(168)^109+E(168)^127+E(168)^151
R_1(3)- tensor R_1(1)+ tensor N_3([1,0])- : 12 168 0 E(168)^37+E(168)^79
 +E(168)^85+E(168)^109+E(168)^127+E(168)^151
R_1(3)- tensor N_1([0,1]) tensor N_3([1,0])- : 12 168 0 E(56)^5+E(56)^13
 +E(56)^31+E(56)^45+E(56)^47+E(56)^55
R_1(1)+ tensor R_3^0(3,5,[0,1]) tensor Xi_4 : 12 168 0 
-E(84)-E(84)^25-E(84)^37
R_1(1)+ tensor R_3^0(3,5,[0,1]) tensor Xi_8 : 12 168 0 -E(84)^29-E(84)^53
 -E(84)^65
R_1(3)- tensor N_1([0,1]) tensor N_3([1,3])+ : 12 168 0 E(56)^5+E(56)^13
 -E(56)^31+E(56)^45-E(56)^47-E(56)^55
R_1(1)+ tensor R_3^0(1,3,[0,1])+ tensor Xi_4 : 12 168 0 E(21)+E(21)^4+E(21)^16
R_1(1)+ tensor R_3^0(1,3,[0,1])+ tensor Xi_8 : 12 168 0 
E(21)^2+E(21)^8+E(21)^11
N_1([0,3]) tensor N_3([1,0])- tensor Xi_4 : 12 168 0 E(24)^11+E(24)^17
R_1(1)+ tensor R_3^0(1,5,[0,1]) tensor Xi_4 : 12 168 0 E(84)+E(84)^25+E(84)^37
R_1(1)- tensor R_1(1)+ tensor N_3([1,3])- : 12 168 0 E(168)^13-E(168)^31
 -E(168)^55+E(168)^61-E(168)^103+E(168)^157
N_1([0,3]) tensor N_3([1,0])+ tensor Xi_8 : 12 168 0 -E(24)-E(24)^19
R_1(1)+ tensor R_3^0(1,7,[0,1])+ tensor Xi_4 : 12 168 0 
-E(21)-E(21)^4-E(21)^16
R_1(1)+ tensor R_3^0(3,1,[0,1]) tensor Xi_8 : 12 168 0 E(84)^29+E(84)^53
 +E(84)^65
N_1([0,3]) tensor N_3([1,3])+ tensor Xi_4 : 12 168 0 -E(24)^11+E(24)^17
R_1(1)+ tensor R_3^0(1,7,[0,1])- tensor Xi_4 : 12 168 0 
-E(21)-E(21)^4-E(21)^16
R_1(1)+ tensor R_3^0(1,7,[0,1])- tensor Xi_8 : 12 168 0 -E(21)^2-E(21)^8
 -E(21)^11
N_1([0,1]) tensor N_3([1,0])+ tensor Xi_4 : 12 168 0 -E(24)^11-E(24)^17
R_1(1)- tensor N_1([0,1]) tensor N_3([1,0])- : 12 168 0 E(56)^15+E(56)^23
 +E(56)^29+E(56)^37+E(56)^39+E(56)^53
R_1(3)+ tensor R_3^0(3,1,[0,1]) tensor Xi_4 : 12 168 0 E(84)^13+E(84)^61
 +E(84)^73
R_1(3)+ tensor R_3^0(3,1,[0,1]) tensor Xi_8 : 12 168 0 E(84)^5+E(84)^17
 +E(84)^41
R_1(3)+ tensor R_3^0(3,5,[0,1]) tensor Xi_4 : 12 168 0 -E(84)^13-E(84)^61
 -E(84)^73
R_1(1)+ tensor R_3^0(1,3,[0,1])- tensor Xi_4 : 12 168 0 E(21)+E(21)^4+E(21)^16
R_1(1)+ tensor R_3^0(1,5,[0,1]) tensor Xi_8 : 12 168 0 E(84)^29+E(84)^53
 +E(84)^65
N_1([0,3]) tensor N_3([1,0])- tensor Xi_8 : 12 168 0 E(24)+E(24)^19
N_3([1,2]) tensor R_1(3)- tensor Xi_4 : 12 168 0 0
R_1(1)+ tensor R_3^0(1,7,[0,1])+ tensor Xi_8 : 12 168 0 -E(21)^2-E(21)^8
 -E(21)^11
N_3([1,2]) tensor R_1(1)- tensor Xi_8 : 12 168 0 0
N_3([1,2]) tensor R_1(1)- tensor Xi_4 : 12 168 0 0
R_1(3)+ tensor R_3^0(1,3,[0,1])+ tensor Xi_8 : 12 168 0 E(21)^5+E(21)^17
 +E(21)^20
N_1([0,1]) tensor N_3([1,0])- tensor Xi_8 : 12 168 0 E(24)+E(24)^19
R_1(3)+ tensor R_3^0(1,5,[0,1]) tensor Xi_8 : 12 168 0 E(84)^5+E(84)^17
 +E(84)^41
R_1(3)+ tensor R_3^0(1,3,[0,1])- tensor Xi_8 : 12 168 0 E(21)^5+E(21)^17
 +E(21)^20
N_1([0,1]) tensor N_3([1,0])- tensor Xi_4 : 12 168 0 E(24)^11+E(24)^17
N_1([0,1]) tensor N_3([1,0])+ tensor Xi_8 : 12 168 0 -E(24)-E(24)^19
R_1(1)- tensor R_1(2)+ tensor N_3([1,3])+ : 12 168 0 -E(168)^5+E(168)^47
 -E(168)^101-E(168)^125+E(168)^143+E(168)^167
R_1(1)+ tensor R_3^0(1,3,[0,1])- tensor Xi_8 : 12 168 0 
E(21)^2+E(21)^8+E(21)^11
N_1([0,1]) tensor N_3([1,3])- tensor Xi_8 : 12 168 0 -E(24)+E(24)^19
R_1(1)- tensor R_1(2)+ tensor N_3([1,0])- : 12 168 0 E(168)^5+E(168)^47
 +E(168)^101+E(168)^125+E(168)^143+E(168)^167
N_1([0,3]) tensor N_3([1,3])+ tensor Xi_8 : 12 168 0 E(24)-E(24)^19
R_1(3)+ tensor R_3^0(1,3,[0,1])- tensor Xi_4 : 12 168 0 E(21)^10+E(21)^13
 +E(21)^19
N_1([0,3]) tensor N_3([1,3])- tensor Xi_4 : 12 168 0 E(24)^11-E(24)^17
N_1([0,3]) tensor N_3([1,3])- tensor Xi_8 : 12 168 0 -E(24)+E(24)^19
N_1([0,1]) tensor N_3([1,3])- tensor Xi_4 : 12 168 0 E(24)^11-E(24)^17
N_3([1,2]) tensor R_1(3)- tensor Xi_8 : 12 168 0 0
N_3([1,1]) tensor R_1(1)- tensor Xi_4 : 12 168 0 0
R_1(3)+ tensor R_3^0(1,7,[0,1])- tensor Xi_8 : 12 168 0 -E(21)^5-E(21)^17
 -E(21)^20
N_1([0,1]) tensor N_3([1,3])+ tensor Xi_8 : 12 168 0 E(24)-E(24)^19
R_1(3)+ tensor R_3^0(3,5,[0,1]) tensor Xi_8 : 12 168 0 -E(84)^5-E(84)^17
 -E(84)^41
N_1([0,1]) tensor N_3([1,3])+ tensor Xi_4 : 12 168 0 -E(24)^11+E(24)^17
R_1(3)+ tensor R_3^0(1,7,[0,1])- tensor Xi_4 : 12 168 0 -E(21)^10-E(21)^13
 -E(21)^19
R_1(3)- tensor N_1([0,1]) tensor N_3([1,0])+ : 12 168 0 -E(56)^5-E(56)^13
 -E(56)^31-E(56)^45-E(56)^47-E(56)^55
R_1(3)+ tensor R_3^0(1,7,[0,1])+ tensor Xi_8 : 12 168 0 -E(21)^5-E(21)^17
 -E(21)^20
R_1(1)- tensor R_1(2)+ tensor N_3([1,3])- : 12 168 0 E(168)^5-E(168)^47
 +E(168)^101+E(168)^125-E(168)^143-E(168)^167
R_2^1(2,1,[1,1]) tensor R_1(1)+ tensor Xi_3 : 12 180 0 -E(60)^19-E(60)^31
(R_2(1)-)_1 tensor R_1(2)+ tensor Xi_9 : 12 180 0 E(20)+E(20)^9
(R_2(1)-)_1 tensor R_1(2)+ tensor Xi_3 : 12 180 0 -E(20)-E(20)^9
R_2^1(2,2,[1,0]) tensor R_1(2)+ tensor Xi_3 : 12 180 0 -E(60)^23-E(60)^47
R_2^1(2,2,[1,0]) tensor R_1(1)+ tensor Xi_9 : 12 180 0 E(60)^11+E(60)^59
(R_2(1)-)_1 tensor R_1(1)+ tensor Xi_9 : 12 180 0 E(20)^13+E(20)^17
R_2^1(2,2,[1,0]) tensor R_1(1)+ tensor Xi_3 : 12 180 0 -E(60)^11-E(60)^59
(R_2(1)-)_1 tensor R_1(1)+ tensor Xi_3 : 12 180 0 -E(20)^13-E(20)^17
R_2^1(2,1,[1,1]) tensor R_1(2)+ tensor Xi_9 : 12 180 0 E(60)^7+E(60)^43
R_2^1(2,1,[1,1]) tensor R_1(2)+ tensor Xi_3 : 12 180 0 -E(60)^7-E(60)^43
R_2^1(2,1,[1,1]) tensor R_1(1)+ tensor Xi_9 : 12 180 0 E(60)^19+E(60)^31
R_2^1(2,2,[1,1]) tensor R_1(1)+ tensor Xi_3 : 12 180 0 -E(60)^11-E(60)^59
R_2^1(2,2,[1,1]) tensor R_1(1)+ tensor Xi_9 : 12 180 0 E(60)^11+E(60)^59
R_2^1(2,2,[1,1]) tensor R_1(2)+ tensor Xi_3 : 12 180 0 -E(60)^23-E(60)^47
R_2^1(2,2,[1,1]) tensor R_1(2)+ tensor Xi_9 : 12 180 0 E(60)^23+E(60)^47
R_2^1(2,2,[1,0]) tensor R_1(2)+ tensor Xi_9 : 12 180 0 E(60)^23+E(60)^47
R_2^1(2,1,[1,0]) tensor R_1(2)+ tensor Xi_9 : 12 180 0 E(60)^7+E(60)^43
R_2^1(2,1,[1,0]) tensor R_1(2)+ tensor Xi_3 : 12 180 0 -E(60)^7-E(60)^43
R_2^1(2,1,[1,0]) tensor R_1(1)+ tensor Xi_9 : 12 180 0 E(60)^19+E(60)^31
R_2^1(2,1,[1,0]) tensor R_1(1)+ tensor Xi_3 : 12 180 0 -E(60)^19-E(60)^31
R_2^1(1,1,[1,0]) tensor R_1(1)+ tensor Xi_3 : 12 180 0 -E(60)^11-E(60)^59
R_2^1(1,1,[1,0]) tensor R_1(1)+ tensor Xi_9 : 12 180 0 E(60)^11+E(60)^59
R_2^1(1,1,[1,0]) tensor R_1(2)+ tensor Xi_3 : 12 180 0 -E(60)^23-E(60)^47
R_2^1(1,1,[1,0]) tensor R_1(2)+ tensor Xi_9 : 12 180 0 E(60)^23+E(60)^47
(R_2(2)-)_1 tensor R_1(2)+ tensor Xi_9 : 12 180 0 E(20)+E(20)^9
(R_2(2)-)_1 tensor R_1(2)+ tensor Xi_3 : 12 180 0 -E(20)-E(20)^9
(R_2(1)+)_1 tensor R_1(1)+ tensor Xi_3 : 12 180 0 -E(20)^13-E(20)^17
(R_2(1)+)_1 tensor R_1(1)+ tensor Xi_9 : 12 180 0 E(20)^13+E(20)^17
(R_2(1)+)_1 tensor R_1(2)+ tensor Xi_3 : 12 180 0 -E(20)-E(20)^9
(R_2(1)+)_1 tensor R_1(2)+ tensor Xi_9 : 12 180 0 E(20)+E(20)^9
(R_2(2)-)_1 tensor R_1(1)+ tensor Xi_9 : 12 180 0 E(20)^13+E(20)^17
(R_2(2)-)_1 tensor R_1(1)+ tensor Xi_3 : 12 180 0 -E(20)^13-E(20)^17
N_2([2,1]) tensor R_1(2)- tensor Xi_9 : 12 180 0 0
N_2([2,1]) tensor R_1(2)- tensor Xi_3 : 12 180 0 0
R_2^1(1,1,[1,1]) tensor R_1(1)+ tensor Xi_3 : 12 180 0 -E(60)^11-E(60)^59
N_2([2,1]) tensor R_1(1)- tensor Xi_9 : 12 180 0 0
N_2([2,1]) tensor R_1(1)- tensor Xi_3 : 12 180 0 0
N_2([1,0]) tensor R_1(1)- tensor Xi_3 : 12 180 0 0
N_2([1,0]) tensor R_1(1)- tensor Xi_9 : 12 180 0 0
N_2([1,0]) tensor R_1(2)- tensor Xi_3 : 12 180 0 0
N_2([1,0]) tensor R_1(2)- tensor Xi_9 : 12 180 0 0
N_2([1,1]) tensor R_1(2)- tensor Xi_9 : 12 180 0 0
N_2([1,1]) tensor R_1(2)- tensor Xi_3 : 12 180 0 0
N_2([1,2]) tensor R_1(1)- tensor Xi_3 : 12 180 0 0
N_2([1,2]) tensor R_1(1)- tensor Xi_9 : 12 180 0 0
N_2([1,1]) tensor R_1(1)- tensor Xi_9 : 12 180 0 0
R_2^1(1,1,[1,1]) tensor R_1(1)+ tensor Xi_9 : 12 180 0 E(60)^11+E(60)^59
R_2^1(1,2,[1,0]) tensor R_1(1)+ tensor Xi_9 : 12 180 0 E(60)^19+E(60)^31
N_2([1,1]) tensor R_1(1)- tensor Xi_3 : 12 180 0 0
R_2^1(1,1,[1,1]) tensor R_1(2)+ tensor Xi_9 : 12 180 0 E(60)^23+E(60)^47
(R_2(2)+)_1 tensor R_1(1)+ tensor Xi_3 : 12 180 0 -E(20)^13-E(20)^17
(R_2(2)+)_1 tensor R_1(1)+ tensor Xi_9 : 12 180 0 E(20)^13+E(20)^17
(R_2(2)+)_1 tensor R_1(2)+ tensor Xi_3 : 12 180 0 -E(20)-E(20)^9
N_2([1,2]) tensor R_1(2)- tensor Xi_3 : 12 180 0 0
N_2([1,2]) tensor R_1(2)- tensor Xi_9 : 12 180 0 0
(R_2(2)+)_1 tensor R_1(2)+ tensor Xi_9 : 12 180 0 E(20)+E(20)^9
R_2^1(1,2,[1,1]) tensor R_1(2)+ tensor Xi_9 : 12 180 0 E(60)^7+E(60)^43
R_2^1(1,2,[1,1]) tensor R_1(2)+ tensor Xi_3 : 12 180 0 -E(60)^7-E(60)^43
R_2^1(1,2,[1,1]) tensor R_1(1)+ tensor Xi_9 : 12 180 0 E(60)^19+E(60)^31
R_2^1(1,2,[1,1]) tensor R_1(1)+ tensor Xi_3 : 12 180 0 -E(60)^19-E(60)^31
R_2^1(1,2,[1,0]) tensor R_1(2)+ tensor Xi_9 : 12 180 0 E(60)^7+E(60)^43
R_2^1(1,2,[1,0]) tensor R_1(2)+ tensor Xi_3 : 12 180 0 -E(60)^7-E(60)^43
R_2^1(1,1,[1,1]) tensor R_1(2)+ tensor Xi_3 : 12 180 0 -E(60)^23-E(60)^47
R_2^1(1,2,[1,0]) tensor R_1(1)+ tensor Xi_3 : 12 180 0 -E(60)^19-E(60)^31
R_6^3(3,5,[1,1]) tensor Xi_4 : 12 192 0 -E(24)^11-E(24)^17
R_6^3(1,1,[1,0]) tensor Xi_4 : 12 192 0 E(24)^11+E(24)^17
R_6^3(1,1,[1,1]) tensor Xi_4 : 12 192 0 E(24)^11+E(24)^17
R_6^3(1,1,[1,1]) tensor Xi_8 : 12 192 0 E(24)+E(24)^19
R_6^3(1,3,[1,0]) tensor Xi_4 : 12 192 0 -E(24)^11+E(24)^17
R_6^3(1,3,[1,0]) tensor Xi_8 : 12 192 0 E(24)-E(24)^19
R_6^3(1,3,[1,1]) tensor Xi_4 : 12 192 0 -E(24)^11+E(24)^17
R_6^3(1,3,[1,1]) tensor Xi_8 : 12 192 0 E(24)-E(24)^19
R_6^3(1,5,[1,0]) tensor Xi_4 : 12 192 0 -E(24)^11-E(24)^17
R_6^3(1,5,[1,0]) tensor Xi_8 : 12 192 0 -E(24)-E(24)^19
R_6^3(1,5,[1,1]) tensor Xi_4 : 12 192 0 -E(24)^11-E(24)^17
R_6^3(1,5,[1,1]) tensor Xi_8 : 12 192 0 -E(24)-E(24)^19
R_6^3(1,7,[1,0]) tensor Xi_4 : 12 192 0 E(24)^11-E(24)^17
R_6^3(1,7,[1,0]) tensor Xi_8 : 12 192 0 -E(24)+E(24)^19
R_6^3(1,7,[1,1]) tensor Xi_4 : 12 192 0 E(24)^11-E(24)^17
R_6^3(1,7,[1,1]) tensor Xi_8 : 12 192 0 -E(24)+E(24)^19
R_6^3(3,1,[1,0]) tensor Xi_4 : 12 192 0 E(24)^11+E(24)^17
R_6^3(3,1,[1,0]) tensor Xi_8 : 12 192 0 E(24)+E(24)^19
R_6^4(5,1,nu)_1 tensor Xi_4 : 12 192 0 E(12)^4+E(12)^7
Xi_6 tensor R_6^4(3,3,nu)_1 tensor Xi_4 : 12 192 0 -E(12)^4+E(12)^7
R_6^3(3,1,[1,1]) tensor Xi_4 : 12 192 0 E(24)^11+E(24)^17
R_6^4(5,1,nu)_1 tensor Xi_8 : 12 192 0 E(12)^8+E(12)^11
R_6^3(3,1,[1,1]) tensor Xi_8 : 12 192 0 E(24)+E(24)^19
Xi_6 tensor R_6^4(5,1,nu)_1 tensor Xi_4 : 12 192 0 -E(12)^4-E(12)^7
R_6^4(3,3,nu)_1 tensor Xi_8 : 12 192 0 E(12)^8-E(12)^11
R_6^3(3,3,[1,0]) tensor Xi_4 : 12 192 0 E(24)^11-E(24)^17
R_6^3(3,3,[1,0]) tensor Xi_8 : 12 192 0 -E(24)+E(24)^19
R_6^3(3,3,[1,1]) tensor Xi_4 : 12 192 0 E(24)^11-E(24)^17
R_6^3(3,3,[1,1]) tensor Xi_8 : 12 192 0 -E(24)+E(24)^19
R_6^3(3,5,[1,0]) tensor Xi_4 : 12 192 0 -E(24)^11-E(24)^17
R_6^3(3,5,[1,0]) tensor Xi_8 : 12 192 0 -E(24)-E(24)^19
R_6^3(1,1,[1,0]) tensor Xi_8 : 12 192 0 E(24)+E(24)^19
R_6^3(3,5,[1,1]) tensor Xi_8 : 12 192 0 -E(24)-E(24)^19
R_6^3(3,7,[1,0]) tensor Xi_4 : 12 192 0 -E(24)^11+E(24)^17
R_6^3(3,7,[1,0]) tensor Xi_8 : 12 192 0 E(24)-E(24)^19
R_6^3(3,7,[1,1]) tensor Xi_4 : 12 192 0 -E(24)^11+E(24)^17
R_6^3(3,7,[1,1]) tensor Xi_8 : 12 192 0 E(24)-E(24)^19
R_6^3(5,1,[1,0]) tensor Xi_4 : 12 192 0 -E(24)^11-E(24)^17
R_6^3(5,1,[1,0]) tensor Xi_8 : 12 192 0 -E(24)-E(24)^19
R_6^3(5,1,[1,1]) tensor Xi_4 : 12 192 0 -E(24)^11-E(24)^17
R_6^3(5,1,[1,1]) tensor Xi_8 : 12 192 0 -E(24)-E(24)^19
R_6^3(5,3,[1,0]) tensor Xi_4 : 12 192 0 E(24)^11-E(24)^17
R_6^3(5,3,[1,0]) tensor Xi_8 : 12 192 0 -E(24)+E(24)^19
R_6^3(5,3,[1,1]) tensor Xi_4 : 12 192 0 E(24)^11-E(24)^17
R_6^3(5,3,[1,1]) tensor Xi_8 : 12 192 0 -E(24)+E(24)^19
R_6^3(5,5,[1,0]) tensor Xi_4 : 12 192 0 E(24)^11+E(24)^17
R_6^3(5,5,[1,0]) tensor Xi_8 : 12 192 0 E(24)+E(24)^19
R_6^3(5,5,[1,1]) tensor Xi_4 : 12 192 0 E(24)^11+E(24)^17
R_6^3(5,5,[1,1]) tensor Xi_8 : 12 192 0 E(24)+E(24)^19
R_6^3(5,7,[1,0]) tensor Xi_4 : 12 192 0 -E(24)^11+E(24)^17
R_6^3(5,7,[1,0]) tensor Xi_8 : 12 192 0 E(24)-E(24)^19
Xi_6 tensor R_6^4(5,1,nu)_1 tensor Xi_8 : 12 192 0 -E(12)^8-E(12)^11
R_6^4(5,3,nu)_1 tensor Xi_4 : 12 192 0 E(12)^4+E(12)^7
R_6^3(5,7,[1,1]) tensor Xi_4 : 12 192 0 -E(24)^11+E(24)^17
R_6^3(5,7,[1,1]) tensor Xi_8 : 12 192 0 E(24)-E(24)^19
R_6^4(3,3,nu)_1 tensor Xi_4 : 12 192 0 E(12)^4-E(12)^7
R_6^4(5,3,nu)_1 tensor Xi_8 : 12 192 0 E(12)^8+E(12)^11
R_6^3(7,1,[1,0]) tensor Xi_4 : 12 192 0 -E(24)^11-E(24)^17
R_6^3(7,1,[1,0]) tensor Xi_8 : 12 192 0 -E(24)-E(24)^19
R_6^3(7,1,[1,1]) tensor Xi_4 : 12 192 0 -E(24)^11-E(24)^17
R_6^3(7,1,[1,1]) tensor Xi_8 : 12 192 0 -E(24)-E(24)^19
R_6^3(7,3,[1,0]) tensor Xi_4 : 12 192 0 -E(24)^11+E(24)^17
R_6^3(7,3,[1,0]) tensor Xi_8 : 12 192 0 E(24)-E(24)^19
Xi_6 tensor R_6^4(5,3,nu)_1 tensor Xi_4 : 12 192 0 -E(12)^4-E(12)^7
Xi_6 tensor R_6^4(3,1,nu)_1 tensor Xi_8 : 12 192 0 -E(12)^8+E(12)^11
R_6^3(7,3,[1,1]) tensor Xi_4 : 12 192 0 -E(24)^11+E(24)^17
Xi_6 tensor R_6^4(5,3,nu)_1 tensor Xi_8 : 12 192 0 -E(12)^8-E(12)^11
R_6^4(7,1,nu)_1 tensor Xi_4 : 12 192 0 E(12)^4-E(12)^7
R_6^3(7,3,[1,1]) tensor Xi_8 : 12 192 0 E(24)-E(24)^19
Xi_6 tensor R_6^4(3,1,nu)_1 tensor Xi_4 : 12 192 0 -E(12)^4+E(12)^7
R_6^4(7,1,nu)_1 tensor Xi_8 : 12 192 0 E(12)^8-E(12)^11
R_6^3(7,5,[1,0]) tensor Xi_4 : 12 192 0 E(24)^11+E(24)^17
Xi_6 tensor R_6^4(7,1,nu)_1 tensor Xi_4 : 12 192 0 -E(12)^4+E(12)^7
R_6^4(3,1,nu)_1 tensor Xi_8 : 12 192 0 E(12)^8-E(12)^11
R_6^3(7,5,[1,0]) tensor Xi_8 : 12 192 0 E(24)+E(24)^19
Xi_6 tensor R_6^4(7,1,nu)_1 tensor Xi_8 : 12 192 0 -E(12)^8+E(12)^11
R_6^4(7,3,nu)_1 tensor Xi_4 : 12 192 0 E(12)^4-E(12)^7
R_6^3(7,5,[1,1]) tensor Xi_4 : 12 192 0 E(24)^11+E(24)^17
R_6^4(3,1,nu)_1 tensor Xi_4 : 12 192 0 E(12)^4-E(12)^7
R_6^4(7,3,nu)_1 tensor Xi_8 : 12 192 0 E(12)^8-E(12)^11
R_6^3(7,5,[1,1]) tensor Xi_8 : 12 192 0 E(24)+E(24)^19
Xi_6 tensor R_6^4(7,3,nu)_1 tensor Xi_4 : 12 192 0 -E(12)^4+E(12)^7
Xi_6 tensor R_6^4(1,3,nu)_1 tensor Xi_8 : 12 192 0 -E(12)^8-E(12)^11
R_6^3(7,7,[1,0]) tensor Xi_4 : 12 192 0 E(24)^11-E(24)^17
Xi_6 tensor R_6^4(7,3,nu)_1 tensor Xi_8 : 12 192 0 -E(12)^8+E(12)^11
Xi_6 tensor R_6^4(1,3,nu)_1 tensor Xi_4 : 12 192 0 -E(12)^4-E(12)^7
R_6^3(7,7,[1,0]) tensor Xi_8 : 12 192 0 -E(24)+E(24)^19
R_6^4(1,3,nu)_1 tensor Xi_8 : 12 192 0 E(12)^8+E(12)^11
R_6^4(1,3,nu)_1 tensor Xi_4 : 12 192 0 E(12)^4+E(12)^7
R_6^3(7,7,[1,1]) tensor Xi_4 : 12 192 0 E(24)^11-E(24)^17
Xi_6 tensor R_6^4(3,3,nu)_1 tensor Xi_8 : 12 192 0 -E(12)^8+E(12)^11
Xi_6 tensor R_6^4(1,1,nu)_1 tensor Xi_8 : 12 192 0 -E(12)^8-E(12)^11
R_6^3(7,7,[1,1]) tensor Xi_8 : 12 192 0 -E(24)+E(24)^19
Xi_6 tensor R_6^4(1,1,nu)_1 tensor Xi_4 : 12 192 0 -E(12)^4-E(12)^7
R_6^4(1,1,nu)_1 tensor Xi_8 : 12 192 0 E(12)^8+E(12)^11
R_6^4(5,3,[1,0]) tensor Xi_8 : 12 192 0 E(12)^8-E(12)^11
R_6^4(1,1,nu)_1 tensor Xi_4 : 12 192 0 E(12)^4+E(12)^7
R_6^4(7,3,[1,1]) tensor Xi_8 : 12 192 0 E(12)^8+E(12)^11
R_6^4(1,1,[1,0]) tensor Xi_8 : 12 192 0 -E(12)^8+E(12)^11
R_6^4(7,3,[1,1]) tensor Xi_4 : 12 192 0 E(12)^4+E(12)^7
R_6^4(7,3,[1,0]) tensor Xi_8 : 12 192 0 E(12)^8+E(12)^11
R_6^4(1,1,[1,1]) tensor Xi_4 : 12 192 0 -E(12)^4+E(12)^7
R_6^4(7,3,[1,0]) tensor Xi_4 : 12 192 0 E(12)^4+E(12)^7
R_6^4(7,1,[1,1]) tensor Xi_8 : 12 192 0 -E(12)^8-E(12)^11
R_6^4(1,1,[1,1]) tensor Xi_8 : 12 192 0 -E(12)^8+E(12)^11
R_6^4(7,1,[1,1]) tensor Xi_4 : 12 192 0 -E(12)^4-E(12)^7
R_6^4(7,1,[1,0]) tensor Xi_8 : 12 192 0 -E(12)^8-E(12)^11
R_6^4(1,3,[1,0]) tensor Xi_4 : 12 192 0 E(12)^4-E(12)^7
R_6^4(7,1,[1,0]) tensor Xi_4 : 12 192 0 -E(12)^4-E(12)^7
R_6^4(5,3,[1,1]) tensor Xi_8 : 12 192 0 E(12)^8-E(12)^11
R_6^4(1,3,[1,0]) tensor Xi_8 : 12 192 0 E(12)^8-E(12)^11
R_6^4(1,3,[1,1]) tensor Xi_4 : 12 192 0 E(12)^4-E(12)^7
R_6^4(1,3,[1,1]) tensor Xi_8 : 12 192 0 E(12)^8-E(12)^11
R_6^4(3,1,[1,0]) tensor Xi_4 : 12 192 0 -E(12)^4-E(12)^7
R_6^4(3,1,[1,0]) tensor Xi_8 : 12 192 0 -E(12)^8-E(12)^11
R_6^4(3,1,[1,1]) tensor Xi_4 : 12 192 0 -E(12)^4-E(12)^7
R_6^4(3,1,[1,1]) tensor Xi_8 : 12 192 0 -E(12)^8-E(12)^11
R_6^4(3,3,[1,0]) tensor Xi_4 : 12 192 0 E(12)^4+E(12)^7
R_6^4(3,3,[1,0]) tensor Xi_8 : 12 192 0 E(12)^8+E(12)^11
R_6^4(3,3,[1,1]) tensor Xi_4 : 12 192 0 E(12)^4+E(12)^7
R_6^4(3,3,[1,1]) tensor Xi_8 : 12 192 0 E(12)^8+E(12)^11
R_6^4(5,1,[1,0]) tensor Xi_4 : 12 192 0 -E(12)^4+E(12)^7
R_6^4(5,1,[1,0]) tensor Xi_8 : 12 192 0 -E(12)^8+E(12)^11
R_6^4(5,1,[1,1]) tensor Xi_4 : 12 192 0 -E(12)^4+E(12)^7
R_6^4(5,1,[1,1]) tensor Xi_8 : 12 192 0 -E(12)^8+E(12)^11
R_6^4(5,3,[1,0]) tensor Xi_4 : 12 192 0 E(12)^4-E(12)^7
R_6^4(1,1,[1,0]) tensor Xi_4 : 12 192 0 -E(12)^4+E(12)^7
R_6^4(5,3,[1,1]) tensor Xi_4 : 12 192 0 E(12)^4-E(12)^7
R_1(1)- tensor R_1(1)- tensor Xi_8 : 12 195 0 E(195)^19+E(195)^31+E(195)^34
 +E(195)^46+E(195)^76+E(195)^106+E(195)^109+E(195)^124+E(195)^136+E(195)^151
 +E(195)^154+E(195)^184
R_1(2)- tensor R_1(2)- tensor Xi_4 : 12 195 0 E(195)^17+E(195)^23+E(195)^38
 +E(195)^53+E(195)^62+E(195)^68+E(195)^77+E(195)^92+E(195)^107+E(195)^113
 +E(195)^152+E(195)^173
R_1(2)- tensor R_1(1)- tensor Xi_8 : 12 195 0 E(195)+E(195)^4+E(195)^16
 +E(195)^49+E(195)^61+E(195)^64+E(195)^79+E(195)^94+E(195)^121+E(195)^139
 +E(195)^166+E(195)^181
R_1(2)- tensor R_1(1)- tensor Xi_4 : 12 195 0 E(195)^14+E(195)^29+E(195)^56
 +E(195)^74+E(195)^101+E(195)^116+E(195)^131+E(195)^134+E(195)^146+E(195)^179
 +E(195)^191+E(195)^194
R_1(1)- tensor R_1(2)- tensor Xi_8 : 12 195 0 E(195)^7+E(195)^28+E(195)^37
 +E(195)^58+E(195)^67+E(195)^73+E(195)^97+E(195)^112+E(195)^148+E(195)^163
 +E(195)^187+E(195)^193
R_1(1)- tensor R_1(2)- tensor Xi_4 : 12 195 0 E(195)^2+E(195)^8+E(195)^32
 +E(195)^47+E(195)^83+E(195)^98+E(195)^122+E(195)^128+E(195)^137+E(195)^158
 +E(195)^167+E(195)^188
R_1(1)- tensor R_1(1)- tensor Xi_4 : 12 195 0 E(195)^11+E(195)^41+E(195)^44
 +E(195)^59+E(195)^71+E(195)^86+E(195)^89+E(195)^119+E(195)^149+E(195)^161
 +E(195)^164+E(195)^176
R_1(2)- tensor R_1(2)- tensor Xi_8 : 12 195 0 E(195)^22+E(195)^43+E(195)^82
 +E(195)^88+E(195)^103+E(195)^118+E(195)^127+E(195)^133+E(195)^142+E(195)^157
 +E(195)^172+E(195)^178
R_1(1)- tensor N_1([0,1]) tensor R_1(2)- tensor Xi_6 : 12 210 0 
E(35)^6+E(35)^19+E(35)^24+E(35)^26+E(35)^31+E(35)^34
N_1([0,2]) tensor R_1(1)- tensor Xi_2 : 12 210 0 E(21)^5+E(21)^17+E(21)^20
R_1(1)- tensor R_1(2)- tensor N_1(nu) tensor Xi_4 : 12 210 0 0
R_1(1)- tensor R_1(2)- tensor N_1(nu) tensor Xi_8 : 12 210 0 0
R_1(3)- tensor N_1([0,1]) tensor R_1(1)- tensor Xi_6 : 12 210 0 
E(35)^2+E(35)^8+E(35)^18+E(35)^22+E(35)^23+E(35)^32
R_1(3)- tensor N_1([0,1]) tensor R_1(2)- tensor Xi_6 : 12 210 0 
E(35)+E(35)^4+E(35)^9+E(35)^11+E(35)^16+E(35)^29
N_1([0,1]) tensor R_1(2)- tensor Xi_2 : 12 210 0 E(15)+E(15)^4
R_1(1)- tensor R_1(1)+ tensor R_1(2)- tensor Xi_6 : 12 210 0 
E(105)^22+E(105)^37+E(105)^43+E(105)^58+E(105)^67+E(105)^88
N_1([0,2]) tensor R_1(1)- tensor Xi_10 : 12 210 0 E(15)^2+E(15)^8
R_1(1)- tensor R_1(1)+ tensor R_1(1)- tensor Xi_6 : 12 210 0 
E(105)+E(105)^4+E(105)^16+E(105)^46+E(105)^64+E(105)^79
N_1([0,2]) tensor R_1(1)- tensor Xi_10 : 12 210 0 E(21)^10+E(21)^13+E(21)^19
R_1(3)- tensor R_1(1)+ tensor R_1(2)- tensor Xi_6 : 12 210 0 
E(105)^13+E(105)^52+E(105)^73+E(105)^82+E(105)^97+E(105)^103
N_1([0,1]) tensor R_1(1)- tensor Xi_10 : 12 210 0 E(15)^2+E(15)^8
N_1([0,1]) tensor R_1(1)- tensor Xi_2 : 12 210 0 E(15)^7+E(15)^13
R_1(3)- tensor R_1(2)+ tensor R_1(2)- tensor Xi_6 : 12 210 0 
E(105)^17+E(105)^38+E(105)^47+E(105)^62+E(105)^68+E(105)^83
N_1([0,1]) tensor R_1(1)- tensor Xi_2 : 12 210 0 E(21)^5+E(21)^17+E(21)^20
R_1(1)- tensor R_1(1)- tensor N_1(nu) tensor Xi_8 : 12 210 0 0
R_1(1)- tensor R_1(2)+ tensor R_1(1)- tensor Xi_6 : 12 210 0 
E(105)^11+E(105)^29+E(105)^44+E(105)^71+E(105)^74+E(105)^86
R_1(3)- tensor R_1(1)+ tensor R_1(1)- tensor Xi_6 : 12 210 0 
E(105)^19+E(105)^31+E(105)^34+E(105)^61+E(105)^76+E(105)^94
N_1([0,1]) tensor R_1(3)- tensor Xi_2 : 12 210 0 E(21)^2+E(21)^8+E(21)^11
N_1([0,2]) tensor R_1(2)- tensor Xi_10 : 12 210 0 E(15)^11+E(15)^14
N_1([0,1]) tensor R_1(3)- tensor Xi_10 : 12 210 0 E(21)+E(21)^4+E(21)^16
R_1(3)- tensor R_1(1)- tensor N_1(nu) tensor Xi_4 : 12 210 0 0
R_1(1)- tensor R_1(1)- tensor N_1(nu) tensor Xi_4 : 12 210 0 0
R_1(3)- tensor R_1(1)- tensor N_1(nu) tensor Xi_8 : 12 210 0 0
R_1(3)- tensor R_1(2)- tensor N_1(nu) tensor Xi_4 : 12 210 0 0
R_1(3)- tensor R_1(2)- tensor N_1(nu) tensor Xi_8 : 12 210 0 0
N_1([0,3]) tensor R_1(1)- tensor Xi_2 : 12 210 0 E(15)^7+E(15)^13
N_1([0,3]) tensor R_1(1)- tensor Xi_10 : 12 210 0 E(15)^2+E(15)^8
N_1([0,3]) tensor R_1(2)- tensor Xi_2 : 12 210 0 E(15)+E(15)^4
R_1(3)+ tensor R_1(1)+ tensor Xi_10 : 12 210 0 -E(105)^2-E(105)^8-E(105)^23
 -E(105)^32-E(105)^53-E(105)^92
R_1(3)+ tensor R_1(1)+ tensor Xi_2 : 12 210 0 -E(105)^22-E(105)^37-E(105)^43
 -E(105)^58-E(105)^67-E(105)^88
R_1(3)+ tensor R_1(2)+ tensor Xi_10 : 12 210 0 -E(105)^11-E(105)^29-E(105)^44
 -E(105)^71-E(105)^74-E(105)^86
N_1([0,2]) tensor R_1(3)- tensor Xi_2 : 12 210 0 E(21)^2+E(21)^8+E(21)^11
R_1(1)- tensor R_1(2)+ tensor R_1(2)- tensor Xi_6 : 12 210 0 E(105)^2+E(105)^8
 +E(105)^23+E(105)^32+E(105)^53+E(105)^92
N_1([0,1]) tensor R_1(2)- tensor Xi_10 : 12 210 0 E(15)^11+E(15)^14
N_1([0,2]) tensor R_1(1)- tensor Xi_2 : 12 210 0 E(15)^7+E(15)^13
R_1(1)+ tensor R_1(1)+ tensor Xi_2 : 12 210 0 -E(105)^13-E(105)^52-E(105)^73
 -E(105)^82-E(105)^97-E(105)^103
R_1(1)+ tensor R_1(1)+ tensor Xi_10 : 12 210 0 -E(105)^17-E(105)^38-E(105)^47
 -E(105)^62-E(105)^68-E(105)^83
R_1(1)+ tensor R_1(2)+ tensor Xi_2 : 12 210 0 -E(105)^19-E(105)^31-E(105)^34
 -E(105)^61-E(105)^76-E(105)^94
R_1(1)+ tensor R_1(2)+ tensor Xi_10 : 12 210 0 -E(105)^26-E(105)^41-E(105)^59
 -E(105)^89-E(105)^101-E(105)^104
R_1(3)+ tensor R_1(2)+ tensor Xi_2 : 12 210 0 -E(105)-E(105)^4-E(105)^16
 -E(105)^46-E(105)^64-E(105)^79
N_1([0,1]) tensor R_1(1)- tensor Xi_10 : 12 210 0 E(21)^10+E(21)^13+E(21)^19
N_1([0,3]) tensor R_1(2)- tensor Xi_10 : 12 210 0 E(15)^11+E(15)^14
N_1([0,2]) tensor R_1(2)- tensor Xi_2 : 12 210 0 E(15)+E(15)^4
R_1(1)- tensor N_1([0,1]) tensor R_1(1)- tensor Xi_6 : 12 210 0 
E(35)^3+E(35)^12+E(35)^13+E(35)^17+E(35)^27+E(35)^33
R_1(3)- tensor R_1(2)+ tensor R_1(1)- tensor Xi_6 : 12 210 0 
E(105)^26+E(105)^41+E(105)^59+E(105)^89+E(105)^101+E(105)^104
N_1([0,2]) tensor R_1(3)- tensor Xi_10 : 12 210 0 E(21)+E(21)^4+E(21)^16
R_1(1)+ tensor R_1(1)- tensor Xi_3 : 12 220 0 -E(220)^19-E(220)^39-E(220)^51
 -E(220)^79-E(220)^131-E(220)^139-E(220)^151-E(220)^171-E(220)^211-E(220)^219
R_1(1)+ tensor R_1(1)- tensor Xi_9 : 12 220 0 E(220)^19+E(220)^39+E(220)^51
 +E(220)^79+E(220)^131+E(220)^139+E(220)^151+E(220)^171+E(220)^211+E(220)^219
R_1(2)+ tensor R_1(2)- tensor Xi_9 : 12 220 0 E(220)^3+E(220)^23+E(220)^27
 +E(220)^47+E(220)^67+E(220)^103+E(220)^147+E(220)^163+E(220)^203+E(220)^207
R_1(2)+ tensor R_1(2)- tensor Xi_3 : 12 220 0 -E(220)^3-E(220)^23-E(220)^27
 -E(220)^47-E(220)^67-E(220)^103-E(220)^147-E(220)^163-E(220)^203-E(220)^207
R_1(2)+ tensor R_1(1)- tensor Xi_9 : 12 220 0 E(220)^31+E(220)^59+E(220)^71
 +E(220)^91+E(220)^111+E(220)^119+E(220)^159+E(220)^179+E(220)^191+E(220)^199
R_1(2)+ tensor R_1(1)- tensor Xi_3 : 12 220 0 -E(220)^31-E(220)^59-E(220)^71
 -E(220)^91-E(220)^111-E(220)^119-E(220)^159-E(220)^179-E(220)^191-E(220)^199
R_1(1)+ tensor R_1(2)- tensor Xi_9 : 12 220 0 E(220)^7+E(220)^43+E(220)^63
 +E(220)^83+E(220)^87+E(220)^107+E(220)^123+E(220)^127+E(220)^167+E(220)^183
R_1(1)+ tensor R_1(2)- tensor Xi_3 : 12 220 0 -E(220)^7-E(220)^43-E(220)^63
 -E(220)^83-E(220)^87-E(220)^107-E(220)^123-E(220)^127-E(220)^167-E(220)^183
R_4^0(1,1,[1,0])+ tensor R_1(2)+ tensor R_1(2)- : 12 240 0 
-E(120)^7-E(120)^103
N_1([0,1]) tensor R_4^0(3,1,[1,0])+ tensor Xi_4 : 12 240 0 -E(24)^17
N_1([0,1]) tensor R_4^0(3,1,[1,0])+ tensor Xi_8 : 12 240 0 -E(24)
N_1([0,1]) tensor R_4^0(3,1,[1,0])- tensor Xi_4 : 12 240 0 E(24)^17
N_1([0,1]) tensor R_4^0(3,1,[1,0])- tensor Xi_8 : 12 240 0 E(24)
N_1([0,1]) tensor R_4^0(3,1,[1,2])+ tensor Xi_4 : 12 240 0 E(24)^17
N_1([0,1]) tensor R_4^0(3,1,[1,2])+ tensor Xi_8 : 12 240 0 E(24)
N_1([0,1]) tensor R_4^0(3,1,[1,2])- tensor Xi_4 : 12 240 0 -E(24)^17
N_1([0,1]) tensor R_4^0(3,1,[1,2])- tensor Xi_8 : 12 240 0 -E(24)
N_1([0,1]) tensor R_4^0(1,5,[0,1])+ tensor Xi_4 : 12 240 0 -E(24)^17
N_1([0,1]) tensor R_4^0(1,5,[0,1])+ tensor Xi_8 : 12 240 0 -E(24)
N_1([0,1]) tensor R_4^0(1,5,[0,1])- tensor Xi_4 : 12 240 0 E(24)^17
N_1([0,1]) tensor R_4^0(1,5,[0,1])- tensor Xi_8 : 12 240 0 E(24)
N_1([0,1]) tensor R_4^0(1,5,[2,1])+ tensor Xi_4 : 12 240 0 E(24)^17
N_1([0,1]) tensor R_4^0(1,5,[2,1])+ tensor Xi_8 : 12 240 0 E(24)
N_1([0,1]) tensor R_4^0(1,5,[2,1])- tensor Xi_4 : 12 240 0 -E(24)^17
N_1([0,1]) tensor R_4^0(1,5,[2,1])- tensor Xi_8 : 12 240 0 -E(24)
N_1([0,1]) tensor R_4^0(3,5,[0,1])+ tensor Xi_4 : 12 240 0 -E(24)^11
N_1([0,1]) tensor R_4^0(3,5,[0,1])+ tensor Xi_8 : 12 240 0 -E(24)^19
N_1([0,1]) tensor R_4^0(3,5,[0,1])- tensor Xi_4 : 12 240 0 E(24)^11
N_1([0,1]) tensor R_4^0(3,5,[0,1])- tensor Xi_8 : 12 240 0 E(24)^19
N_1([0,1]) tensor R_4^0(3,5,[2,1])+ tensor Xi_4 : 12 240 0 E(24)^11
N_1([0,1]) tensor R_4^0(3,5,[2,1])+ tensor Xi_8 : 12 240 0 E(24)^19
N_1([0,1]) tensor R_4^0(3,5,[2,1])- tensor Xi_4 : 12 240 0 -E(24)^11
N_1([0,1]) tensor R_4^0(3,5,[2,1])- tensor Xi_8 : 12 240 0 -E(24)^19
N_1([0,2]) tensor R_4^0(1,1,[1,0])+ tensor Xi_4 : 12 240 0 -E(24)^11
N_1([0,2]) tensor R_4^0(1,1,[1,0])+ tensor Xi_8 : 12 240 0 -E(24)^19
N_1([0,2]) tensor R_4^0(1,1,[1,0])- tensor Xi_4 : 12 240 0 E(24)^11
N_1([0,2]) tensor R_4^0(1,1,[1,0])- tensor Xi_8 : 12 240 0 E(24)^19
N_1([0,2]) tensor R_4^0(1,1,[1,2])+ tensor Xi_4 : 12 240 0 E(24)^11
N_1([0,2]) tensor R_4^0(1,1,[1,2])+ tensor Xi_8 : 12 240 0 E(24)^19
N_1([0,2]) tensor R_4^0(1,1,[1,2])- tensor Xi_4 : 12 240 0 -E(24)^11
N_1([0,2]) tensor R_4^0(1,1,[1,2])- tensor Xi_8 : 12 240 0 -E(24)^19
N_1([0,2]) tensor R_4^0(3,1,[1,0])+ tensor Xi_4 : 12 240 0 -E(24)^17
N_1([0,2]) tensor R_4^0(3,1,[1,0])+ tensor Xi_8 : 12 240 0 -E(24)
N_1([0,2]) tensor R_4^0(3,1,[1,0])- tensor Xi_4 : 12 240 0 E(24)^17
N_1([0,2]) tensor R_4^0(3,1,[1,0])- tensor Xi_8 : 12 240 0 E(24)
N_1([0,2]) tensor R_4^0(3,1,[1,2])+ tensor Xi_4 : 12 240 0 E(24)^17
N_1([0,2]) tensor R_4^0(3,1,[1,2])+ tensor Xi_8 : 12 240 0 E(24)
N_1([0,2]) tensor R_4^0(3,1,[1,2])- tensor Xi_4 : 12 240 0 -E(24)^17
N_1([0,2]) tensor R_4^0(3,1,[1,2])- tensor Xi_8 : 12 240 0 -E(24)
N_1([0,2]) tensor R_4^0(1,5,[0,1])+ tensor Xi_4 : 12 240 0 -E(24)^17
N_1([0,2]) tensor R_4^0(1,5,[0,1])+ tensor Xi_8 : 12 240 0 -E(24)
N_1([0,2]) tensor R_4^0(1,5,[0,1])- tensor Xi_4 : 12 240 0 E(24)^17
N_1([0,2]) tensor R_4^0(1,5,[0,1])- tensor Xi_8 : 12 240 0 E(24)
N_1([0,2]) tensor R_4^0(1,5,[2,1])+ tensor Xi_4 : 12 240 0 E(24)^17
N_1([0,2]) tensor R_4^0(1,5,[2,1])+ tensor Xi_8 : 12 240 0 E(24)
N_1([0,2]) tensor R_4^0(1,5,[2,1])- tensor Xi_4 : 12 240 0 -E(24)^17
N_1([0,1]) tensor R_4^0(1,1,[1,2])- tensor Xi_4 : 12 240 0 -E(24)^11
N_1([0,2]) tensor R_4^0(1,5,[2,1])- tensor Xi_8 : 12 240 0 -E(24)
N_1([0,2]) tensor R_4^0(3,5,[0,1])+ tensor Xi_4 : 12 240 0 -E(24)^11
R_4^0(1,1,[1,0])+ tensor N_1([0,1]) tensor R_1(1)- : 12 240 0 
-E(40)^13-E(40)^37
R_4^0(1,1,[1,0])+ tensor N_1([0,1]) tensor R_1(2)- : 12 240 0 
-E(40)^21-E(40)^29
R_4^0(1,1,[1,0])+ tensor R_1(1)+ tensor R_1(1)- : 12 240 0 
-E(120)^71-E(120)^119
R_4^0(1,1,[1,0])+ tensor R_1(2)+ tensor R_1(1)- : 12 240 0 
-E(120)^31-E(120)^79
R_4^0(1,1,[1,0])- tensor N_1([0,1]) tensor R_1(2)- : 12 240 0 
E(40)^21+E(40)^29
R_4^0(1,1,[1,0])- tensor N_1([0,1]) tensor R_1(1)- : 12 240 0 
E(40)^13+E(40)^37
N_1([0,1]) tensor R_4^0(1,1,[1,2])- tensor Xi_8 : 12 240 0 -E(24)^19
R_4^0(1,1,[1,0])- tensor R_1(1)+ tensor R_1(1)- : 12 240 0 
E(120)^71+E(120)^119
R_4^0(1,1,[1,0])- tensor R_1(1)+ tensor R_1(2)- : 12 240 0 E(120)^23+E(120)^47
R_4^0(1,1,[1,0])- tensor R_1(2)+ tensor R_1(1)- : 12 240 0 E(120)^31+E(120)^79
R_4^0(1,1,[1,0])- tensor R_1(2)+ tensor R_1(2)- : 12 240 0 E(120)^7+E(120)^103
R_4^0(1,1,[1,2])+ tensor N_1([0,1]) tensor R_1(1)- : 12 240 0 
E(40)^13+E(40)^37
R_4^2(3,3,nu)_1 tensor R_1(2)- tensor Xi_8 : 12 240 0 E(60)^4+E(60)^16
 +E(60)^19+E(60)^31
R_4^2(3,3,nu)_1 tensor R_1(2)- tensor Xi_4 : 12 240 0 E(60)^11+E(60)^44
 +E(60)^56+E(60)^59
R_4^2(3,3,nu)_1 tensor R_1(1)- tensor Xi_8 : 12 240 0 E(60)^7+E(60)^28
 +E(60)^43+E(60)^52
R_4^2(3,3,nu)_1 tensor R_1(1)- tensor Xi_4 : 12 240 0 E(60)^8+E(60)^23
 +E(60)^32+E(60)^47
N_1([0,1]) tensor R_4^0(1,1,[1,0])+ tensor Xi_4 : 12 240 0 -E(24)^11
N_1([0,1]) tensor R_4^0(1,1,[1,0])+ tensor Xi_8 : 12 240 0 -E(24)^19
R_4^0(1,1,[1,2])+ tensor N_1([0,1]) tensor R_1(2)- : 12 240 0 
E(40)^21+E(40)^29
R_4^2(1,3,nu)_1 tensor R_1(2)- tensor Xi_8 : 12 240 0 E(60)^4+E(60)^16
 -E(60)^19-E(60)^31
R_4^2(1,3,nu)_1 tensor R_1(2)- tensor Xi_4 : 12 240 0 -E(60)^11+E(60)^44
 +E(60)^56-E(60)^59
R_4^0(1,1,[1,2])+ tensor R_1(1)+ tensor R_1(1)- : 12 240 0 
E(120)^71+E(120)^119
R_4^2(1,3,nu)_1 tensor R_1(1)- tensor Xi_8 : 12 240 0 -E(60)^7+E(60)^28
 -E(60)^43+E(60)^52
R_4^2(1,3,nu)_1 tensor R_1(1)- tensor Xi_4 : 12 240 0 E(60)^8-E(60)^23
 +E(60)^32-E(60)^47
R_4^0(1,1,[1,2])+ tensor R_1(1)+ tensor R_1(2)- : 12 240 0 E(120)^23+E(120)^47
R_4^0(1,1,[1,2])+ tensor R_1(2)+ tensor R_1(1)- : 12 240 0 E(120)^31+E(120)^79
R_4^0(1,1,[1,2])+ tensor R_1(2)+ tensor R_1(2)- : 12 240 0 E(120)^7+E(120)^103
R_4^0(1,1,[1,2])- tensor N_1([0,1]) tensor R_1(1)- : 12 240 0 
-E(40)^13-E(40)^37
Xi_6 tensor R_4^2(3,3,[0,1]) tensor R_1(2)- tensor Xi_8 : 12 240 0 
-E(60)^4-E(60)^16+E(60)^19+E(60)^31
Xi_6 tensor R_4^2(3,3,[0,1]) tensor R_1(2)- tensor Xi_4 : 12 240 0 
E(60)^11-E(60)^44-E(60)^56+E(60)^59
Xi_6 tensor R_4^2(3,3,[0,1]) tensor R_1(1)- tensor Xi_8 : 12 240 0 
E(60)^7-E(60)^28+E(60)^43-E(60)^52
Xi_6 tensor R_4^2(3,3,[0,1]) tensor R_1(1)- tensor Xi_4 : 12 240 0 
-E(60)^8+E(60)^23-E(60)^32+E(60)^47
R_4^0(1,1,[1,2])- tensor N_1([0,1]) tensor R_1(2)- : 12 240 0 
-E(40)^21-E(40)^29
R_4^0(1,1,[1,2])- tensor R_1(1)+ tensor R_1(1)- : 12 240 0 
-E(120)^71-E(120)^119
R_4^0(1,1,[1,2])- tensor R_1(1)+ tensor R_1(2)- : 12 240 0 
-E(120)^23-E(120)^47
R_4^2(3,3,[0,1]) tensor R_1(2)- tensor Xi_8 : 12 240 0 E(60)^4+E(60)^16
 -E(60)^19-E(60)^31
R_4^2(3,3,[0,1]) tensor R_1(2)- tensor Xi_4 : 12 240 0 -E(60)^11+E(60)^44
 +E(60)^56-E(60)^59
R_4^0(1,1,[1,2])- tensor R_1(2)+ tensor R_1(1)- : 12 240 0 
-E(120)^31-E(120)^79
R_4^2(3,3,[0,1]) tensor R_1(1)- tensor Xi_8 : 12 240 0 -E(60)^7+E(60)^28
 -E(60)^43+E(60)^52
R_4^2(3,3,[0,1]) tensor R_1(1)- tensor Xi_4 : 12 240 0 E(60)^8-E(60)^23
 +E(60)^32-E(60)^47
R_4^0(1,1,[1,2])- tensor R_1(2)+ tensor R_1(2)- : 12 240 0 
-E(120)^7-E(120)^103
R_4^0(3,1,[1,0])+ tensor N_1([0,1]) tensor R_1(1)- : 12 240 0 
-E(40)^7-E(40)^23
R_4^0(3,1,[1,0])+ tensor N_1([0,1]) tensor R_1(2)- : 12 240 0 
-E(40)^31-E(40)^39
R_4^0(3,1,[1,0])+ tensor R_1(1)+ tensor R_1(1)- : 12 240 0 
-E(120)^29-E(120)^101
R_4^2(3,1,[0,1]) tensor R_1(2)- tensor Xi_8 : 12 240 0 -E(60)^4-E(60)^16
 -E(60)^19-E(60)^31
R_4^2(3,1,[0,1]) tensor R_1(2)- tensor Xi_4 : 12 240 0 -E(60)^11-E(60)^44
 -E(60)^56-E(60)^59
R_4^2(3,1,[0,1]) tensor R_1(1)- tensor Xi_8 : 12 240 0 -E(60)^7-E(60)^28
 -E(60)^43-E(60)^52
R_4^2(3,1,[0,1]) tensor R_1(1)- tensor Xi_4 : 12 240 0 -E(60)^8-E(60)^23
 -E(60)^32-E(60)^47
Xi_6 tensor R_4^2(1,3,[0,1]) tensor R_1(2)- tensor Xi_8 : 12 240 0 
-E(60)^4-E(60)^16-E(60)^19-E(60)^31
Xi_6 tensor R_4^2(1,3,[0,1]) tensor R_1(2)- tensor Xi_4 : 12 240 0 
-E(60)^11-E(60)^44-E(60)^56-E(60)^59
Xi_6 tensor R_4^2(1,3,[0,1]) tensor R_1(1)- tensor Xi_8 : 12 240 0 
-E(60)^7-E(60)^28-E(60)^43-E(60)^52
Xi_6 tensor R_4^2(1,3,[0,1]) tensor R_1(1)- tensor Xi_4 : 12 240 0 
-E(60)^8-E(60)^23-E(60)^32-E(60)^47
N_1([0,1]) tensor R_4^0(1,1,[1,2])+ tensor Xi_8 : 12 240 0 E(24)^19
R_4^2(1,3,[0,1]) tensor R_1(2)- tensor Xi_8 : 12 240 0 E(60)^4+E(60)^16
 +E(60)^19+E(60)^31
R_4^2(1,3,[0,1]) tensor R_1(2)- tensor Xi_4 : 12 240 0 E(60)^11+E(60)^44
 +E(60)^56+E(60)^59
N_1([0,1]) tensor R_4^0(1,1,[1,0])- tensor Xi_4 : 12 240 0 E(24)^11
R_4^2(1,3,[0,1]) tensor R_1(1)- tensor Xi_8 : 12 240 0 E(60)^7+E(60)^28
 +E(60)^43+E(60)^52
R_4^2(1,3,[0,1]) tensor R_1(1)- tensor Xi_4 : 12 240 0 E(60)^8+E(60)^23
 +E(60)^32+E(60)^47
R_4^0(3,1,[1,0])+ tensor R_1(1)+ tensor R_1(2)- : 12 240 0 
-E(120)^53-E(120)^77
R_4^0(3,1,[1,0])+ tensor R_1(2)+ tensor R_1(1)- : 12 240 0 
-E(120)^61-E(120)^109
R_4^0(3,1,[1,0])+ tensor R_1(2)+ tensor R_1(2)- : 12 240 0 
-E(120)^13-E(120)^37
R_4^0(3,1,[1,0])- tensor N_1([0,1]) tensor R_1(1)- : 12 240 0 E(40)^7+E(40)^23
R_4^2(1,1,[0,1]) tensor R_1(2)- tensor Xi_8 : 12 240 0 -E(60)^4-E(60)^16
 +E(60)^19+E(60)^31
R_4^2(1,1,[0,1]) tensor R_1(2)- tensor Xi_4 : 12 240 0 E(60)^11-E(60)^44
 -E(60)^56+E(60)^59
N_1([0,1]) tensor R_4^0(1,1,[1,2])+ tensor Xi_4 : 12 240 0 E(24)^11
R_4^2(1,1,[0,1]) tensor R_1(1)- tensor Xi_8 : 12 240 0 E(60)^7-E(60)^28
 +E(60)^43-E(60)^52
R_4^2(1,1,[0,1]) tensor R_1(1)- tensor Xi_4 : 12 240 0 -E(60)^8+E(60)^23
 -E(60)^32+E(60)^47
R_4^0(3,1,[1,0])- tensor R_1(1)+ tensor R_1(1)- : 12 240 0 
E(120)^29+E(120)^101
R_4^0(1,7,[1,1])- tensor R_1(2)- tensor Xi_8 : 12 240 0 0
R_4^0(1,7,[1,1])- tensor R_1(2)- tensor Xi_4 : 12 240 0 0
N_1([0,1]) tensor R_4^0(1,1,[1,0])- tensor Xi_8 : 12 240 0 E(24)^19
R_4^0(1,7,[1,1])- tensor R_1(1)- tensor Xi_8 : 12 240 0 0
R_4^0(1,7,[1,1])- tensor R_1(1)- tensor Xi_4 : 12 240 0 0
R_4^0(1,1,[1,0])+ tensor R_1(1)+ tensor R_1(2)- : 12 240 0 
-E(120)^23-E(120)^47
R_4^0(3,1,[1,0])- tensor R_1(1)+ tensor R_1(2)- : 12 240 0 E(120)^53+E(120)^77
R_4^0(3,1,[1,0])- tensor R_1(2)+ tensor R_1(1)- : 12 240 0 
E(120)^61+E(120)^109
R_4^0(3,1,[1,0])- tensor R_1(2)+ tensor R_1(2)- : 12 240 0 E(120)^13+E(120)^37
R_4^0(1,7,[1,1])+ tensor R_1(2)- tensor Xi_8 : 12 240 0 0
R_4^0(1,7,[1,1])+ tensor R_1(2)- tensor Xi_4 : 12 240 0 0
R_4^0(3,1,[1,2])+ tensor N_1([0,1]) tensor R_1(1)- : 12 240 0 E(40)^7+E(40)^23
R_4^0(1,7,[1,1])+ tensor R_1(1)- tensor Xi_8 : 12 240 0 0
R_4^0(1,7,[1,1])+ tensor R_1(1)- tensor Xi_4 : 12 240 0 0
R_4^0(3,1,[1,2])+ tensor N_1([0,1]) tensor R_1(2)- : 12 240 0 
E(40)^31+E(40)^39
R_4^0(3,1,[1,2])+ tensor R_1(1)+ tensor R_1(1)- : 12 240 0 
E(120)^29+E(120)^101
R_4^0(1,7,[1,0])- tensor R_1(2)- tensor Xi_8 : 12 240 0 0
R_4^0(1,7,[1,0])- tensor R_1(2)- tensor Xi_4 : 12 240 0 0
R_4^0(3,1,[1,2])+ tensor R_1(1)+ tensor R_1(2)- : 12 240 0 E(120)^53+E(120)^77
R_4^0(1,7,[1,0])- tensor R_1(1)- tensor Xi_8 : 12 240 0 0
R_4^0(1,7,[1,0])- tensor R_1(1)- tensor Xi_4 : 12 240 0 0
R_4^0(3,1,[1,2])+ tensor R_1(2)+ tensor R_1(1)- : 12 240 0 
E(120)^61+E(120)^109
R_4^0(3,1,[1,2])+ tensor R_1(2)+ tensor R_1(2)- : 12 240 0 E(120)^13+E(120)^37
R_4^0(3,1,[1,2])- tensor N_1([0,1]) tensor R_1(1)- : 12 240 0 
-E(40)^7-E(40)^23
R_4^0(3,1,[1,2])- tensor N_1([0,1]) tensor R_1(2)- : 12 240 0 
-E(40)^31-E(40)^39
R_4^0(1,7,[1,0])+ tensor R_1(2)- tensor Xi_8 : 12 240 0 0
R_4^0(1,7,[1,0])+ tensor R_1(2)- tensor Xi_4 : 12 240 0 0
R_4^0(3,1,[1,2])- tensor R_1(1)+ tensor R_1(1)- : 12 240 0 
-E(120)^29-E(120)^101
R_4^0(1,7,[1,0])+ tensor R_1(1)- tensor Xi_8 : 12 240 0 0
R_4^0(1,7,[1,0])+ tensor R_1(1)- tensor Xi_4 : 12 240 0 0
R_4^0(3,1,[1,2])- tensor R_1(1)+ tensor R_1(2)- : 12 240 0 
-E(120)^53-E(120)^77
R_4^0(3,1,[1,2])- tensor R_1(2)+ tensor R_1(1)- : 12 240 0 
-E(120)^61-E(120)^109
R_4^0(1,3,[1,1])- tensor R_1(2)- tensor Xi_8 : 12 240 0 0
R_4^0(1,3,[1,1])- tensor R_1(2)- tensor Xi_4 : 12 240 0 0
R_4^0(1,3,[1,1])- tensor R_1(1)- tensor Xi_8 : 12 240 0 0
R_4^0(1,3,[1,1])- tensor R_1(1)- tensor Xi_4 : 12 240 0 0
R_4^0(1,3,[1,1])+ tensor R_1(2)- tensor Xi_8 : 12 240 0 0
R_4^0(1,3,[1,1])+ tensor R_1(2)- tensor Xi_4 : 12 240 0 0
N_1([0,2]) tensor R_4^0(3,5,[0,1])+ tensor Xi_8 : 12 240 0 -E(24)^19
R_4^0(1,3,[1,1])+ tensor R_1(1)- tensor Xi_8 : 12 240 0 0
R_4^0(1,3,[1,1])+ tensor R_1(1)- tensor Xi_4 : 12 240 0 0
N_1([0,2]) tensor R_4^0(3,5,[0,1])- tensor Xi_4 : 12 240 0 E(24)^11
R_4^0(3,1,[1,2])- tensor R_1(2)+ tensor R_1(2)- : 12 240 0 
-E(120)^13-E(120)^37
R_4^0(1,5,[0,1])+ tensor N_1([0,1]) tensor R_1(1)- : 12 240 0 
-E(40)^7-E(40)^23
R_4^0(1,5,[0,1])+ tensor N_1([0,1]) tensor R_1(2)- : 12 240 0 
-E(40)^31-E(40)^39
R_4^0(3,5,[2,1])- tensor R_1(2)+ tensor R_1(2)- : 12 240 0 
-E(120)^7-E(120)^103
R_4^0(1,3,[1,0])- tensor R_1(2)- tensor Xi_8 : 12 240 0 0
N_1([0,2]) tensor R_4^0(3,5,[2,1])- tensor Xi_8 : 12 240 0 -E(24)^19
R_4^0(3,5,[0,1])- tensor R_1(1)+ tensor R_1(2)- : 12 240 0 E(120)^23+E(120)^47
R_4^0(3,5,[0,1])- tensor R_1(2)+ tensor R_1(2)- : 12 240 0 E(120)^7+E(120)^103
R_4^0(3,5,[2,1])+ tensor N_1([0,1]) tensor R_1(1)- : 12 240 0 
E(40)^13+E(40)^37
R_4^0(3,5,[2,1])+ tensor N_1([0,1]) tensor R_1(2)- : 12 240 0 
E(40)^21+E(40)^29
R_4^0(3,5,[2,1])+ tensor R_1(1)+ tensor R_1(2)- : 12 240 0 E(120)^23+E(120)^47
R_4^0(3,5,[2,1])+ tensor R_1(2)+ tensor R_1(1)- : 12 240 0 E(120)^31+E(120)^79
R_4^0(3,5,[2,1])+ tensor R_1(2)+ tensor R_1(2)- : 12 240 0 E(120)^7+E(120)^103
R_4^0(3,5,[2,1])- tensor N_1([0,1]) tensor R_1(2)- : 12 240 0 
-E(40)^21-E(40)^29
R_4^0(3,5,[2,1])- tensor R_1(1)+ tensor R_1(1)- : 12 240 0 
-E(120)^71-E(120)^119
R_4^0(3,5,[2,1])- tensor R_1(1)+ tensor R_1(2)- : 12 240 0 
-E(120)^23-E(120)^47
N_1([0,2]) tensor R_4^0(3,5,[0,1])- tensor Xi_8 : 12 240 0 E(24)^19
N_1([0,2]) tensor R_4^0(3,5,[2,1])+ tensor Xi_4 : 12 240 0 E(24)^11
R_4^0(1,5,[0,1])- tensor N_1([0,1]) tensor R_1(2)- : 12 240 0 
E(40)^31+E(40)^39
R_4^0(1,5,[0,1])- tensor R_1(1)+ tensor R_1(1)- : 12 240 0 
E(120)^29+E(120)^101
R_4^0(3,5,[1,0]) tensor R_1(2)- tensor Xi_8 : 12 240 0 0
R_4^0(3,5,[1,0]) tensor R_1(2)- tensor Xi_4 : 12 240 0 0
R_4^0(1,5,[0,1])- tensor R_1(1)+ tensor R_1(2)- : 12 240 0 E(120)^53+E(120)^77
R_4^0(3,5,[1,0]) tensor R_1(1)- tensor Xi_8 : 12 240 0 0
R_4^0(3,5,[1,0]) tensor R_1(1)- tensor Xi_4 : 12 240 0 0
R_4^0(1,5,[0,1])- tensor R_1(2)+ tensor R_1(1)- : 12 240 0 
E(120)^61+E(120)^109
R_4^0(1,5,[0,1])- tensor R_1(2)+ tensor R_1(2)- : 12 240 0 E(120)^13+E(120)^37
R_4^0(1,5,[2,1])+ tensor N_1([0,1]) tensor R_1(1)- : 12 240 0 E(40)^7+E(40)^23
R_4^0(1,5,[2,1])+ tensor N_1([0,1]) tensor R_1(2)- : 12 240 0 
E(40)^31+E(40)^39
R_4^0(1,5,[1,0]) tensor R_1(2)- tensor Xi_8 : 12 240 0 0
R_4^0(1,5,[1,0]) tensor R_1(2)- tensor Xi_4 : 12 240 0 0
R_4^0(1,5,[2,1])+ tensor R_1(1)+ tensor R_1(1)- : 12 240 0 
E(120)^29+E(120)^101
R_4^0(1,5,[1,0]) tensor R_1(1)- tensor Xi_8 : 12 240 0 0
R_4^0(1,5,[1,0]) tensor R_1(1)- tensor Xi_4 : 12 240 0 0
R_4^0(1,5,[2,1])+ tensor R_1(1)+ tensor R_1(2)- : 12 240 0 E(120)^53+E(120)^77
R_4^0(3,1,[1,1]) tensor R_1(2)- tensor Xi_8 : 12 240 0 0
R_4^0(3,1,[1,1]) tensor R_1(2)- tensor Xi_4 : 12 240 0 0
R_4^0(1,5,[2,1])+ tensor R_1(2)+ tensor R_1(1)- : 12 240 0 
E(120)^61+E(120)^109
R_4^0(3,1,[1,1]) tensor R_1(1)- tensor Xi_8 : 12 240 0 0
R_4^0(3,1,[1,1]) tensor R_1(1)- tensor Xi_4 : 12 240 0 0
R_4^0(1,5,[2,1])+ tensor R_1(2)+ tensor R_1(2)- : 12 240 0 E(120)^13+E(120)^37
R_4^0(1,5,[2,1])- tensor N_1([0,1]) tensor R_1(1)- : 12 240 0 
-E(40)^7-E(40)^23
R_4^0(1,1,[1,1]) tensor R_1(2)- tensor Xi_8 : 12 240 0 0
R_4^0(1,1,[1,1]) tensor R_1(2)- tensor Xi_4 : 12 240 0 0
R_4^0(1,5,[2,1])- tensor N_1([0,1]) tensor R_1(2)- : 12 240 0 
-E(40)^31-E(40)^39
R_4^0(1,1,[1,1]) tensor R_1(1)- tensor Xi_8 : 12 240 0 0
R_4^0(1,1,[1,1]) tensor R_1(1)- tensor Xi_4 : 12 240 0 0
R_4^0(1,5,[2,1])- tensor R_1(1)+ tensor R_1(1)- : 12 240 0 
-E(120)^29-E(120)^101
R_4^0(1,5,[2,1])- tensor R_1(1)+ tensor R_1(2)- : 12 240 0 
-E(120)^53-E(120)^77
R_4^0(1,5,[2,1])- tensor R_1(2)+ tensor R_1(1)- : 12 240 0 
-E(120)^61-E(120)^109
N_1([0,2]) tensor R_4^0(3,5,[2,1])+ tensor Xi_8 : 12 240 0 E(24)^19
N_1([0,2]) tensor R_4^0(3,5,[2,1])- tensor Xi_4 : 12 240 0 -E(24)^11
R_4^0(1,5,[2,1])- tensor R_1(2)+ tensor R_1(2)- : 12 240 0 
-E(120)^13-E(120)^37
R_4^0(3,5,[0,1])+ tensor N_1([0,1]) tensor R_1(1)- : 12 240 0 
-E(40)^13-E(40)^37
R_4^0(3,5,[0,1])+ tensor N_1([0,1]) tensor R_1(2)- : 12 240 0 
-E(40)^21-E(40)^29
R_4^0(3,5,[0,1])+ tensor R_1(1)+ tensor R_1(1)- : 12 240 0 
-E(120)^71-E(120)^119
R_4^0(3,5,[0,1])+ tensor R_1(1)+ tensor R_1(2)- : 12 240 0 
-E(120)^23-E(120)^47
R_4^0(3,5,[0,1])+ tensor R_1(2)+ tensor R_1(1)- : 12 240 0 
-E(120)^31-E(120)^79
R_4^0(3,5,[0,1])+ tensor R_1(2)+ tensor R_1(2)- : 12 240 0 
-E(120)^7-E(120)^103
R_4^0(3,5,[0,1])- tensor N_1([0,1]) tensor R_1(1)- : 12 240 0 
E(40)^13+E(40)^37
R_4^0(3,5,[0,1])- tensor R_1(1)+ tensor R_1(1)- : 12 240 0 
E(120)^71+E(120)^119
R_4^0(3,5,[0,1])- tensor N_1([0,1]) tensor R_1(2)- : 12 240 0 
E(40)^21+E(40)^29
R_4^0(1,3,[1,0])- tensor R_1(2)- tensor Xi_4 : 12 240 0 0
R_4^0(1,5,[0,1])+ tensor R_1(1)+ tensor R_1(1)- : 12 240 0 
-E(120)^29-E(120)^101
R_4^0(3,5,[0,1])- tensor R_1(2)+ tensor R_1(1)- : 12 240 0 E(120)^31+E(120)^79
R_4^0(1,3,[1,0])- tensor R_1(1)- tensor Xi_8 : 12 240 0 0
R_4^0(1,3,[1,0])- tensor R_1(1)- tensor Xi_4 : 12 240 0 0
R_4^0(1,5,[0,1])+ tensor R_1(1)+ tensor R_1(2)- : 12 240 0 
-E(120)^53-E(120)^77
R_4^0(3,5,[2,1])+ tensor R_1(1)+ tensor R_1(1)- : 12 240 0 
E(120)^71+E(120)^119
R_4^0(1,5,[0,1])+ tensor R_1(2)+ tensor R_1(1)- : 12 240 0 
-E(120)^61-E(120)^109
R_4^0(1,5,[0,1])+ tensor R_1(2)+ tensor R_1(2)- : 12 240 0 
-E(120)^13-E(120)^37
R_4^0(1,5,[0,1])- tensor N_1([0,1]) tensor R_1(1)- : 12 240 0 E(40)^7+E(40)^23
R_4^0(3,5,[2,1])- tensor N_1([0,1]) tensor R_1(1)- : 12 240 0 
-E(40)^13-E(40)^37
R_4^0(1,3,[1,0])+ tensor R_1(2)- tensor Xi_8 : 12 240 0 0
R_4^0(1,3,[1,0])+ tensor R_1(2)- tensor Xi_4 : 12 240 0 0
R_4^0(1,3,[1,0])+ tensor R_1(1)- tensor Xi_8 : 12 240 0 0
R_4^0(3,5,[2,1])- tensor R_1(2)+ tensor R_1(1)- : 12 240 0 
-E(120)^31-E(120)^79
R_4^0(1,3,[1,0])+ tensor R_1(1)- tensor Xi_4 : 12 240 0 0
R_4^0(3,1,[1,0])- tensor N_1([0,1]) tensor R_1(2)- : 12 240 0 
E(40)^31+E(40)^39
R_2^1(1,1,[1,0]) tensor R_1(3)- tensor Xi_3 : 12 252 0 E(84)+E(84)^25+E(84)^37
(R_2(1)+)_1 tensor R_1(1)- tensor Xi_3 : 12 252 0 E(28)^11+E(28)^15+E(28)^23
R_2^1(2,2,[1,1]) tensor R_1(3)- tensor Xi_9 : 12 252 0 
-E(84)-E(84)^25-E(84)^37
R_2^1(1,1,[1,1]) tensor R_1(3)- tensor Xi_3 : 12 252 0 E(84)+E(84)^25+E(84)^37
R_2^1(1,1,[1,1]) tensor R_1(1)- tensor Xi_9 : 12 252 0 -E(84)^13-E(84)^61
 -E(84)^73
R_2^1(1,2,[1,0]) tensor R_1(1)- tensor Xi_3 : 12 252 0 E(84)^5+E(84)^17
 +E(84)^41
R_2^1(1,2,[1,0]) tensor R_1(1)- tensor Xi_9 : 12 252 0 -E(84)^5-E(84)^17
 -E(84)^41
R_2^1(1,1,[1,1]) tensor R_1(1)- tensor Xi_3 : 12 252 0 E(84)^13+E(84)^61
 +E(84)^73
R_2^1(1,2,[1,0]) tensor R_1(3)- tensor Xi_3 : 12 252 0 E(84)^29+E(84)^53
 +E(84)^65
R_2^1(1,2,[1,0]) tensor R_1(3)- tensor Xi_9 : 12 252 0 -E(84)^29-E(84)^53
 -E(84)^65
R_2^1(1,1,[1,0]) tensor R_1(3)- tensor Xi_9 : 12 252 0 
-E(84)-E(84)^25-E(84)^37
(R_2(1)+)_1 tensor R_1(1)- tensor Xi_9 : 12 252 0 -E(28)^11-E(28)^15-E(28)^23
R_2^1(1,1,[1,0]) tensor R_1(1)- tensor Xi_9 : 12 252 0 -E(84)^13-E(84)^61
 -E(84)^73
R_2^1(1,1,[1,0]) tensor R_1(1)- tensor Xi_3 : 12 252 0 E(84)^13+E(84)^61
 +E(84)^73
(R_2(2)-)_1 tensor R_1(1)- tensor Xi_3 : 12 252 0 E(28)^11+E(28)^15+E(28)^23
(R_2(2)-)_1 tensor R_1(1)- tensor Xi_9 : 12 252 0 -E(28)^11-E(28)^15-E(28)^23
(R_2(2)+)_1 tensor R_1(3)- tensor Xi_9 : 12 252 0 -E(28)^3-E(28)^19-E(28)^27
R_2^1(2,2,[1,1]) tensor R_1(3)- tensor Xi_3 : 12 252 0 E(84)+E(84)^25+E(84)^37
R_2^1(2,2,[1,1]) tensor R_1(1)- tensor Xi_9 : 12 252 0 -E(84)^13-E(84)^61
 -E(84)^73
R_2^1(2,2,[1,1]) tensor R_1(1)- tensor Xi_3 : 12 252 0 E(84)^13+E(84)^61
 +E(84)^73
(R_2(2)+)_1 tensor R_1(3)- tensor Xi_3 : 12 252 0 E(28)^3+E(28)^19+E(28)^27
(R_2(2)-)_1 tensor R_1(3)- tensor Xi_3 : 12 252 0 E(28)^3+E(28)^19+E(28)^27
(R_2(2)-)_1 tensor R_1(3)- tensor Xi_9 : 12 252 0 -E(28)^3-E(28)^19-E(28)^27
(R_2(2)+)_1 tensor R_1(1)- tensor Xi_9 : 12 252 0 -E(28)^11-E(28)^15-E(28)^23
(R_2(2)+)_1 tensor R_1(1)- tensor Xi_3 : 12 252 0 E(28)^11+E(28)^15+E(28)^23
R_2^1(1,2,[1,1]) tensor R_1(1)- tensor Xi_3 : 12 252 0 E(84)^5+E(84)^17
 +E(84)^41
R_2^1(1,2,[1,1]) tensor R_1(1)- tensor Xi_9 : 12 252 0 -E(84)^5-E(84)^17
 -E(84)^41
R_2^1(1,2,[1,1]) tensor R_1(3)- tensor Xi_3 : 12 252 0 E(84)^29+E(84)^53
 +E(84)^65
R_2^1(2,2,[1,0]) tensor R_1(3)- tensor Xi_9 : 12 252 0 
-E(84)-E(84)^25-E(84)^37
R_2^1(2,2,[1,0]) tensor R_1(3)- tensor Xi_3 : 12 252 0 E(84)+E(84)^25+E(84)^37
R_2^1(1,2,[1,1]) tensor R_1(3)- tensor Xi_9 : 12 252 0 -E(84)^29-E(84)^53
 -E(84)^65
R_2^1(2,2,[1,0]) tensor R_1(1)- tensor Xi_9 : 12 252 0 -E(84)^13-E(84)^61
 -E(84)^73
(R_2(1)-)_1 tensor R_1(1)- tensor Xi_3 : 12 252 0 E(28)^11+E(28)^15+E(28)^23
(R_2(1)-)_1 tensor R_1(1)- tensor Xi_9 : 12 252 0 -E(28)^11-E(28)^15-E(28)^23
R_2^1(2,1,[1,1]) tensor R_1(3)- tensor Xi_3 : 12 252 0 E(84)^29+E(84)^53
 +E(84)^65
(R_2(1)+)_1 tensor R_1(3)- tensor Xi_9 : 12 252 0 -E(28)^3-E(28)^19-E(28)^27
(R_2(1)-)_1 tensor R_1(3)- tensor Xi_3 : 12 252 0 E(28)^3+E(28)^19+E(28)^27
(R_2(1)-)_1 tensor R_1(3)- tensor Xi_9 : 12 252 0 -E(28)^3-E(28)^19-E(28)^27
(R_2(1)+)_1 tensor R_1(3)- tensor Xi_3 : 12 252 0 E(28)^3+E(28)^19+E(28)^27
R_2^1(2,1,[1,0]) tensor R_1(1)- tensor Xi_3 : 12 252 0 E(84)^5+E(84)^17
 +E(84)^41
R_2^1(2,1,[1,0]) tensor R_1(1)- tensor Xi_9 : 12 252 0 -E(84)^5-E(84)^17
 -E(84)^41
R_2^1(2,1,[1,0]) tensor R_1(3)- tensor Xi_3 : 12 252 0 E(84)^29+E(84)^53
 +E(84)^65
R_2^1(2,1,[1,0]) tensor R_1(3)- tensor Xi_9 : 12 252 0 -E(84)^29-E(84)^53
 -E(84)^65
R_2^1(2,1,[1,1]) tensor R_1(1)- tensor Xi_3 : 12 252 0 E(84)^5+E(84)^17
 +E(84)^41
R_2^1(2,1,[1,1]) tensor R_1(1)- tensor Xi_9 : 12 252 0 -E(84)^5-E(84)^17
 -E(84)^41
R_2^1(2,2,[1,0]) tensor R_1(1)- tensor Xi_3 : 12 252 0 E(84)^13+E(84)^61
 +E(84)^73
R_2^1(2,1,[1,1]) tensor R_1(3)- tensor Xi_9 : 12 252 0 -E(84)^29-E(84)^53
 -E(84)^65
R_2^1(1,1,[1,1]) tensor R_1(3)- tensor Xi_9 : 12 252 0 
-E(84)-E(84)^25-E(84)^37
R_1(1)- tensor R_1(2)- tensor Xi_9 : 12 260 0 -E(260)^21-E(260)^41-E(260)^89
 -E(260)^109-E(260)^141-E(260)^149-E(260)^161-E(260)^189-E(260)^201-E(260)^229
 -E(260)^241-E(260)^249
R_1(1)- tensor R_1(2)- tensor Xi_3 : 12 260 0 E(260)^21+E(260)^41+E(260)^89
 +E(260)^109+E(260)^141+E(260)^149+E(260)^161+E(260)^189+E(260)^201+E(260)^229
 +E(260)^241+E(260)^249
R_1(2)- tensor R_1(1)- tensor Xi_3 : 12 260 0 E(260)^17+E(260)^53+E(260)^77
 +E(260)^113+E(260)^133+E(260)^153+E(260)^157+E(260)^173+E(260)^217+E(260)^233
 +E(260)^237+E(260)^257
R_1(2)- tensor R_1(1)- tensor Xi_9 : 12 260 0 -E(260)^17-E(260)^53-E(260)^77
 -E(260)^113-E(260)^133-E(260)^153-E(260)^157-E(260)^173-E(260)^217-E(260)^233
 -E(260)^237-E(260)^257
R_1(2)- tensor R_1(2)- tensor Xi_3 : 12 260 0 E(260)+E(260)^9+E(260)^29
 +E(260)^49+E(260)^61+E(260)^69+E(260)^81+E(260)^101+E(260)^121+E(260)^129
 +E(260)^181+E(260)^209
R_1(2)- tensor R_1(2)- tensor Xi_9 : 12 260 0 -E(260)-E(260)^9-E(260)^29
 -E(260)^49-E(260)^61-E(260)^69-E(260)^81-E(260)^101-E(260)^121-E(260)^129
 -E(260)^181-E(260)^209
R_1(1)- tensor R_1(1)- tensor Xi_9 : 12 260 0 -E(260)^33-E(260)^37-E(260)^57
 -E(260)^73-E(260)^93-E(260)^97-E(260)^137-E(260)^177-E(260)^193-E(260)^197
 -E(260)^213-E(260)^253
R_1(1)- tensor R_1(1)- tensor Xi_3 : 12 260 0 E(260)^33+E(260)^37+E(260)^57
 +E(260)^73+E(260)^93+E(260)^97+E(260)^137+E(260)^177+E(260)^193+E(260)^197
 +E(260)^213+E(260)^253
R_1(1)+ tensor N_3([1,3])+ tensor Xi_8 : 12 264 0 E(264)^59-E(264)^89
 -E(264)^113-E(264)^137+E(264)^155+E(264)^179-E(264)^185+E(264)^203+E(264)^251
 -E(264)^257
R_1(1)+ tensor N_3([1,3])- tensor Xi_4 : 12 264 0 E(264)+E(264)^25+E(264)^49
 -E(264)^67-E(264)^91+E(264)^97-E(264)^115-E(264)^163+E(264)^169-E(264)^235
R_1(1)+ tensor N_3([1,3])- tensor Xi_8 : 12 264 0 -E(264)^59+E(264)^89
 +E(264)^113+E(264)^137-E(264)^155-E(264)^179+E(264)^185-E(264)^203-E(264)^251
 +E(264)^257
R_1(2)+ tensor N_3([1,0])+ tensor Xi_4 : 12 264 0 -E(264)^19-E(264)^43
 -E(264)^73-E(264)^139-E(264)^145-E(264)^193-E(264)^211-E(264)^217-E(264)^241
 -E(264)^259
R_1(2)+ tensor N_3([1,0])+ tensor Xi_8 : 12 264 0 -E(264)^17-E(264)^35
 -E(264)^41-E(264)^65-E(264)^83-E(264)^107-E(264)^131-E(264)^161-E(264)^227
 -E(264)^233
R_1(1)+ tensor N_3([1,0])+ tensor Xi_4 : 12 264 0 -E(264)-E(264)^25-E(264)^49
 -E(264)^67-E(264)^91-E(264)^97-E(264)^115-E(264)^163-E(264)^169-E(264)^235
R_1(2)+ tensor N_3([1,3])- tensor Xi_8 : 12 264 0 E(264)^17-E(264)^35
 +E(264)^41+E(264)^65-E(264)^83-E(264)^107-E(264)^131+E(264)^161-E(264)^227
 +E(264)^233
R_1(2)+ tensor N_3([1,3])- tensor Xi_4 : 12 264 0 -E(264)^19-E(264)^43
 +E(264)^73-E(264)^139+E(264)^145+E(264)^193-E(264)^211+E(264)^217+E(264)^241
 -E(264)^259
R_1(2)+ tensor N_3([1,3])+ tensor Xi_8 : 12 264 0 -E(264)^17+E(264)^35
 -E(264)^41-E(264)^65+E(264)^83+E(264)^107+E(264)^131-E(264)^161+E(264)^227
 -E(264)^233
R_1(2)+ tensor N_3([1,3])+ tensor Xi_4 : 12 264 0 E(264)^19+E(264)^43
 -E(264)^73+E(264)^139-E(264)^145-E(264)^193+E(264)^211-E(264)^217-E(264)^241
 +E(264)^259
R_1(1)+ tensor N_3([1,0])+ tensor Xi_8 : 12 264 0 -E(264)^59-E(264)^89
 -E(264)^113-E(264)^137-E(264)^155-E(264)^179-E(264)^185-E(264)^203-E(264)^251
 -E(264)^257
R_1(1)+ tensor N_3([1,0])- tensor Xi_4 : 12 264 0 E(264)+E(264)^25+E(264)^49
 +E(264)^67+E(264)^91+E(264)^97+E(264)^115+E(264)^163+E(264)^169+E(264)^235
R_1(1)+ tensor N_3([1,0])- tensor Xi_8 : 12 264 0 E(264)^59+E(264)^89
 +E(264)^113+E(264)^137+E(264)^155+E(264)^179+E(264)^185+E(264)^203+E(264)^251
 +E(264)^257
R_1(2)+ tensor N_3([1,0])- tensor Xi_4 : 12 264 0 E(264)^19+E(264)^43
 +E(264)^73+E(264)^139+E(264)^145+E(264)^193+E(264)^211+E(264)^217+E(264)^241
 +E(264)^259
R_1(2)+ tensor N_3([1,0])- tensor Xi_8 : 12 264 0 E(264)^17+E(264)^35
 +E(264)^41+E(264)^65+E(264)^83+E(264)^107+E(264)^131+E(264)^161+E(264)^227
 +E(264)^233
R_1(1)+ tensor N_3([1,3])+ tensor Xi_4 : 12 264 0 -E(264)-E(264)^25-E(264)^49
 +E(264)^67+E(264)^91-E(264)^97+E(264)^115+E(264)^163-E(264)^169+E(264)^235
R_1(1)+ tensor Xi_1 : 12 276 0 E(276)^5+E(276)^17+E(276)^53+E(276)^65
 +E(276)^89+E(276)^113+E(276)^125+E(276)^137+E(276)^149+E(276)^221+E(276)^245
R_1(5)+ tensor Xi_11 : 12 276 0 -E(276)-E(276)^13-E(276)^25-E(276)^49
 -E(276)^73-E(276)^85-E(276)^121-E(276)^133-E(276)^169-E(276)^193-E(276)^265
R_1(5)+ tensor Xi_7 : 12 276 0 -E(276)^29-E(276)^41-E(276)^77-E(276)^101
 -E(276)^173-E(276)^185-E(276)^197-E(276)^209-E(276)^233-E(276)^257-E(276)^269
R_1(5)+ tensor Xi_5 : 12 276 0 E(276)+E(276)^13+E(276)^25+E(276)^49+E(276)^73
 +E(276)^85+E(276)^121+E(276)^133+E(276)^169+E(276)^193+E(276)^265
R_1(5)+ tensor Xi_1 : 12 276 0 E(276)^29+E(276)^41+E(276)^77+E(276)^101
 +E(276)^173+E(276)^185+E(276)^197+E(276)^209+E(276)^233+E(276)^257+E(276)^269
R_1(1)+ tensor Xi_11 : 12 276 0 -E(276)^37-E(276)^61-E(276)^97-E(276)^109
 -E(276)^145-E(276)^157-E(276)^181-E(276)^205-E(276)^217-E(276)^229-E(276)^241
R_1(1)+ tensor Xi_7 : 12 276 0 -E(276)^5-E(276)^17-E(276)^53-E(276)^65
 -E(276)^89-E(276)^113-E(276)^125-E(276)^137-E(276)^149-E(276)^221-E(276)^245
R_1(1)+ tensor Xi_5 : 12 276 0 E(276)^37+E(276)^61+E(276)^97+E(276)^109
 +E(276)^145+E(276)^157+E(276)^181+E(276)^205+E(276)^217+E(276)^229+E(276)^241
R_1(1)- tensor R_1(2)- tensor N_3([1,0])+ : 12 280 0 E(280)^3+E(280)^17
 +E(280)^27+E(280)^33+E(280)^73+E(280)^83+E(280)^97+E(280)^153+E(280)^187
 +E(280)^227+E(280)^243+E(280)^257
R_1(1)- tensor R_1(1)- tensor N_3([1,3])+ : 12 280 0 E(280)^19-E(280)^41
 +E(280)^59-E(280)^89-E(280)^129+E(280)^131+E(280)^139+E(280)^171-E(280)^201
 -E(280)^209-E(280)^241+E(280)^251
R_1(1)- tensor R_1(1)- tensor N_3([1,0])- : 12 280 0 -E(280)^19-E(280)^41
 -E(280)^59-E(280)^89-E(280)^129-E(280)^131-E(280)^139-E(280)^171-E(280)^201
 -E(280)^209-E(280)^241-E(280)^251
R_1(1)- tensor R_1(1)- tensor N_3([1,0])+ : 12 280 0 E(280)^19+E(280)^41
 +E(280)^59+E(280)^89+E(280)^129+E(280)^131+E(280)^139+E(280)^171+E(280)^201
 +E(280)^209+E(280)^241+E(280)^251
R_1(3)- tensor R_1(2)- tensor N_3([1,3])- : 12 280 0 -E(280)^43+E(280)^57
 -E(280)^67-E(280)^107+E(280)^113-E(280)^123+E(280)^137-E(280)^163+E(280)^177
 +E(280)^193+E(280)^233-E(280)^267
R_1(3)- tensor R_1(2)- tensor N_3([1,3])+ : 12 280 0 E(280)^43-E(280)^57
 +E(280)^67+E(280)^107-E(280)^113+E(280)^123-E(280)^137+E(280)^163-E(280)^177
 -E(280)^193-E(280)^233+E(280)^267
R_1(3)- tensor R_1(2)- tensor N_3([1,0])- : 12 280 0 -E(280)^43-E(280)^57
 -E(280)^67-E(280)^107-E(280)^113-E(280)^123-E(280)^137-E(280)^163-E(280)^177
 -E(280)^193-E(280)^233-E(280)^267
R_1(3)- tensor R_1(2)- tensor N_3([1,0])+ : 12 280 0 E(280)^43+E(280)^57
 +E(280)^67+E(280)^107+E(280)^113+E(280)^123+E(280)^137+E(280)^163+E(280)^177
 +E(280)^193+E(280)^233+E(280)^267
R_1(3)- tensor R_1(1)- tensor N_3([1,3])- : 12 280 0 E(280)+E(280)^9-E(280)^11
 -E(280)^51+E(280)^81-E(280)^99+E(280)^121+E(280)^169-E(280)^179-E(280)^211
 -E(280)^219+E(280)^249
R_1(3)- tensor R_1(1)- tensor N_3([1,3])+ : 12 280 0 -E(280)-E(280)^9
 +E(280)^11+E(280)^51-E(280)^81+E(280)^99-E(280)^121-E(280)^169+E(280)^179
 +E(280)^211+E(280)^219-E(280)^249
R_1(3)- tensor R_1(1)- tensor N_3([1,0])- : 12 280 0 -E(280)-E(280)^9
 -E(280)^11-E(280)^51-E(280)^81-E(280)^99-E(280)^121-E(280)^169-E(280)^179
 -E(280)^211-E(280)^219-E(280)^249
R_1(3)- tensor R_1(1)- tensor N_3([1,0])+ : 12 280 0 E(280)+E(280)^9+E(280)^11
 +E(280)^51+E(280)^81+E(280)^99+E(280)^121+E(280)^169+E(280)^179+E(280)^211
 +E(280)^219+E(280)^249
R_1(1)- tensor R_1(2)- tensor N_3([1,3])- : 12 280 0 -E(280)^3+E(280)^17
 -E(280)^27+E(280)^33+E(280)^73-E(280)^83+E(280)^97+E(280)^153-E(280)^187
 -E(280)^227-E(280)^243+E(280)^257
R_1(1)- tensor R_1(2)- tensor N_3([1,3])+ : 12 280 0 E(280)^3-E(280)^17
 +E(280)^27-E(280)^33-E(280)^73+E(280)^83-E(280)^97-E(280)^153+E(280)^187
 +E(280)^227+E(280)^243-E(280)^257
R_1(1)- tensor R_1(2)- tensor N_3([1,0])- : 12 280 0 -E(280)^3-E(280)^17
 -E(280)^27-E(280)^33-E(280)^73-E(280)^83-E(280)^97-E(280)^153-E(280)^187
 -E(280)^227-E(280)^243-E(280)^257
R_1(1)- tensor R_1(1)- tensor N_3([1,3])- : 12 280 0 -E(280)^19+E(280)^41
 -E(280)^59+E(280)^89+E(280)^129-E(280)^131-E(280)^139-E(280)^171+E(280)^201
 +E(280)^209+E(280)^241-E(280)^251
(R_2(2)+)_1 tensor Xi_11 : 12 300 0 2*E(12)^11
R_2^1(2,2,[2,1]) tensor Xi_7 : 12 300 0 E(60)^23+E(60)^47
R_2^1(2,2,[2,1]) tensor Xi_11 : 12 300 0 E(60)^7+E(60)^43
(R_2(1)+)_1 tensor Xi_1 : 12 300 0 -2*E(12)^7
(R_2(1)+)_1 tensor Xi_5 : 12 300 0 -2*E(12)^11
R_2^1(2,2,[2,0]) tensor Xi_11 : 12 300 0 E(60)^7+E(60)^43
R_2^1(2,2,[2,0]) tensor Xi_7 : 12 300 0 E(60)^23+E(60)^47
R_2^1(1,1,[1,0]) tensor Xi_1 : 12 300 0 -E(60)^23-E(60)^47
(R_2(1)+)_1 tensor Xi_7 : 12 300 0 2*E(12)^7
R_2^1(2,2,[2,0]) tensor Xi_5 : 12 300 0 -E(60)^7-E(60)^43
R_2^1(2,2,[2,0]) tensor Xi_1 : 12 300 0 -E(60)^23-E(60)^47
(R_2(1)+)_1 tensor Xi_11 : 12 300 0 2*E(12)^11
(R_2(1)-)_1 tensor Xi_1 : 12 300 0 -2*E(12)^7
(R_2(1)-)_1 tensor Xi_5 : 12 300 0 -2*E(12)^11
(R_2(1)-)_1 tensor Xi_7 : 12 300 0 2*E(12)^7
(R_2(1)-)_1 tensor Xi_11 : 12 300 0 2*E(12)^11
(R_2(2)+)_1 tensor Xi_1 : 12 300 0 -2*E(12)^7
(R_2(2)+)_1 tensor Xi_5 : 12 300 0 -2*E(12)^11
(R_2(2)+)_1 tensor Xi_7 : 12 300 0 2*E(12)^7
R_2^1(2,2,[2,1]) tensor Xi_5 : 12 300 0 -E(60)^7-E(60)^43
R_2^1(2,2,[1,1]) tensor Xi_11 : 12 300 0 E(60)^7+E(60)^43
R_2^1(2,2,[1,1]) tensor Xi_7 : 12 300 0 E(60)^23+E(60)^47
R_2^1(2,2,[1,1]) tensor Xi_5 : 12 300 0 -E(60)^7-E(60)^43
R_2^1(2,2,[1,1]) tensor Xi_1 : 12 300 0 -E(60)^23-E(60)^47
R_2^1(2,2,[1,0]) tensor Xi_11 : 12 300 0 E(60)^7+E(60)^43
R_2^1(2,2,[1,0]) tensor Xi_7 : 12 300 0 E(60)^23+E(60)^47
(R_2(2)-)_1 tensor Xi_1 : 12 300 0 -2*E(12)^7
(R_2(2)-)_1 tensor Xi_5 : 12 300 0 -2*E(12)^11
R_2^1(2,2,[1,0]) tensor Xi_5 : 12 300 0 -E(60)^7-E(60)^43
R_2^1(2,2,[1,0]) tensor Xi_1 : 12 300 0 -E(60)^23-E(60)^47
R_2^1(2,1,[2,0]) tensor Xi_5 : 12 300 0 -E(60)^19-E(60)^31
R_2^1(1,1,[1,0]) tensor Xi_5 : 12 300 0 -E(60)^7-E(60)^43
R_2^1(2,1,[2,1]) tensor Xi_11 : 12 300 0 E(60)^19+E(60)^31
R_2^1(1,1,[1,0]) tensor Xi_7 : 12 300 0 E(60)^23+E(60)^47
R_2^1(1,1,[1,0]) tensor Xi_11 : 12 300 0 E(60)^7+E(60)^43
R_2^1(1,1,[1,1]) tensor Xi_1 : 12 300 0 -E(60)^23-E(60)^47
R_2^1(1,1,[1,1]) tensor Xi_5 : 12 300 0 -E(60)^7-E(60)^43
R_2^1(1,1,[1,1]) tensor Xi_7 : 12 300 0 E(60)^23+E(60)^47
R_2^1(1,1,[1,1]) tensor Xi_11 : 12 300 0 E(60)^7+E(60)^43
R_2^1(1,1,[2,0]) tensor Xi_1 : 12 300 0 -E(60)^23-E(60)^47
R_2^1(2,2,[2,1]) tensor Xi_1 : 12 300 0 -E(60)^23-E(60)^47
R_2^1(1,1,[2,0]) tensor Xi_5 : 12 300 0 -E(60)^7-E(60)^43
R_2^1(1,1,[2,0]) tensor Xi_7 : 12 300 0 E(60)^23+E(60)^47
R_2^1(1,1,[2,0]) tensor Xi_11 : 12 300 0 E(60)^7+E(60)^43
R_2^1(1,1,[2,1]) tensor Xi_1 : 12 300 0 -E(60)^23-E(60)^47
R_2^1(1,1,[2,1]) tensor Xi_5 : 12 300 0 -E(60)^7-E(60)^43
R_2^1(1,1,[2,1]) tensor Xi_7 : 12 300 0 E(60)^23+E(60)^47
R_2^1(1,1,[2,1]) tensor Xi_11 : 12 300 0 E(60)^7+E(60)^43
R_2^1(1,2,[1,0]) tensor Xi_1 : 12 300 0 -E(60)^11-E(60)^59
R_2^1(1,2,[1,0]) tensor Xi_5 : 12 300 0 -E(60)^19-E(60)^31
R_2^1(1,2,[1,0]) tensor Xi_7 : 12 300 0 E(60)^11+E(60)^59
R_2^1(1,2,[1,0]) tensor Xi_11 : 12 300 0 E(60)^19+E(60)^31
R_2^1(1,2,[1,1]) tensor Xi_1 : 12 300 0 -E(60)^11-E(60)^59
R_2^1(1,2,[1,1]) tensor Xi_5 : 12 300 0 -E(60)^19-E(60)^31
R_2^1(1,2,[1,1]) tensor Xi_7 : 12 300 0 E(60)^11+E(60)^59
R_2^1(1,2,[1,1]) tensor Xi_11 : 12 300 0 E(60)^19+E(60)^31
R_2^1(1,2,[2,0]) tensor Xi_1 : 12 300 0 -E(60)^11-E(60)^59
R_2^1(1,2,[2,0]) tensor Xi_5 : 12 300 0 -E(60)^19-E(60)^31
R_2^1(1,2,[2,0]) tensor Xi_7 : 12 300 0 E(60)^11+E(60)^59
R_2^1(2,1,[2,1]) tensor Xi_7 : 12 300 0 E(60)^11+E(60)^59
R_2^1(1,2,[2,1]) tensor Xi_1 : 12 300 0 -E(60)^11-E(60)^59
(R_2(2)-)_1 tensor Xi_7 : 12 300 0 2*E(12)^7
(R_2(2)-)_1 tensor Xi_11 : 12 300 0 2*E(12)^11
R_2^1(2,1,[2,0]) tensor Xi_1 : 12 300 0 -E(60)^11-E(60)^59
R_2^1(1,2,[2,1]) tensor Xi_7 : 12 300 0 E(60)^11+E(60)^59
R_2^1(1,2,[2,1]) tensor Xi_11 : 12 300 0 E(60)^19+E(60)^31
R_2^1(2,1,[1,0]) tensor Xi_1 : 12 300 0 -E(60)^11-E(60)^59
R_2^1(2,1,[1,0]) tensor Xi_5 : 12 300 0 -E(60)^19-E(60)^31
R_2^1(2,1,[1,0]) tensor Xi_7 : 12 300 0 E(60)^11+E(60)^59
R_2^1(2,1,[1,0]) tensor Xi_11 : 12 300 0 E(60)^19+E(60)^31
R_2^1(2,1,[1,1]) tensor Xi_1 : 12 300 0 -E(60)^11-E(60)^59
R_2^1(2,1,[1,1]) tensor Xi_5 : 12 300 0 -E(60)^19-E(60)^31
R_2^1(2,1,[1,1]) tensor Xi_7 : 12 300 0 E(60)^11+E(60)^59
R_2^1(2,1,[1,1]) tensor Xi_11 : 12 300 0 E(60)^19+E(60)^31
R_2^1(2,1,[2,0]) tensor Xi_7 : 12 300 0 E(60)^11+E(60)^59
R_2^1(2,1,[2,0]) tensor Xi_11 : 12 300 0 E(60)^19+E(60)^31
R_2^1(2,1,[2,1]) tensor Xi_1 : 12 300 0 -E(60)^11-E(60)^59
R_2^1(2,1,[2,1]) tensor Xi_5 : 12 300 0 -E(60)^19-E(60)^31
R_2^1(1,2,[2,0]) tensor Xi_11 : 12 300 0 E(60)^19+E(60)^31
R_2^1(1,2,[2,1]) tensor Xi_5 : 12 300 0 -E(60)^19-E(60)^31
R_1(2)- tensor N_3([1,3])- tensor Xi_4 : 12 312 0 -E(312)^23+E(312)^29
 +E(312)^53+E(312)^77-E(312)^95+E(312)^101+E(312)^173-E(312)^191-E(312)^263
 +E(312)^269-E(312)^287-E(312)^311
R_1(1)- tensor N_3([1,0])+ tensor Xi_4 : 12 312 0 E(312)^5+E(312)^47+E(312)^71
 +E(312)^119+E(312)^125+E(312)^149+E(312)^167+E(312)^197+E(312)^215+E(312)^239
 +E(312)^245+E(312)^293
R_1(2)- tensor N_3([1,3])- tensor Xi_8 : 12 312 0 -E(312)^55+E(312)^61
 -E(312)^79-E(312)^103-E(312)^127+E(312)^133+E(312)^157+E(312)^181-E(312)^199
 +E(312)^205+E(312)^277-E(312)^295
R_1(1)- tensor N_3([1,0])- tensor Xi_4 : 12 312 0 -E(312)^5-E(312)^47
 -E(312)^71-E(312)^119-E(312)^125-E(312)^149-E(312)^167-E(312)^197-E(312)^215
 -E(312)^239-E(312)^245-E(312)^293
R_1(1)- tensor N_3([1,0])- tensor Xi_8 : 12 312 0 -E(312)^7-E(312)^31
 -E(312)^37-E(312)^85-E(312)^109-E(312)^151-E(312)^175-E(312)^223-E(312)^229
 -E(312)^253-E(312)^271-E(312)^301
R_1(1)- tensor N_3([1,3])+ tensor Xi_4 : 12 312 0 -E(312)^5+E(312)^47
 +E(312)^71+E(312)^119-E(312)^125-E(312)^149+E(312)^167-E(312)^197+E(312)^215
 +E(312)^239-E(312)^245-E(312)^293
R_1(2)- tensor N_3([1,3])+ tensor Xi_8 : 12 312 0 E(312)^55-E(312)^61
 +E(312)^79+E(312)^103+E(312)^127-E(312)^133-E(312)^157-E(312)^181+E(312)^199
 -E(312)^205-E(312)^277+E(312)^295
R_1(2)- tensor N_3([1,3])+ tensor Xi_4 : 12 312 0 E(312)^23-E(312)^29
 -E(312)^53-E(312)^77+E(312)^95-E(312)^101-E(312)^173+E(312)^191+E(312)^263
 -E(312)^269+E(312)^287+E(312)^311
R_1(1)- tensor N_3([1,3])+ tensor Xi_8 : 12 312 0 E(312)^7+E(312)^31-E(312)^37
 -E(312)^85-E(312)^109+E(312)^151+E(312)^175+E(312)^223-E(312)^229-E(312)^253
 +E(312)^271-E(312)^301
R_1(1)- tensor N_3([1,3])- tensor Xi_4 : 12 312 0 E(312)^5-E(312)^47-E(312)^71
 -E(312)^119+E(312)^125+E(312)^149-E(312)^167+E(312)^197-E(312)^215-E(312)^239
 +E(312)^245+E(312)^293
R_1(1)- tensor N_3([1,3])- tensor Xi_8 : 12 312 0 -E(312)^7-E(312)^31
 +E(312)^37+E(312)^85+E(312)^109-E(312)^151-E(312)^175-E(312)^223+E(312)^229
 +E(312)^253-E(312)^271+E(312)^301
R_1(2)- tensor N_3([1,0])- tensor Xi_8 : 12 312 0 -E(312)^55-E(312)^61
 -E(312)^79-E(312)^103-E(312)^127-E(312)^133-E(312)^157-E(312)^181-E(312)^199
 -E(312)^205-E(312)^277-E(312)^295
R_1(2)- tensor N_3([1,0])- tensor Xi_4 : 12 312 0 -E(312)^23-E(312)^29
 -E(312)^53-E(312)^77-E(312)^95-E(312)^101-E(312)^173-E(312)^191-E(312)^263
 -E(312)^269-E(312)^287-E(312)^311
R_1(2)- tensor N_3([1,0])+ tensor Xi_8 : 12 312 0 E(312)^55+E(312)^61
 +E(312)^79+E(312)^103+E(312)^127+E(312)^133+E(312)^157+E(312)^181+E(312)^199
 +E(312)^205+E(312)^277+E(312)^295
R_1(2)- tensor N_3([1,0])+ tensor Xi_4 : 12 312 0 E(312)^23+E(312)^29
 +E(312)^53+E(312)^77+E(312)^95+E(312)^101+E(312)^173+E(312)^191+E(312)^263
 +E(312)^269+E(312)^287+E(312)^311
R_1(1)- tensor N_3([1,0])+ tensor Xi_8 : 12 312 0 E(312)^7+E(312)^31+E(312)^37
 +E(312)^85+E(312)^109+E(312)^151+E(312)^175+E(312)^223+E(312)^229+E(312)^253
 +E(312)^271+E(312)^301
R_1(2)+ tensor R_1(2)- tensor Xi_10 : 12 330 0 E(165)+E(165)^4+E(165)^16
 +E(165)^31+E(165)^34+E(165)^49+E(165)^64+E(165)^91+E(165)^124+E(165)^136
R_1(1)+ tensor R_1(1)- tensor Xi_2 : 12 330 0 E(165)^2+E(165)^8+E(165)^17
 +E(165)^32+E(165)^62+E(165)^68+E(165)^83+E(165)^98+E(165)^107+E(165)^128
R_1(1)+ tensor R_1(1)- tensor Xi_10 : 12 330 0 E(165)^7+E(165)^13+E(165)^28
 +E(165)^43+E(165)^52+E(165)^73+E(165)^112+E(165)^118+E(165)^127+E(165)^142
R_1(1)+ tensor R_1(2)- tensor Xi_2 : 12 330 0 E(165)^29+E(165)^41+E(165)^74
 +E(165)^101+E(165)^116+E(165)^131+E(165)^134+E(165)^149+E(165)^161+E(165)^164
R_1(1)+ tensor R_1(2)- tensor Xi_10 : 12 330 0 E(165)^19+E(165)^46+E(165)^61
 +E(165)^76+E(165)^79+E(165)^94+E(165)^106+E(165)^109+E(165)^139+E(165)^151
R_1(2)+ tensor R_1(1)- tensor Xi_10 : 12 330 0 E(165)^37+E(165)^58+E(165)^67
 +E(165)^82+E(165)^97+E(165)^103+E(165)^133+E(165)^148+E(165)^157+E(165)^163
R_1(2)+ tensor R_1(2)- tensor Xi_2 : 12 330 0 E(165)^14+E(165)^26+E(165)^56
 +E(165)^59+E(165)^71+E(165)^86+E(165)^89+E(165)^104+E(165)^119+E(165)^146
R_1(2)+ tensor R_1(1)- tensor Xi_2 : 12 330 0 E(165)^23+E(165)^38+E(165)^47
 +E(165)^53+E(165)^92+E(165)^113+E(165)^122+E(165)^137+E(165)^152+E(165)^158
R_1(1)+ tensor R_4^0(1,5,[0,1])+ tensor Xi_8 : 12 336 0 -E(168)^79-E(168)^127
 -E(168)^151
R_1(1)+ tensor R_4^0(1,1,[1,0])- tensor Xi_4 : 12 336 0 E(168)^29+E(168)^53
 +E(168)^149
R_1(1)+ tensor R_4^0(1,1,[1,0])+ tensor Xi_8 : 12 336 0 -E(168)^37-E(168)^85
 -E(168)^109
R_1(1)+ tensor R_4^0(1,1,[1,0])+ tensor Xi_4 : 12 336 0 -E(168)^29-E(168)^53
 -E(168)^149
R_1(1)+ tensor R_4^0(3,1,[1,0])+ tensor Xi_8 : 12 336 0 -E(168)^79-E(168)^127
 -E(168)^151
R_1(1)+ tensor R_4^0(3,1,[1,0])- tensor Xi_4 : 12 336 0 E(168)^23+E(168)^71
 +E(168)^95
R_1(1)+ tensor R_4^0(3,1,[1,0])- tensor Xi_8 : 12 336 0 E(168)^79+E(168)^127
 +E(168)^151
R_1(1)+ tensor R_4^0(3,1,[1,2])+ tensor Xi_8 : 12 336 0 E(168)^79+E(168)^127
 +E(168)^151
R_1(1)+ tensor R_4^0(1,1,[1,2])- tensor Xi_8 : 12 336 0 -E(168)^37-E(168)^85
 -E(168)^109
R_1(1)+ tensor R_4^0(3,1,[1,2])- tensor Xi_4 : 12 336 0 -E(168)^23-E(168)^71
 -E(168)^95
R_1(1)+ tensor R_4^0(3,1,[1,2])- tensor Xi_8 : 12 336 0 -E(168)^79-E(168)^127
 -E(168)^151
R_1(1)+ tensor R_4^0(1,5,[0,1])+ tensor Xi_4 : 12 336 0 -E(168)^23-E(168)^71
 -E(168)^95
R_1(1)+ tensor R_4^0(3,5,[2,1])- tensor Xi_8 : 12 336 0 -E(168)^37-E(168)^85
 -E(168)^109
R_1(1)+ tensor R_4^0(1,5,[0,1])- tensor Xi_4 : 12 336 0 E(168)^23+E(168)^71
 +E(168)^95
R_1(1)+ tensor R_4^0(1,5,[0,1])- tensor Xi_8 : 12 336 0 E(168)^79+E(168)^127
 +E(168)^151
R_1(1)+ tensor R_4^0(1,5,[2,1])+ tensor Xi_4 : 12 336 0 E(168)^23+E(168)^71
 +E(168)^95
R_1(1)+ tensor R_4^0(3,5,[2,1])+ tensor Xi_4 : 12 336 0 E(168)^29+E(168)^53
 +E(168)^149
R_1(1)+ tensor R_4^0(1,5,[2,1])- tensor Xi_8 : 12 336 0 -E(168)^79-E(168)^127
 -E(168)^151
R_1(1)+ tensor R_4^0(1,5,[2,1])+ tensor Xi_8 : 12 336 0 E(168)^79+E(168)^127
 +E(168)^151
R_1(1)+ tensor R_4^0(3,5,[2,1])- tensor Xi_4 : 12 336 0 -E(168)^29-E(168)^53
 -E(168)^149
R_1(3)+ tensor R_4^0(1,1,[1,0])+ tensor Xi_4 : 12 336 0 -E(168)^5-E(168)^101
 -E(168)^125
R_1(3)+ tensor R_4^0(1,1,[1,0])+ tensor Xi_8 : 12 336 0 -E(168)^13-E(168)^61
 -E(168)^157
R_1(3)+ tensor R_4^0(1,1,[1,0])- tensor Xi_4 : 12 336 0 E(168)^5+E(168)^101
 +E(168)^125
R_1(3)+ tensor R_4^0(1,1,[1,0])- tensor Xi_8 : 12 336 0 E(168)^13+E(168)^61
 +E(168)^157
R_1(3)+ tensor R_4^0(1,1,[1,2])+ tensor Xi_4 : 12 336 0 E(168)^5+E(168)^101
 +E(168)^125
R_1(3)+ tensor R_4^0(1,1,[1,2])+ tensor Xi_8 : 12 336 0 E(168)^13+E(168)^61
 +E(168)^157
R_1(3)+ tensor R_4^0(1,1,[1,2])- tensor Xi_4 : 12 336 0 -E(168)^5-E(168)^101
 -E(168)^125
R_1(3)+ tensor R_4^0(3,1,[1,0])+ tensor Xi_4 : 12 336 0 -E(168)^47-E(168)^143
 -E(168)^167
R_1(3)+ tensor R_4^0(3,1,[1,0])+ tensor Xi_8 : 12 336 0 -E(168)^31-E(168)^55
 -E(168)^103
R_1(1)+ tensor R_4^0(3,5,[2,1])+ tensor Xi_8 : 12 336 0 E(168)^37+E(168)^85
 +E(168)^109
R_1(3)+ tensor R_4^0(3,1,[1,0])- tensor Xi_4 : 12 336 0 E(168)^47+E(168)^143
 +E(168)^167
R_1(3)+ tensor R_4^0(3,1,[1,0])- tensor Xi_8 : 12 336 0 E(168)^31+E(168)^55
 +E(168)^103
R_1(3)+ tensor R_4^0(3,1,[1,2])+ tensor Xi_4 : 12 336 0 E(168)^47+E(168)^143
 +E(168)^167
R_1(1)+ tensor R_4^0(3,5,[0,1])- tensor Xi_8 : 12 336 0 E(168)^37+E(168)^85
 +E(168)^109
R_1(3)+ tensor R_4^0(1,5,[2,1])- tensor Xi_8 : 12 336 0 -E(168)^31-E(168)^55
 -E(168)^103
R_1(3)+ tensor R_4^0(1,5,[2,1])- tensor Xi_4 : 12 336 0 -E(168)^47-E(168)^143
 -E(168)^167
R_1(3)+ tensor R_4^0(3,5,[0,1])+ tensor Xi_8 : 12 336 0 -E(168)^13-E(168)^61
 -E(168)^157
R_1(3)+ tensor R_4^0(3,5,[0,1])- tensor Xi_8 : 12 336 0 E(168)^13+E(168)^61
 +E(168)^157
R_1(3)+ tensor R_4^0(3,5,[2,1])+ tensor Xi_4 : 12 336 0 E(168)^5+E(168)^101
 +E(168)^125
R_1(3)+ tensor R_4^0(1,5,[0,1])+ tensor Xi_8 : 12 336 0 -E(168)^31-E(168)^55
 -E(168)^103
R_1(3)+ tensor R_4^0(1,5,[0,1])- tensor Xi_4 : 12 336 0 E(168)^47+E(168)^143
 +E(168)^167
R_1(3)+ tensor R_4^0(1,5,[0,1])- tensor Xi_8 : 12 336 0 E(168)^31+E(168)^55
 +E(168)^103
R_1(3)+ tensor R_4^0(1,5,[2,1])+ tensor Xi_4 : 12 336 0 E(168)^47+E(168)^143
 +E(168)^167
R_1(1)+ tensor R_4^0(3,1,[1,0])+ tensor Xi_4 : 12 336 0 -E(168)^23-E(168)^71
 -E(168)^95
R_1(1)+ tensor R_4^0(3,5,[0,1])+ tensor Xi_8 : 12 336 0 -E(168)^37-E(168)^85
 -E(168)^109
R_1(1)+ tensor R_4^0(3,5,[0,1])+ tensor Xi_4 : 12 336 0 -E(168)^29-E(168)^53
 -E(168)^149
R_1(1)+ tensor R_4^0(3,1,[1,2])+ tensor Xi_4 : 12 336 0 E(168)^23+E(168)^71
 +E(168)^95
R_1(3)+ tensor R_4^0(3,5,[0,1])+ tensor Xi_4 : 12 336 0 -E(168)^5-E(168)^101
 -E(168)^125
R_1(1)+ tensor R_4^0(3,5,[0,1])- tensor Xi_4 : 12 336 0 E(168)^29+E(168)^53
 +E(168)^149
R_1(3)+ tensor R_4^0(3,5,[2,1])- tensor Xi_4 : 12 336 0 -E(168)^5-E(168)^101
 -E(168)^125
R_1(3)+ tensor R_4^0(3,5,[0,1])- tensor Xi_4 : 12 336 0 E(168)^5+E(168)^101
 +E(168)^125
R_1(3)+ tensor R_4^0(1,5,[2,1])+ tensor Xi_8 : 12 336 0 E(168)^31+E(168)^55
 +E(168)^103
R_1(3)+ tensor R_4^0(3,1,[1,2])- tensor Xi_8 : 12 336 0 -E(168)^31-E(168)^55
 -E(168)^103
R_1(3)+ tensor R_4^0(1,5,[0,1])+ tensor Xi_4 : 12 336 0 -E(168)^47-E(168)^143
 -E(168)^167
R_1(3)+ tensor R_4^0(3,5,[2,1])- tensor Xi_8 : 12 336 0 -E(168)^13-E(168)^61
 -E(168)^157
R_1(3)+ tensor R_4^0(3,1,[1,2])+ tensor Xi_8 : 12 336 0 E(168)^31+E(168)^55
 +E(168)^103
R_1(3)+ tensor R_4^0(3,1,[1,2])- tensor Xi_4 : 12 336 0 -E(168)^47-E(168)^143
 -E(168)^167
R_1(1)+ tensor R_4^0(1,5,[2,1])- tensor Xi_4 : 12 336 0 -E(168)^23-E(168)^71
 -E(168)^95
R_1(3)+ tensor R_4^0(3,5,[2,1])+ tensor Xi_8 : 12 336 0 E(168)^13+E(168)^61
 +E(168)^157
R_1(1)+ tensor R_4^0(1,1,[1,2])- tensor Xi_4 : 12 336 0 -E(168)^29-E(168)^53
 -E(168)^149
R_1(1)+ tensor R_4^0(1,1,[1,2])+ tensor Xi_8 : 12 336 0 E(168)^37+E(168)^85
 +E(168)^109
R_1(1)+ tensor R_4^0(1,1,[1,2])+ tensor Xi_4 : 12 336 0 E(168)^29+E(168)^53
 +E(168)^149
R_1(1)+ tensor R_4^0(1,1,[1,0])- tensor Xi_8 : 12 336 0 E(168)^37+E(168)^85
 +E(168)^109
R_1(3)+ tensor R_4^0(1,1,[1,2])- tensor Xi_8 : 12 336 0 -E(168)^13-E(168)^61
 -E(168)^157
R_1(2)- tensor R_1(1)- tensor Xi_10 : 12 390 0 -E(195)^14-E(195)^29-E(195)^56
 -E(195)^74-E(195)^101-E(195)^116-E(195)^131-E(195)^134-E(195)^146-E(195)^179
 -E(195)^191-E(195)^194
R_1(1)- tensor R_1(1)- tensor Xi_2 : 12 390 0 -E(195)^19-E(195)^31-E(195)^34
 -E(195)^46-E(195)^76-E(195)^106-E(195)^109-E(195)^124-E(195)^136-E(195)^151
 -E(195)^154-E(195)^184
R_1(1)- tensor R_1(1)- tensor Xi_10 : 12 390 0 -E(195)^11-E(195)^41-E(195)^44
 -E(195)^59-E(195)^71-E(195)^86-E(195)^89-E(195)^119-E(195)^149-E(195)^161
 -E(195)^164-E(195)^176
R_1(1)- tensor R_1(2)- tensor Xi_2 : 12 390 0 -E(195)^7-E(195)^28-E(195)^37
 -E(195)^58-E(195)^67-E(195)^73-E(195)^97-E(195)^112-E(195)^148-E(195)^163
 -E(195)^187-E(195)^193
R_1(1)- tensor R_1(2)- tensor Xi_10 : 12 390 0 -E(195)^2-E(195)^8-E(195)^32
 -E(195)^47-E(195)^83-E(195)^98-E(195)^122-E(195)^128-E(195)^137-E(195)^158
 -E(195)^167-E(195)^188
R_1(2)- tensor R_1(2)- tensor Xi_2 : 12 390 0 -E(195)^22-E(195)^43-E(195)^82
 -E(195)^88-E(195)^103-E(195)^118-E(195)^127-E(195)^133-E(195)^142-E(195)^157
 -E(195)^172-E(195)^178
R_1(2)- tensor R_1(1)- tensor Xi_2 : 12 390 0 -E(195)-E(195)^4-E(195)^16
 -E(195)^49-E(195)^61-E(195)^64-E(195)^79-E(195)^94-E(195)^121-E(195)^139
 -E(195)^166-E(195)^181
R_1(2)- tensor R_1(2)- tensor Xi_10 : 12 390 0 -E(195)^17-E(195)^23-E(195)^38
 -E(195)^53-E(195)^62-E(195)^68-E(195)^77-E(195)^92-E(195)^107-E(195)^113
 -E(195)^152-E(195)^173
R_1(1)+ tensor R_1(1)+ tensor Xi_5 : 12 420 0 -E(420)^13-E(420)^73-E(420)^97
 -E(420)^157-E(420)^313-E(420)^397
R_1(3)+ tensor R_1(2)+ tensor Xi_1 : 12 420 0 -E(420)^29-E(420)^149-E(420)^221
 -E(420)^281-E(420)^389-E(420)^401
N_1([0,1]) tensor R_1(2)- tensor Xi_7 : 12 420 0 -E(60)^11-E(60)^59
N_1([0,1]) tensor R_1(2)- tensor Xi_11 : 12 420 0 -E(60)^19-E(60)^31
R_1(3)+ tensor R_1(1)+ tensor Xi_11 : 12 420 0 E(420)^37+E(420)^193+E(420)^253
 +E(420)^277+E(420)^337+E(420)^373
R_1(3)+ tensor R_1(1)+ tensor Xi_7 : 12 420 0 E(420)^53+E(420)^113+E(420)^137
 +E(420)^197+E(420)^233+E(420)^317
R_1(3)+ tensor R_1(1)+ tensor Xi_5 : 12 420 0 -E(420)^37-E(420)^193-E(420)^253
 -E(420)^277-E(420)^337-E(420)^373
R_1(1)- tensor R_1(1)- tensor N_2([0,1]) tensor Xi_4 : 12 420 0 0
R_1(1)- tensor R_1(2)+ tensor R_1(2)- tensor Xi_9 : 12 420 0 
E(420)^53+E(420)^113+E(420)^137+E(420)^197+E(420)^233+E(420)^317
R_1(1)- tensor R_1(2)+ tensor R_1(2)- tensor Xi_3 : 12 420 0 
-E(420)^53-E(420)^113-E(420)^137-E(420)^197-E(420)^233-E(420)^317
R_1(3)+ tensor R_1(1)+ tensor Xi_1 : 12 420 0 -E(420)^53-E(420)^113-E(420)^137
 -E(420)^197-E(420)^233-E(420)^317
R_1(3)+ tensor R_1(2)+ tensor Xi_7 : 12 420 0 E(420)^29+E(420)^149+E(420)^221
 +E(420)^281+E(420)^389+E(420)^401
N_1([0,1]) tensor R_1(2)- tensor Xi_1 : 12 420 0 E(60)^11+E(60)^59
R_1(3)+ tensor R_1(2)+ tensor Xi_11 : 12 420 0 E(420)+E(420)^109+E(420)^121
 +E(420)^169+E(420)^289+E(420)^361
N_1([0,1]) tensor R_1(2)- tensor Xi_5 : 12 420 0 E(60)^19+E(60)^31
R_1(1)+ tensor R_1(2)+ tensor Xi_1 : 12 420 0 -E(420)^41-E(420)^89-E(420)^101
 -E(420)^209-E(420)^269-E(420)^341
R_1(1)+ tensor R_1(1)+ tensor Xi_11 : 12 420 0 E(420)^13+E(420)^73+E(420)^97
 +E(420)^157+E(420)^313+E(420)^397
R_1(1)+ tensor R_1(1)+ tensor Xi_7 : 12 420 0 E(420)^17+E(420)^173+E(420)^257
 +E(420)^293+E(420)^353+E(420)^377
R_1(1)- tensor R_1(2)- tensor N_2([0,1]) tensor Xi_4 : 12 420 0 0
R_1(1)+ tensor R_1(1)+ tensor Xi_1 : 12 420 0 -E(420)^17-E(420)^173-E(420)^257
 -E(420)^293-E(420)^353-E(420)^377
R_1(3)+ tensor R_1(2)+ tensor Xi_5 : 12 420 0 -E(420)-E(420)^109-E(420)^121
 -E(420)^169-E(420)^289-E(420)^361
R_1(1)- tensor R_1(2)- tensor N_2([0,1]) tensor Xi_8 : 12 420 0 0
R_1(1)- tensor R_1(2)+ tensor R_1(1)- tensor Xi_3 : 12 420 0 
-E(420)^29-E(420)^149-E(420)^221-E(420)^281-E(420)^389-E(420)^401
N_1([0,2]) tensor R_1(3)- tensor Xi_11 : 12 420 0 -E(84)^29-E(84)^53-E(84)^65
N_1([0,2]) tensor R_1(3)- tensor Xi_7 : 12 420 0 -E(84)-E(84)^25-E(84)^37
N_1([0,2]) tensor R_1(3)- tensor Xi_5 : 12 420 0 E(84)^29+E(84)^53+E(84)^65
N_1([0,2]) tensor R_1(3)- tensor Xi_1 : 12 420 0 E(84)+E(84)^25+E(84)^37
R_1(1)+ tensor R_1(2)+ tensor Xi_5 : 12 420 0 -E(420)^61-E(420)^181-E(420)^229
 -E(420)^241-E(420)^349-E(420)^409
R_1(1)- tensor R_1(2)+ tensor R_1(1)- tensor Xi_9 : 12 420 0 
E(420)^29+E(420)^149+E(420)^221+E(420)^281+E(420)^389+E(420)^401
N_1([0,2]) tensor R_1(1)- tensor Xi_11 : 12 420 0 -E(84)^5-E(84)^17-E(84)^41
N_1([0,2]) tensor R_1(1)- tensor Xi_7 : 12 420 0 -E(84)^13-E(84)^61-E(84)^73
R_1(1)+ tensor R_1(2)+ tensor Xi_7 : 12 420 0 E(420)^41+E(420)^89+E(420)^101
 +E(420)^209+E(420)^269+E(420)^341
R_1(1)+ tensor R_1(2)+ tensor Xi_11 : 12 420 0 E(420)^61+E(420)^181+E(420)^229
 +E(420)^241+E(420)^349+E(420)^409
N_1([0,2]) tensor R_1(1)- tensor Xi_5 : 12 420 0 E(84)^5+E(84)^17+E(84)^41
N_1([0,2]) tensor R_1(1)- tensor Xi_1 : 12 420 0 E(84)^13+E(84)^61+E(84)^73
N_1([0,1]) tensor R_1(3)- tensor Xi_11 : 12 420 0 -E(84)^29-E(84)^53-E(84)^65
R_1(3)- tensor N_1([0,1]) tensor R_1(1)- tensor Xi_3 : 12 420 0 
-E(140)^23-E(140)^43-E(140)^67-E(140)^107-E(140)^123-E(140)^127
R_1(3)- tensor N_1([0,1]) tensor R_1(1)- tensor Xi_9 : 12 420 0 
E(140)^23+E(140)^43+E(140)^67+E(140)^107+E(140)^123+E(140)^127
N_1([0,1]) tensor R_1(3)- tensor Xi_7 : 12 420 0 -E(84)-E(84)^25-E(84)^37
N_1([0,1]) tensor R_1(3)- tensor Xi_5 : 12 420 0 E(84)^29+E(84)^53+E(84)^65
R_1(3)- tensor N_1([0,1]) tensor R_1(2)- tensor Xi_3 : 12 420 0 
-E(140)^11-E(140)^39-E(140)^51-E(140)^71-E(140)^79-E(140)^99
R_1(3)- tensor N_1([0,1]) tensor R_1(2)- tensor Xi_9 : 12 420 0 
E(140)^11+E(140)^39+E(140)^51+E(140)^71+E(140)^79+E(140)^99
N_1([0,1]) tensor R_1(3)- tensor Xi_1 : 12 420 0 E(84)+E(84)^25+E(84)^37
N_1([0,1]) tensor R_1(1)- tensor Xi_11 : 12 420 0 -E(84)^5-E(84)^17-E(84)^41
N_1([0,1]) tensor R_1(1)- tensor Xi_7 : 12 420 0 -E(84)^13-E(84)^61-E(84)^73
N_1([0,1]) tensor R_1(1)- tensor Xi_5 : 12 420 0 E(84)^5+E(84)^17+E(84)^41
R_1(1)- tensor N_1([0,1]) tensor R_1(1)- tensor Xi_3 : 12 420 0 
-E(140)^3-E(140)^27-E(140)^47-E(140)^83-E(140)^87-E(140)^103
R_1(1)- tensor N_1([0,1]) tensor R_1(1)- tensor Xi_9 : 12 420 0 
E(140)^3+E(140)^27+E(140)^47+E(140)^83+E(140)^87+E(140)^103
N_1([0,1]) tensor R_1(1)- tensor Xi_1 : 12 420 0 E(84)^13+E(84)^61+E(84)^73
R_1(1)- tensor N_1([0,1]) tensor R_1(2)- tensor Xi_3 : 12 420 0 
-E(140)^19-E(140)^31-E(140)^59-E(140)^111-E(140)^131-E(140)^139
R_1(3)- tensor R_1(1)+ tensor R_1(1)- tensor Xi_3 : 12 420 0 
-E(420)^61-E(420)^181-E(420)^229-E(420)^241-E(420)^349-E(420)^409
R_1(3)- tensor R_1(1)+ tensor R_1(1)- tensor Xi_9 : 12 420 0 
E(420)^61+E(420)^181+E(420)^229+E(420)^241+E(420)^349+E(420)^409
R_1(1)- tensor N_1([0,1]) tensor R_1(2)- tensor Xi_9 : 12 420 0 
E(140)^19+E(140)^31+E(140)^59+E(140)^111+E(140)^131+E(140)^139
N_1([0,2]) tensor R_1(1)- tensor Xi_1 : 12 420 0 E(60)^23+E(60)^47
N_1([0,2]) tensor R_1(2)- tensor Xi_1 : 12 420 0 E(60)^11+E(60)^59
N_1([0,3]) tensor R_1(1)- tensor Xi_7 : 12 420 0 -E(60)^23-E(60)^47
N_1([0,3]) tensor R_1(1)- tensor Xi_1 : 12 420 0 E(60)^23+E(60)^47
R_1(1)- tensor R_1(1)+ tensor R_1(2)- tensor Xi_3 : 12 420 0 
-E(420)^37-E(420)^193-E(420)^253-E(420)^277-E(420)^337-E(420)^373
R_1(3)- tensor R_1(1)- tensor N_2([0,1]) tensor Xi_4 : 12 420 0 0
R_1(3)- tensor R_1(1)- tensor N_2([0,1]) tensor Xi_8 : 12 420 0 0
N_1([0,1]) tensor R_1(1)- tensor Xi_11 : 12 420 0 -E(60)^7-E(60)^43
R_1(3)- tensor R_1(2)- tensor N_2([0,1]) tensor Xi_4 : 12 420 0 0
N_1([0,2]) tensor R_1(2)- tensor Xi_11 : 12 420 0 -E(60)^19-E(60)^31
N_1([0,2]) tensor R_1(2)- tensor Xi_7 : 12 420 0 -E(60)^11-E(60)^59
R_1(3)- tensor R_1(2)+ tensor R_1(1)- tensor Xi_3 : 12 420 0 
-E(420)^41-E(420)^89-E(420)^101-E(420)^209-E(420)^269-E(420)^341
R_1(3)- tensor R_1(2)+ tensor R_1(1)- tensor Xi_9 : 12 420 0 
E(420)^41+E(420)^89+E(420)^101+E(420)^209+E(420)^269+E(420)^341
N_1([0,3]) tensor R_1(2)- tensor Xi_11 : 12 420 0 -E(60)^19-E(60)^31
N_1([0,3]) tensor R_1(2)- tensor Xi_7 : 12 420 0 -E(60)^11-E(60)^59
R_1(3)- tensor R_1(2)+ tensor R_1(2)- tensor Xi_3 : 12 420 0 
-E(420)^17-E(420)^173-E(420)^257-E(420)^293-E(420)^353-E(420)^377
R_1(3)- tensor R_1(2)+ tensor R_1(2)- tensor Xi_9 : 12 420 0 
E(420)^17+E(420)^173+E(420)^257+E(420)^293+E(420)^353+E(420)^377
N_1([0,3]) tensor R_1(2)- tensor Xi_5 : 12 420 0 E(60)^19+E(60)^31
N_1([0,3]) tensor R_1(2)- tensor Xi_1 : 12 420 0 E(60)^11+E(60)^59
N_1([0,3]) tensor R_1(1)- tensor Xi_11 : 12 420 0 -E(60)^7-E(60)^43
R_1(1)- tensor R_1(1)- tensor N_2([0,1]) tensor Xi_8 : 12 420 0 0
N_1([0,3]) tensor R_1(1)- tensor Xi_5 : 12 420 0 E(60)^7+E(60)^43
R_1(3)- tensor R_1(1)+ tensor R_1(2)- tensor Xi_3 : 12 420 0 
-E(420)^13-E(420)^73-E(420)^97-E(420)^157-E(420)^313-E(420)^397
R_1(3)- tensor R_1(1)+ tensor R_1(2)- tensor Xi_9 : 12 420 0 
E(420)^13+E(420)^73+E(420)^97+E(420)^157+E(420)^313+E(420)^397
N_1([0,2]) tensor R_1(1)- tensor Xi_5 : 12 420 0 E(60)^7+E(60)^43
R_1(1)- tensor R_1(1)+ tensor R_1(2)- tensor Xi_9 : 12 420 0 
E(420)^37+E(420)^193+E(420)^253+E(420)^277+E(420)^337+E(420)^373
N_1([0,1]) tensor R_1(1)- tensor Xi_1 : 12 420 0 E(60)^23+E(60)^47
N_1([0,1]) tensor R_1(1)- tensor Xi_5 : 12 420 0 E(60)^7+E(60)^43
N_1([0,1]) tensor R_1(1)- tensor Xi_7 : 12 420 0 -E(60)^23-E(60)^47
R_1(3)- tensor R_1(2)- tensor N_2([0,1]) tensor Xi_8 : 12 420 0 0
R_1(1)- tensor R_1(1)+ tensor R_1(1)- tensor Xi_3 : 12 420 0 
-E(420)-E(420)^109-E(420)^121-E(420)^169-E(420)^289-E(420)^361
N_1([0,2]) tensor R_1(1)- tensor Xi_7 : 12 420 0 -E(60)^23-E(60)^47
N_1([0,2]) tensor R_1(1)- tensor Xi_11 : 12 420 0 -E(60)^7-E(60)^43
R_1(1)- tensor R_1(1)+ tensor R_1(1)- tensor Xi_9 : 12 420 0 E(420)+E(420)^109
 +E(420)^121+E(420)^169+E(420)^289+E(420)^361
N_1([0,2]) tensor R_1(2)- tensor Xi_5 : 12 420 0 E(60)^19+E(60)^31
R_5^2(1,7,[1,1])- tensor R_1(2)- tensor Xi_8 : 12 480 0 E(120)^8+E(120)^32
 -E(120)^53-E(120)^77
R_5^2(3,5,[1,1])- tensor R_1(2)- tensor Xi_8 : 12 480 0 E(120)^38-E(120)^53
 +E(120)^62-E(120)^77
R_5^2(3,5,[1,1])- tensor R_1(2)- tensor Xi_4 : 12 480 0 -E(120)^13+E(120)^22
 -E(120)^37+E(120)^118
R_5^2(3,7,[1,0])- tensor R_1(2)- tensor Xi_8 : 12 480 0 E(120)^8+E(120)^23
 +E(120)^32+E(120)^47
R_5^2(3,5,[1,1])- tensor R_1(1)- tensor Xi_8 : 12 480 0 E(120)^14-E(120)^29
 +E(120)^86-E(120)^101
R_5^2(3,5,[1,1])- tensor R_1(1)- tensor Xi_4 : 12 480 0 E(120)^46-E(120)^61
 +E(120)^94-E(120)^109
R_5^2(3,5,[1,1])+ tensor R_1(2)- tensor Xi_8 : 12 480 0 E(120)^38+E(120)^53
 +E(120)^62+E(120)^77
R_5^2(3,5,[1,1])+ tensor R_1(2)- tensor Xi_4 : 12 480 0 E(120)^13+E(120)^22
 +E(120)^37+E(120)^118
R_5^2(3,7,[1,0])- tensor R_1(1)- tensor Xi_8 : 12 480 0 E(120)^56+E(120)^71
 +E(120)^104+E(120)^119
R_5^2(3,1,[1,0])- tensor R_1(2)- tensor Xi_8 : 12 480 0 -E(120)^38-E(120)^53
 -E(120)^62-E(120)^77
R_5^2(3,5,[1,1])+ tensor R_1(1)- tensor Xi_8 : 12 480 0 E(120)^14+E(120)^29
 +E(120)^86+E(120)^101
R_5^2(3,7,[1,0])+ tensor R_1(1)- tensor Xi_4 : 12 480 0 E(120)^16-E(120)^31
 +E(120)^64-E(120)^79
R_5^2(3,7,[1,0])- tensor R_1(1)- tensor Xi_4 : 12 480 0 E(120)^16+E(120)^31
 +E(120)^64+E(120)^79
R_5^2(3,5,[1,1])+ tensor R_1(1)- tensor Xi_4 : 12 480 0 E(120)^46+E(120)^61
 +E(120)^94+E(120)^109
R_5^2(3,5,[1,0])- tensor R_1(2)- tensor Xi_8 : 12 480 0 E(120)^38+E(120)^53
 +E(120)^62+E(120)^77
R_5^2(3,1,[1,1])+ tensor R_1(1)- tensor Xi_4 : 12 480 0 -E(120)^46-E(120)^61
 -E(120)^94-E(120)^109
R_5^2(3,5,[1,0])- tensor R_1(2)- tensor Xi_4 : 12 480 0 E(120)^13+E(120)^22
 +E(120)^37+E(120)^118
R_5^2(3,5,[1,0])- tensor R_1(1)- tensor Xi_8 : 12 480 0 E(120)^14+E(120)^29
 +E(120)^86+E(120)^101
R_5^2(3,1,[1,1])+ tensor R_1(1)- tensor Xi_8 : 12 480 0 -E(120)^14-E(120)^29
 -E(120)^86-E(120)^101
R_5^2(3,7,[1,0])+ tensor R_1(1)- tensor Xi_8 : 12 480 0 E(120)^56-E(120)^71
 +E(120)^104-E(120)^119
R_5^2(3,7,[1,0])+ tensor R_1(2)- tensor Xi_4 : 12 480 0 -E(120)^7+E(120)^88
 -E(120)^103+E(120)^112
R_5^2(3,7,[1,1])+ tensor R_1(1)- tensor Xi_4 : 12 480 0 E(120)^16+E(120)^31
 +E(120)^64+E(120)^79
R_5^2(3,7,[1,0])+ tensor R_1(2)- tensor Xi_8 : 12 480 0 E(120)^8-E(120)^23
 +E(120)^32-E(120)^47
R_5^2(3,5,[1,0])- tensor R_1(1)- tensor Xi_4 : 12 480 0 E(120)^46+E(120)^61
 +E(120)^94+E(120)^109
R_5^2(3,1,[1,0])- tensor R_1(2)- tensor Xi_4 : 12 480 0 -E(120)^13-E(120)^22
 -E(120)^37-E(120)^118
R_5^2(3,1,[1,0])- tensor R_1(1)- tensor Xi_8 : 12 480 0 -E(120)^14-E(120)^29
 -E(120)^86-E(120)^101
R_5^2(3,1,[1,0])- tensor R_1(1)- tensor Xi_4 : 12 480 0 -E(120)^46-E(120)^61
 -E(120)^94-E(120)^109
R_5^2(3,1,[1,0])+ tensor R_1(2)- tensor Xi_8 : 12 480 0 -E(120)^38+E(120)^53
 -E(120)^62+E(120)^77
R_5^2(3,1,[1,0])+ tensor R_1(2)- tensor Xi_4 : 12 480 0 E(120)^13-E(120)^22
 +E(120)^37-E(120)^118
R_5^2(3,1,[1,0])+ tensor R_1(1)- tensor Xi_8 : 12 480 0 -E(120)^14+E(120)^29
 -E(120)^86+E(120)^101
R_5^2(3,1,[1,0])+ tensor R_1(1)- tensor Xi_4 : 12 480 0 -E(120)^46+E(120)^61
 -E(120)^94+E(120)^109
R_5^2(3,7,[1,0])- tensor R_1(2)- tensor Xi_4 : 12 480 0 E(120)^7+E(120)^88
 +E(120)^103+E(120)^112
R_5^2(1,7,[1,1])- tensor R_1(2)- tensor Xi_4 : 12 480 0 -E(120)^13-E(120)^37
 +E(120)^88+E(120)^112
R_5^2(1,7,[1,1])- tensor R_1(1)- tensor Xi_8 : 12 480 0 -E(120)^29+E(120)^56
 -E(120)^101+E(120)^104
R_5^2(1,7,[1,1])- tensor R_1(1)- tensor Xi_4 : 12 480 0 E(120)^16-E(120)^61
 +E(120)^64-E(120)^109
R_5^2(1,7,[1,1])+ tensor R_1(2)- tensor Xi_8 : 12 480 0 E(120)^8+E(120)^32
 +E(120)^53+E(120)^77
R_5^2(1,7,[1,1])+ tensor R_1(2)- tensor Xi_4 : 12 480 0 E(120)^13+E(120)^37
 +E(120)^88+E(120)^112
R_5^2(1,7,[1,1])+ tensor R_1(1)- tensor Xi_8 : 12 480 0 E(120)^29+E(120)^56
 +E(120)^101+E(120)^104
R_5^2(1,7,[1,1])+ tensor R_1(1)- tensor Xi_4 : 12 480 0 E(120)^16+E(120)^61
 +E(120)^64+E(120)^109
R_5^2(1,7,[1,0])- tensor R_1(2)- tensor Xi_8 : 12 480 0 E(120)^8+E(120)^32
 +E(120)^53+E(120)^77
R_5^2(1,7,[1,0])- tensor R_1(2)- tensor Xi_4 : 12 480 0 E(120)^13+E(120)^37
 +E(120)^88+E(120)^112
R_5^2(1,7,[1,0])- tensor R_1(1)- tensor Xi_8 : 12 480 0 E(120)^29+E(120)^56
 +E(120)^101+E(120)^104
R_5^2(1,7,[1,0])- tensor R_1(1)- tensor Xi_4 : 12 480 0 E(120)^16+E(120)^61
 +E(120)^64+E(120)^109
R_5^2(3,1,[1,1])+ tensor R_1(2)- tensor Xi_4 : 12 480 0 -E(120)^13-E(120)^22
 -E(120)^37-E(120)^118
R_5^2(1,7,[1,0])+ tensor R_1(2)- tensor Xi_8 : 12 480 0 E(120)^8+E(120)^32
 -E(120)^53-E(120)^77
R_5^2(1,7,[1,0])+ tensor R_1(2)- tensor Xi_4 : 12 480 0 -E(120)^13-E(120)^37
 +E(120)^88+E(120)^112
R_5^2(1,7,[1,0])+ tensor R_1(1)- tensor Xi_8 : 12 480 0 -E(120)^29+E(120)^56
 -E(120)^101+E(120)^104
R_5^2(3,1,[1,1])+ tensor R_1(2)- tensor Xi_8 : 12 480 0 -E(120)^38-E(120)^53
 -E(120)^62-E(120)^77
R_5^2(3,1,[1,1])- tensor R_1(1)- tensor Xi_4 : 12 480 0 -E(120)^46+E(120)^61
 -E(120)^94+E(120)^109
R_5^2(3,1,[1,1])- tensor R_1(1)- tensor Xi_8 : 12 480 0 -E(120)^14+E(120)^29
 -E(120)^86+E(120)^101
R_5^2(3,1,[1,1])- tensor R_1(2)- tensor Xi_4 : 12 480 0 E(120)^13-E(120)^22
 +E(120)^37-E(120)^118
R_5^2(1,5,[1,1])- tensor R_1(2)- tensor Xi_8 : 12 480 0 -E(120)^23-E(120)^38
 -E(120)^47-E(120)^62
R_5^2(1,5,[1,1])- tensor R_1(2)- tensor Xi_4 : 12 480 0 -E(120)^7-E(120)^22
 -E(120)^103-E(120)^118
R_5^2(1,5,[1,1])- tensor R_1(1)- tensor Xi_8 : 12 480 0 -E(120)^14-E(120)^71
 -E(120)^86-E(120)^119
R_5^2(1,5,[1,1])- tensor R_1(1)- tensor Xi_4 : 12 480 0 -E(120)^31-E(120)^46
 -E(120)^79-E(120)^94
R_5^2(1,5,[1,1])+ tensor R_1(2)- tensor Xi_8 : 12 480 0 E(120)^23-E(120)^38
 +E(120)^47-E(120)^62
R_5^2(1,5,[1,1])+ tensor R_1(2)- tensor Xi_4 : 12 480 0 E(120)^7-E(120)^22
 +E(120)^103-E(120)^118
R_5^2(1,5,[1,1])+ tensor R_1(1)- tensor Xi_8 : 12 480 0 -E(120)^14+E(120)^71
 -E(120)^86+E(120)^119
R_5^2(1,5,[1,1])+ tensor R_1(1)- tensor Xi_4 : 12 480 0 E(120)^31-E(120)^46
 +E(120)^79-E(120)^94
R_5^2(1,5,[1,0])- tensor R_1(2)- tensor Xi_8 : 12 480 0 E(120)^23-E(120)^38
 +E(120)^47-E(120)^62
R_5^2(1,5,[1,0])- tensor R_1(2)- tensor Xi_4 : 12 480 0 E(120)^7-E(120)^22
 +E(120)^103-E(120)^118
R_5^2(1,5,[1,0])- tensor R_1(1)- tensor Xi_8 : 12 480 0 -E(120)^14+E(120)^71
 -E(120)^86+E(120)^119
R_5^2(1,5,[1,0])- tensor R_1(1)- tensor Xi_4 : 12 480 0 E(120)^31-E(120)^46
 +E(120)^79-E(120)^94
R_5^2(3,1,[1,1])- tensor R_1(2)- tensor Xi_8 : 12 480 0 -E(120)^38+E(120)^53
 -E(120)^62+E(120)^77
R_5^2(3,3,[1,0])+ tensor R_1(1)- tensor Xi_4 : 12 480 0 -E(120)^16+E(120)^31
 -E(120)^64+E(120)^79
R_5^2(3,3,[1,0])+ tensor R_1(1)- tensor Xi_8 : 12 480 0 -E(120)^56+E(120)^71
 -E(120)^104+E(120)^119
R_5^2(1,5,[1,0])+ tensor R_1(2)- tensor Xi_8 : 12 480 0 -E(120)^23-E(120)^38
 -E(120)^47-E(120)^62
R_5^2(1,5,[1,0])+ tensor R_1(2)- tensor Xi_4 : 12 480 0 -E(120)^7-E(120)^22
 -E(120)^103-E(120)^118
R_5^2(1,5,[1,0])+ tensor R_1(1)- tensor Xi_8 : 12 480 0 -E(120)^14-E(120)^71
 -E(120)^86-E(120)^119
R_5^2(1,5,[1,0])+ tensor R_1(1)- tensor Xi_4 : 12 480 0 -E(120)^31-E(120)^46
 -E(120)^79-E(120)^94
R_5^2(3,3,[1,0])+ tensor R_1(2)- tensor Xi_4 : 12 480 0 E(120)^7-E(120)^88
 +E(120)^103-E(120)^112
R_5^2(1,3,[1,1])- tensor R_1(2)- tensor Xi_8 : 12 480 0 -E(120)^8-E(120)^32
 +E(120)^53+E(120)^77
R_5^2(1,3,[1,1])- tensor R_1(2)- tensor Xi_4 : 12 480 0 E(120)^13+E(120)^37
 -E(120)^88-E(120)^112
R_5^2(1,3,[1,1])- tensor R_1(1)- tensor Xi_8 : 12 480 0 E(120)^29-E(120)^56
 +E(120)^101-E(120)^104
R_5^2(1,3,[1,1])- tensor R_1(1)- tensor Xi_4 : 12 480 0 -E(120)^16+E(120)^61
 -E(120)^64+E(120)^109
R_5^2(1,3,[1,1])+ tensor R_1(2)- tensor Xi_8 : 12 480 0 -E(120)^8-E(120)^32
 -E(120)^53-E(120)^77
R_5^2(1,3,[1,1])+ tensor R_1(2)- tensor Xi_4 : 12 480 0 -E(120)^13-E(120)^37
 -E(120)^88-E(120)^112
R_5^2(1,3,[1,1])+ tensor R_1(1)- tensor Xi_8 : 12 480 0 -E(120)^29-E(120)^56
 -E(120)^101-E(120)^104
R_5^2(1,3,[1,1])+ tensor R_1(1)- tensor Xi_4 : 12 480 0 -E(120)^16-E(120)^61
 -E(120)^64-E(120)^109
R_5^2(1,3,[1,0])- tensor R_1(2)- tensor Xi_8 : 12 480 0 -E(120)^8-E(120)^32
 -E(120)^53-E(120)^77
R_5^2(1,3,[1,0])- tensor R_1(2)- tensor Xi_4 : 12 480 0 -E(120)^13-E(120)^37
 -E(120)^88-E(120)^112
R_5^2(1,3,[1,0])- tensor R_1(1)- tensor Xi_8 : 12 480 0 -E(120)^29-E(120)^56
 -E(120)^101-E(120)^104
R_5^2(1,3,[1,0])- tensor R_1(1)- tensor Xi_4 : 12 480 0 -E(120)^16-E(120)^61
 -E(120)^64-E(120)^109
R_5^2(1,3,[1,0])+ tensor R_1(2)- tensor Xi_8 : 12 480 0 -E(120)^8-E(120)^32
 +E(120)^53+E(120)^77
R_5^2(1,3,[1,0])+ tensor R_1(2)- tensor Xi_4 : 12 480 0 E(120)^13+E(120)^37
 -E(120)^88-E(120)^112
R_5^2(1,3,[1,0])+ tensor R_1(1)- tensor Xi_8 : 12 480 0 E(120)^29-E(120)^56
 +E(120)^101-E(120)^104
R_5^2(1,3,[1,0])+ tensor R_1(1)- tensor Xi_4 : 12 480 0 -E(120)^16+E(120)^61
 -E(120)^64+E(120)^109
R_5^2(1,1,[1,1])- tensor R_1(2)- tensor Xi_8 : 12 480 0 E(120)^23+E(120)^38
 +E(120)^47+E(120)^62
R_5^2(1,1,[1,1])- tensor R_1(2)- tensor Xi_4 : 12 480 0 E(120)^7+E(120)^22
 +E(120)^103+E(120)^118
R_5^2(1,1,[1,1])- tensor R_1(1)- tensor Xi_8 : 12 480 0 E(120)^14+E(120)^71
 +E(120)^86+E(120)^119
R_5^2(1,1,[1,1])- tensor R_1(1)- tensor Xi_4 : 12 480 0 E(120)^31+E(120)^46
 +E(120)^79+E(120)^94
R_5^2(1,1,[1,1])+ tensor R_1(2)- tensor Xi_8 : 12 480 0 -E(120)^23+E(120)^38
 -E(120)^47+E(120)^62
R_5^2(1,1,[1,1])+ tensor R_1(2)- tensor Xi_4 : 12 480 0 -E(120)^7+E(120)^22
 -E(120)^103+E(120)^118
R_5^2(1,1,[1,1])+ tensor R_1(1)- tensor Xi_8 : 12 480 0 E(120)^14-E(120)^71
 +E(120)^86-E(120)^119
R_5^2(3,3,[1,1])+ tensor R_1(2)- tensor Xi_8 : 12 480 0 -E(120)^8-E(120)^23
 -E(120)^32-E(120)^47
R_5^2(3,7,[1,1])+ tensor R_1(1)- tensor Xi_8 : 12 480 0 E(120)^56+E(120)^71
 +E(120)^104+E(120)^119
R_5^2(1,1,[1,0])- tensor R_1(2)- tensor Xi_8 : 12 480 0 -E(120)^23+E(120)^38
 -E(120)^47+E(120)^62
R_5^2(1,1,[1,0])- tensor R_1(2)- tensor Xi_4 : 12 480 0 -E(120)^7+E(120)^22
 -E(120)^103+E(120)^118
R_5^2(1,1,[1,0])- tensor R_1(1)- tensor Xi_8 : 12 480 0 E(120)^14-E(120)^71
 +E(120)^86-E(120)^119
R_5^2(1,1,[1,0])- tensor R_1(1)- tensor Xi_4 : 12 480 0 -E(120)^31+E(120)^46
 -E(120)^79+E(120)^94
R_5^2(3,3,[1,0])+ tensor R_1(2)- tensor Xi_8 : 12 480 0 -E(120)^8+E(120)^23
 -E(120)^32+E(120)^47
R_5^2(3,5,[1,0])+ tensor R_1(2)- tensor Xi_8 : 12 480 0 E(120)^38-E(120)^53
 +E(120)^62-E(120)^77
R_5^2(3,5,[1,0])+ tensor R_1(2)- tensor Xi_4 : 12 480 0 -E(120)^13+E(120)^22
 -E(120)^37+E(120)^118
R_5^2(1,1,[1,0])+ tensor R_1(2)- tensor Xi_8 : 12 480 0 E(120)^23+E(120)^38
 +E(120)^47+E(120)^62
R_5^2(1,1,[1,0])+ tensor R_1(2)- tensor Xi_4 : 12 480 0 E(120)^7+E(120)^22
 +E(120)^103+E(120)^118
R_5^2(1,1,[1,0])+ tensor R_1(1)- tensor Xi_8 : 12 480 0 E(120)^14+E(120)^71
 +E(120)^86+E(120)^119
R_5^2(1,1,[1,0])+ tensor R_1(1)- tensor Xi_4 : 12 480 0 E(120)^31+E(120)^46
 +E(120)^79+E(120)^94
R_5^2(3,5,[1,0])+ tensor R_1(1)- tensor Xi_8 : 12 480 0 E(120)^14-E(120)^29
 +E(120)^86-E(120)^101
R_5^2(3,5,[1,0])+ tensor R_1(1)- tensor Xi_4 : 12 480 0 E(120)^46-E(120)^61
 +E(120)^94-E(120)^109
R_5^2(3,3,[1,0])- tensor R_1(1)- tensor Xi_4 : 12 480 0 -E(120)^16-E(120)^31
 -E(120)^64-E(120)^79
R_5^2(3,7,[1,1])+ tensor R_1(2)- tensor Xi_4 : 12 480 0 E(120)^7+E(120)^88
 +E(120)^103+E(120)^112
R_5^2(3,3,[1,1])- tensor R_1(2)- tensor Xi_8 : 12 480 0 -E(120)^8+E(120)^23
 -E(120)^32+E(120)^47
R_5^2(3,3,[1,1])- tensor R_1(2)- tensor Xi_4 : 12 480 0 E(120)^7-E(120)^88
 +E(120)^103-E(120)^112
R_5^2(3,3,[1,1])- tensor R_1(1)- tensor Xi_8 : 12 480 0 -E(120)^56+E(120)^71
 -E(120)^104+E(120)^119
R_5^2(3,3,[1,1])- tensor R_1(1)- tensor Xi_4 : 12 480 0 -E(120)^16+E(120)^31
 -E(120)^64+E(120)^79
R_5^2(3,7,[1,1])+ tensor R_1(2)- tensor Xi_8 : 12 480 0 E(120)^8+E(120)^23
 +E(120)^32+E(120)^47
R_5^2(3,3,[1,0])- tensor R_1(1)- tensor Xi_8 : 12 480 0 -E(120)^56-E(120)^71
 -E(120)^104-E(120)^119
R_5^2(3,3,[1,0])- tensor R_1(2)- tensor Xi_4 : 12 480 0 -E(120)^7-E(120)^88
 -E(120)^103-E(120)^112
R_5^2(3,3,[1,0])- tensor R_1(2)- tensor Xi_8 : 12 480 0 -E(120)^8-E(120)^23
 -E(120)^32-E(120)^47
R_5^2(3,7,[1,1])- tensor R_1(1)- tensor Xi_4 : 12 480 0 E(120)^16-E(120)^31
 +E(120)^64-E(120)^79
R_5^2(3,7,[1,1])- tensor R_1(1)- tensor Xi_8 : 12 480 0 E(120)^56-E(120)^71
 +E(120)^104-E(120)^119
R_5^2(3,7,[1,1])- tensor R_1(2)- tensor Xi_4 : 12 480 0 -E(120)^7+E(120)^88
 -E(120)^103+E(120)^112
R_5^2(3,3,[1,1])+ tensor R_1(1)- tensor Xi_4 : 12 480 0 -E(120)^16-E(120)^31
 -E(120)^64-E(120)^79
R_5^2(3,3,[1,1])+ tensor R_1(1)- tensor Xi_8 : 12 480 0 -E(120)^56-E(120)^71
 -E(120)^104-E(120)^119
R_5^2(3,7,[1,1])- tensor R_1(2)- tensor Xi_8 : 12 480 0 E(120)^8-E(120)^23
 +E(120)^32-E(120)^47
R_5^2(1,1,[1,1])+ tensor R_1(1)- tensor Xi_4 : 12 480 0 -E(120)^31+E(120)^46
 -E(120)^79+E(120)^94
R_5^2(3,3,[1,1])+ tensor R_1(2)- tensor Xi_4 : 12 480 0 -E(120)^7-E(120)^88
 -E(120)^103-E(120)^112
R_5^2(1,7,[1,0])+ tensor R_1(1)- tensor Xi_4 : 12 480 0 E(120)^16-E(120)^61
 +E(120)^64-E(120)^109
R_1(2)+ tensor R_1(1)- tensor Xi_11 : 12 660 0 -E(660)^53-E(660)^113
 -E(660)^137-E(660)^257-E(660)^317-E(660)^353-E(660)^377-E(660)^533-E(660)^617
 -E(660)^653
R_1(2)+ tensor R_1(1)- tensor Xi_5 : 12 660 0 E(660)^53+E(660)^113+E(660)^137
 +E(660)^257+E(660)^317+E(660)^353+E(660)^377+E(660)^533+E(660)^617+E(660)^653
R_1(2)+ tensor R_1(1)- tensor Xi_1 : 12 660 0 E(660)^37+E(660)^97+E(660)^133
 +E(660)^157+E(660)^313+E(660)^397+E(660)^433+E(660)^493+E(660)^553+E(660)^577
R_1(2)+ tensor R_1(2)- tensor Xi_1 : 12 660 0 E(660)+E(660)^49+E(660)^169
 +E(660)^181+E(660)^229+E(660)^289+E(660)^301+E(660)^361+E(660)^421+E(660)^529
R_1(2)+ tensor R_1(2)- tensor Xi_5 : 12 660 0 E(660)^89+E(660)^221+E(660)^269
 +E(660)^389+E(660)^401+E(660)^449+E(660)^509+E(660)^521+E(660)^581+E(660)^641
R_1(2)+ tensor R_1(2)- tensor Xi_7 : 12 660 0 -E(660)-E(660)^49-E(660)^169
 -E(660)^181-E(660)^229-E(660)^289-E(660)^301-E(660)^361-E(660)^421-E(660)^529
R_1(2)+ tensor R_1(2)- tensor Xi_11 : 12 660 0 -E(660)^89-E(660)^221
 -E(660)^269-E(660)^389-E(660)^401-E(660)^449-E(660)^509-E(660)^521-E(660)^581
 -E(660)^641
R_1(1)+ tensor R_1(2)- tensor Xi_11 : 12 660 0 -E(660)^29-E(660)^41-E(660)^101
 -E(660)^149-E(660)^161-E(660)^281-E(660)^329-E(660)^461-E(660)^569-E(660)^629
R_1(1)+ tensor R_1(2)- tensor Xi_7 : 12 660 0 -E(660)^61-E(660)^109-E(660)^241
 -E(660)^349-E(660)^409-E(660)^469-E(660)^481-E(660)^541-E(660)^589-E(660)^601
R_1(1)+ tensor R_1(2)- tensor Xi_5 : 12 660 0 E(660)^29+E(660)^41+E(660)^101
 +E(660)^149+E(660)^161+E(660)^281+E(660)^329+E(660)^461+E(660)^569+E(660)^629
R_1(1)+ tensor R_1(2)- tensor Xi_1 : 12 660 0 E(660)^61+E(660)^109+E(660)^241
 +E(660)^349+E(660)^409+E(660)^469+E(660)^481+E(660)^541+E(660)^589+E(660)^601
R_1(1)+ tensor R_1(1)- tensor Xi_11 : 12 660 0 -E(660)^17-E(660)^173
 -E(660)^197-E(660)^233-E(660)^293-E(660)^413-E(660)^437-E(660)^497-E(660)^557
 -E(660)^593
R_1(1)+ tensor R_1(1)- tensor Xi_7 : 12 660 0 -E(660)^13-E(660)^73-E(660)^193
 -E(660)^217-E(660)^277-E(660)^337-E(660)^373-E(660)^457-E(660)^613-E(660)^637
R_1(1)+ tensor R_1(1)- tensor Xi_5 : 12 660 0 E(660)^17+E(660)^173+E(660)^197
 +E(660)^233+E(660)^293+E(660)^413+E(660)^437+E(660)^497+E(660)^557+E(660)^593
R_1(1)+ tensor R_1(1)- tensor Xi_1 : 12 660 0 E(660)^13+E(660)^73+E(660)^193
 +E(660)^217+E(660)^277+E(660)^337+E(660)^373+E(660)^457+E(660)^613+E(660)^637
R_1(2)+ tensor R_1(1)- tensor Xi_7 : 12 660 0 -E(660)^37-E(660)^97-E(660)^133
 -E(660)^157-E(660)^313-E(660)^397-E(660)^433-E(660)^493-E(660)^553-E(660)^577
R_1(1)- tensor R_1(2)- tensor Xi_1 : 12 780 0 -E(780)^47-E(780)^83-E(780)^167
 -E(780)^203-E(780)^227-E(780)^323-E(780)^383-E(780)^527-E(780)^587-E(780)^683
 -E(780)^707-E(780)^743
R_1(1)- tensor R_1(1)- tensor Xi_1 : 12 780 0 -E(780)^11-E(780)^59-E(780)^71
 -E(780)^119-E(780)^239-E(780)^359-E(780)^371-E(780)^431-E(780)^479-E(780)^539
 -E(780)^551-E(780)^671
R_1(1)- tensor R_1(1)- tensor Xi_5 : 12 780 0 -E(780)^19-E(780)^31-E(780)^151
 -E(780)^271-E(780)^319-E(780)^331-E(780)^379-E(780)^499-E(780)^619-E(780)^631
 -E(780)^691-E(780)^739
R_1(1)- tensor R_1(1)- tensor Xi_7 : 12 780 0 E(780)^11+E(780)^59+E(780)^71
 +E(780)^119+E(780)^239+E(780)^359+E(780)^371+E(780)^431+E(780)^479+E(780)^539
 +E(780)^551+E(780)^671
R_1(2)- tensor R_1(2)- tensor Xi_11 : 12 780 0 E(780)^43+E(780)^103+E(780)^127
 +E(780)^283+E(780)^367+E(780)^523+E(780)^547+E(780)^607+E(780)^667+E(780)^703
 +E(780)^727+E(780)^763
R_1(1)- tensor R_1(1)- tensor Xi_11 : 12 780 0 E(780)^19+E(780)^31+E(780)^151
 +E(780)^271+E(780)^319+E(780)^331+E(780)^379+E(780)^499+E(780)^619+E(780)^631
 +E(780)^691+E(780)^739
R_1(2)- tensor R_1(2)- tensor Xi_7 : 12 780 0 E(780)^23+E(780)^107+E(780)^263
 +E(780)^287+E(780)^347+E(780)^407+E(780)^443+E(780)^467+E(780)^503+E(780)^563
 +E(780)^623+E(780)^647
R_1(2)- tensor R_1(2)- tensor Xi_5 : 12 780 0 -E(780)^43-E(780)^103-E(780)^127
 -E(780)^283-E(780)^367-E(780)^523-E(780)^547-E(780)^607-E(780)^667-E(780)^703
 -E(780)^727-E(780)^763
R_1(2)- tensor R_1(1)- tensor Xi_11 : 12 780 0 E(780)^79+E(780)^139+E(780)^199
 +E(780)^211+E(780)^259+E(780)^391+E(780)^439+E(780)^451+E(780)^511+E(780)^571
 +E(780)^679+E(780)^751
R_1(2)- tensor R_1(1)- tensor Xi_7 : 12 780 0 E(780)^131+E(780)^179+E(780)^191
 +E(780)^251+E(780)^311+E(780)^419+E(780)^491+E(780)^599+E(780)^659+E(780)^719
 +E(780)^731+E(780)^779
R_1(2)- tensor R_1(1)- tensor Xi_5 : 12 780 0 -E(780)^79-E(780)^139-E(780)^199
 -E(780)^211-E(780)^259-E(780)^391-E(780)^439-E(780)^451-E(780)^511-E(780)^571
 -E(780)^679-E(780)^751
R_1(2)- tensor R_1(1)- tensor Xi_1 : 12 780 0 -E(780)^131-E(780)^179
 -E(780)^191-E(780)^251-E(780)^311-E(780)^419-E(780)^491-E(780)^599-E(780)^659
 -E(780)^719-E(780)^731-E(780)^779
R_1(1)- tensor R_1(2)- tensor Xi_5 : 12 780 0 -E(780)^7-E(780)^67-E(780)^163
 -E(780)^187-E(780)^223-E(780)^307-E(780)^343-E(780)^427-E(780)^463-E(780)^487
 -E(780)^583-E(780)^643
R_1(1)- tensor R_1(2)- tensor Xi_7 : 12 780 0 E(780)^47+E(780)^83+E(780)^167
 +E(780)^203+E(780)^227+E(780)^323+E(780)^383+E(780)^527+E(780)^587+E(780)^683
 +E(780)^707+E(780)^743
R_1(1)- tensor R_1(2)- tensor Xi_11 : 12 780 0 E(780)^7+E(780)^67+E(780)^163
 +E(780)^187+E(780)^223+E(780)^307+E(780)^343+E(780)^427+E(780)^463+E(780)^487
 +E(780)^583+E(780)^643
R_1(2)- tensor R_1(2)- tensor Xi_1 : 12 780 0 -E(780)^23-E(780)^107-E(780)^263
 -E(780)^287-E(780)^347-E(780)^407-E(780)^443-E(780)^467-E(780)^503-E(780)^563
 -E(780)^623-E(780)^647
R_1(1)- tensor R_1(1)- tensor N_3([1,3])- tensor Xi_8 : 12 840 0 
E(840)^107-E(840)^113-E(840)^137-E(840)^233+E(840)^323+E(840)^347+E(840)^443
 -E(840)^473-E(840)^617+E(840)^683-E(840)^737+E(840)^827
R_1(1)- tensor R_1(2)- tensor N_3([1,0])+ tensor Xi_8 : 12 840 0 
E(840)^11+E(840)^179+E(840)^281+E(840)^401+E(840)^449+E(840)^491+E(840)^569
 +E(840)^611+E(840)^641+E(840)^659+E(840)^779+E(840)^809
R_1(1)- tensor R_1(2)- tensor N_3([1,0])+ tensor Xi_4 : 12 840 0 
E(840)+E(840)^121+E(840)^169+E(840)^211+E(840)^289+E(840)^331+E(840)^361
 +E(840)^379+E(840)^499+E(840)^529+E(840)^571+E(840)^739
R_1(3)- tensor R_1(2)- tensor N_3([1,0])- tensor Xi_8 : 12 840 0 
-E(840)^41-E(840)^59-E(840)^89-E(840)^131-E(840)^209-E(840)^251-E(840)^299
 -E(840)^419-E(840)^521-E(840)^689-E(840)^731-E(840)^761
R_1(3)- tensor R_1(2)- tensor N_3([1,0])- tensor Xi_4 : 12 840 0 
-E(840)^19-E(840)^139-E(840)^241-E(840)^409-E(840)^451-E(840)^481-E(840)^601
 -E(840)^619-E(840)^649-E(840)^691-E(840)^769-E(840)^811
R_1(3)- tensor R_1(2)- tensor N_3([1,0])+ tensor Xi_8 : 12 840 0 
E(840)^41+E(840)^59+E(840)^89+E(840)^131+E(840)^209+E(840)^251+E(840)^299
 +E(840)^419+E(840)^521+E(840)^689+E(840)^731+E(840)^761
R_1(3)- tensor R_1(2)- tensor N_3([1,3])- tensor Xi_8 : 12 840 0 
-E(840)^41+E(840)^59-E(840)^89+E(840)^131-E(840)^209+E(840)^251+E(840)^299
 +E(840)^419-E(840)^521-E(840)^689+E(840)^731-E(840)^761
R_1(3)- tensor R_1(2)- tensor N_3([1,3])+ tensor Xi_4 : 12 840 0 
-E(840)^19-E(840)^139+E(840)^241+E(840)^409-E(840)^451+E(840)^481+E(840)^601
 -E(840)^619+E(840)^649-E(840)^691+E(840)^769-E(840)^811
R_1(1)- tensor R_1(1)- tensor N_3([1,3])- tensor Xi_4 : 12 840 0 
E(840)^43+E(840)^67+E(840)^163-E(840)^193-E(840)^337+E(840)^403-E(840)^457
 +E(840)^547+E(840)^667-E(840)^673-E(840)^697-E(840)^793
R_1(1)- tensor R_1(1)- tensor N_3([1,3])+ tensor Xi_8 : 12 840 0 
-E(840)^107+E(840)^113+E(840)^137+E(840)^233-E(840)^323-E(840)^347-E(840)^443
 +E(840)^473+E(840)^617-E(840)^683+E(840)^737-E(840)^827
R_1(1)- tensor R_1(1)- tensor N_3([1,3])+ tensor Xi_4 : 12 840 0 
-E(840)^43-E(840)^67-E(840)^163+E(840)^193+E(840)^337-E(840)^403+E(840)^457
 -E(840)^547-E(840)^667+E(840)^673+E(840)^697+E(840)^793
R_1(1)- tensor R_1(2)- tensor N_3([1,3])- tensor Xi_8 : 12 840 0 
E(840)^11+E(840)^179-E(840)^281-E(840)^401-E(840)^449+E(840)^491-E(840)^569
 +E(840)^611-E(840)^641+E(840)^659+E(840)^779-E(840)^809
R_1(1)- tensor R_1(2)- tensor N_3([1,0])- tensor Xi_8 : 12 840 0 
-E(840)^11-E(840)^179-E(840)^281-E(840)^401-E(840)^449-E(840)^491-E(840)^569
 -E(840)^611-E(840)^641-E(840)^659-E(840)^779-E(840)^809
R_1(3)- tensor R_1(2)- tensor N_3([1,3])+ tensor Xi_8 : 12 840 0 
E(840)^41-E(840)^59+E(840)^89-E(840)^131+E(840)^209-E(840)^251-E(840)^299
 -E(840)^419+E(840)^521+E(840)^689-E(840)^731+E(840)^761
R_1(1)- tensor R_1(2)- tensor N_3([1,3])+ tensor Xi_4 : 12 840 0 
E(840)+E(840)^121+E(840)^169-E(840)^211+E(840)^289-E(840)^331+E(840)^361
 -E(840)^379-E(840)^499+E(840)^529-E(840)^571-E(840)^739
R_1(3)- tensor R_1(1)- tensor N_3([1,0])+ tensor Xi_4 : 12 840 0 
E(840)^73+E(840)^97+E(840)^187+E(840)^283+E(840)^307+E(840)^313+E(840)^433
 +E(840)^523+E(840)^577+E(840)^643+E(840)^787+E(840)^817
R_1(1)- tensor R_1(1)- tensor N_3([1,0])- tensor Xi_8 : 12 840 0 
-E(840)^107-E(840)^113-E(840)^137-E(840)^233-E(840)^323-E(840)^347-E(840)^443
 -E(840)^473-E(840)^617-E(840)^683-E(840)^737-E(840)^827
R_1(1)- tensor R_1(1)- tensor N_3([1,0])- tensor Xi_4 : 12 840 0 
-E(840)^43-E(840)^67-E(840)^163-E(840)^193-E(840)^337-E(840)^403-E(840)^457
 -E(840)^547-E(840)^667-E(840)^673-E(840)^697-E(840)^793
R_1(1)- tensor R_1(1)- tensor N_3([1,0])+ tensor Xi_8 : 12 840 0 
E(840)^107+E(840)^113+E(840)^137+E(840)^233+E(840)^323+E(840)^347+E(840)^443
 +E(840)^473+E(840)^617+E(840)^683+E(840)^737+E(840)^827
R_1(3)- tensor R_1(1)- tensor N_3([1,3])+ tensor Xi_4 : 12 840 0 
E(840)^73+E(840)^97-E(840)^187-E(840)^283-E(840)^307+E(840)^313+E(840)^433
 -E(840)^523+E(840)^577-E(840)^643-E(840)^787+E(840)^817
R_1(1)- tensor R_1(2)- tensor N_3([1,3])+ tensor Xi_8 : 12 840 0 
-E(840)^11-E(840)^179+E(840)^281+E(840)^401+E(840)^449-E(840)^491+E(840)^569
 -E(840)^611+E(840)^641-E(840)^659-E(840)^779+E(840)^809
R_1(3)- tensor R_1(2)- tensor N_3([1,3])- tensor Xi_4 : 12 840 0 
E(840)^19+E(840)^139-E(840)^241-E(840)^409+E(840)^451-E(840)^481-E(840)^601
 +E(840)^619-E(840)^649+E(840)^691-E(840)^769+E(840)^811
R_1(3)- tensor R_1(1)- tensor N_3([1,3])+ tensor Xi_8 : 12 840 0 
E(840)^17-E(840)^83-E(840)^227+E(840)^257+E(840)^353+E(840)^377-E(840)^467
 -E(840)^563-E(840)^587+E(840)^593+E(840)^713-E(840)^803
R_1(1)- tensor R_1(1)- tensor N_3([1,0])+ tensor Xi_4 : 12 840 0 
E(840)^43+E(840)^67+E(840)^163+E(840)^193+E(840)^337+E(840)^403+E(840)^457
 +E(840)^547+E(840)^667+E(840)^673+E(840)^697+E(840)^793
R_1(3)- tensor R_1(1)- tensor N_3([1,0])+ tensor Xi_8 : 12 840 0 
E(840)^17+E(840)^83+E(840)^227+E(840)^257+E(840)^353+E(840)^377+E(840)^467
 +E(840)^563+E(840)^587+E(840)^593+E(840)^713+E(840)^803
R_1(3)- tensor R_1(1)- tensor N_3([1,0])- tensor Xi_4 : 12 840 0 
-E(840)^73-E(840)^97-E(840)^187-E(840)^283-E(840)^307-E(840)^313-E(840)^433
 -E(840)^523-E(840)^577-E(840)^643-E(840)^787-E(840)^817
R_1(3)- tensor R_1(1)- tensor N_3([1,0])- tensor Xi_8 : 12 840 0 
-E(840)^17-E(840)^83-E(840)^227-E(840)^257-E(840)^353-E(840)^377-E(840)^467
 -E(840)^563-E(840)^587-E(840)^593-E(840)^713-E(840)^803
R_1(3)- tensor R_1(1)- tensor N_3([1,3])- tensor Xi_8 : 12 840 0 
-E(840)^17+E(840)^83+E(840)^227-E(840)^257-E(840)^353-E(840)^377+E(840)^467
 +E(840)^563+E(840)^587-E(840)^593-E(840)^713+E(840)^803
R_1(3)- tensor R_1(1)- tensor N_3([1,3])- tensor Xi_4 : 12 840 0 
-E(840)^73-E(840)^97+E(840)^187+E(840)^283+E(840)^307-E(840)^313-E(840)^433
 +E(840)^523-E(840)^577+E(840)^643+E(840)^787-E(840)^817
R_1(1)- tensor R_1(2)- tensor N_3([1,3])- tensor Xi_4 : 12 840 0 
-E(840)-E(840)^121-E(840)^169+E(840)^211-E(840)^289+E(840)^331-E(840)^361
 +E(840)^379+E(840)^499-E(840)^529+E(840)^571+E(840)^739
R_1(3)- tensor R_1(2)- tensor N_3([1,0])+ tensor Xi_4 : 12 840 0 
E(840)^19+E(840)^139+E(840)^241+E(840)^409+E(840)^451+E(840)^481+E(840)^601
 +E(840)^619+E(840)^649+E(840)^691+E(840)^769+E(840)^811
R_1(1)- tensor R_1(2)- tensor N_3([1,0])- tensor Xi_4 : 12 840 0 
-E(840)-E(840)^121-E(840)^169-E(840)^211-E(840)^289-E(840)^331-E(840)^361
 -E(840)^379-E(840)^499-E(840)^529-E(840)^571-E(840)^739
gap> STOP_TEST( "irrdeg.tst" );
