#############################################################################
##
#A  anupqeg.tst               ANUPQ package                       Greg Gamble
##
##  Tests all but one of the ANUPQ examples.
##  Execute this file with `Test( "anupqeg.tst" );'.
##  This is a *big* test, taking some 40 minutes on a *fast* (1GHz) machine.
##  The number of GAPstones returned at the end do not mean much as  they  do
##  not measure the time spent by the `pq' binary.
##

gap> START_TEST( "Testing ANUPQ examples" );
gap> SetInfoLevel(InfoANUPQ, 1);
gap> examples := AllPqExamples();
[ "11gp-3-Engel-Id", "11gp-3-Engel-Id-i", "11gp-PG-i", "11gp-Rel-i", 
  "11gp-SP-a-Rel-1-i", "11gp-SP-a-Rel-i", "11gp-SP-a-i", "11gp-SP-b-Rel-i", 
  "11gp-SP-b-i", "11gp-SP-c-Rel-i", "11gp-a-Rel-i", "11gp-i", "2gp-PG-2-i", 
  "2gp-PG-3-i", "2gp-PG-4-i", "2gp-PG-e4-i", "2gp-PG-i", "2gp-Rel", 
  "2gp-Rel-i", "2gp-SP-1-Rel-i", "2gp-SP-2-Rel-i", "2gp-SP-3-Rel-i", 
  "2gp-SP-4-Rel-i", "2gp-SP-Rel-i", "2gp-SP-d-Rel-i", "2gp-a-Rel-i", 
  "3gp-PG-4-i", "3gp-PG-i", "3gp-PG-x-1-i", "3gp-PG-x-i", "3gp-Rel-i", 
  "3gp-SP-1-Rel-i", "3gp-SP-2-Rel-i", "3gp-SP-3-Rel-i", "3gp-SP-4-Rel-i", 
  "3gp-SP-Rel-i", "3gp-a-Rel", "3gp-a-Rel-i", "3gp-a-x-Rel-i", 
  "3gp-maxoccur-Rel-i", "5gp-PG-i", "5gp-Rel-i", "5gp-SP-Rel-i", 
  "5gp-SP-a-Rel-i", "5gp-SP-b-Rel-i", "5gp-SP-big-Rel-i", "5gp-SP-d-Rel-i", 
  "5gp-a-Rel-i", "5gp-b-Rel-i", "5gp-c-Rel-i", "5gp-maxoccur-Rel-i", 
  "5gp-metabelian-Rel", "5gp-metabelian-Rel-i", "7gp-PG-i", "7gp-Rel-i", 
  "7gp-SP-Rel-i", "7gp-SP-a-Rel-i", "7gp-SP-b-Rel-i", "B2-4", "B2-4-Id", 
  "B2-4-SP-i", "B2-5", "B2-5-i", "B2-8-i", "B4-4-a-i", "B4-4-i", "B5-4.g", 
  "B5-5-Engel3-Id", "EpimorphismStandardPresentation", 
  "EpimorphismStandardPresentation-i", "F2-5-i", "G2-SP-Rel-i", 
  "G3-SP-Rel-i", "G5-SP-Rel-i", "G5-SP-a-Rel-i", "IsIsomorphicPGroup-ni", 
  "Nott-APG-Rel-i", "Nott-PG-Rel-i", "Nott-SP-Rel-i", "Pq", "Pq-ni", 
  "PqDescendants-1", "PqDescendants-1-i", "PqDescendants-2", 
  "PqDescendants-3", "PqDescendants-treetraverse-i", 
  "PqDescendantsTreeCoclassOne-16-i", "PqDescendantsTreeCoclassOne-25-i", 
  "PqDescendantsTreeCoclassOne-9-i", "PqEpimorphism", "PqPCover", 
  "PqSupplementInnerAutomorphisms", "R2-5-i", "R2-5-x-i", 
  "StandardPresentation", "StandardPresentation-i", "gp-256-SP-Rel-i" ]
gap> RemoveSet(examples, "EpimorphismStandardPresentation-i");
gap> nexamples := Length( examples );
96
gap> ##Example: "11gp-3-Engel-Id" . . . 3-Engel group for prime 11
gap> ##Non-trivial example of using the `Identities' option
gap> F := FreeGroup("a", "b"); a := F.1; b := F.2;
<free group on the generators [ a, b ]>
a
b
gap> G := F/[ a^11, b^11 ];
<fp group on the generators [ a, b ]>
gap> # All word pairs u, v in the pc generators of the 11-quotient Q of G 
gap> # must satisfy the Engel identity: [u, v, v, v] = 1.
gap> f := function(u, v) return PqLeftNormComm( [u, v, v, v] ); end;
function( u, v ) ... end
gap> Q := Pq( G : Prime := 11, Identities := [ f ] );
#I  Class 1 with 2 generators.
#I  Class 2 with 3 generators.
#I  Class 3 with 5 generators.
#I  Class 3 with 5 generators.
<pc group of size 161051 with 5 generators>
gap> # We do a ``sample'' check that pairs of elements of Q do satisfy
gap> # the given identity:
gap> f( Random(Q), Random(Q) );
<identity> of ...
gap> f( Q.1, Q.2 );
<identity> of ...
gap> # Executing interactive variant of example: "11gp-3-Engel-Id"
gap> ##Example: "11gp-3-Engel-Id" . . . 3-Engel group for prime 11
gap> ##Non-trivial example of using the `Identities' option
gap> F := FreeGroup("a", "b"); a := F.1; b := F.2;
<free group on the generators [ a, b ]>
a
b
gap> G := F/[ a^11, b^11 ];
<fp group on the generators [ a, b ]>
gap> # All word pairs u, v in the pc generators of the 11-quotient Q of G 
gap> # must satisfy the Engel identity: [u, v, v, v] = 1.
gap> f := function(u, v) return PqLeftNormComm( [u, v, v, v] ); end;
function( u, v ) ... end
gap> procId := PqStart( G );
1
gap> Q := Pq( procId : Prime := 11, Identities := [ f ] );
#I  Class 1 with 2 generators.
#I  Class 2 with 3 generators.
#I  Class 3 with 5 generators.
#I  Class 3 with 5 generators.
<pc group of size 161051 with 5 generators>
gap> # We do a ``sample'' check that pairs of elements of Q do satisfy
gap> # the given identity:
gap> f( Random(Q), Random(Q) );
<identity> of ...
gap> f( Q.1, Q.2 );
<identity> of ...
gap> ##Example: "11gp-3-Engel-Id-i" . . . 3-Engel grp for prime 11
gap> ##Variation of "11gp-3-Engel-Id" broken down into its lower-level component
gap> ##command parts.
gap> F := FreeGroup("a", "b"); a := F.1; b := F.2;
<free group on the generators [ a, b ]>
a
b
gap> G := F/[ a^11, b^11 ];
<fp group on the generators [ a, b ]>
gap> # All word pairs u, v in the pc generators of the 11-quotient Q of G 
gap> # must satisfy the Engel identity: [u, v, v, v] = 1.
gap> f := function(u, v) return PqLeftNormComm( [u, v, v, v] ); end;
function( u, v ) ... end
gap> procId := PqStart( G : Prime := 11 );
2
gap> PqPcPresentation( procId : ClassBound := 1);
gap> PqEvaluateIdentities( procId : Identities := [f] );
#I  Class 1 with 2 generators.
gap> for c in [2 .. 4] do
>   PqNextClass( procId : Identities := [] ); #reset `Identities' option
>   PqEvaluateIdentities( procId : Identities := [f] );
> od;
#I  Class 2 with 3 generators.
#I  Class 3 with 5 generators.
#I  Class 3 with 5 generators.
gap> Q := PqCurrentGroup( procId );
<pc group of size 161051 with 5 generators>
gap> # We do a ``sample'' check that pairs of elements of Q do satisfy
gap> # the given identity:
gap> f( Random(Q), Random(Q) );
<identity> of ...
gap> f( Q.1, Q.2 );
<identity> of ...
gap> ##Example: "11gp-PG-i" . . . based on: examples/pga_11gp
gap> ##Descendants of C11 x C11 x C11
gap> F := FreeGroup("a", "b", "c");
<free group on the generators [ a, b, c ]>
gap> procId := PqStart(F : Prime := 11);
3
gap> PqPcPresentation(procId : ClassBound := 1, 
>                           OutputLevel := 1);
#I  Lower exponent-11 central series for [grp]
#I  Group: [grp] to lower exponent-11 central class 1 has order 11^3
gap> PqComputePCover(procId);
#I  Group: [grp] to lower exponent-11 central class 2 has order 11^9
gap> PqPGSupplyAutomorphisms(procId, [ [[ 2, 0, 0],
>                                    [ 0, 1, 0],
>                                    [ 0, 0, 1]],
> 
>                                   [[10, 0, 1],
>                                    [10, 0, 0],
>                                    [ 0,10, 0]] ]);
gap> PqPGConstructDescendants(procId : ClassBound := 2,
>                                   CapableDescendants,
>                                   StepSize := 1,
>                                   RankInitialSegmentSubgroups := 3);
#I  **************************************************
#I  Starting group: [grp]
#I  Order: 11^3
#I  Nuclear rank: 6
#I  11-multiplicator rank: 6
#I  # of immediate descendants of order 11^4 is 4
#I  # of capable immediate descendants is 2
#I  **************************************************
2
gap> PqQuitAll();
gap> ##Example: "11gp-Rel-i" . . . based on: examples/11gp
gap> ##(equivalent to "11gp-i" example but uses `Relators' option)
gap> F := FreeGroup("a", "b", "c");
<free group on the generators [ a, b, c ]>
gap> rels := ["[b, a, a, b, c]^11", "[a, b, b, a, b, c]^11", "(a * b)^11"];
[ "[b, a, a, b, c]^11", "[a, b, b, a, b, c]^11", "(a * b)^11" ]
gap> procId := PqStart(F : Prime := 11, Relators := rels);
1
gap> PqPcPresentation(procId : ClassBound := 7, 
>                           OutputLevel := 1);
#I  Lower exponent-11 central series for [grp]
#I  Group: [grp] to lower exponent-11 central class 1 has order 11^3
#I  Group: [grp] to lower exponent-11 central class 2 has order 11^8
#I  Group: [grp] to lower exponent-11 central class 3 has order 11^19
#I  Group: [grp] to lower exponent-11 central class 4 has order 11^42
#I  Group: [grp] to lower exponent-11 central class 5 has order 11^98
#I  Group: [grp] to lower exponent-11 central class 6 has order 11^228
#I  Group: [grp] to lower exponent-11 central class 7 has order 11^563
gap> PqSavePcPresentation(procId, ANUPQData.outfile);
gap> ##Example: "11gp-SP-a-Rel-1-i" . . . based on: isom/11gp_a.com
gap> ##(like "11gp-SP-a-Rel-i" but the initial input presentation
gap> ## is only to class 1).
gap> F := FreeGroup("a", "b");
<free group on the generators [ a, b ]>
gap> rels := ["a^11", "b^11*[b, a, a]^-2", "[b, a, b, b, b, b]"];
[ "a^11", "b^11*[b, a, a]^-2", "[b, a, b, b, b, b]" ]
gap> procId := PqStart(F : Prime := 11, Relators := rels);
2
gap> PqSetOutputLevel(procId, 0);
gap> PqSPComputePcpAndPCover(procId : ClassBound := 1);
gap> PqSPStandardPresentation(procId, [ [[1,0],
>                                     [0,1]],
> 
>                                    [[1,0],
>                                     [0,1]],
> 
>                                    [[1,0],
>                                     [0,1]],
> 
>                                    [[1,0],
>                                     [3,1]],
> 
>                                    [[1,0],
>                                     [9,3]],
> 
>                                    [[1,0],
>                                     [6,6]],
> 
>                                    [[10,0],
>                                     [2,1]] ]
> 
>                          : # options
>                            ClassBound := 19,
>                            PcgsAutomorphisms);
gap> ##Example: "11gp-SP-a-Rel-i" . . . based on: isom/11gp_a.com
gap> ##(equivalent to "11gp-SP-a-i" but uses the `Relators' option)
gap> F := FreeGroup("a", "b");
<free group on the generators [ a, b ]>
gap> rels := ["a^11", "b^11*[b, a, a]^-2", "[b, a, b, b, b, b]"];
[ "a^11", "b^11*[b, a, a]^-2", "[b, a, b, b, b, b]" ]
gap> procId := PqStart(F : Prime := 11, Relators := rels);
3
gap> PqSetOutputLevel(procId, 0);
gap> PqSPComputePcpAndPCover(procId : ClassBound := 3);
gap> PqSPStandardPresentation(procId, [ [[1,0,0,0,1],
>                                     [0,1,0,0,0]],
> 
>                                    [[1,0,0,0,0],
>                                     [0,1,0,1,0]],
> 
>                                    [[1,0,0,0,0],
>                                     [0,1,0,0,1]],
> 
>                                    [[1,0,0,0,0],
>                                     [3,1,0,0,0]],
> 
>                                    [[1,0,0,0,0],
>                                     [9,3,0,0,0]],
> 
>                                    [[1,0,0,0,0],
>                                     [6,6,0,0,0]],
> 
>                                    [[10,0,0,0,0],
>                                     [2,1,0,0,0]] ]
> 
>                          : # options
>                            ClassBound := 19,
>                            PcgsAutomorphisms);
gap> PqQuitAll();
gap> ##Example: "11gp-SP-a-i" . . . based on: isom/11gp_a.com
gap> F := FreeGroup("a", "b"); a := F.1; b := F.2;
<free group on the generators [ a, b ]>
a
b
gap> R := [a^11, b^11/PqLeftNormComm([b, a, a])^2, 
>       PqLeftNormComm([b, a, b, b, b, b])];;
gap> procId := PqStart(F/R : Prime := 11);
1
gap> PqSetOutputLevel(procId, 0);
gap> PqSPComputePcpAndPCover(procId : ClassBound := 3);
gap> PqSPStandardPresentation(procId, [ [[1,0,0,0,1],
>                                     [0,1,0,0,0]],
> 
>                                    [[1,0,0,0,0],
>                                     [0,1,0,1,0]],
> 
>                                    [[1,0,0,0,0],
>                                     [0,1,0,0,1]],
> 
>                                    [[1,0,0,0,0],
>                                     [3,1,0,0,0]],
> 
>                                    [[1,0,0,0,0],
>                                     [9,3,0,0,0]],
> 
>                                    [[1,0,0,0,0],
>                                     [6,6,0,0,0]],
> 
>                                    [[10,0,0,0,0],
>                                     [2,1,0,0,0]] ]
> 
>                          : # options
>                            ClassBound := 19,
>                            PcgsAutomorphisms);
gap> ##Example: "11gp-SP-b-Rel-i" . . . based on: isom/11gp_b.com
gap> ##(equivalent to "11gp-SP-b-i" but uses the `Relators' option)
gap> F := FreeGroup("a", "b", "c");
<free group on the generators [ a, b, c ]>
gap> rels := ["a^11", "b^11", "c^11", "[b, a, a, a, b, a]", 
>          "[c, a]", "[c, b]", "[b, a, b]"];
[ "a^11", "b^11", "c^11", "[b, a, a, a, b, a]", "[c, a]", "[c, b]", 
  "[b, a, b]" ]
gap> procId := PqStart(F : Prime := 11, Relators := rels);
2
gap> PqSetOutputLevel(procId, 0);
gap> PqSPComputePcpAndPCover(procId : ClassBound := 3);
gap> PqSPStandardPresentation(procId, [ [[1,0,0,0,0],
>                                     [0,1,0,0,1],
>                                     [0,0,1,0,0]],
> 
>                                    [[1,0,0,0,0],
>                                     [0,1,0,0,0],
>                                     [0,0,1,0,1]],
> 
>                                    [[1,0,9,0,0],
>                                     [0,1,0,0,0],
>                                     [0,0,1,0,0]],
> 
>                                    [[1,7,8,0,0],
>                                     [0,1,0,0,0],
>                                     [0,0,1,0,0]],
> 
>                                    [[10,0,0,0,0],
>                                     [0,1,0,0,0],
>                                     [0,0,1,0,0]],
> 
>                                    [[2,0,0,0,0],
>                                     [0,1,0,0,0],
>                                     [0,0,1,0,0]],
> 
>                                    [[1,0,8,0,0],
>                                     [0,1,3,0,0],
>                                     [0,0,1,0,0]],
> 
>                                    [[1,0,9,0,0],
>                                     [0,1,0,0,0],
>                                     [0,0,3,0,0]],
> 
>                                    [[1,0,2,0,0],
>                                     [0,1,0,0,0],
>                                     [0,0,10,0,0]],
> 
>                                    [[1,9,10,0,0],
>                                     [0,3,7,0,0],
>                                     [0,0,6,0,0]],
> 
>                                    [[1,5,9,0,0],
>                                     [0,7,4,0,0],
>                                     [0,0,10,0,0]]]
> 
>                          : # options
>                            ClassBound := 8,
>                            PcgsAutomorphisms);
gap> ##Example: "11gp-SP-b-i" . . . based on: isom/11gp_b.com
gap> F := FreeGroup("a", "b", "c"); a := F.1; b := F.2; c := F.3;
<free group on the generators [ a, b, c ]>
a
b
c
gap> R := [a^11, b^11, c^11, PqLeftNormComm([b, a, a, a, b, a]),
>       Comm(c, a), Comm(c, b), PqLeftNormComm([b, a, b])];;
gap> procId := PqStart(F/R : Prime := 11);
3
gap> PqSetOutputLevel(procId, 0);
gap> PqSPComputePcpAndPCover(procId : ClassBound := 3);
gap> PqSPStandardPresentation(procId, [ [[1,0,0,0,0],
>                                     [0,1,0,0,1],
>                                     [0,0,1,0,0]],
> 
>                                    [[1,0,0,0,0],
>                                     [0,1,0,0,0],
>                                     [0,0,1,0,1]],
> 
>                                    [[1,0,9,0,0],
>                                     [0,1,0,0,0],
>                                     [0,0,1,0,0]],
> 
>                                    [[1,7,8,0,0],
>                                     [0,1,0,0,0],
>                                     [0,0,1,0,0]],
> 
>                                    [[10,0,0,0,0],
>                                     [0,1,0,0,0],
>                                     [0,0,1,0,0]],
> 
>                                    [[2,0,0,0,0],
>                                     [0,1,0,0,0],
>                                     [0,0,1,0,0]],
> 
>                                    [[1,0,8,0,0],
>                                     [0,1,3,0,0],
>                                     [0,0,1,0,0]],
> 
>                                    [[1,0,9,0,0],
>                                     [0,1,0,0,0],
>                                     [0,0,3,0,0]],
> 
>                                    [[1,0,2,0,0],
>                                     [0,1,0,0,0],
>                                     [0,0,10,0,0]],
> 
>                                    [[1,9,10,0,0],
>                                     [0,3,7,0,0],
>                                     [0,0,6,0,0]],
> 
>                                    [[1,5,9,0,0],
>                                     [0,7,4,0,0],
>                                     [0,0,10,0,0]]]
> 
>                          : # options
>                            ClassBound := 8,
>                            PcgsAutomorphisms);
gap> PqQuitAll();
gap> ##Example: "11gp-SP-c-Rel-i" . . . based on: isom/11gp_c.com
gap> F := FreeGroup("a", "b", "c");
<free group on the generators [ a, b, c ]>
gap> rels := ["a^11", "b^11", "c^11", "[b, a, a, a, b]", 
>          "[c, a]", "[c, b]", "[b, a, b]"];
[ "a^11", "b^11", "c^11", "[b, a, a, a, b]", "[c, a]", "[c, b]", "[b, a, b]" ]
gap> procId := PqStart(F : Prime := 11, Relators := rels);
1
gap> PqSPComputePcpAndPCover(procId : ClassBound := 3);
gap> PqSPStandardPresentation(procId, [ [[1,0,0,0,0],
>                                     [0,1,0,0,1],
>                                     [0,0,1,0,0]],
> 
>                                    [[1,0,0,0,0],
>                                     [0,1,0,0,0],
>                                     [0,0,1,0,1]],
> 
>                                    [[1,0,9,0,0],
>                                     [0,1,0,0,0],
>                                     [0,0,1,0,0]],
> 
>                                    [[1,7,8,0,0],
>                                     [0,1,0,0,0],
>                                     [0,0,1,0,0]],
> 
>                                    [[10,0,0,0,0],
>                                     [0,1,0,0,0],
>                                     [0,0,1,0,0]],
> 
>                                    [[2,0,0,0,0],
>                                     [0,1,0,0,0],
>                                     [0,0,1,0,0]],
> 
>                                    [[1,0,8,0,0],
>                                     [0,1,3,0,0],
>                                     [0,0,1,0,0]],
> 
>                                    [[1,0,9,0,0],
>                                     [0,1,0,0,0],
>                                     [0,0,3,0,0]],
> 
>                                    [[1,0,2,0,0],
>                                     [0,1,0,0,0],
>                                     [0,0,10,0,0]],
> 
>                                    [[1,9,10,0,0],
>                                     [0,3,7,0,0],
>                                     [0,0,6,0,0]],
> 
>                                    [[1,5,9,0,0],
>                                     [0,7,4,0,0],
>                                     [0,0,10,0,0]]]
> 
>                          : # options
>                            ClassBound := 8,#for 9 perm.deg.>2^31, pq dies
>                            PcgsAutomorphisms);
gap> ##Example: "11gp-a-Rel-i" . . . based on: examples/11gpA
gap> F := FreeGroup("a", "b");
<free group on the generators [ a, b ]>
gap> rels := ["[b, a, a, b, b]^11", "[a, b, b, a, b, b]^11", "(a * b)^11"];
[ "[b, a, a, b, b]^11", "[a, b, b, a, b, b]^11", "(a * b)^11" ]
gap> procId := PqStart(F : Prime := 11, Relators := rels);
2
gap> PqPcPresentation(procId : ClassBound := 8, 
>                           OutputLevel := 1);
#I  Lower exponent-11 central series for [grp]
#I  Group: [grp] to lower exponent-11 central class 1 has order 11^2
#I  Group: [grp] to lower exponent-11 central class 2 has order 11^4
#I  Group: [grp] to lower exponent-11 central class 3 has order 11^7
#I  Group: [grp] to lower exponent-11 central class 4 has order 11^11
#I  Group: [grp] to lower exponent-11 central class 5 has order 11^18
#I  Group: [grp] to lower exponent-11 central class 6 has order 11^28
#I  Group: [grp] to lower exponent-11 central class 7 has order 11^47
#I  Group: [grp] to lower exponent-11 central class 8 has order 11^78
gap> PqSavePcPresentation(procId, ANUPQData.outfile);
gap> ##Example: "11gp-i" . . . based on: examples/11gp
gap> F := FreeGroup("a", "b", "c"); a := F.1; b := F.2; c := F.3;
<free group on the generators [ a, b, c ]>
a
b
c
gap> R := [PqLeftNormComm([b, a, a, b, c])^11, 
>       PqLeftNormComm([a, b, b, a, b, c])^11, (a * b)^11];;
gap> procId := PqStart(F/R : Prime := 11);
3
gap> PqPcPresentation(procId : ClassBound := 7, 
>                           OutputLevel := 1);
#I  Lower exponent-11 central series for [grp]
#I  Group: [grp] to lower exponent-11 central class 1 has order 11^3
#I  Group: [grp] to lower exponent-11 central class 2 has order 11^8
#I  Group: [grp] to lower exponent-11 central class 3 has order 11^19
#I  Group: [grp] to lower exponent-11 central class 4 has order 11^42
#I  Group: [grp] to lower exponent-11 central class 5 has order 11^98
#I  Group: [grp] to lower exponent-11 central class 6 has order 11^228
#I  Group: [grp] to lower exponent-11 central class 7 has order 11^563
gap> PqSavePcPresentation(procId, ANUPQData.outfile);
gap> PqQuitAll();
gap> ##Example: "2gp-PG-2-i" . . . based on: examples/pga_example
gap> ##All class 3 descendants of C2 x C2 with extensive output
gap> F := FreeGroup("a", "b");
<free group on the generators [ a, b ]>
gap> procId := PqStart(F : Prime := 2);
1
gap> PqPcPresentation(procId : ClassBound := 1, 
>                           OutputLevel := 1);
#I  Lower exponent-2 central series for [grp]
#I  Group: [grp] to lower exponent-2 central class 1 has order 2^2
gap> PqComputePCover(procId);
#I  Group: [grp] to lower exponent-2 central class 2 has order 2^5
gap> PqPGSupplyAutomorphisms(procId, [ [[0,1],
>                                    [1,1]],
> 
>                                   [[0,1],
>                                    [1,0]] ]);
gap> PqPGConstructDescendants(procId : ClassBound := 3,
>                                   PcgsAutomorphisms,
>                                   CustomiseOutput := rec(group := [,,1],
>                                                          autgroup := [,1]));
#I  **************************************************
#I  Starting group: [grp]
#I  Order: 2^2
#I  Nuclear rank: 3
#I  2-multiplicator rank: 3
#I  Group: [grp] #1;1 to lower exponent-2 central class 2 has order 2^3
#I  Class 1
#I  1 is defined on image of defining generator 1
#I  2 is defined on image of defining generator 2
#I  Class 2
#I  3 is defined on 1^2 = 1 1 
#I  Non-trivial powers:
#I   .1^2 = .3
#I  Non-trivial commutators:
#I  Automorphism 1:
#I  Generator  1 --> 1 0 1 
#I  Generator  2 --> 0 1 0 
#I  Automorphism 2:
#I  Generator  1 --> 1 0 0 
#I  Generator  2 --> 0 1 1 
#I  Number of stabiliser generators is 1
#I  Automorphism 1:
#I  Generator  1 --> 1 1 0 
#I  Generator  2 --> 0 1 1 
#I  Group: [grp] #2;1 to lower exponent-2 central class 2 has order 2^3
#I  Class 1
#I  1 is defined on image of defining generator 1
#I  2 is defined on image of defining generator 2
#I  Class 2
#I  3 is defined on [2, 1] = 2 1 
#I  Non-trivial powers:
#I  Non-trivial commutators:
#I  [ .2, .1 ] = .3
#I  Number of stabiliser generators is 1
#I  Automorphism 1:
#I  Generator  1 --> 0 1 0 
#I  Generator  2 --> 1 0 0 
#I  Group: [grp] #3;1 to lower exponent-2 central class 2 has order 2^3
#I  Class 1
#I  1 is defined on image of defining generator 1
#I  2 is defined on image of defining generator 2
#I  Class 2
#I  3 is defined on [2, 1] = 2 1 
#I  Non-trivial powers:
#I   .1^2 = .3
#I   .2^2 = .3
#I  Non-trivial commutators:
#I  [ .2, .1 ] = .3
#I  Number of stabiliser generators is 2
#I  Automorphism 1:
#I  Generator  1 --> 0 1 0 
#I  Generator  2 --> 1 1 0 
#I  Automorphism 2:
#I  Generator  1 --> 0 1 0 
#I  Generator  2 --> 1 0 0 
#I  # of immediate descendants of order 2^3 is 3
#I  # of capable immediate descendants is 2
#I  Group: [grp] #4;2 to lower exponent-2 central class 2 has order 2^4
#I  Class 1
#I  1 is defined on image of defining generator 1
#I  2 is defined on image of defining generator 2
#I  Class 2
#I  3 is defined on 1^2 = 1 1 
#I  4 is defined on 2^2 = 2 2 
#I  Non-trivial powers:
#I   .1^2 = .3
#I   .2^2 = .4
#I  Non-trivial commutators:
#I  Automorphism 1:
#I  Generator  1 --> 1 0 1 0 
#I  Generator  2 --> 0 1 0 0 
#I  Automorphism 2:
#I  Generator  1 --> 1 0 0 1 
#I  Generator  2 --> 0 1 0 0 
#I  Automorphism 3:
#I  Generator  1 --> 1 0 0 0 
#I  Generator  2 --> 0 1 1 0 
#I  Automorphism 4:
#I  Generator  1 --> 1 0 0 0 
#I  Generator  2 --> 0 1 0 1 
#I  Number of stabiliser generators is 2
#I  Automorphism 1:
#I  Generator  1 --> 0 1 0 0 
#I  Generator  2 --> 1 1 0 0 
#I  Automorphism 2:
#I  Generator  1 --> 0 1 0 0 
#I  Generator  2 --> 1 0 0 0 
#I  Group: [grp] #5;2 to lower exponent-2 central class 2 has order 2^4
#I  Class 1
#I  1 is defined on image of defining generator 1
#I  2 is defined on image of defining generator 2
#I  Class 2
#I  3 is defined on [2, 1] = 2 1 
#I  4 is defined on 1^2 = 1 1 
#I  Non-trivial powers:
#I   .1^2 = .4
#I  Non-trivial commutators:
#I  [ .2, .1 ] = .3
#I  Automorphism 1:
#I  Generator  1 --> 1 0 0 1 
#I  Generator  2 --> 0 1 0 0 
#I  Automorphism 2:
#I  Generator  1 --> 1 0 0 0 
#I  Generator  2 --> 0 1 0 1 
#I  Number of stabiliser generators is 1
#I  Automorphism 1:
#I  Generator  1 --> 1 1 1 0 
#I  Generator  2 --> 0 1 1 1 
#I  Group: [grp] #6;2 to lower exponent-2 central class 2 has order 2^4
#I  Class 1
#I  1 is defined on image of defining generator 1
#I  2 is defined on image of defining generator 2
#I  Class 2
#I  3 is defined on [2, 1] = 2 1 
#I  4 is defined on 1^2 = 1 1 
#I  Non-trivial powers:
#I   .1^2 = .4
#I   .2^2 = .3
#I  Non-trivial commutators:
#I  [ .2, .1 ] = .3
#I  Automorphism 1:
#I  Generator  1 --> 1 0 0 1 
#I  Generator  2 --> 0 1 0 0 
#I  Automorphism 2:
#I  Generator  1 --> 1 0 0 0 
#I  Generator  2 --> 0 1 0 1 
#I  Number of stabiliser generators is 1
#I  Automorphism 1:
#I  Generator  1 --> 1 1 1 0 
#I  Generator  2 --> 0 1 1 1 
#I  # of immediate descendants of order 2^4 is 3
#I  # of capable immediate descendants is 3
#I  Group: [grp] #7;3 to lower exponent-2 central class 2 has order 2^5
#I  Class 1
#I  1 is defined on image of defining generator 1
#I  2 is defined on image of defining generator 2
#I  Class 2
#I  3 is defined on [2, 1] = 2 1 
#I  4 is defined on 1^2 = 1 1 
#I  5 is defined on 2^2 = 2 2 
#I  Non-trivial powers:
#I   .1^2 = .4
#I   .2^2 = .5
#I  Non-trivial commutators:
#I  [ .2, .1 ] = .3
#I  Automorphism 1:
#I  Generator  1 --> 1 0 0 1 0 
#I  Generator  2 --> 0 1 0 0 0 
#I  Automorphism 2:
#I  Generator  1 --> 1 0 0 0 1 
#I  Generator  2 --> 0 1 0 0 0 
#I  Automorphism 3:
#I  Generator  1 --> 1 0 0 0 0 
#I  Generator  2 --> 0 1 0 1 0 
#I  Automorphism 4:
#I  Generator  1 --> 1 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 1 
#I  Number of stabiliser generators is 2
#I  Automorphism 1:
#I  Generator  1 --> 0 1 0 0 0 
#I  Generator  2 --> 1 1 0 0 0 
#I  Automorphism 2:
#I  Generator  1 --> 0 1 0 0 0 
#I  Generator  2 --> 1 0 0 0 0 
#I  # of immediate descendants of order 2^5 is 1
#I  # of capable immediate descendants is 1
#I  **************************************************
#I  **************************************************
#I  Starting group: [grp] #1;1
#I  Order: 2^3
#I  Nuclear rank: 1
#I  2-multiplicator rank: 3
#I  Group: [grp] #1;1 #1;1 to lower exponent-2 central class 3 has order 2^4
#I  Class 1
#I  1 is defined on image of defining generator 1
#I  2 is defined on image of defining generator 2
#I  Class 2
#I  3 is defined on 1^2 = 1 1 
#I  Class 3
#I  4 is defined on 3^2 = 1 1 1 
#I  Non-trivial powers:
#I   .1^2 = .3
#I   .3^2 = .4
#I  Non-trivial commutators:
#I  Automorphism 1:
#I  Generator  1 --> 1 0 0 1 
#I  Generator  2 --> 0 1 0 0 
#I  Automorphism 2:
#I  Generator  1 --> 1 0 0 0 
#I  Generator  2 --> 0 1 0 1 
#I  Number of stabiliser generators is 2
#I  Automorphism 1:
#I  Generator  1 --> 1 0 1 0 
#I  Generator  2 --> 0 1 0 0 
#I  Automorphism 2:
#I  Generator  1 --> 1 1 0 0 
#I  Generator  2 --> 0 1 0 1 
#I  Group: [grp] #1;1 #2;1 to lower exponent-2 central class 3 has order 2^4
#I  Class 1
#I  1 is defined on image of defining generator 1
#I  2 is defined on image of defining generator 2
#I  Class 2
#I  3 is defined on 1^2 = 1 1 
#I  Class 3
#I  4 is defined on 3^2 = 1 1 1 
#I  Non-trivial powers:
#I   .1^2 = .3
#I   .3^2 = .4
#I  Non-trivial commutators:
#I  [ .2, .1 ] = .4
#I  Automorphism 1:
#I  Generator  1 --> 1 0 0 1 
#I  Generator  2 --> 0 1 0 0 
#I  Automorphism 2:
#I  Generator  1 --> 1 0 0 0 
#I  Generator  2 --> 0 1 0 1 
#I  Number of stabiliser generators is 2
#I  Automorphism 1:
#I  Generator  1 --> 1 0 1 0 
#I  Generator  2 --> 0 1 0 0 
#I  Automorphism 2:
#I  Generator  1 --> 1 1 0 0 
#I  Generator  2 --> 0 1 0 0 
#I  # of immediate descendants of order 2^4 is 2
#I  # of capable immediate descendants is 1
#I  **************************************************
#I  Starting group: [grp] #2;1
#I  Order: 2^3
#I  Nuclear rank: 1
#I  2-multiplicator rank: 3
#I  Group: [grp] #2;1 #1;1 to lower exponent-2 central class 3 has order 2^4
#I  Class 1
#I  1 is defined on image of defining generator 1
#I  2 is defined on image of defining generator 2
#I  Class 2
#I  3 is defined on [2, 1] = 2 1 
#I  Class 3
#I  4 is defined on [3, 1] = 2 1 1 
#I  Non-trivial powers:
#I   .3^2 = .4
#I  Non-trivial commutators:
#I  [ .2, .1 ] = .3
#I  [ .3, .1 ] = .4
#I  [ .3, .2 ] = .4
#I  Automorphism 1:
#I  Generator  1 --> 1 0 0 0 
#I  Generator  2 --> 0 1 0 1 
#I  Number of stabiliser generators is 1
#I  Automorphism 1:
#I  Generator  1 --> 0 1 0 0 
#I  Generator  2 --> 1 0 0 0 
#I  Group: [grp] #2;1 #2;1 to lower exponent-2 central class 3 has order 2^4
#I  Class 1
#I  1 is defined on image of defining generator 1
#I  2 is defined on image of defining generator 2
#I  Class 2
#I  3 is defined on [2, 1] = 2 1 
#I  Class 3
#I  4 is defined on [3, 1] = 2 1 1 
#I  Non-trivial powers:
#I   .1^2 = .4
#I   .3^2 = .4
#I  Non-trivial commutators:
#I  [ .2, .1 ] = .3
#I  [ .3, .1 ] = .4
#I  [ .3, .2 ] = .4
#I  Automorphism 1:
#I  Generator  1 --> 1 0 0 0 
#I  Generator  2 --> 0 1 0 1 
#I  Number of stabiliser generators is 0
#I  Group: [grp] #2;1 #3;1 to lower exponent-2 central class 3 has order 2^4
#I  Class 1
#I  1 is defined on image of defining generator 1
#I  2 is defined on image of defining generator 2
#I  Class 2
#I  3 is defined on [2, 1] = 2 1 
#I  Class 3
#I  4 is defined on [3, 1] = 2 1 1 
#I  Non-trivial powers:
#I   .1^2 = .4
#I   .2^2 = .4
#I   .3^2 = .4
#I  Non-trivial commutators:
#I  [ .2, .1 ] = .3
#I  [ .3, .1 ] = .4
#I  [ .3, .2 ] = .4
#I  Automorphism 1:
#I  Generator  1 --> 1 0 0 0 
#I  Generator  2 --> 0 1 0 1 
#I  Number of stabiliser generators is 1
#I  Automorphism 1:
#I  Generator  1 --> 0 1 0 0 
#I  Generator  2 --> 1 0 0 0 
#I  # of immediate descendants of order 2^4 is 3
#I  # of capable immediate descendants is 1
#I  **************************************************
#I  Starting group: [grp] #3;1
#I  Order: 2^3
#I  Nuclear rank: 0
#I  2-multiplicator rank: 1
#I  Group [grp] #3;1 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #4;2
#I  Order: 2^4
#I  Nuclear rank: 2
#I  2-multiplicator rank: 3
#I  Group: [grp] #4;2 #1;1 to lower exponent-2 central class 3 has order 2^5
#I  Class 1
#I  1 is defined on image of defining generator 1
#I  2 is defined on image of defining generator 2
#I  Class 2
#I  3 is defined on 1^2 = 1 1 
#I  4 is defined on 2^2 = 2 2 
#I  Class 3
#I  5 is defined on 3^2 = 1 1 1 
#I  Non-trivial powers:
#I   .1^2 = .3
#I   .2^2 = .4
#I   .3^2 = .5
#I  Non-trivial commutators:
#I  Automorphism 1:
#I  Generator  1 --> 1 0 0 0 1 
#I  Generator  2 --> 0 1 0 0 0 
#I  Automorphism 2:
#I  Generator  1 --> 1 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 1 
#I  Number of stabiliser generators is 5
#I  Automorphism 1:
#I  Generator  1 --> 1 0 1 0 0 
#I  Generator  2 --> 0 1 0 0 0 
#I  Automorphism 2:
#I  Generator  1 --> 1 0 0 1 0 
#I  Generator  2 --> 0 1 0 0 0 
#I  Automorphism 3:
#I  Generator  1 --> 1 0 0 0 0 
#I  Generator  2 --> 0 1 1 0 0 
#I  Automorphism 4:
#I  Generator  1 --> 1 0 0 0 0 
#I  Generator  2 --> 0 1 0 1 0 
#I  Automorphism 5:
#I  Generator  1 --> 1 1 0 0 0 
#I  Generator  2 --> 0 1 1 0 0 
#I  Group: [grp] #4;2 #2;1 to lower exponent-2 central class 3 has order 2^5
#I  Class 1
#I  1 is defined on image of defining generator 1
#I  2 is defined on image of defining generator 2
#I  Class 2
#I  3 is defined on 1^2 = 1 1 
#I  4 is defined on 2^2 = 2 2 
#I  Class 3
#I  5 is defined on 3^2 = 1 1 1 
#I  Non-trivial powers:
#I   .1^2 = .3
#I   .2^2 = .4
#I   .3^2 = .5
#I  Non-trivial commutators:
#I  [ .2, .1 ] = .5
#I  Automorphism 1:
#I  Generator  1 --> 1 0 0 0 1 
#I  Generator  2 --> 0 1 0 0 0 
#I  Automorphism 2:
#I  Generator  1 --> 1 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 1 
#I  Number of stabiliser generators is 5
#I  Automorphism 1:
#I  Generator  1 --> 1 0 1 0 0 
#I  Generator  2 --> 0 1 0 0 0 
#I  Automorphism 2:
#I  Generator  1 --> 1 0 0 1 0 
#I  Generator  2 --> 0 1 0 0 0 
#I  Automorphism 3:
#I  Generator  1 --> 1 0 0 0 0 
#I  Generator  2 --> 0 1 1 0 0 
#I  Automorphism 4:
#I  Generator  1 --> 1 0 0 0 0 
#I  Generator  2 --> 0 1 0 1 0 
#I  Automorphism 5:
#I  Generator  1 --> 1 1 0 0 0 
#I  Generator  2 --> 0 1 1 0 0 
#I  # of immediate descendants of order 2^5 is 2
#I  # of capable immediate descendants is 2
#I  Group: [grp] #4;2 #3;2 to lower exponent-2 central class 3 has order 2^6
#I  Class 1
#I  1 is defined on image of defining generator 1
#I  2 is defined on image of defining generator 2
#I  Class 2
#I  3 is defined on 1^2 = 1 1 
#I  4 is defined on 2^2 = 2 2 
#I  Class 3
#I  5 is defined on 3^2 = 1 1 1 
#I  6 is defined on 4^2 = 2 2 2 
#I  Non-trivial powers:
#I   .1^2 = .3
#I   .2^2 = .4
#I   .3^2 = .5
#I   .4^2 = .6
#I  Non-trivial commutators:
#I  Automorphism 1:
#I  Generator  1 --> 1 0 0 0 1 0 
#I  Generator  2 --> 0 1 0 0 0 0 
#I  Automorphism 2:
#I  Generator  1 --> 1 0 0 0 0 1 
#I  Generator  2 --> 0 1 0 0 0 0 
#I  Automorphism 3:
#I  Generator  1 --> 1 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 1 0 
#I  Automorphism 4:
#I  Generator  1 --> 1 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 1 
#I  Number of stabiliser generators is 6
#I  Automorphism 1:
#I  Generator  1 --> 1 0 1 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 
#I  Automorphism 2:
#I  Generator  1 --> 1 0 0 1 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 
#I  Automorphism 3:
#I  Generator  1 --> 1 0 0 0 0 0 
#I  Generator  2 --> 0 1 1 0 0 0 
#I  Automorphism 4:
#I  Generator  1 --> 1 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 1 0 0 
#I  Automorphism 5:
#I  Generator  1 --> 0 1 0 0 0 0 
#I  Generator  2 --> 1 1 0 0 0 0 
#I  Automorphism 6:
#I  Generator  1 --> 0 1 0 0 0 0 
#I  Generator  2 --> 1 0 0 0 0 0 
#I  Group: [grp] #4;2 #4;2 to lower exponent-2 central class 3 has order 2^6
#I  Class 1
#I  1 is defined on image of defining generator 1
#I  2 is defined on image of defining generator 2
#I  Class 2
#I  3 is defined on 1^2 = 1 1 
#I  4 is defined on 2^2 = 2 2 
#I  Class 3
#I  5 is defined on 3^2 = 1 1 1 
#I  6 is defined on 4^2 = 2 2 2 
#I  Non-trivial powers:
#I   .1^2 = .3
#I   .2^2 = .4
#I   .3^2 = .5
#I   .4^2 = .6
#I  Non-trivial commutators:
#I  [ .2, .1 ] = .5
#I  Automorphism 1:
#I  Generator  1 --> 1 0 0 0 1 0 
#I  Generator  2 --> 0 1 0 0 0 0 
#I  Automorphism 2:
#I  Generator  1 --> 1 0 0 0 0 1 
#I  Generator  2 --> 0 1 0 0 0 0 
#I  Automorphism 3:
#I  Generator  1 --> 1 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 1 0 
#I  Automorphism 4:
#I  Generator  1 --> 1 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 1 
#I  Number of stabiliser generators is 5
#I  Automorphism 1:
#I  Generator  1 --> 1 0 1 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 
#I  Automorphism 2:
#I  Generator  1 --> 1 0 0 1 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 
#I  Automorphism 3:
#I  Generator  1 --> 1 0 0 0 0 0 
#I  Generator  2 --> 0 1 1 0 0 0 
#I  Automorphism 4:
#I  Generator  1 --> 1 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 1 0 0 
#I  Automorphism 5:
#I  Generator  1 --> 1 0 0 0 0 0 
#I  Generator  2 --> 1 1 0 0 0 0 
#I  # of immediate descendants of order 2^6 is 2
#I  # of capable immediate descendants is 2
#I  **************************************************
#I  Starting group: [grp] #5;2
#I  Order: 2^4
#I  Nuclear rank: 3
#I  2-multiplicator rank: 4
#I  Group: [grp] #5;2 #1;1 to lower exponent-2 central class 3 has order 2^5
#I  Class 1
#I  1 is defined on image of defining generator 1
#I  2 is defined on image of defining generator 2
#I  Class 2
#I  3 is defined on [2, 1] = 2 1 
#I  4 is defined on 1^2 = 1 1 
#I  Class 3
#I  5 is defined on 4^2 = 1 1 1 
#I  Non-trivial powers:
#I   .1^2 = .4
#I   .4^2 = .5
#I  Non-trivial commutators:
#I  [ .2, .1 ] = .3
#I  Automorphism 1:
#I  Generator  1 --> 1 0 0 0 1 
#I  Generator  2 --> 0 1 0 0 0 
#I  Automorphism 2:
#I  Generator  1 --> 1 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 1 
#I  Number of stabiliser generators is 2
#I  Automorphism 1:
#I  Generator  1 --> 1 0 0 1 0 
#I  Generator  2 --> 0 1 0 0 0 
#I  Automorphism 2:
#I  Generator  1 --> 1 1 1 0 0 
#I  Generator  2 --> 0 1 0 0 1 
#I  Group: [grp] #5;2 #2;1 to lower exponent-2 central class 3 has order 2^5
#I  Class 1
#I  1 is defined on image of defining generator 1
#I  2 is defined on image of defining generator 2
#I  Class 2
#I  3 is defined on [2, 1] = 2 1 
#I  4 is defined on 1^2 = 1 1 
#I  Class 3
#I  5 is defined on [3, 1] = 2 1 1 
#I  Non-trivial powers:
#I   .1^2 = .4
#I  Non-trivial commutators:
#I  [ .2, .1 ] = .3
#I  [ .3, .1 ] = .5
#I  [ .4, .2 ] = .5
#I  Number of stabiliser generators is 2
#I  Automorphism 1:
#I  Generator  1 --> 1 0 0 1 0 
#I  Generator  2 --> 0 1 0 0 0 
#I  Automorphism 2:
#I  Generator  1 --> 1 1 1 0 0 
#I  Generator  2 --> 0 1 0 0 1 
#I  Group: [grp] #5;2 #3;1 to lower exponent-2 central class 3 has order 2^5
#I  Class 1
#I  1 is defined on image of defining generator 1
#I  2 is defined on image of defining generator 2
#I  Class 2
#I  3 is defined on [2, 1] = 2 1 
#I  4 is defined on 1^2 = 1 1 
#I  Class 3
#I  5 is defined on [3, 1] = 2 1 1 
#I  Non-trivial powers:
#I   .1^2 = .4
#I   .4^2 = .5
#I  Non-trivial commutators:
#I  [ .2, .1 ] = .3
#I  [ .3, .1 ] = .5
#I  [ .4, .2 ] = .5
#I  Number of stabiliser generators is 3
#I  Automorphism 1:
#I  Generator  1 --> 1 0 0 1 0 
#I  Generator  2 --> 0 1 0 0 0 
#I  Automorphism 2:
#I  Generator  1 --> 1 0 0 0 0 
#I  Generator  2 --> 0 1 0 1 0 
#I  Automorphism 3:
#I  Generator  1 --> 1 1 1 0 0 
#I  Generator  2 --> 0 1 1 1 0 
#I  Group: [grp] #5;2 #4;1 to lower exponent-2 central class 3 has order 2^5
#I  Class 1
#I  1 is defined on image of defining generator 1
#I  2 is defined on image of defining generator 2
#I  Class 2
#I  3 is defined on [2, 1] = 2 1 
#I  4 is defined on 1^2 = 1 1 
#I  Class 3
#I  5 is defined on [3, 1] = 2 1 1 
#I  Non-trivial powers:
#I   .1^2 = .4
#I   .2^2 = .5
#I   .4^2 = .5
#I  Non-trivial commutators:
#I  [ .2, .1 ] = .3
#I  [ .3, .1 ] = .5
#I  [ .4, .2 ] = .5
#I  Number of stabiliser generators is 3
#I  Automorphism 1:
#I  Generator  1 --> 1 0 0 1 0 
#I  Generator  2 --> 0 1 0 0 0 
#I  Automorphism 2:
#I  Generator  1 --> 1 0 0 0 0 
#I  Generator  2 --> 0 1 0 1 0 
#I  Automorphism 3:
#I  Generator  1 --> 1 1 1 0 0 
#I  Generator  2 --> 0 1 1 1 0 
#I  Group: [grp] #5;2 #5;1 to lower exponent-2 central class 3 has order 2^5
#I  Class 1
#I  1 is defined on image of defining generator 1
#I  2 is defined on image of defining generator 2
#I  Class 2
#I  3 is defined on [2, 1] = 2 1 
#I  4 is defined on 1^2 = 1 1 
#I  Class 3
#I  5 is defined on [3, 1] = 2 1 1 
#I  Non-trivial powers:
#I   .1^2 = .4
#I   .3^2 = .5
#I  Non-trivial commutators:
#I  [ .2, .1 ] = .3
#I  [ .3, .1 ] = .5
#I  [ .3, .2 ] = .5
#I  Automorphism 1:
#I  Generator  1 --> 1 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 1 
#I  Number of stabiliser generators is 2
#I  Automorphism 1:
#I  Generator  1 --> 1 0 0 1 0 
#I  Generator  2 --> 0 1 0 0 0 
#I  Automorphism 2:
#I  Generator  1 --> 1 0 0 0 0 
#I  Generator  2 --> 0 1 0 1 0 
#I  Group: [grp] #5;2 #6;1 to lower exponent-2 central class 3 has order 2^5
#I  Class 1
#I  1 is defined on image of defining generator 1
#I  2 is defined on image of defining generator 2
#I  Class 2
#I  3 is defined on [2, 1] = 2 1 
#I  4 is defined on 1^2 = 1 1 
#I  Class 3
#I  5 is defined on [3, 1] = 2 1 1 
#I  Non-trivial powers:
#I   .1^2 = .4
#I   .2^2 = .5
#I   .3^2 = .5
#I  Non-trivial commutators:
#I  [ .2, .1 ] = .3
#I  [ .3, .1 ] = .5
#I  [ .3, .2 ] = .5
#I  Automorphism 1:
#I  Generator  1 --> 1 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 1 
#I  Number of stabiliser generators is 2
#I  Automorphism 1:
#I  Generator  1 --> 1 0 0 1 0 
#I  Generator  2 --> 0 1 0 0 0 
#I  Automorphism 2:
#I  Generator  1 --> 1 0 0 0 0 
#I  Generator  2 --> 0 1 0 1 0 
#I  Group: [grp] #5;2 #7;1 to lower exponent-2 central class 3 has order 2^5
#I  Class 1
#I  1 is defined on image of defining generator 1
#I  2 is defined on image of defining generator 2
#I  Class 2
#I  3 is defined on [2, 1] = 2 1 
#I  4 is defined on 1^2 = 1 1 
#I  Class 3
#I  5 is defined on [3, 1] = 2 1 1 
#I  Non-trivial powers:
#I   .1^2 = .4
#I   .3^2 = .5
#I   .4^2 = .5
#I  Non-trivial commutators:
#I  [ .2, .1 ] = .3
#I  [ .3, .1 ] = .5
#I  [ .3, .2 ] = .5
#I  Automorphism 1:
#I  Generator  1 --> 1 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 1 
#I  Number of stabiliser generators is 1
#I  Automorphism 1:
#I  Generator  1 --> 1 0 0 1 0 
#I  Generator  2 --> 0 1 0 0 0 
#I  # of immediate descendants of order 2^5 is 7
#I  # of capable immediate descendants is 3
#I  Group: [grp] #5;2 #8;2 to lower exponent-2 central class 3 has order 2^6
#I  Class 1
#I  1 is defined on image of defining generator 1
#I  2 is defined on image of defining generator 2
#I  Class 2
#I  3 is defined on [2, 1] = 2 1 
#I  4 is defined on 1^2 = 1 1 
#I  Class 3
#I  5 is defined on [3, 1] = 2 1 1 
#I  6 is defined on 4^2 = 1 1 1 
#I  Non-trivial powers:
#I   .1^2 = .4
#I   .4^2 = .6
#I  Non-trivial commutators:
#I  [ .2, .1 ] = .3
#I  [ .3, .1 ] = .5
#I  [ .4, .2 ] = .5
#I  Automorphism 1:
#I  Generator  1 --> 1 0 0 0 0 1 
#I  Generator  2 --> 0 1 0 0 0 0 
#I  Automorphism 2:
#I  Generator  1 --> 1 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 1 
#I  Number of stabiliser generators is 2
#I  Automorphism 1:
#I  Generator  1 --> 1 0 0 1 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 
#I  Automorphism 2:
#I  Generator  1 --> 1 1 1 0 0 0 
#I  Generator  2 --> 0 1 0 0 1 1 
#I  Group: [grp] #5;2 #9;2 to lower exponent-2 central class 3 has order 2^6
#I  Class 1
#I  1 is defined on image of defining generator 1
#I  2 is defined on image of defining generator 2
#I  Class 2
#I  3 is defined on [2, 1] = 2 1 
#I  4 is defined on 1^2 = 1 1 
#I  Class 3
#I  5 is defined on [3, 1] = 2 1 1 
#I  6 is defined on 4^2 = 1 1 1 
#I  Non-trivial powers:
#I   .1^2 = .4
#I   .2^2 = .5
#I   .4^2 = .6
#I  Non-trivial commutators:
#I  [ .2, .1 ] = .3
#I  [ .3, .1 ] = .5
#I  [ .4, .2 ] = .5
#I  Automorphism 1:
#I  Generator  1 --> 1 0 0 0 0 1 
#I  Generator  2 --> 0 1 0 0 0 0 
#I  Automorphism 2:
#I  Generator  1 --> 1 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 1 
#I  Number of stabiliser generators is 2
#I  Automorphism 1:
#I  Generator  1 --> 1 0 0 1 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 
#I  Automorphism 2:
#I  Generator  1 --> 1 1 1 0 0 0 
#I  Generator  2 --> 0 1 0 0 1 1 
#I  Group: [grp] #5;2 #10;2 to lower exponent-2 central class 3 has order 2^6
#I  Class 1
#I  1 is defined on image of defining generator 1
#I  2 is defined on image of defining generator 2
#I  Class 2
#I  3 is defined on [2, 1] = 2 1 
#I  4 is defined on 1^2 = 1 1 
#I  Class 3
#I  5 is defined on [3, 1] = 2 1 1 
#I  6 is defined on 4^2 = 1 1 1 
#I  Non-trivial powers:
#I   .1^2 = .4
#I   .3^2 = .5
#I   .4^2 = .6
#I  Non-trivial commutators:
#I  [ .2, .1 ] = .3
#I  [ .3, .1 ] = .5
#I  [ .3, .2 ] = .5
#I  Automorphism 1:
#I  Generator  1 --> 1 0 0 0 0 1 
#I  Generator  2 --> 0 1 0 0 0 0 
#I  Automorphism 2:
#I  Generator  1 --> 1 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 1 0 
#I  Automorphism 3:
#I  Generator  1 --> 1 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 1 
#I  Number of stabiliser generators is 1
#I  Automorphism 1:
#I  Generator  1 --> 1 0 0 1 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 
#I  Group: [grp] #5;2 #11;2 to lower exponent-2 central class 3 has order 2^6
#I  Class 1
#I  1 is defined on image of defining generator 1
#I  2 is defined on image of defining generator 2
#I  Class 2
#I  3 is defined on [2, 1] = 2 1 
#I  4 is defined on 1^2 = 1 1 
#I  Class 3
#I  5 is defined on [3, 1] = 2 1 1 
#I  6 is defined on 4^2 = 1 1 1 
#I  Non-trivial powers:
#I   .1^2 = .4
#I   .2^2 = .5
#I   .3^2 = .5
#I   .4^2 = .6
#I  Non-trivial commutators:
#I  [ .2, .1 ] = .3
#I  [ .3, .1 ] = .5
#I  [ .3, .2 ] = .5
#I  Automorphism 1:
#I  Generator  1 --> 1 0 0 0 0 1 
#I  Generator  2 --> 0 1 0 0 0 0 
#I  Automorphism 2:
#I  Generator  1 --> 1 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 1 0 
#I  Automorphism 3:
#I  Generator  1 --> 1 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 1 
#I  Number of stabiliser generators is 1
#I  Automorphism 1:
#I  Generator  1 --> 1 0 0 1 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 
#I  Group: [grp] #5;2 #12;2 to lower exponent-2 central class 3 has order 2^6
#I  Class 1
#I  1 is defined on image of defining generator 1
#I  2 is defined on image of defining generator 2
#I  Class 2
#I  3 is defined on [2, 1] = 2 1 
#I  4 is defined on 1^2 = 1 1 
#I  Class 3
#I  5 is defined on [3, 1] = 2 1 1 
#I  6 is defined on [3, 2] = 2 1 2 
#I  Non-trivial powers:
#I   .1^2 = .4
#I   .3^2 = .6
#I  Non-trivial commutators:
#I  [ .2, .1 ] = .3
#I  [ .3, .1 ] = .5
#I  [ .3, .2 ] = .6
#I  [ .4, .2 ] = .5 .6
#I  Automorphism 1:
#I  Generator  1 --> 1 0 0 0 0 1 
#I  Generator  2 --> 0 1 0 0 0 0 
#I  Automorphism 2:
#I  Generator  1 --> 1 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 1 
#I  Number of stabiliser generators is 1
#I  Automorphism 1:
#I  Generator  1 --> 1 0 0 1 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 
#I  Group: [grp] #5;2 #13;2 to lower exponent-2 central class 3 has order 2^6
#I  Class 1
#I  1 is defined on image of defining generator 1
#I  2 is defined on image of defining generator 2
#I  Class 2
#I  3 is defined on [2, 1] = 2 1 
#I  4 is defined on 1^2 = 1 1 
#I  Class 3
#I  5 is defined on [3, 1] = 2 1 1 
#I  6 is defined on [3, 2] = 2 1 2 
#I  Non-trivial powers:
#I   .1^2 = .4
#I   .2^2 = .5
#I   .3^2 = .6
#I  Non-trivial commutators:
#I  [ .2, .1 ] = .3
#I  [ .3, .1 ] = .5
#I  [ .3, .2 ] = .6
#I  [ .4, .2 ] = .5 .6
#I  Automorphism 1:
#I  Generator  1 --> 1 0 0 0 0 1 
#I  Generator  2 --> 0 1 0 0 0 0 
#I  Automorphism 2:
#I  Generator  1 --> 1 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 1 
#I  Number of stabiliser generators is 1
#I  Automorphism 1:
#I  Generator  1 --> 1 0 0 1 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 
#I  Group: [grp] #5;2 #14;2 to lower exponent-2 central class 3 has order 2^6
#I  Class 1
#I  1 is defined on image of defining generator 1
#I  2 is defined on image of defining generator 2
#I  Class 2
#I  3 is defined on [2, 1] = 2 1 
#I  4 is defined on 1^2 = 1 1 
#I  Class 3
#I  5 is defined on [3, 1] = 2 1 1 
#I  6 is defined on [3, 2] = 2 1 2 
#I  Non-trivial powers:
#I   .1^2 = .4
#I   .3^2 = .6
#I   .4^2 = .5
#I  Non-trivial commutators:
#I  [ .2, .1 ] = .3
#I  [ .3, .1 ] = .5
#I  [ .3, .2 ] = .6
#I  [ .4, .2 ] = .5 .6
#I  Automorphism 1:
#I  Generator  1 --> 1 0 0 0 0 1 
#I  Generator  2 --> 0 1 0 0 0 0 
#I  Automorphism 2:
#I  Generator  1 --> 1 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 1 
#I  Number of stabiliser generators is 2
#I  Automorphism 1:
#I  Generator  1 --> 1 0 0 1 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 
#I  Automorphism 2:
#I  Generator  1 --> 1 1 1 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 
#I  Group: [grp] #5;2 #15;2 to lower exponent-2 central class 3 has order 2^6
#I  Class 1
#I  1 is defined on image of defining generator 1
#I  2 is defined on image of defining generator 2
#I  Class 2
#I  3 is defined on [2, 1] = 2 1 
#I  4 is defined on 1^2 = 1 1 
#I  Class 3
#I  5 is defined on [3, 1] = 2 1 1 
#I  6 is defined on [3, 2] = 2 1 2 
#I  Non-trivial powers:
#I   .1^2 = .4
#I   .2^2 = .5
#I   .3^2 = .6
#I   .4^2 = .5
#I  Non-trivial commutators:
#I  [ .2, .1 ] = .3
#I  [ .3, .1 ] = .5
#I  [ .3, .2 ] = .6
#I  [ .4, .2 ] = .5 .6
#I  Automorphism 1:
#I  Generator  1 --> 1 0 0 0 0 1 
#I  Generator  2 --> 0 1 0 0 0 0 
#I  Automorphism 2:
#I  Generator  1 --> 1 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 1 
#I  Number of stabiliser generators is 2
#I  Automorphism 1:
#I  Generator  1 --> 1 0 0 1 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 
#I  Automorphism 2:
#I  Generator  1 --> 1 1 1 0 0 0 
#I  Generator  2 --> 0 1 1 1 0 0 
#I  Group: [grp] #5;2 #16;2 to lower exponent-2 central class 3 has order 2^6
#I  Class 1
#I  1 is defined on image of defining generator 1
#I  2 is defined on image of defining generator 2
#I  Class 2
#I  3 is defined on [2, 1] = 2 1 
#I  4 is defined on 1^2 = 1 1 
#I  Class 3
#I  5 is defined on [3, 1] = 2 1 1 
#I  6 is defined on [3, 2] = 2 1 2 
#I  Non-trivial powers:
#I   .1^2 = .4
#I   .3^2 = .6
#I   .4^2 = .5 .6
#I  Non-trivial commutators:
#I  [ .2, .1 ] = .3
#I  [ .3, .1 ] = .5
#I  [ .3, .2 ] = .6
#I  [ .4, .2 ] = .5 .6
#I  Automorphism 1:
#I  Generator  1 --> 1 0 0 0 0 1 
#I  Generator  2 --> 0 1 0 0 0 0 
#I  Automorphism 2:
#I  Generator  1 --> 1 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 1 
#I  Number of stabiliser generators is 3
#I  Automorphism 1:
#I  Generator  1 --> 1 0 0 1 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 
#I  Automorphism 2:
#I  Generator  1 --> 1 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 1 0 0 
#I  Automorphism 3:
#I  Generator  1 --> 1 1 1 0 0 0 
#I  Generator  2 --> 0 1 1 1 0 0 
#I  Group: [grp] #5;2 #17;2 to lower exponent-2 central class 3 has order 2^6
#I  Class 1
#I  1 is defined on image of defining generator 1
#I  2 is defined on image of defining generator 2
#I  Class 2
#I  3 is defined on [2, 1] = 2 1 
#I  4 is defined on 1^2 = 1 1 
#I  Class 3
#I  5 is defined on [3, 1] = 2 1 1 
#I  6 is defined on [3, 2] = 2 1 2 
#I  Non-trivial powers:
#I   .1^2 = .4
#I   .2^2 = .5
#I   .3^2 = .6
#I   .4^2 = .5 .6
#I  Non-trivial commutators:
#I  [ .2, .1 ] = .3
#I  [ .3, .1 ] = .5
#I  [ .3, .2 ] = .6
#I  [ .4, .2 ] = .5 .6
#I  Automorphism 1:
#I  Generator  1 --> 1 0 0 0 0 1 
#I  Generator  2 --> 0 1 0 0 0 0 
#I  Automorphism 2:
#I  Generator  1 --> 1 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 1 
#I  Number of stabiliser generators is 2
#I  Automorphism 1:
#I  Generator  1 --> 1 0 0 1 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 
#I  Automorphism 2:
#I  Generator  1 --> 1 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 1 0 0 
#I  Group: [grp] #5;2 #18;2 to lower exponent-2 central class 3 has order 2^6
#I  Class 1
#I  1 is defined on image of defining generator 1
#I  2 is defined on image of defining generator 2
#I  Class 2
#I  3 is defined on [2, 1] = 2 1 
#I  4 is defined on 1^2 = 1 1 
#I  Class 3
#I  5 is defined on [3, 1] = 2 1 1 
#I  6 is defined on [3, 2] = 2 1 2 
#I  Non-trivial powers:
#I   .1^2 = .4
#I   .2^2 = .6
#I   .3^2 = .6
#I   .4^2 = .5 .6
#I  Non-trivial commutators:
#I  [ .2, .1 ] = .3
#I  [ .3, .1 ] = .5
#I  [ .3, .2 ] = .6
#I  [ .4, .2 ] = .5 .6
#I  Automorphism 1:
#I  Generator  1 --> 1 0 0 0 0 1 
#I  Generator  2 --> 0 1 0 0 0 0 
#I  Automorphism 2:
#I  Generator  1 --> 1 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 1 
#I  Number of stabiliser generators is 3
#I  Automorphism 1:
#I  Generator  1 --> 1 0 0 1 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 
#I  Automorphism 2:
#I  Generator  1 --> 1 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 1 0 0 
#I  Automorphism 3:
#I  Generator  1 --> 1 1 1 0 0 0 
#I  Generator  2 --> 0 1 1 1 0 0 
#I  # of immediate descendants of order 2^6 is 11
#I  # of capable immediate descendants is 10
#I  Group: [grp] #5;2 #19;3 to lower exponent-2 central class 3 has order 2^7
#I  Class 1
#I  1 is defined on image of defining generator 1
#I  2 is defined on image of defining generator 2
#I  Class 2
#I  3 is defined on [2, 1] = 2 1 
#I  4 is defined on 1^2 = 1 1 
#I  Class 3
#I  5 is defined on [3, 1] = 2 1 1 
#I  6 is defined on [3, 2] = 2 1 2 
#I  7 is defined on 4^2 = 1 1 1 
#I  Non-trivial powers:
#I   .1^2 = .4
#I   .3^2 = .6
#I   .4^2 = .7
#I  Non-trivial commutators:
#I  [ .2, .1 ] = .3
#I  [ .3, .1 ] = .5
#I  [ .3, .2 ] = .6
#I  [ .4, .2 ] = .5 .6
#I  Automorphism 1:
#I  Generator  1 --> 1 0 0 0 0 1 0 
#I  Generator  2 --> 0 1 0 0 0 0 0 
#I  Automorphism 2:
#I  Generator  1 --> 1 0 0 0 0 0 1 
#I  Generator  2 --> 0 1 0 0 0 0 0 
#I  Automorphism 3:
#I  Generator  1 --> 1 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 1 0 
#I  Automorphism 4:
#I  Generator  1 --> 1 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 1 
#I  Number of stabiliser generators is 2
#I  Automorphism 1:
#I  Generator  1 --> 1 0 0 1 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 0 
#I  Automorphism 2:
#I  Generator  1 --> 1 1 1 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 1 0 1 
#I  Group: [grp] #5;2 #20;3 to lower exponent-2 central class 3 has order 2^7
#I  Class 1
#I  1 is defined on image of defining generator 1
#I  2 is defined on image of defining generator 2
#I  Class 2
#I  3 is defined on [2, 1] = 2 1 
#I  4 is defined on 1^2 = 1 1 
#I  Class 3
#I  5 is defined on [3, 1] = 2 1 1 
#I  6 is defined on [3, 2] = 2 1 2 
#I  7 is defined on 4^2 = 1 1 1 
#I  Non-trivial powers:
#I   .1^2 = .4
#I   .2^2 = .5
#I   .3^2 = .6
#I   .4^2 = .7
#I  Non-trivial commutators:
#I  [ .2, .1 ] = .3
#I  [ .3, .1 ] = .5
#I  [ .3, .2 ] = .6
#I  [ .4, .2 ] = .5 .6
#I  Automorphism 1:
#I  Generator  1 --> 1 0 0 0 0 1 0 
#I  Generator  2 --> 0 1 0 0 0 0 0 
#I  Automorphism 2:
#I  Generator  1 --> 1 0 0 0 0 0 1 
#I  Generator  2 --> 0 1 0 0 0 0 0 
#I  Automorphism 3:
#I  Generator  1 --> 1 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 1 0 
#I  Automorphism 4:
#I  Generator  1 --> 1 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 1 
#I  Number of stabiliser generators is 1
#I  Automorphism 1:
#I  Generator  1 --> 1 0 0 1 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 0 
#I  Group: [grp] #5;2 #21;3 to lower exponent-2 central class 3 has order 2^7
#I  Class 1
#I  1 is defined on image of defining generator 1
#I  2 is defined on image of defining generator 2
#I  Class 2
#I  3 is defined on [2, 1] = 2 1 
#I  4 is defined on 1^2 = 1 1 
#I  Class 3
#I  5 is defined on [3, 1] = 2 1 1 
#I  6 is defined on [3, 2] = 2 1 2 
#I  7 is defined on 4^2 = 1 1 1 
#I  Non-trivial powers:
#I   .1^2 = .4
#I   .2^2 = .6
#I   .3^2 = .6
#I   .4^2 = .7
#I  Non-trivial commutators:
#I  [ .2, .1 ] = .3
#I  [ .3, .1 ] = .5
#I  [ .3, .2 ] = .6
#I  [ .4, .2 ] = .5 .6
#I  Automorphism 1:
#I  Generator  1 --> 1 0 0 0 0 1 0 
#I  Generator  2 --> 0 1 0 0 0 0 0 
#I  Automorphism 2:
#I  Generator  1 --> 1 0 0 0 0 0 1 
#I  Generator  2 --> 0 1 0 0 0 0 0 
#I  Automorphism 3:
#I  Generator  1 --> 1 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 1 0 
#I  Automorphism 4:
#I  Generator  1 --> 1 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 1 
#I  Number of stabiliser generators is 2
#I  Automorphism 1:
#I  Generator  1 --> 1 0 0 1 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 0 
#I  Automorphism 2:
#I  Generator  1 --> 1 1 1 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 1 0 1 
#I  # of immediate descendants of order 2^7 is 3
#I  # of capable immediate descendants is 3
#I  **************************************************
#I  Starting group: [grp] #6;2
#I  Order: 2^4
#I  Nuclear rank: 2
#I  2-multiplicator rank: 3
#I  Group: [grp] #6;2 #1;1 to lower exponent-2 central class 3 has order 2^5
#I  Class 1
#I  1 is defined on image of defining generator 1
#I  2 is defined on image of defining generator 2
#I  Class 2
#I  3 is defined on [2, 1] = 2 1 
#I  4 is defined on 1^2 = 1 1 
#I  Class 3
#I  5 is defined on 4^2 = 1 1 1 
#I  Non-trivial powers:
#I   .1^2 = .4
#I   .2^2 = .3
#I   .4^2 = .5
#I  Non-trivial commutators:
#I  [ .2, .1 ] = .3
#I  Automorphism 1:
#I  Generator  1 --> 1 0 0 0 1 
#I  Generator  2 --> 0 1 0 0 0 
#I  Automorphism 2:
#I  Generator  1 --> 1 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 1 
#I  Number of stabiliser generators is 2
#I  Automorphism 1:
#I  Generator  1 --> 1 0 0 1 0 
#I  Generator  2 --> 0 1 0 0 0 
#I  Automorphism 2:
#I  Generator  1 --> 1 1 1 0 0 
#I  Generator  2 --> 0 1 1 0 1 
#I  Group: [grp] #6;2 #2;1 to lower exponent-2 central class 3 has order 2^5
#I  Class 1
#I  1 is defined on image of defining generator 1
#I  2 is defined on image of defining generator 2
#I  Class 2
#I  3 is defined on [2, 1] = 2 1 
#I  4 is defined on 1^2 = 1 1 
#I  Class 3
#I  5 is defined on [3, 1] = 2 1 1 
#I  Non-trivial powers:
#I   .1^2 = .4
#I   .2^2 = .3
#I   .3^2 = .5
#I  Non-trivial commutators:
#I  [ .2, .1 ] = .3
#I  [ .3, .1 ] = .5
#I  Automorphism 1:
#I  Generator  1 --> 1 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 1 
#I  Number of stabiliser generators is 3
#I  Automorphism 1:
#I  Generator  1 --> 1 0 0 1 0 
#I  Generator  2 --> 0 1 0 0 0 
#I  Automorphism 2:
#I  Generator  1 --> 1 0 0 0 0 
#I  Generator  2 --> 0 1 0 1 0 
#I  Automorphism 3:
#I  Generator  1 --> 1 1 1 0 0 
#I  Generator  2 --> 0 1 1 1 0 
#I  Group: [grp] #6;2 #3;1 to lower exponent-2 central class 3 has order 2^5
#I  Class 1
#I  1 is defined on image of defining generator 1
#I  2 is defined on image of defining generator 2
#I  Class 2
#I  3 is defined on [2, 1] = 2 1 
#I  4 is defined on 1^2 = 1 1 
#I  Class 3
#I  5 is defined on [3, 1] = 2 1 1 
#I  Non-trivial powers:
#I   .1^2 = .4
#I   .2^2 = .3 .5
#I   .3^2 = .5
#I  Non-trivial commutators:
#I  [ .2, .1 ] = .3
#I  [ .3, .1 ] = .5
#I  Automorphism 1:
#I  Generator  1 --> 1 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 1 
#I  Number of stabiliser generators is 3
#I  Automorphism 1:
#I  Generator  1 --> 1 0 0 1 0 
#I  Generator  2 --> 0 1 0 0 0 
#I  Automorphism 2:
#I  Generator  1 --> 1 0 0 0 0 
#I  Generator  2 --> 0 1 0 1 0 
#I  Automorphism 3:
#I  Generator  1 --> 1 1 1 0 0 
#I  Generator  2 --> 0 1 1 1 0 
#I  Group: [grp] #6;2 #4;1 to lower exponent-2 central class 3 has order 2^5
#I  Class 1
#I  1 is defined on image of defining generator 1
#I  2 is defined on image of defining generator 2
#I  Class 2
#I  3 is defined on [2, 1] = 2 1 
#I  4 is defined on 1^2 = 1 1 
#I  Class 3
#I  5 is defined on [3, 1] = 2 1 1 
#I  Non-trivial powers:
#I   .1^2 = .4
#I   .2^2 = .3
#I   .3^2 = .5
#I   .4^2 = .5
#I  Non-trivial commutators:
#I  [ .2, .1 ] = .3
#I  [ .3, .1 ] = .5
#I  Automorphism 1:
#I  Generator  1 --> 1 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 1 
#I  Number of stabiliser generators is 2
#I  Automorphism 1:
#I  Generator  1 --> 1 0 0 1 0 
#I  Generator  2 --> 0 1 0 0 0 
#I  Automorphism 2:
#I  Generator  1 --> 1 1 1 0 0 
#I  Generator  2 --> 0 1 1 0 0 
#I  # of immediate descendants of order 2^5 is 4
#I  # of capable immediate descendants is 3
#I  Group: [grp] #6;2 #5;2 to lower exponent-2 central class 3 has order 2^6
#I  Class 1
#I  1 is defined on image of defining generator 1
#I  2 is defined on image of defining generator 2
#I  Class 2
#I  3 is defined on [2, 1] = 2 1 
#I  4 is defined on 1^2 = 1 1 
#I  Class 3
#I  5 is defined on [3, 1] = 2 1 1 
#I  6 is defined on 4^2 = 1 1 1 
#I  Non-trivial powers:
#I   .1^2 = .4
#I   .2^2 = .3
#I   .3^2 = .5
#I   .4^2 = .6
#I  Non-trivial commutators:
#I  [ .2, .1 ] = .3
#I  [ .3, .1 ] = .5
#I  Automorphism 1:
#I  Generator  1 --> 1 0 0 0 0 1 
#I  Generator  2 --> 0 1 0 0 0 0 
#I  Automorphism 2:
#I  Generator  1 --> 1 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 1 0 
#I  Automorphism 3:
#I  Generator  1 --> 1 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 1 
#I  Number of stabiliser generators is 2
#I  Automorphism 1:
#I  Generator  1 --> 1 0 0 1 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 
#I  Automorphism 2:
#I  Generator  1 --> 1 1 1 0 0 0 
#I  Generator  2 --> 0 1 1 0 1 1 
#I  Group: [grp] #6;2 #6;2 to lower exponent-2 central class 3 has order 2^6
#I  Class 1
#I  1 is defined on image of defining generator 1
#I  2 is defined on image of defining generator 2
#I  Class 2
#I  3 is defined on [2, 1] = 2 1 
#I  4 is defined on 1^2 = 1 1 
#I  Class 3
#I  5 is defined on [3, 1] = 2 1 1 
#I  6 is defined on 4^2 = 1 1 1 
#I  Non-trivial powers:
#I   .1^2 = .4
#I   .2^2 = .3 .5
#I   .3^2 = .5
#I   .4^2 = .6
#I  Non-trivial commutators:
#I  [ .2, .1 ] = .3
#I  [ .3, .1 ] = .5
#I  Automorphism 1:
#I  Generator  1 --> 1 0 0 0 0 1 
#I  Generator  2 --> 0 1 0 0 0 0 
#I  Automorphism 2:
#I  Generator  1 --> 1 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 1 0 
#I  Automorphism 3:
#I  Generator  1 --> 1 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 1 
#I  Number of stabiliser generators is 2
#I  Automorphism 1:
#I  Generator  1 --> 1 0 0 1 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 
#I  Automorphism 2:
#I  Generator  1 --> 1 1 1 0 0 0 
#I  Generator  2 --> 0 1 1 0 1 1 
#I  # of immediate descendants of order 2^6 is 2
#I  # of capable immediate descendants is 2
#I  **************************************************
#I  Starting group: [grp] #7;3
#I  Order: 2^5
#I  Nuclear rank: 5
#I  2-multiplicator rank: 5
#I  Group: [grp] #7;3 #1;1 to lower exponent-2 central class 3 has order 2^6
#I  Class 1
#I  1 is defined on image of defining generator 1
#I  2 is defined on image of defining generator 2
#I  Class 2
#I  3 is defined on [2, 1] = 2 1 
#I  4 is defined on 1^2 = 1 1 
#I  5 is defined on 2^2 = 2 2 
#I  Class 3
#I  6 is defined on 4^2 = 1 1 1 
#I  Non-trivial powers:
#I   .1^2 = .4
#I   .2^2 = .5
#I   .4^2 = .6
#I  Non-trivial commutators:
#I  [ .2, .1 ] = .3
#I  Automorphism 1:
#I  Generator  1 --> 1 0 0 0 0 1 
#I  Generator  2 --> 0 1 0 0 0 0 
#I  Automorphism 2:
#I  Generator  1 --> 1 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 1 
#I  Number of stabiliser generators is 5
#I  Automorphism 1:
#I  Generator  1 --> 1 0 0 1 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 
#I  Automorphism 2:
#I  Generator  1 --> 1 0 0 0 1 0 
#I  Generator  2 --> 0 1 0 0 0 0 
#I  Automorphism 3:
#I  Generator  1 --> 1 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 1 0 0 
#I  Automorphism 4:
#I  Generator  1 --> 1 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 1 0 
#I  Automorphism 5:
#I  Generator  1 --> 1 1 1 0 0 0 
#I  Generator  2 --> 0 1 1 1 0 0 
#I  Group: [grp] #7;3 #2;1 to lower exponent-2 central class 3 has order 2^6
#I  Class 1
#I  1 is defined on image of defining generator 1
#I  2 is defined on image of defining generator 2
#I  Class 2
#I  3 is defined on [2, 1] = 2 1 
#I  4 is defined on 1^2 = 1 1 
#I  5 is defined on 2^2 = 2 2 
#I  Class 3
#I  6 is defined on [4, 2] = 1 1 2 
#I  Non-trivial powers:
#I   .1^2 = .4
#I   .2^2 = .5
#I   .3^2 = .6
#I  Non-trivial commutators:
#I  [ .2, .1 ] = .3
#I  [ .4, .2 ] = .6
#I  [ .5, .1 ] = .6
#I  Number of stabiliser generators is 5
#I  Automorphism 1:
#I  Generator  1 --> 1 0 0 1 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 
#I  Automorphism 2:
#I  Generator  1 --> 1 0 0 0 1 0 
#I  Generator  2 --> 0 1 0 0 0 0 
#I  Automorphism 3:
#I  Generator  1 --> 1 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 1 0 0 
#I  Automorphism 4:
#I  Generator  1 --> 1 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 1 0 
#I  Automorphism 5:
#I  Generator  1 --> 0 1 0 0 0 0 
#I  Generator  2 --> 1 0 0 0 0 0 
#I  Group: [grp] #7;3 #3;1 to lower exponent-2 central class 3 has order 2^6
#I  Class 1
#I  1 is defined on image of defining generator 1
#I  2 is defined on image of defining generator 2
#I  Class 2
#I  3 is defined on [2, 1] = 2 1 
#I  4 is defined on 1^2 = 1 1 
#I  5 is defined on 2^2 = 2 2 
#I  Class 3
#I  6 is defined on [4, 2] = 1 1 2 
#I  Non-trivial powers:
#I   .1^2 = .4
#I   .2^2 = .5
#I   .3^2 = .6
#I   .4^2 = .6
#I   .5^2 = .6
#I  Non-trivial commutators:
#I  [ .2, .1 ] = .3
#I  [ .4, .2 ] = .6
#I  [ .5, .1 ] = .6
#I  Number of stabiliser generators is 6
#I  Automorphism 1:
#I  Generator  1 --> 1 0 0 1 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 
#I  Automorphism 2:
#I  Generator  1 --> 1 0 0 0 1 0 
#I  Generator  2 --> 0 1 0 0 0 0 
#I  Automorphism 3:
#I  Generator  1 --> 1 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 1 0 0 
#I  Automorphism 4:
#I  Generator  1 --> 1 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 1 0 
#I  Automorphism 5:
#I  Generator  1 --> 0 1 0 0 0 0 
#I  Generator  2 --> 1 1 0 0 0 0 
#I  Automorphism 6:
#I  Generator  1 --> 0 1 0 0 0 0 
#I  Generator  2 --> 1 0 0 0 0 0 
#I  Group: [grp] #7;3 #4;1 to lower exponent-2 central class 3 has order 2^6
#I  Class 1
#I  1 is defined on image of defining generator 1
#I  2 is defined on image of defining generator 2
#I  Class 2
#I  3 is defined on [2, 1] = 2 1 
#I  4 is defined on 1^2 = 1 1 
#I  5 is defined on 2^2 = 2 2 
#I  Class 3
#I  6 is defined on [3, 1] = 2 1 1 
#I  Non-trivial powers:
#I   .1^2 = .4
#I   .2^2 = .5
#I   .3^2 = .6
#I  Non-trivial commutators:
#I  [ .2, .1 ] = .3
#I  [ .3, .1 ] = .6
#I  [ .5, .1 ] = .6
#I  Automorphism 1:
#I  Generator  1 --> 1 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 1 
#I  Number of stabiliser generators is 4
#I  Automorphism 1:
#I  Generator  1 --> 1 0 0 1 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 
#I  Automorphism 2:
#I  Generator  1 --> 1 0 0 0 1 0 
#I  Generator  2 --> 0 1 0 0 0 0 
#I  Automorphism 3:
#I  Generator  1 --> 1 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 1 0 0 
#I  Automorphism 4:
#I  Generator  1 --> 1 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 1 0 
#I  Group: [grp] #7;3 #5;1 to lower exponent-2 central class 3 has order 2^6
#I  Class 1
#I  1 is defined on image of defining generator 1
#I  2 is defined on image of defining generator 2
#I  Class 2
#I  3 is defined on [2, 1] = 2 1 
#I  4 is defined on 1^2 = 1 1 
#I  5 is defined on 2^2 = 2 2 
#I  Class 3
#I  6 is defined on [3, 1] = 2 1 1 
#I  Non-trivial powers:
#I   .1^2 = .4
#I   .2^2 = .5
#I   .3^2 = .6
#I   .5^2 = .6
#I  Non-trivial commutators:
#I  [ .2, .1 ] = .3
#I  [ .3, .1 ] = .6
#I  [ .5, .1 ] = .6
#I  Automorphism 1:
#I  Generator  1 --> 1 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 1 
#I  Number of stabiliser generators is 5
#I  Automorphism 1:
#I  Generator  1 --> 1 0 0 1 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 
#I  Automorphism 2:
#I  Generator  1 --> 1 0 0 0 1 0 
#I  Generator  2 --> 0 1 0 0 0 0 
#I  Automorphism 3:
#I  Generator  1 --> 1 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 1 0 0 
#I  Automorphism 4:
#I  Generator  1 --> 1 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 1 0 
#I  Automorphism 5:
#I  Generator  1 --> 1 1 1 0 0 0 
#I  Generator  2 --> 0 1 1 1 0 0 
#I  Group: [grp] #7;3 #6;1 to lower exponent-2 central class 3 has order 2^6
#I  Class 1
#I  1 is defined on image of defining generator 1
#I  2 is defined on image of defining generator 2
#I  Class 2
#I  3 is defined on [2, 1] = 2 1 
#I  4 is defined on 1^2 = 1 1 
#I  5 is defined on 2^2 = 2 2 
#I  Class 3
#I  6 is defined on [3, 1] = 2 1 1 
#I  Non-trivial powers:
#I   .1^2 = .4
#I   .2^2 = .5
#I   .3^2 = .6
#I   .4^2 = .6
#I   .5^2 = .6
#I  Non-trivial commutators:
#I  [ .2, .1 ] = .3
#I  [ .3, .1 ] = .6
#I  [ .5, .1 ] = .6
#I  Automorphism 1:
#I  Generator  1 --> 1 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 1 
#I  Number of stabiliser generators is 5
#I  Automorphism 1:
#I  Generator  1 --> 1 0 0 1 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 
#I  Automorphism 2:
#I  Generator  1 --> 1 0 0 0 1 0 
#I  Generator  2 --> 0 1 0 0 0 0 
#I  Automorphism 3:
#I  Generator  1 --> 1 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 1 0 0 
#I  Automorphism 4:
#I  Generator  1 --> 1 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 1 0 
#I  Automorphism 5:
#I  Generator  1 --> 1 1 1 0 0 0 
#I  Generator  2 --> 0 1 1 1 0 0 
#I  Group: [grp] #7;3 #7;1 to lower exponent-2 central class 3 has order 2^6
#I  Class 1
#I  1 is defined on image of defining generator 1
#I  2 is defined on image of defining generator 2
#I  Class 2
#I  3 is defined on [2, 1] = 2 1 
#I  4 is defined on 1^2 = 1 1 
#I  5 is defined on 2^2 = 2 2 
#I  Class 3
#I  6 is defined on [3, 1] = 2 1 1 
#I  Non-trivial powers:
#I   .1^2 = .4
#I   .2^2 = .5
#I  Non-trivial commutators:
#I  [ .2, .1 ] = .3
#I  [ .3, .1 ] = .6
#I  [ .4, .2 ] = .6
#I  Number of stabiliser generators is 5
#I  Automorphism 1:
#I  Generator  1 --> 1 0 0 1 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 
#I  Automorphism 2:
#I  Generator  1 --> 1 0 0 0 1 0 
#I  Generator  2 --> 0 1 0 0 0 0 
#I  Automorphism 3:
#I  Generator  1 --> 1 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 1 0 0 
#I  Automorphism 4:
#I  Generator  1 --> 1 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 1 0 
#I  Automorphism 5:
#I  Generator  1 --> 1 1 1 0 0 0 
#I  Generator  2 --> 0 1 1 1 0 0 
#I  Group: [grp] #7;3 #8;1 to lower exponent-2 central class 3 has order 2^6
#I  Class 1
#I  1 is defined on image of defining generator 1
#I  2 is defined on image of defining generator 2
#I  Class 2
#I  3 is defined on [2, 1] = 2 1 
#I  4 is defined on 1^2 = 1 1 
#I  5 is defined on 2^2 = 2 2 
#I  Class 3
#I  6 is defined on [3, 1] = 2 1 1 
#I  Non-trivial powers:
#I   .1^2 = .4
#I   .2^2 = .5
#I   .4^2 = .6
#I  Non-trivial commutators:
#I  [ .2, .1 ] = .3
#I  [ .3, .1 ] = .6
#I  [ .4, .2 ] = .6
#I  Number of stabiliser generators is 5
#I  Automorphism 1:
#I  Generator  1 --> 1 0 0 1 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 
#I  Automorphism 2:
#I  Generator  1 --> 1 0 0 0 1 0 
#I  Generator  2 --> 0 1 0 0 0 0 
#I  Automorphism 3:
#I  Generator  1 --> 1 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 1 0 0 
#I  Automorphism 4:
#I  Generator  1 --> 1 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 1 0 
#I  Automorphism 5:
#I  Generator  1 --> 1 1 1 0 0 0 
#I  Generator  2 --> 0 1 1 1 0 0 
#I  Group: [grp] #7;3 #9;1 to lower exponent-2 central class 3 has order 2^6
#I  Class 1
#I  1 is defined on image of defining generator 1
#I  2 is defined on image of defining generator 2
#I  Class 2
#I  3 is defined on [2, 1] = 2 1 
#I  4 is defined on 1^2 = 1 1 
#I  5 is defined on 2^2 = 2 2 
#I  Class 3
#I  6 is defined on [3, 1] = 2 1 1 
#I  Non-trivial powers:
#I   .1^2 = .4
#I   .2^2 = .5
#I   .5^2 = .6
#I  Non-trivial commutators:
#I  [ .2, .1 ] = .3
#I  [ .3, .1 ] = .6
#I  [ .4, .2 ] = .6
#I  Number of stabiliser generators is 4
#I  Automorphism 1:
#I  Generator  1 --> 1 0 0 1 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 
#I  Automorphism 2:
#I  Generator  1 --> 1 0 0 0 1 0 
#I  Generator  2 --> 0 1 0 0 0 0 
#I  Automorphism 3:
#I  Generator  1 --> 1 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 1 0 0 
#I  Automorphism 4:
#I  Generator  1 --> 1 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 1 0 
#I  # of immediate descendants of order 2^6 is 9
#I  # of capable immediate descendants is 3
#I  Group: [grp] #7;3 #10;2 to lower exponent-2 central class 3 has order 2^7
#I  Class 1
#I  1 is defined on image of defining generator 1
#I  2 is defined on image of defining generator 2
#I  Class 2
#I  3 is defined on [2, 1] = 2 1 
#I  4 is defined on 1^2 = 1 1 
#I  5 is defined on 2^2 = 2 2 
#I  Class 3
#I  6 is defined on 4^2 = 1 1 1 
#I  7 is defined on 5^2 = 2 2 2 
#I  Non-trivial powers:
#I   .1^2 = .4
#I   .2^2 = .5
#I   .4^2 = .6
#I   .5^2 = .7
#I  Non-trivial commutators:
#I  [ .2, .1 ] = .3
#I  Automorphism 1:
#I  Generator  1 --> 1 0 0 0 0 1 0 
#I  Generator  2 --> 0 1 0 0 0 0 0 
#I  Automorphism 2:
#I  Generator  1 --> 1 0 0 0 0 0 1 
#I  Generator  2 --> 0 1 0 0 0 0 0 
#I  Automorphism 3:
#I  Generator  1 --> 1 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 1 0 
#I  Automorphism 4:
#I  Generator  1 --> 1 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 1 
#I  Number of stabiliser generators is 6
#I  Automorphism 1:
#I  Generator  1 --> 1 0 0 1 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 0 
#I  Automorphism 2:
#I  Generator  1 --> 1 0 0 0 1 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 0 
#I  Automorphism 3:
#I  Generator  1 --> 1 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 1 0 0 0 
#I  Automorphism 4:
#I  Generator  1 --> 1 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 1 0 0 
#I  Automorphism 5:
#I  Generator  1 --> 0 1 0 0 0 0 0 
#I  Generator  2 --> 1 1 0 0 0 0 0 
#I  Automorphism 6:
#I  Generator  1 --> 0 1 0 0 0 0 0 
#I  Generator  2 --> 1 0 0 0 0 0 0 
#I  Group: [grp] #7;3 #11;2 to lower exponent-2 central class 3 has order 2^7
#I  Class 1
#I  1 is defined on image of defining generator 1
#I  2 is defined on image of defining generator 2
#I  Class 2
#I  3 is defined on [2, 1] = 2 1 
#I  4 is defined on 1^2 = 1 1 
#I  5 is defined on 2^2 = 2 2 
#I  Class 3
#I  6 is defined on [4, 2] = 1 1 2 
#I  7 is defined on 4^2 = 1 1 1 
#I  Non-trivial powers:
#I   .1^2 = .4
#I   .2^2 = .5
#I   .3^2 = .6
#I   .4^2 = .7
#I  Non-trivial commutators:
#I  [ .2, .1 ] = .3
#I  [ .4, .2 ] = .6
#I  [ .5, .1 ] = .6
#I  Automorphism 1:
#I  Generator  1 --> 1 0 0 0 0 0 1 
#I  Generator  2 --> 0 1 0 0 0 0 0 
#I  Automorphism 2:
#I  Generator  1 --> 1 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 1 
#I  Number of stabiliser generators is 5
#I  Automorphism 1:
#I  Generator  1 --> 1 0 0 1 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 0 
#I  Automorphism 2:
#I  Generator  1 --> 1 0 0 0 1 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 0 
#I  Automorphism 3:
#I  Generator  1 --> 1 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 1 0 0 0 
#I  Automorphism 4:
#I  Generator  1 --> 1 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 1 0 0 
#I  Automorphism 5:
#I  Generator  1 --> 1 1 1 0 0 0 0 
#I  Generator  2 --> 0 1 1 1 0 1 0 
#I  Group: [grp] #7;3 #12;2 to lower exponent-2 central class 3 has order 2^7
#I  Class 1
#I  1 is defined on image of defining generator 1
#I  2 is defined on image of defining generator 2
#I  Class 2
#I  3 is defined on [2, 1] = 2 1 
#I  4 is defined on 1^2 = 1 1 
#I  5 is defined on 2^2 = 2 2 
#I  Class 3
#I  6 is defined on [4, 2] = 1 1 2 
#I  7 is defined on 4^2 = 1 1 1 
#I  Non-trivial powers:
#I   .1^2 = .4
#I   .2^2 = .5
#I   .3^2 = .6
#I   .4^2 = .7
#I   .5^2 = .6
#I  Non-trivial commutators:
#I  [ .2, .1 ] = .3
#I  [ .4, .2 ] = .6
#I  [ .5, .1 ] = .6
#I  Automorphism 1:
#I  Generator  1 --> 1 0 0 0 0 0 1 
#I  Generator  2 --> 0 1 0 0 0 0 0 
#I  Automorphism 2:
#I  Generator  1 --> 1 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 1 
#I  Number of stabiliser generators is 5
#I  Automorphism 1:
#I  Generator  1 --> 1 0 0 1 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 0 
#I  Automorphism 2:
#I  Generator  1 --> 1 0 0 0 1 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 0 
#I  Automorphism 3:
#I  Generator  1 --> 1 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 1 0 0 0 
#I  Automorphism 4:
#I  Generator  1 --> 1 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 1 0 0 
#I  Automorphism 5:
#I  Generator  1 --> 1 1 1 0 0 0 0 
#I  Generator  2 --> 0 1 1 1 0 1 0 
#I  Group: [grp] #7;3 #13;2 to lower exponent-2 central class 3 has order 2^7
#I  Class 1
#I  1 is defined on image of defining generator 1
#I  2 is defined on image of defining generator 2
#I  Class 2
#I  3 is defined on [2, 1] = 2 1 
#I  4 is defined on 1^2 = 1 1 
#I  5 is defined on 2^2 = 2 2 
#I  Class 3
#I  6 is defined on [3, 1] = 2 1 1 
#I  7 is defined on 4^2 = 1 1 1 
#I  Non-trivial powers:
#I   .1^2 = .4
#I   .2^2 = .5
#I   .3^2 = .6
#I   .4^2 = .7
#I  Non-trivial commutators:
#I  [ .2, .1 ] = .3
#I  [ .3, .1 ] = .6
#I  [ .5, .1 ] = .6
#I  Automorphism 1:
#I  Generator  1 --> 1 0 0 0 0 0 1 
#I  Generator  2 --> 0 1 0 0 0 0 0 
#I  Automorphism 2:
#I  Generator  1 --> 1 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 1 0 
#I  Automorphism 3:
#I  Generator  1 --> 1 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 1 
#I  Number of stabiliser generators is 5
#I  Automorphism 1:
#I  Generator  1 --> 1 0 0 1 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 0 
#I  Automorphism 2:
#I  Generator  1 --> 1 0 0 0 1 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 0 
#I  Automorphism 3:
#I  Generator  1 --> 1 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 1 0 0 0 
#I  Automorphism 4:
#I  Generator  1 --> 1 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 1 0 0 
#I  Automorphism 5:
#I  Generator  1 --> 1 1 1 0 0 0 0 
#I  Generator  2 --> 0 1 1 1 0 0 0 
#I  Group: [grp] #7;3 #14;2 to lower exponent-2 central class 3 has order 2^7
#I  Class 1
#I  1 is defined on image of defining generator 1
#I  2 is defined on image of defining generator 2
#I  Class 2
#I  3 is defined on [2, 1] = 2 1 
#I  4 is defined on 1^2 = 1 1 
#I  5 is defined on 2^2 = 2 2 
#I  Class 3
#I  6 is defined on [3, 1] = 2 1 1 
#I  7 is defined on 4^2 = 1 1 1 
#I  Non-trivial powers:
#I   .1^2 = .4
#I   .2^2 = .5
#I   .3^2 = .6
#I   .4^2 = .7
#I   .5^2 = .6
#I  Non-trivial commutators:
#I  [ .2, .1 ] = .3
#I  [ .3, .1 ] = .6
#I  [ .5, .1 ] = .6
#I  Automorphism 1:
#I  Generator  1 --> 1 0 0 0 0 0 1 
#I  Generator  2 --> 0 1 0 0 0 0 0 
#I  Automorphism 2:
#I  Generator  1 --> 1 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 1 0 
#I  Automorphism 3:
#I  Generator  1 --> 1 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 1 
#I  Number of stabiliser generators is 5
#I  Automorphism 1:
#I  Generator  1 --> 1 0 0 1 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 0 
#I  Automorphism 2:
#I  Generator  1 --> 1 0 0 0 1 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 0 
#I  Automorphism 3:
#I  Generator  1 --> 1 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 1 0 0 0 
#I  Automorphism 4:
#I  Generator  1 --> 1 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 1 0 0 
#I  Automorphism 5:
#I  Generator  1 --> 1 1 1 0 0 0 0 
#I  Generator  2 --> 0 1 1 1 0 0 0 
#I  Group: [grp] #7;3 #15;2 to lower exponent-2 central class 3 has order 2^7
#I  Class 1
#I  1 is defined on image of defining generator 1
#I  2 is defined on image of defining generator 2
#I  Class 2
#I  3 is defined on [2, 1] = 2 1 
#I  4 is defined on 1^2 = 1 1 
#I  5 is defined on 2^2 = 2 2 
#I  Class 3
#I  6 is defined on [3, 1] = 2 1 1 
#I  7 is defined on 4^2 = 1 1 1 
#I  Non-trivial powers:
#I   .1^2 = .4
#I   .2^2 = .5
#I   .3^2 = .6
#I   .4^2 = .7
#I   .5^2 = .7
#I  Non-trivial commutators:
#I  [ .2, .1 ] = .3
#I  [ .3, .1 ] = .6
#I  [ .5, .1 ] = .6
#I  Automorphism 1:
#I  Generator  1 --> 1 0 0 0 0 0 1 
#I  Generator  2 --> 0 1 0 0 0 0 0 
#I  Automorphism 2:
#I  Generator  1 --> 1 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 1 0 
#I  Automorphism 3:
#I  Generator  1 --> 1 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 1 
#I  Number of stabiliser generators is 4
#I  Automorphism 1:
#I  Generator  1 --> 1 0 0 1 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 0 
#I  Automorphism 2:
#I  Generator  1 --> 1 0 0 0 1 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 0 
#I  Automorphism 3:
#I  Generator  1 --> 1 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 1 0 0 0 
#I  Automorphism 4:
#I  Generator  1 --> 1 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 1 0 0 
#I  Group: [grp] #7;3 #16;2 to lower exponent-2 central class 3 has order 2^7
#I  Class 1
#I  1 is defined on image of defining generator 1
#I  2 is defined on image of defining generator 2
#I  Class 2
#I  3 is defined on [2, 1] = 2 1 
#I  4 is defined on 1^2 = 1 1 
#I  5 is defined on 2^2 = 2 2 
#I  Class 3
#I  6 is defined on [3, 1] = 2 1 1 
#I  7 is defined on 4^2 = 1 1 1 
#I  Non-trivial powers:
#I   .1^2 = .4
#I   .2^2 = .5
#I   .3^2 = .6
#I   .4^2 = .7
#I   .5^2 = .6 .7
#I  Non-trivial commutators:
#I  [ .2, .1 ] = .3
#I  [ .3, .1 ] = .6
#I  [ .5, .1 ] = .6
#I  Automorphism 1:
#I  Generator  1 --> 1 0 0 0 0 0 1 
#I  Generator  2 --> 0 1 0 0 0 0 0 
#I  Automorphism 2:
#I  Generator  1 --> 1 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 1 0 
#I  Automorphism 3:
#I  Generator  1 --> 1 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 1 
#I  Number of stabiliser generators is 4
#I  Automorphism 1:
#I  Generator  1 --> 1 0 0 1 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 0 
#I  Automorphism 2:
#I  Generator  1 --> 1 0 0 0 1 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 0 
#I  Automorphism 3:
#I  Generator  1 --> 1 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 1 0 0 0 
#I  Automorphism 4:
#I  Generator  1 --> 1 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 1 0 0 
#I  Group: [grp] #7;3 #17;2 to lower exponent-2 central class 3 has order 2^7
#I  Class 1
#I  1 is defined on image of defining generator 1
#I  2 is defined on image of defining generator 2
#I  Class 2
#I  3 is defined on [2, 1] = 2 1 
#I  4 is defined on 1^2 = 1 1 
#I  5 is defined on 2^2 = 2 2 
#I  Class 3
#I  6 is defined on [3, 1] = 2 1 1 
#I  7 is defined on 4^2 = 1 1 1 
#I  Non-trivial powers:
#I   .1^2 = .4
#I   .2^2 = .5
#I   .4^2 = .7
#I  Non-trivial commutators:
#I  [ .2, .1 ] = .3
#I  [ .3, .1 ] = .6
#I  [ .4, .2 ] = .6
#I  Automorphism 1:
#I  Generator  1 --> 1 0 0 0 0 0 1 
#I  Generator  2 --> 0 1 0 0 0 0 0 
#I  Automorphism 2:
#I  Generator  1 --> 1 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 1 
#I  Number of stabiliser generators is 5
#I  Automorphism 1:
#I  Generator  1 --> 1 0 0 1 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 0 
#I  Automorphism 2:
#I  Generator  1 --> 1 0 0 0 1 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 0 
#I  Automorphism 3:
#I  Generator  1 --> 1 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 1 0 0 0 
#I  Automorphism 4:
#I  Generator  1 --> 1 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 1 0 0 
#I  Automorphism 5:
#I  Generator  1 --> 1 1 1 0 0 0 0 
#I  Generator  2 --> 0 1 1 1 0 0 0 
#I  Group: [grp] #7;3 #18;2 to lower exponent-2 central class 3 has order 2^7
#I  Class 1
#I  1 is defined on image of defining generator 1
#I  2 is defined on image of defining generator 2
#I  Class 2
#I  3 is defined on [2, 1] = 2 1 
#I  4 is defined on 1^2 = 1 1 
#I  5 is defined on 2^2 = 2 2 
#I  Class 3
#I  6 is defined on [3, 1] = 2 1 1 
#I  7 is defined on 4^2 = 1 1 1 
#I  Non-trivial powers:
#I   .1^2 = .4
#I   .2^2 = .5
#I   .4^2 = .7
#I   .5^2 = .6
#I  Non-trivial commutators:
#I  [ .2, .1 ] = .3
#I  [ .3, .1 ] = .6
#I  [ .4, .2 ] = .6
#I  Automorphism 1:
#I  Generator  1 --> 1 0 0 0 0 0 1 
#I  Generator  2 --> 0 1 0 0 0 0 0 
#I  Automorphism 2:
#I  Generator  1 --> 1 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 1 
#I  Number of stabiliser generators is 5
#I  Automorphism 1:
#I  Generator  1 --> 1 0 0 1 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 0 
#I  Automorphism 2:
#I  Generator  1 --> 1 0 0 0 1 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 0 
#I  Automorphism 3:
#I  Generator  1 --> 1 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 1 0 0 0 
#I  Automorphism 4:
#I  Generator  1 --> 1 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 1 0 0 
#I  Automorphism 5:
#I  Generator  1 --> 1 1 1 0 0 0 0 
#I  Generator  2 --> 0 1 1 1 0 0 0 
#I  Group: [grp] #7;3 #19;2 to lower exponent-2 central class 3 has order 2^7
#I  Class 1
#I  1 is defined on image of defining generator 1
#I  2 is defined on image of defining generator 2
#I  Class 2
#I  3 is defined on [2, 1] = 2 1 
#I  4 is defined on 1^2 = 1 1 
#I  5 is defined on 2^2 = 2 2 
#I  Class 3
#I  6 is defined on [3, 1] = 2 1 1 
#I  7 is defined on 4^2 = 1 1 1 
#I  Non-trivial powers:
#I   .1^2 = .4
#I   .2^2 = .5
#I   .4^2 = .7
#I   .5^2 = .7
#I  Non-trivial commutators:
#I  [ .2, .1 ] = .3
#I  [ .3, .1 ] = .6
#I  [ .4, .2 ] = .6
#I  Automorphism 1:
#I  Generator  1 --> 1 0 0 0 0 0 1 
#I  Generator  2 --> 0 1 0 0 0 0 0 
#I  Automorphism 2:
#I  Generator  1 --> 1 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 1 
#I  Number of stabiliser generators is 4
#I  Automorphism 1:
#I  Generator  1 --> 1 0 0 1 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 0 
#I  Automorphism 2:
#I  Generator  1 --> 1 0 0 0 1 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 0 
#I  Automorphism 3:
#I  Generator  1 --> 1 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 1 0 0 0 
#I  Automorphism 4:
#I  Generator  1 --> 1 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 1 0 0 
#I  Group: [grp] #7;3 #20;2 to lower exponent-2 central class 3 has order 2^7
#I  Class 1
#I  1 is defined on image of defining generator 1
#I  2 is defined on image of defining generator 2
#I  Class 2
#I  3 is defined on [2, 1] = 2 1 
#I  4 is defined on 1^2 = 1 1 
#I  5 is defined on 2^2 = 2 2 
#I  Class 3
#I  6 is defined on [3, 1] = 2 1 1 
#I  7 is defined on 4^2 = 1 1 1 
#I  Non-trivial powers:
#I   .1^2 = .4
#I   .2^2 = .5
#I   .4^2 = .7
#I   .5^2 = .6 .7
#I  Non-trivial commutators:
#I  [ .2, .1 ] = .3
#I  [ .3, .1 ] = .6
#I  [ .4, .2 ] = .6
#I  Automorphism 1:
#I  Generator  1 --> 1 0 0 0 0 0 1 
#I  Generator  2 --> 0 1 0 0 0 0 0 
#I  Automorphism 2:
#I  Generator  1 --> 1 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 1 
#I  Number of stabiliser generators is 4
#I  Automorphism 1:
#I  Generator  1 --> 1 0 0 1 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 0 
#I  Automorphism 2:
#I  Generator  1 --> 1 0 0 0 1 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 0 
#I  Automorphism 3:
#I  Generator  1 --> 1 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 1 0 0 0 
#I  Automorphism 4:
#I  Generator  1 --> 1 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 1 0 0 
#I  Group: [grp] #7;3 #21;2 to lower exponent-2 central class 3 has order 2^7
#I  Class 1
#I  1 is defined on image of defining generator 1
#I  2 is defined on image of defining generator 2
#I  Class 2
#I  3 is defined on [2, 1] = 2 1 
#I  4 is defined on 1^2 = 1 1 
#I  5 is defined on 2^2 = 2 2 
#I  Class 3
#I  6 is defined on [3, 1] = 2 1 1 
#I  7 is defined on [4, 2] = 1 1 2 
#I  Non-trivial powers:
#I   .1^2 = .4
#I   .2^2 = .5
#I   .3^2 = .6 .7
#I  Non-trivial commutators:
#I  [ .2, .1 ] = .3
#I  [ .3, .1 ] = .6
#I  [ .4, .2 ] = .7
#I  [ .5, .1 ] = .6 .7
#I  Automorphism 1:
#I  Generator  1 --> 1 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 1 0 
#I  Number of stabiliser generators is 4
#I  Automorphism 1:
#I  Generator  1 --> 1 0 0 1 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 0 
#I  Automorphism 2:
#I  Generator  1 --> 1 0 0 0 1 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 0 
#I  Automorphism 3:
#I  Generator  1 --> 1 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 1 0 0 0 
#I  Automorphism 4:
#I  Generator  1 --> 1 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 1 0 0 
#I  Group: [grp] #7;3 #22;2 to lower exponent-2 central class 3 has order 2^7
#I  Class 1
#I  1 is defined on image of defining generator 1
#I  2 is defined on image of defining generator 2
#I  Class 2
#I  3 is defined on [2, 1] = 2 1 
#I  4 is defined on 1^2 = 1 1 
#I  5 is defined on 2^2 = 2 2 
#I  Class 3
#I  6 is defined on [3, 1] = 2 1 1 
#I  7 is defined on [4, 2] = 1 1 2 
#I  Non-trivial powers:
#I   .1^2 = .4
#I   .2^2 = .5
#I   .3^2 = .6 .7
#I   .4^2 = .6
#I  Non-trivial commutators:
#I  [ .2, .1 ] = .3
#I  [ .3, .1 ] = .6
#I  [ .4, .2 ] = .7
#I  [ .5, .1 ] = .6 .7
#I  Automorphism 1:
#I  Generator  1 --> 1 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 1 0 
#I  Number of stabiliser generators is 4
#I  Automorphism 1:
#I  Generator  1 --> 1 0 0 1 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 0 
#I  Automorphism 2:
#I  Generator  1 --> 1 0 0 0 1 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 0 
#I  Automorphism 3:
#I  Generator  1 --> 1 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 1 0 0 0 
#I  Automorphism 4:
#I  Generator  1 --> 1 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 1 0 0 
#I  Group: [grp] #7;3 #23;2 to lower exponent-2 central class 3 has order 2^7
#I  Class 1
#I  1 is defined on image of defining generator 1
#I  2 is defined on image of defining generator 2
#I  Class 2
#I  3 is defined on [2, 1] = 2 1 
#I  4 is defined on 1^2 = 1 1 
#I  5 is defined on 2^2 = 2 2 
#I  Class 3
#I  6 is defined on [3, 1] = 2 1 1 
#I  7 is defined on [4, 2] = 1 1 2 
#I  Non-trivial powers:
#I   .1^2 = .4
#I   .2^2 = .5
#I   .3^2 = .6 .7
#I   .5^2 = .6
#I  Non-trivial commutators:
#I  [ .2, .1 ] = .3
#I  [ .3, .1 ] = .6
#I  [ .4, .2 ] = .7
#I  [ .5, .1 ] = .6 .7
#I  Automorphism 1:
#I  Generator  1 --> 1 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 1 0 
#I  Number of stabiliser generators is 4
#I  Automorphism 1:
#I  Generator  1 --> 1 0 0 1 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 0 
#I  Automorphism 2:
#I  Generator  1 --> 1 0 0 0 1 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 0 
#I  Automorphism 3:
#I  Generator  1 --> 1 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 1 0 0 0 
#I  Automorphism 4:
#I  Generator  1 --> 1 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 1 0 0 
#I  Group: [grp] #7;3 #24;2 to lower exponent-2 central class 3 has order 2^7
#I  Class 1
#I  1 is defined on image of defining generator 1
#I  2 is defined on image of defining generator 2
#I  Class 2
#I  3 is defined on [2, 1] = 2 1 
#I  4 is defined on 1^2 = 1 1 
#I  5 is defined on 2^2 = 2 2 
#I  Class 3
#I  6 is defined on [3, 1] = 2 1 1 
#I  7 is defined on [4, 2] = 1 1 2 
#I  Non-trivial powers:
#I   .1^2 = .4
#I   .2^2 = .5
#I   .3^2 = .6 .7
#I   .4^2 = .6
#I   .5^2 = .6
#I  Non-trivial commutators:
#I  [ .2, .1 ] = .3
#I  [ .3, .1 ] = .6
#I  [ .4, .2 ] = .7
#I  [ .5, .1 ] = .6 .7
#I  Automorphism 1:
#I  Generator  1 --> 1 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 1 0 
#I  Number of stabiliser generators is 4
#I  Automorphism 1:
#I  Generator  1 --> 1 0 0 1 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 0 
#I  Automorphism 2:
#I  Generator  1 --> 1 0 0 0 1 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 0 
#I  Automorphism 3:
#I  Generator  1 --> 1 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 1 0 0 0 
#I  Automorphism 4:
#I  Generator  1 --> 1 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 1 0 0 
#I  Group: [grp] #7;3 #25;2 to lower exponent-2 central class 3 has order 2^7
#I  Class 1
#I  1 is defined on image of defining generator 1
#I  2 is defined on image of defining generator 2
#I  Class 2
#I  3 is defined on [2, 1] = 2 1 
#I  4 is defined on 1^2 = 1 1 
#I  5 is defined on 2^2 = 2 2 
#I  Class 3
#I  6 is defined on [3, 1] = 2 1 1 
#I  7 is defined on [4, 2] = 1 1 2 
#I  Non-trivial powers:
#I   .1^2 = .4
#I   .2^2 = .5
#I   .3^2 = .6 .7
#I   .5^2 = .7
#I  Non-trivial commutators:
#I  [ .2, .1 ] = .3
#I  [ .3, .1 ] = .6
#I  [ .4, .2 ] = .7
#I  [ .5, .1 ] = .6 .7
#I  Automorphism 1:
#I  Generator  1 --> 1 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 1 0 
#I  Number of stabiliser generators is 4
#I  Automorphism 1:
#I  Generator  1 --> 1 0 0 1 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 0 
#I  Automorphism 2:
#I  Generator  1 --> 1 0 0 0 1 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 0 
#I  Automorphism 3:
#I  Generator  1 --> 1 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 1 0 0 0 
#I  Automorphism 4:
#I  Generator  1 --> 1 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 1 0 0 
#I  Group: [grp] #7;3 #26;2 to lower exponent-2 central class 3 has order 2^7
#I  Class 1
#I  1 is defined on image of defining generator 1
#I  2 is defined on image of defining generator 2
#I  Class 2
#I  3 is defined on [2, 1] = 2 1 
#I  4 is defined on 1^2 = 1 1 
#I  5 is defined on 2^2 = 2 2 
#I  Class 3
#I  6 is defined on [3, 1] = 2 1 1 
#I  7 is defined on [4, 2] = 1 1 2 
#I  Non-trivial powers:
#I   .1^2 = .4
#I   .2^2 = .5
#I   .3^2 = .6 .7
#I   .5^2 = .6 .7
#I  Non-trivial commutators:
#I  [ .2, .1 ] = .3
#I  [ .3, .1 ] = .6
#I  [ .4, .2 ] = .7
#I  [ .5, .1 ] = .6 .7
#I  Automorphism 1:
#I  Generator  1 --> 1 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 1 0 
#I  Number of stabiliser generators is 5
#I  Automorphism 1:
#I  Generator  1 --> 1 0 0 1 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 0 
#I  Automorphism 2:
#I  Generator  1 --> 1 0 0 0 1 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 0 
#I  Automorphism 3:
#I  Generator  1 --> 1 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 1 0 0 0 
#I  Automorphism 4:
#I  Generator  1 --> 1 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 1 0 0 
#I  Automorphism 5:
#I  Generator  1 --> 1 1 1 0 0 0 0 
#I  Generator  2 --> 0 1 1 1 0 0 0 
#I  Group: [grp] #7;3 #27;2 to lower exponent-2 central class 3 has order 2^7
#I  Class 1
#I  1 is defined on image of defining generator 1
#I  2 is defined on image of defining generator 2
#I  Class 2
#I  3 is defined on [2, 1] = 2 1 
#I  4 is defined on 1^2 = 1 1 
#I  5 is defined on 2^2 = 2 2 
#I  Class 3
#I  6 is defined on [3, 1] = 2 1 1 
#I  7 is defined on [4, 2] = 1 1 2 
#I  Non-trivial powers:
#I   .1^2 = .4
#I   .2^2 = .5
#I   .3^2 = .6 .7
#I   .4^2 = .6
#I   .5^2 = .6 .7
#I  Non-trivial commutators:
#I  [ .2, .1 ] = .3
#I  [ .3, .1 ] = .6
#I  [ .4, .2 ] = .7
#I  [ .5, .1 ] = .6 .7
#I  Automorphism 1:
#I  Generator  1 --> 1 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 1 0 
#I  Number of stabiliser generators is 5
#I  Automorphism 1:
#I  Generator  1 --> 1 0 0 1 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 0 
#I  Automorphism 2:
#I  Generator  1 --> 1 0 0 0 1 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 0 
#I  Automorphism 3:
#I  Generator  1 --> 1 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 1 0 0 0 
#I  Automorphism 4:
#I  Generator  1 --> 1 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 1 0 0 
#I  Automorphism 5:
#I  Generator  1 --> 1 1 1 0 0 0 0 
#I  Generator  2 --> 0 1 1 1 0 0 0 
#I  Group: [grp] #7;3 #28;2 to lower exponent-2 central class 3 has order 2^7
#I  Class 1
#I  1 is defined on image of defining generator 1
#I  2 is defined on image of defining generator 2
#I  Class 2
#I  3 is defined on [2, 1] = 2 1 
#I  4 is defined on 1^2 = 1 1 
#I  5 is defined on 2^2 = 2 2 
#I  Class 3
#I  6 is defined on [3, 1] = 2 1 1 
#I  7 is defined on [4, 2] = 1 1 2 
#I  Non-trivial powers:
#I   .1^2 = .4
#I   .2^2 = .5
#I   .3^2 = .6 .7
#I   .4^2 = .7
#I   .5^2 = .7
#I  Non-trivial commutators:
#I  [ .2, .1 ] = .3
#I  [ .3, .1 ] = .6
#I  [ .4, .2 ] = .7
#I  [ .5, .1 ] = .6 .7
#I  Automorphism 1:
#I  Generator  1 --> 1 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 1 0 
#I  Number of stabiliser generators is 4
#I  Automorphism 1:
#I  Generator  1 --> 1 0 0 1 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 0 
#I  Automorphism 2:
#I  Generator  1 --> 1 0 0 0 1 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 0 
#I  Automorphism 3:
#I  Generator  1 --> 1 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 1 0 0 0 
#I  Automorphism 4:
#I  Generator  1 --> 1 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 1 0 0 
#I  Group: [grp] #7;3 #29;2 to lower exponent-2 central class 3 has order 2^7
#I  Class 1
#I  1 is defined on image of defining generator 1
#I  2 is defined on image of defining generator 2
#I  Class 2
#I  3 is defined on [2, 1] = 2 1 
#I  4 is defined on 1^2 = 1 1 
#I  5 is defined on 2^2 = 2 2 
#I  Class 3
#I  6 is defined on [3, 1] = 2 1 1 
#I  7 is defined on [4, 2] = 1 1 2 
#I  Non-trivial powers:
#I   .1^2 = .4
#I   .2^2 = .5
#I   .3^2 = .6 .7
#I   .4^2 = .7
#I   .5^2 = .6 .7
#I  Non-trivial commutators:
#I  [ .2, .1 ] = .3
#I  [ .3, .1 ] = .6
#I  [ .4, .2 ] = .7
#I  [ .5, .1 ] = .6 .7
#I  Automorphism 1:
#I  Generator  1 --> 1 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 1 0 
#I  Number of stabiliser generators is 5
#I  Automorphism 1:
#I  Generator  1 --> 1 0 0 1 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 0 
#I  Automorphism 2:
#I  Generator  1 --> 1 0 0 0 1 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 0 
#I  Automorphism 3:
#I  Generator  1 --> 1 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 1 0 0 0 
#I  Automorphism 4:
#I  Generator  1 --> 1 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 1 0 0 
#I  Automorphism 5:
#I  Generator  1 --> 1 1 1 0 0 0 0 
#I  Generator  2 --> 0 1 1 1 0 0 0 
#I  Group: [grp] #7;3 #30;2 to lower exponent-2 central class 3 has order 2^7
#I  Class 1
#I  1 is defined on image of defining generator 1
#I  2 is defined on image of defining generator 2
#I  Class 2
#I  3 is defined on [2, 1] = 2 1 
#I  4 is defined on 1^2 = 1 1 
#I  5 is defined on 2^2 = 2 2 
#I  Class 3
#I  6 is defined on [3, 1] = 2 1 1 
#I  7 is defined on [4, 2] = 1 1 2 
#I  Non-trivial powers:
#I   .1^2 = .4
#I   .2^2 = .5
#I   .3^2 = .6 .7
#I   .4^2 = .6 .7
#I   .5^2 = .6 .7
#I  Non-trivial commutators:
#I  [ .2, .1 ] = .3
#I  [ .3, .1 ] = .6
#I  [ .4, .2 ] = .7
#I  [ .5, .1 ] = .6 .7
#I  Automorphism 1:
#I  Generator  1 --> 1 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 1 0 
#I  Number of stabiliser generators is 5
#I  Automorphism 1:
#I  Generator  1 --> 1 0 0 1 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 0 
#I  Automorphism 2:
#I  Generator  1 --> 1 0 0 0 1 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 0 
#I  Automorphism 3:
#I  Generator  1 --> 1 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 1 0 0 0 
#I  Automorphism 4:
#I  Generator  1 --> 1 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 1 0 0 
#I  Automorphism 5:
#I  Generator  1 --> 1 1 1 0 0 0 0 
#I  Generator  2 --> 0 1 1 1 0 0 0 
#I  Group: [grp] #7;3 #31;2 to lower exponent-2 central class 3 has order 2^7
#I  Class 1
#I  1 is defined on image of defining generator 1
#I  2 is defined on image of defining generator 2
#I  Class 2
#I  3 is defined on [2, 1] = 2 1 
#I  4 is defined on 1^2 = 1 1 
#I  5 is defined on 2^2 = 2 2 
#I  Class 3
#I  6 is defined on [3, 1] = 2 1 1 
#I  7 is defined on [3, 2] = 2 1 2 
#I  Non-trivial powers:
#I   .1^2 = .4
#I   .2^2 = .5
#I  Non-trivial commutators:
#I  [ .2, .1 ] = .3
#I  [ .3, .1 ] = .6
#I  [ .3, .2 ] = .7
#I  [ .4, .2 ] = .6
#I  [ .5, .1 ] = .7
#I  Automorphism 1:
#I  Generator  1 --> 1 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 1 
#I  Number of stabiliser generators is 6
#I  Automorphism 1:
#I  Generator  1 --> 1 0 0 1 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 0 
#I  Automorphism 2:
#I  Generator  1 --> 1 0 0 0 1 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 0 
#I  Automorphism 3:
#I  Generator  1 --> 1 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 1 0 0 0 
#I  Automorphism 4:
#I  Generator  1 --> 1 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 1 0 0 
#I  Automorphism 5:
#I  Generator  1 --> 0 1 0 0 0 0 0 
#I  Generator  2 --> 1 1 0 0 0 0 0 
#I  Automorphism 6:
#I  Generator  1 --> 0 1 0 0 0 0 0 
#I  Generator  2 --> 1 0 0 0 0 0 0 
#I  Group: [grp] #7;3 #32;2 to lower exponent-2 central class 3 has order 2^7
#I  Class 1
#I  1 is defined on image of defining generator 1
#I  2 is defined on image of defining generator 2
#I  Class 2
#I  3 is defined on [2, 1] = 2 1 
#I  4 is defined on 1^2 = 1 1 
#I  5 is defined on 2^2 = 2 2 
#I  Class 3
#I  6 is defined on [3, 1] = 2 1 1 
#I  7 is defined on [3, 2] = 2 1 2 
#I  Non-trivial powers:
#I   .1^2 = .4
#I   .2^2 = .5
#I   .4^2 = .6
#I  Non-trivial commutators:
#I  [ .2, .1 ] = .3
#I  [ .3, .1 ] = .6
#I  [ .3, .2 ] = .7
#I  [ .4, .2 ] = .6
#I  [ .5, .1 ] = .7
#I  Automorphism 1:
#I  Generator  1 --> 1 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 1 
#I  Number of stabiliser generators is 4
#I  Automorphism 1:
#I  Generator  1 --> 1 0 0 1 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 0 
#I  Automorphism 2:
#I  Generator  1 --> 1 0 0 0 1 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 0 
#I  Automorphism 3:
#I  Generator  1 --> 1 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 1 0 0 0 
#I  Automorphism 4:
#I  Generator  1 --> 1 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 1 0 0 
#I  Group: [grp] #7;3 #33;2 to lower exponent-2 central class 3 has order 2^7
#I  Class 1
#I  1 is defined on image of defining generator 1
#I  2 is defined on image of defining generator 2
#I  Class 2
#I  3 is defined on [2, 1] = 2 1 
#I  4 is defined on 1^2 = 1 1 
#I  5 is defined on 2^2 = 2 2 
#I  Class 3
#I  6 is defined on [3, 1] = 2 1 1 
#I  7 is defined on [3, 2] = 2 1 2 
#I  Non-trivial powers:
#I   .1^2 = .4
#I   .2^2 = .5
#I   .5^2 = .6
#I  Non-trivial commutators:
#I  [ .2, .1 ] = .3
#I  [ .3, .1 ] = .6
#I  [ .3, .2 ] = .7
#I  [ .4, .2 ] = .6
#I  [ .5, .1 ] = .7
#I  Automorphism 1:
#I  Generator  1 --> 1 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 1 
#I  Number of stabiliser generators is 5
#I  Automorphism 1:
#I  Generator  1 --> 1 0 0 1 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 0 
#I  Automorphism 2:
#I  Generator  1 --> 1 0 0 0 1 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 0 
#I  Automorphism 3:
#I  Generator  1 --> 1 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 1 0 0 0 
#I  Automorphism 4:
#I  Generator  1 --> 1 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 1 0 0 
#I  Automorphism 5:
#I  Generator  1 --> 1 0 0 0 0 0 0 
#I  Generator  2 --> 1 1 1 0 0 0 0 
#I  Group: [grp] #7;3 #34;2 to lower exponent-2 central class 3 has order 2^7
#I  Class 1
#I  1 is defined on image of defining generator 1
#I  2 is defined on image of defining generator 2
#I  Class 2
#I  3 is defined on [2, 1] = 2 1 
#I  4 is defined on 1^2 = 1 1 
#I  5 is defined on 2^2 = 2 2 
#I  Class 3
#I  6 is defined on [3, 1] = 2 1 1 
#I  7 is defined on [3, 2] = 2 1 2 
#I  Non-trivial powers:
#I   .1^2 = .4
#I   .2^2 = .5
#I   .4^2 = .7
#I   .5^2 = .6
#I  Non-trivial commutators:
#I  [ .2, .1 ] = .3
#I  [ .3, .1 ] = .6
#I  [ .3, .2 ] = .7
#I  [ .4, .2 ] = .6
#I  [ .5, .1 ] = .7
#I  Automorphism 1:
#I  Generator  1 --> 1 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 1 
#I  Number of stabiliser generators is 5
#I  Automorphism 1:
#I  Generator  1 --> 1 0 0 1 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 0 
#I  Automorphism 2:
#I  Generator  1 --> 1 0 0 0 1 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 0 
#I  Automorphism 3:
#I  Generator  1 --> 1 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 1 0 0 0 
#I  Automorphism 4:
#I  Generator  1 --> 1 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 1 0 0 
#I  Automorphism 5:
#I  Generator  1 --> 0 1 0 0 0 0 0 
#I  Generator  2 --> 1 0 0 0 0 0 0 
#I  Group: [grp] #7;3 #35;2 to lower exponent-2 central class 3 has order 2^7
#I  Class 1
#I  1 is defined on image of defining generator 1
#I  2 is defined on image of defining generator 2
#I  Class 2
#I  3 is defined on [2, 1] = 2 1 
#I  4 is defined on 1^2 = 1 1 
#I  5 is defined on 2^2 = 2 2 
#I  Class 3
#I  6 is defined on [3, 1] = 2 1 1 
#I  7 is defined on [3, 2] = 2 1 2 
#I  Non-trivial powers:
#I   .1^2 = .4
#I   .2^2 = .5
#I   .4^2 = .6 .7
#I   .5^2 = .6
#I  Non-trivial commutators:
#I  [ .2, .1 ] = .3
#I  [ .3, .1 ] = .6
#I  [ .3, .2 ] = .7
#I  [ .4, .2 ] = .6
#I  [ .5, .1 ] = .7
#I  Automorphism 1:
#I  Generator  1 --> 1 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 1 
#I  Number of stabiliser generators is 5
#I  Automorphism 1:
#I  Generator  1 --> 1 0 0 1 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 0 
#I  Automorphism 2:
#I  Generator  1 --> 1 0 0 0 1 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 0 
#I  Automorphism 3:
#I  Generator  1 --> 1 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 1 0 0 0 
#I  Automorphism 4:
#I  Generator  1 --> 1 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 1 0 0 
#I  Automorphism 5:
#I  Generator  1 --> 0 1 0 0 0 0 0 
#I  Generator  2 --> 1 1 0 0 0 0 0 
#I  Group: [grp] #7;3 #36;2 to lower exponent-2 central class 3 has order 2^7
#I  Class 1
#I  1 is defined on image of defining generator 1
#I  2 is defined on image of defining generator 2
#I  Class 2
#I  3 is defined on [2, 1] = 2 1 
#I  4 is defined on 1^2 = 1 1 
#I  5 is defined on 2^2 = 2 2 
#I  Class 3
#I  6 is defined on [3, 1] = 2 1 1 
#I  7 is defined on [3, 2] = 2 1 2 
#I  Non-trivial powers:
#I   .1^2 = .4
#I   .2^2 = .5
#I   .4^2 = .6
#I   .5^2 = .7
#I  Non-trivial commutators:
#I  [ .2, .1 ] = .3
#I  [ .3, .1 ] = .6
#I  [ .3, .2 ] = .7
#I  [ .4, .2 ] = .6
#I  [ .5, .1 ] = .7
#I  Automorphism 1:
#I  Generator  1 --> 1 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 1 
#I  Number of stabiliser generators is 6
#I  Automorphism 1:
#I  Generator  1 --> 1 0 0 1 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 0 
#I  Automorphism 2:
#I  Generator  1 --> 1 0 0 0 1 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 0 
#I  Automorphism 3:
#I  Generator  1 --> 1 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 1 0 0 0 
#I  Automorphism 4:
#I  Generator  1 --> 1 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 1 0 0 
#I  Automorphism 5:
#I  Generator  1 --> 0 1 0 0 0 0 0 
#I  Generator  2 --> 1 1 0 0 0 0 0 
#I  Automorphism 6:
#I  Generator  1 --> 0 1 0 0 0 0 0 
#I  Generator  2 --> 1 0 0 0 0 0 0 
#I  Group: [grp] #7;3 #37;2 to lower exponent-2 central class 3 has order 2^7
#I  Class 1
#I  1 is defined on image of defining generator 1
#I  2 is defined on image of defining generator 2
#I  Class 2
#I  3 is defined on [2, 1] = 2 1 
#I  4 is defined on 1^2 = 1 1 
#I  5 is defined on 2^2 = 2 2 
#I  Class 3
#I  6 is defined on [3, 1] = 2 1 1 
#I  7 is defined on [3, 2] = 2 1 2 
#I  Non-trivial powers:
#I   .1^2 = .4
#I   .2^2 = .5
#I   .3^2 = .6
#I  Non-trivial commutators:
#I  [ .2, .1 ] = .3
#I  [ .3, .1 ] = .6
#I  [ .3, .2 ] = .7
#I  [ .5, .1 ] = .6 .7
#I  Automorphism 1:
#I  Generator  1 --> 1 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 1 0 
#I  Automorphism 2:
#I  Generator  1 --> 1 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 1 
#I  Number of stabiliser generators is 4
#I  Automorphism 1:
#I  Generator  1 --> 1 0 0 1 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 0 
#I  Automorphism 2:
#I  Generator  1 --> 1 0 0 0 1 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 0 
#I  Automorphism 3:
#I  Generator  1 --> 1 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 1 0 0 0 
#I  Automorphism 4:
#I  Generator  1 --> 1 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 1 0 0 
#I  Group: [grp] #7;3 #38;2 to lower exponent-2 central class 3 has order 2^7
#I  Class 1
#I  1 is defined on image of defining generator 1
#I  2 is defined on image of defining generator 2
#I  Class 2
#I  3 is defined on [2, 1] = 2 1 
#I  4 is defined on 1^2 = 1 1 
#I  5 is defined on 2^2 = 2 2 
#I  Class 3
#I  6 is defined on [3, 1] = 2 1 1 
#I  7 is defined on [3, 2] = 2 1 2 
#I  Non-trivial powers:
#I   .1^2 = .4
#I   .2^2 = .5
#I   .3^2 = .6
#I   .5^2 = .7
#I  Non-trivial commutators:
#I  [ .2, .1 ] = .3
#I  [ .3, .1 ] = .6
#I  [ .3, .2 ] = .7
#I  [ .5, .1 ] = .6 .7
#I  Automorphism 1:
#I  Generator  1 --> 1 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 1 0 
#I  Automorphism 2:
#I  Generator  1 --> 1 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 1 
#I  Number of stabiliser generators is 5
#I  Automorphism 1:
#I  Generator  1 --> 1 0 0 1 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 0 
#I  Automorphism 2:
#I  Generator  1 --> 1 0 0 0 1 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 0 
#I  Automorphism 3:
#I  Generator  1 --> 1 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 1 0 0 0 
#I  Automorphism 4:
#I  Generator  1 --> 1 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 1 0 0 
#I  Automorphism 5:
#I  Generator  1 --> 1 0 0 0 0 0 0 
#I  Generator  2 --> 1 1 1 0 0 0 0 
#I  Group: [grp] #7;3 #39;2 to lower exponent-2 central class 3 has order 2^7
#I  Class 1
#I  1 is defined on image of defining generator 1
#I  2 is defined on image of defining generator 2
#I  Class 2
#I  3 is defined on [2, 1] = 2 1 
#I  4 is defined on 1^2 = 1 1 
#I  5 is defined on 2^2 = 2 2 
#I  Class 3
#I  6 is defined on [3, 1] = 2 1 1 
#I  7 is defined on [3, 2] = 2 1 2 
#I  Non-trivial powers:
#I   .1^2 = .4
#I   .2^2 = .5
#I   .3^2 = .6
#I   .5^2 = .6 .7
#I  Non-trivial commutators:
#I  [ .2, .1 ] = .3
#I  [ .3, .1 ] = .6
#I  [ .3, .2 ] = .7
#I  [ .5, .1 ] = .6 .7
#I  Automorphism 1:
#I  Generator  1 --> 1 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 1 0 
#I  Automorphism 2:
#I  Generator  1 --> 1 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 1 
#I  Number of stabiliser generators is 5
#I  Automorphism 1:
#I  Generator  1 --> 1 0 0 1 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 0 
#I  Automorphism 2:
#I  Generator  1 --> 1 0 0 0 1 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 0 
#I  Automorphism 3:
#I  Generator  1 --> 1 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 1 0 0 0 
#I  Automorphism 4:
#I  Generator  1 --> 1 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 1 0 0 
#I  Automorphism 5:
#I  Generator  1 --> 1 0 0 0 0 0 0 
#I  Generator  2 --> 1 1 1 0 0 0 0 
#I  Group: [grp] #7;3 #40;2 to lower exponent-2 central class 3 has order 2^7
#I  Class 1
#I  1 is defined on image of defining generator 1
#I  2 is defined on image of defining generator 2
#I  Class 2
#I  3 is defined on [2, 1] = 2 1 
#I  4 is defined on 1^2 = 1 1 
#I  5 is defined on 2^2 = 2 2 
#I  Class 3
#I  6 is defined on [3, 1] = 2 1 1 
#I  7 is defined on [3, 2] = 2 1 2 
#I  Non-trivial powers:
#I   .1^2 = .4
#I   .2^2 = .5
#I   .3^2 = .6
#I   .4^2 = .6
#I  Non-trivial commutators:
#I  [ .2, .1 ] = .3
#I  [ .3, .1 ] = .6
#I  [ .3, .2 ] = .7
#I  [ .5, .1 ] = .6 .7
#I  Automorphism 1:
#I  Generator  1 --> 1 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 1 0 
#I  Automorphism 2:
#I  Generator  1 --> 1 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 1 
#I  Number of stabiliser generators is 5
#I  Automorphism 1:
#I  Generator  1 --> 1 0 0 1 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 0 
#I  Automorphism 2:
#I  Generator  1 --> 1 0 0 0 1 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 0 
#I  Automorphism 3:
#I  Generator  1 --> 1 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 1 0 0 0 
#I  Automorphism 4:
#I  Generator  1 --> 1 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 1 0 0 
#I  Automorphism 5:
#I  Generator  1 --> 1 0 0 0 0 0 0 
#I  Generator  2 --> 1 1 1 0 0 0 0 
#I  Group: [grp] #7;3 #41;2 to lower exponent-2 central class 3 has order 2^7
#I  Class 1
#I  1 is defined on image of defining generator 1
#I  2 is defined on image of defining generator 2
#I  Class 2
#I  3 is defined on [2, 1] = 2 1 
#I  4 is defined on 1^2 = 1 1 
#I  5 is defined on 2^2 = 2 2 
#I  Class 3
#I  6 is defined on [3, 1] = 2 1 1 
#I  7 is defined on [3, 2] = 2 1 2 
#I  Non-trivial powers:
#I   .1^2 = .4
#I   .2^2 = .5
#I   .3^2 = .6
#I   .4^2 = .6
#I   .5^2 = .6
#I  Non-trivial commutators:
#I  [ .2, .1 ] = .3
#I  [ .3, .1 ] = .6
#I  [ .3, .2 ] = .7
#I  [ .5, .1 ] = .6 .7
#I  Automorphism 1:
#I  Generator  1 --> 1 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 1 0 
#I  Automorphism 2:
#I  Generator  1 --> 1 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 1 
#I  Number of stabiliser generators is 5
#I  Automorphism 1:
#I  Generator  1 --> 1 0 0 1 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 0 
#I  Automorphism 2:
#I  Generator  1 --> 1 0 0 0 1 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 0 
#I  Automorphism 3:
#I  Generator  1 --> 1 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 1 0 0 0 
#I  Automorphism 4:
#I  Generator  1 --> 1 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 1 0 0 
#I  Automorphism 5:
#I  Generator  1 --> 1 0 0 0 0 0 0 
#I  Generator  2 --> 1 1 1 0 0 0 0 
#I  Group: [grp] #7;3 #42;2 to lower exponent-2 central class 3 has order 2^7
#I  Class 1
#I  1 is defined on image of defining generator 1
#I  2 is defined on image of defining generator 2
#I  Class 2
#I  3 is defined on [2, 1] = 2 1 
#I  4 is defined on 1^2 = 1 1 
#I  5 is defined on 2^2 = 2 2 
#I  Class 3
#I  6 is defined on [3, 1] = 2 1 1 
#I  7 is defined on [3, 2] = 2 1 2 
#I  Non-trivial powers:
#I   .1^2 = .4
#I   .2^2 = .5
#I   .3^2 = .6
#I   .4^2 = .6
#I   .5^2 = .7
#I  Non-trivial commutators:
#I  [ .2, .1 ] = .3
#I  [ .3, .1 ] = .6
#I  [ .3, .2 ] = .7
#I  [ .5, .1 ] = .6 .7
#I  Automorphism 1:
#I  Generator  1 --> 1 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 1 0 
#I  Automorphism 2:
#I  Generator  1 --> 1 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 1 
#I  Number of stabiliser generators is 4
#I  Automorphism 1:
#I  Generator  1 --> 1 0 0 1 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 0 
#I  Automorphism 2:
#I  Generator  1 --> 1 0 0 0 1 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 0 
#I  Automorphism 3:
#I  Generator  1 --> 1 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 1 0 0 0 
#I  Automorphism 4:
#I  Generator  1 --> 1 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 1 0 0 
#I  Group: [grp] #7;3 #43;2 to lower exponent-2 central class 3 has order 2^7
#I  Class 1
#I  1 is defined on image of defining generator 1
#I  2 is defined on image of defining generator 2
#I  Class 2
#I  3 is defined on [2, 1] = 2 1 
#I  4 is defined on 1^2 = 1 1 
#I  5 is defined on 2^2 = 2 2 
#I  Class 3
#I  6 is defined on [3, 1] = 2 1 1 
#I  7 is defined on [3, 2] = 2 1 2 
#I  Non-trivial powers:
#I   .1^2 = .4
#I   .2^2 = .5
#I   .3^2 = .6
#I   .4^2 = .7
#I  Non-trivial commutators:
#I  [ .2, .1 ] = .3
#I  [ .3, .1 ] = .6
#I  [ .3, .2 ] = .7
#I  [ .5, .1 ] = .6 .7
#I  Automorphism 1:
#I  Generator  1 --> 1 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 1 0 
#I  Automorphism 2:
#I  Generator  1 --> 1 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 1 
#I  Number of stabiliser generators is 4
#I  Automorphism 1:
#I  Generator  1 --> 1 0 0 1 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 0 
#I  Automorphism 2:
#I  Generator  1 --> 1 0 0 0 1 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 0 
#I  Automorphism 3:
#I  Generator  1 --> 1 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 1 0 0 0 
#I  Automorphism 4:
#I  Generator  1 --> 1 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 1 0 0 
#I  Group: [grp] #7;3 #44;2 to lower exponent-2 central class 3 has order 2^7
#I  Class 1
#I  1 is defined on image of defining generator 1
#I  2 is defined on image of defining generator 2
#I  Class 2
#I  3 is defined on [2, 1] = 2 1 
#I  4 is defined on 1^2 = 1 1 
#I  5 is defined on 2^2 = 2 2 
#I  Class 3
#I  6 is defined on [3, 1] = 2 1 1 
#I  7 is defined on [3, 2] = 2 1 2 
#I  Non-trivial powers:
#I   .1^2 = .4
#I   .2^2 = .5
#I   .3^2 = .6
#I   .4^2 = .7
#I   .5^2 = .6
#I  Non-trivial commutators:
#I  [ .2, .1 ] = .3
#I  [ .3, .1 ] = .6
#I  [ .3, .2 ] = .7
#I  [ .5, .1 ] = .6 .7
#I  Automorphism 1:
#I  Generator  1 --> 1 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 1 0 
#I  Automorphism 2:
#I  Generator  1 --> 1 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 1 
#I  Number of stabiliser generators is 4
#I  Automorphism 1:
#I  Generator  1 --> 1 0 0 1 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 0 
#I  Automorphism 2:
#I  Generator  1 --> 1 0 0 0 1 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 0 
#I  Automorphism 3:
#I  Generator  1 --> 1 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 1 0 0 0 
#I  Automorphism 4:
#I  Generator  1 --> 1 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 1 0 0 
#I  Group: [grp] #7;3 #45;2 to lower exponent-2 central class 3 has order 2^7
#I  Class 1
#I  1 is defined on image of defining generator 1
#I  2 is defined on image of defining generator 2
#I  Class 2
#I  3 is defined on [2, 1] = 2 1 
#I  4 is defined on 1^2 = 1 1 
#I  5 is defined on 2^2 = 2 2 
#I  Class 3
#I  6 is defined on [3, 1] = 2 1 1 
#I  7 is defined on [3, 2] = 2 1 2 
#I  Non-trivial powers:
#I   .1^2 = .4
#I   .2^2 = .5
#I   .3^2 = .6
#I   .4^2 = .7
#I   .5^2 = .7
#I  Non-trivial commutators:
#I  [ .2, .1 ] = .3
#I  [ .3, .1 ] = .6
#I  [ .3, .2 ] = .7
#I  [ .5, .1 ] = .6 .7
#I  Automorphism 1:
#I  Generator  1 --> 1 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 1 0 
#I  Automorphism 2:
#I  Generator  1 --> 1 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 1 
#I  Number of stabiliser generators is 4
#I  Automorphism 1:
#I  Generator  1 --> 1 0 0 1 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 0 
#I  Automorphism 2:
#I  Generator  1 --> 1 0 0 0 1 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 0 
#I  Automorphism 3:
#I  Generator  1 --> 1 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 1 0 0 0 
#I  Automorphism 4:
#I  Generator  1 --> 1 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 1 0 0 
#I  Group: [grp] #7;3 #46;2 to lower exponent-2 central class 3 has order 2^7
#I  Class 1
#I  1 is defined on image of defining generator 1
#I  2 is defined on image of defining generator 2
#I  Class 2
#I  3 is defined on [2, 1] = 2 1 
#I  4 is defined on 1^2 = 1 1 
#I  5 is defined on 2^2 = 2 2 
#I  Class 3
#I  6 is defined on [3, 1] = 2 1 1 
#I  7 is defined on [3, 2] = 2 1 2 
#I  Non-trivial powers:
#I   .1^2 = .4
#I   .2^2 = .5
#I   .3^2 = .6
#I   .4^2 = .7
#I   .5^2 = .6 .7
#I  Non-trivial commutators:
#I  [ .2, .1 ] = .3
#I  [ .3, .1 ] = .6
#I  [ .3, .2 ] = .7
#I  [ .5, .1 ] = .6 .7
#I  Automorphism 1:
#I  Generator  1 --> 1 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 1 0 
#I  Automorphism 2:
#I  Generator  1 --> 1 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 1 
#I  Number of stabiliser generators is 4
#I  Automorphism 1:
#I  Generator  1 --> 1 0 0 1 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 0 
#I  Automorphism 2:
#I  Generator  1 --> 1 0 0 0 1 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 0 
#I  Automorphism 3:
#I  Generator  1 --> 1 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 1 0 0 0 
#I  Automorphism 4:
#I  Generator  1 --> 1 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 1 0 0 
#I  # of immediate descendants of order 2^7 is 37
#I  # of capable immediate descendants is 28
#I  Group: [grp] #7;3 #47;3 to lower exponent-2 central class 3 has order 2^8
#I  Class 1
#I  1 is defined on image of defining generator 1
#I  2 is defined on image of defining generator 2
#I  Class 2
#I  3 is defined on [2, 1] = 2 1 
#I  4 is defined on 1^2 = 1 1 
#I  5 is defined on 2^2 = 2 2 
#I  Class 3
#I  6 is defined on [4, 2] = 1 1 2 
#I  7 is defined on 4^2 = 1 1 1 
#I  8 is defined on 5^2 = 2 2 2 
#I  Non-trivial powers:
#I   .1^2 = .4
#I   .2^2 = .5
#I   .3^2 = .6
#I   .4^2 = .7
#I   .5^2 = .8
#I  Non-trivial commutators:
#I  [ .2, .1 ] = .3
#I  [ .4, .2 ] = .6
#I  [ .5, .1 ] = .6
#I  Automorphism 1:
#I  Generator  1 --> 1 0 0 0 0 0 1 0 
#I  Generator  2 --> 0 1 0 0 0 0 0 0 
#I  Automorphism 2:
#I  Generator  1 --> 1 0 0 0 0 0 0 1 
#I  Generator  2 --> 0 1 0 0 0 0 0 0 
#I  Automorphism 3:
#I  Generator  1 --> 1 0 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 1 0 
#I  Automorphism 4:
#I  Generator  1 --> 1 0 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 0 1 
#I  Number of stabiliser generators is 6
#I  Automorphism 1:
#I  Generator  1 --> 1 0 0 1 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 0 0 
#I  Automorphism 2:
#I  Generator  1 --> 1 0 0 0 1 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 0 0 
#I  Automorphism 3:
#I  Generator  1 --> 1 0 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 1 0 0 0 0 
#I  Automorphism 4:
#I  Generator  1 --> 1 0 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 1 0 0 0 
#I  Automorphism 5:
#I  Generator  1 --> 0 1 0 0 0 0 0 0 
#I  Generator  2 --> 1 1 0 0 0 0 0 0 
#I  Automorphism 6:
#I  Generator  1 --> 0 1 0 0 0 0 0 0 
#I  Generator  2 --> 1 0 0 0 0 0 0 0 
#I  Group: [grp] #7;3 #48;3 to lower exponent-2 central class 3 has order 2^8
#I  Class 1
#I  1 is defined on image of defining generator 1
#I  2 is defined on image of defining generator 2
#I  Class 2
#I  3 is defined on [2, 1] = 2 1 
#I  4 is defined on 1^2 = 1 1 
#I  5 is defined on 2^2 = 2 2 
#I  Class 3
#I  6 is defined on [3, 1] = 2 1 1 
#I  7 is defined on 4^2 = 1 1 1 
#I  8 is defined on 5^2 = 2 2 2 
#I  Non-trivial powers:
#I   .1^2 = .4
#I   .2^2 = .5
#I   .3^2 = .6
#I   .4^2 = .7
#I   .5^2 = .8
#I  Non-trivial commutators:
#I  [ .2, .1 ] = .3
#I  [ .3, .1 ] = .6
#I  [ .5, .1 ] = .6
#I  Automorphism 1:
#I  Generator  1 --> 1 0 0 0 0 0 1 0 
#I  Generator  2 --> 0 1 0 0 0 0 0 0 
#I  Automorphism 2:
#I  Generator  1 --> 1 0 0 0 0 0 0 1 
#I  Generator  2 --> 0 1 0 0 0 0 0 0 
#I  Automorphism 3:
#I  Generator  1 --> 1 0 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 1 0 0 
#I  Automorphism 4:
#I  Generator  1 --> 1 0 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 1 0 
#I  Automorphism 5:
#I  Generator  1 --> 1 0 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 0 1 
#I  Number of stabiliser generators is 5
#I  Automorphism 1:
#I  Generator  1 --> 1 0 0 1 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 0 0 
#I  Automorphism 2:
#I  Generator  1 --> 1 0 0 0 1 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 0 0 
#I  Automorphism 3:
#I  Generator  1 --> 1 0 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 1 0 0 0 0 
#I  Automorphism 4:
#I  Generator  1 --> 1 0 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 1 0 0 0 
#I  Automorphism 5:
#I  Generator  1 --> 1 1 1 0 0 0 0 0 
#I  Generator  2 --> 0 1 1 1 0 0 0 0 
#I  Group: [grp] #7;3 #49;3 to lower exponent-2 central class 3 has order 2^8
#I  Class 1
#I  1 is defined on image of defining generator 1
#I  2 is defined on image of defining generator 2
#I  Class 2
#I  3 is defined on [2, 1] = 2 1 
#I  4 is defined on 1^2 = 1 1 
#I  5 is defined on 2^2 = 2 2 
#I  Class 3
#I  6 is defined on [3, 1] = 2 1 1 
#I  7 is defined on 4^2 = 1 1 1 
#I  8 is defined on 5^2 = 2 2 2 
#I  Non-trivial powers:
#I   .1^2 = .4
#I   .2^2 = .5
#I   .4^2 = .7
#I   .5^2 = .8
#I  Non-trivial commutators:
#I  [ .2, .1 ] = .3
#I  [ .3, .1 ] = .6
#I  [ .4, .2 ] = .6
#I  Automorphism 1:
#I  Generator  1 --> 1 0 0 0 0 0 1 0 
#I  Generator  2 --> 0 1 0 0 0 0 0 0 
#I  Automorphism 2:
#I  Generator  1 --> 1 0 0 0 0 0 0 1 
#I  Generator  2 --> 0 1 0 0 0 0 0 0 
#I  Automorphism 3:
#I  Generator  1 --> 1 0 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 1 0 
#I  Automorphism 4:
#I  Generator  1 --> 1 0 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 0 1 
#I  Number of stabiliser generators is 5
#I  Automorphism 1:
#I  Generator  1 --> 1 0 0 1 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 0 0 
#I  Automorphism 2:
#I  Generator  1 --> 1 0 0 0 1 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 0 0 
#I  Automorphism 3:
#I  Generator  1 --> 1 0 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 1 0 0 0 0 
#I  Automorphism 4:
#I  Generator  1 --> 1 0 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 1 0 0 0 
#I  Automorphism 5:
#I  Generator  1 --> 1 1 1 0 0 0 0 0 
#I  Generator  2 --> 0 1 1 1 0 0 0 0 
#I  Group: [grp] #7;3 #50;3 to lower exponent-2 central class 3 has order 2^8
#I  Class 1
#I  1 is defined on image of defining generator 1
#I  2 is defined on image of defining generator 2
#I  Class 2
#I  3 is defined on [2, 1] = 2 1 
#I  4 is defined on 1^2 = 1 1 
#I  5 is defined on 2^2 = 2 2 
#I  Class 3
#I  6 is defined on [3, 1] = 2 1 1 
#I  7 is defined on [4, 2] = 1 1 2 
#I  8 is defined on 4^2 = 1 1 1 
#I  Non-trivial powers:
#I   .1^2 = .4
#I   .2^2 = .5
#I   .3^2 = .6 .7
#I   .4^2 = .8
#I  Non-trivial commutators:
#I  [ .2, .1 ] = .3
#I  [ .3, .1 ] = .6
#I  [ .4, .2 ] = .7
#I  [ .5, .1 ] = .6 .7
#I  Automorphism 1:
#I  Generator  1 --> 1 0 0 0 0 0 0 1 
#I  Generator  2 --> 0 1 0 0 0 0 0 0 
#I  Automorphism 2:
#I  Generator  1 --> 1 0 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 1 0 0 
#I  Automorphism 3:
#I  Generator  1 --> 1 0 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 0 1 
#I  Number of stabiliser generators is 5
#I  Automorphism 1:
#I  Generator  1 --> 1 0 0 1 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 0 0 
#I  Automorphism 2:
#I  Generator  1 --> 1 0 0 0 1 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 0 0 
#I  Automorphism 3:
#I  Generator  1 --> 1 0 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 1 0 0 0 0 
#I  Automorphism 4:
#I  Generator  1 --> 1 0 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 1 0 0 0 
#I  Automorphism 5:
#I  Generator  1 --> 1 1 1 0 0 0 0 0 
#I  Generator  2 --> 0 1 1 1 0 0 0 0 
#I  Group: [grp] #7;3 #51;3 to lower exponent-2 central class 3 has order 2^8
#I  Class 1
#I  1 is defined on image of defining generator 1
#I  2 is defined on image of defining generator 2
#I  Class 2
#I  3 is defined on [2, 1] = 2 1 
#I  4 is defined on 1^2 = 1 1 
#I  5 is defined on 2^2 = 2 2 
#I  Class 3
#I  6 is defined on [3, 1] = 2 1 1 
#I  7 is defined on [4, 2] = 1 1 2 
#I  8 is defined on 4^2 = 1 1 1 
#I  Non-trivial powers:
#I   .1^2 = .4
#I   .2^2 = .5
#I   .3^2 = .6 .7
#I   .4^2 = .8
#I   .5^2 = .6
#I  Non-trivial commutators:
#I  [ .2, .1 ] = .3
#I  [ .3, .1 ] = .6
#I  [ .4, .2 ] = .7
#I  [ .5, .1 ] = .6 .7
#I  Automorphism 1:
#I  Generator  1 --> 1 0 0 0 0 0 0 1 
#I  Generator  2 --> 0 1 0 0 0 0 0 0 
#I  Automorphism 2:
#I  Generator  1 --> 1 0 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 1 0 0 
#I  Automorphism 3:
#I  Generator  1 --> 1 0 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 0 1 
#I  Number of stabiliser generators is 5
#I  Automorphism 1:
#I  Generator  1 --> 1 0 0 1 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 0 0 
#I  Automorphism 2:
#I  Generator  1 --> 1 0 0 0 1 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 0 0 
#I  Automorphism 3:
#I  Generator  1 --> 1 0 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 1 0 0 0 0 
#I  Automorphism 4:
#I  Generator  1 --> 1 0 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 1 0 0 0 
#I  Automorphism 5:
#I  Generator  1 --> 1 1 1 0 0 0 0 0 
#I  Generator  2 --> 0 1 1 1 0 0 0 0 
#I  Group: [grp] #7;3 #52;3 to lower exponent-2 central class 3 has order 2^8
#I  Class 1
#I  1 is defined on image of defining generator 1
#I  2 is defined on image of defining generator 2
#I  Class 2
#I  3 is defined on [2, 1] = 2 1 
#I  4 is defined on 1^2 = 1 1 
#I  5 is defined on 2^2 = 2 2 
#I  Class 3
#I  6 is defined on [3, 1] = 2 1 1 
#I  7 is defined on [4, 2] = 1 1 2 
#I  8 is defined on 4^2 = 1 1 1 
#I  Non-trivial powers:
#I   .1^2 = .4
#I   .2^2 = .5
#I   .3^2 = .6 .7
#I   .4^2 = .8
#I   .5^2 = .7
#I  Non-trivial commutators:
#I  [ .2, .1 ] = .3
#I  [ .3, .1 ] = .6
#I  [ .4, .2 ] = .7
#I  [ .5, .1 ] = .6 .7
#I  Automorphism 1:
#I  Generator  1 --> 1 0 0 0 0 0 0 1 
#I  Generator  2 --> 0 1 0 0 0 0 0 0 
#I  Automorphism 2:
#I  Generator  1 --> 1 0 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 1 0 0 
#I  Automorphism 3:
#I  Generator  1 --> 1 0 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 0 1 
#I  Number of stabiliser generators is 5
#I  Automorphism 1:
#I  Generator  1 --> 1 0 0 1 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 0 0 
#I  Automorphism 2:
#I  Generator  1 --> 1 0 0 0 1 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 0 0 
#I  Automorphism 3:
#I  Generator  1 --> 1 0 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 1 0 0 0 0 
#I  Automorphism 4:
#I  Generator  1 --> 1 0 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 1 0 0 0 
#I  Automorphism 5:
#I  Generator  1 --> 1 1 1 0 0 0 0 0 
#I  Generator  2 --> 0 1 1 1 0 0 0 0 
#I  Group: [grp] #7;3 #53;3 to lower exponent-2 central class 3 has order 2^8
#I  Class 1
#I  1 is defined on image of defining generator 1
#I  2 is defined on image of defining generator 2
#I  Class 2
#I  3 is defined on [2, 1] = 2 1 
#I  4 is defined on 1^2 = 1 1 
#I  5 is defined on 2^2 = 2 2 
#I  Class 3
#I  6 is defined on [3, 1] = 2 1 1 
#I  7 is defined on [4, 2] = 1 1 2 
#I  8 is defined on 4^2 = 1 1 1 
#I  Non-trivial powers:
#I   .1^2 = .4
#I   .2^2 = .5
#I   .3^2 = .6 .7
#I   .4^2 = .8
#I   .5^2 = .6 .7
#I  Non-trivial commutators:
#I  [ .2, .1 ] = .3
#I  [ .3, .1 ] = .6
#I  [ .4, .2 ] = .7
#I  [ .5, .1 ] = .6 .7
#I  Automorphism 1:
#I  Generator  1 --> 1 0 0 0 0 0 0 1 
#I  Generator  2 --> 0 1 0 0 0 0 0 0 
#I  Automorphism 2:
#I  Generator  1 --> 1 0 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 1 0 0 
#I  Automorphism 3:
#I  Generator  1 --> 1 0 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 0 1 
#I  Number of stabiliser generators is 5
#I  Automorphism 1:
#I  Generator  1 --> 1 0 0 1 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 0 0 
#I  Automorphism 2:
#I  Generator  1 --> 1 0 0 0 1 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 0 0 
#I  Automorphism 3:
#I  Generator  1 --> 1 0 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 1 0 0 0 0 
#I  Automorphism 4:
#I  Generator  1 --> 1 0 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 1 0 0 0 
#I  Automorphism 5:
#I  Generator  1 --> 1 1 1 0 0 0 0 0 
#I  Generator  2 --> 0 1 1 1 0 0 0 0 
#I  Group: [grp] #7;3 #54;3 to lower exponent-2 central class 3 has order 2^8
#I  Class 1
#I  1 is defined on image of defining generator 1
#I  2 is defined on image of defining generator 2
#I  Class 2
#I  3 is defined on [2, 1] = 2 1 
#I  4 is defined on 1^2 = 1 1 
#I  5 is defined on 2^2 = 2 2 
#I  Class 3
#I  6 is defined on [3, 1] = 2 1 1 
#I  7 is defined on [4, 2] = 1 1 2 
#I  8 is defined on 4^2 = 1 1 1 
#I  Non-trivial powers:
#I   .1^2 = .4
#I   .2^2 = .5
#I   .3^2 = .6 .7
#I   .4^2 = .8
#I   .5^2 = .8
#I  Non-trivial commutators:
#I  [ .2, .1 ] = .3
#I  [ .3, .1 ] = .6
#I  [ .4, .2 ] = .7
#I  [ .5, .1 ] = .6 .7
#I  Automorphism 1:
#I  Generator  1 --> 1 0 0 0 0 0 0 1 
#I  Generator  2 --> 0 1 0 0 0 0 0 0 
#I  Automorphism 2:
#I  Generator  1 --> 1 0 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 1 0 0 
#I  Automorphism 3:
#I  Generator  1 --> 1 0 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 0 1 
#I  Number of stabiliser generators is 4
#I  Automorphism 1:
#I  Generator  1 --> 1 0 0 1 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 0 0 
#I  Automorphism 2:
#I  Generator  1 --> 1 0 0 0 1 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 0 0 
#I  Automorphism 3:
#I  Generator  1 --> 1 0 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 1 0 0 0 0 
#I  Automorphism 4:
#I  Generator  1 --> 1 0 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 1 0 0 0 
#I  Group: [grp] #7;3 #55;3 to lower exponent-2 central class 3 has order 2^8
#I  Class 1
#I  1 is defined on image of defining generator 1
#I  2 is defined on image of defining generator 2
#I  Class 2
#I  3 is defined on [2, 1] = 2 1 
#I  4 is defined on 1^2 = 1 1 
#I  5 is defined on 2^2 = 2 2 
#I  Class 3
#I  6 is defined on [3, 1] = 2 1 1 
#I  7 is defined on [4, 2] = 1 1 2 
#I  8 is defined on 4^2 = 1 1 1 
#I  Non-trivial powers:
#I   .1^2 = .4
#I   .2^2 = .5
#I   .3^2 = .6 .7
#I   .4^2 = .8
#I   .5^2 = .6 .8
#I  Non-trivial commutators:
#I  [ .2, .1 ] = .3
#I  [ .3, .1 ] = .6
#I  [ .4, .2 ] = .7
#I  [ .5, .1 ] = .6 .7
#I  Automorphism 1:
#I  Generator  1 --> 1 0 0 0 0 0 0 1 
#I  Generator  2 --> 0 1 0 0 0 0 0 0 
#I  Automorphism 2:
#I  Generator  1 --> 1 0 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 1 0 0 
#I  Automorphism 3:
#I  Generator  1 --> 1 0 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 0 1 
#I  Number of stabiliser generators is 4
#I  Automorphism 1:
#I  Generator  1 --> 1 0 0 1 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 0 0 
#I  Automorphism 2:
#I  Generator  1 --> 1 0 0 0 1 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 0 0 
#I  Automorphism 3:
#I  Generator  1 --> 1 0 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 1 0 0 0 0 
#I  Automorphism 4:
#I  Generator  1 --> 1 0 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 1 0 0 0 
#I  Group: [grp] #7;3 #56;3 to lower exponent-2 central class 3 has order 2^8
#I  Class 1
#I  1 is defined on image of defining generator 1
#I  2 is defined on image of defining generator 2
#I  Class 2
#I  3 is defined on [2, 1] = 2 1 
#I  4 is defined on 1^2 = 1 1 
#I  5 is defined on 2^2 = 2 2 
#I  Class 3
#I  6 is defined on [3, 1] = 2 1 1 
#I  7 is defined on [4, 2] = 1 1 2 
#I  8 is defined on 4^2 = 1 1 1 
#I  Non-trivial powers:
#I   .1^2 = .4
#I   .2^2 = .5
#I   .3^2 = .6 .7
#I   .4^2 = .8
#I   .5^2 = .7 .8
#I  Non-trivial commutators:
#I  [ .2, .1 ] = .3
#I  [ .3, .1 ] = .6
#I  [ .4, .2 ] = .7
#I  [ .5, .1 ] = .6 .7
#I  Automorphism 1:
#I  Generator  1 --> 1 0 0 0 0 0 0 1 
#I  Generator  2 --> 0 1 0 0 0 0 0 0 
#I  Automorphism 2:
#I  Generator  1 --> 1 0 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 1 0 0 
#I  Automorphism 3:
#I  Generator  1 --> 1 0 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 0 1 
#I  Number of stabiliser generators is 4
#I  Automorphism 1:
#I  Generator  1 --> 1 0 0 1 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 0 0 
#I  Automorphism 2:
#I  Generator  1 --> 1 0 0 0 1 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 0 0 
#I  Automorphism 3:
#I  Generator  1 --> 1 0 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 1 0 0 0 0 
#I  Automorphism 4:
#I  Generator  1 --> 1 0 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 1 0 0 0 
#I  Group: [grp] #7;3 #57;3 to lower exponent-2 central class 3 has order 2^8
#I  Class 1
#I  1 is defined on image of defining generator 1
#I  2 is defined on image of defining generator 2
#I  Class 2
#I  3 is defined on [2, 1] = 2 1 
#I  4 is defined on 1^2 = 1 1 
#I  5 is defined on 2^2 = 2 2 
#I  Class 3
#I  6 is defined on [3, 1] = 2 1 1 
#I  7 is defined on [4, 2] = 1 1 2 
#I  8 is defined on 4^2 = 1 1 1 
#I  Non-trivial powers:
#I   .1^2 = .4
#I   .2^2 = .5
#I   .3^2 = .6 .7
#I   .4^2 = .8
#I   .5^2 = .6 .7 .8
#I  Non-trivial commutators:
#I  [ .2, .1 ] = .3
#I  [ .3, .1 ] = .6
#I  [ .4, .2 ] = .7
#I  [ .5, .1 ] = .6 .7
#I  Automorphism 1:
#I  Generator  1 --> 1 0 0 0 0 0 0 1 
#I  Generator  2 --> 0 1 0 0 0 0 0 0 
#I  Automorphism 2:
#I  Generator  1 --> 1 0 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 1 0 0 
#I  Automorphism 3:
#I  Generator  1 --> 1 0 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 0 1 
#I  Number of stabiliser generators is 4
#I  Automorphism 1:
#I  Generator  1 --> 1 0 0 1 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 0 0 
#I  Automorphism 2:
#I  Generator  1 --> 1 0 0 0 1 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 0 0 
#I  Automorphism 3:
#I  Generator  1 --> 1 0 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 1 0 0 0 0 
#I  Automorphism 4:
#I  Generator  1 --> 1 0 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 1 0 0 0 
#I  Group: [grp] #7;3 #58;3 to lower exponent-2 central class 3 has order 2^8
#I  Class 1
#I  1 is defined on image of defining generator 1
#I  2 is defined on image of defining generator 2
#I  Class 2
#I  3 is defined on [2, 1] = 2 1 
#I  4 is defined on 1^2 = 1 1 
#I  5 is defined on 2^2 = 2 2 
#I  Class 3
#I  6 is defined on [3, 1] = 2 1 1 
#I  7 is defined on [3, 2] = 2 1 2 
#I  8 is defined on 4^2 = 1 1 1 
#I  Non-trivial powers:
#I   .1^2 = .4
#I   .2^2 = .5
#I   .4^2 = .8
#I  Non-trivial commutators:
#I  [ .2, .1 ] = .3
#I  [ .3, .1 ] = .6
#I  [ .3, .2 ] = .7
#I  [ .4, .2 ] = .6
#I  [ .5, .1 ] = .7
#I  Automorphism 1:
#I  Generator  1 --> 1 0 0 0 0 0 0 1 
#I  Generator  2 --> 0 1 0 0 0 0 0 0 
#I  Automorphism 2:
#I  Generator  1 --> 1 0 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 1 0 
#I  Automorphism 3:
#I  Generator  1 --> 1 0 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 0 1 
#I  Number of stabiliser generators is 5
#I  Automorphism 1:
#I  Generator  1 --> 1 0 0 1 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 0 0 
#I  Automorphism 2:
#I  Generator  1 --> 1 0 0 0 1 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 0 0 
#I  Automorphism 3:
#I  Generator  1 --> 1 0 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 1 0 0 0 0 
#I  Automorphism 4:
#I  Generator  1 --> 1 0 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 1 0 0 0 
#I  Automorphism 5:
#I  Generator  1 --> 1 1 1 0 0 0 0 0 
#I  Generator  2 --> 0 1 1 1 0 1 0 0 
#I  Group: [grp] #7;3 #59;3 to lower exponent-2 central class 3 has order 2^8
#I  Class 1
#I  1 is defined on image of defining generator 1
#I  2 is defined on image of defining generator 2
#I  Class 2
#I  3 is defined on [2, 1] = 2 1 
#I  4 is defined on 1^2 = 1 1 
#I  5 is defined on 2^2 = 2 2 
#I  Class 3
#I  6 is defined on [3, 1] = 2 1 1 
#I  7 is defined on [3, 2] = 2 1 2 
#I  8 is defined on 4^2 = 1 1 1 
#I  Non-trivial powers:
#I   .1^2 = .4
#I   .2^2 = .5
#I   .4^2 = .8
#I   .5^2 = .6
#I  Non-trivial commutators:
#I  [ .2, .1 ] = .3
#I  [ .3, .1 ] = .6
#I  [ .3, .2 ] = .7
#I  [ .4, .2 ] = .6
#I  [ .5, .1 ] = .7
#I  Automorphism 1:
#I  Generator  1 --> 1 0 0 0 0 0 0 1 
#I  Generator  2 --> 0 1 0 0 0 0 0 0 
#I  Automorphism 2:
#I  Generator  1 --> 1 0 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 1 0 
#I  Automorphism 3:
#I  Generator  1 --> 1 0 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 0 1 
#I  Number of stabiliser generators is 4
#I  Automorphism 1:
#I  Generator  1 --> 1 0 0 1 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 0 0 
#I  Automorphism 2:
#I  Generator  1 --> 1 0 0 0 1 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 0 0 
#I  Automorphism 3:
#I  Generator  1 --> 1 0 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 1 0 0 0 0 
#I  Automorphism 4:
#I  Generator  1 --> 1 0 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 1 0 0 0 
#I  Group: [grp] #7;3 #60;3 to lower exponent-2 central class 3 has order 2^8
#I  Class 1
#I  1 is defined on image of defining generator 1
#I  2 is defined on image of defining generator 2
#I  Class 2
#I  3 is defined on [2, 1] = 2 1 
#I  4 is defined on 1^2 = 1 1 
#I  5 is defined on 2^2 = 2 2 
#I  Class 3
#I  6 is defined on [3, 1] = 2 1 1 
#I  7 is defined on [3, 2] = 2 1 2 
#I  8 is defined on 4^2 = 1 1 1 
#I  Non-trivial powers:
#I   .1^2 = .4
#I   .2^2 = .5
#I   .4^2 = .8
#I   .5^2 = .7
#I  Non-trivial commutators:
#I  [ .2, .1 ] = .3
#I  [ .3, .1 ] = .6
#I  [ .3, .2 ] = .7
#I  [ .4, .2 ] = .6
#I  [ .5, .1 ] = .7
#I  Automorphism 1:
#I  Generator  1 --> 1 0 0 0 0 0 0 1 
#I  Generator  2 --> 0 1 0 0 0 0 0 0 
#I  Automorphism 2:
#I  Generator  1 --> 1 0 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 1 0 
#I  Automorphism 3:
#I  Generator  1 --> 1 0 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 0 1 
#I  Number of stabiliser generators is 5
#I  Automorphism 1:
#I  Generator  1 --> 1 0 0 1 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 0 0 
#I  Automorphism 2:
#I  Generator  1 --> 1 0 0 0 1 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 0 0 
#I  Automorphism 3:
#I  Generator  1 --> 1 0 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 1 0 0 0 0 
#I  Automorphism 4:
#I  Generator  1 --> 1 0 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 1 0 0 0 
#I  Automorphism 5:
#I  Generator  1 --> 1 1 1 0 0 0 0 0 
#I  Generator  2 --> 0 1 1 1 0 1 0 0 
#I  Group: [grp] #7;3 #61;3 to lower exponent-2 central class 3 has order 2^8
#I  Class 1
#I  1 is defined on image of defining generator 1
#I  2 is defined on image of defining generator 2
#I  Class 2
#I  3 is defined on [2, 1] = 2 1 
#I  4 is defined on 1^2 = 1 1 
#I  5 is defined on 2^2 = 2 2 
#I  Class 3
#I  6 is defined on [3, 1] = 2 1 1 
#I  7 is defined on [3, 2] = 2 1 2 
#I  8 is defined on [4, 2] = 1 1 2 
#I  Non-trivial powers:
#I   .1^2 = .4
#I   .2^2 = .5
#I   .3^2 = .6 .8
#I  Non-trivial commutators:
#I  [ .2, .1 ] = .3
#I  [ .3, .1 ] = .6
#I  [ .3, .2 ] = .7
#I  [ .4, .2 ] = .8
#I  [ .5, .1 ] = .6 .7 .8
#I  Automorphism 1:
#I  Generator  1 --> 1 0 0 0 0 0 0 1 
#I  Generator  2 --> 0 1 0 0 0 0 0 0 
#I  Automorphism 2:
#I  Generator  1 --> 1 0 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 1 0 0 
#I  Automorphism 3:
#I  Generator  1 --> 1 0 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 1 0 
#I  Number of stabiliser generators is 5
#I  Automorphism 1:
#I  Generator  1 --> 1 0 0 1 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 0 0 
#I  Automorphism 2:
#I  Generator  1 --> 1 0 0 0 1 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 0 0 
#I  Automorphism 3:
#I  Generator  1 --> 1 0 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 1 0 0 0 0 
#I  Automorphism 4:
#I  Generator  1 --> 1 0 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 1 0 0 0 
#I  Automorphism 5:
#I  Generator  1 --> 0 1 0 0 0 0 0 0 
#I  Generator  2 --> 1 0 0 0 0 0 0 0 
#I  Group: [grp] #7;3 #62;3 to lower exponent-2 central class 3 has order 2^8
#I  Class 1
#I  1 is defined on image of defining generator 1
#I  2 is defined on image of defining generator 2
#I  Class 2
#I  3 is defined on [2, 1] = 2 1 
#I  4 is defined on 1^2 = 1 1 
#I  5 is defined on 2^2 = 2 2 
#I  Class 3
#I  6 is defined on [3, 1] = 2 1 1 
#I  7 is defined on [3, 2] = 2 1 2 
#I  8 is defined on [4, 2] = 1 1 2 
#I  Non-trivial powers:
#I   .1^2 = .4
#I   .2^2 = .5
#I   .3^2 = .6 .8
#I   .4^2 = .6
#I  Non-trivial commutators:
#I  [ .2, .1 ] = .3
#I  [ .3, .1 ] = .6
#I  [ .3, .2 ] = .7
#I  [ .4, .2 ] = .8
#I  [ .5, .1 ] = .6 .7 .8
#I  Automorphism 1:
#I  Generator  1 --> 1 0 0 0 0 0 0 1 
#I  Generator  2 --> 0 1 0 0 0 0 0 0 
#I  Automorphism 2:
#I  Generator  1 --> 1 0 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 1 0 0 
#I  Automorphism 3:
#I  Generator  1 --> 1 0 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 1 0 
#I  Number of stabiliser generators is 4
#I  Automorphism 1:
#I  Generator  1 --> 1 0 0 1 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 0 0 
#I  Automorphism 2:
#I  Generator  1 --> 1 0 0 0 1 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 0 0 
#I  Automorphism 3:
#I  Generator  1 --> 1 0 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 1 0 0 0 0 
#I  Automorphism 4:
#I  Generator  1 --> 1 0 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 1 0 0 0 
#I  Group: [grp] #7;3 #63;3 to lower exponent-2 central class 3 has order 2^8
#I  Class 1
#I  1 is defined on image of defining generator 1
#I  2 is defined on image of defining generator 2
#I  Class 2
#I  3 is defined on [2, 1] = 2 1 
#I  4 is defined on 1^2 = 1 1 
#I  5 is defined on 2^2 = 2 2 
#I  Class 3
#I  6 is defined on [3, 1] = 2 1 1 
#I  7 is defined on [3, 2] = 2 1 2 
#I  8 is defined on [4, 2] = 1 1 2 
#I  Non-trivial powers:
#I   .1^2 = .4
#I   .2^2 = .5
#I   .3^2 = .6 .8
#I   .5^2 = .6
#I  Non-trivial commutators:
#I  [ .2, .1 ] = .3
#I  [ .3, .1 ] = .6
#I  [ .3, .2 ] = .7
#I  [ .4, .2 ] = .8
#I  [ .5, .1 ] = .6 .7 .8
#I  Automorphism 1:
#I  Generator  1 --> 1 0 0 0 0 0 0 1 
#I  Generator  2 --> 0 1 0 0 0 0 0 0 
#I  Automorphism 2:
#I  Generator  1 --> 1 0 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 1 0 0 
#I  Automorphism 3:
#I  Generator  1 --> 1 0 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 1 0 
#I  Number of stabiliser generators is 4
#I  Automorphism 1:
#I  Generator  1 --> 1 0 0 1 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 0 0 
#I  Automorphism 2:
#I  Generator  1 --> 1 0 0 0 1 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 0 0 
#I  Automorphism 3:
#I  Generator  1 --> 1 0 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 1 0 0 0 0 
#I  Automorphism 4:
#I  Generator  1 --> 1 0 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 1 0 0 0 
#I  Group: [grp] #7;3 #64;3 to lower exponent-2 central class 3 has order 2^8
#I  Class 1
#I  1 is defined on image of defining generator 1
#I  2 is defined on image of defining generator 2
#I  Class 2
#I  3 is defined on [2, 1] = 2 1 
#I  4 is defined on 1^2 = 1 1 
#I  5 is defined on 2^2 = 2 2 
#I  Class 3
#I  6 is defined on [3, 1] = 2 1 1 
#I  7 is defined on [3, 2] = 2 1 2 
#I  8 is defined on [4, 2] = 1 1 2 
#I  Non-trivial powers:
#I   .1^2 = .4
#I   .2^2 = .5
#I   .3^2 = .6 .8
#I   .4^2 = .6
#I   .5^2 = .6
#I  Non-trivial commutators:
#I  [ .2, .1 ] = .3
#I  [ .3, .1 ] = .6
#I  [ .3, .2 ] = .7
#I  [ .4, .2 ] = .8
#I  [ .5, .1 ] = .6 .7 .8
#I  Automorphism 1:
#I  Generator  1 --> 1 0 0 0 0 0 0 1 
#I  Generator  2 --> 0 1 0 0 0 0 0 0 
#I  Automorphism 2:
#I  Generator  1 --> 1 0 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 1 0 0 
#I  Automorphism 3:
#I  Generator  1 --> 1 0 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 1 0 
#I  Number of stabiliser generators is 4
#I  Automorphism 1:
#I  Generator  1 --> 1 0 0 1 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 0 0 
#I  Automorphism 2:
#I  Generator  1 --> 1 0 0 0 1 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 0 0 
#I  Automorphism 3:
#I  Generator  1 --> 1 0 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 1 0 0 0 0 
#I  Automorphism 4:
#I  Generator  1 --> 1 0 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 1 0 0 0 
#I  Group: [grp] #7;3 #65;3 to lower exponent-2 central class 3 has order 2^8
#I  Class 1
#I  1 is defined on image of defining generator 1
#I  2 is defined on image of defining generator 2
#I  Class 2
#I  3 is defined on [2, 1] = 2 1 
#I  4 is defined on 1^2 = 1 1 
#I  5 is defined on 2^2 = 2 2 
#I  Class 3
#I  6 is defined on [3, 1] = 2 1 1 
#I  7 is defined on [3, 2] = 2 1 2 
#I  8 is defined on [4, 2] = 1 1 2 
#I  Non-trivial powers:
#I   .1^2 = .4
#I   .2^2 = .5
#I   .3^2 = .6 .8
#I   .4^2 = .6 .7
#I  Non-trivial commutators:
#I  [ .2, .1 ] = .3
#I  [ .3, .1 ] = .6
#I  [ .3, .2 ] = .7
#I  [ .4, .2 ] = .8
#I  [ .5, .1 ] = .6 .7 .8
#I  Automorphism 1:
#I  Generator  1 --> 1 0 0 0 0 0 0 1 
#I  Generator  2 --> 0 1 0 0 0 0 0 0 
#I  Automorphism 2:
#I  Generator  1 --> 1 0 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 1 0 0 
#I  Automorphism 3:
#I  Generator  1 --> 1 0 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 1 0 
#I  Number of stabiliser generators is 4
#I  Automorphism 1:
#I  Generator  1 --> 1 0 0 1 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 0 0 
#I  Automorphism 2:
#I  Generator  1 --> 1 0 0 0 1 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 0 0 
#I  Automorphism 3:
#I  Generator  1 --> 1 0 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 1 0 0 0 0 
#I  Automorphism 4:
#I  Generator  1 --> 1 0 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 1 0 0 0 
#I  Group: [grp] #7;3 #66;3 to lower exponent-2 central class 3 has order 2^8
#I  Class 1
#I  1 is defined on image of defining generator 1
#I  2 is defined on image of defining generator 2
#I  Class 2
#I  3 is defined on [2, 1] = 2 1 
#I  4 is defined on 1^2 = 1 1 
#I  5 is defined on 2^2 = 2 2 
#I  Class 3
#I  6 is defined on [3, 1] = 2 1 1 
#I  7 is defined on [3, 2] = 2 1 2 
#I  8 is defined on [4, 2] = 1 1 2 
#I  Non-trivial powers:
#I   .1^2 = .4
#I   .2^2 = .5
#I   .3^2 = .6 .8
#I   .4^2 = .7
#I   .5^2 = .6
#I  Non-trivial commutators:
#I  [ .2, .1 ] = .3
#I  [ .3, .1 ] = .6
#I  [ .3, .2 ] = .7
#I  [ .4, .2 ] = .8
#I  [ .5, .1 ] = .6 .7 .8
#I  Automorphism 1:
#I  Generator  1 --> 1 0 0 0 0 0 0 1 
#I  Generator  2 --> 0 1 0 0 0 0 0 0 
#I  Automorphism 2:
#I  Generator  1 --> 1 0 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 1 0 0 
#I  Automorphism 3:
#I  Generator  1 --> 1 0 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 1 0 
#I  Number of stabiliser generators is 5
#I  Automorphism 1:
#I  Generator  1 --> 1 0 0 1 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 0 0 
#I  Automorphism 2:
#I  Generator  1 --> 1 0 0 0 1 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 0 0 
#I  Automorphism 3:
#I  Generator  1 --> 1 0 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 1 0 0 0 0 
#I  Automorphism 4:
#I  Generator  1 --> 1 0 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 1 0 0 0 
#I  Automorphism 5:
#I  Generator  1 --> 0 1 0 0 0 0 0 0 
#I  Generator  2 --> 1 0 0 0 0 0 0 0 
#I  Group: [grp] #7;3 #67;3 to lower exponent-2 central class 3 has order 2^8
#I  Class 1
#I  1 is defined on image of defining generator 1
#I  2 is defined on image of defining generator 2
#I  Class 2
#I  3 is defined on [2, 1] = 2 1 
#I  4 is defined on 1^2 = 1 1 
#I  5 is defined on 2^2 = 2 2 
#I  Class 3
#I  6 is defined on [3, 1] = 2 1 1 
#I  7 is defined on [3, 2] = 2 1 2 
#I  8 is defined on [4, 2] = 1 1 2 
#I  Non-trivial powers:
#I   .1^2 = .4
#I   .2^2 = .5
#I   .3^2 = .6 .8
#I   .4^2 = .6 .7
#I   .5^2 = .6
#I  Non-trivial commutators:
#I  [ .2, .1 ] = .3
#I  [ .3, .1 ] = .6
#I  [ .3, .2 ] = .7
#I  [ .4, .2 ] = .8
#I  [ .5, .1 ] = .6 .7 .8
#I  Automorphism 1:
#I  Generator  1 --> 1 0 0 0 0 0 0 1 
#I  Generator  2 --> 0 1 0 0 0 0 0 0 
#I  Automorphism 2:
#I  Generator  1 --> 1 0 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 1 0 0 
#I  Automorphism 3:
#I  Generator  1 --> 1 0 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 1 0 
#I  Number of stabiliser generators is 4
#I  Automorphism 1:
#I  Generator  1 --> 1 0 0 1 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 0 0 
#I  Automorphism 2:
#I  Generator  1 --> 1 0 0 0 1 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 0 0 
#I  Automorphism 3:
#I  Generator  1 --> 1 0 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 1 0 0 0 0 
#I  Automorphism 4:
#I  Generator  1 --> 1 0 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 1 0 0 0 
#I  Group: [grp] #7;3 #68;3 to lower exponent-2 central class 3 has order 2^8
#I  Class 1
#I  1 is defined on image of defining generator 1
#I  2 is defined on image of defining generator 2
#I  Class 2
#I  3 is defined on [2, 1] = 2 1 
#I  4 is defined on 1^2 = 1 1 
#I  5 is defined on 2^2 = 2 2 
#I  Class 3
#I  6 is defined on [3, 1] = 2 1 1 
#I  7 is defined on [3, 2] = 2 1 2 
#I  8 is defined on [4, 2] = 1 1 2 
#I  Non-trivial powers:
#I   .1^2 = .4
#I   .2^2 = .5
#I   .3^2 = .6 .8
#I   .4^2 = .6
#I   .5^2 = .7
#I  Non-trivial commutators:
#I  [ .2, .1 ] = .3
#I  [ .3, .1 ] = .6
#I  [ .3, .2 ] = .7
#I  [ .4, .2 ] = .8
#I  [ .5, .1 ] = .6 .7 .8
#I  Automorphism 1:
#I  Generator  1 --> 1 0 0 0 0 0 0 1 
#I  Generator  2 --> 0 1 0 0 0 0 0 0 
#I  Automorphism 2:
#I  Generator  1 --> 1 0 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 1 0 0 
#I  Automorphism 3:
#I  Generator  1 --> 1 0 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 1 0 
#I  Number of stabiliser generators is 5
#I  Automorphism 1:
#I  Generator  1 --> 1 0 0 1 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 0 0 
#I  Automorphism 2:
#I  Generator  1 --> 1 0 0 0 1 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 0 0 
#I  Automorphism 3:
#I  Generator  1 --> 1 0 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 1 0 0 0 0 
#I  Automorphism 4:
#I  Generator  1 --> 1 0 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 1 0 0 0 
#I  Automorphism 5:
#I  Generator  1 --> 0 1 0 0 0 0 0 0 
#I  Generator  2 --> 1 0 0 0 0 0 0 0 
#I  Group: [grp] #7;3 #69;3 to lower exponent-2 central class 3 has order 2^8
#I  Class 1
#I  1 is defined on image of defining generator 1
#I  2 is defined on image of defining generator 2
#I  Class 2
#I  3 is defined on [2, 1] = 2 1 
#I  4 is defined on 1^2 = 1 1 
#I  5 is defined on 2^2 = 2 2 
#I  Class 3
#I  6 is defined on [3, 1] = 2 1 1 
#I  7 is defined on [3, 2] = 2 1 2 
#I  8 is defined on [4, 2] = 1 1 2 
#I  Non-trivial powers:
#I   .1^2 = .4
#I   .2^2 = .5
#I   .3^2 = .6 .8
#I   .4^2 = .6
#I   .5^2 = .6 .7
#I  Non-trivial commutators:
#I  [ .2, .1 ] = .3
#I  [ .3, .1 ] = .6
#I  [ .3, .2 ] = .7
#I  [ .4, .2 ] = .8
#I  [ .5, .1 ] = .6 .7 .8
#I  Automorphism 1:
#I  Generator  1 --> 1 0 0 0 0 0 0 1 
#I  Generator  2 --> 0 1 0 0 0 0 0 0 
#I  Automorphism 2:
#I  Generator  1 --> 1 0 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 1 0 0 
#I  Automorphism 3:
#I  Generator  1 --> 1 0 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 1 0 
#I  Number of stabiliser generators is 4
#I  Automorphism 1:
#I  Generator  1 --> 1 0 0 1 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 0 0 
#I  Automorphism 2:
#I  Generator  1 --> 1 0 0 0 1 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 0 0 
#I  Automorphism 3:
#I  Generator  1 --> 1 0 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 1 0 0 0 0 
#I  Automorphism 4:
#I  Generator  1 --> 1 0 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 1 0 0 0 
#I  Group: [grp] #7;3 #70;3 to lower exponent-2 central class 3 has order 2^8
#I  Class 1
#I  1 is defined on image of defining generator 1
#I  2 is defined on image of defining generator 2
#I  Class 2
#I  3 is defined on [2, 1] = 2 1 
#I  4 is defined on 1^2 = 1 1 
#I  5 is defined on 2^2 = 2 2 
#I  Class 3
#I  6 is defined on [3, 1] = 2 1 1 
#I  7 is defined on [3, 2] = 2 1 2 
#I  8 is defined on [4, 2] = 1 1 2 
#I  Non-trivial powers:
#I   .1^2 = .4
#I   .2^2 = .5
#I   .3^2 = .6 .8
#I   .4^2 = .6 .7
#I   .5^2 = .6 .7
#I  Non-trivial commutators:
#I  [ .2, .1 ] = .3
#I  [ .3, .1 ] = .6
#I  [ .3, .2 ] = .7
#I  [ .4, .2 ] = .8
#I  [ .5, .1 ] = .6 .7 .8
#I  Automorphism 1:
#I  Generator  1 --> 1 0 0 0 0 0 0 1 
#I  Generator  2 --> 0 1 0 0 0 0 0 0 
#I  Automorphism 2:
#I  Generator  1 --> 1 0 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 1 0 0 
#I  Automorphism 3:
#I  Generator  1 --> 1 0 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 1 0 
#I  Number of stabiliser generators is 5
#I  Automorphism 1:
#I  Generator  1 --> 1 0 0 1 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 0 0 
#I  Automorphism 2:
#I  Generator  1 --> 1 0 0 0 1 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 0 0 
#I  Automorphism 3:
#I  Generator  1 --> 1 0 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 1 0 0 0 0 
#I  Automorphism 4:
#I  Generator  1 --> 1 0 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 1 0 0 0 
#I  Automorphism 5:
#I  Generator  1 --> 0 1 0 0 0 0 0 0 
#I  Generator  2 --> 1 0 0 0 0 0 0 0 
#I  Group: [grp] #7;3 #71;3 to lower exponent-2 central class 3 has order 2^8
#I  Class 1
#I  1 is defined on image of defining generator 1
#I  2 is defined on image of defining generator 2
#I  Class 2
#I  3 is defined on [2, 1] = 2 1 
#I  4 is defined on 1^2 = 1 1 
#I  5 is defined on 2^2 = 2 2 
#I  Class 3
#I  6 is defined on [3, 1] = 2 1 1 
#I  7 is defined on [3, 2] = 2 1 2 
#I  8 is defined on [4, 2] = 1 1 2 
#I  Non-trivial powers:
#I   .1^2 = .4
#I   .2^2 = .5
#I   .3^2 = .6 .8
#I   .4^2 = .8
#I   .5^2 = .8
#I  Non-trivial commutators:
#I  [ .2, .1 ] = .3
#I  [ .3, .1 ] = .6
#I  [ .3, .2 ] = .7
#I  [ .4, .2 ] = .8
#I  [ .5, .1 ] = .6 .7 .8
#I  Automorphism 1:
#I  Generator  1 --> 1 0 0 0 0 0 0 1 
#I  Generator  2 --> 0 1 0 0 0 0 0 0 
#I  Automorphism 2:
#I  Generator  1 --> 1 0 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 1 0 0 
#I  Automorphism 3:
#I  Generator  1 --> 1 0 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 1 0 
#I  Number of stabiliser generators is 4
#I  Automorphism 1:
#I  Generator  1 --> 1 0 0 1 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 0 0 
#I  Automorphism 2:
#I  Generator  1 --> 1 0 0 0 1 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 0 0 
#I  Automorphism 3:
#I  Generator  1 --> 1 0 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 1 0 0 0 0 
#I  Automorphism 4:
#I  Generator  1 --> 1 0 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 1 0 0 0 
#I  Group: [grp] #7;3 #72;3 to lower exponent-2 central class 3 has order 2^8
#I  Class 1
#I  1 is defined on image of defining generator 1
#I  2 is defined on image of defining generator 2
#I  Class 2
#I  3 is defined on [2, 1] = 2 1 
#I  4 is defined on 1^2 = 1 1 
#I  5 is defined on 2^2 = 2 2 
#I  Class 3
#I  6 is defined on [3, 1] = 2 1 1 
#I  7 is defined on [3, 2] = 2 1 2 
#I  8 is defined on [4, 2] = 1 1 2 
#I  Non-trivial powers:
#I   .1^2 = .4
#I   .2^2 = .5
#I   .3^2 = .6 .8
#I   .4^2 = .6 .8
#I   .5^2 = .8
#I  Non-trivial commutators:
#I  [ .2, .1 ] = .3
#I  [ .3, .1 ] = .6
#I  [ .3, .2 ] = .7
#I  [ .4, .2 ] = .8
#I  [ .5, .1 ] = .6 .7 .8
#I  Automorphism 1:
#I  Generator  1 --> 1 0 0 0 0 0 0 1 
#I  Generator  2 --> 0 1 0 0 0 0 0 0 
#I  Automorphism 2:
#I  Generator  1 --> 1 0 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 1 0 0 
#I  Automorphism 3:
#I  Generator  1 --> 1 0 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 1 0 
#I  Number of stabiliser generators is 5
#I  Automorphism 1:
#I  Generator  1 --> 1 0 0 1 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 0 0 
#I  Automorphism 2:
#I  Generator  1 --> 1 0 0 0 1 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 0 0 
#I  Automorphism 3:
#I  Generator  1 --> 1 0 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 1 0 0 0 0 
#I  Automorphism 4:
#I  Generator  1 --> 1 0 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 1 0 0 0 
#I  Automorphism 5:
#I  Generator  1 --> 1 0 0 0 0 0 0 0 
#I  Generator  2 --> 1 1 1 0 0 0 0 0 
#I  Group: [grp] #7;3 #73;3 to lower exponent-2 central class 3 has order 2^8
#I  Class 1
#I  1 is defined on image of defining generator 1
#I  2 is defined on image of defining generator 2
#I  Class 2
#I  3 is defined on [2, 1] = 2 1 
#I  4 is defined on 1^2 = 1 1 
#I  5 is defined on 2^2 = 2 2 
#I  Class 3
#I  6 is defined on [3, 1] = 2 1 1 
#I  7 is defined on [3, 2] = 2 1 2 
#I  8 is defined on [4, 2] = 1 1 2 
#I  Non-trivial powers:
#I   .1^2 = .4
#I   .2^2 = .5
#I   .3^2 = .6 .8
#I   .4^2 = .6 .8
#I   .5^2 = .6 .8
#I  Non-trivial commutators:
#I  [ .2, .1 ] = .3
#I  [ .3, .1 ] = .6
#I  [ .3, .2 ] = .7
#I  [ .4, .2 ] = .8
#I  [ .5, .1 ] = .6 .7 .8
#I  Automorphism 1:
#I  Generator  1 --> 1 0 0 0 0 0 0 1 
#I  Generator  2 --> 0 1 0 0 0 0 0 0 
#I  Automorphism 2:
#I  Generator  1 --> 1 0 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 1 0 0 
#I  Automorphism 3:
#I  Generator  1 --> 1 0 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 1 0 
#I  Number of stabiliser generators is 6
#I  Automorphism 1:
#I  Generator  1 --> 1 0 0 1 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 0 0 
#I  Automorphism 2:
#I  Generator  1 --> 1 0 0 0 1 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 0 0 
#I  Automorphism 3:
#I  Generator  1 --> 1 0 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 1 0 0 0 0 
#I  Automorphism 4:
#I  Generator  1 --> 1 0 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 1 0 0 0 
#I  Automorphism 5:
#I  Generator  1 --> 0 1 0 0 0 0 0 0 
#I  Generator  2 --> 1 1 0 0 0 0 0 0 
#I  Automorphism 6:
#I  Generator  1 --> 0 1 0 0 0 0 0 0 
#I  Generator  2 --> 1 0 0 0 0 0 0 0 
#I  Group: [grp] #7;3 #74;3 to lower exponent-2 central class 3 has order 2^8
#I  Class 1
#I  1 is defined on image of defining generator 1
#I  2 is defined on image of defining generator 2
#I  Class 2
#I  3 is defined on [2, 1] = 2 1 
#I  4 is defined on 1^2 = 1 1 
#I  5 is defined on 2^2 = 2 2 
#I  Class 3
#I  6 is defined on [3, 1] = 2 1 1 
#I  7 is defined on [3, 2] = 2 1 2 
#I  8 is defined on [4, 2] = 1 1 2 
#I  Non-trivial powers:
#I   .1^2 = .4
#I   .2^2 = .5
#I   .3^2 = .6 .8
#I   .4^2 = .7 .8
#I   .5^2 = .8
#I  Non-trivial commutators:
#I  [ .2, .1 ] = .3
#I  [ .3, .1 ] = .6
#I  [ .3, .2 ] = .7
#I  [ .4, .2 ] = .8
#I  [ .5, .1 ] = .6 .7 .8
#I  Automorphism 1:
#I  Generator  1 --> 1 0 0 0 0 0 0 1 
#I  Generator  2 --> 0 1 0 0 0 0 0 0 
#I  Automorphism 2:
#I  Generator  1 --> 1 0 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 1 0 0 
#I  Automorphism 3:
#I  Generator  1 --> 1 0 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 1 0 
#I  Number of stabiliser generators is 5
#I  Automorphism 1:
#I  Generator  1 --> 1 0 0 1 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 0 0 
#I  Automorphism 2:
#I  Generator  1 --> 1 0 0 0 1 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 0 0 
#I  Automorphism 3:
#I  Generator  1 --> 1 0 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 1 0 0 0 0 
#I  Automorphism 4:
#I  Generator  1 --> 1 0 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 1 0 0 0 
#I  Automorphism 5:
#I  Generator  1 --> 0 1 0 0 0 0 0 0 
#I  Generator  2 --> 1 1 0 0 0 0 0 0 
#I  Group: [grp] #7;3 #75;3 to lower exponent-2 central class 3 has order 2^8
#I  Class 1
#I  1 is defined on image of defining generator 1
#I  2 is defined on image of defining generator 2
#I  Class 2
#I  3 is defined on [2, 1] = 2 1 
#I  4 is defined on 1^2 = 1 1 
#I  5 is defined on 2^2 = 2 2 
#I  Class 3
#I  6 is defined on [3, 1] = 2 1 1 
#I  7 is defined on [3, 2] = 2 1 2 
#I  8 is defined on [4, 2] = 1 1 2 
#I  Non-trivial powers:
#I   .1^2 = .4
#I   .2^2 = .5
#I   .3^2 = .6 .8
#I   .4^2 = .6 .7 .8
#I   .5^2 = .8
#I  Non-trivial commutators:
#I  [ .2, .1 ] = .3
#I  [ .3, .1 ] = .6
#I  [ .3, .2 ] = .7
#I  [ .4, .2 ] = .8
#I  [ .5, .1 ] = .6 .7 .8
#I  Automorphism 1:
#I  Generator  1 --> 1 0 0 0 0 0 0 1 
#I  Generator  2 --> 0 1 0 0 0 0 0 0 
#I  Automorphism 2:
#I  Generator  1 --> 1 0 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 1 0 0 
#I  Automorphism 3:
#I  Generator  1 --> 1 0 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 1 0 
#I  Number of stabiliser generators is 5
#I  Automorphism 1:
#I  Generator  1 --> 1 0 0 1 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 0 0 
#I  Automorphism 2:
#I  Generator  1 --> 1 0 0 0 1 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 0 0 
#I  Automorphism 3:
#I  Generator  1 --> 1 0 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 1 0 0 0 0 
#I  Automorphism 4:
#I  Generator  1 --> 1 0 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 1 0 0 0 
#I  Automorphism 5:
#I  Generator  1 --> 0 1 0 0 0 0 0 0 
#I  Generator  2 --> 1 0 0 0 0 0 0 0 
#I  Group: [grp] #7;3 #76;3 to lower exponent-2 central class 3 has order 2^8
#I  Class 1
#I  1 is defined on image of defining generator 1
#I  2 is defined on image of defining generator 2
#I  Class 2
#I  3 is defined on [2, 1] = 2 1 
#I  4 is defined on 1^2 = 1 1 
#I  5 is defined on 2^2 = 2 2 
#I  Class 3
#I  6 is defined on [3, 1] = 2 1 1 
#I  7 is defined on [3, 2] = 2 1 2 
#I  8 is defined on [4, 2] = 1 1 2 
#I  Non-trivial powers:
#I   .1^2 = .4
#I   .2^2 = .5
#I   .3^2 = .6 .8
#I   .4^2 = .8
#I   .5^2 = .6 .7 .8
#I  Non-trivial commutators:
#I  [ .2, .1 ] = .3
#I  [ .3, .1 ] = .6
#I  [ .3, .2 ] = .7
#I  [ .4, .2 ] = .8
#I  [ .5, .1 ] = .6 .7 .8
#I  Automorphism 1:
#I  Generator  1 --> 1 0 0 0 0 0 0 1 
#I  Generator  2 --> 0 1 0 0 0 0 0 0 
#I  Automorphism 2:
#I  Generator  1 --> 1 0 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 1 0 0 
#I  Automorphism 3:
#I  Generator  1 --> 1 0 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 1 0 
#I  Number of stabiliser generators is 6
#I  Automorphism 1:
#I  Generator  1 --> 1 0 0 1 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 0 0 
#I  Automorphism 2:
#I  Generator  1 --> 1 0 0 0 1 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 0 0 
#I  Automorphism 3:
#I  Generator  1 --> 1 0 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 1 0 0 0 0 
#I  Automorphism 4:
#I  Generator  1 --> 1 0 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 1 0 0 0 
#I  Automorphism 5:
#I  Generator  1 --> 0 1 0 0 0 0 0 0 
#I  Generator  2 --> 1 1 0 0 0 0 0 0 
#I  Automorphism 6:
#I  Generator  1 --> 0 1 0 0 0 0 0 0 
#I  Generator  2 --> 1 0 0 0 0 0 0 0 
#I  Group: [grp] #7;3 #77;3 to lower exponent-2 central class 3 has order 2^8
#I  Class 1
#I  1 is defined on image of defining generator 1
#I  2 is defined on image of defining generator 2
#I  Class 2
#I  3 is defined on [2, 1] = 2 1 
#I  4 is defined on 1^2 = 1 1 
#I  5 is defined on 2^2 = 2 2 
#I  Class 3
#I  6 is defined on [3, 1] = 2 1 1 
#I  7 is defined on [3, 2] = 2 1 2 
#I  8 is defined on 5^2 = 2 2 2 
#I  Non-trivial powers:
#I   .1^2 = .4
#I   .2^2 = .5
#I   .3^2 = .6
#I   .5^2 = .8
#I  Non-trivial commutators:
#I  [ .2, .1 ] = .3
#I  [ .3, .1 ] = .6
#I  [ .3, .2 ] = .7
#I  [ .5, .1 ] = .6 .7
#I  Automorphism 1:
#I  Generator  1 --> 1 0 0 0 0 0 0 1 
#I  Generator  2 --> 0 1 0 0 0 0 0 0 
#I  Automorphism 2:
#I  Generator  1 --> 1 0 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 1 0 0 
#I  Automorphism 3:
#I  Generator  1 --> 1 0 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 1 0 
#I  Automorphism 4:
#I  Generator  1 --> 1 0 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 0 1 
#I  Number of stabiliser generators is 5
#I  Automorphism 1:
#I  Generator  1 --> 1 0 0 1 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 0 0 
#I  Automorphism 2:
#I  Generator  1 --> 1 0 0 0 1 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 0 0 
#I  Automorphism 3:
#I  Generator  1 --> 1 0 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 1 0 0 0 0 
#I  Automorphism 4:
#I  Generator  1 --> 1 0 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 1 0 0 0 
#I  Automorphism 5:
#I  Generator  1 --> 1 0 0 0 0 0 0 0 
#I  Generator  2 --> 1 1 1 0 0 0 0 0 
#I  Group: [grp] #7;3 #78;3 to lower exponent-2 central class 3 has order 2^8
#I  Class 1
#I  1 is defined on image of defining generator 1
#I  2 is defined on image of defining generator 2
#I  Class 2
#I  3 is defined on [2, 1] = 2 1 
#I  4 is defined on 1^2 = 1 1 
#I  5 is defined on 2^2 = 2 2 
#I  Class 3
#I  6 is defined on [3, 1] = 2 1 1 
#I  7 is defined on [3, 2] = 2 1 2 
#I  8 is defined on 5^2 = 2 2 2 
#I  Non-trivial powers:
#I   .1^2 = .4
#I   .2^2 = .5
#I   .3^2 = .6
#I   .4^2 = .6
#I   .5^2 = .8
#I  Non-trivial commutators:
#I  [ .2, .1 ] = .3
#I  [ .3, .1 ] = .6
#I  [ .3, .2 ] = .7
#I  [ .5, .1 ] = .6 .7
#I  Automorphism 1:
#I  Generator  1 --> 1 0 0 0 0 0 0 1 
#I  Generator  2 --> 0 1 0 0 0 0 0 0 
#I  Automorphism 2:
#I  Generator  1 --> 1 0 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 1 0 0 
#I  Automorphism 3:
#I  Generator  1 --> 1 0 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 1 0 
#I  Automorphism 4:
#I  Generator  1 --> 1 0 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 0 1 
#I  Number of stabiliser generators is 5
#I  Automorphism 1:
#I  Generator  1 --> 1 0 0 1 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 0 0 
#I  Automorphism 2:
#I  Generator  1 --> 1 0 0 0 1 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 0 0 
#I  Automorphism 3:
#I  Generator  1 --> 1 0 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 1 0 0 0 0 
#I  Automorphism 4:
#I  Generator  1 --> 1 0 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 1 0 0 0 
#I  Automorphism 5:
#I  Generator  1 --> 1 0 0 0 0 0 0 0 
#I  Generator  2 --> 1 1 1 0 0 0 0 0 
#I  Group: [grp] #7;3 #79;3 to lower exponent-2 central class 3 has order 2^8
#I  Class 1
#I  1 is defined on image of defining generator 1
#I  2 is defined on image of defining generator 2
#I  Class 2
#I  3 is defined on [2, 1] = 2 1 
#I  4 is defined on 1^2 = 1 1 
#I  5 is defined on 2^2 = 2 2 
#I  Class 3
#I  6 is defined on [3, 1] = 2 1 1 
#I  7 is defined on [3, 2] = 2 1 2 
#I  8 is defined on 5^2 = 2 2 2 
#I  Non-trivial powers:
#I   .1^2 = .4
#I   .2^2 = .5
#I   .3^2 = .6
#I   .4^2 = .7
#I   .5^2 = .8
#I  Non-trivial commutators:
#I  [ .2, .1 ] = .3
#I  [ .3, .1 ] = .6
#I  [ .3, .2 ] = .7
#I  [ .5, .1 ] = .6 .7
#I  Automorphism 1:
#I  Generator  1 --> 1 0 0 0 0 0 0 1 
#I  Generator  2 --> 0 1 0 0 0 0 0 0 
#I  Automorphism 2:
#I  Generator  1 --> 1 0 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 1 0 0 
#I  Automorphism 3:
#I  Generator  1 --> 1 0 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 1 0 
#I  Automorphism 4:
#I  Generator  1 --> 1 0 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 0 1 
#I  Number of stabiliser generators is 4
#I  Automorphism 1:
#I  Generator  1 --> 1 0 0 1 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 0 0 
#I  Automorphism 2:
#I  Generator  1 --> 1 0 0 0 1 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 0 0 
#I  Automorphism 3:
#I  Generator  1 --> 1 0 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 1 0 0 0 0 
#I  Automorphism 4:
#I  Generator  1 --> 1 0 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 1 0 0 0 
#I  Group: [grp] #7;3 #80;3 to lower exponent-2 central class 3 has order 2^8
#I  Class 1
#I  1 is defined on image of defining generator 1
#I  2 is defined on image of defining generator 2
#I  Class 2
#I  3 is defined on [2, 1] = 2 1 
#I  4 is defined on 1^2 = 1 1 
#I  5 is defined on 2^2 = 2 2 
#I  Class 3
#I  6 is defined on [3, 1] = 2 1 1 
#I  7 is defined on [3, 2] = 2 1 2 
#I  8 is defined on 4^2 = 1 1 1 
#I  Non-trivial powers:
#I   .1^2 = .4
#I   .2^2 = .5
#I   .3^2 = .6
#I   .4^2 = .8
#I  Non-trivial commutators:
#I  [ .2, .1 ] = .3
#I  [ .3, .1 ] = .6
#I  [ .3, .2 ] = .7
#I  [ .5, .1 ] = .6 .7
#I  Automorphism 1:
#I  Generator  1 --> 1 0 0 0 0 0 0 1 
#I  Generator  2 --> 0 1 0 0 0 0 0 0 
#I  Automorphism 2:
#I  Generator  1 --> 1 0 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 1 0 0 
#I  Automorphism 3:
#I  Generator  1 --> 1 0 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 1 0 
#I  Automorphism 4:
#I  Generator  1 --> 1 0 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 0 1 
#I  Number of stabiliser generators is 4
#I  Automorphism 1:
#I  Generator  1 --> 1 0 0 1 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 0 0 
#I  Automorphism 2:
#I  Generator  1 --> 1 0 0 0 1 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 0 0 
#I  Automorphism 3:
#I  Generator  1 --> 1 0 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 1 0 0 0 0 
#I  Automorphism 4:
#I  Generator  1 --> 1 0 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 1 0 0 0 
#I  Group: [grp] #7;3 #81;3 to lower exponent-2 central class 3 has order 2^8
#I  Class 1
#I  1 is defined on image of defining generator 1
#I  2 is defined on image of defining generator 2
#I  Class 2
#I  3 is defined on [2, 1] = 2 1 
#I  4 is defined on 1^2 = 1 1 
#I  5 is defined on 2^2 = 2 2 
#I  Class 3
#I  6 is defined on [3, 1] = 2 1 1 
#I  7 is defined on [3, 2] = 2 1 2 
#I  8 is defined on 4^2 = 1 1 1 
#I  Non-trivial powers:
#I   .1^2 = .4
#I   .2^2 = .5
#I   .3^2 = .6
#I   .4^2 = .8
#I   .5^2 = .6
#I  Non-trivial commutators:
#I  [ .2, .1 ] = .3
#I  [ .3, .1 ] = .6
#I  [ .3, .2 ] = .7
#I  [ .5, .1 ] = .6 .7
#I  Automorphism 1:
#I  Generator  1 --> 1 0 0 0 0 0 0 1 
#I  Generator  2 --> 0 1 0 0 0 0 0 0 
#I  Automorphism 2:
#I  Generator  1 --> 1 0 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 1 0 0 
#I  Automorphism 3:
#I  Generator  1 --> 1 0 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 1 0 
#I  Automorphism 4:
#I  Generator  1 --> 1 0 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 0 1 
#I  Number of stabiliser generators is 4
#I  Automorphism 1:
#I  Generator  1 --> 1 0 0 1 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 0 0 
#I  Automorphism 2:
#I  Generator  1 --> 1 0 0 0 1 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 0 0 
#I  Automorphism 3:
#I  Generator  1 --> 1 0 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 1 0 0 0 0 
#I  Automorphism 4:
#I  Generator  1 --> 1 0 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 1 0 0 0 
#I  Group: [grp] #7;3 #82;3 to lower exponent-2 central class 3 has order 2^8
#I  Class 1
#I  1 is defined on image of defining generator 1
#I  2 is defined on image of defining generator 2
#I  Class 2
#I  3 is defined on [2, 1] = 2 1 
#I  4 is defined on 1^2 = 1 1 
#I  5 is defined on 2^2 = 2 2 
#I  Class 3
#I  6 is defined on [3, 1] = 2 1 1 
#I  7 is defined on [3, 2] = 2 1 2 
#I  8 is defined on 4^2 = 1 1 1 
#I  Non-trivial powers:
#I   .1^2 = .4
#I   .2^2 = .5
#I   .3^2 = .6
#I   .4^2 = .8
#I   .5^2 = .7
#I  Non-trivial commutators:
#I  [ .2, .1 ] = .3
#I  [ .3, .1 ] = .6
#I  [ .3, .2 ] = .7
#I  [ .5, .1 ] = .6 .7
#I  Automorphism 1:
#I  Generator  1 --> 1 0 0 0 0 0 0 1 
#I  Generator  2 --> 0 1 0 0 0 0 0 0 
#I  Automorphism 2:
#I  Generator  1 --> 1 0 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 1 0 0 
#I  Automorphism 3:
#I  Generator  1 --> 1 0 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 1 0 
#I  Automorphism 4:
#I  Generator  1 --> 1 0 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 0 1 
#I  Number of stabiliser generators is 4
#I  Automorphism 1:
#I  Generator  1 --> 1 0 0 1 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 0 0 
#I  Automorphism 2:
#I  Generator  1 --> 1 0 0 0 1 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 0 0 
#I  Automorphism 3:
#I  Generator  1 --> 1 0 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 1 0 0 0 0 
#I  Automorphism 4:
#I  Generator  1 --> 1 0 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 1 0 0 0 
#I  Group: [grp] #7;3 #83;3 to lower exponent-2 central class 3 has order 2^8
#I  Class 1
#I  1 is defined on image of defining generator 1
#I  2 is defined on image of defining generator 2
#I  Class 2
#I  3 is defined on [2, 1] = 2 1 
#I  4 is defined on 1^2 = 1 1 
#I  5 is defined on 2^2 = 2 2 
#I  Class 3
#I  6 is defined on [3, 1] = 2 1 1 
#I  7 is defined on [3, 2] = 2 1 2 
#I  8 is defined on 4^2 = 1 1 1 
#I  Non-trivial powers:
#I   .1^2 = .4
#I   .2^2 = .5
#I   .3^2 = .6
#I   .4^2 = .8
#I   .5^2 = .6 .7
#I  Non-trivial commutators:
#I  [ .2, .1 ] = .3
#I  [ .3, .1 ] = .6
#I  [ .3, .2 ] = .7
#I  [ .5, .1 ] = .6 .7
#I  Automorphism 1:
#I  Generator  1 --> 1 0 0 0 0 0 0 1 
#I  Generator  2 --> 0 1 0 0 0 0 0 0 
#I  Automorphism 2:
#I  Generator  1 --> 1 0 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 1 0 0 
#I  Automorphism 3:
#I  Generator  1 --> 1 0 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 1 0 
#I  Automorphism 4:
#I  Generator  1 --> 1 0 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 0 1 
#I  Number of stabiliser generators is 4
#I  Automorphism 1:
#I  Generator  1 --> 1 0 0 1 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 0 0 
#I  Automorphism 2:
#I  Generator  1 --> 1 0 0 0 1 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 0 0 
#I  Automorphism 3:
#I  Generator  1 --> 1 0 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 1 0 0 0 0 
#I  Automorphism 4:
#I  Generator  1 --> 1 0 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 1 0 0 0 
#I  # of immediate descendants of order 2^8 is 37
#I  # of capable immediate descendants is 37
#I  Group: [grp] #7;3 #84;4 to lower exponent-2 central class 3 has order 2^9
#I  Class 1
#I  1 is defined on image of defining generator 1
#I  2 is defined on image of defining generator 2
#I  Class 2
#I  3 is defined on [2, 1] = 2 1 
#I  4 is defined on 1^2 = 1 1 
#I  5 is defined on 2^2 = 2 2 
#I  Class 3
#I  6 is defined on [3, 1] = 2 1 1 
#I  7 is defined on [4, 2] = 1 1 2 
#I  8 is defined on 4^2 = 1 1 1 
#I  9 is defined on 5^2 = 2 2 2 
#I  Non-trivial powers:
#I   .1^2 = .4
#I   .2^2 = .5
#I   .3^2 = .6 .7
#I   .4^2 = .8
#I   .5^2 = .9
#I  Non-trivial commutators:
#I  [ .2, .1 ] = .3
#I  [ .3, .1 ] = .6
#I  [ .4, .2 ] = .7
#I  [ .5, .1 ] = .6 .7
#I  Automorphism 1:
#I  Generator  1 --> 1 0 0 0 0 0 0 1 0 
#I  Generator  2 --> 0 1 0 0 0 0 0 0 0 
#I  Automorphism 2:
#I  Generator  1 --> 1 0 0 0 0 0 0 0 1 
#I  Generator  2 --> 0 1 0 0 0 0 0 0 0 
#I  Automorphism 3:
#I  Generator  1 --> 1 0 0 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 1 0 0 0 
#I  Automorphism 4:
#I  Generator  1 --> 1 0 0 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 0 1 0 
#I  Automorphism 5:
#I  Generator  1 --> 1 0 0 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 0 0 1 
#I  Number of stabiliser generators is 5
#I  Automorphism 1:
#I  Generator  1 --> 1 0 0 1 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 0 0 0 
#I  Automorphism 2:
#I  Generator  1 --> 1 0 0 0 1 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 0 0 0 
#I  Automorphism 3:
#I  Generator  1 --> 1 0 0 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 1 0 0 0 0 0 
#I  Automorphism 4:
#I  Generator  1 --> 1 0 0 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 1 0 0 0 0 
#I  Automorphism 5:
#I  Generator  1 --> 1 1 1 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 1 1 0 0 0 0 0 
#I  Group: [grp] #7;3 #85;4 to lower exponent-2 central class 3 has order 2^9
#I  Class 1
#I  1 is defined on image of defining generator 1
#I  2 is defined on image of defining generator 2
#I  Class 2
#I  3 is defined on [2, 1] = 2 1 
#I  4 is defined on 1^2 = 1 1 
#I  5 is defined on 2^2 = 2 2 
#I  Class 3
#I  6 is defined on [3, 1] = 2 1 1 
#I  7 is defined on [3, 2] = 2 1 2 
#I  8 is defined on 4^2 = 1 1 1 
#I  9 is defined on 5^2 = 2 2 2 
#I  Non-trivial powers:
#I   .1^2 = .4
#I   .2^2 = .5
#I   .4^2 = .8
#I   .5^2 = .9
#I  Non-trivial commutators:
#I  [ .2, .1 ] = .3
#I  [ .3, .1 ] = .6
#I  [ .3, .2 ] = .7
#I  [ .4, .2 ] = .6
#I  [ .5, .1 ] = .7
#I  Automorphism 1:
#I  Generator  1 --> 1 0 0 0 0 0 0 1 0 
#I  Generator  2 --> 0 1 0 0 0 0 0 0 0 
#I  Automorphism 2:
#I  Generator  1 --> 1 0 0 0 0 0 0 0 1 
#I  Generator  2 --> 0 1 0 0 0 0 0 0 0 
#I  Automorphism 3:
#I  Generator  1 --> 1 0 0 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 1 0 0 
#I  Automorphism 4:
#I  Generator  1 --> 1 0 0 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 0 1 0 
#I  Automorphism 5:
#I  Generator  1 --> 1 0 0 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 0 0 1 
#I  Number of stabiliser generators is 6
#I  Automorphism 1:
#I  Generator  1 --> 1 0 0 1 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 0 0 0 
#I  Automorphism 2:
#I  Generator  1 --> 1 0 0 0 1 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 0 0 0 
#I  Automorphism 3:
#I  Generator  1 --> 1 0 0 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 1 0 0 0 0 0 
#I  Automorphism 4:
#I  Generator  1 --> 1 0 0 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 1 0 0 0 0 
#I  Automorphism 5:
#I  Generator  1 --> 0 1 0 0 0 0 0 0 0 
#I  Generator  2 --> 1 1 0 0 0 0 0 0 0 
#I  Automorphism 6:
#I  Generator  1 --> 0 1 0 0 0 0 0 0 0 
#I  Generator  2 --> 1 0 0 0 0 0 0 0 0 
#I  Group: [grp] #7;3 #86;4 to lower exponent-2 central class 3 has order 2^9
#I  Class 1
#I  1 is defined on image of defining generator 1
#I  2 is defined on image of defining generator 2
#I  Class 2
#I  3 is defined on [2, 1] = 2 1 
#I  4 is defined on 1^2 = 1 1 
#I  5 is defined on 2^2 = 2 2 
#I  Class 3
#I  6 is defined on [3, 1] = 2 1 1 
#I  7 is defined on [3, 2] = 2 1 2 
#I  8 is defined on [4, 2] = 1 1 2 
#I  9 is defined on 4^2 = 1 1 1 
#I  Non-trivial powers:
#I   .1^2 = .4
#I   .2^2 = .5
#I   .3^2 = .6 .8
#I   .4^2 = .9
#I  Non-trivial commutators:
#I  [ .2, .1 ] = .3
#I  [ .3, .1 ] = .6
#I  [ .3, .2 ] = .7
#I  [ .4, .2 ] = .8
#I  [ .5, .1 ] = .6 .7 .8
#I  Automorphism 1:
#I  Generator  1 --> 1 0 0 0 0 0 0 1 0 
#I  Generator  2 --> 0 1 0 0 0 0 0 0 0 
#I  Automorphism 2:
#I  Generator  1 --> 1 0 0 0 0 0 0 0 1 
#I  Generator  2 --> 0 1 0 0 0 0 0 0 0 
#I  Automorphism 3:
#I  Generator  1 --> 1 0 0 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 1 0 0 0 
#I  Automorphism 4:
#I  Generator  1 --> 1 0 0 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 1 0 0 
#I  Automorphism 5:
#I  Generator  1 --> 1 0 0 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 0 0 1 
#I  Number of stabiliser generators is 5
#I  Automorphism 1:
#I  Generator  1 --> 1 0 0 1 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 0 0 0 
#I  Automorphism 2:
#I  Generator  1 --> 1 0 0 0 1 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 0 0 0 
#I  Automorphism 3:
#I  Generator  1 --> 1 0 0 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 1 0 0 0 0 0 
#I  Automorphism 4:
#I  Generator  1 --> 1 0 0 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 1 0 0 0 0 
#I  Automorphism 5:
#I  Generator  1 --> 1 1 1 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 1 1 0 0 0 1 0 
#I  Group: [grp] #7;3 #87;4 to lower exponent-2 central class 3 has order 2^9
#I  Class 1
#I  1 is defined on image of defining generator 1
#I  2 is defined on image of defining generator 2
#I  Class 2
#I  3 is defined on [2, 1] = 2 1 
#I  4 is defined on 1^2 = 1 1 
#I  5 is defined on 2^2 = 2 2 
#I  Class 3
#I  6 is defined on [3, 1] = 2 1 1 
#I  7 is defined on [3, 2] = 2 1 2 
#I  8 is defined on [4, 2] = 1 1 2 
#I  9 is defined on 4^2 = 1 1 1 
#I  Non-trivial powers:
#I   .1^2 = .4
#I   .2^2 = .5
#I   .3^2 = .6 .8
#I   .4^2 = .9
#I   .5^2 = .6
#I  Non-trivial commutators:
#I  [ .2, .1 ] = .3
#I  [ .3, .1 ] = .6
#I  [ .3, .2 ] = .7
#I  [ .4, .2 ] = .8
#I  [ .5, .1 ] = .6 .7 .8
#I  Automorphism 1:
#I  Generator  1 --> 1 0 0 0 0 0 0 1 0 
#I  Generator  2 --> 0 1 0 0 0 0 0 0 0 
#I  Automorphism 2:
#I  Generator  1 --> 1 0 0 0 0 0 0 0 1 
#I  Generator  2 --> 0 1 0 0 0 0 0 0 0 
#I  Automorphism 3:
#I  Generator  1 --> 1 0 0 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 1 0 0 0 
#I  Automorphism 4:
#I  Generator  1 --> 1 0 0 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 1 0 0 
#I  Automorphism 5:
#I  Generator  1 --> 1 0 0 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 0 0 1 
#I  Number of stabiliser generators is 4
#I  Automorphism 1:
#I  Generator  1 --> 1 0 0 1 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 0 0 0 
#I  Automorphism 2:
#I  Generator  1 --> 1 0 0 0 1 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 0 0 0 
#I  Automorphism 3:
#I  Generator  1 --> 1 0 0 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 1 0 0 0 0 0 
#I  Automorphism 4:
#I  Generator  1 --> 1 0 0 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 1 0 0 0 0 
#I  Group: [grp] #7;3 #88;4 to lower exponent-2 central class 3 has order 2^9
#I  Class 1
#I  1 is defined on image of defining generator 1
#I  2 is defined on image of defining generator 2
#I  Class 2
#I  3 is defined on [2, 1] = 2 1 
#I  4 is defined on 1^2 = 1 1 
#I  5 is defined on 2^2 = 2 2 
#I  Class 3
#I  6 is defined on [3, 1] = 2 1 1 
#I  7 is defined on [3, 2] = 2 1 2 
#I  8 is defined on [4, 2] = 1 1 2 
#I  9 is defined on 4^2 = 1 1 1 
#I  Non-trivial powers:
#I   .1^2 = .4
#I   .2^2 = .5
#I   .3^2 = .6 .8
#I   .4^2 = .9
#I   .5^2 = .7
#I  Non-trivial commutators:
#I  [ .2, .1 ] = .3
#I  [ .3, .1 ] = .6
#I  [ .3, .2 ] = .7
#I  [ .4, .2 ] = .8
#I  [ .5, .1 ] = .6 .7 .8
#I  Automorphism 1:
#I  Generator  1 --> 1 0 0 0 0 0 0 1 0 
#I  Generator  2 --> 0 1 0 0 0 0 0 0 0 
#I  Automorphism 2:
#I  Generator  1 --> 1 0 0 0 0 0 0 0 1 
#I  Generator  2 --> 0 1 0 0 0 0 0 0 0 
#I  Automorphism 3:
#I  Generator  1 --> 1 0 0 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 1 0 0 0 
#I  Automorphism 4:
#I  Generator  1 --> 1 0 0 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 1 0 0 
#I  Automorphism 5:
#I  Generator  1 --> 1 0 0 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 0 0 1 
#I  Number of stabiliser generators is 5
#I  Automorphism 1:
#I  Generator  1 --> 1 0 0 1 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 0 0 0 
#I  Automorphism 2:
#I  Generator  1 --> 1 0 0 0 1 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 0 0 0 
#I  Automorphism 3:
#I  Generator  1 --> 1 0 0 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 1 0 0 0 0 0 
#I  Automorphism 4:
#I  Generator  1 --> 1 0 0 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 1 0 0 0 0 
#I  Automorphism 5:
#I  Generator  1 --> 1 1 1 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 1 1 0 0 0 1 0 
#I  Group: [grp] #7;3 #89;4 to lower exponent-2 central class 3 has order 2^9
#I  Class 1
#I  1 is defined on image of defining generator 1
#I  2 is defined on image of defining generator 2
#I  Class 2
#I  3 is defined on [2, 1] = 2 1 
#I  4 is defined on 1^2 = 1 1 
#I  5 is defined on 2^2 = 2 2 
#I  Class 3
#I  6 is defined on [3, 1] = 2 1 1 
#I  7 is defined on [3, 2] = 2 1 2 
#I  8 is defined on [4, 2] = 1 1 2 
#I  9 is defined on 4^2 = 1 1 1 
#I  Non-trivial powers:
#I   .1^2 = .4
#I   .2^2 = .5
#I   .3^2 = .6 .8
#I   .4^2 = .9
#I   .5^2 = .8
#I  Non-trivial commutators:
#I  [ .2, .1 ] = .3
#I  [ .3, .1 ] = .6
#I  [ .3, .2 ] = .7
#I  [ .4, .2 ] = .8
#I  [ .5, .1 ] = .6 .7 .8
#I  Automorphism 1:
#I  Generator  1 --> 1 0 0 0 0 0 0 1 0 
#I  Generator  2 --> 0 1 0 0 0 0 0 0 0 
#I  Automorphism 2:
#I  Generator  1 --> 1 0 0 0 0 0 0 0 1 
#I  Generator  2 --> 0 1 0 0 0 0 0 0 0 
#I  Automorphism 3:
#I  Generator  1 --> 1 0 0 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 1 0 0 0 
#I  Automorphism 4:
#I  Generator  1 --> 1 0 0 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 1 0 0 
#I  Automorphism 5:
#I  Generator  1 --> 1 0 0 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 0 0 1 
#I  Number of stabiliser generators is 4
#I  Automorphism 1:
#I  Generator  1 --> 1 0 0 1 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 0 0 0 
#I  Automorphism 2:
#I  Generator  1 --> 1 0 0 0 1 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 0 0 0 
#I  Automorphism 3:
#I  Generator  1 --> 1 0 0 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 1 0 0 0 0 0 
#I  Automorphism 4:
#I  Generator  1 --> 1 0 0 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 1 0 0 0 0 
#I  Group: [grp] #7;3 #90;4 to lower exponent-2 central class 3 has order 2^9
#I  Class 1
#I  1 is defined on image of defining generator 1
#I  2 is defined on image of defining generator 2
#I  Class 2
#I  3 is defined on [2, 1] = 2 1 
#I  4 is defined on 1^2 = 1 1 
#I  5 is defined on 2^2 = 2 2 
#I  Class 3
#I  6 is defined on [3, 1] = 2 1 1 
#I  7 is defined on [3, 2] = 2 1 2 
#I  8 is defined on [4, 2] = 1 1 2 
#I  9 is defined on 4^2 = 1 1 1 
#I  Non-trivial powers:
#I   .1^2 = .4
#I   .2^2 = .5
#I   .3^2 = .6 .8
#I   .4^2 = .9
#I   .5^2 = .6 .8
#I  Non-trivial commutators:
#I  [ .2, .1 ] = .3
#I  [ .3, .1 ] = .6
#I  [ .3, .2 ] = .7
#I  [ .4, .2 ] = .8
#I  [ .5, .1 ] = .6 .7 .8
#I  Automorphism 1:
#I  Generator  1 --> 1 0 0 0 0 0 0 1 0 
#I  Generator  2 --> 0 1 0 0 0 0 0 0 0 
#I  Automorphism 2:
#I  Generator  1 --> 1 0 0 0 0 0 0 0 1 
#I  Generator  2 --> 0 1 0 0 0 0 0 0 0 
#I  Automorphism 3:
#I  Generator  1 --> 1 0 0 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 1 0 0 0 
#I  Automorphism 4:
#I  Generator  1 --> 1 0 0 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 1 0 0 
#I  Automorphism 5:
#I  Generator  1 --> 1 0 0 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 0 0 1 
#I  Number of stabiliser generators is 5
#I  Automorphism 1:
#I  Generator  1 --> 1 0 0 1 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 0 0 0 
#I  Automorphism 2:
#I  Generator  1 --> 1 0 0 0 1 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 0 0 0 
#I  Automorphism 3:
#I  Generator  1 --> 1 0 0 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 1 0 0 0 0 0 
#I  Automorphism 4:
#I  Generator  1 --> 1 0 0 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 1 0 0 0 0 
#I  Automorphism 5:
#I  Generator  1 --> 1 1 1 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 1 1 0 0 0 1 0 
#I  Group: [grp] #7;3 #91;4 to lower exponent-2 central class 3 has order 2^9
#I  Class 1
#I  1 is defined on image of defining generator 1
#I  2 is defined on image of defining generator 2
#I  Class 2
#I  3 is defined on [2, 1] = 2 1 
#I  4 is defined on 1^2 = 1 1 
#I  5 is defined on 2^2 = 2 2 
#I  Class 3
#I  6 is defined on [3, 1] = 2 1 1 
#I  7 is defined on [3, 2] = 2 1 2 
#I  8 is defined on [4, 2] = 1 1 2 
#I  9 is defined on 4^2 = 1 1 1 
#I  Non-trivial powers:
#I   .1^2 = .4
#I   .2^2 = .5
#I   .3^2 = .6 .8
#I   .4^2 = .9
#I   .5^2 = .6 .7 .8
#I  Non-trivial commutators:
#I  [ .2, .1 ] = .3
#I  [ .3, .1 ] = .6
#I  [ .3, .2 ] = .7
#I  [ .4, .2 ] = .8
#I  [ .5, .1 ] = .6 .7 .8
#I  Automorphism 1:
#I  Generator  1 --> 1 0 0 0 0 0 0 1 0 
#I  Generator  2 --> 0 1 0 0 0 0 0 0 0 
#I  Automorphism 2:
#I  Generator  1 --> 1 0 0 0 0 0 0 0 1 
#I  Generator  2 --> 0 1 0 0 0 0 0 0 0 
#I  Automorphism 3:
#I  Generator  1 --> 1 0 0 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 1 0 0 0 
#I  Automorphism 4:
#I  Generator  1 --> 1 0 0 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 1 0 0 
#I  Automorphism 5:
#I  Generator  1 --> 1 0 0 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 0 0 1 
#I  Number of stabiliser generators is 5
#I  Automorphism 1:
#I  Generator  1 --> 1 0 0 1 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 0 0 0 
#I  Automorphism 2:
#I  Generator  1 --> 1 0 0 0 1 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 0 0 0 
#I  Automorphism 3:
#I  Generator  1 --> 1 0 0 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 1 0 0 0 0 0 
#I  Automorphism 4:
#I  Generator  1 --> 1 0 0 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 1 0 0 0 0 
#I  Automorphism 5:
#I  Generator  1 --> 1 1 1 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 1 1 0 0 0 1 0 
#I  Group: [grp] #7;3 #92;4 to lower exponent-2 central class 3 has order 2^9
#I  Class 1
#I  1 is defined on image of defining generator 1
#I  2 is defined on image of defining generator 2
#I  Class 2
#I  3 is defined on [2, 1] = 2 1 
#I  4 is defined on 1^2 = 1 1 
#I  5 is defined on 2^2 = 2 2 
#I  Class 3
#I  6 is defined on [3, 1] = 2 1 1 
#I  7 is defined on [3, 2] = 2 1 2 
#I  8 is defined on 4^2 = 1 1 1 
#I  9 is defined on 5^2 = 2 2 2 
#I  Non-trivial powers:
#I   .1^2 = .4
#I   .2^2 = .5
#I   .3^2 = .6
#I   .4^2 = .8
#I   .5^2 = .9
#I  Non-trivial commutators:
#I  [ .2, .1 ] = .3
#I  [ .3, .1 ] = .6
#I  [ .3, .2 ] = .7
#I  [ .5, .1 ] = .6 .7
#I  Automorphism 1:
#I  Generator  1 --> 1 0 0 0 0 0 0 1 0 
#I  Generator  2 --> 0 1 0 0 0 0 0 0 0 
#I  Automorphism 2:
#I  Generator  1 --> 1 0 0 0 0 0 0 0 1 
#I  Generator  2 --> 0 1 0 0 0 0 0 0 0 
#I  Automorphism 3:
#I  Generator  1 --> 1 0 0 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 1 0 0 0 
#I  Automorphism 4:
#I  Generator  1 --> 1 0 0 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 1 0 0 
#I  Automorphism 5:
#I  Generator  1 --> 1 0 0 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 0 1 0 
#I  Automorphism 6:
#I  Generator  1 --> 1 0 0 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 0 0 1 
#I  Number of stabiliser generators is 5
#I  Automorphism 1:
#I  Generator  1 --> 1 0 0 1 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 0 0 0 
#I  Automorphism 2:
#I  Generator  1 --> 1 0 0 0 1 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 0 0 0 
#I  Automorphism 3:
#I  Generator  1 --> 1 0 0 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 1 0 0 0 0 0 
#I  Automorphism 4:
#I  Generator  1 --> 1 0 0 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 1 0 0 0 0 
#I  Automorphism 5:
#I  Generator  1 --> 1 0 0 0 0 0 0 0 0 
#I  Generator  2 --> 1 1 1 0 0 0 0 0 0 
#I  # of immediate descendants of order 2^9 is 9
#I  # of capable immediate descendants is 9
#I  Group: [grp] #7;3 #93;5 to lower exponent-2 central class 3 has order 2^10
#I  Class 1
#I  1 is defined on image of defining generator 1
#I  2 is defined on image of defining generator 2
#I  Class 2
#I  3 is defined on [2, 1] = 2 1 
#I  4 is defined on 1^2 = 1 1 
#I  5 is defined on 2^2 = 2 2 
#I  Class 3
#I  6 is defined on [3, 1] = 2 1 1 
#I  7 is defined on [3, 2] = 2 1 2 
#I  8 is defined on [4, 2] = 1 1 2 
#I  9 is defined on 4^2 = 1 1 1 
#I  10 is defined on 5^2 = 2 2 2 
#I  Non-trivial powers:
#I   .1^2 = .4
#I   .2^2 = .5
#I   .3^2 = .6 .8
#I   .4^2 = .9
#I   .5^2 = .10
#I  Non-trivial commutators:
#I  [ .2, .1 ] = .3
#I  [ .3, .1 ] = .6
#I  [ .3, .2 ] = .7
#I  [ .4, .2 ] = .8
#I  [ .5, .1 ] = .6 .7 .8
#I  Automorphism 1:
#I  Generator  1 --> 1 0 0 0 0 0 0 1 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 0 0 0 0 
#I  Automorphism 2:
#I  Generator  1 --> 1 0 0 0 0 0 0 0 1 0 
#I  Generator  2 --> 0 1 0 0 0 0 0 0 0 0 
#I  Automorphism 3:
#I  Generator  1 --> 1 0 0 0 0 0 0 0 0 1 
#I  Generator  2 --> 0 1 0 0 0 0 0 0 0 0 
#I  Automorphism 4:
#I  Generator  1 --> 1 0 0 0 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 1 0 0 0 0 
#I  Automorphism 5:
#I  Generator  1 --> 1 0 0 0 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 1 0 0 0 
#I  Automorphism 6:
#I  Generator  1 --> 1 0 0 0 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 0 0 1 0 
#I  Automorphism 7:
#I  Generator  1 --> 1 0 0 0 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 0 0 0 1 
#I  Number of stabiliser generators is 6
#I  Automorphism 1:
#I  Generator  1 --> 1 0 0 1 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 0 0 0 0 
#I  Automorphism 2:
#I  Generator  1 --> 1 0 0 0 1 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 0 0 0 0 0 0 
#I  Automorphism 3:
#I  Generator  1 --> 1 0 0 0 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 1 0 0 0 0 0 0 
#I  Automorphism 4:
#I  Generator  1 --> 1 0 0 0 0 0 0 0 0 0 
#I  Generator  2 --> 0 1 0 0 1 0 0 0 0 0 
#I  Automorphism 5:
#I  Generator  1 --> 0 1 0 0 0 0 0 0 0 0 
#I  Generator  2 --> 1 1 0 0 0 0 0 0 0 0 
#I  Automorphism 6:
#I  Generator  1 --> 0 1 0 0 0 0 0 0 0 0 
#I  Generator  2 --> 1 0 0 0 0 0 0 0 0 0 
#I  # of immediate descendants of order 2^10 is 1
#I  # of capable immediate descendants is 1
#I  **************************************************
136
gap> ##Example: "2gp-PG-3-i" . . . based on: examples/pga_3-2.com
gap> ##All descendants of C2 x C2 x C2
gap> F := FreeGroup("a", "b", "c");
<free group on the generators [ a, b, c ]>
gap> procId := PqStart(F : Prime := 2);
2
gap> PqPcPresentation(procId : ClassBound := 1, 
>                           OutputLevel := 1);
#I  Lower exponent-2 central series for [grp]
#I  Group: [grp] to lower exponent-2 central class 1 has order 2^3
gap> PqComputePCover(procId);
#I  Group: [grp] to lower exponent-2 central class 2 has order 2^9
gap> PqPGSupplyAutomorphisms(procId, [ [[1,1,0],
>                                    [0,1,0],
>                                    [0,0,1]],
> 
>                                   [[0,0,1],
>                                    [1,0,0],
>                                    [0,1,0]] ]);
gap> PqPGConstructDescendants(procId : ClassBound := 5,
>                                   OrderBound := 7,
>                                   BasicAlgorithm);
#I  **************************************************
#I  Starting group: [grp]
#I  Order: 2^3
#I  Nuclear rank: 6
#I  2-multiplicator rank: 6
#I  # of immediate descendants of order 2^4 is 4
#I  # of capable immediate descendants is 2
#I  # of immediate descendants of order 2^5 is 15
#I  # of capable immediate descendants is 13
#I  # of immediate descendants of order 2^6 is 28
#I  # of capable immediate descendants is 28
#I  # of immediate descendants of order 2^7 is 15
#I  # of capable immediate descendants is 15
#I  **************************************************
#I  **************************************************
#I  Starting group: [grp] #1;1
#I  Order: 2^4
#I  Nuclear rank: 1
#I  2-multiplicator rank: 6
#I  # of immediate descendants of order 2^5 is 3
#I  # of capable immediate descendants is 1
#I  **************************************************
#I  Starting group: [grp] #2;1
#I  Order: 2^4
#I  Nuclear rank: 1
#I  2-multiplicator rank: 6
#I  # of immediate descendants of order 2^5 is 6
#I  # of capable immediate descendants is 1
#I  **************************************************
#I  Starting group: [grp] #5;2
#I  Order: 2^5
#I  Nuclear rank: 2
#I  2-multiplicator rank: 6
#I  # of immediate descendants of order 2^6 is 4
#I  # of capable immediate descendants is 2
#I  # of immediate descendants of order 2^7 is 9
#I  # of capable immediate descendants is 6
#I  **************************************************
#I  Starting group: [grp] #6;2
#I  Order: 2^5
#I  Nuclear rank: 3
#I  2-multiplicator rank: 7
#I  # of immediate descendants of order 2^6 is 16
#I  # of capable immediate descendants is 3
#I  # of immediate descendants of order 2^7 is 106
#I  # of capable immediate descendants is 54
#I  **************************************************
#I  Starting group: [grp] #7;2
#I  Order: 2^5
#I  Nuclear rank: 2
#I  2-multiplicator rank: 6
#I  # of immediate descendants of order 2^6 is 9
#I  # of capable immediate descendants is 3
#I  # of immediate descendants of order 2^7 is 13
#I  # of capable immediate descendants is 9
#I  **************************************************
#I  Starting group: [grp] #8;2
#I  Order: 2^5
#I  Nuclear rank: 1
#I  2-multiplicator rank: 5
#I  # of immediate descendants of order 2^6 is 3
#I  # of capable immediate descendants is 2
#I  **************************************************
#I  Starting group: [grp] #9;2
#I  Order: 2^5
#I  Nuclear rank: 2
#I  2-multiplicator rank: 6
#I  # of immediate descendants of order 2^6 is 11
#I  # of capable immediate descendants is 3
#I  # of immediate descendants of order 2^7 is 20
#I  # of capable immediate descendants is 10
#I  **************************************************
#I  Starting group: [grp] #10;2
#I  Order: 2^5
#I  Nuclear rank: 1
#I  2-multiplicator rank: 5
#I  # of immediate descendants of order 2^6 is 2
#I  # of capable immediate descendants is 1
#I  **************************************************
#I  Starting group: [grp] #11;2
#I  Order: 2^5
#I  Nuclear rank: 3
#I  2-multiplicator rank: 7
#I  # of immediate descendants of order 2^6 is 12
#I  # of capable immediate descendants is 2
#I  # of immediate descendants of order 2^7 is 70
#I  # of capable immediate descendants is 25
#I  **************************************************
#I  Starting group: [grp] #12;2
#I  Order: 2^5
#I  Nuclear rank: 2
#I  2-multiplicator rank: 6
#I  # of immediate descendants of order 2^6 is 15
#I  # of capable immediate descendants is 2
#I  # of immediate descendants of order 2^7 is 40
#I  # of capable immediate descendants is 13
#I  **************************************************
#I  Starting group: [grp] #13;2
#I  Order: 2^5
#I  Nuclear rank: 1
#I  2-multiplicator rank: 5
#I  # of immediate descendants of order 2^6 is 6
#I  # of capable immediate descendants is 2
#I  **************************************************
#I  Starting group: [grp] #14;2
#I  Order: 2^5
#I  Nuclear rank: 1
#I  2-multiplicator rank: 5
#I  # of immediate descendants of order 2^6 is 6
#I  # of capable immediate descendants is 2
#I  **************************************************
#I  Starting group: [grp] #15;2
#I  Order: 2^5
#I  Nuclear rank: 1
#I  2-multiplicator rank: 5
#I  # of immediate descendants of order 2^6 is 6
#I  # of capable immediate descendants is 1
#I  **************************************************
#I  Starting group: [grp] #18;2
#I  Order: 2^5
#I  Nuclear rank: 2
#I  2-multiplicator rank: 6
#I  # of immediate descendants of order 2^6 is 6
#I  # of capable immediate descendants is 1
#I  # of immediate descendants of order 2^7 is 19
#I  # of capable immediate descendants is 6
#I  **************************************************
#I  Starting group: [grp] #19;2
#I  Order: 2^5
#I  Nuclear rank: 1
#I  2-multiplicator rank: 5
#I  # of immediate descendants of order 2^6 is 4
#I  # of capable immediate descendants is 1
#I  **************************************************
#I  Starting group: [grp] #20;3
#I  Order: 2^6
#I  Nuclear rank: 3
#I  2-multiplicator rank: 6
#I  # of immediate descendants of order 2^7 is 3
#I  # of capable immediate descendants is 3
#I  **************************************************
#I  Starting group: [grp] #21;3
#I  Order: 2^6
#I  Nuclear rank: 5
#I  2-multiplicator rank: 8
#I  # of immediate descendants of order 2^7 is 17
#I  # of capable immediate descendants is 3
#I  **************************************************
#I  Starting group: [grp] #22;3
#I  Order: 2^6
#I  Nuclear rank: 3
#I  2-multiplicator rank: 6
#I  # of immediate descendants of order 2^7 is 4
#I  # of capable immediate descendants is 3
#I  **************************************************
#I  Starting group: [grp] #23;3
#I  Order: 2^6
#I  Nuclear rank: 4
#I  2-multiplicator rank: 7
#I  # of immediate descendants of order 2^7 is 18
#I  # of capable immediate descendants is 7
#I  **************************************************
#I  Starting group: [grp] #24;3
#I  Order: 2^6
#I  Nuclear rank: 3
#I  2-multiplicator rank: 6
#I  # of immediate descendants of order 2^7 is 13
#I  # of capable immediate descendants is 7
#I  **************************************************
#I  Starting group: [grp] #25;3
#I  Order: 2^6
#I  Nuclear rank: 6
#I  2-multiplicator rank: 9
#I  # of immediate descendants of order 2^7 is 18
#I  # of capable immediate descendants is 5
#I  **************************************************
#I  Starting group: [grp] #26;3
#I  Order: 2^6
#I  Nuclear rank: 4
#I  2-multiplicator rank: 7
#I  # of immediate descendants of order 2^7 is 20
#I  # of capable immediate descendants is 6
#I  **************************************************
#I  Starting group: [grp] #27;3
#I  Order: 2^6
#I  Nuclear rank: 4
#I  2-multiplicator rank: 7
#I  # of immediate descendants of order 2^7 is 14
#I  # of capable immediate descendants is 5
#I  **************************************************
#I  Starting group: [grp] #28;3
#I  Order: 2^6
#I  Nuclear rank: 3
#I  2-multiplicator rank: 6
#I  # of immediate descendants of order 2^7 is 8
#I  # of capable immediate descendants is 4
#I  **************************************************
#I  Starting group: [grp] #29;3
#I  Order: 2^6
#I  Nuclear rank: 3
#I  2-multiplicator rank: 6
#I  # of immediate descendants of order 2^7 is 3
#I  # of capable immediate descendants is 1
#I  **************************************************
#I  Starting group: [grp] #30;3
#I  Order: 2^6
#I  Nuclear rank: 3
#I  2-multiplicator rank: 6
#I  # of immediate descendants of order 2^7 is 8
#I  # of capable immediate descendants is 5
#I  **************************************************
#I  Starting group: [grp] #31;3
#I  Order: 2^6
#I  Nuclear rank: 4
#I  2-multiplicator rank: 7
#I  # of immediate descendants of order 2^7 is 19
#I  # of capable immediate descendants is 6
#I  **************************************************
#I  Starting group: [grp] #32;3
#I  Order: 2^6
#I  Nuclear rank: 5
#I  2-multiplicator rank: 8
#I  # of immediate descendants of order 2^7 is 47
#I  # of capable immediate descendants is 6
#I  **************************************************
#I  Starting group: [grp] #33;3
#I  Order: 2^6
#I  Nuclear rank: 2
#I  2-multiplicator rank: 5
#I  # of immediate descendants of order 2^7 is 7
#I  # of capable immediate descendants is 6
#I  **************************************************
#I  Starting group: [grp] #34;3
#I  Order: 2^6
#I  Nuclear rank: 3
#I  2-multiplicator rank: 6
#I  # of immediate descendants of order 2^7 is 16
#I  # of capable immediate descendants is 6
#I  **************************************************
#I  Starting group: [grp] #35;3
#I  Order: 2^6
#I  Nuclear rank: 3
#I  2-multiplicator rank: 6
#I  # of immediate descendants of order 2^7 is 15
#I  # of capable immediate descendants is 5
#I  **************************************************
#I  Starting group: [grp] #36;3
#I  Order: 2^6
#I  Nuclear rank: 4
#I  2-multiplicator rank: 7
#I  # of immediate descendants of order 2^7 is 30
#I  # of capable immediate descendants is 8
#I  **************************************************
#I  Starting group: [grp] #37;3
#I  Order: 2^6
#I  Nuclear rank: 3
#I  2-multiplicator rank: 6
#I  # of immediate descendants of order 2^7 is 15
#I  # of capable immediate descendants is 7
#I  **************************************************
#I  Starting group: [grp] #38;3
#I  Order: 2^6
#I  Nuclear rank: 5
#I  2-multiplicator rank: 8
#I  # of immediate descendants of order 2^7 is 24
#I  # of capable immediate descendants is 3
#I  **************************************************
#I  Starting group: [grp] #39;3
#I  Order: 2^6
#I  Nuclear rank: 4
#I  2-multiplicator rank: 7
#I  # of immediate descendants of order 2^7 is 10
#I  # of capable immediate descendants is 2
#I  **************************************************
#I  Starting group: [grp] #40;3
#I  Order: 2^6
#I  Nuclear rank: 4
#I  2-multiplicator rank: 7
#I  # of immediate descendants of order 2^7 is 24
#I  # of capable immediate descendants is 5
#I  **************************************************
#I  Starting group: [grp] #41;3
#I  Order: 2^6
#I  Nuclear rank: 3
#I  2-multiplicator rank: 6
#I  # of immediate descendants of order 2^7 is 6
#I  # of capable immediate descendants is 3
#I  **************************************************
#I  Starting group: [grp] #42;3
#I  Order: 2^6
#I  Nuclear rank: 3
#I  2-multiplicator rank: 6
#I  # of immediate descendants of order 2^7 is 8
#I  # of capable immediate descendants is 2
#I  **************************************************
#I  Starting group: [grp] #43;3
#I  Order: 2^6
#I  Nuclear rank: 3
#I  2-multiplicator rank: 6
#I  # of immediate descendants of order 2^7 is 12
#I  # of capable immediate descendants is 5
#I  **************************************************
#I  Starting group: [grp] #44;3
#I  Order: 2^6
#I  Nuclear rank: 2
#I  2-multiplicator rank: 5
#I  # of immediate descendants of order 2^7 is 8
#I  # of capable immediate descendants is 6
#I  **************************************************
#I  Starting group: [grp] #45;3
#I  Order: 2^6
#I  Nuclear rank: 3
#I  2-multiplicator rank: 6
#I  # of immediate descendants of order 2^7 is 8
#I  # of capable immediate descendants is 3
#I  **************************************************
#I  Starting group: [grp] #46;3
#I  Order: 2^6
#I  Nuclear rank: 2
#I  2-multiplicator rank: 5
#I  # of immediate descendants of order 2^7 is 5
#I  # of capable immediate descendants is 3
#I  **************************************************
#I  Starting group: [grp] #47;3
#I  Order: 2^6
#I  Nuclear rank: 2
#I  2-multiplicator rank: 5
#I  # of immediate descendants of order 2^7 is 1
#I  **************************************************
#I  Starting group: [grp] #48;4
#I  Order: 2^7
#I  Nuclear rank: 6
#I  2-multiplicator rank: 8
#I  Group [grp] #48;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #49;4
#I  Order: 2^7
#I  Nuclear rank: 8
#I  2-multiplicator rank: 10
#I  Group [grp] #49;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #50;4
#I  Order: 2^7
#I  Nuclear rank: 6
#I  2-multiplicator rank: 8
#I  Group [grp] #50;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #51;4
#I  Order: 2^7
#I  Nuclear rank: 6
#I  2-multiplicator rank: 8
#I  Group [grp] #51;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #52;4
#I  Order: 2^7
#I  Nuclear rank: 6
#I  2-multiplicator rank: 8
#I  Group [grp] #52;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #53;4
#I  Order: 2^7
#I  Nuclear rank: 7
#I  2-multiplicator rank: 9
#I  Group [grp] #53;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #54;4
#I  Order: 2^7
#I  Nuclear rank: 8
#I  2-multiplicator rank: 10
#I  Group [grp] #54;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #55;4
#I  Order: 2^7
#I  Nuclear rank: 7
#I  2-multiplicator rank: 9
#I  Group [grp] #55;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #56;4
#I  Order: 2^7
#I  Nuclear rank: 7
#I  2-multiplicator rank: 9
#I  Group [grp] #56;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #57;4
#I  Order: 2^7
#I  Nuclear rank: 6
#I  2-multiplicator rank: 8
#I  Group [grp] #57;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #58;4
#I  Order: 2^7
#I  Nuclear rank: 6
#I  2-multiplicator rank: 8
#I  Group [grp] #58;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #59;4
#I  Order: 2^7
#I  Nuclear rank: 6
#I  2-multiplicator rank: 8
#I  Group [grp] #59;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #60;4
#I  Order: 2^7
#I  Nuclear rank: 6
#I  2-multiplicator rank: 8
#I  Group [grp] #60;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #61;4
#I  Order: 2^7
#I  Nuclear rank: 6
#I  2-multiplicator rank: 8
#I  Group [grp] #61;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #62;4
#I  Order: 2^7
#I  Nuclear rank: 7
#I  2-multiplicator rank: 9
#I  Group [grp] #62;4 is an invalid starting group
#I  **************************************************
#I  **************************************************
#I  Starting group: [grp] #1;1 #1;1
#I  Order: 2^5
#I  Nuclear rank: 1
#I  2-multiplicator rank: 6
#I  # of immediate descendants of order 2^6 is 3
#I  # of capable immediate descendants is 1
#I  **************************************************
#I  Starting group: [grp] #2;1 #1;1
#I  Order: 2^5
#I  Nuclear rank: 1
#I  2-multiplicator rank: 6
#I  # of immediate descendants of order 2^6 is 6
#I  # of capable immediate descendants is 1
#I  **************************************************
#I  Starting group: [grp] #5;2 #1;1
#I  Order: 2^6
#I  Nuclear rank: 1
#I  2-multiplicator rank: 6
#I  # of immediate descendants of order 2^7 is 4
#I  # of capable immediate descendants is 2
#I  **************************************************
#I  Starting group: [grp] #5;2 #2;1
#I  Order: 2^6
#I  Nuclear rank: 1
#I  2-multiplicator rank: 6
#I  # of immediate descendants of order 2^7 is 2
#I  **************************************************
#I  Starting group: [grp] #5;2 #5;2
#I  Order: 2^7
#I  Nuclear rank: 2
#I  2-multiplicator rank: 6
#I  Group [grp] #5;2 #5;2 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #5;2 #6;2
#I  Order: 2^7
#I  Nuclear rank: 2
#I  2-multiplicator rank: 6
#I  Group [grp] #5;2 #6;2 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #5;2 #7;2
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 5
#I  Group [grp] #5;2 #7;2 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #5;2 #8;2
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 5
#I  Group [grp] #5;2 #8;2 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #5;2 #9;2
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 5
#I  Group [grp] #5;2 #9;2 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #5;2 #10;2
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 5
#I  Group [grp] #5;2 #10;2 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #6;2 #1;1
#I  Order: 2^6
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  # of immediate descendants of order 2^7 is 7
#I  # of capable immediate descendants is 1
#I  **************************************************
#I  Starting group: [grp] #6;2 #4;1
#I  Order: 2^6
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  # of immediate descendants of order 2^7 is 18
#I  # of capable immediate descendants is 4
#I  **************************************************
#I  Starting group: [grp] #6;2 #9;1
#I  Order: 2^6
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  # of immediate descendants of order 2^7 is 13
#I  # of capable immediate descendants is 1
#I  **************************************************
#I  Starting group: [grp] #6;2 #17;2
#I  Order: 2^7
#I  Nuclear rank: 2
#I  2-multiplicator rank: 7
#I  Group [grp] #6;2 #17;2 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #6;2 #18;2
#I  Order: 2^7
#I  Nuclear rank: 2
#I  2-multiplicator rank: 7
#I  Group [grp] #6;2 #18;2 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #6;2 #19;2
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 6
#I  Group [grp] #6;2 #19;2 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #6;2 #20;2
#I  Order: 2^7
#I  Nuclear rank: 2
#I  2-multiplicator rank: 7
#I  Group [grp] #6;2 #20;2 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #6;2 #21;2
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 6
#I  Group [grp] #6;2 #21;2 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #6;2 #22;2
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 6
#I  Group [grp] #6;2 #22;2 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #6;2 #23;2
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 6
#I  Group [grp] #6;2 #23;2 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #6;2 #24;2
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 6
#I  Group [grp] #6;2 #24;2 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #6;2 #25;2
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 6
#I  Group [grp] #6;2 #25;2 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #6;2 #26;2
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 6
#I  Group [grp] #6;2 #26;2 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #6;2 #27;2
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 6
#I  Group [grp] #6;2 #27;2 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #6;2 #28;2
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 6
#I  Group [grp] #6;2 #28;2 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #6;2 #29;2
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 6
#I  Group [grp] #6;2 #29;2 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #6;2 #32;2
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 6
#I  Group [grp] #6;2 #32;2 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #6;2 #33;2
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 6
#I  Group [grp] #6;2 #33;2 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #6;2 #35;2
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 6
#I  Group [grp] #6;2 #35;2 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #6;2 #43;2
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 6
#I  Group [grp] #6;2 #43;2 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #6;2 #46;2
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 6
#I  Group [grp] #6;2 #46;2 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #6;2 #51;2
#I  Order: 2^7
#I  Nuclear rank: 2
#I  2-multiplicator rank: 7
#I  Group [grp] #6;2 #51;2 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #6;2 #52;2
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 6
#I  Group [grp] #6;2 #52;2 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #6;2 #53;2
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 6
#I  Group [grp] #6;2 #53;2 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #6;2 #54;2
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 6
#I  Group [grp] #6;2 #54;2 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #6;2 #58;2
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 6
#I  Group [grp] #6;2 #58;2 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #6;2 #59;2
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 6
#I  Group [grp] #6;2 #59;2 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #6;2 #60;2
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 6
#I  Group [grp] #6;2 #60;2 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #6;2 #64;2
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 6
#I  Group [grp] #6;2 #64;2 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #6;2 #68;2
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 6
#I  Group [grp] #6;2 #68;2 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #6;2 #71;2
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 6
#I  Group [grp] #6;2 #71;2 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #6;2 #75;2
#I  Order: 2^7
#I  Nuclear rank: 2
#I  2-multiplicator rank: 7
#I  Group [grp] #6;2 #75;2 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #6;2 #76;2
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 6
#I  Group [grp] #6;2 #76;2 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #6;2 #77;2
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 6
#I  Group [grp] #6;2 #77;2 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #6;2 #78;2
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 6
#I  Group [grp] #6;2 #78;2 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #6;2 #79;2
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 6
#I  Group [grp] #6;2 #79;2 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #6;2 #80;2
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 6
#I  Group [grp] #6;2 #80;2 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #6;2 #81;2
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 6
#I  Group [grp] #6;2 #81;2 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #6;2 #87;2
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 6
#I  Group [grp] #6;2 #87;2 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #6;2 #91;2
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 6
#I  Group [grp] #6;2 #91;2 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #6;2 #93;2
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 6
#I  Group [grp] #6;2 #93;2 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #6;2 #99;2
#I  Order: 2^7
#I  Nuclear rank: 2
#I  2-multiplicator rank: 7
#I  Group [grp] #6;2 #99;2 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #6;2 #100;2
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 6
#I  Group [grp] #6;2 #100;2 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #6;2 #102;2
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 6
#I  Group [grp] #6;2 #102;2 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #6;2 #103;2
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 6
#I  Group [grp] #6;2 #103;2 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #6;2 #105;2
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 6
#I  Group [grp] #6;2 #105;2 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #6;2 #106;2
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 6
#I  Group [grp] #6;2 #106;2 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #6;2 #108;2
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 6
#I  Group [grp] #6;2 #108;2 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #6;2 #109;2
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 6
#I  Group [grp] #6;2 #109;2 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #6;2 #111;2
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 6
#I  Group [grp] #6;2 #111;2 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #6;2 #112;2
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 6
#I  Group [grp] #6;2 #112;2 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #6;2 #114;2
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 6
#I  Group [grp] #6;2 #114;2 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #6;2 #115;2
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 6
#I  Group [grp] #6;2 #115;2 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #6;2 #117;2
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 6
#I  Group [grp] #6;2 #117;2 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #6;2 #118;2
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 6
#I  Group [grp] #6;2 #118;2 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #6;2 #120;2
#I  Order: 2^7
#I  Nuclear rank: 2
#I  2-multiplicator rank: 7
#I  Group [grp] #6;2 #120;2 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #6;2 #121;2
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 6
#I  Group [grp] #6;2 #121;2 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #7;2 #1;1
#I  Order: 2^6
#I  Nuclear rank: 1
#I  2-multiplicator rank: 6
#I  # of immediate descendants of order 2^7 is 5
#I  # of capable immediate descendants is 1
#I  **************************************************
#I  Starting group: [grp] #7;2 #4;1
#I  Order: 2^6
#I  Nuclear rank: 1
#I  2-multiplicator rank: 6
#I  # of immediate descendants of order 2^7 is 2
#I  **************************************************
#I  Starting group: [grp] #7;2 #5;1
#I  Order: 2^6
#I  Nuclear rank: 1
#I  2-multiplicator rank: 6
#I  # of immediate descendants of order 2^7 is 6
#I  # of capable immediate descendants is 2
#I  **************************************************
#I  Starting group: [grp] #7;2 #10;2
#I  Order: 2^7
#I  Nuclear rank: 2
#I  2-multiplicator rank: 6
#I  Group [grp] #7;2 #10;2 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #7;2 #11;2
#I  Order: 2^7
#I  Nuclear rank: 2
#I  2-multiplicator rank: 6
#I  Group [grp] #7;2 #11;2 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #7;2 #12;2
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 5
#I  Group [grp] #7;2 #12;2 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #7;2 #13;2
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 5
#I  Group [grp] #7;2 #13;2 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #7;2 #14;2
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 5
#I  Group [grp] #7;2 #14;2 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #7;2 #15;2
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 5
#I  Group [grp] #7;2 #15;2 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #7;2 #16;2
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 5
#I  Group [grp] #7;2 #16;2 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #7;2 #18;2
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 5
#I  Group [grp] #7;2 #18;2 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #7;2 #19;2
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 5
#I  Group [grp] #7;2 #19;2 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #8;2 #1;1
#I  Order: 2^6
#I  Nuclear rank: 1
#I  2-multiplicator rank: 5
#I  # of immediate descendants of order 2^7 is 3
#I  # of capable immediate descendants is 2
#I  **************************************************
#I  Starting group: [grp] #8;2 #2;1
#I  Order: 2^6
#I  Nuclear rank: 1
#I  2-multiplicator rank: 5
#I  # of immediate descendants of order 2^7 is 2
#I  **************************************************
#I  Starting group: [grp] #9;2 #1;1
#I  Order: 2^6
#I  Nuclear rank: 1
#I  2-multiplicator rank: 6
#I  # of immediate descendants of order 2^7 is 5
#I  # of capable immediate descendants is 1
#I  **************************************************
#I  Starting group: [grp] #9;2 #3;1
#I  Order: 2^6
#I  Nuclear rank: 1
#I  2-multiplicator rank: 6
#I  # of immediate descendants of order 2^7 is 8
#I  # of capable immediate descendants is 2
#I  **************************************************
#I  Starting group: [grp] #9;2 #8;1
#I  Order: 2^6
#I  Nuclear rank: 1
#I  2-multiplicator rank: 6
#I  # of immediate descendants of order 2^7 is 2
#I  **************************************************
#I  Starting group: [grp] #9;2 #12;2
#I  Order: 2^7
#I  Nuclear rank: 2
#I  2-multiplicator rank: 6
#I  Group [grp] #9;2 #12;2 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #9;2 #13;2
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 5
#I  Group [grp] #9;2 #13;2 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #9;2 #14;2
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 5
#I  Group [grp] #9;2 #14;2 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #9;2 #15;2
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 5
#I  Group [grp] #9;2 #15;2 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #9;2 #16;2
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 5
#I  Group [grp] #9;2 #16;2 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #9;2 #17;2
#I  Order: 2^7
#I  Nuclear rank: 2
#I  2-multiplicator rank: 6
#I  Group [grp] #9;2 #17;2 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #9;2 #18;2
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 5
#I  Group [grp] #9;2 #18;2 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #9;2 #23;2
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 5
#I  Group [grp] #9;2 #23;2 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #9;2 #24;2
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 5
#I  Group [grp] #9;2 #24;2 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #9;2 #29;2
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 5
#I  Group [grp] #9;2 #29;2 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #10;2 #1;1
#I  Order: 2^6
#I  Nuclear rank: 1
#I  2-multiplicator rank: 5
#I  # of immediate descendants of order 2^7 is 2
#I  # of capable immediate descendants is 1
#I  **************************************************
#I  Starting group: [grp] #11;2 #1;1
#I  Order: 2^6
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  # of immediate descendants of order 2^7 is 12
#I  # of capable immediate descendants is 1
#I  **************************************************
#I  Starting group: [grp] #11;2 #11;1
#I  Order: 2^6
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  # of immediate descendants of order 2^7 is 10
#I  # of capable immediate descendants is 1
#I  **************************************************
#I  Starting group: [grp] #11;2 #13;2
#I  Order: 2^7
#I  Nuclear rank: 2
#I  2-multiplicator rank: 7
#I  Group [grp] #11;2 #13;2 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #11;2 #14;2
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 6
#I  Group [grp] #11;2 #14;2 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #11;2 #15;2
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 6
#I  Group [grp] #11;2 #15;2 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #11;2 #16;2
#I  Order: 2^7
#I  Nuclear rank: 2
#I  2-multiplicator rank: 7
#I  Group [grp] #11;2 #16;2 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #11;2 #17;2
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 6
#I  Group [grp] #11;2 #17;2 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #11;2 #18;2
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 6
#I  Group [grp] #11;2 #18;2 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #11;2 #19;2
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 6
#I  Group [grp] #11;2 #19;2 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #11;2 #20;2
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 6
#I  Group [grp] #11;2 #20;2 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #11;2 #21;2
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 6
#I  Group [grp] #11;2 #21;2 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #11;2 #22;2
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 6
#I  Group [grp] #11;2 #22;2 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #11;2 #23;2
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 6
#I  Group [grp] #11;2 #23;2 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #11;2 #24;2
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 6
#I  Group [grp] #11;2 #24;2 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #11;2 #25;2
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 6
#I  Group [grp] #11;2 #25;2 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #11;2 #28;2
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 6
#I  Group [grp] #11;2 #28;2 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #11;2 #31;2
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 6
#I  Group [grp] #11;2 #31;2 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #11;2 #34;2
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 6
#I  Group [grp] #11;2 #34;2 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #11;2 #41;2
#I  Order: 2^7
#I  Nuclear rank: 2
#I  2-multiplicator rank: 7
#I  Group [grp] #11;2 #41;2 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #11;2 #43;2
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 6
#I  Group [grp] #11;2 #43;2 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #11;2 #47;2
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 6
#I  Group [grp] #11;2 #47;2 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #11;2 #49;2
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 6
#I  Group [grp] #11;2 #49;2 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #11;2 #51;2
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 6
#I  Group [grp] #11;2 #51;2 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #11;2 #61;2
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 6
#I  Group [grp] #11;2 #61;2 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #11;2 #63;2
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 6
#I  Group [grp] #11;2 #63;2 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #11;2 #69;2
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 6
#I  Group [grp] #11;2 #69;2 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #11;2 #71;2
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 6
#I  Group [grp] #11;2 #71;2 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #12;2 #1;1
#I  Order: 2^6
#I  Nuclear rank: 1
#I  2-multiplicator rank: 6
#I  # of immediate descendants of order 2^7 is 9
#I  # of capable immediate descendants is 1
#I  **************************************************
#I  Starting group: [grp] #12;2 #8;1
#I  Order: 2^6
#I  Nuclear rank: 1
#I  2-multiplicator rank: 6
#I  # of immediate descendants of order 2^7 is 9
#I  # of capable immediate descendants is 1
#I  **************************************************
#I  Starting group: [grp] #12;2 #16;2
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 5
#I  Group [grp] #12;2 #16;2 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #12;2 #18;2
#I  Order: 2^7
#I  Nuclear rank: 2
#I  2-multiplicator rank: 6
#I  Group [grp] #12;2 #18;2 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #12;2 #19;2
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 5
#I  Group [grp] #12;2 #19;2 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #12;2 #20;2
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 5
#I  Group [grp] #12;2 #20;2 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #12;2 #24;2
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 5
#I  Group [grp] #12;2 #24;2 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #12;2 #25;2
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 5
#I  Group [grp] #12;2 #25;2 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #12;2 #26;2
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 5
#I  Group [grp] #12;2 #26;2 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #12;2 #28;2
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 5
#I  Group [grp] #12;2 #28;2 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #12;2 #32;2
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 5
#I  Group [grp] #12;2 #32;2 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #12;2 #33;2
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 5
#I  Group [grp] #12;2 #33;2 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #12;2 #36;2
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 5
#I  Group [grp] #12;2 #36;2 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #12;2 #38;2
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 5
#I  Group [grp] #12;2 #38;2 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #12;2 #40;2
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 5
#I  Group [grp] #12;2 #40;2 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #13;2 #1;1
#I  Order: 2^6
#I  Nuclear rank: 1
#I  2-multiplicator rank: 5
#I  # of immediate descendants of order 2^7 is 6
#I  # of capable immediate descendants is 2
#I  **************************************************
#I  Starting group: [grp] #13;2 #3;1
#I  Order: 2^6
#I  Nuclear rank: 1
#I  2-multiplicator rank: 5
#I  # of immediate descendants of order 2^7 is 2
#I  **************************************************
#I  Starting group: [grp] #14;2 #1;1
#I  Order: 2^6
#I  Nuclear rank: 1
#I  2-multiplicator rank: 5
#I  # of immediate descendants of order 2^7 is 6
#I  # of capable immediate descendants is 2
#I  **************************************************
#I  Starting group: [grp] #14;2 #2;1
#I  Order: 2^6
#I  Nuclear rank: 1
#I  2-multiplicator rank: 5
#I  # of immediate descendants of order 2^7 is 2
#I  **************************************************
#I  Starting group: [grp] #15;2 #1;1
#I  Order: 2^6
#I  Nuclear rank: 1
#I  2-multiplicator rank: 5
#I  # of immediate descendants of order 2^7 is 6
#I  # of capable immediate descendants is 1
#I  **************************************************
#I  Starting group: [grp] #18;2 #2;1
#I  Order: 2^6
#I  Nuclear rank: 1
#I  2-multiplicator rank: 6
#I  # of immediate descendants of order 2^7 is 6
#I  # of capable immediate descendants is 1
#I  **************************************************
#I  Starting group: [grp] #18;2 #8;2
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 5
#I  Group [grp] #18;2 #8;2 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #18;2 #11;2
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 5
#I  Group [grp] #18;2 #11;2 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #18;2 #14;2
#I  Order: 2^7
#I  Nuclear rank: 2
#I  2-multiplicator rank: 6
#I  Group [grp] #18;2 #14;2 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #18;2 #15;2
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 5
#I  Group [grp] #18;2 #15;2 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #18;2 #23;2
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 5
#I  Group [grp] #18;2 #23;2 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #18;2 #24;2
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 5
#I  Group [grp] #18;2 #24;2 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #19;2 #3;1
#I  Order: 2^6
#I  Nuclear rank: 1
#I  2-multiplicator rank: 5
#I  # of immediate descendants of order 2^7 is 4
#I  # of capable immediate descendants is 1
#I  **************************************************
#I  Starting group: [grp] #20;3 #1;1
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 6
#I  Group [grp] #20;3 #1;1 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #20;3 #2;1
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 6
#I  Group [grp] #20;3 #2;1 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #20;3 #3;1
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 6
#I  Group [grp] #20;3 #3;1 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #21;3 #1;1
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 8
#I  Group [grp] #21;3 #1;1 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #21;3 #6;1
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 8
#I  Group [grp] #21;3 #6;1 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #21;3 #11;1
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 8
#I  Group [grp] #21;3 #11;1 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #22;3 #1;1
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 6
#I  Group [grp] #22;3 #1;1 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #22;3 #2;1
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 6
#I  Group [grp] #22;3 #2;1 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #22;3 #3;1
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 6
#I  Group [grp] #22;3 #3;1 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #23;3 #1;1
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #23;3 #1;1 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #23;3 #2;1
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #23;3 #2;1 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #23;3 #4;1
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #23;3 #4;1 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #23;3 #5;1
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #23;3 #5;1 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #23;3 #7;1
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #23;3 #7;1 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #23;3 #13;1
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #23;3 #13;1 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #23;3 #15;1
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #23;3 #15;1 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #24;3 #1;1
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 6
#I  Group [grp] #24;3 #1;1 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #24;3 #2;1
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 6
#I  Group [grp] #24;3 #2;1 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #24;3 #4;1
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 6
#I  Group [grp] #24;3 #4;1 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #24;3 #5;1
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 6
#I  Group [grp] #24;3 #5;1 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #24;3 #9;1
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 6
#I  Group [grp] #24;3 #9;1 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #24;3 #10;1
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 6
#I  Group [grp] #24;3 #10;1 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #24;3 #11;1
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 6
#I  Group [grp] #24;3 #11;1 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #25;3 #1;1
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 9
#I  Group [grp] #25;3 #1;1 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #25;3 #3;1
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 9
#I  Group [grp] #25;3 #3;1 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #25;3 #4;1
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 9
#I  Group [grp] #25;3 #4;1 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #25;3 #8;1
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 9
#I  Group [grp] #25;3 #8;1 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #25;3 #12;1
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 9
#I  Group [grp] #25;3 #12;1 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #26;3 #1;1
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #26;3 #1;1 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #26;3 #3;1
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #26;3 #3;1 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #26;3 #6;1
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #26;3 #6;1 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #26;3 #8;1
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #26;3 #8;1 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #26;3 #11;1
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #26;3 #11;1 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #26;3 #12;1
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #26;3 #12;1 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #27;3 #1;1
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #27;3 #1;1 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #27;3 #3;1
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #27;3 #3;1 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #27;3 #4;1
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #27;3 #4;1 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #27;3 #7;1
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #27;3 #7;1 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #27;3 #8;1
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #27;3 #8;1 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #28;3 #1;1
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 6
#I  Group [grp] #28;3 #1;1 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #28;3 #2;1
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 6
#I  Group [grp] #28;3 #2;1 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #28;3 #3;1
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 6
#I  Group [grp] #28;3 #3;1 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #28;3 #4;1
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 6
#I  Group [grp] #28;3 #4;1 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #29;3 #1;1
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 6
#I  Group [grp] #29;3 #1;1 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #30;3 #1;1
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 6
#I  Group [grp] #30;3 #1;1 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #30;3 #2;1
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 6
#I  Group [grp] #30;3 #2;1 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #30;3 #3;1
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 6
#I  Group [grp] #30;3 #3;1 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #30;3 #4;1
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 6
#I  Group [grp] #30;3 #4;1 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #30;3 #5;1
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 6
#I  Group [grp] #30;3 #5;1 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #31;3 #1;1
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #31;3 #1;1 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #31;3 #3;1
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #31;3 #3;1 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #31;3 #4;1
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #31;3 #4;1 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #31;3 #10;1
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #31;3 #10;1 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #31;3 #15;1
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #31;3 #15;1 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #31;3 #17;1
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #31;3 #17;1 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #32;3 #1;1
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 8
#I  Group [grp] #32;3 #1;1 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #32;3 #6;1
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 8
#I  Group [grp] #32;3 #6;1 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #32;3 #11;1
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 8
#I  Group [grp] #32;3 #11;1 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #32;3 #21;1
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 8
#I  Group [grp] #32;3 #21;1 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #32;3 #25;1
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 8
#I  Group [grp] #32;3 #25;1 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #32;3 #30;1
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 8
#I  Group [grp] #32;3 #30;1 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #33;3 #1;1
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 5
#I  Group [grp] #33;3 #1;1 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #33;3 #2;1
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 5
#I  Group [grp] #33;3 #2;1 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #33;3 #3;1
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 5
#I  Group [grp] #33;3 #3;1 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #33;3 #4;1
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 5
#I  Group [grp] #33;3 #4;1 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #33;3 #5;1
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 5
#I  Group [grp] #33;3 #5;1 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #33;3 #6;1
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 5
#I  Group [grp] #33;3 #6;1 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #34;3 #1;1
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 6
#I  Group [grp] #34;3 #1;1 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #34;3 #2;1
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 6
#I  Group [grp] #34;3 #2;1 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #34;3 #3;1
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 6
#I  Group [grp] #34;3 #3;1 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #34;3 #4;1
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 6
#I  Group [grp] #34;3 #4;1 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #34;3 #12;1
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 6
#I  Group [grp] #34;3 #12;1 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #34;3 #14;1
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 6
#I  Group [grp] #34;3 #14;1 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #35;3 #1;1
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 6
#I  Group [grp] #35;3 #1;1 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #35;3 #4;1
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 6
#I  Group [grp] #35;3 #4;1 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #35;3 #5;1
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 6
#I  Group [grp] #35;3 #5;1 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #35;3 #9;1
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 6
#I  Group [grp] #35;3 #9;1 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #35;3 #10;1
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 6
#I  Group [grp] #35;3 #10;1 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #36;3 #1;1
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #36;3 #1;1 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #36;3 #2;1
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #36;3 #2;1 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #36;3 #4;1
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #36;3 #4;1 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #36;3 #8;1
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #36;3 #8;1 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #36;3 #11;1
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #36;3 #11;1 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #36;3 #17;1
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #36;3 #17;1 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #36;3 #19;1
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #36;3 #19;1 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #36;3 #29;1
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #36;3 #29;1 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #37;3 #1;1
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 6
#I  Group [grp] #37;3 #1;1 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #37;3 #2;1
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 6
#I  Group [grp] #37;3 #2;1 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #37;3 #4;1
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 6
#I  Group [grp] #37;3 #4;1 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #37;3 #5;1
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 6
#I  Group [grp] #37;3 #5;1 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #37;3 #7;1
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 6
#I  Group [grp] #37;3 #7;1 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #37;3 #10;1
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 6
#I  Group [grp] #37;3 #10;1 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #37;3 #13;1
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 6
#I  Group [grp] #37;3 #13;1 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #38;3 #5;1
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 8
#I  Group [grp] #38;3 #5;1 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #38;3 #7;1
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 8
#I  Group [grp] #38;3 #7;1 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #38;3 #13;1
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 8
#I  Group [grp] #38;3 #13;1 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #39;3 #1;1
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #39;3 #1;1 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #39;3 #7;1
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #39;3 #7;1 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #40;3 #3;1
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #40;3 #3;1 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #40;3 #6;1
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #40;3 #6;1 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #40;3 #12;1
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #40;3 #12;1 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #40;3 #15;1
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #40;3 #15;1 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #40;3 #16;1
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #40;3 #16;1 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #41;3 #1;1
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 6
#I  Group [grp] #41;3 #1;1 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #41;3 #2;1
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 6
#I  Group [grp] #41;3 #2;1 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #41;3 #6;1
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 6
#I  Group [grp] #41;3 #6;1 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #42;3 #5;1
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 6
#I  Group [grp] #42;3 #5;1 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #42;3 #7;1
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 6
#I  Group [grp] #42;3 #7;1 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #43;3 #1;1
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 6
#I  Group [grp] #43;3 #1;1 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #43;3 #3;1
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 6
#I  Group [grp] #43;3 #3;1 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #43;3 #5;1
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 6
#I  Group [grp] #43;3 #5;1 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #43;3 #6;1
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 6
#I  Group [grp] #43;3 #6;1 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #43;3 #7;1
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 6
#I  Group [grp] #43;3 #7;1 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #44;3 #1;1
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 5
#I  Group [grp] #44;3 #1;1 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #44;3 #2;1
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 5
#I  Group [grp] #44;3 #2;1 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #44;3 #3;1
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 5
#I  Group [grp] #44;3 #3;1 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #44;3 #4;1
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 5
#I  Group [grp] #44;3 #4;1 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #44;3 #5;1
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 5
#I  Group [grp] #44;3 #5;1 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #44;3 #6;1
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 5
#I  Group [grp] #44;3 #6;1 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #45;3 #2;1
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 6
#I  Group [grp] #45;3 #2;1 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #45;3 #3;1
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 6
#I  Group [grp] #45;3 #3;1 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #45;3 #4;1
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 6
#I  Group [grp] #45;3 #4;1 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #46;3 #1;1
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 5
#I  Group [grp] #46;3 #1;1 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #46;3 #2;1
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 5
#I  Group [grp] #46;3 #2;1 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #46;3 #3;1
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 5
#I  Group [grp] #46;3 #3;1 is an invalid starting group
#I  **************************************************
#I  **************************************************
#I  Starting group: [grp] #1;1 #1;1 #1;1
#I  Order: 2^6
#I  Nuclear rank: 1
#I  2-multiplicator rank: 6
#I  # of immediate descendants of order 2^7 is 3
#I  # of capable immediate descendants is 1
#I  **************************************************
#I  Starting group: [grp] #2;1 #1;1 #1;1
#I  Order: 2^6
#I  Nuclear rank: 1
#I  2-multiplicator rank: 6
#I  # of immediate descendants of order 2^7 is 6
#I  # of capable immediate descendants is 1
#I  **************************************************
#I  Starting group: [grp] #5;2 #1;1 #1;1
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 6
#I  Group [grp] #5;2 #1;1 #1;1 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #5;2 #1;1 #2;1
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 6
#I  Group [grp] #5;2 #1;1 #2;1 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #6;2 #1;1 #1;1
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #6;2 #1;1 #1;1 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #6;2 #4;1 #1;1
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #6;2 #4;1 #1;1 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #6;2 #4;1 #2;1
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #6;2 #4;1 #2;1 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #6;2 #4;1 #4;1
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #6;2 #4;1 #4;1 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #6;2 #4;1 #13;1
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #6;2 #4;1 #13;1 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #6;2 #9;1 #1;1
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #6;2 #9;1 #1;1 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #7;2 #1;1 #1;1
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 6
#I  Group [grp] #7;2 #1;1 #1;1 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #7;2 #5;1 #1;1
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 6
#I  Group [grp] #7;2 #5;1 #1;1 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #7;2 #5;1 #2;1
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 6
#I  Group [grp] #7;2 #5;1 #2;1 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #8;2 #1;1 #1;1
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 5
#I  Group [grp] #8;2 #1;1 #1;1 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #8;2 #1;1 #2;1
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 5
#I  Group [grp] #8;2 #1;1 #2;1 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #9;2 #1;1 #1;1
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 6
#I  Group [grp] #9;2 #1;1 #1;1 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #9;2 #3;1 #1;1
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 6
#I  Group [grp] #9;2 #3;1 #1;1 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #9;2 #3;1 #6;1
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 6
#I  Group [grp] #9;2 #3;1 #6;1 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #10;2 #1;1 #1;1
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 5
#I  Group [grp] #10;2 #1;1 #1;1 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #11;2 #1;1 #1;1
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #11;2 #1;1 #1;1 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #11;2 #11;1 #1;1
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #11;2 #11;1 #1;1 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #12;2 #1;1 #1;1
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 6
#I  Group [grp] #12;2 #1;1 #1;1 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #12;2 #8;1 #1;1
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 6
#I  Group [grp] #12;2 #8;1 #1;1 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #13;2 #1;1 #1;1
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 5
#I  Group [grp] #13;2 #1;1 #1;1 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #13;2 #1;1 #3;1
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 5
#I  Group [grp] #13;2 #1;1 #3;1 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #14;2 #1;1 #1;1
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 5
#I  Group [grp] #14;2 #1;1 #1;1 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #14;2 #1;1 #2;1
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 5
#I  Group [grp] #14;2 #1;1 #2;1 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #15;2 #1;1 #1;1
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 5
#I  Group [grp] #15;2 #1;1 #1;1 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #18;2 #2;1 #1;1
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 6
#I  Group [grp] #18;2 #2;1 #1;1 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #19;2 #3;1 #1;1
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 5
#I  Group [grp] #19;2 #3;1 #1;1 is an invalid starting group
#I  **************************************************
365
gap> ##Example: "2gp-PG-4-i" . . . based on: examples/pga_4-2.com
gap> ##All descendants of C2 x C2 x C2 x C2
gap> F := FreeGroup("a", "b", "c", "d");
<free group on the generators [ a, b, c, d ]>
gap> procId := PqStart(F : Prime := 2);
3
gap> PqPcPresentation(procId : ClassBound := 1, 
>                           OutputLevel := 1);
#I  Lower exponent-2 central series for [grp]
#I  Group: [grp] to lower exponent-2 central class 1 has order 2^4
gap> PqComputePCover(procId);
#I  Group: [grp] to lower exponent-2 central class 2 has order 2^14
gap> PqPGSupplyAutomorphisms(procId, [ [[1,1,0,0],
>                                    [0,1,0,0],
>                                    [0,0,1,0],
>                                    [0,0,0,1]],
> 
>                                   [[0,0,0,1],
>                                    [1,0,0,0],
>                                    [0,1,0,0],
>                                    [0,0,1,0]] ]);
gap> PqPGConstructDescendants(procId : ClassBound := 4,
>                                   OrderBound := 8,
>                                   BasicAlgorithm);
#I  **************************************************
#I  Starting group: [grp]
#I  Order: 2^4
#I  Nuclear rank: 10
#I  2-multiplicator rank: 10
#I  # of immediate descendants of order 2^5 is 6
#I  # of capable immediate descendants is 2
#I  # of immediate descendants of order 2^6 is 54
#I  # of capable immediate descendants is 29
#I  # of immediate descendants of order 2^7 is 604
#I  # of capable immediate descendants is 439
#I  # of immediate descendants of order 2^8 is 3566
#I  # of capable immediate descendants is 3458
#I  **************************************************
#I  **************************************************
#I  Starting group: [grp] #1;1
#I  Order: 2^5
#I  Nuclear rank: 1
#I  2-multiplicator rank: 10
#I  # of immediate descendants of order 2^6 is 4
#I  # of capable immediate descendants is 1
#I  **************************************************
#I  Starting group: [grp] #2;1
#I  Order: 2^5
#I  Nuclear rank: 1
#I  2-multiplicator rank: 10
#I  # of immediate descendants of order 2^6 is 10
#I  # of capable immediate descendants is 1
#I  **************************************************
#I  Starting group: [grp] #7;2
#I  Order: 2^6
#I  Nuclear rank: 2
#I  2-multiplicator rank: 10
#I  # of immediate descendants of order 2^7 is 7
#I  # of capable immediate descendants is 2
#I  # of immediate descendants of order 2^8 is 33
#I  # of capable immediate descendants is 11
#I  **************************************************
#I  Starting group: [grp] #8;2
#I  Order: 2^6
#I  Nuclear rank: 3
#I  2-multiplicator rank: 11
#I  # of immediate descendants of order 2^7 is 26
#I  # of capable immediate descendants is 3
#I  # of immediate descendants of order 2^8 is 440
#I  # of capable immediate descendants is 96
#I  **************************************************
#I  Starting group: [grp] #9;2
#I  Order: 2^6
#I  Nuclear rank: 2
#I  2-multiplicator rank: 10
#I  # of immediate descendants of order 2^7 is 15
#I  # of capable immediate descendants is 3
#I  # of immediate descendants of order 2^8 is 59
#I  # of capable immediate descendants is 16
#I  **************************************************
#I  Starting group: [grp] #10;2
#I  Order: 2^6
#I  Nuclear rank: 1
#I  2-multiplicator rank: 9
#I  # of immediate descendants of order 2^7 is 9
#I  # of capable immediate descendants is 2
#I  **************************************************
#I  Starting group: [grp] #11;2
#I  Order: 2^6
#I  Nuclear rank: 2
#I  2-multiplicator rank: 10
#I  # of immediate descendants of order 2^7 is 32
#I  # of capable immediate descendants is 3
#I  # of immediate descendants of order 2^8 is 252
#I  # of capable immediate descendants is 35
#I  **************************************************
#I  Starting group: [grp] #12;2
#I  Order: 2^6
#I  Nuclear rank: 1
#I  2-multiplicator rank: 9
#I  # of immediate descendants of order 2^7 is 6
#I  # of capable immediate descendants is 1
#I  **************************************************
#I  Starting group: [grp] #13;2
#I  Order: 2^6
#I  Nuclear rank: 1
#I  2-multiplicator rank: 9
#I  # of immediate descendants of order 2^7 is 8
#I  # of capable immediate descendants is 1
#I  **************************************************
#I  Starting group: [grp] #14;2
#I  Order: 2^6
#I  Nuclear rank: 1
#I  2-multiplicator rank: 9
#I  # of immediate descendants of order 2^7 is 10
#I  # of capable immediate descendants is 1
#I  **************************************************
#I  Starting group: [grp] #15;2
#I  Order: 2^6
#I  Nuclear rank: 1
#I  2-multiplicator rank: 9
#I  # of immediate descendants of order 2^7 is 6
#I  # of capable immediate descendants is 1
#I  **************************************************
#I  Starting group: [grp] #16;2
#I  Order: 2^6
#I  Nuclear rank: 1
#I  2-multiplicator rank: 9
#I  # of immediate descendants of order 2^7 is 8
#I  # of capable immediate descendants is 1
#I  **************************************************
#I  Starting group: [grp] #17;2
#I  Order: 2^6
#I  Nuclear rank: 3
#I  2-multiplicator rank: 11
#I  # of immediate descendants of order 2^7 is 33
#I  # of capable immediate descendants is 2
#I  # of immediate descendants of order 2^8 is 1004
#I  # of capable immediate descendants is 107
#I  **************************************************
#I  Starting group: [grp] #18;2
#I  Order: 2^6
#I  Nuclear rank: 2
#I  2-multiplicator rank: 10
#I  # of immediate descendants of order 2^7 is 41
#I  # of capable immediate descendants is 2
#I  # of immediate descendants of order 2^8 is 494
#I  # of capable immediate descendants is 37
#I  **************************************************
#I  Starting group: [grp] #19;2
#I  Order: 2^6
#I  Nuclear rank: 1
#I  2-multiplicator rank: 9
#I  # of immediate descendants of order 2^7 is 15
#I  # of capable immediate descendants is 2
#I  **************************************************
#I  Starting group: [grp] #20;2
#I  Order: 2^6
#I  Nuclear rank: 1
#I  2-multiplicator rank: 9
#I  # of immediate descendants of order 2^7 is 15
#I  # of capable immediate descendants is 2
#I  **************************************************
#I  Starting group: [grp] #21;2
#I  Order: 2^6
#I  Nuclear rank: 1
#I  2-multiplicator rank: 9
#I  # of immediate descendants of order 2^7 is 28
#I  # of capable immediate descendants is 2
#I  **************************************************
#I  Starting group: [grp] #22;2
#I  Order: 2^6
#I  Nuclear rank: 1
#I  2-multiplicator rank: 9
#I  # of immediate descendants of order 2^7 is 15
#I  # of capable immediate descendants is 1
#I  **************************************************
#I  Starting group: [grp] #26;2
#I  Order: 2^6
#I  Nuclear rank: 2
#I  2-multiplicator rank: 10
#I  # of immediate descendants of order 2^7 is 14
#I  # of capable immediate descendants is 1
#I  # of immediate descendants of order 2^8 is 163
#I  # of capable immediate descendants is 14
#I  **************************************************
#I  Starting group: [grp] #27;2
#I  Order: 2^6
#I  Nuclear rank: 1
#I  2-multiplicator rank: 9
#I  # of immediate descendants of order 2^7 is 10
#I  # of capable immediate descendants is 1
#I  **************************************************
#I  Starting group: [grp] #28;2
#I  Order: 2^6
#I  Nuclear rank: 1
#I  2-multiplicator rank: 9
#I  # of immediate descendants of order 2^7 is 19
#I  # of capable immediate descendants is 1
#I  **************************************************
#I  Starting group: [grp] #30;2
#I  Order: 2^6
#I  Nuclear rank: 1
#I  2-multiplicator rank: 9
#I  # of immediate descendants of order 2^7 is 19
#I  # of capable immediate descendants is 1
#I  **************************************************
#I  Starting group: [grp] #31;2
#I  Order: 2^6
#I  Nuclear rank: 1
#I  2-multiplicator rank: 9
#I  # of immediate descendants of order 2^7 is 21
#I  # of capable immediate descendants is 1
#I  **************************************************
#I  Starting group: [grp] #32;2
#I  Order: 2^6
#I  Nuclear rank: 1
#I  2-multiplicator rank: 9
#I  # of immediate descendants of order 2^7 is 19
#I  # of capable immediate descendants is 1
#I  **************************************************
#I  Starting group: [grp] #33;2
#I  Order: 2^6
#I  Nuclear rank: 1
#I  2-multiplicator rank: 9
#I  # of immediate descendants of order 2^7 is 19
#I  # of capable immediate descendants is 1
#I  **************************************************
#I  Starting group: [grp] #41;2
#I  Order: 2^6
#I  Nuclear rank: 2
#I  2-multiplicator rank: 10
#I  # of immediate descendants of order 2^7 is 30
#I  # of capable immediate descendants is 1
#I  # of immediate descendants of order 2^8 is 570
#I  # of capable immediate descendants is 24
#I  **************************************************
#I  Starting group: [grp] #42;2
#I  Order: 2^6
#I  Nuclear rank: 1
#I  2-multiplicator rank: 9
#I  # of immediate descendants of order 2^7 is 40
#I  # of capable immediate descendants is 1
#I  **************************************************
#I  Starting group: [grp] #43;2
#I  Order: 2^6
#I  Nuclear rank: 1
#I  2-multiplicator rank: 9
#I  # of immediate descendants of order 2^7 is 24
#I  # of capable immediate descendants is 1
#I  **************************************************
#I  Starting group: [grp] #44;2
#I  Order: 2^6
#I  Nuclear rank: 1
#I  2-multiplicator rank: 9
#I  # of immediate descendants of order 2^7 is 20
#I  # of capable immediate descendants is 1
#I  **************************************************
#I  Starting group: [grp] #45;2
#I  Order: 2^6
#I  Nuclear rank: 1
#I  2-multiplicator rank: 9
#I  # of immediate descendants of order 2^7 is 13
#I  # of capable immediate descendants is 1
#I  **************************************************
#I  Starting group: [grp] #46;2
#I  Order: 2^6
#I  Nuclear rank: 1
#I  2-multiplicator rank: 9
#I  # of immediate descendants of order 2^7 is 13
#I  # of capable immediate descendants is 1
#I  **************************************************
#I  Starting group: [grp] #61;3
#I  Order: 2^7
#I  Nuclear rank: 3
#I  2-multiplicator rank: 10
#I  # of immediate descendants of order 2^8 is 7
#I  # of capable immediate descendants is 3
#I  **************************************************
#I  Starting group: [grp] #62;3
#I  Order: 2^7
#I  Nuclear rank: 5
#I  2-multiplicator rank: 12
#I  # of immediate descendants of order 2^8 is 29
#I  # of capable immediate descendants is 3
#I  **************************************************
#I  Starting group: [grp] #63;3
#I  Order: 2^7
#I  Nuclear rank: 3
#I  2-multiplicator rank: 10
#I  # of immediate descendants of order 2^8 is 10
#I  # of capable immediate descendants is 3
#I  **************************************************
#I  Starting group: [grp] #64;3
#I  Order: 2^7
#I  Nuclear rank: 4
#I  2-multiplicator rank: 11
#I  # of immediate descendants of order 2^8 is 52
#I  # of capable immediate descendants is 7
#I  **************************************************
#I  Starting group: [grp] #65;3
#I  Order: 2^7
#I  Nuclear rank: 3
#I  2-multiplicator rank: 10
#I  # of immediate descendants of order 2^8 is 38
#I  # of capable immediate descendants is 7
#I  **************************************************
#I  Starting group: [grp] #66;3
#I  Order: 2^7
#I  Nuclear rank: 2
#I  2-multiplicator rank: 9
#I  # of immediate descendants of order 2^8 is 22
#I  # of capable immediate descendants is 6
#I  **************************************************
#I  Starting group: [grp] #67;3
#I  Order: 2^7
#I  Nuclear rank: 3
#I  2-multiplicator rank: 10
#I  # of immediate descendants of order 2^8 is 32
#I  # of capable immediate descendants is 4
#I  **************************************************
#I  Starting group: [grp] #68;3
#I  Order: 2^7
#I  Nuclear rank: 2
#I  2-multiplicator rank: 9
#I  # of immediate descendants of order 2^8 is 8
#I  # of capable immediate descendants is 2
#I  **************************************************
#I  Starting group: [grp] #69;3
#I  Order: 2^7
#I  Nuclear rank: 2
#I  2-multiplicator rank: 9
#I  # of immediate descendants of order 2^8 is 10
#I  # of capable immediate descendants is 2
#I  **************************************************
#I  Starting group: [grp] #70;3
#I  Order: 2^7
#I  Nuclear rank: 2
#I  2-multiplicator rank: 9
#I  # of immediate descendants of order 2^8 is 22
#I  # of capable immediate descendants is 4
#I  **************************************************
#I  Starting group: [grp] #71;3
#I  Order: 2^7
#I  Nuclear rank: 2
#I  2-multiplicator rank: 9
#I  # of immediate descendants of order 2^8 is 14
#I  # of capable immediate descendants is 2
#I  **************************************************
#I  Starting group: [grp] #72;3
#I  Order: 2^7
#I  Nuclear rank: 2
#I  2-multiplicator rank: 9
#I  # of immediate descendants of order 2^8 is 8
#I  # of capable immediate descendants is 2
#I  **************************************************
#I  Starting group: [grp] #73;3
#I  Order: 2^7
#I  Nuclear rank: 6
#I  2-multiplicator rank: 13
#I  # of immediate descendants of order 2^8 is 47
#I  # of capable immediate descendants is 7
#I  **************************************************
#I  Starting group: [grp] #74;3
#I  Order: 2^7
#I  Nuclear rank: 4
#I  2-multiplicator rank: 11
#I  # of immediate descendants of order 2^8 is 56
#I  # of capable immediate descendants is 6
#I  **************************************************
#I  Starting group: [grp] #75;3
#I  Order: 2^7
#I  Nuclear rank: 4
#I  2-multiplicator rank: 11
#I  # of immediate descendants of order 2^8 is 34
#I  # of capable immediate descendants is 5
#I  **************************************************
#I  Starting group: [grp] #76;3
#I  Order: 2^7
#I  Nuclear rank: 3
#I  2-multiplicator rank: 10
#I  # of immediate descendants of order 2^8 is 36
#I  # of capable immediate descendants is 8
#I  **************************************************
#I  Starting group: [grp] #77;3
#I  Order: 2^7
#I  Nuclear rank: 3
#I  2-multiplicator rank: 10
#I  # of immediate descendants of order 2^8 is 20
#I  # of capable immediate descendants is 4
#I  **************************************************
#I  Starting group: [grp] #78;3
#I  Order: 2^7
#I  Nuclear rank: 3
#I  2-multiplicator rank: 10
#I  # of immediate descendants of order 2^8 is 7
#I  # of capable immediate descendants is 1
#I  **************************************************
#I  Starting group: [grp] #79;3
#I  Order: 2^7
#I  Nuclear rank: 2
#I  2-multiplicator rank: 9
#I  # of immediate descendants of order 2^8 is 12
#I  # of capable immediate descendants is 2
#I  **************************************************
#I  Starting group: [grp] #80;3
#I  Order: 2^7
#I  Nuclear rank: 3
#I  2-multiplicator rank: 10
#I  # of immediate descendants of order 2^8 is 19
#I  # of capable immediate descendants is 5
#I  **************************************************
#I  Starting group: [grp] #81;3
#I  Order: 2^7
#I  Nuclear rank: 2
#I  2-multiplicator rank: 9
#I  # of immediate descendants of order 2^8 is 24
#I  # of capable immediate descendants is 5
#I  **************************************************
#I  Starting group: [grp] #82;3
#I  Order: 2^7
#I  Nuclear rank: 4
#I  2-multiplicator rank: 11
#I  # of immediate descendants of order 2^8 is 61
#I  # of capable immediate descendants is 6
#I  **************************************************
#I  Starting group: [grp] #83;3
#I  Order: 2^7
#I  Nuclear rank: 5
#I  2-multiplicator rank: 12
#I  # of immediate descendants of order 2^8 is 125
#I  # of capable immediate descendants is 6
#I  **************************************************
#I  Starting group: [grp] #84;3
#I  Order: 2^7
#I  Nuclear rank: 2
#I  2-multiplicator rank: 9
#I  # of immediate descendants of order 2^8 is 26
#I  # of capable immediate descendants is 6
#I  **************************************************
#I  Starting group: [grp] #85;3
#I  Order: 2^7
#I  Nuclear rank: 3
#I  2-multiplicator rank: 10
#I  # of immediate descendants of order 2^8 is 57
#I  # of capable immediate descendants is 6
#I  **************************************************
#I  Starting group: [grp] #86;3
#I  Order: 2^7
#I  Nuclear rank: 2
#I  2-multiplicator rank: 9
#I  # of immediate descendants of order 2^8 is 40
#I  # of capable immediate descendants is 5
#I  **************************************************
#I  Starting group: [grp] #87;3
#I  Order: 2^7
#I  Nuclear rank: 3
#I  2-multiplicator rank: 10
#I  # of immediate descendants of order 2^8 is 44
#I  # of capable immediate descendants is 5
#I  **************************************************
#I  Starting group: [grp] #88;3
#I  Order: 2^7
#I  Nuclear rank: 4
#I  2-multiplicator rank: 11
#I  # of immediate descendants of order 2^8 is 79
#I  # of capable immediate descendants is 8
#I  **************************************************
#I  Starting group: [grp] #89;3
#I  Order: 2^7
#I  Nuclear rank: 2
#I  2-multiplicator rank: 9
#I  # of immediate descendants of order 2^8 is 34
#I  # of capable immediate descendants is 4
#I  **************************************************
#I  Starting group: [grp] #90;3
#I  Order: 2^7
#I  Nuclear rank: 3
#I  2-multiplicator rank: 10
#I  # of immediate descendants of order 2^8 is 41
#I  # of capable immediate descendants is 7
#I  **************************************************
#I  Starting group: [grp] #91;3
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 8
#I  # of immediate descendants of order 2^8 is 10
#I  # of capable immediate descendants is 2
#I  **************************************************
#I  Starting group: [grp] #92;3
#I  Order: 2^7
#I  Nuclear rank: 2
#I  2-multiplicator rank: 9
#I  # of immediate descendants of order 2^8 is 24
#I  # of capable immediate descendants is 4
#I  **************************************************
#I  Starting group: [grp] #93;3
#I  Order: 2^7
#I  Nuclear rank: 3
#I  2-multiplicator rank: 10
#I  # of immediate descendants of order 2^8 is 57
#I  # of capable immediate descendants is 7
#I  **************************************************
#I  Starting group: [grp] #94;3
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 8
#I  # of immediate descendants of order 2^8 is 8
#I  # of capable immediate descendants is 2
#I  **************************************************
#I  Starting group: [grp] #95;3
#I  Order: 2^7
#I  Nuclear rank: 4
#I  2-multiplicator rank: 11
#I  # of immediate descendants of order 2^8 is 47
#I  # of capable immediate descendants is 4
#I  **************************************************
#I  Starting group: [grp] #96;3
#I  Order: 2^7
#I  Nuclear rank: 3
#I  2-multiplicator rank: 10
#I  # of immediate descendants of order 2^8 is 75
#I  # of capable immediate descendants is 5
#I  **************************************************
#I  Starting group: [grp] #97;3
#I  Order: 2^7
#I  Nuclear rank: 2
#I  2-multiplicator rank: 9
#I  # of immediate descendants of order 2^8 is 35
#I  # of capable immediate descendants is 5
#I  **************************************************
#I  Starting group: [grp] #98;3
#I  Order: 2^7
#I  Nuclear rank: 2
#I  2-multiplicator rank: 9
#I  # of immediate descendants of order 2^8 is 35
#I  # of capable immediate descendants is 5
#I  **************************************************
#I  Starting group: [grp] #99;3
#I  Order: 2^7
#I  Nuclear rank: 2
#I  2-multiplicator rank: 9
#I  # of immediate descendants of order 2^8 is 34
#I  # of capable immediate descendants is 4
#I  **************************************************
#I  Starting group: [grp] #100;3
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 8
#I  # of immediate descendants of order 2^8 is 8
#I  # of capable immediate descendants is 1
#I  **************************************************
#I  Starting group: [grp] #101;3
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 8
#I  # of immediate descendants of order 2^8 is 8
#I  # of capable immediate descendants is 1
#I  **************************************************
#I  Starting group: [grp] #102;3
#I  Order: 2^7
#I  Nuclear rank: 3
#I  2-multiplicator rank: 10
#I  # of immediate descendants of order 2^8 is 31
#I  # of capable immediate descendants is 5
#I  **************************************************
#I  Starting group: [grp] #103;3
#I  Order: 2^7
#I  Nuclear rank: 2
#I  2-multiplicator rank: 9
#I  # of immediate descendants of order 2^8 is 27
#I  # of capable immediate descendants is 3
#I  **************************************************
#I  Starting group: [grp] #104;3
#I  Order: 2^7
#I  Nuclear rank: 4
#I  2-multiplicator rank: 11
#I  # of immediate descendants of order 2^8 is 48
#I  # of capable immediate descendants is 4
#I  **************************************************
#I  Starting group: [grp] #105;3
#I  Order: 2^7
#I  Nuclear rank: 3
#I  2-multiplicator rank: 10
#I  # of immediate descendants of order 2^8 is 32
#I  # of capable immediate descendants is 7
#I  **************************************************
#I  Starting group: [grp] #106;3
#I  Order: 2^7
#I  Nuclear rank: 3
#I  2-multiplicator rank: 10
#I  # of immediate descendants of order 2^8 is 29
#I  # of capable immediate descendants is 5
#I  **************************************************
#I  Starting group: [grp] #107;3
#I  Order: 2^7
#I  Nuclear rank: 3
#I  2-multiplicator rank: 10
#I  # of immediate descendants of order 2^8 is 55
#I  # of capable immediate descendants is 7
#I  **************************************************
#I  Starting group: [grp] #108;3
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 8
#I  # of immediate descendants of order 2^8 is 10
#I  # of capable immediate descendants is 2
#I  **************************************************
#I  Starting group: [grp] #109;3
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 8
#I  # of immediate descendants of order 2^8 is 10
#I  # of capable immediate descendants is 2
#I  **************************************************
#I  Starting group: [grp] #110;3
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 8
#I  # of immediate descendants of order 2^8 is 8
#I  # of capable immediate descendants is 2
#I  **************************************************
#I  Starting group: [grp] #111;3
#I  Order: 2^7
#I  Nuclear rank: 2
#I  2-multiplicator rank: 9
#I  # of immediate descendants of order 2^8 is 21
#I  # of capable immediate descendants is 3
#I  **************************************************
#I  Starting group: [grp] #112;3
#I  Order: 2^7
#I  Nuclear rank: 2
#I  2-multiplicator rank: 9
#I  # of immediate descendants of order 2^8 is 21
#I  # of capable immediate descendants is 3
#I  **************************************************
#I  Starting group: [grp] #113;3
#I  Order: 2^7
#I  Nuclear rank: 2
#I  2-multiplicator rank: 9
#I  # of immediate descendants of order 2^8 is 24
#I  # of capable immediate descendants is 4
#I  **************************************************
#I  Starting group: [grp] #114;3
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 8
#I  # of immediate descendants of order 2^8 is 12
#I  # of capable immediate descendants is 2
#I  **************************************************
#I  Starting group: [grp] #115;3
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 8
#I  # of immediate descendants of order 2^8 is 10
#I  # of capable immediate descendants is 2
#I  **************************************************
#I  Starting group: [grp] #116;3
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 8
#I  # of immediate descendants of order 2^8 is 10
#I  # of capable immediate descendants is 2
#I  **************************************************
#I  Starting group: [grp] #117;3
#I  Order: 2^7
#I  Nuclear rank: 2
#I  2-multiplicator rank: 9
#I  # of immediate descendants of order 2^8 is 35
#I  # of capable immediate descendants is 4
#I  **************************************************
#I  Starting group: [grp] #118;3
#I  Order: 2^7
#I  Nuclear rank: 2
#I  2-multiplicator rank: 9
#I  # of immediate descendants of order 2^8 is 35
#I  # of capable immediate descendants is 3
#I  **************************************************
#I  Starting group: [grp] #119;3
#I  Order: 2^7
#I  Nuclear rank: 2
#I  2-multiplicator rank: 9
#I  # of immediate descendants of order 2^8 is 35
#I  # of capable immediate descendants is 3
#I  **************************************************
#I  Starting group: [grp] #120;3
#I  Order: 2^7
#I  Nuclear rank: 2
#I  2-multiplicator rank: 9
#I  # of immediate descendants of order 2^8 is 35
#I  # of capable immediate descendants is 4
#I  **************************************************
#I  Starting group: [grp] #121;3
#I  Order: 2^7
#I  Nuclear rank: 2
#I  2-multiplicator rank: 9
#I  # of immediate descendants of order 2^8 is 40
#I  # of capable immediate descendants is 3
#I  **************************************************
#I  Starting group: [grp] #122;3
#I  Order: 2^7
#I  Nuclear rank: 2
#I  2-multiplicator rank: 9
#I  # of immediate descendants of order 2^8 is 30
#I  # of capable immediate descendants is 4
#I  **************************************************
#I  Starting group: [grp] #123;3
#I  Order: 2^7
#I  Nuclear rank: 2
#I  2-multiplicator rank: 9
#I  # of immediate descendants of order 2^8 is 22
#I  # of capable immediate descendants is 3
#I  **************************************************
#I  Starting group: [grp] #124;3
#I  Order: 2^7
#I  Nuclear rank: 3
#I  2-multiplicator rank: 10
#I  # of immediate descendants of order 2^8 is 27
#I  # of capable immediate descendants is 4
#I  **************************************************
#I  Starting group: [grp] #125;3
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 8
#I  # of immediate descendants of order 2^8 is 12
#I  # of capable immediate descendants is 1
#I  **************************************************
#I  Starting group: [grp] #126;3
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 8
#I  # of immediate descendants of order 2^8 is 8
#I  # of capable immediate descendants is 1
#I  **************************************************
#I  Starting group: [grp] #127;3
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 8
#I  # of immediate descendants of order 2^8 is 10
#I  # of capable immediate descendants is 2
#I  **************************************************
#I  Starting group: [grp] #128;3
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 8
#I  # of immediate descendants of order 2^8 is 12
#I  # of capable immediate descendants is 1
#I  **************************************************
#I  Starting group: [grp] #129;3
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 8
#I  # of immediate descendants of order 2^8 is 12
#I  # of capable immediate descendants is 2
#I  **************************************************
#I  Starting group: [grp] #130;3
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 8
#I  # of immediate descendants of order 2^8 is 16
#I  # of capable immediate descendants is 1
#I  **************************************************
#I  Starting group: [grp] #131;3
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 8
#I  # of immediate descendants of order 2^8 is 16
#I  # of capable immediate descendants is 1
#I  **************************************************
#I  Starting group: [grp] #132;3
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 8
#I  # of immediate descendants of order 2^8 is 12
#I  # of capable immediate descendants is 1
#I  **************************************************
#I  Starting group: [grp] #133;3
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 8
#I  # of immediate descendants of order 2^8 is 12
#I  # of capable immediate descendants is 2
#I  **************************************************
#I  Starting group: [grp] #134;3
#I  Order: 2^7
#I  Nuclear rank: 4
#I  2-multiplicator rank: 11
#I  # of immediate descendants of order 2^8 is 72
#I  # of capable immediate descendants is 5
#I  **************************************************
#I  Starting group: [grp] #135;3
#I  Order: 2^7
#I  Nuclear rank: 3
#I  2-multiplicator rank: 10
#I  # of immediate descendants of order 2^8 is 39
#I  # of capable immediate descendants is 3
#I  **************************************************
#I  Starting group: [grp] #136;3
#I  Order: 2^7
#I  Nuclear rank: 3
#I  2-multiplicator rank: 10
#I  # of immediate descendants of order 2^8 is 22
#I  # of capable immediate descendants is 3
#I  **************************************************
#I  Starting group: [grp] #137;3
#I  Order: 2^7
#I  Nuclear rank: 3
#I  2-multiplicator rank: 10
#I  # of immediate descendants of order 2^8 is 22
#I  # of capable immediate descendants is 3
#I  **************************************************
#I  Starting group: [grp] #138;3
#I  Order: 2^7
#I  Nuclear rank: 2
#I  2-multiplicator rank: 9
#I  # of immediate descendants of order 2^8 is 37
#I  # of capable immediate descendants is 4
#I  **************************************************
#I  Starting group: [grp] #139;3
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 8
#I  # of immediate descendants of order 2^8 is 10
#I  # of capable immediate descendants is 2
#I  **************************************************
#I  Starting group: [grp] #140;3
#I  Order: 2^7
#I  Nuclear rank: 2
#I  2-multiplicator rank: 9
#I  # of immediate descendants of order 2^8 is 26
#I  # of capable immediate descendants is 4
#I  **************************************************
#I  Starting group: [grp] #141;3
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 8
#I  # of immediate descendants of order 2^8 is 7
#I  # of capable immediate descendants is 2
#I  **************************************************
#I  Starting group: [grp] #142;3
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 8
#I  # of immediate descendants of order 2^8 is 7
#I  # of capable immediate descendants is 3
#I  **************************************************
#I  Starting group: [grp] #143;3
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 8
#I  # of immediate descendants of order 2^8 is 7
#I  # of capable immediate descendants is 2
#I  **************************************************
#I  Starting group: [grp] #144;3
#I  Order: 2^7
#I  Nuclear rank: 3
#I  2-multiplicator rank: 10
#I  # of immediate descendants of order 2^8 is 50
#I  # of capable immediate descendants is 5
#I  **************************************************
#I  Starting group: [grp] #145;3
#I  Order: 2^7
#I  Nuclear rank: 2
#I  2-multiplicator rank: 9
#I  # of immediate descendants of order 2^8 is 24
#I  # of capable immediate descendants is 3
#I  **************************************************
#I  Starting group: [grp] #146;3
#I  Order: 2^7
#I  Nuclear rank: 2
#I  2-multiplicator rank: 9
#I  # of immediate descendants of order 2^8 is 14
#I  # of capable immediate descendants is 3
#I  **************************************************
#I  Starting group: [grp] #147;3
#I  Order: 2^7
#I  Nuclear rank: 2
#I  2-multiplicator rank: 9
#I  # of immediate descendants of order 2^8 is 14
#I  # of capable immediate descendants is 3
#I  **************************************************
#I  Starting group: [grp] #148;3
#I  Order: 2^7
#I  Nuclear rank: 2
#I  2-multiplicator rank: 9
#I  # of immediate descendants of order 2^8 is 37
#I  # of capable immediate descendants is 4
#I  **************************************************
#I  Starting group: [grp] #149;3
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 8
#I  # of immediate descendants of order 2^8 is 10
#I  # of capable immediate descendants is 2
#I  **************************************************
#I  Starting group: [grp] #150;3
#I  Order: 2^7
#I  Nuclear rank: 2
#I  2-multiplicator rank: 9
#I  # of immediate descendants of order 2^8 is 26
#I  # of capable immediate descendants is 4
#I  **************************************************
#I  Starting group: [grp] #151;3
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 8
#I  # of immediate descendants of order 2^8 is 7
#I  # of capable immediate descendants is 2
#I  **************************************************
#I  Starting group: [grp] #152;3
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 8
#I  # of immediate descendants of order 2^8 is 7
#I  # of capable immediate descendants is 2
#I  **************************************************
#I  Starting group: [grp] #153;3
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 8
#I  # of immediate descendants of order 2^8 is 7
#I  # of capable immediate descendants is 2
#I  **************************************************
#I  Starting group: [grp] #154;3
#I  Order: 2^7
#I  Nuclear rank: 3
#I  2-multiplicator rank: 10
#I  # of immediate descendants of order 2^8 is 58
#I  # of capable immediate descendants is 3
#I  **************************************************
#I  Starting group: [grp] #155;3
#I  Order: 2^7
#I  Nuclear rank: 2
#I  2-multiplicator rank: 9
#I  # of immediate descendants of order 2^8 is 52
#I  # of capable immediate descendants is 3
#I  **************************************************
#I  Starting group: [grp] #156;3
#I  Order: 2^7
#I  Nuclear rank: 2
#I  2-multiplicator rank: 9
#I  # of immediate descendants of order 2^8 is 33
#I  # of capable immediate descendants is 3
#I  **************************************************
#I  Starting group: [grp] #157;3
#I  Order: 2^7
#I  Nuclear rank: 3
#I  2-multiplicator rank: 10
#I  # of immediate descendants of order 2^8 is 65
#I  # of capable immediate descendants is 5
#I  **************************************************
#I  Starting group: [grp] #158;3
#I  Order: 2^7
#I  Nuclear rank: 2
#I  2-multiplicator rank: 9
#I  # of immediate descendants of order 2^8 is 33
#I  # of capable immediate descendants is 3
#I  **************************************************
#I  Starting group: [grp] #159;3
#I  Order: 2^7
#I  Nuclear rank: 2
#I  2-multiplicator rank: 9
#I  # of immediate descendants of order 2^8 is 33
#I  # of capable immediate descendants is 4
#I  **************************************************
#I  Starting group: [grp] #160;3
#I  Order: 2^7
#I  Nuclear rank: 2
#I  2-multiplicator rank: 9
#I  # of immediate descendants of order 2^8 is 33
#I  # of capable immediate descendants is 3
#I  **************************************************
#I  Starting group: [grp] #161;3
#I  Order: 2^7
#I  Nuclear rank: 2
#I  2-multiplicator rank: 9
#I  # of immediate descendants of order 2^8 is 24
#I  # of capable immediate descendants is 3
#I  **************************************************
#I  Starting group: [grp] #162;3
#I  Order: 2^7
#I  Nuclear rank: 3
#I  2-multiplicator rank: 10
#I  # of immediate descendants of order 2^8 is 31
#I  # of capable immediate descendants is 3
#I  **************************************************
#I  Starting group: [grp] #163;3
#I  Order: 2^7
#I  Nuclear rank: 2
#I  2-multiplicator rank: 9
#I  # of immediate descendants of order 2^8 is 33
#I  # of capable immediate descendants is 3
#I  **************************************************
#I  Starting group: [grp] #164;3
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 8
#I  # of immediate descendants of order 2^8 is 10
#I  # of capable immediate descendants is 1
#I  **************************************************
#I  Starting group: [grp] #165;3
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 8
#I  # of immediate descendants of order 2^8 is 6
#I  # of capable immediate descendants is 2
#I  **************************************************
#I  Starting group: [grp] #166;3
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 8
#I  # of immediate descendants of order 2^8 is 10
#I  # of capable immediate descendants is 1
#I  **************************************************
#I  Starting group: [grp] #167;3
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 8
#I  # of immediate descendants of order 2^8 is 6
#I  # of capable immediate descendants is 1
#I  **************************************************
#I  Starting group: [grp] #168;3
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 8
#I  # of immediate descendants of order 2^8 is 9
#I  # of capable immediate descendants is 3
#I  **************************************************
#I  Starting group: [grp] #169;3
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 8
#I  # of immediate descendants of order 2^8 is 16
#I  # of capable immediate descendants is 1
#I  **************************************************
#I  Starting group: [grp] #170;3
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 8
#I  # of immediate descendants of order 2^8 is 12
#I  # of capable immediate descendants is 1
#I  **************************************************
#I  Starting group: [grp] #171;3
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 8
#I  # of immediate descendants of order 2^8 is 8
#I  # of capable immediate descendants is 2
#I  **************************************************
#I  Starting group: [grp] #172;3
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 8
#I  # of immediate descendants of order 2^8 is 12
#I  # of capable immediate descendants is 1
#I  **************************************************
#I  Starting group: [grp] #173;3
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 8
#I  # of immediate descendants of order 2^8 is 10
#I  # of capable immediate descendants is 2
#I  **************************************************
#I  Starting group: [grp] #174;3
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 8
#I  # of immediate descendants of order 2^8 is 10
#I  # of capable immediate descendants is 1
#I  **************************************************
#I  Starting group: [grp] #175;3
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 8
#I  # of immediate descendants of order 2^8 is 9
#I  # of capable immediate descendants is 3
#I  **************************************************
#I  Starting group: [grp] #176;3
#I  Order: 2^7
#I  Nuclear rank: 3
#I  2-multiplicator rank: 10
#I  # of immediate descendants of order 2^8 is 8
#I  # of capable immediate descendants is 1
#I  **************************************************
#I  Starting group: [grp] #177;3
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 8
#I  # of immediate descendants of order 2^8 is 6
#I  # of capable immediate descendants is 2
#I  **************************************************
#I  Starting group: [grp] #178;3
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 8
#I  # of immediate descendants of order 2^8 is 6
#I  # of capable immediate descendants is 1
#I  **************************************************
#I  Starting group: [grp] #179;3
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 8
#I  # of immediate descendants of order 2^8 is 8
#I  # of capable immediate descendants is 1
#I  **************************************************
#I  Starting group: [grp] #180;3
#I  Order: 2^7
#I  Nuclear rank: 5
#I  2-multiplicator rank: 12
#I  # of immediate descendants of order 2^8 is 64
#I  # of capable immediate descendants is 3
#I  **************************************************
#I  Starting group: [grp] #181;3
#I  Order: 2^7
#I  Nuclear rank: 4
#I  2-multiplicator rank: 11
#I  # of immediate descendants of order 2^8 is 28
#I  # of capable immediate descendants is 2
#I  **************************************************
#I  Starting group: [grp] #182;3
#I  Order: 2^7
#I  Nuclear rank: 4
#I  2-multiplicator rank: 11
#I  # of immediate descendants of order 2^8 is 73
#I  # of capable immediate descendants is 5
#I  **************************************************
#I  Starting group: [grp] #183;3
#I  Order: 2^7
#I  Nuclear rank: 3
#I  2-multiplicator rank: 10
#I  # of immediate descendants of order 2^8 is 19
#I  # of capable immediate descendants is 3
#I  **************************************************
#I  Starting group: [grp] #184;3
#I  Order: 2^7
#I  Nuclear rank: 3
#I  2-multiplicator rank: 10
#I  # of immediate descendants of order 2^8 is 32
#I  # of capable immediate descendants is 3
#I  **************************************************
#I  Starting group: [grp] #185;3
#I  Order: 2^7
#I  Nuclear rank: 3
#I  2-multiplicator rank: 10
#I  # of immediate descendants of order 2^8 is 24
#I  # of capable immediate descendants is 2
#I  **************************************************
#I  Starting group: [grp] #186;3
#I  Order: 2^7
#I  Nuclear rank: 3
#I  2-multiplicator rank: 10
#I  # of immediate descendants of order 2^8 is 30
#I  # of capable immediate descendants is 5
#I  **************************************************
#I  Starting group: [grp] #187;3
#I  Order: 2^7
#I  Nuclear rank: 2
#I  2-multiplicator rank: 9
#I  # of immediate descendants of order 2^8 is 23
#I  # of capable immediate descendants is 6
#I  **************************************************
#I  Starting group: [grp] #188;3
#I  Order: 2^7
#I  Nuclear rank: 2
#I  2-multiplicator rank: 9
#I  # of immediate descendants of order 2^8 is 46
#I  # of capable immediate descendants is 5
#I  **************************************************
#I  Starting group: [grp] #189;3
#I  Order: 2^7
#I  Nuclear rank: 3
#I  2-multiplicator rank: 10
#I  # of immediate descendants of order 2^8 is 19
#I  # of capable immediate descendants is 3
#I  **************************************************
#I  Starting group: [grp] #190;3
#I  Order: 2^7
#I  Nuclear rank: 2
#I  2-multiplicator rank: 9
#I  # of immediate descendants of order 2^8 is 13
#I  # of capable immediate descendants is 3
#I  **************************************************
#I  Starting group: [grp] #191;3
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 8
#I  # of immediate descendants of order 2^8 is 20
#I  # of capable immediate descendants is 6
#I  **************************************************
#I  Starting group: [grp] #192;3
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 8
#I  # of immediate descendants of order 2^8 is 20
#I  # of capable immediate descendants is 4
#I  **************************************************
#I  Starting group: [grp] #193;3
#I  Order: 2^7
#I  Nuclear rank: 3
#I  2-multiplicator rank: 10
#I  # of immediate descendants of order 2^8 is 21
#I  # of capable immediate descendants is 3
#I  **************************************************
#I  Starting group: [grp] #194;3
#I  Order: 2^7
#I  Nuclear rank: 2
#I  2-multiplicator rank: 9
#I  # of immediate descendants of order 2^8 is 20
#I  # of capable immediate descendants is 2
#I  **************************************************
#I  Starting group: [grp] #195;3
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 8
#I  # of immediate descendants of order 2^8 is 11
#I  # of capable immediate descendants is 3
#I  **************************************************
#I  Starting group: [grp] #196;3
#I  Order: 2^7
#I  Nuclear rank: 2
#I  2-multiplicator rank: 9
#I  # of immediate descendants of order 2^8 is 2
#I  **************************************************
#I  Starting group: [grp] #199;3
#I  Order: 2^7
#I  Nuclear rank: 5
#I  2-multiplicator rank: 12
#I  # of immediate descendants of order 2^8 is 82
#I  # of capable immediate descendants is 3
#I  **************************************************
#I  Starting group: [grp] #200;3
#I  Order: 2^7
#I  Nuclear rank: 4
#I  2-multiplicator rank: 11
#I  # of immediate descendants of order 2^8 is 72
#I  # of capable immediate descendants is 3
#I  **************************************************
#I  Starting group: [grp] #201;3
#I  Order: 2^7
#I  Nuclear rank: 3
#I  2-multiplicator rank: 10
#I  # of immediate descendants of order 2^8 is 58
#I  # of capable immediate descendants is 6
#I  **************************************************
#I  Starting group: [grp] #202;3
#I  Order: 2^7
#I  Nuclear rank: 3
#I  2-multiplicator rank: 10
#I  # of immediate descendants of order 2^8 is 56
#I  # of capable immediate descendants is 5
#I  **************************************************
#I  Starting group: [grp] #203;3
#I  Order: 2^7
#I  Nuclear rank: 3
#I  2-multiplicator rank: 10
#I  # of immediate descendants of order 2^8 is 92
#I  # of capable immediate descendants is 7
#I  **************************************************
#I  Starting group: [grp] #204;3
#I  Order: 2^7
#I  Nuclear rank: 4
#I  2-multiplicator rank: 11
#I  # of immediate descendants of order 2^8 is 90
#I  # of capable immediate descendants is 5
#I  **************************************************
#I  Starting group: [grp] #205;3
#I  Order: 2^7
#I  Nuclear rank: 3
#I  2-multiplicator rank: 10
#I  # of immediate descendants of order 2^8 is 56
#I  # of capable immediate descendants is 5
#I  **************************************************
#I  Starting group: [grp] #206;3
#I  Order: 2^7
#I  Nuclear rank: 4
#I  2-multiplicator rank: 11
#I  # of immediate descendants of order 2^8 is 122
#I  # of capable immediate descendants is 4
#I  **************************************************
#I  Starting group: [grp] #207;3
#I  Order: 2^7
#I  Nuclear rank: 2
#I  2-multiplicator rank: 9
#I  # of immediate descendants of order 2^8 is 50
#I  # of capable immediate descendants is 3
#I  **************************************************
#I  Starting group: [grp] #208;3
#I  Order: 2^7
#I  Nuclear rank: 2
#I  2-multiplicator rank: 9
#I  # of immediate descendants of order 2^8 is 50
#I  # of capable immediate descendants is 4
#I  **************************************************
#I  Starting group: [grp] #209;3
#I  Order: 2^7
#I  Nuclear rank: 2
#I  2-multiplicator rank: 9
#I  # of immediate descendants of order 2^8 is 50
#I  # of capable immediate descendants is 3
#I  **************************************************
#I  Starting group: [grp] #210;3
#I  Order: 2^7
#I  Nuclear rank: 2
#I  2-multiplicator rank: 9
#I  # of immediate descendants of order 2^8 is 50
#I  # of capable immediate descendants is 3
#I  **************************************************
#I  Starting group: [grp] #211;3
#I  Order: 2^7
#I  Nuclear rank: 2
#I  2-multiplicator rank: 9
#I  # of immediate descendants of order 2^8 is 50
#I  # of capable immediate descendants is 3
#I  **************************************************
#I  Starting group: [grp] #212;3
#I  Order: 2^7
#I  Nuclear rank: 3
#I  2-multiplicator rank: 10
#I  # of immediate descendants of order 2^8 is 85
#I  # of capable immediate descendants is 3
#I  **************************************************
#I  Starting group: [grp] #213;3
#I  Order: 2^7
#I  Nuclear rank: 2
#I  2-multiplicator rank: 9
#I  # of immediate descendants of order 2^8 is 50
#I  # of capable immediate descendants is 4
#I  **************************************************
#I  Starting group: [grp] #214;3
#I  Order: 2^7
#I  Nuclear rank: 2
#I  2-multiplicator rank: 9
#I  # of immediate descendants of order 2^8 is 72
#I  # of capable immediate descendants is 6
#I  **************************************************
#I  Starting group: [grp] #215;3
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 8
#I  # of immediate descendants of order 2^8 is 32
#I  # of capable immediate descendants is 2
#I  **************************************************
#I  Starting group: [grp] #216;3
#I  Order: 2^7
#I  Nuclear rank: 2
#I  2-multiplicator rank: 9
#I  # of immediate descendants of order 2^8 is 25
#I  # of capable immediate descendants is 2
#I  **************************************************
#I  Starting group: [grp] #217;3
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 8
#I  # of immediate descendants of order 2^8 is 20
#I  # of capable immediate descendants is 2
#I  **************************************************
#I  Starting group: [grp] #218;3
#I  Order: 2^7
#I  Nuclear rank: 2
#I  2-multiplicator rank: 9
#I  # of immediate descendants of order 2^8 is 46
#I  # of capable immediate descendants is 4
#I  **************************************************
#I  Starting group: [grp] #219;3
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 8
#I  # of immediate descendants of order 2^8 is 20
#I  # of capable immediate descendants is 2
#I  **************************************************
#I  Starting group: [grp] #220;3
#I  Order: 2^7
#I  Nuclear rank: 3
#I  2-multiplicator rank: 10
#I  # of immediate descendants of order 2^8 is 124
#I  # of capable immediate descendants is 4
#I  **************************************************
#I  Starting group: [grp] #221;3
#I  Order: 2^7
#I  Nuclear rank: 2
#I  2-multiplicator rank: 9
#I  # of immediate descendants of order 2^8 is 72
#I  # of capable immediate descendants is 2
#I  **************************************************
#I  Starting group: [grp] #222;3
#I  Order: 2^7
#I  Nuclear rank: 2
#I  2-multiplicator rank: 9
#I  # of immediate descendants of order 2^8 is 46
#I  # of capable immediate descendants is 2
#I  **************************************************
#I  Starting group: [grp] #223;3
#I  Order: 2^7
#I  Nuclear rank: 2
#I  2-multiplicator rank: 9
#I  # of immediate descendants of order 2^8 is 46
#I  # of capable immediate descendants is 4
#I  **************************************************
#I  Starting group: [grp] #224;3
#I  Order: 2^7
#I  Nuclear rank: 3
#I  2-multiplicator rank: 10
#I  # of immediate descendants of order 2^8 is 85
#I  # of capable immediate descendants is 3
#I  **************************************************
#I  Starting group: [grp] #225;3
#I  Order: 2^7
#I  Nuclear rank: 2
#I  2-multiplicator rank: 9
#I  # of immediate descendants of order 2^8 is 46
#I  # of capable immediate descendants is 2
#I  **************************************************
#I  Starting group: [grp] #226;3
#I  Order: 2^7
#I  Nuclear rank: 3
#I  2-multiplicator rank: 10
#I  # of immediate descendants of order 2^8 is 72
#I  # of capable immediate descendants is 3
#I  **************************************************
#I  Starting group: [grp] #227;3
#I  Order: 2^7
#I  Nuclear rank: 3
#I  2-multiplicator rank: 10
#I  # of immediate descendants of order 2^8 is 78
#I  # of capable immediate descendants is 4
#I  **************************************************
#I  Starting group: [grp] #228;3
#I  Order: 2^7
#I  Nuclear rank: 3
#I  2-multiplicator rank: 10
#I  # of immediate descendants of order 2^8 is 72
#I  # of capable immediate descendants is 4
#I  **************************************************
#I  Starting group: [grp] #229;3
#I  Order: 2^7
#I  Nuclear rank: 4
#I  2-multiplicator rank: 11
#I  # of immediate descendants of order 2^8 is 94
#I  # of capable immediate descendants is 4
#I  **************************************************
#I  Starting group: [grp] #230;3
#I  Order: 2^7
#I  Nuclear rank: 3
#I  2-multiplicator rank: 10
#I  # of immediate descendants of order 2^8 is 44
#I  # of capable immediate descendants is 3
#I  **************************************************
#I  Starting group: [grp] #231;3
#I  Order: 2^7
#I  Nuclear rank: 3
#I  2-multiplicator rank: 10
#I  # of immediate descendants of order 2^8 is 47
#I  # of capable immediate descendants is 5
#I  **************************************************
#I  Starting group: [grp] #232;3
#I  Order: 2^7
#I  Nuclear rank: 3
#I  2-multiplicator rank: 10
#I  # of immediate descendants of order 2^8 is 48
#I  # of capable immediate descendants is 3
#I  **************************************************
#I  Starting group: [grp] #233;3
#I  Order: 2^7
#I  Nuclear rank: 2
#I  2-multiplicator rank: 9
#I  # of immediate descendants of order 2^8 is 38
#I  # of capable immediate descendants is 2
#I  **************************************************
#I  Starting group: [grp] #234;3
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 8
#I  # of immediate descendants of order 2^8 is 32
#I  # of capable immediate descendants is 2
#I  **************************************************
#I  Starting group: [grp] #235;3
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 8
#I  # of immediate descendants of order 2^8 is 20
#I  # of capable immediate descendants is 2
#I  **************************************************
#I  Starting group: [grp] #236;3
#I  Order: 2^7
#I  Nuclear rank: 2
#I  2-multiplicator rank: 9
#I  # of immediate descendants of order 2^8 is 46
#I  # of capable immediate descendants is 3
#I  **************************************************
#I  Starting group: [grp] #237;3
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 8
#I  # of immediate descendants of order 2^8 is 20
#I  # of capable immediate descendants is 2
#I  **************************************************
#I  Starting group: [grp] #238;3
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 8
#I  # of immediate descendants of order 2^8 is 20
#I  # of capable immediate descendants is 4
#I  **************************************************
#I  Starting group: [grp] #239;3
#I  Order: 2^7
#I  Nuclear rank: 2
#I  2-multiplicator rank: 9
#I  # of immediate descendants of order 2^8 is 72
#I  # of capable immediate descendants is 4
#I  **************************************************
#I  Starting group: [grp] #240;3
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 8
#I  # of immediate descendants of order 2^8 is 32
#I  # of capable immediate descendants is 2
#I  **************************************************
#I  Starting group: [grp] #241;3
#I  Order: 2^7
#I  Nuclear rank: 2
#I  2-multiplicator rank: 9
#I  # of immediate descendants of order 2^8 is 46
#I  # of capable immediate descendants is 3
#I  **************************************************
#I  Starting group: [grp] #242;3
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 8
#I  # of immediate descendants of order 2^8 is 20
#I  # of capable immediate descendants is 2
#I  **************************************************
#I  Starting group: [grp] #243;3
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 8
#I  # of immediate descendants of order 2^8 is 20
#I  # of capable immediate descendants is 4
#I  **************************************************
#I  Starting group: [grp] #244;3
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 8
#I  # of immediate descendants of order 2^8 is 20
#I  # of capable immediate descendants is 2
#I  **************************************************
#I  Starting group: [grp] #245;3
#I  Order: 2^7
#I  Nuclear rank: 2
#I  2-multiplicator rank: 9
#I  # of immediate descendants of order 2^8 is 72
#I  # of capable immediate descendants is 4
#I  **************************************************
#I  Starting group: [grp] #246;3
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 8
#I  # of immediate descendants of order 2^8 is 32
#I  # of capable immediate descendants is 2
#I  **************************************************
#I  Starting group: [grp] #247;3
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 8
#I  # of immediate descendants of order 2^8 is 20
#I  # of capable immediate descendants is 2
#I  **************************************************
#I  Starting group: [grp] #248;3
#I  Order: 2^7
#I  Nuclear rank: 2
#I  2-multiplicator rank: 9
#I  # of immediate descendants of order 2^8 is 46
#I  # of capable immediate descendants is 3
#I  **************************************************
#I  Starting group: [grp] #249;3
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 8
#I  # of immediate descendants of order 2^8 is 20
#I  # of capable immediate descendants is 2
#I  **************************************************
#I  Starting group: [grp] #250;3
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 8
#I  # of immediate descendants of order 2^8 is 20
#I  # of capable immediate descendants is 4
#I  **************************************************
#I  Starting group: [grp] #251;3
#I  Order: 2^7
#I  Nuclear rank: 2
#I  2-multiplicator rank: 9
#I  # of immediate descendants of order 2^8 is 38
#I  # of capable immediate descendants is 2
#I  **************************************************
#I  Starting group: [grp] #252;3
#I  Order: 2^7
#I  Nuclear rank: 2
#I  2-multiplicator rank: 9
#I  # of immediate descendants of order 2^8 is 72
#I  # of capable immediate descendants is 4
#I  **************************************************
#I  Starting group: [grp] #253;3
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 8
#I  # of immediate descendants of order 2^8 is 32
#I  # of capable immediate descendants is 4
#I  **************************************************
#I  Starting group: [grp] #254;3
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 8
#I  # of immediate descendants of order 2^8 is 32
#I  # of capable immediate descendants is 2
#I  **************************************************
#I  Starting group: [grp] #255;3
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 8
#I  # of immediate descendants of order 2^8 is 32
#I  # of capable immediate descendants is 2
#I  **************************************************
#I  Starting group: [grp] #256;3
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 8
#I  # of immediate descendants of order 2^8 is 32
#I  # of capable immediate descendants is 2
#I  **************************************************
#I  Starting group: [grp] #257;3
#I  Order: 2^7
#I  Nuclear rank: 2
#I  2-multiplicator rank: 9
#I  # of immediate descendants of order 2^8 is 72
#I  # of capable immediate descendants is 3
#I  **************************************************
#I  Starting group: [grp] #258;3
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 8
#I  # of immediate descendants of order 2^8 is 32
#I  # of capable immediate descendants is 2
#I  **************************************************
#I  Starting group: [grp] #259;3
#I  Order: 2^7
#I  Nuclear rank: 2
#I  2-multiplicator rank: 9
#I  # of immediate descendants of order 2^8 is 38
#I  # of capable immediate descendants is 2
#I  **************************************************
#I  Starting group: [grp] #260;3
#I  Order: 2^7
#I  Nuclear rank: 2
#I  2-multiplicator rank: 9
#I  # of immediate descendants of order 2^8 is 72
#I  # of capable immediate descendants is 4
#I  **************************************************
#I  Starting group: [grp] #261;3
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 8
#I  # of immediate descendants of order 2^8 is 32
#I  # of capable immediate descendants is 2
#I  **************************************************
#I  Starting group: [grp] #262;3
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 8
#I  # of immediate descendants of order 2^8 is 32
#I  # of capable immediate descendants is 2
#I  **************************************************
#I  Starting group: [grp] #263;3
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 8
#I  # of immediate descendants of order 2^8 is 32
#I  # of capable immediate descendants is 2
#I  **************************************************
#I  Starting group: [grp] #264;3
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 8
#I  # of immediate descendants of order 2^8 is 32
#I  # of capable immediate descendants is 4
#I  **************************************************
#I  Starting group: [grp] #265;3
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 8
#I  # of immediate descendants of order 2^8 is 32
#I  # of capable immediate descendants is 2
#I  **************************************************
#I  Starting group: [grp] #266;3
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 8
#I  # of immediate descendants of order 2^8 is 32
#I  # of capable immediate descendants is 2
#I  **************************************************
#I  Starting group: [grp] #267;3
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 8
#I  # of immediate descendants of order 2^8 is 32
#I  # of capable immediate descendants is 2
#I  **************************************************
#I  Starting group: [grp] #268;3
#I  Order: 2^7
#I  Nuclear rank: 2
#I  2-multiplicator rank: 9
#I  # of immediate descendants of order 2^8 is 72
#I  # of capable immediate descendants is 3
#I  **************************************************
#I  Starting group: [grp] #269;3
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 8
#I  # of immediate descendants of order 2^8 is 32
#I  # of capable immediate descendants is 2
#I  **************************************************
#I  Starting group: [grp] #270;3
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 8
#I  # of immediate descendants of order 2^8 is 32
#I  # of capable immediate descendants is 2
#I  **************************************************
#I  Starting group: [grp] #271;3
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 8
#I  # of immediate descendants of order 2^8 is 32
#I  # of capable immediate descendants is 2
#I  **************************************************
#I  Starting group: [grp] #272;3
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 8
#I  # of immediate descendants of order 2^8 is 32
#I  # of capable immediate descendants is 2
#I  **************************************************
#I  Starting group: [grp] #273;3
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 8
#I  # of immediate descendants of order 2^8 is 32
#I  # of capable immediate descendants is 2
#I  **************************************************
#I  Starting group: [grp] #274;3
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 8
#I  # of immediate descendants of order 2^8 is 32
#I  # of capable immediate descendants is 2
#I  **************************************************
#I  Starting group: [grp] #275;3
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 8
#I  # of immediate descendants of order 2^8 is 32
#I  # of capable immediate descendants is 2
#I  **************************************************
#I  Starting group: [grp] #276;3
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 8
#I  # of immediate descendants of order 2^8 is 32
#I  # of capable immediate descendants is 4
#I  **************************************************
#I  Starting group: [grp] #277;3
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 8
#I  # of immediate descendants of order 2^8 is 32
#I  # of capable immediate descendants is 2
#I  **************************************************
#I  Starting group: [grp] #278;3
#I  Order: 2^7
#I  Nuclear rank: 2
#I  2-multiplicator rank: 9
#I  # of immediate descendants of order 2^8 is 18
#I  # of capable immediate descendants is 2
#I  **************************************************
#I  Starting group: [grp] #279;3
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 8
#I  # of immediate descendants of order 2^8 is 10
#I  # of capable immediate descendants is 3
#I  **************************************************
#I  Starting group: [grp] #280;3
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 8
#I  # of immediate descendants of order 2^8 is 14
#I  # of capable immediate descendants is 4
#I  **************************************************
#I  Starting group: [grp] #281;3
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 8
#I  # of immediate descendants of order 2^8 is 20
#I  # of capable immediate descendants is 4
#I  **************************************************
#I  Starting group: [grp] #282;3
#I  Order: 2^7
#I  Nuclear rank: 2
#I  2-multiplicator rank: 9
#I  # of immediate descendants of order 2^8 is 33
#I  # of capable immediate descendants is 4
#I  **************************************************
#I  Starting group: [grp] #283;3
#I  Order: 2^7
#I  Nuclear rank: 2
#I  2-multiplicator rank: 9
#I  # of immediate descendants of order 2^8 is 18
#I  # of capable immediate descendants is 2
#I  **************************************************
#I  Starting group: [grp] #284;3
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 8
#I  # of immediate descendants of order 2^8 is 32
#I  # of capable immediate descendants is 1
#I  **************************************************
#I  Starting group: [grp] #285;3
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 8
#I  # of immediate descendants of order 2^8 is 20
#I  # of capable immediate descendants is 2
#I  **************************************************
#I  Starting group: [grp] #286;3
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 8
#I  # of immediate descendants of order 2^8 is 20
#I  # of capable immediate descendants is 2
#I  **************************************************
#I  Starting group: [grp] #287;3
#I  Order: 2^7
#I  Nuclear rank: 2
#I  2-multiplicator rank: 9
#I  # of immediate descendants of order 2^8 is 46
#I  # of capable immediate descendants is 2
#I  **************************************************
#I  Starting group: [grp] #288;3
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 8
#I  # of immediate descendants of order 2^8 is 20
#I  # of capable immediate descendants is 2
#I  **************************************************
#I  Starting group: [grp] #291;3
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 8
#I  # of immediate descendants of order 2^8 is 2
#I  **************************************************
#I  Starting group: [grp] #292;3
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 8
#I  # of immediate descendants of order 2^8 is 20
#I  # of capable immediate descendants is 2
#I  **************************************************
#I  Starting group: [grp] #294;3
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 8
#I  # of immediate descendants of order 2^8 is 20
#I  # of capable immediate descendants is 2
#I  **************************************************
#I  Starting group: [grp] #295;3
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 8
#I  # of immediate descendants of order 2^8 is 14
#I  # of capable immediate descendants is 2
#I  **************************************************
#I  Starting group: [grp] #296;3
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 8
#I  # of immediate descendants of order 2^8 is 16
#I  # of capable immediate descendants is 2
#I  **************************************************
#I  Starting group: [grp] #297;3
#I  Order: 2^7
#I  Nuclear rank: 2
#I  2-multiplicator rank: 9
#I  # of immediate descendants of order 2^8 is 43
#I  # of capable immediate descendants is 4
#I  **************************************************
#I  Starting group: [grp] #298;3
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 8
#I  # of immediate descendants of order 2^8 is 12
#I  # of capable immediate descendants is 2
#I  **************************************************
#I  Starting group: [grp] #299;3
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 8
#I  # of immediate descendants of order 2^8 is 12
#I  # of capable immediate descendants is 2
#I  **************************************************
#I  Starting group: [grp] #300;3
#I  Order: 2^7
#I  Nuclear rank: 2
#I  2-multiplicator rank: 9
#I  # of immediate descendants of order 2^8 is 18
#I  # of capable immediate descendants is 1
#I  **************************************************
#I  Starting group: [grp] #302;3
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 8
#I  # of immediate descendants of order 2^8 is 20
#I  # of capable immediate descendants is 1
#I  **************************************************
#I  Starting group: [grp] #308;3
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 8
#I  # of immediate descendants of order 2^8 is 20
#I  # of capable immediate descendants is 1
#I  **************************************************
#I  Starting group: [grp] #315;3
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 8
#I  # of immediate descendants of order 2^8 is 32
#I  # of capable immediate descendants is 1
#I  **************************************************
#I  Starting group: [grp] #317;3
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 8
#I  # of immediate descendants of order 2^8 is 32
#I  # of capable immediate descendants is 2
#I  **************************************************
#I  Starting group: [grp] #330;3
#I  Order: 2^7
#I  Nuclear rank: 2
#I  2-multiplicator rank: 9
#I  # of immediate descendants of order 2^8 is 46
#I  # of capable immediate descendants is 4
#I  **************************************************
#I  Starting group: [grp] #331;3
#I  Order: 2^7
#I  Nuclear rank: 3
#I  2-multiplicator rank: 10
#I  # of immediate descendants of order 2^8 is 45
#I  # of capable immediate descendants is 4
#I  **************************************************
#I  Starting group: [grp] #332;3
#I  Order: 2^7
#I  Nuclear rank: 2
#I  2-multiplicator rank: 9
#I  # of immediate descendants of order 2^8 is 38
#I  # of capable immediate descendants is 4
#I  **************************************************
#I  Starting group: [grp] #333;3
#I  Order: 2^7
#I  Nuclear rank: 3
#I  2-multiplicator rank: 10
#I  # of immediate descendants of order 2^8 is 40
#I  # of capable immediate descendants is 4
#I  **************************************************
#I  Starting group: [grp] #334;3
#I  Order: 2^7
#I  Nuclear rank: 2
#I  2-multiplicator rank: 9
#I  # of immediate descendants of order 2^8 is 38
#I  # of capable immediate descendants is 4
#I  **************************************************
#I  Starting group: [grp] #335;3
#I  Order: 2^7
#I  Nuclear rank: 2
#I  2-multiplicator rank: 9
#I  # of immediate descendants of order 2^8 is 68
#I  # of capable immediate descendants is 4
#I  **************************************************
#I  Starting group: [grp] #336;3
#I  Order: 2^7
#I  Nuclear rank: 2
#I  2-multiplicator rank: 9
#I  # of immediate descendants of order 2^8 is 68
#I  # of capable immediate descendants is 4
#I  **************************************************
#I  Starting group: [grp] #337;3
#I  Order: 2^7
#I  Nuclear rank: 3
#I  2-multiplicator rank: 10
#I  # of immediate descendants of order 2^8 is 71
#I  # of capable immediate descendants is 3
#I  **************************************************
#I  Starting group: [grp] #338;3
#I  Order: 2^7
#I  Nuclear rank: 2
#I  2-multiplicator rank: 9
#I  # of immediate descendants of order 2^8 is 43
#I  # of capable immediate descendants is 4
#I  **************************************************
#I  Starting group: [grp] #339;3
#I  Order: 2^7
#I  Nuclear rank: 2
#I  2-multiplicator rank: 9
#I  # of immediate descendants of order 2^8 is 46
#I  # of capable immediate descendants is 2
#I  **************************************************
#I  Starting group: [grp] #340;3
#I  Order: 2^7
#I  Nuclear rank: 2
#I  2-multiplicator rank: 9
#I  # of immediate descendants of order 2^8 is 40
#I  # of capable immediate descendants is 3
#I  **************************************************
#I  Starting group: [grp] #341;3
#I  Order: 2^7
#I  Nuclear rank: 2
#I  2-multiplicator rank: 9
#I  # of immediate descendants of order 2^8 is 38
#I  # of capable immediate descendants is 2
#I  **************************************************
#I  Starting group: [grp] #342;3
#I  Order: 2^7
#I  Nuclear rank: 2
#I  2-multiplicator rank: 9
#I  # of immediate descendants of order 2^8 is 29
#I  # of capable immediate descendants is 2
#I  **************************************************
#I  Starting group: [grp] #343;3
#I  Order: 2^7
#I  Nuclear rank: 2
#I  2-multiplicator rank: 9
#I  # of immediate descendants of order 2^8 is 32
#I  # of capable immediate descendants is 3
#I  **************************************************
#I  Starting group: [grp] #344;3
#I  Order: 2^7
#I  Nuclear rank: 2
#I  2-multiplicator rank: 9
#I  # of immediate descendants of order 2^8 is 33
#I  # of capable immediate descendants is 2
#I  **************************************************
#I  Starting group: [grp] #345;3
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 8
#I  # of immediate descendants of order 2^8 is 20
#I  # of capable immediate descendants is 1
#I  **************************************************
#I  Starting group: [grp] #346;3
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 8
#I  # of immediate descendants of order 2^8 is 20
#I  # of capable immediate descendants is 2
#I  **************************************************
#I  Starting group: [grp] #347;3
#I  Order: 2^7
#I  Nuclear rank: 2
#I  2-multiplicator rank: 9
#I  # of immediate descendants of order 2^8 is 18
#I  # of capable immediate descendants is 1
#I  **************************************************
#I  Starting group: [grp] #348;3
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 8
#I  # of immediate descendants of order 2^8 is 14
#I  # of capable immediate descendants is 2
#I  **************************************************
#I  Starting group: [grp] #349;3
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 8
#I  # of immediate descendants of order 2^8 is 32
#I  # of capable immediate descendants is 2
#I  **************************************************
#I  Starting group: [grp] #350;3
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 8
#I  # of immediate descendants of order 2^8 is 32
#I  # of capable immediate descendants is 1
#I  **************************************************
#I  Starting group: [grp] #351;3
#I  Order: 2^7
#I  Nuclear rank: 2
#I  2-multiplicator rank: 9
#I  # of immediate descendants of order 2^8 is 38
#I  # of capable immediate descendants is 1
#I  **************************************************
#I  Starting group: [grp] #352;3
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 8
#I  # of immediate descendants of order 2^8 is 32
#I  # of capable immediate descendants is 1
#I  **************************************************
#I  Starting group: [grp] #353;3
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 8
#I  # of immediate descendants of order 2^8 is 32
#I  # of capable immediate descendants is 2
#I  **************************************************
#I  Starting group: [grp] #354;3
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 8
#I  # of immediate descendants of order 2^8 is 32
#I  # of capable immediate descendants is 1
#I  **************************************************
#I  Starting group: [grp] #355;3
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 8
#I  # of immediate descendants of order 2^8 is 32
#I  # of capable immediate descendants is 2
#I  **************************************************
#I  Starting group: [grp] #356;3
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 8
#I  # of immediate descendants of order 2^8 is 32
#I  # of capable immediate descendants is 1
#I  **************************************************
#I  Starting group: [grp] #357;3
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 8
#I  # of immediate descendants of order 2^8 is 18
#I  # of capable immediate descendants is 2
#I  **************************************************
#I  Starting group: [grp] #358;3
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 8
#I  # of immediate descendants of order 2^8 is 18
#I  # of capable immediate descendants is 2
#I  **************************************************
#I  Starting group: [grp] #359;3
#I  Order: 2^7
#I  Nuclear rank: 2
#I  2-multiplicator rank: 9
#I  # of immediate descendants of order 2^8 is 17
#I  # of capable immediate descendants is 1
#I  **************************************************
#I  Starting group: [grp] #360;3
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 8
#I  # of immediate descendants of order 2^8 is 20
#I  # of capable immediate descendants is 2
#I  **************************************************
#I  Starting group: [grp] #361;3
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 8
#I  # of immediate descendants of order 2^8 is 14
#I  # of capable immediate descendants is 2
#I  **************************************************
#I  Starting group: [grp] #362;3
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 8
#I  # of immediate descendants of order 2^8 is 16
#I  # of capable immediate descendants is 2
#I  **************************************************
#I  Starting group: [grp] #363;3
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 8
#I  # of immediate descendants of order 2^8 is 12
#I  # of capable immediate descendants is 2
#I  **************************************************
#I  Starting group: [grp] #364;3
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 8
#I  # of immediate descendants of order 2^8 is 12
#I  # of capable immediate descendants is 2
#I  **************************************************
#I  Starting group: [grp] #367;3
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 8
#I  # of immediate descendants of order 2^8 is 2
#I  **************************************************
#I  Starting group: [grp] #368;3
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 8
#I  # of immediate descendants of order 2^8 is 2
#I  **************************************************
#I  Starting group: [grp] #375;3
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 8
#I  # of immediate descendants of order 2^8 is 20
#I  # of capable immediate descendants is 4
#I  **************************************************
#I  Starting group: [grp] #376;3
#I  Order: 2^7
#I  Nuclear rank: 2
#I  2-multiplicator rank: 9
#I  # of immediate descendants of order 2^8 is 18
#I  # of capable immediate descendants is 2
#I  **************************************************
#I  Starting group: [grp] #377;3
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 8
#I  # of immediate descendants of order 2^8 is 14
#I  # of capable immediate descendants is 4
#I  **************************************************
#I  Starting group: [grp] #378;3
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 8
#I  # of immediate descendants of order 2^8 is 10
#I  # of capable immediate descendants is 3
#I  **************************************************
#I  Starting group: [grp] #379;3
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 8
#I  # of immediate descendants of order 2^8 is 16
#I  # of capable immediate descendants is 2
#I  **************************************************
#I  Starting group: [grp] #380;3
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 8
#I  # of immediate descendants of order 2^8 is 16
#I  # of capable immediate descendants is 2
#I  **************************************************
#I  Starting group: [grp] #387;3
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 8
#I  # of immediate descendants of order 2^8 is 18
#I  # of capable immediate descendants is 2
#I  **************************************************
#I  Starting group: [grp] #388;3
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 8
#I  # of immediate descendants of order 2^8 is 18
#I  # of capable immediate descendants is 2
#I  **************************************************
#I  Starting group: [grp] #394;3
#I  Order: 2^7
#I  Nuclear rank: 2
#I  2-multiplicator rank: 9
#I  # of immediate descendants of order 2^8 is 24
#I  # of capable immediate descendants is 2
#I  **************************************************
#I  Starting group: [grp] #395;3
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 8
#I  # of immediate descendants of order 2^8 is 20
#I  # of capable immediate descendants is 4
#I  **************************************************
#I  Starting group: [grp] #396;3
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 8
#I  # of immediate descendants of order 2^8 is 20
#I  # of capable immediate descendants is 3
#I  **************************************************
#I  Starting group: [grp] #397;3
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 8
#I  # of immediate descendants of order 2^8 is 32
#I  # of capable immediate descendants is 2
#I  **************************************************
#I  Starting group: [grp] #398;3
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 8
#I  # of immediate descendants of order 2^8 is 32
#I  # of capable immediate descendants is 2
#I  **************************************************
#I  Starting group: [grp] #399;3
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 8
#I  # of immediate descendants of order 2^8 is 20
#I  # of capable immediate descendants is 3
#I  **************************************************
#I  Starting group: [grp] #400;3
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 8
#I  # of immediate descendants of order 2^8 is 20
#I  # of capable immediate descendants is 2
#I  **************************************************
#I  Starting group: [grp] #405;3
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 8
#I  # of immediate descendants of order 2^8 is 20
#I  # of capable immediate descendants is 3
#I  **************************************************
#I  Starting group: [grp] #406;3
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 8
#I  # of immediate descendants of order 2^8 is 20
#I  # of capable immediate descendants is 2
#I  **************************************************
#I  Starting group: [grp] #407;3
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 8
#I  # of immediate descendants of order 2^8 is 20
#I  # of capable immediate descendants is 2
#I  **************************************************
#I  Starting group: [grp] #409;3
#I  Order: 2^7
#I  Nuclear rank: 3
#I  2-multiplicator rank: 10
#I  # of immediate descendants of order 2^8 is 46
#I  # of capable immediate descendants is 5
#I  **************************************************
#I  Starting group: [grp] #410;3
#I  Order: 2^7
#I  Nuclear rank: 3
#I  2-multiplicator rank: 10
#I  # of immediate descendants of order 2^8 is 22
#I  # of capable immediate descendants is 2
#I  **************************************************
#I  Starting group: [grp] #411;3
#I  Order: 2^7
#I  Nuclear rank: 3
#I  2-multiplicator rank: 10
#I  # of immediate descendants of order 2^8 is 27
#I  # of capable immediate descendants is 2
#I  **************************************************
#I  Starting group: [grp] #412;3
#I  Order: 2^7
#I  Nuclear rank: 3
#I  2-multiplicator rank: 10
#I  # of immediate descendants of order 2^8 is 25
#I  # of capable immediate descendants is 2
#I  **************************************************
#I  Starting group: [grp] #413;3
#I  Order: 2^7
#I  Nuclear rank: 2
#I  2-multiplicator rank: 9
#I  # of immediate descendants of order 2^8 is 42
#I  # of capable immediate descendants is 3
#I  **************************************************
#I  Starting group: [grp] #414;3
#I  Order: 2^7
#I  Nuclear rank: 2
#I  2-multiplicator rank: 9
#I  # of immediate descendants of order 2^8 is 40
#I  # of capable immediate descendants is 2
#I  **************************************************
#I  Starting group: [grp] #415;3
#I  Order: 2^7
#I  Nuclear rank: 2
#I  2-multiplicator rank: 9
#I  # of immediate descendants of order 2^8 is 30
#I  # of capable immediate descendants is 2
#I  **************************************************
#I  Starting group: [grp] #416;3
#I  Order: 2^7
#I  Nuclear rank: 2
#I  2-multiplicator rank: 9
#I  # of immediate descendants of order 2^8 is 40
#I  # of capable immediate descendants is 2
#I  **************************************************
#I  Starting group: [grp] #417;3
#I  Order: 2^7
#I  Nuclear rank: 2
#I  2-multiplicator rank: 9
#I  # of immediate descendants of order 2^8 is 26
#I  # of capable immediate descendants is 2
#I  **************************************************
#I  Starting group: [grp] #418;3
#I  Order: 2^7
#I  Nuclear rank: 2
#I  2-multiplicator rank: 9
#I  # of immediate descendants of order 2^8 is 16
#I  # of capable immediate descendants is 2
#I  **************************************************
#I  Starting group: [grp] #419;3
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 8
#I  # of immediate descendants of order 2^8 is 14
#I  # of capable immediate descendants is 3
#I  **************************************************
#I  Starting group: [grp] #420;3
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 8
#I  # of immediate descendants of order 2^8 is 16
#I  # of capable immediate descendants is 3
#I  **************************************************
#I  Starting group: [grp] #421;3
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 8
#I  # of immediate descendants of order 2^8 is 14
#I  # of capable immediate descendants is 3
#I  **************************************************
#I  Starting group: [grp] #422;3
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 8
#I  # of immediate descendants of order 2^8 is 16
#I  # of capable immediate descendants is 2
#I  **************************************************
#I  Starting group: [grp] #423;3
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 8
#I  # of immediate descendants of order 2^8 is 14
#I  # of capable immediate descendants is 2
#I  **************************************************
#I  Starting group: [grp] #424;3
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 8
#I  # of immediate descendants of order 2^8 is 14
#I  # of capable immediate descendants is 2
#I  **************************************************
#I  Starting group: [grp] #425;3
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 8
#I  # of immediate descendants of order 2^8 is 12
#I  # of capable immediate descendants is 2
#I  **************************************************
#I  Starting group: [grp] #426;3
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 8
#I  # of immediate descendants of order 2^8 is 32
#I  # of capable immediate descendants is 2
#I  **************************************************
#I  Starting group: [grp] #427;3
#I  Order: 2^7
#I  Nuclear rank: 2
#I  2-multiplicator rank: 9
#I  # of immediate descendants of order 2^8 is 21
#I  # of capable immediate descendants is 1
#I  **************************************************
#I  Starting group: [grp] #428;3
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 8
#I  # of immediate descendants of order 2^8 is 16
#I  # of capable immediate descendants is 2
#I  **************************************************
#I  Starting group: [grp] #429;3
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 8
#I  # of immediate descendants of order 2^8 is 16
#I  # of capable immediate descendants is 2
#I  **************************************************
#I  Starting group: [grp] #430;3
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 8
#I  # of immediate descendants of order 2^8 is 14
#I  # of capable immediate descendants is 2
#I  **************************************************
#I  Starting group: [grp] #431;3
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 8
#I  # of immediate descendants of order 2^8 is 20
#I  # of capable immediate descendants is 2
#I  **************************************************
#I  Starting group: [grp] #432;3
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 8
#I  # of immediate descendants of order 2^8 is 20
#I  # of capable immediate descendants is 3
#I  **************************************************
#I  Starting group: [grp] #433;3
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 8
#I  # of immediate descendants of order 2^8 is 20
#I  # of capable immediate descendants is 2
#I  **************************************************
#I  Starting group: [grp] #434;3
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 8
#I  # of immediate descendants of order 2^8 is 20
#I  # of capable immediate descendants is 2
#I  **************************************************
#I  Starting group: [grp] #435;3
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 8
#I  # of immediate descendants of order 2^8 is 18
#I  # of capable immediate descendants is 1
#I  **************************************************
#I  Starting group: [grp] #436;3
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 8
#I  # of immediate descendants of order 2^8 is 15
#I  # of capable immediate descendants is 1
#I  **************************************************
#I  Starting group: [grp] #437;3
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 8
#I  # of immediate descendants of order 2^8 is 10
#I  # of capable immediate descendants is 1
#I  **************************************************
#I  Starting group: [grp] #438;3
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 8
#I  # of immediate descendants of order 2^8 is 8
#I  # of capable immediate descendants is 1
#I  **************************************************
#I  Starting group: [grp] #440;3
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 8
#I  # of immediate descendants of order 2^8 is 3
#I  **************************************************
#I  Starting group: [grp] #452;3
#I  Order: 2^7
#I  Nuclear rank: 2
#I  2-multiplicator rank: 9
#I  # of immediate descendants of order 2^8 is 19
#I  # of capable immediate descendants is 1
#I  **************************************************
#I  Starting group: [grp] #453;3
#I  Order: 2^7
#I  Nuclear rank: 2
#I  2-multiplicator rank: 9
#I  # of immediate descendants of order 2^8 is 18
#I  # of capable immediate descendants is 1
#I  **************************************************
#I  Starting group: [grp] #454;3
#I  Order: 2^7
#I  Nuclear rank: 2
#I  2-multiplicator rank: 9
#I  # of immediate descendants of order 2^8 is 15
#I  # of capable immediate descendants is 1
#I  **************************************************
#I  Starting group: [grp] #455;3
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 8
#I  # of immediate descendants of order 2^8 is 13
#I  # of capable immediate descendants is 1
#I  **************************************************
#I  Starting group: [grp] #456;3
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 8
#I  # of immediate descendants of order 2^8 is 12
#I  # of capable immediate descendants is 1
#I  **************************************************
#I  Starting group: [grp] #457;3
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 8
#I  # of immediate descendants of order 2^8 is 20
#I  # of capable immediate descendants is 1
#I  **************************************************
#I  Starting group: [grp] #458;3
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 8
#I  # of immediate descendants of order 2^8 is 20
#I  # of capable immediate descendants is 1
#I  **************************************************
#I  Starting group: [grp] #459;3
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 8
#I  # of immediate descendants of order 2^8 is 20
#I  # of capable immediate descendants is 1
#I  **************************************************
#I  Starting group: [grp] #460;3
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 8
#I  # of immediate descendants of order 2^8 is 20
#I  # of capable immediate descendants is 1
#I  **************************************************
#I  Starting group: [grp] #464;3
#I  Order: 2^7
#I  Nuclear rank: 3
#I  2-multiplicator rank: 10
#I  # of immediate descendants of order 2^8 is 48
#I  # of capable immediate descendants is 2
#I  **************************************************
#I  Starting group: [grp] #465;3
#I  Order: 2^7
#I  Nuclear rank: 3
#I  2-multiplicator rank: 10
#I  # of immediate descendants of order 2^8 is 75
#I  # of capable immediate descendants is 2
#I  **************************************************
#I  Starting group: [grp] #466;3
#I  Order: 2^7
#I  Nuclear rank: 2
#I  2-multiplicator rank: 9
#I  # of immediate descendants of order 2^8 is 38
#I  # of capable immediate descendants is 1
#I  **************************************************
#I  Starting group: [grp] #467;3
#I  Order: 2^7
#I  Nuclear rank: 2
#I  2-multiplicator rank: 9
#I  # of immediate descendants of order 2^8 is 72
#I  # of capable immediate descendants is 4
#I  **************************************************
#I  Starting group: [grp] #468;3
#I  Order: 2^7
#I  Nuclear rank: 2
#I  2-multiplicator rank: 9
#I  # of immediate descendants of order 2^8 is 72
#I  # of capable immediate descendants is 2
#I  **************************************************
#I  Starting group: [grp] #469;3
#I  Order: 2^7
#I  Nuclear rank: 2
#I  2-multiplicator rank: 9
#I  # of immediate descendants of order 2^8 is 72
#I  # of capable immediate descendants is 2
#I  **************************************************
#I  Starting group: [grp] #470;3
#I  Order: 2^7
#I  Nuclear rank: 2
#I  2-multiplicator rank: 9
#I  # of immediate descendants of order 2^8 is 72
#I  # of capable immediate descendants is 2
#I  **************************************************
#I  Starting group: [grp] #471;3
#I  Order: 2^7
#I  Nuclear rank: 3
#I  2-multiplicator rank: 10
#I  # of immediate descendants of order 2^8 is 29
#I  # of capable immediate descendants is 1
#I  **************************************************
#I  Starting group: [grp] #472;3
#I  Order: 2^7
#I  Nuclear rank: 2
#I  2-multiplicator rank: 9
#I  # of immediate descendants of order 2^8 is 72
#I  # of capable immediate descendants is 2
#I  **************************************************
#I  Starting group: [grp] #473;3
#I  Order: 2^7
#I  Nuclear rank: 2
#I  2-multiplicator rank: 9
#I  # of immediate descendants of order 2^8 is 38
#I  # of capable immediate descendants is 1
#I  **************************************************
#I  Starting group: [grp] #474;3
#I  Order: 2^7
#I  Nuclear rank: 2
#I  2-multiplicator rank: 9
#I  # of immediate descendants of order 2^8 is 72
#I  # of capable immediate descendants is 4
#I  **************************************************
#I  Starting group: [grp] #475;3
#I  Order: 2^7
#I  Nuclear rank: 3
#I  2-multiplicator rank: 10
#I  # of immediate descendants of order 2^8 is 22
#I  # of capable immediate descendants is 2
#I  **************************************************
#I  Starting group: [grp] #476;3
#I  Order: 2^7
#I  Nuclear rank: 2
#I  2-multiplicator rank: 9
#I  # of immediate descendants of order 2^8 is 38
#I  # of capable immediate descendants is 1
#I  **************************************************
#I  Starting group: [grp] #477;3
#I  Order: 2^7
#I  Nuclear rank: 2
#I  2-multiplicator rank: 9
#I  # of immediate descendants of order 2^8 is 72
#I  # of capable immediate descendants is 2
#I  **************************************************
#I  Starting group: [grp] #478;3
#I  Order: 2^7
#I  Nuclear rank: 2
#I  2-multiplicator rank: 9
#I  # of immediate descendants of order 2^8 is 46
#I  # of capable immediate descendants is 2
#I  **************************************************
#I  Starting group: [grp] #479;3
#I  Order: 2^7
#I  Nuclear rank: 2
#I  2-multiplicator rank: 9
#I  # of immediate descendants of order 2^8 is 26
#I  # of capable immediate descendants is 1
#I  **************************************************
#I  Starting group: [grp] #480;3
#I  Order: 2^7
#I  Nuclear rank: 2
#I  2-multiplicator rank: 9
#I  # of immediate descendants of order 2^8 is 26
#I  # of capable immediate descendants is 2
#I  **************************************************
#I  Starting group: [grp] #481;3
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 8
#I  # of immediate descendants of order 2^8 is 32
#I  # of capable immediate descendants is 2
#I  **************************************************
#I  Starting group: [grp] #482;3
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 8
#I  # of immediate descendants of order 2^8 is 32
#I  # of capable immediate descendants is 2
#I  **************************************************
#I  Starting group: [grp] #483;3
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 8
#I  # of immediate descendants of order 2^8 is 32
#I  # of capable immediate descendants is 2
#I  **************************************************
#I  Starting group: [grp] #484;3
#I  Order: 2^7
#I  Nuclear rank: 2
#I  2-multiplicator rank: 9
#I  # of immediate descendants of order 2^8 is 40
#I  # of capable immediate descendants is 2
#I  **************************************************
#I  Starting group: [grp] #485;3
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 8
#I  # of immediate descendants of order 2^8 is 32
#I  # of capable immediate descendants is 2
#I  **************************************************
#I  Starting group: [grp] #486;3
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 8
#I  # of immediate descendants of order 2^8 is 32
#I  # of capable immediate descendants is 2
#I  **************************************************
#I  Starting group: [grp] #487;3
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 8
#I  # of immediate descendants of order 2^8 is 32
#I  # of capable immediate descendants is 2
#I  **************************************************
#I  Starting group: [grp] #488;3
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 8
#I  # of immediate descendants of order 2^8 is 32
#I  # of capable immediate descendants is 2
#I  **************************************************
#I  Starting group: [grp] #489;3
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 8
#I  # of immediate descendants of order 2^8 is 20
#I  # of capable immediate descendants is 3
#I  **************************************************
#I  Starting group: [grp] #490;3
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 8
#I  # of immediate descendants of order 2^8 is 32
#I  # of capable immediate descendants is 2
#I  **************************************************
#I  Starting group: [grp] #491;3
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 8
#I  # of immediate descendants of order 2^8 is 32
#I  # of capable immediate descendants is 2
#I  **************************************************
#I  Starting group: [grp] #492;3
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 8
#I  # of immediate descendants of order 2^8 is 32
#I  # of capable immediate descendants is 2
#I  **************************************************
#I  Starting group: [grp] #493;3
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 8
#I  # of immediate descendants of order 2^8 is 20
#I  # of capable immediate descendants is 4
#I  **************************************************
#I  Starting group: [grp] #494;3
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 8
#I  # of immediate descendants of order 2^8 is 32
#I  # of capable immediate descendants is 1
#I  **************************************************
#I  Starting group: [grp] #495;3
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 8
#I  # of immediate descendants of order 2^8 is 20
#I  # of capable immediate descendants is 2
#I  **************************************************
#I  Starting group: [grp] #496;3
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 8
#I  # of immediate descendants of order 2^8 is 32
#I  # of capable immediate descendants is 1
#I  **************************************************
#I  Starting group: [grp] #497;3
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 8
#I  # of immediate descendants of order 2^8 is 32
#I  # of capable immediate descendants is 2
#I  **************************************************
#I  Starting group: [grp] #498;3
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 8
#I  # of immediate descendants of order 2^8 is 32
#I  # of capable immediate descendants is 1
#I  **************************************************
#I  Starting group: [grp] #499;3
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 8
#I  # of immediate descendants of order 2^8 is 32
#I  # of capable immediate descendants is 2
#I  **************************************************
#I  Starting group: [grp] #500;3
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 8
#I  # of immediate descendants of order 2^8 is 32
#I  # of capable immediate descendants is 1
#I  **************************************************
#I  Starting group: [grp] #501;3
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 8
#I  # of immediate descendants of order 2^8 is 32
#I  # of capable immediate descendants is 1
#I  **************************************************
#I  Starting group: [grp] #502;3
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 8
#I  # of immediate descendants of order 2^8 is 32
#I  # of capable immediate descendants is 2
#I  **************************************************
#I  Starting group: [grp] #503;3
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 8
#I  # of immediate descendants of order 2^8 is 32
#I  # of capable immediate descendants is 1
#I  **************************************************
#I  Starting group: [grp] #504;3
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 8
#I  # of immediate descendants of order 2^8 is 32
#I  # of capable immediate descendants is 4
#I  **************************************************
#I  Starting group: [grp] #505;3
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 8
#I  # of immediate descendants of order 2^8 is 20
#I  # of capable immediate descendants is 2
#I  **************************************************
#I  Starting group: [grp] #506;3
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 8
#I  # of immediate descendants of order 2^8 is 32
#I  # of capable immediate descendants is 1
#I  **************************************************
#I  Starting group: [grp] #507;3
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 8
#I  # of immediate descendants of order 2^8 is 32
#I  # of capable immediate descendants is 1
#I  **************************************************
#I  Starting group: [grp] #508;3
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 8
#I  # of immediate descendants of order 2^8 is 20
#I  # of capable immediate descendants is 1
#I  **************************************************
#I  Starting group: [grp] #509;3
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 8
#I  # of immediate descendants of order 2^8 is 32
#I  # of capable immediate descendants is 1
#I  **************************************************
#I  Starting group: [grp] #510;3
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 8
#I  # of immediate descendants of order 2^8 is 32
#I  # of capable immediate descendants is 1
#I  **************************************************
#I  Starting group: [grp] #511;3
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 8
#I  # of immediate descendants of order 2^8 is 32
#I  # of capable immediate descendants is 1
#I  **************************************************
#I  Starting group: [grp] #512;3
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 8
#I  # of immediate descendants of order 2^8 is 32
#I  # of capable immediate descendants is 1
#I  **************************************************
#I  Starting group: [grp] #513;3
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 8
#I  # of immediate descendants of order 2^8 is 20
#I  # of capable immediate descendants is 2
#I  **************************************************
#I  Starting group: [grp] #514;3
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 8
#I  # of immediate descendants of order 2^8 is 32
#I  # of capable immediate descendants is 1
#I  **************************************************
#I  Starting group: [grp] #515;3
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 8
#I  # of immediate descendants of order 2^8 is 32
#I  # of capable immediate descendants is 1
#I  **************************************************
#I  Starting group: [grp] #516;3
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 8
#I  # of immediate descendants of order 2^8 is 32
#I  # of capable immediate descendants is 1
#I  **************************************************
#I  Starting group: [grp] #517;3
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 8
#I  # of immediate descendants of order 2^8 is 32
#I  # of capable immediate descendants is 1
#I  **************************************************
#I  Starting group: [grp] #518;3
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 8
#I  # of immediate descendants of order 2^8 is 20
#I  # of capable immediate descendants is 1
#I  **************************************************
#I  Starting group: [grp] #519;3
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 8
#I  # of immediate descendants of order 2^8 is 32
#I  # of capable immediate descendants is 1
#I  **************************************************
#I  Starting group: [grp] #520;3
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 8
#I  # of immediate descendants of order 2^8 is 14
#I  # of capable immediate descendants is 3
#I  **************************************************
#I  Starting group: [grp] #521;3
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 8
#I  # of immediate descendants of order 2^8 is 32
#I  # of capable immediate descendants is 1
#I  **************************************************
#I  Starting group: [grp] #522;3
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 8
#I  # of immediate descendants of order 2^8 is 20
#I  # of capable immediate descendants is 1
#I  **************************************************
#I  Starting group: [grp] #523;3
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 8
#I  # of immediate descendants of order 2^8 is 20
#I  # of capable immediate descendants is 1
#I  **************************************************
#I  Starting group: [grp] #524;3
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 8
#I  # of immediate descendants of order 2^8 is 20
#I  # of capable immediate descendants is 3
#I  **************************************************
#I  Starting group: [grp] #525;3
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 8
#I  # of immediate descendants of order 2^8 is 32
#I  # of capable immediate descendants is 2
#I  **************************************************
#I  Starting group: [grp] #526;3
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 8
#I  # of immediate descendants of order 2^8 is 32
#I  # of capable immediate descendants is 2
#I  **************************************************
#I  Starting group: [grp] #527;3
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 8
#I  # of immediate descendants of order 2^8 is 20
#I  # of capable immediate descendants is 1
#I  **************************************************
#I  Starting group: [grp] #528;3
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 8
#I  # of immediate descendants of order 2^8 is 20
#I  # of capable immediate descendants is 3
#I  **************************************************
#I  Starting group: [grp] #529;3
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 8
#I  # of immediate descendants of order 2^8 is 14
#I  # of capable immediate descendants is 1
#I  **************************************************
#I  Starting group: [grp] #530;3
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 8
#I  # of immediate descendants of order 2^8 is 14
#I  # of capable immediate descendants is 1
#I  **************************************************
#I  Starting group: [grp] #545;3
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 8
#I  # of immediate descendants of order 2^8 is 4
#I  **************************************************
#I  Starting group: [grp] #556;3
#I  Order: 2^7
#I  Nuclear rank: 2
#I  2-multiplicator rank: 9
#I  # of immediate descendants of order 2^8 is 2
#I  **************************************************
#I  Starting group: [grp] #578;3
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 8
#I  # of immediate descendants of order 2^8 is 2
#I  **************************************************
#I  Starting group: [grp] #600;3
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 8
#I  # of immediate descendants of order 2^8 is 2
#I  **************************************************
#I  Starting group: [grp] #608;3
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 8
#I  # of immediate descendants of order 2^8 is 12
#I  # of capable immediate descendants is 2
#I  **************************************************
#I  Starting group: [grp] #609;3
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 8
#I  # of immediate descendants of order 2^8 is 20
#I  # of capable immediate descendants is 1
#I  **************************************************
#I  Starting group: [grp] #610;3
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 8
#I  # of immediate descendants of order 2^8 is 20
#I  # of capable immediate descendants is 1
#I  **************************************************
#I  Starting group: [grp] #611;3
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 8
#I  # of immediate descendants of order 2^8 is 12
#I  # of capable immediate descendants is 1
#I  **************************************************
#I  Starting group: [grp] #612;3
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 8
#I  # of immediate descendants of order 2^8 is 16
#I  # of capable immediate descendants is 1
#I  **************************************************
#I  Starting group: [grp] #613;3
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 8
#I  # of immediate descendants of order 2^8 is 10
#I  # of capable immediate descendants is 1
#I  **************************************************
#I  Starting group: [grp] #614;3
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 8
#I  # of immediate descendants of order 2^8 is 10
#I  # of capable immediate descendants is 1
#I  **************************************************
#I  Starting group: [grp] #615;3
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 8
#I  # of immediate descendants of order 2^8 is 12
#I  # of capable immediate descendants is 1
#I  **************************************************
#I  Starting group: [grp] #616;3
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 8
#I  # of immediate descendants of order 2^8 is 16
#I  # of capable immediate descendants is 1
#I  **************************************************
#I  Starting group: [grp] #617;3
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 8
#I  # of immediate descendants of order 2^8 is 14
#I  # of capable immediate descendants is 1
#I  **************************************************
#I  Starting group: [grp] #618;3
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 8
#I  # of immediate descendants of order 2^8 is 10
#I  # of capable immediate descendants is 1
#I  **************************************************
#I  Starting group: [grp] #619;3
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 8
#I  # of immediate descendants of order 2^8 is 12
#I  # of capable immediate descendants is 2
#I  **************************************************
#I  Starting group: [grp] #622;3
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 8
#I  # of immediate descendants of order 2^8 is 3
#I  **************************************************
#I  Starting group: [grp] #636;3
#I  Order: 2^7
#I  Nuclear rank: 2
#I  2-multiplicator rank: 9
#I  # of immediate descendants of order 2^8 is 2
#I  **************************************************
#I  Starting group: [grp] #638;3
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 8
#I  # of immediate descendants of order 2^8 is 3
#I  **************************************************
#I  Starting group: [grp] #642;3
#I  Order: 2^7
#I  Nuclear rank: 6
#I  2-multiplicator rank: 13
#I  # of immediate descendants of order 2^8 is 24
#I  # of capable immediate descendants is 3
#I  **************************************************
#I  Starting group: [grp] #643;3
#I  Order: 2^7
#I  Nuclear rank: 4
#I  2-multiplicator rank: 11
#I  # of immediate descendants of order 2^8 is 51
#I  # of capable immediate descendants is 3
#I  **************************************************
#I  Starting group: [grp] #644;3
#I  Order: 2^7
#I  Nuclear rank: 3
#I  2-multiplicator rank: 10
#I  # of immediate descendants of order 2^8 is 25
#I  # of capable immediate descendants is 4
#I  **************************************************
#I  Starting group: [grp] #645;3
#I  Order: 2^7
#I  Nuclear rank: 3
#I  2-multiplicator rank: 10
#I  # of immediate descendants of order 2^8 is 46
#I  # of capable immediate descendants is 6
#I  **************************************************
#I  Starting group: [grp] #646;3
#I  Order: 2^7
#I  Nuclear rank: 2
#I  2-multiplicator rank: 9
#I  # of immediate descendants of order 2^8 is 42
#I  # of capable immediate descendants is 3
#I  **************************************************
#I  Starting group: [grp] #647;3
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 8
#I  # of immediate descendants of order 2^8 is 12
#I  # of capable immediate descendants is 3
#I  **************************************************
#I  Starting group: [grp] #648;3
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 8
#I  # of immediate descendants of order 2^8 is 16
#I  # of capable immediate descendants is 2
#I  **************************************************
#I  Starting group: [grp] #649;3
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 8
#I  # of immediate descendants of order 2^8 is 12
#I  # of capable immediate descendants is 3
#I  **************************************************
#I  Starting group: [grp] #650;3
#I  Order: 2^7
#I  Nuclear rank: 2
#I  2-multiplicator rank: 9
#I  # of immediate descendants of order 2^8 is 40
#I  # of capable immediate descendants is 3
#I  **************************************************
#I  Starting group: [grp] #651;3
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 8
#I  # of immediate descendants of order 2^8 is 14
#I  # of capable immediate descendants is 4
#I  **************************************************
#I  Starting group: [grp] #652;3
#I  Order: 2^7
#I  Nuclear rank: 3
#I  2-multiplicator rank: 10
#I  # of immediate descendants of order 2^8 is 35
#I  # of capable immediate descendants is 2
#I  **************************************************
#I  Starting group: [grp] #653;3
#I  Order: 2^7
#I  Nuclear rank: 2
#I  2-multiplicator rank: 9
#I  # of immediate descendants of order 2^8 is 29
#I  # of capable immediate descendants is 3
#I  **************************************************
#I  Starting group: [grp] #654;3
#I  Order: 2^7
#I  Nuclear rank: 2
#I  2-multiplicator rank: 9
#I  # of immediate descendants of order 2^8 is 32
#I  # of capable immediate descendants is 2
#I  **************************************************
#I  Starting group: [grp] #655;3
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 8
#I  # of immediate descendants of order 2^8 is 9
#I  # of capable immediate descendants is 1
#I  **************************************************
#I  Starting group: [grp] #656;3
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 8
#I  # of immediate descendants of order 2^8 is 12
#I  # of capable immediate descendants is 2
#I  **************************************************
#I  Starting group: [grp] #657;3
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 8
#I  # of immediate descendants of order 2^8 is 12
#I  # of capable immediate descendants is 1
#I  **************************************************
#I  Starting group: [grp] #658;3
#I  Order: 2^7
#I  Nuclear rank: 1
#I  2-multiplicator rank: 8
#I  # of immediate descendants of order 2^8 is 11
#I  # of capable immediate descendants is 1
#I  **************************************************
#I  Starting group: [grp] #663;3
#I  Order: 2^7
#I  Nuclear rank: 3
#I  2-multiplicator rank: 10
#I  # of immediate descendants of order 2^8 is 10
#I  # of capable immediate descendants is 1
#I  **************************************************
#I  Starting group: [grp] #664;3
#I  Order: 2^7
#I  Nuclear rank: 2
#I  2-multiplicator rank: 9
#I  # of immediate descendants of order 2^8 is 10
#I  # of capable immediate descendants is 1
#I  **************************************************
#I  Starting group: [grp] #665;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #665;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #666;4
#I  Order: 2^8
#I  Nuclear rank: 6
#I  2-multiplicator rank: 12
#I  Group [grp] #666;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #667;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #667;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #668;4
#I  Order: 2^8
#I  Nuclear rank: 5
#I  2-multiplicator rank: 11
#I  Group [grp] #668;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #669;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #669;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #670;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #670;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #671;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #671;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #672;4
#I  Order: 2^8
#I  Nuclear rank: 8
#I  2-multiplicator rank: 14
#I  Group [grp] #672;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #673;4
#I  Order: 2^8
#I  Nuclear rank: 6
#I  2-multiplicator rank: 12
#I  Group [grp] #673;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #674;4
#I  Order: 2^8
#I  Nuclear rank: 5
#I  2-multiplicator rank: 11
#I  Group [grp] #674;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #675;4
#I  Order: 2^8
#I  Nuclear rank: 6
#I  2-multiplicator rank: 12
#I  Group [grp] #675;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #676;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #676;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #677;4
#I  Order: 2^8
#I  Nuclear rank: 5
#I  2-multiplicator rank: 11
#I  Group [grp] #677;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #678;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #678;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #679;4
#I  Order: 2^8
#I  Nuclear rank: 6
#I  2-multiplicator rank: 12
#I  Group [grp] #679;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #680;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #680;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #681;4
#I  Order: 2^8
#I  Nuclear rank: 7
#I  2-multiplicator rank: 13
#I  Group [grp] #681;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #682;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #682;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #683;4
#I  Order: 2^8
#I  Nuclear rank: 6
#I  2-multiplicator rank: 12
#I  Group [grp] #683;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #684;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #684;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #685;4
#I  Order: 2^8
#I  Nuclear rank: 5
#I  2-multiplicator rank: 11
#I  Group [grp] #685;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #686;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #686;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #687;4
#I  Order: 2^8
#I  Nuclear rank: 5
#I  2-multiplicator rank: 11
#I  Group [grp] #687;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #688;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #688;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #689;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #689;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #690;4
#I  Order: 2^8
#I  Nuclear rank: 7
#I  2-multiplicator rank: 13
#I  Group [grp] #690;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #691;4
#I  Order: 2^8
#I  Nuclear rank: 5
#I  2-multiplicator rank: 11
#I  Group [grp] #691;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #692;4
#I  Order: 2^8
#I  Nuclear rank: 5
#I  2-multiplicator rank: 11
#I  Group [grp] #692;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #693;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #693;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #694;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #694;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #695;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #695;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #696;4
#I  Order: 2^8
#I  Nuclear rank: 5
#I  2-multiplicator rank: 11
#I  Group [grp] #696;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #697;4
#I  Order: 2^8
#I  Nuclear rank: 5
#I  2-multiplicator rank: 11
#I  Group [grp] #697;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #698;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #698;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #699;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #699;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #700;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #700;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #701;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #701;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #702;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #702;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #703;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #703;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #704;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #704;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #705;4
#I  Order: 2^8
#I  Nuclear rank: 5
#I  2-multiplicator rank: 11
#I  Group [grp] #705;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #706;4
#I  Order: 2^8
#I  Nuclear rank: 5
#I  2-multiplicator rank: 11
#I  Group [grp] #706;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #707;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #707;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #708;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #708;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #709;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #709;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #710;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #710;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #711;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #711;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #712;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #712;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #713;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #713;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #714;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #714;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #715;4
#I  Order: 2^8
#I  Nuclear rank: 7
#I  2-multiplicator rank: 13
#I  Group [grp] #715;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #716;4
#I  Order: 2^8
#I  Nuclear rank: 5
#I  2-multiplicator rank: 11
#I  Group [grp] #716;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #717;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #717;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #718;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #718;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #719;4
#I  Order: 2^8
#I  Nuclear rank: 6
#I  2-multiplicator rank: 12
#I  Group [grp] #719;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #720;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #720;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #721;4
#I  Order: 2^8
#I  Nuclear rank: 5
#I  2-multiplicator rank: 11
#I  Group [grp] #721;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #722;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #722;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #723;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #723;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #724;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #724;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #725;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #725;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #726;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #726;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #727;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #727;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #728;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #728;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #729;4
#I  Order: 2^8
#I  Nuclear rank: 6
#I  2-multiplicator rank: 12
#I  Group [grp] #729;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #730;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #730;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #731;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #731;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #732;4
#I  Order: 2^8
#I  Nuclear rank: 5
#I  2-multiplicator rank: 11
#I  Group [grp] #732;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #733;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #733;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #734;4
#I  Order: 2^8
#I  Nuclear rank: 5
#I  2-multiplicator rank: 11
#I  Group [grp] #734;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #735;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #735;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #736;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #736;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #737;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #737;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #738;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #738;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #739;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #739;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #740;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #740;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #741;4
#I  Order: 2^8
#I  Nuclear rank: 5
#I  2-multiplicator rank: 11
#I  Group [grp] #741;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #742;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #742;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #743;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #743;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #744;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #744;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #745;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #745;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #746;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #746;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #747;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #747;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #748;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #748;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #749;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #749;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #750;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #750;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #751;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #751;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #752;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #752;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #753;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #753;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #754;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #754;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #755;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #755;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #756;4
#I  Order: 2^8
#I  Nuclear rank: 8
#I  2-multiplicator rank: 14
#I  Group [grp] #756;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #757;4
#I  Order: 2^8
#I  Nuclear rank: 7
#I  2-multiplicator rank: 13
#I  Group [grp] #757;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #758;4
#I  Order: 2^8
#I  Nuclear rank: 7
#I  2-multiplicator rank: 13
#I  Group [grp] #758;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #759;4
#I  Order: 2^8
#I  Nuclear rank: 6
#I  2-multiplicator rank: 12
#I  Group [grp] #759;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #760;4
#I  Order: 2^8
#I  Nuclear rank: 5
#I  2-multiplicator rank: 11
#I  Group [grp] #760;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #761;4
#I  Order: 2^8
#I  Nuclear rank: 6
#I  2-multiplicator rank: 12
#I  Group [grp] #761;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #762;4
#I  Order: 2^8
#I  Nuclear rank: 6
#I  2-multiplicator rank: 12
#I  Group [grp] #762;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #763;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #763;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #764;4
#I  Order: 2^8
#I  Nuclear rank: 6
#I  2-multiplicator rank: 12
#I  Group [grp] #764;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #765;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #765;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #766;4
#I  Order: 2^8
#I  Nuclear rank: 6
#I  2-multiplicator rank: 12
#I  Group [grp] #766;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #767;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #767;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #768;4
#I  Order: 2^8
#I  Nuclear rank: 5
#I  2-multiplicator rank: 11
#I  Group [grp] #768;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #769;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #769;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #770;4
#I  Order: 2^8
#I  Nuclear rank: 7
#I  2-multiplicator rank: 13
#I  Group [grp] #770;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #771;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #771;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #772;4
#I  Order: 2^8
#I  Nuclear rank: 6
#I  2-multiplicator rank: 12
#I  Group [grp] #772;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #773;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #773;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #774;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #774;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #775;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #775;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #776;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #776;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #777;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #777;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #778;4
#I  Order: 2^8
#I  Nuclear rank: 6
#I  2-multiplicator rank: 12
#I  Group [grp] #778;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #779;4
#I  Order: 2^8
#I  Nuclear rank: 5
#I  2-multiplicator rank: 11
#I  Group [grp] #779;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #780;4
#I  Order: 2^8
#I  Nuclear rank: 5
#I  2-multiplicator rank: 11
#I  Group [grp] #780;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #781;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #781;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #782;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #782;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #783;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #783;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #784;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #784;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #785;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #785;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #786;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #786;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #787;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #787;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #788;4
#I  Order: 2^8
#I  Nuclear rank: 8
#I  2-multiplicator rank: 14
#I  Group [grp] #788;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #789;4
#I  Order: 2^8
#I  Nuclear rank: 6
#I  2-multiplicator rank: 12
#I  Group [grp] #789;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #790;4
#I  Order: 2^8
#I  Nuclear rank: 6
#I  2-multiplicator rank: 12
#I  Group [grp] #790;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #791;4
#I  Order: 2^8
#I  Nuclear rank: 5
#I  2-multiplicator rank: 11
#I  Group [grp] #791;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #792;4
#I  Order: 2^8
#I  Nuclear rank: 5
#I  2-multiplicator rank: 11
#I  Group [grp] #792;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #793;4
#I  Order: 2^8
#I  Nuclear rank: 6
#I  2-multiplicator rank: 12
#I  Group [grp] #793;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #794;4
#I  Order: 2^8
#I  Nuclear rank: 5
#I  2-multiplicator rank: 11
#I  Group [grp] #794;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #795;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #795;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #796;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #796;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #797;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #797;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #798;4
#I  Order: 2^8
#I  Nuclear rank: 6
#I  2-multiplicator rank: 12
#I  Group [grp] #798;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #799;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #799;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #800;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #800;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #801;4
#I  Order: 2^8
#I  Nuclear rank: 5
#I  2-multiplicator rank: 11
#I  Group [grp] #801;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #802;4
#I  Order: 2^8
#I  Nuclear rank: 5
#I  2-multiplicator rank: 11
#I  Group [grp] #802;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #803;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #803;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #804;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #804;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #805;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #805;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #806;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #806;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #807;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #807;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #808;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #808;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #809;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #809;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #810;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #810;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #811;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #811;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #812;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #812;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #813;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #813;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #814;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #814;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #815;4
#I  Order: 2^8
#I  Nuclear rank: 5
#I  2-multiplicator rank: 11
#I  Group [grp] #815;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #816;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #816;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #817;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #817;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #818;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #818;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #819;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #819;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #820;4
#I  Order: 2^8
#I  Nuclear rank: 5
#I  2-multiplicator rank: 11
#I  Group [grp] #820;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #821;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #821;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #822;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #822;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #823;4
#I  Order: 2^8
#I  Nuclear rank: 7
#I  2-multiplicator rank: 13
#I  Group [grp] #823;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #824;4
#I  Order: 2^8
#I  Nuclear rank: 5
#I  2-multiplicator rank: 11
#I  Group [grp] #824;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #825;4
#I  Order: 2^8
#I  Nuclear rank: 5
#I  2-multiplicator rank: 11
#I  Group [grp] #825;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #826;4
#I  Order: 2^8
#I  Nuclear rank: 5
#I  2-multiplicator rank: 11
#I  Group [grp] #826;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #827;4
#I  Order: 2^8
#I  Nuclear rank: 5
#I  2-multiplicator rank: 11
#I  Group [grp] #827;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #828;4
#I  Order: 2^8
#I  Nuclear rank: 5
#I  2-multiplicator rank: 11
#I  Group [grp] #828;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #829;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #829;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #830;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #830;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #831;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #831;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #832;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #832;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #833;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #833;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #834;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #834;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #835;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #835;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #836;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #836;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #837;4
#I  Order: 2^8
#I  Nuclear rank: 5
#I  2-multiplicator rank: 11
#I  Group [grp] #837;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #838;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #838;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #839;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #839;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #840;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #840;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #841;4
#I  Order: 2^8
#I  Nuclear rank: 5
#I  2-multiplicator rank: 11
#I  Group [grp] #841;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #842;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #842;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #843;4
#I  Order: 2^8
#I  Nuclear rank: 6
#I  2-multiplicator rank: 12
#I  Group [grp] #843;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #844;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #844;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #845;4
#I  Order: 2^8
#I  Nuclear rank: 5
#I  2-multiplicator rank: 11
#I  Group [grp] #845;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #846;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #846;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #847;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #847;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #848;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #848;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #849;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #849;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #850;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #850;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #851;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #851;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #852;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #852;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #853;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #853;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #854;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #854;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #855;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #855;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #856;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #856;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #857;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #857;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #858;4
#I  Order: 2^8
#I  Nuclear rank: 6
#I  2-multiplicator rank: 12
#I  Group [grp] #858;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #859;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #859;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #860;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #860;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #861;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #861;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #862;4
#I  Order: 2^8
#I  Nuclear rank: 5
#I  2-multiplicator rank: 11
#I  Group [grp] #862;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #863;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #863;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #864;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #864;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #865;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #865;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #866;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #866;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #867;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #867;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #868;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #868;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #869;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #869;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #870;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #870;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #871;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #871;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #872;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #872;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #873;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #873;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #874;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #874;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #875;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #875;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #876;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #876;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #877;4
#I  Order: 2^8
#I  Nuclear rank: 7
#I  2-multiplicator rank: 13
#I  Group [grp] #877;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #878;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #878;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #879;4
#I  Order: 2^8
#I  Nuclear rank: 5
#I  2-multiplicator rank: 11
#I  Group [grp] #879;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #880;4
#I  Order: 2^8
#I  Nuclear rank: 5
#I  2-multiplicator rank: 11
#I  Group [grp] #880;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #881;4
#I  Order: 2^8
#I  Nuclear rank: 5
#I  2-multiplicator rank: 11
#I  Group [grp] #881;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #882;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #882;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #883;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #883;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #884;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #884;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #885;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #885;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #886;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #886;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #887;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #887;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #888;4
#I  Order: 2^8
#I  Nuclear rank: 7
#I  2-multiplicator rank: 13
#I  Group [grp] #888;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #889;4
#I  Order: 2^8
#I  Nuclear rank: 5
#I  2-multiplicator rank: 11
#I  Group [grp] #889;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #890;4
#I  Order: 2^8
#I  Nuclear rank: 5
#I  2-multiplicator rank: 11
#I  Group [grp] #890;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #891;4
#I  Order: 2^8
#I  Nuclear rank: 6
#I  2-multiplicator rank: 12
#I  Group [grp] #891;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #892;4
#I  Order: 2^8
#I  Nuclear rank: 5
#I  2-multiplicator rank: 11
#I  Group [grp] #892;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #893;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #893;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #894;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #894;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #895;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #895;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #896;4
#I  Order: 2^8
#I  Nuclear rank: 5
#I  2-multiplicator rank: 11
#I  Group [grp] #896;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #897;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #897;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #898;4
#I  Order: 2^8
#I  Nuclear rank: 5
#I  2-multiplicator rank: 11
#I  Group [grp] #898;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #899;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #899;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #900;4
#I  Order: 2^8
#I  Nuclear rank: 5
#I  2-multiplicator rank: 11
#I  Group [grp] #900;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #901;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #901;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #902;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #902;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #903;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #903;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #904;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #904;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #905;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #905;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #906;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #906;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #907;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #907;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #908;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #908;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #909;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #909;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #910;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #910;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #911;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #911;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #912;4
#I  Order: 2^8
#I  Nuclear rank: 5
#I  2-multiplicator rank: 11
#I  Group [grp] #912;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #913;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #913;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #914;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #914;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #915;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #915;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #916;4
#I  Order: 2^8
#I  Nuclear rank: 6
#I  2-multiplicator rank: 12
#I  Group [grp] #916;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #917;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #917;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #918;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #918;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #919;4
#I  Order: 2^8
#I  Nuclear rank: 5
#I  2-multiplicator rank: 11
#I  Group [grp] #919;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #920;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #920;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #921;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #921;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #922;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #922;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #923;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #923;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #924;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #924;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #925;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #925;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #926;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #926;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #927;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #927;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #928;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #928;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #929;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #929;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #930;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #930;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #931;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #931;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #932;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #932;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #933;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #933;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #934;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #934;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #935;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #935;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #936;4
#I  Order: 2^8
#I  Nuclear rank: 6
#I  2-multiplicator rank: 12
#I  Group [grp] #936;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #937;4
#I  Order: 2^8
#I  Nuclear rank: 5
#I  2-multiplicator rank: 11
#I  Group [grp] #937;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #938;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #938;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #939;4
#I  Order: 2^8
#I  Nuclear rank: 5
#I  2-multiplicator rank: 11
#I  Group [grp] #939;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #940;4
#I  Order: 2^8
#I  Nuclear rank: 5
#I  2-multiplicator rank: 11
#I  Group [grp] #940;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #941;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #941;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #942;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #942;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #943;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #943;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #944;4
#I  Order: 2^8
#I  Nuclear rank: 6
#I  2-multiplicator rank: 12
#I  Group [grp] #944;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #945;4
#I  Order: 2^8
#I  Nuclear rank: 5
#I  2-multiplicator rank: 11
#I  Group [grp] #945;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #946;4
#I  Order: 2^8
#I  Nuclear rank: 6
#I  2-multiplicator rank: 12
#I  Group [grp] #946;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #947;4
#I  Order: 2^8
#I  Nuclear rank: 5
#I  2-multiplicator rank: 11
#I  Group [grp] #947;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #948;4
#I  Order: 2^8
#I  Nuclear rank: 5
#I  2-multiplicator rank: 11
#I  Group [grp] #948;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #949;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #949;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #950;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #950;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #951;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #951;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #952;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #952;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #953;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #953;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #954;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #954;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #955;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #955;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #956;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #956;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #957;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #957;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #958;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #958;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #959;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #959;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #960;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #960;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #961;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #961;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #962;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #962;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #963;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #963;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #964;4
#I  Order: 2^8
#I  Nuclear rank: 5
#I  2-multiplicator rank: 11
#I  Group [grp] #964;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #965;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #965;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #966;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #966;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #967;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #967;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #968;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #968;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #969;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #969;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #970;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #970;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #971;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #971;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #972;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #972;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #973;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #973;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #974;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #974;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #975;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #975;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #976;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #976;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #977;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #977;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #978;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #978;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #979;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #979;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #980;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #980;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #981;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #981;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #982;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #982;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #983;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #983;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #984;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #984;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #985;4
#I  Order: 2^8
#I  Nuclear rank: 5
#I  2-multiplicator rank: 11
#I  Group [grp] #985;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #986;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #986;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #987;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #987;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #988;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #988;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #989;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #989;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #990;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #990;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #991;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #991;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #992;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #992;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #993;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #993;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #994;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #994;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #995;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #995;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #996;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #996;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #997;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #997;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #998;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #998;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #999;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #999;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1000;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #1000;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1001;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #1001;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1002;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #1002;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1003;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #1003;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1004;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1004;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1005;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #1005;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1006;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1006;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1007;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1007;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1008;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1008;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1009;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1009;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1010;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1010;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1011;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1011;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1012;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1012;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1013;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1013;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1014;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #1014;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1015;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #1015;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1016;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #1016;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1017;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #1017;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1018;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #1018;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1019;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #1019;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1020;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #1020;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1021;4
#I  Order: 2^8
#I  Nuclear rank: 5
#I  2-multiplicator rank: 11
#I  Group [grp] #1021;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1022;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #1022;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1023;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #1023;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1024;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #1024;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1025;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1025;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1026;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1026;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1027;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #1027;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1028;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1028;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1029;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #1029;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1030;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #1030;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1031;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1031;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1032;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #1032;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1033;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #1033;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1034;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1034;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1035;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1035;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1036;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1036;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1037;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #1037;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1038;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #1038;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1039;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #1039;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1040;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #1040;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1041;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1041;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1042;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #1042;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1043;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #1043;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1044;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #1044;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1045;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1045;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1046;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1046;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1047;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1047;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1048;4
#I  Order: 2^8
#I  Nuclear rank: 6
#I  2-multiplicator rank: 12
#I  Group [grp] #1048;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1049;4
#I  Order: 2^8
#I  Nuclear rank: 5
#I  2-multiplicator rank: 11
#I  Group [grp] #1049;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1050;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #1050;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1051;4
#I  Order: 2^8
#I  Nuclear rank: 5
#I  2-multiplicator rank: 11
#I  Group [grp] #1051;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1052;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #1052;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1053;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #1053;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1054;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #1054;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1055;4
#I  Order: 2^8
#I  Nuclear rank: 7
#I  2-multiplicator rank: 13
#I  Group [grp] #1055;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1056;4
#I  Order: 2^8
#I  Nuclear rank: 5
#I  2-multiplicator rank: 11
#I  Group [grp] #1056;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1057;4
#I  Order: 2^8
#I  Nuclear rank: 5
#I  2-multiplicator rank: 11
#I  Group [grp] #1057;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1058;4
#I  Order: 2^8
#I  Nuclear rank: 6
#I  2-multiplicator rank: 12
#I  Group [grp] #1058;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1059;4
#I  Order: 2^8
#I  Nuclear rank: 5
#I  2-multiplicator rank: 11
#I  Group [grp] #1059;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1060;4
#I  Order: 2^8
#I  Nuclear rank: 5
#I  2-multiplicator rank: 11
#I  Group [grp] #1060;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1061;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #1061;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1062;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #1062;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1063;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #1063;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1064;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #1064;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1065;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1065;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1066;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #1066;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1067;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #1067;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1068;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1068;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1069;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1069;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1070;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #1070;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1071;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #1071;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1072;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #1072;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1073;4
#I  Order: 2^8
#I  Nuclear rank: 5
#I  2-multiplicator rank: 11
#I  Group [grp] #1073;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1074;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #1074;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1075;4
#I  Order: 2^8
#I  Nuclear rank: 5
#I  2-multiplicator rank: 11
#I  Group [grp] #1075;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1076;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #1076;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1077;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1077;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1078;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #1078;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1079;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1079;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1080;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #1080;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1081;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #1081;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1082;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #1082;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1083;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1083;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1084;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #1084;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1085;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #1085;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1086;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1086;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1087;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #1087;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1088;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #1088;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1089;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1089;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1090;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #1090;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1091;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #1091;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1092;4
#I  Order: 2^8
#I  Nuclear rank: 6
#I  2-multiplicator rank: 12
#I  Group [grp] #1092;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1093;4
#I  Order: 2^8
#I  Nuclear rank: 5
#I  2-multiplicator rank: 11
#I  Group [grp] #1093;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1094;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #1094;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1095;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #1095;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1096;4
#I  Order: 2^8
#I  Nuclear rank: 6
#I  2-multiplicator rank: 12
#I  Group [grp] #1096;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1097;4
#I  Order: 2^8
#I  Nuclear rank: 5
#I  2-multiplicator rank: 11
#I  Group [grp] #1097;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1098;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #1098;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1099;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #1099;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1100;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1100;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1101;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1101;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1102;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #1102;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1103;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #1103;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1104;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #1104;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1105;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #1105;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1106;4
#I  Order: 2^8
#I  Nuclear rank: 5
#I  2-multiplicator rank: 11
#I  Group [grp] #1106;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1107;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #1107;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1108;4
#I  Order: 2^8
#I  Nuclear rank: 5
#I  2-multiplicator rank: 11
#I  Group [grp] #1108;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1109;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #1109;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1110;4
#I  Order: 2^8
#I  Nuclear rank: 5
#I  2-multiplicator rank: 11
#I  Group [grp] #1110;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1111;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #1111;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1112;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #1112;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1113;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1113;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1114;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1114;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1115;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #1115;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1116;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #1116;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1117;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #1117;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1118;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1118;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1119;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #1119;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1120;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #1120;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1121;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #1121;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1122;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #1122;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1123;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #1123;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1124;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #1124;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1125;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #1125;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1126;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #1126;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1127;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #1127;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1128;4
#I  Order: 2^8
#I  Nuclear rank: 5
#I  2-multiplicator rank: 11
#I  Group [grp] #1128;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1129;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #1129;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1130;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #1130;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1131;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #1131;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1132;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #1132;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1133;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1133;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1134;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #1134;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1135;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #1135;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1136;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #1136;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1137;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1137;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1138;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1138;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1139;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1139;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1140;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #1140;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1141;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #1141;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1142;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1142;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1143;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #1143;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1144;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #1144;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1145;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #1145;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1146;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #1146;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1147;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #1147;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1148;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #1148;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1149;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #1149;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1150;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #1150;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1151;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #1151;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1152;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #1152;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1153;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #1153;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1154;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1154;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1155;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1155;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1156;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1156;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1157;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #1157;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1158;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1158;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1159;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1159;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1160;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #1160;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1161;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #1161;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1162;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1162;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1163;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1163;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1164;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #1164;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1165;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1165;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1166;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #1166;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1167;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #1167;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1168;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #1168;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1169;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1169;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1170;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #1170;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1171;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1171;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1172;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #1172;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1173;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1173;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1174;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #1174;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1175;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1175;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1176;4
#I  Order: 2^8
#I  Nuclear rank: 6
#I  2-multiplicator rank: 12
#I  Group [grp] #1176;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1177;4
#I  Order: 2^8
#I  Nuclear rank: 5
#I  2-multiplicator rank: 11
#I  Group [grp] #1177;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1178;4
#I  Order: 2^8
#I  Nuclear rank: 5
#I  2-multiplicator rank: 11
#I  Group [grp] #1178;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1179;4
#I  Order: 2^8
#I  Nuclear rank: 5
#I  2-multiplicator rank: 11
#I  Group [grp] #1179;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1180;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #1180;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1181;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #1181;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1182;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #1182;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1183;4
#I  Order: 2^8
#I  Nuclear rank: 5
#I  2-multiplicator rank: 11
#I  Group [grp] #1183;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1184;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #1184;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1185;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #1185;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1186;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #1186;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1187;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #1187;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1188;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #1188;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1189;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1189;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1190;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1190;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1191;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1191;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1192;4
#I  Order: 2^8
#I  Nuclear rank: 5
#I  2-multiplicator rank: 11
#I  Group [grp] #1192;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1193;4
#I  Order: 2^8
#I  Nuclear rank: 5
#I  2-multiplicator rank: 11
#I  Group [grp] #1193;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1194;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #1194;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1195;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #1195;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1196;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #1196;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1197;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #1197;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1198;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #1198;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1199;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #1199;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1200;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1200;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1201;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1201;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1202;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #1202;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1203;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #1203;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1204;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #1204;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1205;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1205;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1206;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #1206;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1207;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1207;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1208;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #1208;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1209;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #1209;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1210;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #1210;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1211;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #1211;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1212;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #1212;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1213;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #1213;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1214;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #1214;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1215;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #1215;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1216;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1216;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1217;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1217;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1218;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1218;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1219;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #1219;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1220;4
#I  Order: 2^8
#I  Nuclear rank: 5
#I  2-multiplicator rank: 11
#I  Group [grp] #1220;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1221;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #1221;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1222;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #1222;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1223;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #1223;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1224;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #1224;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1225;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #1225;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1226;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #1226;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1227;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #1227;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1228;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1228;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1229;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1229;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1230;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #1230;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1231;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #1231;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1232;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #1232;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1233;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #1233;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1234;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #1234;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1235;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #1235;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1236;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1236;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1237;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1237;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1238;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #1238;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1239;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1239;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1240;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #1240;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1241;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1241;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1242;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #1242;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1243;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #1243;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1244;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1244;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1245;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1245;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1246;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1246;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1247;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1247;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1248;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1248;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1249;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1249;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1250;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #1250;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1251;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #1251;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1252;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1252;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1253;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1253;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1254;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #1254;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1255;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #1255;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1256;4
#I  Order: 2^8
#I  Nuclear rank: 7
#I  2-multiplicator rank: 13
#I  Group [grp] #1256;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1257;4
#I  Order: 2^8
#I  Nuclear rank: 7
#I  2-multiplicator rank: 13
#I  Group [grp] #1257;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1258;4
#I  Order: 2^8
#I  Nuclear rank: 6
#I  2-multiplicator rank: 12
#I  Group [grp] #1258;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1259;4
#I  Order: 2^8
#I  Nuclear rank: 5
#I  2-multiplicator rank: 11
#I  Group [grp] #1259;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1260;4
#I  Order: 2^8
#I  Nuclear rank: 5
#I  2-multiplicator rank: 11
#I  Group [grp] #1260;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1261;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #1261;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1262;4
#I  Order: 2^8
#I  Nuclear rank: 6
#I  2-multiplicator rank: 12
#I  Group [grp] #1262;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1263;4
#I  Order: 2^8
#I  Nuclear rank: 5
#I  2-multiplicator rank: 11
#I  Group [grp] #1263;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1264;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #1264;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1265;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #1265;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1266;4
#I  Order: 2^8
#I  Nuclear rank: 5
#I  2-multiplicator rank: 11
#I  Group [grp] #1266;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1267;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #1267;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1268;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #1268;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1269;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #1269;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1270;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #1270;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1271;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #1271;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1272;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1272;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1273;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1273;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1274;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #1274;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1275;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #1275;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1276;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1276;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1277;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1277;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1278;4
#I  Order: 2^8
#I  Nuclear rank: 6
#I  2-multiplicator rank: 12
#I  Group [grp] #1278;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1279;4
#I  Order: 2^8
#I  Nuclear rank: 5
#I  2-multiplicator rank: 11
#I  Group [grp] #1279;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1280;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #1280;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1281;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #1281;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1282;4
#I  Order: 2^8
#I  Nuclear rank: 5
#I  2-multiplicator rank: 11
#I  Group [grp] #1282;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1283;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #1283;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1284;4
#I  Order: 2^8
#I  Nuclear rank: 5
#I  2-multiplicator rank: 11
#I  Group [grp] #1284;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1285;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #1285;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1286;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #1286;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1287;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #1287;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1288;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1288;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1289;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #1289;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1290;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #1290;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1291;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1291;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1292;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1292;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1293;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1293;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1294;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #1294;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1295;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #1295;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1296;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #1296;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1297;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #1297;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1298;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #1298;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1299;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1299;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1300;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #1300;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1301;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1301;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1302;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #1302;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1303;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #1303;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1304;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1304;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1305;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1305;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1306;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #1306;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1307;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1307;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1308;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1308;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1309;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1309;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1310;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #1310;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1311;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1311;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1312;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #1312;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1313;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #1313;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1314;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #1314;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1315;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1315;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1316;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1316;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1317;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1317;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1318;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #1318;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1319;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1319;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1320;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1320;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1321;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1321;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1322;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #1322;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1323;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #1323;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1324;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #1324;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1325;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #1325;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1326;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #1326;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1327;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #1327;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1328;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #1328;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1329;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #1329;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1330;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #1330;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1331;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #1331;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1332;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1332;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1333;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1333;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1334;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #1334;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1335;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1335;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1336;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #1336;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1337;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1337;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1338;4
#I  Order: 2^8
#I  Nuclear rank: 6
#I  2-multiplicator rank: 12
#I  Group [grp] #1338;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1339;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #1339;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1340;4
#I  Order: 2^8
#I  Nuclear rank: 6
#I  2-multiplicator rank: 12
#I  Group [grp] #1340;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1341;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #1341;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1342;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #1342;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1343;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1343;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1344;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1344;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1345;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #1345;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1346;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #1346;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1347;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1347;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1348;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #1348;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1349;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #1349;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1350;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #1350;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1351;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1351;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1352;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #1352;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1353;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1353;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1354;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1354;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1355;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1355;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1356;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1356;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1357;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1357;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1358;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1358;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1359;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #1359;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1360;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #1360;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1361;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #1361;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1362;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #1362;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1363;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #1363;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1364;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1364;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1365;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #1365;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1366;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #1366;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1367;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1367;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1368;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1368;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1369;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #1369;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1370;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #1370;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1371;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #1371;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1372;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #1372;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1373;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1373;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1374;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1374;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1375;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #1375;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1376;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #1376;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1377;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1377;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1378;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1378;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1379;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #1379;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1380;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #1380;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1381;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #1381;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1382;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #1382;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1383;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #1383;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1384;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #1384;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1385;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #1385;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1386;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1386;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1387;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1387;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1388;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1388;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1389;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1389;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1390;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1390;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1391;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1391;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1392;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1392;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1393;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #1393;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1394;4
#I  Order: 2^8
#I  Nuclear rank: 5
#I  2-multiplicator rank: 11
#I  Group [grp] #1394;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1395;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #1395;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1396;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #1396;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1397;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1397;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1398;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1398;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1399;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #1399;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1400;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1400;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1401;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #1401;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1402;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1402;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1403;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #1403;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1404;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #1404;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1405;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1405;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1406;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #1406;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1407;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #1407;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1408;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1408;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1409;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1409;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1410;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1410;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1411;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1411;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1412;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #1412;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1413;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #1413;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1414;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #1414;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1415;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1415;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1416;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1416;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1417;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #1417;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1418;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #1418;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1419;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #1419;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1420;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #1420;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1421;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #1421;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1422;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1422;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1423;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1423;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1424;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #1424;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1425;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #1425;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1426;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #1426;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1427;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #1427;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1428;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #1428;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1429;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #1429;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1430;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1430;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1431;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #1431;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1432;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #1432;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1433;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #1433;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1434;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #1434;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1435;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1435;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1436;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1436;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1437;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #1437;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1438;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #1438;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1439;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #1439;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1440;4
#I  Order: 2^8
#I  Nuclear rank: 5
#I  2-multiplicator rank: 11
#I  Group [grp] #1440;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1441;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #1441;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1442;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #1442;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1443;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #1443;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1444;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #1444;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1445;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #1445;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1446;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #1446;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1447;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #1447;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1448;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #1448;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1449;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #1449;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1450;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #1450;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1451;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1451;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1452;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1452;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1453;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1453;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1454;4
#I  Order: 2^8
#I  Nuclear rank: 5
#I  2-multiplicator rank: 11
#I  Group [grp] #1454;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1455;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #1455;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1456;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #1456;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1457;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #1457;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1458;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #1458;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1459;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #1459;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1460;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #1460;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1461;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #1461;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1462;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #1462;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1463;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1463;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1464;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #1464;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1465;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1465;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1466;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1466;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1467;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1467;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1468;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1468;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1469;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #1469;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1470;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #1470;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1471;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1471;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1472;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #1472;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1473;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #1473;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1474;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #1474;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1475;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1475;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1476;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1476;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1477;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #1477;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1478;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #1478;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1479;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1479;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1480;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1480;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1481;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1481;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1482;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1482;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1483;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #1483;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1484;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #1484;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1485;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1485;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1486;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #1486;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1487;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1487;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1488;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #1488;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1489;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1489;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1490;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #1490;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1491;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1491;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1492;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #1492;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1493;4
#I  Order: 2^8
#I  Nuclear rank: 6
#I  2-multiplicator rank: 12
#I  Group [grp] #1493;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1494;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #1494;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1495;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #1495;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1496;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #1496;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1497;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #1497;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1498;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1498;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1499;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #1499;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1500;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1500;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1501;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1501;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1502;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1502;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1503;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1503;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1504;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1504;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1505;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #1505;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1506;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1506;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1507;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1507;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1508;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1508;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1509;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1509;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1510;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1510;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1511;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1511;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1512;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1512;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1513;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #1513;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1514;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #1514;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1515;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #1515;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1516;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #1516;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1517;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #1517;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1518;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1518;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1519;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #1519;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1520;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #1520;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1521;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #1521;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1522;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #1522;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1523;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #1523;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1524;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #1524;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1525;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1525;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1526;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #1526;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1527;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #1527;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1528;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #1528;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1529;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #1529;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1530;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1530;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1531;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #1531;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1532;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #1532;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1533;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #1533;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1534;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #1534;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1535;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1535;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1536;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #1536;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1537;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1537;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1538;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1538;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1539;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #1539;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1540;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1540;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1541;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #1541;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1542;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #1542;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1543;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #1543;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1544;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #1544;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1545;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1545;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1546;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1546;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1547;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1547;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1548;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1548;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1549;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #1549;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1550;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1550;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1551;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1551;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1552;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1552;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1553;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1553;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1554;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1554;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1555;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1555;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1556;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #1556;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1557;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #1557;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1558;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1558;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1559;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #1559;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1560;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #1560;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1561;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #1561;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1562;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1562;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1563;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #1563;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1564;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1564;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1565;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #1565;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1566;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1566;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1567;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #1567;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1568;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #1568;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1569;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1569;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1570;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1570;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1571;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #1571;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1572;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #1572;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1573;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #1573;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1574;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1574;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1575;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #1575;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1576;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #1576;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1577;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #1577;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1578;4
#I  Order: 2^8
#I  Nuclear rank: 5
#I  2-multiplicator rank: 11
#I  Group [grp] #1578;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1579;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #1579;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1580;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #1580;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1581;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #1581;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1582;4
#I  Order: 2^8
#I  Nuclear rank: 5
#I  2-multiplicator rank: 11
#I  Group [grp] #1582;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1583;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #1583;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1584;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #1584;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1585;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #1585;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1586;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #1586;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1587;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #1587;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1588;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #1588;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1589;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1589;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1590;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1590;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1591;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1591;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1592;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #1592;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1593;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #1593;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1594;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #1594;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1595;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1595;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1596;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1596;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1597;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #1597;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1598;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1598;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1599;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1599;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1600;4
#I  Order: 2^8
#I  Nuclear rank: 10
#I  2-multiplicator rank: 16
#I  Group [grp] #1600;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1601;4
#I  Order: 2^8
#I  Nuclear rank: 7
#I  2-multiplicator rank: 13
#I  Group [grp] #1601;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1602;4
#I  Order: 2^8
#I  Nuclear rank: 7
#I  2-multiplicator rank: 13
#I  Group [grp] #1602;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1603;4
#I  Order: 2^8
#I  Nuclear rank: 5
#I  2-multiplicator rank: 11
#I  Group [grp] #1603;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1604;4
#I  Order: 2^8
#I  Nuclear rank: 5
#I  2-multiplicator rank: 11
#I  Group [grp] #1604;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1605;4
#I  Order: 2^8
#I  Nuclear rank: 5
#I  2-multiplicator rank: 11
#I  Group [grp] #1605;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1606;4
#I  Order: 2^8
#I  Nuclear rank: 5
#I  2-multiplicator rank: 11
#I  Group [grp] #1606;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1607;4
#I  Order: 2^8
#I  Nuclear rank: 5
#I  2-multiplicator rank: 11
#I  Group [grp] #1607;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1608;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #1608;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1609;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #1609;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1610;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #1610;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1611;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #1611;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1612;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #1612;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1613;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #1613;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1614;4
#I  Order: 2^8
#I  Nuclear rank: 7
#I  2-multiplicator rank: 13
#I  Group [grp] #1614;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1615;4
#I  Order: 2^8
#I  Nuclear rank: 8
#I  2-multiplicator rank: 14
#I  Group [grp] #1615;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1616;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #1616;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1617;4
#I  Order: 2^8
#I  Nuclear rank: 5
#I  2-multiplicator rank: 11
#I  Group [grp] #1617;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1618;4
#I  Order: 2^8
#I  Nuclear rank: 5
#I  2-multiplicator rank: 11
#I  Group [grp] #1618;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1619;4
#I  Order: 2^8
#I  Nuclear rank: 6
#I  2-multiplicator rank: 12
#I  Group [grp] #1619;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1620;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #1620;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1621;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #1621;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1622;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #1622;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1623;4
#I  Order: 2^8
#I  Nuclear rank: 5
#I  2-multiplicator rank: 11
#I  Group [grp] #1623;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1624;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #1624;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1625;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1625;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1626;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #1626;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1627;4
#I  Order: 2^8
#I  Nuclear rank: 5
#I  2-multiplicator rank: 11
#I  Group [grp] #1627;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1628;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #1628;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1629;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #1629;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1630;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #1630;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1631;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1631;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1632;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #1632;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1633;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #1633;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1634;4
#I  Order: 2^8
#I  Nuclear rank: 5
#I  2-multiplicator rank: 11
#I  Group [grp] #1634;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1635;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #1635;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1636;4
#I  Order: 2^8
#I  Nuclear rank: 8
#I  2-multiplicator rank: 14
#I  Group [grp] #1636;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1637;4
#I  Order: 2^8
#I  Nuclear rank: 7
#I  2-multiplicator rank: 13
#I  Group [grp] #1637;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1638;4
#I  Order: 2^8
#I  Nuclear rank: 6
#I  2-multiplicator rank: 12
#I  Group [grp] #1638;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1639;4
#I  Order: 2^8
#I  Nuclear rank: 6
#I  2-multiplicator rank: 12
#I  Group [grp] #1639;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1640;4
#I  Order: 2^8
#I  Nuclear rank: 6
#I  2-multiplicator rank: 12
#I  Group [grp] #1640;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1641;4
#I  Order: 2^8
#I  Nuclear rank: 5
#I  2-multiplicator rank: 11
#I  Group [grp] #1641;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1642;4
#I  Order: 2^8
#I  Nuclear rank: 5
#I  2-multiplicator rank: 11
#I  Group [grp] #1642;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1643;4
#I  Order: 2^8
#I  Nuclear rank: 6
#I  2-multiplicator rank: 12
#I  Group [grp] #1643;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1644;4
#I  Order: 2^8
#I  Nuclear rank: 5
#I  2-multiplicator rank: 11
#I  Group [grp] #1644;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1645;4
#I  Order: 2^8
#I  Nuclear rank: 7
#I  2-multiplicator rank: 13
#I  Group [grp] #1645;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1646;4
#I  Order: 2^8
#I  Nuclear rank: 6
#I  2-multiplicator rank: 12
#I  Group [grp] #1646;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1647;4
#I  Order: 2^8
#I  Nuclear rank: 5
#I  2-multiplicator rank: 11
#I  Group [grp] #1647;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1648;4
#I  Order: 2^8
#I  Nuclear rank: 5
#I  2-multiplicator rank: 11
#I  Group [grp] #1648;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1649;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #1649;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1650;4
#I  Order: 2^8
#I  Nuclear rank: 5
#I  2-multiplicator rank: 11
#I  Group [grp] #1650;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1651;4
#I  Order: 2^8
#I  Nuclear rank: 5
#I  2-multiplicator rank: 11
#I  Group [grp] #1651;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1652;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #1652;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1653;4
#I  Order: 2^8
#I  Nuclear rank: 5
#I  2-multiplicator rank: 11
#I  Group [grp] #1653;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1654;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #1654;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1655;4
#I  Order: 2^8
#I  Nuclear rank: 5
#I  2-multiplicator rank: 11
#I  Group [grp] #1655;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1656;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #1656;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1657;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #1657;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1658;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #1658;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1659;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #1659;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1660;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #1660;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1661;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1661;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1662;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #1662;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1663;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1663;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1664;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #1664;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1665;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1665;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1666;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #1666;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1667;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1667;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1668;4
#I  Order: 2^8
#I  Nuclear rank: 5
#I  2-multiplicator rank: 11
#I  Group [grp] #1668;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1669;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #1669;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1670;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #1670;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1671;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #1671;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1672;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #1672;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1673;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #1673;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1674;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #1674;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1675;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #1675;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1676;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #1676;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1677;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #1677;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1678;4
#I  Order: 2^8
#I  Nuclear rank: 6
#I  2-multiplicator rank: 12
#I  Group [grp] #1678;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1679;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #1679;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1680;4
#I  Order: 2^8
#I  Nuclear rank: 5
#I  2-multiplicator rank: 11
#I  Group [grp] #1680;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1681;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #1681;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1682;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #1682;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1683;4
#I  Order: 2^8
#I  Nuclear rank: 5
#I  2-multiplicator rank: 11
#I  Group [grp] #1683;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1684;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #1684;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1685;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #1685;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1686;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #1686;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1687;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #1687;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1688;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #1688;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1689;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #1689;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1690;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #1690;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1691;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #1691;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1692;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #1692;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1693;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1693;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1694;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1694;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1695;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1695;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1696;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1696;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1697;4
#I  Order: 2^8
#I  Nuclear rank: 5
#I  2-multiplicator rank: 11
#I  Group [grp] #1697;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1698;4
#I  Order: 2^8
#I  Nuclear rank: 5
#I  2-multiplicator rank: 11
#I  Group [grp] #1698;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1699;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #1699;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1700;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1700;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1701;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #1701;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1702;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1702;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1703;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1703;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1704;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1704;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1705;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1705;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1706;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1706;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1707;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #1707;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1708;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1708;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1709;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #1709;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1710;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #1710;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1711;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1711;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1712;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1712;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1713;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1713;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1714;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1714;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1715;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1715;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1716;4
#I  Order: 2^8
#I  Nuclear rank: 5
#I  2-multiplicator rank: 11
#I  Group [grp] #1716;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1717;4
#I  Order: 2^8
#I  Nuclear rank: 5
#I  2-multiplicator rank: 11
#I  Group [grp] #1717;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1718;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #1718;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1719;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #1719;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1720;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #1720;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1721;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1721;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1722;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #1722;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1723;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #1723;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1724;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #1724;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1725;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1725;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1726;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #1726;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1727;4
#I  Order: 2^8
#I  Nuclear rank: 5
#I  2-multiplicator rank: 11
#I  Group [grp] #1727;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1728;4
#I  Order: 2^8
#I  Nuclear rank: 5
#I  2-multiplicator rank: 11
#I  Group [grp] #1728;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1729;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #1729;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1730;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1730;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1731;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #1731;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1732;4
#I  Order: 2^8
#I  Nuclear rank: 6
#I  2-multiplicator rank: 12
#I  Group [grp] #1732;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1733;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #1733;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1734;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #1734;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1735;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #1735;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1736;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #1736;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1737;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #1737;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1738;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #1738;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1739;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #1739;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1740;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #1740;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1741;4
#I  Order: 2^8
#I  Nuclear rank: 5
#I  2-multiplicator rank: 11
#I  Group [grp] #1741;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1742;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #1742;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1743;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #1743;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1744;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #1744;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1745;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #1745;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1746;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #1746;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1747;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #1747;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1748;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #1748;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1749;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1749;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1750;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1750;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1751;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1751;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1752;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1752;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1753;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1753;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1754;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1754;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1755;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1755;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1756;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1756;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1757;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #1757;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1758;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1758;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1759;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #1759;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1760;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #1760;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1761;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1761;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1762;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1762;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1763;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #1763;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1764;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #1764;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1765;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1765;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1766;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #1766;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1767;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1767;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1768;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #1768;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1769;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1769;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1770;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #1770;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1771;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1771;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1772;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #1772;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1773;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #1773;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1774;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1774;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1775;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1775;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1776;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #1776;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1777;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1777;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1778;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #1778;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1779;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #1779;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1780;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1780;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1781;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #1781;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1782;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1782;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1783;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #1783;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1784;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #1784;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1785;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1785;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1786;4
#I  Order: 2^8
#I  Nuclear rank: 5
#I  2-multiplicator rank: 11
#I  Group [grp] #1786;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1787;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #1787;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1788;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1788;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1789;4
#I  Order: 2^8
#I  Nuclear rank: 5
#I  2-multiplicator rank: 11
#I  Group [grp] #1789;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1790;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1790;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1791;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #1791;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1792;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1792;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1793;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1793;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1794;4
#I  Order: 2^8
#I  Nuclear rank: 7
#I  2-multiplicator rank: 13
#I  Group [grp] #1794;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1795;4
#I  Order: 2^8
#I  Nuclear rank: 6
#I  2-multiplicator rank: 12
#I  Group [grp] #1795;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1796;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #1796;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1797;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #1797;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1798;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #1798;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1799;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #1799;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1800;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #1800;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1801;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #1801;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1802;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #1802;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1803;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #1803;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1804;4
#I  Order: 2^8
#I  Nuclear rank: 5
#I  2-multiplicator rank: 11
#I  Group [grp] #1804;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1805;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #1805;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1806;4
#I  Order: 2^8
#I  Nuclear rank: 7
#I  2-multiplicator rank: 13
#I  Group [grp] #1806;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1807;4
#I  Order: 2^8
#I  Nuclear rank: 5
#I  2-multiplicator rank: 11
#I  Group [grp] #1807;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1808;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #1808;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1809;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #1809;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1810;4
#I  Order: 2^8
#I  Nuclear rank: 6
#I  2-multiplicator rank: 12
#I  Group [grp] #1810;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1811;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #1811;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1812;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #1812;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1813;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #1813;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1814;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #1814;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1815;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #1815;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1816;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #1816;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1817;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1817;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1818;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #1818;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1819;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #1819;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1820;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1820;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1821;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #1821;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1822;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1822;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1823;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #1823;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1824;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1824;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1825;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #1825;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1826;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #1826;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1827;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #1827;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1828;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #1828;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1829;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #1829;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1830;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #1830;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1831;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #1831;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1832;4
#I  Order: 2^8
#I  Nuclear rank: 6
#I  2-multiplicator rank: 12
#I  Group [grp] #1832;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1833;4
#I  Order: 2^8
#I  Nuclear rank: 5
#I  2-multiplicator rank: 11
#I  Group [grp] #1833;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1834;4
#I  Order: 2^8
#I  Nuclear rank: 5
#I  2-multiplicator rank: 11
#I  Group [grp] #1834;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1835;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #1835;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1836;4
#I  Order: 2^8
#I  Nuclear rank: 5
#I  2-multiplicator rank: 11
#I  Group [grp] #1836;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1837;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #1837;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1838;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #1838;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1839;4
#I  Order: 2^8
#I  Nuclear rank: 5
#I  2-multiplicator rank: 11
#I  Group [grp] #1839;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1840;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #1840;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1841;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #1841;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1842;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #1842;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1843;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #1843;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1844;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #1844;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1845;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #1845;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1846;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #1846;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1847;4
#I  Order: 2^8
#I  Nuclear rank: 5
#I  2-multiplicator rank: 11
#I  Group [grp] #1847;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1848;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #1848;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1849;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #1849;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1850;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #1850;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1851;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #1851;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1852;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #1852;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1853;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #1853;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1854;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #1854;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1855;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #1855;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1856;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #1856;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1857;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #1857;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1858;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1858;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1859;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1859;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1860;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1860;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1861;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1861;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1862;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #1862;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1863;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #1863;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1864;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #1864;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1865;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #1865;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1866;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #1866;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1867;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #1867;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1868;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1868;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1869;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #1869;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1870;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1870;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1871;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #1871;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1872;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #1872;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1873;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #1873;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1874;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #1874;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1875;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #1875;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1876;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #1876;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1877;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1877;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1878;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #1878;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1879;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #1879;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1880;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1880;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1881;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #1881;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1882;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #1882;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1883;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #1883;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1884;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #1884;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1885;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #1885;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1886;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1886;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1887;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1887;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1888;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1888;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1889;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #1889;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1890;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #1890;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1891;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1891;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1892;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1892;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1893;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1893;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1894;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #1894;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1895;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #1895;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1896;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #1896;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1897;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #1897;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1898;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #1898;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1899;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1899;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1900;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1900;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1901;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1901;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1902;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #1902;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1903;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1903;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1904;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1904;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1905;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #1905;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1906;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #1906;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1907;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1907;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1908;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #1908;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1909;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1909;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1910;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1910;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1911;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #1911;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1912;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1912;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1913;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #1913;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1914;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1914;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1915;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1915;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1916;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1916;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1917;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #1917;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1918;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1918;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1919;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1919;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1920;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #1920;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1921;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1921;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1922;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #1922;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1923;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #1923;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1924;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #1924;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1925;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #1925;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1926;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1926;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1927;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1927;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1928;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #1928;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1929;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1929;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1930;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #1930;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1931;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #1931;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1932;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1932;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1933;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1933;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1934;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1934;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1935;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #1935;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1936;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #1936;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1937;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #1937;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1938;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #1938;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1939;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #1939;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1940;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #1940;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1941;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1941;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1942;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #1942;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1943;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #1943;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1944;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1944;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1945;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #1945;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1946;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1946;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1947;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #1947;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1948;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #1948;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1950;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #1950;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1952;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #1952;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1954;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #1954;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1956;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #1956;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1959;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #1959;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1961;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #1961;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1962;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #1962;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1964;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1964;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1965;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #1965;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1966;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #1966;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1967;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #1967;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1968;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1968;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1969;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #1969;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1970;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #1970;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1971;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #1971;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1972;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #1972;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1973;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #1973;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1974;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #1974;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1975;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1975;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1976;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #1976;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1978;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #1978;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1980;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #1980;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1981;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #1981;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1982;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1982;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1983;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #1983;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1984;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1984;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1985;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #1985;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1986;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1986;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1987;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #1987;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1988;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #1988;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1989;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #1989;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1990;4
#I  Order: 2^8
#I  Nuclear rank: 5
#I  2-multiplicator rank: 11
#I  Group [grp] #1990;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1991;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #1991;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1992;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #1992;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1993;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #1993;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1994;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #1994;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1995;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #1995;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1996;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1996;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1997;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #1997;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1998;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #1998;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #1999;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #1999;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2000;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #2000;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2001;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2001;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2002;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #2002;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2003;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #2003;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2004;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2004;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2005;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #2005;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2006;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2006;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2007;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2007;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2008;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2008;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2009;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2009;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2010;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #2010;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2011;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #2011;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2012;4
#I  Order: 2^8
#I  Nuclear rank: 5
#I  2-multiplicator rank: 11
#I  Group [grp] #2012;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2013;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #2013;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2014;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2014;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2015;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #2015;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2016;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2016;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2017;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #2017;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2018;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2018;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2019;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2019;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2020;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #2020;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2021;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #2021;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2022;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2022;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2023;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2023;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2024;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #2024;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2025;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #2025;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2026;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2026;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2027;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #2027;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2028;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #2028;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2029;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2029;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2030;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2030;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2031;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #2031;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2032;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #2032;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2033;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #2033;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2034;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #2034;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2035;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #2035;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2036;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #2036;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2037;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2037;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2038;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2038;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2039;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #2039;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2040;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2040;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2041;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #2041;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2042;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2042;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2043;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2043;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2044;4
#I  Order: 2^8
#I  Nuclear rank: 6
#I  2-multiplicator rank: 12
#I  Group [grp] #2044;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2045;4
#I  Order: 2^8
#I  Nuclear rank: 6
#I  2-multiplicator rank: 12
#I  Group [grp] #2045;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2046;4
#I  Order: 2^8
#I  Nuclear rank: 5
#I  2-multiplicator rank: 11
#I  Group [grp] #2046;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2047;4
#I  Order: 2^8
#I  Nuclear rank: 5
#I  2-multiplicator rank: 11
#I  Group [grp] #2047;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2048;4
#I  Order: 2^8
#I  Nuclear rank: 5
#I  2-multiplicator rank: 11
#I  Group [grp] #2048;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2049;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #2049;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2050;4
#I  Order: 2^8
#I  Nuclear rank: 5
#I  2-multiplicator rank: 11
#I  Group [grp] #2050;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2051;4
#I  Order: 2^8
#I  Nuclear rank: 5
#I  2-multiplicator rank: 11
#I  Group [grp] #2051;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2052;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #2052;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2053;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #2053;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2054;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #2054;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2055;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #2055;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2056;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #2056;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2057;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #2057;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2058;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #2058;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2059;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #2059;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2060;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #2060;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2061;4
#I  Order: 2^8
#I  Nuclear rank: 5
#I  2-multiplicator rank: 11
#I  Group [grp] #2061;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2062;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #2062;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2063;4
#I  Order: 2^8
#I  Nuclear rank: 6
#I  2-multiplicator rank: 12
#I  Group [grp] #2063;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2064;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #2064;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2065;4
#I  Order: 2^8
#I  Nuclear rank: 5
#I  2-multiplicator rank: 11
#I  Group [grp] #2065;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2066;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #2066;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2067;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #2067;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2068;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #2068;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2069;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #2069;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2070;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #2070;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2071;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #2071;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2072;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #2072;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2073;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #2073;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2074;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #2074;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2075;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #2075;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2076;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #2076;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2077;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #2077;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2078;4
#I  Order: 2^8
#I  Nuclear rank: 5
#I  2-multiplicator rank: 11
#I  Group [grp] #2078;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2079;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #2079;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2080;4
#I  Order: 2^8
#I  Nuclear rank: 5
#I  2-multiplicator rank: 11
#I  Group [grp] #2080;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2081;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #2081;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2082;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #2082;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2083;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #2083;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2084;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #2084;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2085;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2085;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2086;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #2086;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2087;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2087;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2088;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #2088;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2089;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #2089;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2090;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #2090;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2091;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #2091;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2092;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #2092;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2093;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #2093;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2094;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2094;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2095;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #2095;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2096;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #2096;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2097;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #2097;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2098;4
#I  Order: 2^8
#I  Nuclear rank: 5
#I  2-multiplicator rank: 11
#I  Group [grp] #2098;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2099;4
#I  Order: 2^8
#I  Nuclear rank: 5
#I  2-multiplicator rank: 11
#I  Group [grp] #2099;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2100;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #2100;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2101;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #2101;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2102;4
#I  Order: 2^8
#I  Nuclear rank: 5
#I  2-multiplicator rank: 11
#I  Group [grp] #2102;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2103;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #2103;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2104;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #2104;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2105;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #2105;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2106;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #2106;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2107;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #2107;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2108;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #2108;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2109;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #2109;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2110;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #2110;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2111;4
#I  Order: 2^8
#I  Nuclear rank: 5
#I  2-multiplicator rank: 11
#I  Group [grp] #2111;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2112;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #2112;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2113;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #2113;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2114;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #2114;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2115;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #2115;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2116;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #2116;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2117;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #2117;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2118;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #2118;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2119;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #2119;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2120;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #2120;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2121;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #2121;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2122;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #2122;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2123;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #2123;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2124;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #2124;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2125;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #2125;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2126;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2126;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2127;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2127;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2128;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2128;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2130;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2130;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2132;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #2132;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2133;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2133;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2134;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2134;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2135;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #2135;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2136;4
#I  Order: 2^8
#I  Nuclear rank: 5
#I  2-multiplicator rank: 11
#I  Group [grp] #2136;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2137;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #2137;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2138;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #2138;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2139;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #2139;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2140;4
#I  Order: 2^8
#I  Nuclear rank: 5
#I  2-multiplicator rank: 11
#I  Group [grp] #2140;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2141;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #2141;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2142;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #2142;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2143;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #2143;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2144;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #2144;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2145;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #2145;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2146;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #2146;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2147;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #2147;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2148;4
#I  Order: 2^8
#I  Nuclear rank: 5
#I  2-multiplicator rank: 11
#I  Group [grp] #2148;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2149;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #2149;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2150;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #2150;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2151;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #2151;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2152;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #2152;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2153;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #2153;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2154;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #2154;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2155;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #2155;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2156;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #2156;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2157;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #2157;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2158;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #2158;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2159;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #2159;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2160;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #2160;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2161;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #2161;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2162;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #2162;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2163;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #2163;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2164;4
#I  Order: 2^8
#I  Nuclear rank: 5
#I  2-multiplicator rank: 11
#I  Group [grp] #2164;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2165;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #2165;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2166;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #2166;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2167;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2167;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2168;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2168;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2169;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #2169;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2170;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #2170;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2171;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #2171;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2172;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #2172;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2173;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2173;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2174;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2174;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2175;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #2175;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2176;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #2176;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2177;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2177;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2178;4
#I  Order: 2^8
#I  Nuclear rank: 7
#I  2-multiplicator rank: 13
#I  Group [grp] #2178;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2179;4
#I  Order: 2^8
#I  Nuclear rank: 7
#I  2-multiplicator rank: 13
#I  Group [grp] #2179;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2180;4
#I  Order: 2^8
#I  Nuclear rank: 6
#I  2-multiplicator rank: 12
#I  Group [grp] #2180;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2181;4
#I  Order: 2^8
#I  Nuclear rank: 5
#I  2-multiplicator rank: 11
#I  Group [grp] #2181;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2182;4
#I  Order: 2^8
#I  Nuclear rank: 5
#I  2-multiplicator rank: 11
#I  Group [grp] #2182;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2183;4
#I  Order: 2^8
#I  Nuclear rank: 5
#I  2-multiplicator rank: 11
#I  Group [grp] #2183;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2184;4
#I  Order: 2^8
#I  Nuclear rank: 6
#I  2-multiplicator rank: 12
#I  Group [grp] #2184;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2185;4
#I  Order: 2^8
#I  Nuclear rank: 5
#I  2-multiplicator rank: 11
#I  Group [grp] #2185;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2186;4
#I  Order: 2^8
#I  Nuclear rank: 5
#I  2-multiplicator rank: 11
#I  Group [grp] #2186;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2187;4
#I  Order: 2^8
#I  Nuclear rank: 6
#I  2-multiplicator rank: 12
#I  Group [grp] #2187;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2188;4
#I  Order: 2^8
#I  Nuclear rank: 6
#I  2-multiplicator rank: 12
#I  Group [grp] #2188;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2189;4
#I  Order: 2^8
#I  Nuclear rank: 5
#I  2-multiplicator rank: 11
#I  Group [grp] #2189;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2190;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #2190;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2191;4
#I  Order: 2^8
#I  Nuclear rank: 5
#I  2-multiplicator rank: 11
#I  Group [grp] #2191;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2192;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #2192;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2193;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #2193;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2194;4
#I  Order: 2^8
#I  Nuclear rank: 6
#I  2-multiplicator rank: 12
#I  Group [grp] #2194;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2195;4
#I  Order: 2^8
#I  Nuclear rank: 5
#I  2-multiplicator rank: 11
#I  Group [grp] #2195;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2196;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #2196;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2197;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #2197;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2198;4
#I  Order: 2^8
#I  Nuclear rank: 5
#I  2-multiplicator rank: 11
#I  Group [grp] #2198;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2199;4
#I  Order: 2^8
#I  Nuclear rank: 6
#I  2-multiplicator rank: 12
#I  Group [grp] #2199;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2200;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #2200;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2201;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #2201;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2202;4
#I  Order: 2^8
#I  Nuclear rank: 5
#I  2-multiplicator rank: 11
#I  Group [grp] #2202;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2203;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #2203;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2204;4
#I  Order: 2^8
#I  Nuclear rank: 5
#I  2-multiplicator rank: 11
#I  Group [grp] #2204;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2205;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #2205;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2206;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #2206;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2207;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2207;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2208;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #2208;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2209;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2209;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2210;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #2210;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2211;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #2211;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2212;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #2212;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2213;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #2213;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2214;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #2214;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2215;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #2215;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2216;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #2216;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2217;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #2217;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2218;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #2218;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2219;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #2219;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2220;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #2220;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2221;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #2221;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2222;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #2222;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2223;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #2223;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2224;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #2224;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2225;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #2225;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2226;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #2226;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2227;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #2227;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2228;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #2228;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2229;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #2229;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2230;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #2230;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2231;4
#I  Order: 2^8
#I  Nuclear rank: 6
#I  2-multiplicator rank: 12
#I  Group [grp] #2231;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2232;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #2232;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2233;4
#I  Order: 2^8
#I  Nuclear rank: 5
#I  2-multiplicator rank: 11
#I  Group [grp] #2233;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2234;4
#I  Order: 2^8
#I  Nuclear rank: 5
#I  2-multiplicator rank: 11
#I  Group [grp] #2234;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2235;4
#I  Order: 2^8
#I  Nuclear rank: 5
#I  2-multiplicator rank: 11
#I  Group [grp] #2235;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2236;4
#I  Order: 2^8
#I  Nuclear rank: 5
#I  2-multiplicator rank: 11
#I  Group [grp] #2236;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2237;4
#I  Order: 2^8
#I  Nuclear rank: 5
#I  2-multiplicator rank: 11
#I  Group [grp] #2237;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2238;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #2238;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2239;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #2239;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2240;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #2240;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2241;4
#I  Order: 2^8
#I  Nuclear rank: 5
#I  2-multiplicator rank: 11
#I  Group [grp] #2241;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2242;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #2242;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2243;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #2243;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2244;4
#I  Order: 2^8
#I  Nuclear rank: 5
#I  2-multiplicator rank: 11
#I  Group [grp] #2244;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2245;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #2245;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2246;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #2246;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2247;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #2247;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2248;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #2248;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2249;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #2249;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2250;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #2250;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2251;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #2251;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2252;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #2252;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2253;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2253;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2254;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2254;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2255;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #2255;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2256;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #2256;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2257;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2257;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2258;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2258;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2259;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #2259;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2260;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #2260;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2261;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #2261;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2262;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2262;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2263;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #2263;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2264;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #2264;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2265;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #2265;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2266;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #2266;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2267;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #2267;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2268;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #2268;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2269;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #2269;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2270;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #2270;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2271;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2271;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2272;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #2272;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2273;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2273;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2274;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #2274;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2275;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #2275;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2276;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #2276;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2277;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2277;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2278;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #2278;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2279;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #2279;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2280;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #2280;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2281;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #2281;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2282;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #2282;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2283;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #2283;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2284;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #2284;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2285;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2285;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2286;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #2286;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2287;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #2287;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2288;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2288;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2289;4
#I  Order: 2^8
#I  Nuclear rank: 5
#I  2-multiplicator rank: 11
#I  Group [grp] #2289;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2290;4
#I  Order: 2^8
#I  Nuclear rank: 5
#I  2-multiplicator rank: 11
#I  Group [grp] #2290;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2291;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #2291;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2292;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #2292;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2293;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #2293;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2294;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2294;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2295;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2295;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2296;4
#I  Order: 2^8
#I  Nuclear rank: 5
#I  2-multiplicator rank: 11
#I  Group [grp] #2296;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2297;4
#I  Order: 2^8
#I  Nuclear rank: 5
#I  2-multiplicator rank: 11
#I  Group [grp] #2297;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2298;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #2298;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2299;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #2299;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2300;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #2300;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2301;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #2301;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2302;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2302;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2303;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2303;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2304;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #2304;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2305;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #2305;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2306;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #2306;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2307;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #2307;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2308;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #2308;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2309;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2309;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2310;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2310;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2311;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #2311;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2312;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #2312;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2313;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #2313;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2314;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2314;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2315;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #2315;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2316;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2316;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2317;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2317;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2318;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #2318;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2319;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #2319;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2320;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #2320;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2321;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2321;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2322;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2322;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2323;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #2323;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2324;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #2324;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2325;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #2325;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2326;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #2326;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2327;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #2327;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2328;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2328;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2329;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #2329;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2330;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2330;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2331;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2331;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2332;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #2332;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2333;4
#I  Order: 2^8
#I  Nuclear rank: 5
#I  2-multiplicator rank: 11
#I  Group [grp] #2333;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2334;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #2334;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2335;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2335;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2336;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2336;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2337;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #2337;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2338;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #2338;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2339;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #2339;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2340;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #2340;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2341;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #2341;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2342;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #2342;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2343;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2343;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2344;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #2344;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2345;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2345;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2346;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2346;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2347;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #2347;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2348;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #2348;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2349;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #2349;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2350;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #2350;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2351;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #2351;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2352;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #2352;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2353;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #2353;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2354;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2354;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2355;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2355;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2356;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2356;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2357;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #2357;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2358;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2358;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2359;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2359;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2360;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #2360;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2361;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #2361;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2362;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #2362;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2363;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #2363;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2364;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2364;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2365;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2365;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2366;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2366;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2367;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #2367;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2368;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #2368;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2369;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2369;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2370;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2370;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2371;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #2371;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2372;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #2372;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2373;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #2373;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2374;4
#I  Order: 2^8
#I  Nuclear rank: 5
#I  2-multiplicator rank: 11
#I  Group [grp] #2374;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2375;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2375;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2376;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2376;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2377;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #2377;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2378;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2378;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2379;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #2379;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2380;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2380;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2381;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2381;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2382;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #2382;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2383;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #2383;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2384;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #2384;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2385;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #2385;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2386;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #2386;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2387;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #2387;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2388;4
#I  Order: 2^8
#I  Nuclear rank: 5
#I  2-multiplicator rank: 11
#I  Group [grp] #2388;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2389;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #2389;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2390;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2390;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2391;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2391;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2392;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #2392;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2393;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #2393;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2394;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #2394;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2395;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #2395;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2396;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #2396;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2397;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #2397;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2398;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2398;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2399;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2399;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2400;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #2400;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2401;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #2401;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2402;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2402;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2403;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2403;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2404;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2404;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2405;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #2405;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2406;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #2406;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2407;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2407;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2408;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2408;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2409;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2409;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2410;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #2410;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2411;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2411;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2412;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2412;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2413;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2413;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2414;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #2414;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2415;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #2415;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2416;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #2416;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2417;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #2417;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2418;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #2418;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2419;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #2419;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2420;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2420;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2421;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2421;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2422;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #2422;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2423;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #2423;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2424;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2424;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2425;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2425;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2426;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #2426;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2427;4
#I  Order: 2^8
#I  Nuclear rank: 5
#I  2-multiplicator rank: 11
#I  Group [grp] #2427;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2428;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #2428;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2429;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #2429;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2430;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2430;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2431;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2431;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2432;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2432;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2433;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2433;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2434;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2434;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2435;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2435;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2436;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2436;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2437;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #2437;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2438;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2438;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2439;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2439;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2440;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #2440;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2441;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2441;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2442;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #2442;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2443;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #2443;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2444;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2444;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2445;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2445;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2446;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2446;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2447;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #2447;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2448;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #2448;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2449;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2449;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2450;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #2450;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2451;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2451;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2452;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2452;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2453;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2453;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2454;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #2454;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2455;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #2455;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2456;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #2456;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2457;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2457;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2458;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2458;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2459;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #2459;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2460;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2460;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2461;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2461;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2462;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2462;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2463;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #2463;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2464;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #2464;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2465;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2465;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2466;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2466;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2467;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2467;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2468;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #2468;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2469;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #2469;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2470;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #2470;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2471;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #2471;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2472;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2472;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2473;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #2473;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2474;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #2474;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2475;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #2475;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2476;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2476;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2477;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #2477;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2478;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2478;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2479;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #2479;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2480;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #2480;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2481;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2481;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2482;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #2482;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2483;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2483;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2484;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #2484;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2485;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #2485;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2486;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2486;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2487;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #2487;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2488;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #2488;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2489;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #2489;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2490;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #2490;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2491;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #2491;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2492;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #2492;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2493;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #2493;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2494;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2494;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2495;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #2495;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2496;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2496;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2497;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #2497;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2498;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #2498;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2499;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #2499;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2500;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #2500;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2501;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #2501;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2502;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #2502;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2503;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #2503;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2504;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2504;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2505;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2505;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2506;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2506;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2507;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #2507;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2508;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2508;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2509;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #2509;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2510;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #2510;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2511;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2511;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2512;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #2512;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2513;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #2513;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2514;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2514;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2515;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2515;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2516;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2516;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2517;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #2517;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2518;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2518;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2519;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2519;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2520;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2520;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2521;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #2521;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2522;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #2522;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2523;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #2523;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2524;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2524;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2525;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #2525;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2526;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2526;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2527;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2527;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2528;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2528;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2529;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #2529;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2530;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #2530;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2531;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #2531;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2532;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #2532;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2533;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #2533;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2534;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #2534;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2535;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #2535;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2536;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #2536;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2537;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #2537;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2538;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #2538;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2539;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #2539;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2540;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #2540;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2541;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #2541;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2542;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #2542;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2543;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #2543;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2544;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #2544;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2545;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2545;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2546;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #2546;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2547;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2547;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2548;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2548;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2549;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2549;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2550;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #2550;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2551;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #2551;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2552;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #2552;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2553;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #2553;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2554;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #2554;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2555;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #2555;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2556;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #2556;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2557;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #2557;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2558;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2558;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2559;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2559;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2560;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2560;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2561;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #2561;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2562;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2562;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2563;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2563;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2564;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #2564;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2565;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2565;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2566;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2566;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2567;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2567;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2568;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2568;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2569;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #2569;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2570;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2570;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2571;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2571;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2572;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #2572;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2573;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2573;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2574;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2574;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2575;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2575;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2576;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #2576;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2577;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2577;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2578;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2578;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2579;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2579;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2580;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2580;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2581;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #2581;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2582;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #2582;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2583;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #2583;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2584;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2584;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2585;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2585;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2586;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2586;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2587;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #2587;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2588;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #2588;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2589;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #2589;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2590;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #2590;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2591;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #2591;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2592;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #2592;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2593;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #2593;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2594;4
#I  Order: 2^8
#I  Nuclear rank: 5
#I  2-multiplicator rank: 11
#I  Group [grp] #2594;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2595;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #2595;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2596;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2596;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2597;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2597;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2598;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2598;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2599;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2599;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2600;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #2600;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2601;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2601;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2602;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2602;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2603;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #2603;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2604;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #2604;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2605;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #2605;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2606;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2606;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2607;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #2607;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2608;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #2608;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2609;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #2609;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2610;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2610;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2611;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #2611;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2612;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2612;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2613;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #2613;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2614;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2614;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2615;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2615;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2616;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2616;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2617;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #2617;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2618;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2618;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2619;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2619;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2620;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2620;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2621;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2621;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2622;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #2622;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2623;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #2623;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2624;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2624;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2625;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2625;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2626;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2626;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2627;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #2627;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2628;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2628;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2629;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2629;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2630;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #2630;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2631;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2631;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2632;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #2632;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2633;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #2633;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2634;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #2634;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2635;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #2635;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2636;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #2636;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2637;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #2637;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2638;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2638;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2639;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #2639;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2640;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2640;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2641;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #2641;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2642;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #2642;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2643;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2643;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2644;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #2644;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2645;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #2645;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2646;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2646;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2647;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #2647;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2648;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2648;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2649;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #2649;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2650;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #2650;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2651;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2651;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2652;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #2652;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2653;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #2653;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2654;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2654;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2655;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2655;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2656;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2656;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2657;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2657;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2658;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2658;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2659;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2659;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2660;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2660;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2661;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2661;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2662;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #2662;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2663;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #2663;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2664;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #2664;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2665;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #2665;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2666;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #2666;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2667;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #2667;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2668;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #2668;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2669;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #2669;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2670;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #2670;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2671;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #2671;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2672;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2672;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2673;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #2673;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2674;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #2674;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2675;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #2675;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2676;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #2676;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2677;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2677;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2678;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2678;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2679;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2679;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2680;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #2680;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2681;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #2681;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2682;4
#I  Order: 2^8
#I  Nuclear rank: 5
#I  2-multiplicator rank: 11
#I  Group [grp] #2682;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2683;4
#I  Order: 2^8
#I  Nuclear rank: 5
#I  2-multiplicator rank: 11
#I  Group [grp] #2683;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2684;4
#I  Order: 2^8
#I  Nuclear rank: 5
#I  2-multiplicator rank: 11
#I  Group [grp] #2684;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2685;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #2685;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2686;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #2686;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2687;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2687;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2688;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2688;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2689;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #2689;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2690;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #2690;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2691;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #2691;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2692;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2692;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2693;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #2693;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2694;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2694;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2695;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #2695;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2696;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2696;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2697;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #2697;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2698;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #2698;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2699;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #2699;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2700;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #2700;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2701;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #2701;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2702;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2702;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2703;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #2703;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2704;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #2704;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2705;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #2705;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2706;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #2706;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2707;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #2707;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2708;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2708;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2709;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2709;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2710;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2710;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2711;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #2711;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2712;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2712;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2713;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #2713;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2714;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2714;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2715;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2715;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2716;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #2716;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2717;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2717;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2718;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2718;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2719;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #2719;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2720;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2720;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2721;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2721;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2722;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #2722;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2723;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2723;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2724;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #2724;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2725;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2725;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2726;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #2726;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2727;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2727;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2728;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #2728;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2729;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2729;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2730;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #2730;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2731;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2731;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2732;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #2732;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2733;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #2733;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2734;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2734;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2735;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2735;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2736;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2736;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2737;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #2737;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2738;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2738;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2739;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #2739;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2740;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2740;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2741;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2741;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2742;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2742;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2743;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #2743;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2744;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #2744;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2745;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #2745;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2746;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2746;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2747;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2747;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2748;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2748;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2749;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2749;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2750;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #2750;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2751;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #2751;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2752;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #2752;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2753;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2753;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2754;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #2754;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2755;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2755;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2756;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2756;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2757;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2757;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2758;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #2758;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2759;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2759;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2760;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #2760;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2761;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2761;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2762;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2762;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2763;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #2763;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2764;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #2764;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2765;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2765;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2766;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #2766;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2767;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #2767;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2768;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #2768;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2769;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #2769;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2770;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #2770;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2771;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #2771;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2772;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2772;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2773;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2773;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2774;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2774;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2775;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2775;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2776;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2776;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2777;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2777;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2778;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #2778;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2779;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2779;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2780;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2780;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2781;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2781;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2782;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2782;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2783;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #2783;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2784;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #2784;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2785;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #2785;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2786;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #2786;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2787;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2787;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2788;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2788;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2789;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #2789;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2790;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #2790;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2791;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #2791;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2792;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2792;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2793;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #2793;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2794;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2794;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2795;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2795;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2796;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #2796;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2797;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #2797;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2798;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #2798;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2799;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #2799;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2800;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #2800;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2801;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #2801;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2802;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #2802;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2803;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #2803;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2804;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2804;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2805;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2805;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2806;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2806;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2807;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2807;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2808;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2808;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2809;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2809;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2810;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2810;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2811;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #2811;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2812;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #2812;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2813;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #2813;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2814;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #2814;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2815;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2815;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2816;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2816;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2817;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #2817;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2818;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #2818;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2819;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #2819;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2820;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #2820;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2821;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #2821;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2822;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2822;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2823;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2823;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2824;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #2824;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2825;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #2825;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2826;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #2826;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2827;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #2827;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2828;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2828;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2829;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #2829;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2830;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #2830;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2831;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #2831;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2832;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #2832;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2833;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #2833;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2834;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #2834;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2835;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #2835;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2836;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2836;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2837;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2837;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2838;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2838;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2839;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #2839;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2840;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2840;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2841;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #2841;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2842;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #2842;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2843;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2843;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2844;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #2844;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2845;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #2845;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2846;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2846;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2847;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2847;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2848;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #2848;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2849;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #2849;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2850;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #2850;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2851;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #2851;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2852;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #2852;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2853;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2853;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2854;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2854;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2855;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2855;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2856;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #2856;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2857;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2857;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2858;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #2858;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2859;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #2859;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2860;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #2860;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2861;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #2861;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2862;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #2862;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2863;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #2863;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2864;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2864;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2865;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2865;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2866;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #2866;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2867;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #2867;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2868;4
#I  Order: 2^8
#I  Nuclear rank: 8
#I  2-multiplicator rank: 14
#I  Group [grp] #2868;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2869;4
#I  Order: 2^8
#I  Nuclear rank: 6
#I  2-multiplicator rank: 12
#I  Group [grp] #2869;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2870;4
#I  Order: 2^8
#I  Nuclear rank: 5
#I  2-multiplicator rank: 11
#I  Group [grp] #2870;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2871;4
#I  Order: 2^8
#I  Nuclear rank: 5
#I  2-multiplicator rank: 11
#I  Group [grp] #2871;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2872;4
#I  Order: 2^8
#I  Nuclear rank: 5
#I  2-multiplicator rank: 11
#I  Group [grp] #2872;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2873;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #2873;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2874;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2874;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2875;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #2875;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2876;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2876;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2877;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2877;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2878;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2878;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2879;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #2879;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2880;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2880;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2881;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2881;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2882;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #2882;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2883;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #2883;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2884;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2884;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2885;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2885;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2886;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2886;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2887;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #2887;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2888;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #2888;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2889;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2889;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2890;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2890;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2891;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2891;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2892;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2892;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2893;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #2893;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2894;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #2894;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2895;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2895;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2896;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #2896;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2897;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2897;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2898;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2898;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2899;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2899;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2900;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #2900;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2901;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2901;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2902;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2902;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2903;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #2903;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2904;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #2904;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2905;4
#I  Order: 2^8
#I  Nuclear rank: 5
#I  2-multiplicator rank: 11
#I  Group [grp] #2905;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2906;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #2906;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2907;4
#I  Order: 2^8
#I  Nuclear rank: 5
#I  2-multiplicator rank: 11
#I  Group [grp] #2907;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2908;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #2908;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2909;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2909;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2910;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2910;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2911;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2911;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2912;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2912;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2913;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2913;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2914;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2914;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2915;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #2915;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2916;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2916;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2917;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #2917;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2918;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2918;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2919;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2919;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2920;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #2920;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2921;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2921;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2922;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2922;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2923;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2923;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2924;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #2924;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2925;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #2925;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2926;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #2926;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2927;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2927;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2928;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #2928;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2929;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2929;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2930;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2930;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2931;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #2931;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2932;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2932;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2933;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #2933;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2934;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #2934;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2935;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #2935;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2936;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2936;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2937;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #2937;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2938;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2938;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2939;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #2939;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2940;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #2940;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2941;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #2941;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2942;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #2942;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2943;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #2943;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2944;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #2944;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2945;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #2945;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2946;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #2946;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2947;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #2947;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2948;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2948;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2949;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2949;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2950;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2950;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2951;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2951;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2952;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #2952;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2953;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #2953;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2954;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #2954;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2955;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #2955;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2956;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2956;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2957;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2957;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2958;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #2958;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2959;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2959;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2960;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2960;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2961;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #2961;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2962;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #2962;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2963;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #2963;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2964;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #2964;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2965;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2965;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2966;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #2966;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2967;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #2967;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2968;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2968;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2969;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #2969;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2970;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2970;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2971;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #2971;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2972;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #2972;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2973;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #2973;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2974;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #2974;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2975;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #2975;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2976;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #2976;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2977;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2977;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2978;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #2978;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2979;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2979;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2980;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2980;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2981;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2981;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2982;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #2982;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2983;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2983;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2984;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2984;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2985;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2985;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2986;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2986;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2987;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2987;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2988;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #2988;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2989;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2989;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2990;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2990;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2991;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #2991;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2992;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #2992;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2993;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2993;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2994;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2994;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2995;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #2995;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2996;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2996;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2997;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #2997;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2998;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2998;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #2999;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #2999;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3000;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #3000;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3001;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #3001;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3002;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #3002;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3003;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #3003;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3004;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #3004;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3005;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #3005;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3006;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #3006;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3007;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #3007;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3008;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #3008;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3009;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #3009;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3010;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #3010;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3011;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #3011;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3012;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #3012;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3013;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #3013;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3014;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #3014;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3015;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #3015;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3016;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #3016;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3017;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #3017;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3018;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #3018;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3019;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #3019;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3020;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #3020;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3021;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #3021;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3022;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #3022;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3023;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #3023;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3024;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #3024;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3025;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #3025;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3026;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #3026;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3027;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #3027;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3028;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #3028;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3029;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #3029;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3030;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #3030;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3031;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #3031;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3032;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #3032;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3033;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #3033;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3034;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #3034;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3035;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #3035;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3036;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #3036;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3037;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #3037;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3038;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #3038;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3039;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #3039;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3041;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #3041;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3042;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #3042;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3043;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #3043;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3045;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #3045;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3046;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #3046;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3049;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #3049;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3050;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #3050;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3052;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #3052;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3053;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #3053;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3054;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #3054;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3055;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #3055;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3056;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #3056;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3058;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #3058;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3062;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #3062;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3064;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #3064;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3065;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #3065;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3066;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #3066;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3067;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #3067;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3068;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #3068;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3070;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #3070;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3072;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #3072;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3073;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #3073;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3075;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #3075;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3077;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #3077;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3079;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #3079;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3080;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #3080;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3081;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #3081;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3082;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #3082;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3083;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #3083;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3084;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #3084;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3087;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #3087;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3096;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #3096;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3098;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #3098;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3102;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #3102;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3103;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #3103;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3104;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #3104;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3105;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #3105;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3106;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #3106;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3111;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #3111;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3113;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #3113;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3114;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #3114;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3115;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #3115;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3116;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #3116;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3117;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #3117;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3118;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #3118;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3120;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #3120;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3121;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #3121;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3122;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #3122;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3125;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #3125;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3126;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #3126;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3127;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #3127;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3128;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #3128;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3129;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #3129;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3130;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #3130;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3131;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #3131;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3132;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #3132;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3134;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #3134;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3135;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #3135;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3136;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #3136;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3137;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #3137;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3138;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #3138;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3140;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #3140;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3141;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #3141;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3143;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #3143;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3144;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #3144;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3145;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #3145;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3146;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #3146;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3149;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #3149;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3150;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #3150;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3153;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #3153;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3154;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #3154;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3156;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #3156;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3157;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #3157;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3159;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #3159;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3161;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #3161;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3163;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #3163;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3164;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #3164;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3165;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #3165;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3166;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #3166;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3167;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #3167;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3168;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #3168;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3169;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #3169;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3170;4
#I  Order: 2^8
#I  Nuclear rank: 6
#I  2-multiplicator rank: 12
#I  Group [grp] #3170;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3171;4
#I  Order: 2^8
#I  Nuclear rank: 5
#I  2-multiplicator rank: 11
#I  Group [grp] #3171;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3172;4
#I  Order: 2^8
#I  Nuclear rank: 5
#I  2-multiplicator rank: 11
#I  Group [grp] #3172;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3173;4
#I  Order: 2^8
#I  Nuclear rank: 6
#I  2-multiplicator rank: 12
#I  Group [grp] #3173;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3174;4
#I  Order: 2^8
#I  Nuclear rank: 5
#I  2-multiplicator rank: 11
#I  Group [grp] #3174;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3175;4
#I  Order: 2^8
#I  Nuclear rank: 5
#I  2-multiplicator rank: 11
#I  Group [grp] #3175;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3176;4
#I  Order: 2^8
#I  Nuclear rank: 5
#I  2-multiplicator rank: 11
#I  Group [grp] #3176;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3177;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #3177;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3178;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #3178;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3179;4
#I  Order: 2^8
#I  Nuclear rank: 5
#I  2-multiplicator rank: 11
#I  Group [grp] #3179;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3180;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #3180;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3181;4
#I  Order: 2^8
#I  Nuclear rank: 5
#I  2-multiplicator rank: 11
#I  Group [grp] #3181;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3182;4
#I  Order: 2^8
#I  Nuclear rank: 5
#I  2-multiplicator rank: 11
#I  Group [grp] #3182;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3183;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #3183;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3184;4
#I  Order: 2^8
#I  Nuclear rank: 5
#I  2-multiplicator rank: 11
#I  Group [grp] #3184;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3185;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #3185;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3186;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #3186;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3187;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #3187;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3188;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #3188;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3189;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #3189;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3190;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #3190;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3191;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #3191;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3192;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #3192;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3193;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #3193;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3194;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #3194;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3195;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #3195;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3196;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #3196;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3197;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #3197;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3198;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #3198;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3199;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #3199;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3200;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #3200;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3201;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #3201;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3202;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #3202;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3203;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #3203;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3204;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #3204;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3205;4
#I  Order: 2^8
#I  Nuclear rank: 5
#I  2-multiplicator rank: 11
#I  Group [grp] #3205;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3206;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #3206;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3207;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #3207;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3208;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #3208;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3209;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #3209;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3210;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #3210;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3211;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #3211;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3212;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #3212;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3213;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #3213;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3214;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #3214;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3215;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #3215;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3216;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #3216;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3217;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #3217;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3218;4
#I  Order: 2^8
#I  Nuclear rank: 5
#I  2-multiplicator rank: 11
#I  Group [grp] #3218;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3219;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #3219;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3220;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #3220;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3221;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #3221;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3222;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #3222;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3223;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #3223;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3224;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #3224;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3225;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #3225;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3226;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #3226;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3227;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #3227;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3228;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #3228;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3229;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #3229;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3230;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #3230;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3231;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #3231;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3232;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #3232;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3233;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #3233;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3234;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #3234;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3235;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #3235;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3236;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #3236;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3237;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #3237;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3238;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #3238;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3239;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #3239;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3240;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #3240;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3241;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #3241;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3242;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #3242;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3243;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #3243;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3244;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #3244;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3245;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #3245;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3246;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #3246;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3247;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #3247;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3248;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #3248;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3249;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #3249;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3250;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #3250;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3251;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #3251;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3252;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #3252;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3253;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #3253;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3254;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #3254;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3255;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #3255;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3256;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #3256;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3257;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #3257;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3258;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #3258;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3259;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #3259;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3260;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #3260;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3261;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #3261;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3262;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #3262;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3263;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #3263;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3264;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #3264;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3265;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #3265;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3266;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #3266;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3267;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #3267;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3268;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #3268;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3269;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #3269;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3270;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #3270;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3271;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #3271;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3272;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #3272;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3273;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #3273;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3274;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #3274;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3275;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #3275;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3276;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #3276;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3277;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #3277;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3278;4
#I  Order: 2^8
#I  Nuclear rank: 5
#I  2-multiplicator rank: 11
#I  Group [grp] #3278;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3279;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #3279;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3280;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #3280;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3281;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #3281;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3282;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #3282;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3283;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #3283;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3284;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #3284;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3285;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #3285;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3286;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #3286;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3287;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #3287;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3288;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #3288;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3289;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #3289;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3290;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #3290;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3291;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #3291;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3292;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #3292;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3293;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #3293;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3294;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #3294;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3295;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #3295;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3296;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #3296;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3297;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #3297;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3298;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #3298;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3299;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #3299;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3300;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #3300;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3301;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #3301;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3302;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #3302;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3303;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #3303;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3304;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #3304;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3305;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #3305;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3306;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #3306;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3307;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #3307;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3308;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #3308;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3309;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #3309;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3310;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #3310;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3311;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #3311;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3312;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #3312;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3313;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #3313;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3314;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #3314;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3315;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #3315;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3316;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #3316;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3317;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #3317;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3318;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #3318;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3319;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #3319;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3320;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #3320;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3321;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #3321;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3322;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #3322;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3323;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #3323;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3324;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #3324;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3325;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #3325;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3326;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #3326;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3327;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #3327;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3328;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #3328;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3329;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #3329;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3330;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #3330;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3331;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #3331;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3332;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #3332;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3333;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #3333;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3334;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #3334;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3335;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #3335;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3336;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #3336;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3337;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #3337;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3338;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #3338;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3339;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #3339;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3340;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #3340;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3341;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #3341;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3342;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #3342;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3343;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #3343;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3344;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #3344;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3345;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #3345;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3346;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #3346;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3347;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #3347;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3348;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #3348;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3349;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #3349;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3350;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #3350;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3351;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #3351;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3352;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #3352;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3353;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #3353;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3354;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #3354;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3355;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #3355;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3356;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #3356;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3357;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #3357;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3358;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #3358;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3359;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #3359;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3360;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #3360;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3361;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #3361;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3362;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #3362;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3363;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #3363;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3364;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #3364;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3365;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #3365;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3366;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #3366;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3367;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #3367;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3368;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #3368;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3369;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #3369;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3370;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #3370;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3371;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #3371;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3372;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #3372;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3373;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #3373;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3374;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #3374;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3375;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #3375;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3376;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #3376;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3377;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #3377;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3378;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #3378;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3379;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #3379;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3380;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #3380;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3381;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #3381;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3382;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #3382;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3383;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #3383;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3384;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #3384;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3385;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #3385;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3386;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #3386;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3387;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #3387;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3388;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #3388;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3389;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #3389;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3390;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #3390;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3391;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #3391;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3392;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #3392;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3393;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #3393;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3394;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #3394;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3395;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #3395;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3396;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #3396;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3397;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #3397;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3398;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #3398;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3399;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #3399;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3400;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #3400;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3401;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #3401;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3402;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #3402;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3403;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #3403;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3404;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #3404;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3405;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #3405;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3406;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #3406;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3407;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #3407;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3408;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #3408;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3409;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #3409;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3410;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #3410;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3411;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #3411;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3412;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #3412;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3413;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #3413;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3414;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #3414;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3415;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #3415;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3416;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #3416;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3417;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #3417;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3418;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #3418;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3419;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #3419;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3420;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #3420;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3421;4
#I  Order: 2^8
#I  Nuclear rank: 5
#I  2-multiplicator rank: 11
#I  Group [grp] #3421;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3422;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #3422;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3423;4
#I  Order: 2^8
#I  Nuclear rank: 5
#I  2-multiplicator rank: 11
#I  Group [grp] #3423;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3424;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #3424;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3425;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #3425;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3426;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #3426;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3427;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #3427;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3428;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #3428;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3429;4
#I  Order: 2^8
#I  Nuclear rank: 5
#I  2-multiplicator rank: 11
#I  Group [grp] #3429;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3430;4
#I  Order: 2^8
#I  Nuclear rank: 5
#I  2-multiplicator rank: 11
#I  Group [grp] #3430;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3431;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #3431;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3432;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #3432;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3433;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #3433;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3434;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #3434;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3435;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #3435;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3436;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #3436;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3437;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #3437;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3438;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #3438;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3439;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #3439;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3440;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #3440;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3441;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #3441;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3442;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #3442;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3443;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #3443;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3444;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #3444;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3445;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #3445;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3446;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #3446;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3447;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #3447;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3448;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #3448;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3449;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #3449;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3450;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #3450;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3451;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #3451;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3452;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #3452;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3453;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #3453;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3454;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #3454;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3455;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #3455;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3456;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #3456;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3457;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #3457;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3458;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #3458;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3459;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #3459;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3460;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #3460;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3461;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #3461;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3462;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #3462;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3463;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #3463;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3464;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #3464;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3465;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #3465;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3466;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #3466;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3467;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #3467;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3468;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #3468;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3469;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #3469;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3470;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #3470;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3471;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #3471;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3472;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #3472;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3473;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #3473;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3474;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #3474;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3475;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #3475;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3476;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #3476;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3477;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #3477;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3478;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #3478;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3479;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #3479;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3480;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #3480;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3481;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #3481;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3482;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #3482;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3483;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #3483;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3484;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #3484;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3485;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #3485;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3486;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #3486;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3487;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #3487;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3488;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #3488;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3489;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #3489;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3490;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #3490;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3491;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #3491;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3492;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #3492;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3493;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #3493;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3494;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #3494;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3495;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #3495;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3496;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #3496;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3497;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #3497;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3498;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #3498;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3499;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #3499;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3500;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #3500;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3501;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #3501;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3502;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #3502;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3503;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #3503;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3504;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #3504;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3505;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #3505;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3506;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #3506;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3507;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #3507;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3508;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #3508;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3509;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #3509;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3510;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #3510;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3511;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #3511;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3512;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #3512;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3513;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #3513;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3514;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #3514;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3515;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #3515;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3516;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #3516;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3517;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #3517;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3518;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #3518;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3519;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #3519;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3520;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #3520;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3521;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #3521;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3522;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #3522;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3523;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #3523;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3524;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #3524;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3525;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #3525;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3526;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #3526;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3527;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #3527;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3528;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #3528;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3529;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #3529;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3530;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #3530;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3531;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #3531;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3532;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #3532;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3533;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #3533;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3534;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #3534;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3535;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #3535;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3536;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #3536;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3537;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #3537;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3538;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #3538;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3539;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #3539;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3540;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #3540;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3541;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #3541;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3542;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #3542;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3543;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #3543;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3544;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #3544;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3545;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #3545;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3546;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #3546;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3547;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #3547;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3548;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #3548;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3549;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #3549;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3550;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #3550;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3551;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #3551;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3552;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #3552;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3553;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #3553;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3554;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #3554;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3555;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #3555;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3556;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #3556;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3557;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #3557;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3558;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #3558;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3559;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #3559;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3560;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #3560;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3561;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #3561;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3562;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #3562;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3563;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #3563;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3564;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #3564;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3565;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #3565;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3566;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #3566;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3567;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #3567;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3568;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #3568;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3569;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #3569;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3570;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #3570;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3571;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #3571;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3572;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #3572;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3573;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #3573;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3574;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #3574;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3575;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #3575;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3576;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #3576;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3577;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #3577;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3578;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #3578;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3579;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #3579;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3580;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #3580;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3581;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #3581;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3582;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #3582;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3583;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #3583;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3584;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #3584;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3585;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #3585;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3586;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #3586;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3587;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #3587;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3588;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #3588;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3589;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #3589;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3590;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #3590;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3591;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #3591;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3592;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #3592;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3593;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #3593;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3594;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #3594;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3595;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #3595;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3596;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #3596;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3597;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #3597;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3598;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #3598;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3599;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #3599;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3600;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #3600;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3601;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #3601;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3602;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #3602;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3603;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #3603;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3604;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #3604;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3605;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #3605;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3606;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #3606;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3607;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #3607;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3608;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #3608;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3609;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #3609;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3610;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #3610;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3611;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #3611;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3612;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #3612;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3613;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #3613;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3614;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #3614;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3615;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #3615;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3616;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #3616;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3617;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #3617;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3618;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #3618;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3619;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #3619;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3620;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #3620;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3621;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #3621;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3622;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #3622;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3623;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #3623;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3624;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #3624;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3625;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #3625;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3626;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #3626;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3627;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #3627;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3628;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #3628;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3629;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #3629;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3630;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #3630;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3631;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #3631;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3632;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #3632;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3637;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #3637;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3638;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #3638;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3639;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #3639;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3640;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #3640;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3641;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #3641;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3643;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #3643;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3644;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #3644;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3646;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #3646;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3647;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #3647;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3648;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #3648;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3649;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #3649;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3650;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #3650;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3651;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #3651;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3652;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #3652;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3653;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #3653;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3654;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #3654;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3655;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #3655;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3656;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #3656;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3657;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #3657;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3658;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #3658;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3659;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #3659;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3660;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #3660;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3662;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #3662;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3663;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #3663;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3664;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #3664;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3665;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #3665;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3666;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #3666;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3667;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #3667;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3668;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #3668;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3669;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #3669;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3670;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #3670;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3671;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #3671;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3672;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #3672;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3673;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #3673;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3674;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #3674;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3675;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #3675;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3676;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #3676;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3677;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #3677;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3679;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #3679;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3680;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #3680;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3681;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #3681;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3682;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #3682;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3683;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #3683;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3684;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #3684;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3685;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #3685;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3686;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #3686;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3687;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #3687;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3688;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #3688;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3689;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #3689;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3690;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #3690;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3692;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #3692;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3693;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #3693;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3694;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #3694;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3695;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #3695;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3697;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #3697;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3699;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #3699;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3700;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #3700;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3701;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #3701;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3702;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #3702;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3703;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #3703;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3706;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #3706;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3707;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #3707;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3708;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #3708;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3709;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #3709;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3710;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #3710;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3711;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #3711;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3712;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #3712;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3713;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #3713;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3714;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #3714;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3715;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #3715;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3716;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #3716;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3717;4
#I  Order: 2^8
#I  Nuclear rank: 1
#I  2-multiplicator rank: 7
#I  Group [grp] #3717;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3718;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #3718;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3719;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #3719;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3720;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #3720;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3721;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #3721;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3722;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #3722;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3723;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #3723;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3724;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #3724;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3725;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #3725;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3726;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #3726;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3727;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #3727;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3728;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #3728;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3729;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #3729;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3730;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #3730;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3731;4
#I  Order: 2^8
#I  Nuclear rank: 4
#I  2-multiplicator rank: 10
#I  Group [grp] #3731;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3732;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #3732;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3733;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #3733;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3734;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  Group [grp] #3734;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3735;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #3735;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3736;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #3736;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3737;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #3737;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3738;4
#I  Order: 2^8
#I  Nuclear rank: 3
#I  2-multiplicator rank: 9
#I  Group [grp] #3738;4 is an invalid starting group
#I  **************************************************
#I  Starting group: [grp] #3739;4
#I  Order: 2^8
#I  Nuclear rank: 2
#I  2-multiplicator rank: 8
#I  G