/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.plugin.script;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Properties;
import java.util.stream.Stream;
import org.apache.commons.io.FileUtils;
import org.freeplane.core.util.LogUtils;
import org.freeplane.plugin.script.ScriptResources;

class CompiledScriptCleaner {
    CompiledScriptCleaner() {
    }

    private long calculateLastDependencyModificationTime() {
        long lastModificationTime = ScriptResources.getClasspath().stream().map(File::new).mapToLong(this::calculateLastDependencyModificationTime).reduce(0L, Long::max);
        return lastModificationTime;
    }

    private long calculateLastDependencyModificationTime(File f) {
        long lastModificationTime;
        if (f.isDirectory()) {
            try {
                lastModificationTime = Files.walk(Paths.get(f.toURI()), FileVisitOption.FOLLOW_LINKS).filter(path -> path.getFileName().toString().endsWith(".class")).map(Path::toFile).mapToLong(File::lastModified).reduce(0L, Long::max);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        } else {
            lastModificationTime = f.getName().endsWith(".jar") ? f.lastModified() : 0L;
        }
        return lastModificationTime;
    }

    void removeOutdatedCompiledScripts(boolean compileOnlyChangedScriptFiles) {
        File compiledScriptsDir = ScriptResources.getCompiledScriptsDir();
        if (compileOnlyChangedScriptFiles) {
            File[] cacheDirectories = compiledScriptsDir.listFiles();
            if (cacheDirectories != null) {
                long lastDependencyModificationTime = this.calculateLastDependencyModificationTime();
                Stream.of(cacheDirectories).forEach(cache -> this.removeOutdated((File)cache, lastDependencyModificationTime));
            }
        } else {
            try {
                FileUtils.deleteDirectory((File)compiledScriptsDir);
            }
            catch (IOException e) {
                LogUtils.warn((Throwable)e);
            }
        }
    }

    private void removeOutdated(File cache, long lastDependencyModificationTime) {
        File propertyFile = new File(cache, "compiled.properties");
        if (propertyFile.exists()) {
            Properties properties = new Properties();
            try (FileInputStream in = new FileInputStream(propertyFile);){
                properties.load(in);
            }
            catch (IOException e) {
                LogUtils.warn((Throwable)e);
                return;
            }
            try {
                long compileTime = Long.parseLong(properties.getProperty("time"));
                String source = properties.getProperty("source");
                File sourceFile = new File(source);
                if (!sourceFile.canRead() || lastDependencyModificationTime >= compileTime || sourceFile.lastModified() >= compileTime) {
                    FileUtils.deleteDirectory((File)cache);
                }
            }
            catch (IOException | NumberFormatException e) {
                LogUtils.warn((Throwable)e);
                return;
            }
        }
    }
}

