/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.rtf.rtflib.rtfdoc;

import java.io.IOException;
import java.io.Writer;
import org.apache.fop.render.rtf.rtflib.rtfdoc.IBorderAttributes;
import org.apache.fop.render.rtf.rtflib.rtfdoc.IRtfExternalGraphicContainer;
import org.apache.fop.render.rtf.rtflib.rtfdoc.IRtfListContainer;
import org.apache.fop.render.rtf.rtflib.rtfdoc.IRtfParagraphContainer;
import org.apache.fop.render.rtf.rtflib.rtfdoc.IRtfTableContainer;
import org.apache.fop.render.rtf.rtflib.rtfdoc.IRtfTextrunContainer;
import org.apache.fop.render.rtf.rtflib.rtfdoc.ITableAttributes;
import org.apache.fop.render.rtf.rtflib.rtfdoc.ITableColumnsInfo;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfAttributes;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfContainer;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfElement;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfExternalGraphic;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfList;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfParagraph;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfParagraphBreak;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfTable;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfTableRow;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfTextrun;

public class RtfTableCell
extends RtfContainer
implements IRtfParagraphContainer,
IRtfListContainer,
IRtfTableContainer,
IRtfExternalGraphicContainer,
IRtfTextrunContainer {
    private RtfParagraph paragraph;
    private RtfList list;
    private RtfTable table;
    private RtfExternalGraphic externalGraphic;
    private final RtfTableRow parentRow;
    private boolean setCenter;
    private boolean setRight;
    private int id;
    private RtfParagraphBreak lastBreak;
    private static final String TABLE_CELL_PARAGRAPH = "cell";
    private static final String TABLE_CELL_NESTED_PARAGRAPH = "nestcell";
    public static final int DEFAULT_CELL_WIDTH = 2000;
    private int cellWidth;
    private int widthOffset;
    private int vMerge = 0;
    private int hMerge = 0;
    public static final int NO_MERGE = 0;
    public static final int MERGE_START = 1;
    public static final int MERGE_WITH_PREVIOUS = 2;

    RtfTableCell(RtfTableRow parent, Writer w, int cellWidth, int idNum) throws IOException {
        super(parent, w);
        this.id = idNum;
        this.parentRow = parent;
        this.cellWidth = cellWidth;
        this.setCenter = false;
        this.setRight = false;
    }

    RtfTableCell(RtfTableRow parent, Writer w, int cellWidth, RtfAttributes attrs, int idNum) throws IOException {
        super(parent, w, attrs);
        this.id = idNum;
        this.parentRow = parent;
        this.cellWidth = cellWidth;
    }

    @Override
    public RtfParagraph newParagraph(RtfAttributes attrs) throws IOException {
        this.closeAll();
        if (attrs == null) {
            attrs = new RtfAttributes();
        }
        attrs.set("intbl");
        this.paragraph = new RtfParagraph(this, this.writer, attrs);
        if (this.paragraph.attrib.isSet("qc")) {
            this.setCenter = true;
            attrs.set("qc");
        } else if (this.paragraph.attrib.isSet("qr")) {
            this.setRight = true;
            attrs.set("qr");
        } else {
            attrs.set("ql");
        }
        attrs.set("intbl");
        return this.paragraph;
    }

    @Override
    public RtfExternalGraphic newImage() throws IOException {
        this.closeAll();
        this.externalGraphic = new RtfExternalGraphic(this, this.writer);
        return this.externalGraphic;
    }

    @Override
    public RtfParagraph newParagraph() throws IOException {
        return this.newParagraph(null);
    }

    @Override
    public RtfList newList(RtfAttributes attrib) throws IOException {
        this.closeAll();
        this.list = new RtfList(this, this.writer, attrib);
        return this.list;
    }

    @Override
    public RtfTable newTable(ITableColumnsInfo tc) throws IOException {
        this.closeAll();
        this.table = new RtfTable(this, this.writer, tc);
        return this.table;
    }

    @Override
    public RtfTable newTable(RtfAttributes attrs, ITableColumnsInfo tc) throws IOException {
        this.closeAll();
        this.table = new RtfTable(this, this.writer, attrs, tc);
        return this.table;
    }

    int writeCellDef(int offset) throws IOException {
        if (this.hMerge == 2) {
            return offset;
        }
        this.newLine();
        this.widthOffset = offset;
        if (this.vMerge == 1) {
            this.writeControlWord("clvmgf");
        } else if (this.vMerge == 2) {
            this.writeControlWord("clvmrg");
        }
        this.writeAttributes(this.attrib, ITableAttributes.CELL_COLOR);
        this.writeAttributes(this.attrib, ITableAttributes.ATTRIB_CELL_PADDING);
        this.writeAttributes(this.attrib, ITableAttributes.CELL_BORDER);
        this.writeAttributes(this.attrib, IBorderAttributes.BORDERS);
        int iCurrentWidth = this.cellWidth;
        if (this.attrib.getValue("number-columns-spanned") != null) {
            int nbMergedCells = (Integer)this.attrib.getValue("number-columns-spanned");
            RtfTable tab = this.getRow().getTable();
            ITableColumnsInfo tableColumnsInfo = tab.getITableColumnsInfo();
            tableColumnsInfo.selectFirstColumn();
            while (this.id - 1 != tableColumnsInfo.getColumnIndex()) {
                tableColumnsInfo.selectNextColumn();
            }
            for (int i = nbMergedCells - 1; i > 0; --i) {
                tableColumnsInfo.selectNextColumn();
                iCurrentWidth += (int)tableColumnsInfo.getColumnWidth();
            }
            if (this.getRow().isHighestCell(this.id + nbMergedCells - 1)) {
                this.writeAttributes(this.getRow().getTable().getBorderAttributes(), new String[]{"clbrdrr"});
            }
        }
        int xPos = offset + iCurrentWidth;
        if (this.setCenter) {
            this.writeControlWord("trqc");
        } else if (this.setRight) {
            this.writeControlWord("trqr");
        } else {
            this.writeControlWord("trql");
        }
        this.writeAttributes(this.attrib, ITableAttributes.CELL_VERT_ALIGN);
        this.writeControlWord("cellx" + xPos);
        return xPos;
    }

    @Override
    protected void writeRtfContent() throws IOException {
        if (this.hMerge == 2) {
            return;
        }
        super.writeRtfContent();
    }

    @Override
    protected void writeRtfPrefix() throws IOException {
        if (this.hMerge == 2) {
            return;
        }
        super.writeRtfPrefix();
    }

    @Override
    protected void writeRtfSuffix() throws IOException {
        if (this.hMerge == 2) {
            return;
        }
        if (this.getRow().getTable().isNestedTable()) {
            if (this.lastBreak == null) {
                this.writeControlWordNS(TABLE_CELL_NESTED_PARAGRAPH);
            }
            this.writeGroupMark(true);
            this.writeControlWord("nonesttables");
            this.writeControlWord("par");
            this.writeGroupMark(false);
        } else {
            if (this.setCenter) {
                this.writeControlWord("qc");
            } else if (this.setRight) {
                this.writeControlWord("qr");
            } else {
                RtfElement lastChild = null;
                if (this.getChildren().size() > 0) {
                    lastChild = (RtfElement)this.getChildren().get(this.getChildren().size() - 1);
                }
                if (lastChild == null || !(lastChild instanceof RtfTextrun)) {
                    this.writeControlWord("ql");
                }
            }
            if (!this.containsText()) {
                this.writeControlWord("intbl");
            }
            if (this.lastBreak == null) {
                this.writeControlWord(TABLE_CELL_PARAGRAPH);
            }
        }
    }

    private void closeCurrentParagraph() throws IOException {
        if (this.paragraph != null) {
            this.paragraph.close();
        }
    }

    private void closeCurrentList() throws IOException {
        if (this.list != null) {
            this.list.close();
        }
    }

    private void closeCurrentTable() throws IOException {
        if (this.table != null) {
            this.table.close();
        }
    }

    private void closeCurrentExternalGraphic() throws IOException {
        if (this.externalGraphic != null) {
            this.externalGraphic.close();
        }
    }

    private void closeAll() throws IOException {
        this.closeCurrentTable();
        this.closeCurrentParagraph();
        this.closeCurrentList();
        this.closeCurrentExternalGraphic();
    }

    public void setVMerge(int mergeStatus) {
        this.vMerge = mergeStatus;
    }

    public int getVMerge() {
        return this.vMerge;
    }

    public void setHMerge(int mergeStatus) {
        this.hMerge = mergeStatus;
    }

    public int getHMerge() {
        return this.hMerge;
    }

    int getCellWidth() {
        return this.cellWidth;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    boolean paragraphNeedsPar(RtfParagraph p) {
        boolean pFound = false;
        boolean result = false;
        for (Object o : this.getChildren()) {
            if (!pFound) {
                pFound = o == p;
                continue;
            }
            if (o instanceof RtfParagraph) {
                RtfParagraph p2 = (RtfParagraph)o;
                if (p2.isEmpty()) continue;
                result = true;
                break;
            }
            if (!(o instanceof RtfTable)) continue;
            break;
        }
        return result;
    }

    @Override
    public RtfTextrun getTextrun() throws IOException {
        RtfAttributes attrs = new RtfAttributes();
        if (!this.getRow().getTable().isNestedTable()) {
            attrs.set("intbl");
        }
        RtfTextrun textrun = RtfTextrun.getTextrun(this, this.writer, attrs);
        textrun.setSuppressLastPar(true);
        return textrun;
    }

    public RtfTableRow getRow() {
        RtfContainer e = this;
        while (e.parent != null) {
            if (e.parent instanceof RtfTableRow) {
                return (RtfTableRow)e.parent;
            }
            e = e.parent;
        }
        return null;
    }

    public void setLastParagraph(RtfParagraphBreak parBreak) {
        if (parBreak != null) {
            this.lastBreak = parBreak;
        }
    }

    public void finish() {
        if (this.getRow().getTable().isNestedTable() && this.table != null) {
            this.lastBreak = null;
        } else if (this.lastBreak != null) {
            this.lastBreak.switchControlWord(this.getRow().getTable().isNestedTable() ? TABLE_CELL_NESTED_PARAGRAPH : TABLE_CELL_PARAGRAPH);
        }
    }
}

