/*
 * Decompiled with CFR 0.152.
 */
package net.infonode.gui.layout;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.awt.Point;
import java.awt.Rectangle;
import net.infonode.gui.layout.LayoutUtil;

public class BorderLayout2
implements LayoutManager2 {
    private Component[][] components = new Component[3][];

    public BorderLayout2() {
        int i = 0;
        while (i < this.components.length) {
            this.components[i] = new Component[3];
            ++i;
        }
    }

    @Override
    public void addLayoutComponent(String name, Component comp) {
    }

    @Override
    public void addLayoutComponent(Component comp, Object constraints) {
        if (!(constraints instanceof Point)) {
            throw new RuntimeException("BorderLayout2 constraint must be a Point!");
        }
        Point p = (Point)constraints;
        this.components[p.x][p.y] = comp;
    }

    @Override
    public float getLayoutAlignmentX(Container target) {
        return target.getAlignmentX();
    }

    @Override
    public float getLayoutAlignmentY(Container target) {
        return target.getAlignmentY();
    }

    @Override
    public void invalidateLayout(Container target) {
    }

    @Override
    public Dimension maximumLayoutSize(Container target) {
        int width = 0;
        int height = 0;
        int i = 0;
        while (i < 3) {
            width += this.getMaximumWidth(i);
            height += this.getMaximumHeight(i);
            ++i;
        }
        return new Dimension(width, height);
    }

    private int getPreferredHeight(int row) {
        int maxHeight = 0;
        int i = 0;
        while (i < 3) {
            int height;
            Component c = this.components[i][row];
            if (c != null && c.isVisible() && (height = c.getPreferredSize().height) > maxHeight) {
                maxHeight = height;
            }
            ++i;
        }
        return maxHeight;
    }

    private int getPreferredWidth(int column) {
        int maxWidth = 0;
        int i = 0;
        while (i < 3) {
            int width;
            Component c = this.components[column][i];
            if (c != null && c.isVisible() && (width = c.getPreferredSize().width) > maxWidth) {
                maxWidth = width;
            }
            ++i;
        }
        return maxWidth;
    }

    private int getMinimumHeight(int row) {
        int maxHeight = 0;
        int i = 0;
        while (i < 3) {
            int height;
            Component c = this.components[i][row];
            if (c != null && c.isVisible() && (height = c.getMinimumSize().height) > maxHeight) {
                maxHeight = height;
            }
            ++i;
        }
        return maxHeight;
    }

    private int getMinimumWidth(int column) {
        int maxWidth = 0;
        int i = 0;
        while (i < 3) {
            int width;
            Component c = this.components[column][i];
            if (c != null && c.isVisible() && (width = c.getMinimumSize().width) > maxWidth) {
                maxWidth = width;
            }
            ++i;
        }
        return maxWidth;
    }

    private int getMaximumHeight(int row) {
        int minHeight = Integer.MAX_VALUE;
        int i = 0;
        while (i < 3) {
            int height;
            Component c = this.components[i][row];
            if (c != null && c.isVisible() && (height = c.getMaximumSize().height) < minHeight) {
                minHeight = height;
            }
            ++i;
        }
        return minHeight;
    }

    private int getMaximumWidth(int column) {
        int minWidth = 0;
        int i = 0;
        while (i < 3) {
            int width;
            Component c = this.components[column][i];
            if (c != null && c.isVisible() && (width = c.getMaximumSize().width) < minWidth) {
                minWidth = width;
            }
            ++i;
        }
        return minWidth;
    }

    private static void setBounds(Component component, Rectangle bounds) {
        int width = Math.min(component.getMaximumSize().width, bounds.width);
        int height = Math.min(component.getMaximumSize().height, bounds.height);
        Rectangle r = new Rectangle(bounds.x + (int)(component.getAlignmentX() * (float)(bounds.width - width)), bounds.y + (int)(component.getAlignmentY() * (float)(bounds.height - height)), width, height);
        component.setBounds(r);
    }

    @Override
    public void layoutContainer(Container parent) {
        Insets insets = parent.getInsets();
        Dimension innerSize = LayoutUtil.getInteriorSize(parent);
        int[] w = new int[]{this.getPreferredWidth(0), this.getPreferredWidth(2)};
        int[] h = new int[]{this.getPreferredHeight(0), this.getPreferredHeight(2)};
        int y = insets.top;
        int row = 0;
        while (row < 3) {
            int height = row == 1 ? innerSize.height - h[0] - h[1] : h[row / 2];
            int x = insets.left;
            int col = 0;
            while (col < 3) {
                int width = col == 1 ? innerSize.width - w[0] - w[1] : w[col / 2];
                Component c = this.components[col][row];
                if (c != null && c.isVisible()) {
                    BorderLayout2.setBounds(c, new Rectangle(x, y, width, height));
                }
                x += width;
                ++col;
            }
            y += height;
            ++row;
        }
    }

    @Override
    public Dimension minimumLayoutSize(Container parent) {
        int width = 0;
        int height = 0;
        int i = 0;
        while (i < 3) {
            width += this.getMinimumWidth(i);
            height += this.getMinimumHeight(i);
            ++i;
        }
        return new Dimension(width, height);
    }

    @Override
    public Dimension preferredLayoutSize(Container parent) {
        int width = 0;
        int height = 0;
        int i = 0;
        while (i < 3) {
            width += this.getPreferredWidth(i);
            height += this.getPreferredHeight(i);
            ++i;
        }
        return new Dimension(width, height);
    }

    @Override
    public void removeLayoutComponent(Component comp) {
        int col = 0;
        while (col < 3) {
            int row = 0;
            while (row < 3) {
                if (this.components[col][row] == comp) {
                    this.components[col][row] = null;
                    return;
                }
                ++row;
            }
            ++col;
        }
    }
}

