/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.core.util;

import com.lightdev.app.shtm.SHTMLWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilterWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.StyleConstants;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.Option;
import org.freeplane.core.util.LogUtils;

class XHTMLWriter
extends SHTMLWriter {
    private static final char NB_SPACE = '\u00a0';
    static final String NB_SPACE_LITERAL = "&#xa0;";
    private boolean writeLineSeparatorEnabled = true;
    private boolean shouldEndElementNow;

    public static void html2xhtml(Reader reader, Writer writer) throws IOException, BadLocationException {
        HTMLEditorKit kit = new HTMLEditorKit();
        Document doc = kit.createDefaultDocument();
        kit.read(reader, doc, doc.getLength());
        XHTMLWriter xhw = new XHTMLWriter(writer, (HTMLDocument)doc);
        xhw.write();
    }

    public static void main(String[] args) {
        try (FileReader reader = new FileReader(args[0]);
             FileWriter writer = new FileWriter(args[1]);){
            XHTMLWriter.html2xhtml(reader, writer);
        }
        catch (Exception e) {
            LogUtils.severe(e);
        }
    }

    public XHTMLWriter(Writer writer, HTMLDocument doc) {
        super(writer, doc);
        this.setLineLength(Integer.MAX_VALUE);
    }

    public XHTMLWriter(Writer writer, HTMLDocument doc, int pos, int len) {
        super((Writer)new XHTMLFilterWriter(writer), doc, pos, len);
        this.setLineLength(Integer.MAX_VALUE);
    }

    public void write() throws IOException, BadLocationException {
        super.write();
    }

    protected void writeLineSeparator() throws IOException {
        if (this.writeLineSeparatorEnabled) {
            super.writeLineSeparator();
        }
    }

    protected void writeOption(Option option) throws IOException {
        this.writeLineSeparatorEnabled = false;
        super.writeOption(option);
        this.writeLineSeparatorEnabled = true;
        this.write("</option>");
        this.writeLineSeparator();
    }

    protected void writeAttributes(AttributeSet attributeSet) throws IOException {
        Object endTag;
        Object nameTag = attributeSet != null ? attributeSet.getAttribute(StyleConstants.NameAttribute) : null;
        Object object = endTag = attributeSet != null ? attributeSet.getAttribute(HTML.Attribute.ENDTAG) : null;
        if (nameTag != null && endTag != null && endTag instanceof String && ((String)endTag).equals("true")) {
            return;
        }
        super.writeAttributes(attributeSet);
        if (this.shouldEndElementNow) {
            this.write('/');
        }
    }

    protected void output(char[] chars, int start, int length) throws IOException {
        for (int i = start; i < start + length; ++i) {
            char c = chars[i];
            if (c >= ' ' || c == '\r' || c == '\n' || c == '\t') continue;
            chars[i] = 32;
        }
        super.output(chars, start, length);
    }

    protected String entity(char c) {
        if (c == '\u00a0') {
            return NB_SPACE_LITERAL;
        }
        return super.entity(c);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void emptyTag(Element elem) throws BadLocationException, IOException {
        try {
            boolean isEndtag = this.isEndtag(elem);
            int balance = this.balance(elem, isEndtag);
            if (balance == 0 || balance > 0 && isEndtag || balance < 0 && !isEndtag) {
                super.emptyTag(elem);
                return;
            }
            if (isEndtag) {
                this.write('<');
                this.write(elem.getName());
                this.write('/');
                this.write('>');
                return;
            }
            this.shouldEndElementNow = true;
            super.emptyTag(elem);
        }
        finally {
            this.shouldEndElementNow = false;
        }
    }

    private int balance(Element elem, boolean isEndtag) {
        Element parentElement = elem.getParentElement();
        int elementCount = parentElement.getElementCount();
        int balance = 0;
        String elemName = elem.getName();
        for (int i = 0; i < elementCount; ++i) {
            Element childElement = parentElement.getElement(i);
            if (isEndtag) {
                if (childElement == elem) {
                    --balance;
                    break;
                }
            } else {
                if (childElement == elem) {
                    balance = 1;
                    continue;
                }
                if (balance == 0) continue;
            }
            if (!elemName.equals(childElement.getName())) continue;
            if (this.isEndtag(childElement)) {
                if (balance <= 0) continue;
                --balance;
                continue;
            }
            ++balance;
        }
        return balance;
    }

    private boolean isEndtag(Element elem) {
        AttributeSet attributes = elem.getAttributes();
        Object endTag = attributes.getAttribute(HTML.Attribute.ENDTAG);
        boolean isEndtag = endTag instanceof String && ((String)endTag).equals("true");
        return isEndtag;
    }

    protected void closeOutUnwantedEmbeddedTags(AttributeSet attr) throws IOException {
        boolean insideEmptyTag = this.shouldEndElementNow;
        this.shouldEndElementNow = false;
        try {
            super.closeOutUnwantedEmbeddedTags(attr);
        }
        finally {
            this.shouldEndElementNow = insideEmptyTag;
        }
    }

    protected void writeEmbeddedTags(AttributeSet attr) throws IOException {
        boolean insideEmptyTag = this.shouldEndElementNow;
        this.shouldEndElementNow = false;
        try {
            super.writeEmbeddedTags(attr);
        }
        finally {
            this.shouldEndElementNow = insideEmptyTag;
        }
    }

    public static class XHTMLFilterWriter
    extends FilterWriter {
        private boolean insideTag = false;
        private boolean insideValue = false;

        public XHTMLFilterWriter(Writer writer) {
            super(writer);
        }

        @Override
        public void write(char[] cbuf, int off, int len) throws IOException {
            while (len-- > 0) {
                this.write(cbuf[off++]);
            }
        }

        @Override
        public void write(int c) throws IOException {
            if (this.insideValue) {
                if (c == 38) {
                    super.write("&amp;", 0, 5);
                    return;
                }
                if (c == 60) {
                    super.write("&lt;", 0, 4);
                    return;
                }
                if (c == 62) {
                    super.write("&gt;", 0, 4);
                    return;
                }
                if (c == 34) {
                    this.insideValue = false;
                }
            } else if (this.insideTag) {
                if (c == 34) {
                    this.insideValue = true;
                } else if (c == 62) {
                    this.insideTag = false;
                }
            } else if (c == 60) {
                this.insideTag = true;
            }
            super.write(c);
        }

        @Override
        public void write(String str, int off, int len) throws IOException {
            this.write(str.toCharArray(), off, len);
        }
    }
}

